/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.transformer;

import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.FabricLoaderImpl;
import net.fabricmc.loader.game.MinecraftGameProvider;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.transformer.ClassStripper;
import net.fabricmc.loader.transformer.EnvironmentStrippingData;
import net.fabricmc.loader.transformer.PackageAccessFixer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class FabricTransformer {
    public static byte[] lwTransformerHook(String name, String transformedName, byte[] bytes) {
        boolean isDevelopment = FabricLauncherBase.getLauncher().isDevelopment();
        EnvType envType = FabricLauncherBase.getLauncher().getEnvironmentType();
        byte[] input = MinecraftGameProvider.TRANSFORMER.transform(name);
        if (input != null) {
            return FabricTransformer.transform(isDevelopment, envType, name, input);
        }
        if (bytes != null) {
            return FabricTransformer.transform(isDevelopment, envType, name, bytes);
        }
        return null;
    }

    public static byte[] transform(boolean isDevelopment, EnvType envType, String name, byte[] bytes) {
        ClassWriter classWriter;
        boolean applyAccessWidener;
        boolean isMinecraftClass = name.startsWith("net.minecraft.") || name.indexOf(46) < 0;
        boolean transformAccess = isMinecraftClass && FabricLauncherBase.getLauncher().getMappingConfiguration().requiresPackageAccessHack();
        boolean environmentStrip = !isMinecraftClass || isDevelopment;
        boolean bl = applyAccessWidener = isMinecraftClass && FabricLoaderImpl.getInstance().getAccessWidener().getTargets().contains(name);
        if (!(transformAccess || environmentStrip || applyAccessWidener)) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        Object visitor = classWriter = new ClassWriter(0);
        int visitorCount = 0;
        if (applyAccessWidener) {
            visitor = AccessWidenerVisitor.createClassVisitor((int)589824, (ClassVisitor)visitor, (AccessWidener)FabricLoaderImpl.getInstance().getAccessWidener());
            ++visitorCount;
        }
        if (transformAccess) {
            visitor = new PackageAccessFixer(589824, (ClassVisitor)visitor);
            ++visitorCount;
        }
        if (environmentStrip) {
            EnvironmentStrippingData stripData = new EnvironmentStrippingData(589824, envType.toString());
            classReader.accept((ClassVisitor)stripData, 5);
            if (stripData.stripEntireClass()) {
                throw new RuntimeException("Cannot load class " + name + " in environment type " + (Object)((Object)envType));
            }
            if (!stripData.isEmpty()) {
                visitor = new ClassStripper(589824, (ClassVisitor)visitor, stripData.getStripInterfaces(), stripData.getStripFields(), stripData.getStripMethods());
                ++visitorCount;
            }
        }
        if (visitorCount <= 0) {
            return bytes;
        }
        classReader.accept((ClassVisitor)visitor, 0);
        return classWriter.toByteArray();
    }
}

