/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.common;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.mapping.reader.v2.TinyMetadata;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.LocalVariableDef;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.ParameterDef;
import net.fabricmc.mapping.tree.TinyMappingFactory;
import net.fabricmc.mapping.tree.TinyTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class MappingConfiguration {
    protected static Logger LOGGER = LogManager.getFormatterLogger((String)"FabricLoader");
    private static TinyTree mappings;
    private static boolean checkedMappings;

    private static TinyTree wrapTree(final TinyTree mappings) {
        return new TinyTree(){
            final String primaryNamespace = (String)this.getMetadata().getNamespaces().get(0);

            private Optional<String> remap(String name, String namespace) {
                return Optional.ofNullable(this.getDefaultNamespaceClassMap().get(name)).map(mapping -> mapping.getRawName(namespace)).map(Strings::emptyToNull);
            }

            String remapDesc(String desc, String namespace) {
                Type type = Type.getType((String)desc);
                switch (type.getSort()) {
                    case 9: {
                        StringBuilder remappedDescriptor = new StringBuilder(desc.substring(0, type.getDimensions()));
                        remappedDescriptor.append(this.remapDesc(type.getElementType().getDescriptor(), namespace));
                        return remappedDescriptor.toString();
                    }
                    case 10: {
                        return this.remap(type.getInternalName(), namespace).map(name -> 'L' + name + ';').orElse(desc);
                    }
                    case 11: {
                        if ("()V".equals(desc)) {
                            return desc;
                        }
                        StringBuilder stringBuilder = new StringBuilder("(");
                        for (Type argumentType : type.getArgumentTypes()) {
                            stringBuilder.append(this.remapDesc(argumentType.getDescriptor(), namespace));
                        }
                        Type returnType = type.getReturnType();
                        if (returnType == Type.VOID_TYPE) {
                            stringBuilder.append(")V");
                        } else {
                            stringBuilder.append(')').append(this.remapDesc(returnType.getDescriptor(), namespace));
                        }
                        return stringBuilder.toString();
                    }
                }
                return desc;
            }

            private ClassDef wrap(final ClassDef mapping) {
                return new ClassDef(){
                    private final boolean common;
                    {
                        this.common = this.getMetadata().getNamespaces().stream().skip(1L).map(this::getRawName).allMatch(Strings::isNullOrEmpty);
                    }

                    public String getRawName(String namespace) {
                        try {
                            return mapping.getRawName(this.common ? primaryNamespace : namespace);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            return "";
                        }
                    }

                    public String getName(String namespace) {
                        return mapping.getName(namespace);
                    }

                    public String getComment() {
                        return mapping.getComment();
                    }

                    public Collection<MethodDef> getMethods() {
                        return Collections2.transform((Collection)mapping.getMethods(), method -> new MethodDef((MethodDef)method){
                            final /* synthetic */ MethodDef val$method;
                            {
                                this.val$method = methodDef;
                            }

                            public String getRawName(String namespace) {
                                try {
                                    return this.val$method.getRawName(namespace);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    return "";
                                }
                            }

                            public String getName(String namespace) {
                                return this.val$method.getName(namespace);
                            }

                            public String getComment() {
                                return this.val$method.getComment();
                            }

                            public String getDescriptor(String namespace) {
                                String desc = this.val$method.getDescriptor(primaryNamespace);
                                return primaryNamespace.equals(namespace) ? desc : this.remapDesc(desc, namespace);
                            }

                            public Collection<ParameterDef> getParameters() {
                                return this.val$method.getParameters();
                            }

                            public Collection<LocalVariableDef> getLocalVariables() {
                                return this.val$method.getLocalVariables();
                            }
                        });
                    }

                    public Collection<FieldDef> getFields() {
                        return Collections2.transform((Collection)mapping.getFields(), field -> new FieldDef((FieldDef)field){
                            final /* synthetic */ FieldDef val$field;
                            {
                                this.val$field = fieldDef;
                            }

                            public String getRawName(String namespace) {
                                try {
                                    return this.val$field.getRawName(namespace);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    return "";
                                }
                            }

                            public String getName(String namespace) {
                                return this.val$field.getName(namespace);
                            }

                            public String getComment() {
                                return this.val$field.getComment();
                            }

                            public String getDescriptor(String namespace) {
                                String desc = this.val$field.getDescriptor(primaryNamespace);
                                return primaryNamespace.equals(namespace) ? desc : this.remapDesc(desc, namespace);
                            }
                        });
                    }
                };
            }

            public TinyMetadata getMetadata() {
                return mappings.getMetadata();
            }

            public Map<String, ClassDef> getDefaultNamespaceClassMap() {
                return Maps.transformValues((Map)mappings.getDefaultNamespaceClassMap(), this::wrap);
            }

            public Collection<ClassDef> getClasses() {
                return Collections2.transform((Collection)mappings.getClasses(), this::wrap);
            }
        };
    }

    public TinyTree getMappings() {
        if (!checkedMappings) {
            InputStream mappingStream = FabricLauncherBase.class.getClassLoader().getResourceAsStream("mappings/mappings.tiny");
            if (mappingStream != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(mappingStream));){
                    long time = System.currentTimeMillis();
                    mappings = MappingConfiguration.wrapTree(TinyMappingFactory.loadWithDetection((BufferedReader)reader));
                    LOGGER.debug("Loading mappings took " + (System.currentTimeMillis() - time) + " ms");
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
                try {
                    mappingStream.close();
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
            if (mappings == null) {
                LOGGER.info("Mappings not present!");
                mappings = TinyMappingFactory.EMPTY_TREE;
            }
            checkedMappings = true;
        }
        return mappings;
    }

    public String getTargetNamespace() {
        return FabricLauncherBase.getLauncher().isDevelopment() ? "named" : "intermediary";
    }

    public boolean requiresPackageAccessHack() {
        return this.getTargetNamespace().equals("named");
    }
}

