/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.launch.common.FabricLauncher;
import net.fabricmc.loader.launch.common.MappingConfiguration;
import net.fabricmc.loader.util.Arguments;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.ClassInstance;
import net.fabricmc.tinyremapper.FileSystemHandler;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.MemberInstance;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.commons.Remapper;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class FabricLauncherBase
implements FabricLauncher {
    public static Path minecraftJar;
    protected static Logger LOGGER;
    private static boolean mixinReady;
    private static Map<String, Object> properties;
    private static FabricLauncher launcher;
    private static MappingConfiguration mappingConfiguration;
    private static boolean emittedInfo;

    protected FabricLauncherBase() {
        FabricLauncherBase.setLauncher(this);
    }

    public static File getLaunchDirectory(Arguments argMap) {
        return new File(argMap.getOrDefault("gameDir", "."));
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, FabricLauncherBase.getLauncher().getTargetClassLoader());
    }

    @Override
    public MappingConfiguration getMappingConfiguration() {
        return mappingConfiguration;
    }

    protected static Path deobfuscate(String gameId, String gameVersion, Path gameDir, Path jarFile, FabricLauncher launcher) {
        return FabricLauncherBase.deobfuscate_backend(gameId, gameVersion, gameDir, jarFile, launcher, new String[0]);
    }

    private static Path deobfuscate_backend(String gameId, String gameVersion, Path gameDir, Path jarFile, FabricLauncher launcher, String ... namespaces) {
        String targetNamespace;
        Path resultJarFile = jarFile;
        LOGGER.debug("Requesting deobfuscation of " + jarFile.getFileName());
        TinyTree mappings = launcher.isDevelopment() ? null : mappingConfiguration.getMappings();
        String string = targetNamespace = namespaces.length == 0 ? mappingConfiguration.getTargetNamespace() : namespaces[0];
        if (mappings != null && mappings.getMetadata().getNamespaces().contains(targetNamespace)) {
            LOGGER.debug("Fabric mapping file detected, applying...");
            try {
                if (!Files.exists(jarFile, new LinkOption[0])) {
                    throw new RuntimeException("Could not locate Minecraft: " + jarFile + " not found");
                }
                Path deobfJarDir = gameDir.resolve(".fabric").resolve("remappedJars");
                if (!gameId.isEmpty()) {
                    String versionedId = gameVersion.isEmpty() ? gameId : String.format("%s-%s", gameId, gameVersion);
                    deobfJarDir = deobfJarDir.resolve(versionedId);
                }
                if (!Files.exists(deobfJarDir, new LinkOption[0])) {
                    Files.createDirectories(deobfJarDir, new FileAttribute[0]);
                }
                String deobfJarFilename = mappingConfiguration.getTargetNamespace() + "-" + jarFile.getFileName();
                if (namespaces.length != 0) {
                    deobfJarFilename = deobfJarFilename + ".remap";
                }
                Path deobfJarFile = deobfJarDir.resolve(deobfJarFilename);
                Path deobfJarFileTmp = deobfJarDir.resolve(deobfJarFilename + ".tmp");
                Files.deleteIfExists(deobfJarFile);
                if (Files.exists(deobfJarFileTmp, new LinkOption[0])) {
                    LOGGER.warn("Incomplete remapped file found! This means that the remapping process failed on the previous launch. If this persists, make sure to let us at Fabric know!");
                    Files.deleteIfExists(deobfJarFileTmp);
                    Files.deleteIfExists(deobfJarFile);
                }
                if (!Files.exists(deobfJarFile, new LinkOption[0])) {
                    boolean found = false;
                    while (!found) {
                        if (!emittedInfo) {
                            LOGGER.info("Fabric is preparing JARs on first launch, this may take a few seconds...");
                            emittedInfo = true;
                        }
                        String sidedOrigin = launcher.getEnvironmentType().name().toLowerCase(Locale.ENGLISH);
                        String originNamespace = namespaces.length == 0 ? (mappings.getMetadata().getNamespaces().contains(sidedOrigin) ? sidedOrigin : "official") : namespaces[1];
                        TinyRemapperWithOverwrites remapper = new TinyRemapperWithOverwrites(TinyRemapper.newRemapper().withMappings(TinyRemapperMappingsHelper.create(mappings, originNamespace, targetNamespace)).rebuildSourceFilenames(true).fixPackageAccess(!launcher.isDevelopment()).extraRemapper(new Remapper(){

                            public String map(String internalName) {
                                if (!internalName.contains("/")) {
                                    return "net/minecraft/src/" + internalName;
                                }
                                return internalName;
                            }
                        }).build());
                        HashSet<Path> depPaths = new HashSet<Path>();
                        for (URL uRL : launcher.getLoadTimeDependencies()) {
                            try {
                                Path path = UrlUtil.asPath(uRL);
                                if (!Files.exists(path, new LinkOption[0])) {
                                    throw new RuntimeException("Path does not exist: " + path);
                                }
                                if (path.equals(jarFile)) continue;
                                depPaths.add(path);
                            }
                            catch (UrlConversionException e2) {
                                throw new RuntimeException("Failed to convert '" + uRL + "' to path!", e2);
                            }
                        }
                        try {
                            Throwable throwable = null;
                            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(deobfJarFileTmp).assumeArchive(true).filter(clsName -> !clsName.startsWith("com/google/common/") && !clsName.startsWith("com/google/gson/") && !clsName.startsWith("com/google/thirdparty/") && !clsName.startsWith("org/apache/logging/log4j/")).build();){
                                for (Path path : depPaths) {
                                    LOGGER.debug("Appending '" + path + "' to remapper classpath");
                                    TinyRemapperWithOverwrites.INSTANCE.readClassPath(new Path[]{path});
                                }
                                remapper.readInputs(jarFile);
                                TinyRemapperWithOverwrites.INSTANCE.apply((BiConsumer)outputConsumer);
                            }
                            catch (Throwable throwable2) {
                                Throwable throwable3 = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (IOException e3) {
                            throw new RuntimeException("Failed to remap '" + jarFile + "'!", e3);
                        }
                        finally {
                            TinyRemapperWithOverwrites.INSTANCE.finish();
                        }
                        depPaths.add(deobfJarFileTmp);
                        for (Path path : depPaths) {
                            try {
                                path.getFileSystem().close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                FileSystems.getFileSystem(new URI("jar:" + path.toUri())).close();
                            }
                            catch (Exception exception) {}
                        }
                        Throwable throwable = null;
                        try (JarFile jar = new JarFile(deobfJarFileTmp.toFile());){
                            found = jar.stream().anyMatch(e -> e.getName().endsWith(".class"));
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = throwable4;
                            throw throwable4;
                        }
                        if (!found) {
                            LOGGER.error("Generated deobfuscated JAR contains no classes! Trying again...");
                            Files.delete(deobfJarFileTmp);
                            continue;
                        }
                        Files.move(deobfJarFileTmp, deobfJarFile, new CopyOption[0]);
                    }
                }
                if (!Files.exists(deobfJarFile, new LinkOption[0])) {
                    throw new RuntimeException("Remapped .JAR file does not exist after remapping! Cannot continue!");
                }
                resultJarFile = deobfJarFile;
            }
            catch (IOException e4) {
                throw new RuntimeException(e4);
            }
        }
        try {
            launcher.propose(UrlUtil.asUrl(resultJarFile));
        }
        catch (UrlConversionException e5) {
            throw new RuntimeException(e5);
        }
        if (minecraftJar == null) {
            minecraftJar = resultJarFile;
        }
        return resultJarFile;
    }

    public static void processArgumentMap(Arguments argMap, EnvType envType) {
        switch (envType) {
            case CLIENT: {
                if (!argMap.containsKey("accessToken")) {
                    argMap.put("accessToken", "FabricMC");
                }
                if (!argMap.containsKey("version")) {
                    argMap.put("version", "Fabric");
                }
                String versionType = "";
                if (argMap.containsKey("versionType") && !argMap.get("versionType").equalsIgnoreCase("release")) {
                    versionType = argMap.get("versionType") + "/";
                }
                argMap.put("versionType", versionType + "Fabric");
                if (argMap.containsKey("gameDir")) break;
                argMap.put("gameDir", FabricLauncherBase.getLaunchDirectory(argMap).getAbsolutePath());
                break;
            }
            case SERVER: {
                argMap.remove("version");
                argMap.remove("gameDir");
                argMap.remove("assetsDir");
            }
        }
    }

    protected static void setProperties(Map<String, Object> propertiesA) {
        if (properties != null && properties != propertiesA) {
            throw new RuntimeException("Duplicate setProperties call!");
        }
        properties = propertiesA;
    }

    private static void setLauncher(FabricLauncher launcherA) {
        if (launcher != null && launcher != launcherA) {
            throw new RuntimeException("Duplicate setLauncher call!");
        }
        launcher = launcherA;
    }

    public static FabricLauncher getLauncher() {
        return launcher;
    }

    public static Map<String, Object> getProperties() {
        return properties;
    }

    protected static void finishMixinBootstrapping() {
        if (mixinReady) {
            throw new RuntimeException("Must not call FabricLauncherBase.finishMixinBootstrapping() twice!");
        }
        try {
            Method m = MixinEnvironment.class.getDeclaredMethod("gotoPhase", MixinEnvironment.Phase.class);
            m.setAccessible(true);
            m.invoke(null, MixinEnvironment.Phase.INIT);
            m.invoke(null, MixinEnvironment.Phase.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        mixinReady = true;
    }

    public static boolean isMixinReady() {
        return mixinReady;
    }

    static {
        LOGGER = LogManager.getFormatterLogger((String)"FabricLoader");
        mappingConfiguration = new MappingConfiguration();
        emittedInfo = false;
    }

    public static class TinyRemapperWithOverwrites {
        public static TinyRemapper INSTANCE;
        public static Map<String, AccessibleObject> accessMap;
        private static Map<String, ClassInstance> intermediaryMap;

        /*
         * WARNING - void declaration
         */
        public TinyRemapperWithOverwrites(TinyRemapper t) {
            void var6_11;
            INSTANCE = t;
            accessMap = new HashMap<String, AccessibleObject>();
            Field[] fields = null;
            try {
                fields = new Field[]{TinyRemapper.class.getDeclaredField("singleInputTags"), TinyRemapper.class.getDeclaredField("dirty"), TinyRemapper.class.getDeclaredField("readClasses"), TinyRemapper.class.getDeclaredField("classesToMakePublic"), TinyRemapper.class.getDeclaredField("membersToMakePublic"), ClassInstance.class.getDeclaredField("isInput"), ClassInstance.class.getDeclaredField("srcPath"), ClassInstance.class.getDeclaredField("name"), ClassInstance.class.getDeclaredField("data")};
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            for (void var6_9 : fields) {
                var6_9.setAccessible(true);
                accessMap.put("field_" + var6_9.getName(), (AccessibleObject)var6_9);
            }
            Method[] methods = null;
            try {
                methods = new Method[]{TinyRemapper.class.getDeclaredMethod("read", Path.class, Boolean.TYPE, InputTag[].class, Boolean.TYPE, List.class), TinyRemapper.class.getDeclaredMethod("mapClass", String.class), ClassInstance.class.getDeclaredMethod("addInputTags", InputTag[].class), ClassInstance.class.getDeclaredMethod("getInputTags", new Class[0])};
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            Method[] methodArray = methods;
            int n = methodArray.length;
            boolean bl = false;
            while (var6_11 < n) {
                void var7_12 = methodArray[var6_11];
                var7_12.setAccessible(true);
                accessMap.put("method_" + var7_12.getName(), (AccessibleObject)var7_12);
                ++var6_11;
            }
        }

        public void readInputs(Path ... inputs) {
            this.readInputs((InputTag)null, inputs);
        }

        public void readInputs(InputTag tag, Path ... inputs) {
            this.read(inputs, true, tag);
        }

        private static void makeMembersPublic(ClassInstance cls) {
            try {
                Set membersToMakePublic = (Set)((Field)accessMap.get("field_membersToMakePublic")).get(INSTANCE);
                for (MemberInstance member : cls.getMembers()) {
                    membersToMakePublic.add(member);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public List<ClassInstance> read(Path[] inputs, boolean isInput, InputTag tag) {
            InputTag[] tags = new InputTag[]{};
            try {
                tags = (InputTag[])((Map)((AtomicReference)((Field)accessMap.get("field_singleInputTags")).get(INSTANCE)).get()).get(tag);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ArrayList futures = new ArrayList();
            ArrayList fsToClose = new ArrayList();
            for (Path input : inputs) {
                try {
                    Collection x = (Collection)((Method)accessMap.get("method_read")).invoke((Object)INSTANCE, input, isInput, tags, true, fsToClose);
                    for (CompletableFuture listCompletableFuture : x) {
                        futures.add(listCompletableFuture.get());
                    }
                }
                catch (IllegalAccessException | InterruptedException | InvocationTargetException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (futures.isEmpty()) {
                return Collections.emptyList();
            }
            List<ClassInstance> ret = futures.size() == 1 ? (List<ClassInstance>)futures.get(0) : futures.stream().flatMap(Collection::stream).collect(Collectors.toList());
            try {
                ((Field)accessMap.get("field_dirty")).set(INSTANCE, true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            Field readClasses = (Field)accessMap.get("field_readClasses");
            ret.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
            for (int i = 0; i < ret.size(); ++i) {
                ClassInstance res = ret.get(i);
                for (FileSystem fs : fsToClose) {
                    try {
                        FileSystemHandler.close((FileSystem)fs);
                    }
                    catch (Exception exception) {}
                }
                try {
                    TinyRemapperWithOverwrites.addClass(res, (Map)readClasses.get(INSTANCE), intermediaryMap);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }

        private static void addClass(ClassInstance cls, Map<String, ClassInstance> out, Map<String, ClassInstance> intermediary) throws IllegalAccessException, InvocationTargetException {
            ClassInstance prev_mapped;
            Method getInputTags;
            Method addInputTags;
            Field classesToMakePublic;
            block6: {
                Field isInput = (Field)accessMap.get("field_isInput");
                Field srcPath = (Field)accessMap.get("field_srcPath");
                classesToMakePublic = (Field)accessMap.get("field_classesToMakePublic");
                Field field_name = (Field)accessMap.get("field_name");
                addInputTags = (Method)accessMap.get("method_addInputTags");
                getInputTags = (Method)accessMap.get("method_getInputTags");
                Method mapClass = (Method)accessMap.get("method_mapClass");
                String name = cls.getName();
                String mapped_name = (String)mapClass.invoke((Object)INSTANCE, cls.getName());
                while (true) {
                    ClassInstance prev = out.putIfAbsent(name, cls);
                    prev_mapped = out.putIfAbsent(mapped_name, cls);
                    if (prev == null && prev_mapped == null) {
                        ((Set)classesToMakePublic.get(INSTANCE)).add(cls);
                        TinyRemapperWithOverwrites.makeMembersPublic(cls);
                        return;
                    }
                    if (prev != null) {
                        if (((Boolean)isInput.get(cls)).booleanValue()) {
                            if (((Boolean)isInput.get(prev)).booleanValue()) {
                                addInputTags.invoke((Object)prev, getInputTags.invoke((Object)cls, new Object[0]));
                                ((Set)classesToMakePublic.get(INSTANCE)).add(prev);
                                TinyRemapperWithOverwrites.makeMembersPublic(prev);
                                return;
                            }
                            if (!out.replace(name, prev, cls)) continue;
                            addInputTags.invoke((Object)cls, getInputTags.invoke((Object)prev, new Object[0]));
                            ((Set)classesToMakePublic.get(INSTANCE)).add(cls);
                            TinyRemapperWithOverwrites.makeMembersPublic(cls);
                            return;
                        }
                        addInputTags.invoke((Object)prev, getInputTags.invoke((Object)cls, new Object[0]));
                        ((Set)classesToMakePublic.get(INSTANCE)).add(prev);
                        TinyRemapperWithOverwrites.makeMembersPublic(prev);
                        return;
                    }
                    if (!((Boolean)isInput.get(cls)).booleanValue()) break block6;
                    if (((Boolean)isInput.get(prev_mapped)).booleanValue()) {
                        addInputTags.invoke((Object)prev_mapped, getInputTags.invoke((Object)cls, new Object[0]));
                        ((Set)classesToMakePublic.get(INSTANCE)).add(prev_mapped);
                        TinyRemapperWithOverwrites.makeMembersPublic(prev_mapped);
                        return;
                    }
                    if (out.replace(name, prev_mapped, cls)) break;
                }
                addInputTags.invoke((Object)cls, getInputTags.invoke((Object)prev_mapped, new Object[0]));
                ((Set)classesToMakePublic.get(INSTANCE)).add(cls);
                TinyRemapperWithOverwrites.makeMembersPublic(cls);
                return;
            }
            addInputTags.invoke((Object)prev_mapped, getInputTags.invoke((Object)cls, new Object[0]));
            ((Set)classesToMakePublic.get(INSTANCE)).add(prev_mapped);
            TinyRemapperWithOverwrites.makeMembersPublic(prev_mapped);
        }

        static {
            intermediaryMap = new HashMap<String, ClassInstance>();
        }
    }
}

