/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import net.fabricmc.loader.FabricLoaderImpl;
import net.fabricmc.loader.discovery.ModCandidateFinder;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;

public class DirectoryModCandidateFinder
implements ModCandidateFinder {
    private final Path path;
    private final boolean requiresRemap;

    public DirectoryModCandidateFinder(Path path, boolean requiresRemap) {
        this.path = path;
        this.requiresRemap = requiresRemap;
    }

    @Override
    public void findCandidates(FabricLoaderImpl loader, final BiConsumer<URL, Boolean> urlProposer) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createDirectory(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create directory " + this.path, e);
            }
        }
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            throw new RuntimeException(this.path + " is not a directory!");
        }
        try {
            Files.walkFileTree(this.path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(".jar") && !fileName.startsWith(".") && !Files.isHidden(file)) {
                        try {
                            urlProposer.accept(UrlUtil.asUrl(file), DirectoryModCandidateFinder.this.requiresRemap);
                        }
                        catch (UrlConversionException e) {
                            throw new RuntimeException("Failed to convert URL for mod '" + file + "'!", e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while searching for mods in '" + this.path + "'!", e);
        }
    }
}

