/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.EntrypointException;
import net.fabricmc.loader.FabricLoaderImpl;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.entrypoint.EntrypointContainerImpl;
import net.fabricmc.loader.metadata.EntrypointMetadata;

class EntrypointStorage {
    private final Map<String, List<Entry>> entryMap = new HashMap<String, List<Entry>>();

    EntrypointStorage() {
    }

    private List<Entry> getOrCreateEntries(String key) {
        return this.entryMap.computeIfAbsent(key, z -> new ArrayList());
    }

    protected void add(ModContainer modContainer, String key, EntrypointMetadata metadata, Map<String, LanguageAdapter> adapterMap) throws Exception {
        if (!adapterMap.containsKey(metadata.getAdapter())) {
            throw new Exception("Could not find adapter '" + metadata.getAdapter() + "' (mod " + modContainer.getInfo().getId() + "!)");
        }
        FabricLoaderImpl.getInstance().getLogger().debug("Registering new-style initializer " + metadata.getValue() + " for mod " + modContainer.getInfo().getId() + " (key " + key + ")");
        this.getOrCreateEntries(key).add(new NewEntry(modContainer, adapterMap.get(metadata.getAdapter()), metadata.getValue()));
    }

    boolean hasEntrypoints(String key) {
        return this.entryMap.containsKey(key);
    }

    protected <T> List<T> getEntrypoints(String key, Class<T> type) {
        List<Entry> entries = this.entryMap.get(key);
        if (entries == null) {
            return Collections.emptyList();
        }
        Throwable exception = null;
        ArrayList<T> results = new ArrayList<T>(entries.size());
        for (Entry entry : entries) {
            try {
                T result = entry.getOrCreate(type);
                if (result == null) continue;
                results.add(result);
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = new EntrypointException(key, entry.getModContainer(), t);
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return results;
    }

    protected <T> List<EntrypointContainer<T>> getEntrypointContainers(String key, Class<T> type) {
        List<Entry> entries = this.entryMap.get(key);
        if (entries == null) {
            return Collections.emptyList();
        }
        ArrayList<EntrypointContainer<T>> results = new ArrayList<EntrypointContainer<T>>(entries.size());
        for (Entry entry : entries) {
            results.add(new EntrypointContainerImpl<Object>(entry.getModContainer(), () -> {
                try {
                    return entry.getOrCreate(type);
                }
                catch (Exception ex) {
                    throw new EntrypointException(key, entry.getModContainer(), ex);
                }
            }));
        }
        return results;
    }

    private static class NewEntry
    implements Entry {
        private final ModContainer mod;
        private final LanguageAdapter adapter;
        private final String value;
        private final ClassToInstanceMap<Object> instanceMap = MutableClassToInstanceMap.create(new IdentityHashMap());

        private NewEntry(ModContainer mod, LanguageAdapter adapter, String value) {
            this.mod = mod;
            this.adapter = adapter;
            this.value = value;
        }

        public String toString() {
            return this.mod.getInfo().getId() + "->" + this.value;
        }

        @Override
        public <T> T getOrCreate(Class<T> type) throws Exception {
            Object o = this.instanceMap.getInstance(type);
            if (o == null) {
                o = this.create(type);
                this.instanceMap.putInstance(type, o);
            }
            return (T)o;
        }

        @Override
        public ModContainer getModContainer() {
            return this.mod;
        }

        private <T> T create(Class<T> type) throws Exception {
            return this.adapter.create(this.mod, this.value, type);
        }
    }

    static interface Entry {
        public <T> T getOrCreate(Class<T> var1) throws Exception;

        public ModContainer getModContainer();
    }
}

