/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.symbols.MapSymbolDefinitions;
import zombie.worldMap.symbols.WorldMapBaseSymbol;
import zombie.worldMap.symbols.WorldMapSymbolCollisions;
import zombie.worldMap.symbols.WorldMapSymbols;

public final class WorldMapTextureSymbol
extends WorldMapBaseSymbol {
    private String m_symbolID;
    Texture m_texture;

    public WorldMapTextureSymbol(WorldMapSymbols worldMapSymbols) {
        super(worldMapSymbols);
    }

    public void setSymbolID(String string) {
        this.m_symbolID = string;
    }

    public String getSymbolID() {
        return this.m_symbolID;
    }

    public void checkTexture() {
        if (this.m_texture != null) {
            return;
        }
        MapSymbolDefinitions.MapSymbolDefinition mapSymbolDefinition = MapSymbolDefinitions.getInstance().getSymbolById(this.getSymbolID());
        if (mapSymbolDefinition == null) {
            this.m_width = 18.0f;
            this.m_height = 18.0f;
        } else {
            this.m_texture = Texture.getSharedTexture(mapSymbolDefinition.getTexturePath());
            this.m_width = mapSymbolDefinition.getWidth();
            this.m_height = mapSymbolDefinition.getHeight();
        }
        if (this.m_texture == null) {
            this.m_texture = Texture.getErrorTexture();
        }
    }

    @Override
    public WorldMapSymbols.WorldMapSymbolType getType() {
        return WorldMapSymbols.WorldMapSymbolType.Texture;
    }

    @Override
    public void layout(UIWorldMap uIWorldMap, WorldMapSymbolCollisions worldMapSymbolCollisions, float f, float f2) {
        this.checkTexture();
        super.layout(uIWorldMap, worldMapSymbolCollisions, f, f2);
    }

    @Override
    public void save(ByteBuffer byteBuffer) throws IOException {
        super.save(byteBuffer);
        GameWindow.WriteString(byteBuffer, this.m_symbolID);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        super.load(byteBuffer, n, n2);
        this.m_symbolID = GameWindow.ReadString(byteBuffer);
    }

    @Override
    public void render(UIWorldMap uIWorldMap, float f, float f2) {
        if (this.m_collided) {
            this.renderCollided(uIWorldMap, f, f2);
        } else {
            this.checkTexture();
            float f3 = f + this.m_layoutX;
            float f4 = f2 + this.m_layoutY;
            if (this.m_scale > 0.0f) {
                float f5 = this.getDisplayScale(uIWorldMap);
                SpriteRenderer.instance.m_states.getPopulatingActiveState().render(this.m_texture, (float)uIWorldMap.getAbsoluteX().intValue() + f3, (float)uIWorldMap.getAbsoluteY().intValue() + f4, (float)this.m_texture.getWidth() * f5, (float)this.m_texture.getHeight() * f5, this.m_r, this.m_g, this.m_b, this.m_a, null);
            } else {
                uIWorldMap.DrawTextureColor(this.m_texture, f3, f4, this.m_r, this.m_g, this.m_b, this.m_a);
            }
        }
    }

    @Override
    public void release() {
        this.m_symbolID = null;
        this.m_texture = null;
    }
}

