/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import java.util.ArrayList;
import java.util.Objects;
import zombie.Lua.LuaManager;
import zombie.ui.UIFont;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.symbols.WorldMapBaseSymbol;
import zombie.worldMap.symbols.WorldMapSymbols;
import zombie.worldMap.symbols.WorldMapTextSymbol;
import zombie.worldMap.symbols.WorldMapTextureSymbol;

public class WorldMapSymbolsV1 {
    private static final Pool<WorldMapTextSymbolV1> s_textPool = new Pool<WorldMapTextSymbolV1>(WorldMapTextSymbolV1::new);
    private static final Pool<WorldMapTextureSymbolV1> s_texturePool = new Pool<WorldMapTextureSymbolV1>(WorldMapTextureSymbolV1::new);
    private final UIWorldMap m_ui;
    private final WorldMapSymbols m_uiSymbols;
    private final ArrayList<WorldMapBaseSymbolV1> m_symbols = new ArrayList();

    public WorldMapSymbolsV1(UIWorldMap uIWorldMap, WorldMapSymbols worldMapSymbols) {
        Objects.requireNonNull(uIWorldMap);
        this.m_ui = uIWorldMap;
        this.m_uiSymbols = worldMapSymbols;
        this.reinit();
    }

    public WorldMapTextSymbolV1 addTranslatedText(String string, UIFont uIFont, float f, float f2) {
        WorldMapTextSymbol worldMapTextSymbol = this.m_uiSymbols.addTranslatedText(string, uIFont, f, f2, 1.0f, 1.0f, 1.0f, 1.0f);
        WorldMapTextSymbolV1 worldMapTextSymbolV1 = s_textPool.alloc().init(this, worldMapTextSymbol);
        this.m_symbols.add(worldMapTextSymbolV1);
        return worldMapTextSymbolV1;
    }

    public WorldMapTextSymbolV1 addUntranslatedText(String string, UIFont uIFont, float f, float f2) {
        WorldMapTextSymbol worldMapTextSymbol = this.m_uiSymbols.addUntranslatedText(string, uIFont, f, f2, 1.0f, 1.0f, 1.0f, 1.0f);
        WorldMapTextSymbolV1 worldMapTextSymbolV1 = s_textPool.alloc().init(this, worldMapTextSymbol);
        this.m_symbols.add(worldMapTextSymbolV1);
        return worldMapTextSymbolV1;
    }

    public WorldMapTextureSymbolV1 addTexture(String string, float f, float f2) {
        WorldMapTextureSymbol worldMapTextureSymbol = this.m_uiSymbols.addTexture(string, f, f2, 1.0f, 1.0f, 1.0f, 1.0f);
        WorldMapTextureSymbolV1 worldMapTextureSymbolV1 = s_texturePool.alloc().init(this, worldMapTextureSymbol);
        this.m_symbols.add(worldMapTextureSymbolV1);
        return worldMapTextureSymbolV1;
    }

    public int hitTest(float f, float f2) {
        return this.m_uiSymbols.hitTest(this.m_ui, f, f2);
    }

    public int getSymbolCount() {
        return this.m_symbols.size();
    }

    public WorldMapBaseSymbolV1 getSymbolByIndex(int n) {
        return this.m_symbols.get(n);
    }

    public void removeSymbolByIndex(int n) {
        this.m_uiSymbols.removeSymbolByIndex(n);
        this.m_symbols.remove(n).release();
    }

    public void clear() {
        this.m_uiSymbols.clear();
        this.reinit();
    }

    void reinit() {
        int n;
        for (n = 0; n < this.m_symbols.size(); ++n) {
            this.m_symbols.get(n).release();
        }
        this.m_symbols.clear();
        for (n = 0; n < this.m_uiSymbols.getSymbolCount(); ++n) {
            Object object;
            WorldMapBaseSymbol worldMapBaseSymbol = this.m_uiSymbols.getSymbolByIndex(n);
            WorldMapTextSymbol worldMapTextSymbol = Type.tryCastTo(worldMapBaseSymbol, WorldMapTextSymbol.class);
            if (worldMapTextSymbol != null) {
                object = s_textPool.alloc().init(this, worldMapTextSymbol);
                this.m_symbols.add((WorldMapBaseSymbolV1)object);
            }
            if ((object = Type.tryCastTo(worldMapBaseSymbol, WorldMapTextureSymbol.class)) == null) continue;
            WorldMapTextureSymbolV1 worldMapTextureSymbolV1 = s_texturePool.alloc().init(this, (WorldMapTextureSymbol)object);
            this.m_symbols.add(worldMapTextureSymbolV1);
        }
    }

    public static void setExposed(LuaManager.Exposer exposer) {
        exposer.setExposed(WorldMapSymbolsV1.class);
        exposer.setExposed(WorldMapTextSymbolV1.class);
        exposer.setExposed(WorldMapTextureSymbolV1.class);
    }

    public static class WorldMapTextSymbolV1
    extends WorldMapBaseSymbolV1 {
        WorldMapTextSymbol m_textSymbol;

        WorldMapTextSymbolV1 init(WorldMapSymbolsV1 worldMapSymbolsV1, WorldMapTextSymbol worldMapTextSymbol) {
            super.init(worldMapSymbolsV1, worldMapTextSymbol);
            this.m_textSymbol = worldMapTextSymbol;
            return this;
        }

        public void setTranslatedText(String string) {
            if (StringUtils.isNullOrWhitespace(string)) {
                return;
            }
            this.m_textSymbol.setTranslatedText(string);
            this.m_owner.m_uiSymbols.invalidateLayout();
        }

        public void setUntranslatedText(String string) {
            if (StringUtils.isNullOrWhitespace(string)) {
                return;
            }
            this.m_textSymbol.setUntranslatedText(string);
            this.m_owner.m_uiSymbols.invalidateLayout();
        }

        public String getTranslatedText() {
            return this.m_textSymbol.getTranslatedText();
        }

        public String getUntranslatedText() {
            return this.m_textSymbol.getUntranslatedText();
        }

        @Override
        public boolean isText() {
            return true;
        }
    }

    public static class WorldMapTextureSymbolV1
    extends WorldMapBaseSymbolV1 {
        WorldMapTextureSymbol m_textureSymbol;

        WorldMapTextureSymbolV1 init(WorldMapSymbolsV1 worldMapSymbolsV1, WorldMapTextureSymbol worldMapTextureSymbol) {
            super.init(worldMapSymbolsV1, worldMapTextureSymbol);
            this.m_textureSymbol = worldMapTextureSymbol;
            return this;
        }

        public String getSymbolID() {
            return this.m_textureSymbol.getSymbolID();
        }

        @Override
        public boolean isTexture() {
            return true;
        }
    }

    protected static class WorldMapBaseSymbolV1
    extends PooledObject {
        WorldMapSymbolsV1 m_owner;
        WorldMapBaseSymbol m_symbol;

        protected WorldMapBaseSymbolV1() {
        }

        WorldMapBaseSymbolV1 init(WorldMapSymbolsV1 worldMapSymbolsV1, WorldMapBaseSymbol worldMapBaseSymbol) {
            this.m_owner = worldMapSymbolsV1;
            this.m_symbol = worldMapBaseSymbol;
            return this;
        }

        public float getWorldX() {
            return this.m_symbol.m_x;
        }

        public float getWorldY() {
            return this.m_symbol.m_y;
        }

        public float getDisplayX() {
            this.m_owner.m_uiSymbols.checkLayout(this.m_owner.m_ui);
            return this.m_symbol.m_layoutX + this.m_owner.m_ui.getAPIv1().worldOriginX();
        }

        public float getDisplayY() {
            this.m_owner.m_uiSymbols.checkLayout(this.m_owner.m_ui);
            return this.m_symbol.m_layoutY + this.m_owner.m_ui.getAPIv1().worldOriginY();
        }

        public float getDisplayWidth() {
            this.m_owner.m_uiSymbols.checkLayout(this.m_owner.m_ui);
            return this.m_symbol.widthScaled(this.m_owner.m_ui);
        }

        public float getDisplayHeight() {
            this.m_owner.m_uiSymbols.checkLayout(this.m_owner.m_ui);
            return this.m_symbol.heightScaled(this.m_owner.m_ui);
        }

        public void setAnchor(float f, float f2) {
            this.m_symbol.setAnchor(f, f2);
        }

        public void setPosition(float f, float f2) {
            this.m_symbol.setPosition(f, f2);
            this.m_owner.m_uiSymbols.invalidateLayout();
        }

        public void setCollide(boolean bl) {
            this.m_symbol.setCollide(bl);
        }

        public void setVisible(boolean bl) {
            this.m_symbol.setVisible(bl);
        }

        public boolean isVisible() {
            return this.m_symbol.isVisible();
        }

        public void setRGBA(float f, float f2, float f3, float f4) {
            this.m_symbol.setRGBA(f, f2, f3, f4);
        }

        public float getRed() {
            return this.m_symbol.m_r;
        }

        public float getGreen() {
            return this.m_symbol.m_g;
        }

        public float getBlue() {
            return this.m_symbol.m_b;
        }

        public float getAlpha() {
            return this.m_symbol.m_a;
        }

        public void setScale(float f) {
            this.m_symbol.setScale(f);
        }

        public boolean isText() {
            return false;
        }

        public boolean isTexture() {
            return false;
        }
    }
}

