/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TFloatArrayList;

public final class WorldMapSymbolCollisions {
    final TFloatArrayList m_boxes = new TFloatArrayList();
    final TByteArrayList m_collide = new TByteArrayList();

    boolean addBox(float f, float f2, float f3, float f4, boolean bl) {
        int n = this.m_boxes.size() / 4 - 1;
        int n2 = n + 1;
        this.m_boxes.add(f);
        this.m_boxes.add(f2);
        this.m_boxes.add(f + f3);
        this.m_boxes.add(f2 + f4);
        this.m_collide.add(bl ? (byte)1 : 0);
        if (!bl) {
            return false;
        }
        for (int i = 0; i <= n; ++i) {
            if (!this.isCollision(i, n2)) continue;
            this.m_boxes.set(n2 * 4, (f += f3 / 2.0f) - 3.0f - 1.0f);
            this.m_boxes.set(n2 * 4 + 1, (f2 += f4 / 2.0f) - 3.0f - 1.0f);
            this.m_boxes.set(n2 * 4 + 2, f + 3.0f + 1.0f);
            this.m_boxes.set(n2 * 4 + 3, f2 - 3.0f + 1.0f);
            return true;
        }
        return false;
    }

    boolean isCollision(int n, int n2) {
        if (this.m_collide.getQuick(n) == 0 || this.m_collide.getQuick(n2) == 0) {
            return false;
        }
        float f = this.m_boxes.get(n *= 4);
        float f2 = this.m_boxes.get(n + 1);
        float f3 = this.m_boxes.get(n + 2);
        float f4 = this.m_boxes.get(n + 3);
        float f5 = this.m_boxes.get(n2 *= 4);
        float f6 = this.m_boxes.get(n2 + 1);
        float f7 = this.m_boxes.get(n2 + 2);
        float f8 = this.m_boxes.get(n2 + 3);
        return f < f7 && f3 > f5 && f2 < f8 && f4 > f6;
    }

    boolean isCollision(int n) {
        for (int i = 0; i < this.m_boxes.size() / 4; ++i) {
            if (i == n || !this.isCollision(n, i)) continue;
            return true;
        }
        return false;
    }
}

