/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import zombie.core.textures.Texture;

public final class MapSymbolDefinitions {
    private static MapSymbolDefinitions instance;
    private final ArrayList<MapSymbolDefinition> m_symbolList = new ArrayList();
    private final HashMap<String, MapSymbolDefinition> m_symbolByID = new HashMap();

    public static MapSymbolDefinitions getInstance() {
        if (instance == null) {
            instance = new MapSymbolDefinitions();
        }
        return instance;
    }

    public void addTexture(String string, String string2, int n, int n2) {
        MapSymbolDefinition mapSymbolDefinition = new MapSymbolDefinition();
        mapSymbolDefinition.id = string;
        mapSymbolDefinition.texturePath = string2;
        mapSymbolDefinition.width = n;
        mapSymbolDefinition.height = n2;
        this.m_symbolList.add(mapSymbolDefinition);
        this.m_symbolByID.put(string, mapSymbolDefinition);
    }

    public void addTexture(String string, String string2) {
        Texture texture = Texture.getSharedTexture(string2);
        if (texture == null) {
            this.addTexture(string, string2, 18, 18);
            return;
        }
        this.addTexture(string, string2, texture.getWidth(), texture.getHeight());
    }

    public int getSymbolCount() {
        return this.m_symbolList.size();
    }

    public MapSymbolDefinition getSymbolByIndex(int n) {
        return this.m_symbolList.get(n);
    }

    public MapSymbolDefinition getSymbolById(String string) {
        return this.m_symbolByID.get(string);
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        MapSymbolDefinitions.getInstance().m_symbolList.clear();
        MapSymbolDefinitions.getInstance().m_symbolByID.clear();
    }

    public static final class MapSymbolDefinition {
        private String id;
        private String texturePath;
        private int width;
        private int height;

        public String getId() {
            return this.id;
        }

        public String getTexturePath() {
            return this.texturePath;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

