/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.styles;

import java.util.ArrayList;
import java.util.Objects;
import zombie.Lua.LuaManager;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.UIWorldMapV1;
import zombie.worldMap.styles.WorldMapLineStyleLayer;
import zombie.worldMap.styles.WorldMapPolygonStyleLayer;
import zombie.worldMap.styles.WorldMapStyle;
import zombie.worldMap.styles.WorldMapStyleLayer;
import zombie.worldMap.styles.WorldMapTextureStyleLayer;

public class WorldMapStyleV1 {
    public UIWorldMap m_ui;
    public UIWorldMapV1 m_api;
    public WorldMapStyle m_style;
    public final ArrayList<WorldMapStyleLayerV1> m_layers = new ArrayList();

    public WorldMapStyleV1(UIWorldMap uIWorldMap) {
        Objects.requireNonNull(uIWorldMap);
        this.m_ui = uIWorldMap;
        this.m_api = uIWorldMap.getAPIv1();
        this.m_style = this.m_api.getStyle();
    }

    public WorldMapStyleLayerV1 newLineLayer(String string) throws IllegalArgumentException {
        WorldMapLineStyleLayerV1 worldMapLineStyleLayerV1 = new WorldMapLineStyleLayerV1(this, string);
        this.m_layers.add(worldMapLineStyleLayerV1);
        return worldMapLineStyleLayerV1;
    }

    public WorldMapStyleLayerV1 newPolygonLayer(String string) throws IllegalArgumentException {
        WorldMapPolygonStyleLayerV1 worldMapPolygonStyleLayerV1 = new WorldMapPolygonStyleLayerV1(this, string);
        this.m_layers.add(worldMapPolygonStyleLayerV1);
        return worldMapPolygonStyleLayerV1;
    }

    public WorldMapStyleLayerV1 newTextureLayer(String string) throws IllegalArgumentException {
        WorldMapTextureStyleLayerV1 worldMapTextureStyleLayerV1 = new WorldMapTextureStyleLayerV1(this, string);
        this.m_layers.add(worldMapTextureStyleLayerV1);
        return worldMapTextureStyleLayerV1;
    }

    public int getLayerCount() {
        return this.m_layers.size();
    }

    public WorldMapStyleLayerV1 getLayerByIndex(int n) {
        return this.m_layers.get(n);
    }

    public WorldMapStyleLayerV1 getLayerByName(String string) {
        int n = this.indexOfLayer(string);
        return n == -1 ? null : this.m_layers.get(n);
    }

    public int indexOfLayer(String string) {
        for (int i = 0; i < this.m_layers.size(); ++i) {
            WorldMapStyleLayerV1 worldMapStyleLayerV1 = this.m_layers.get(i);
            if (!worldMapStyleLayerV1.m_layer.m_id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void moveLayer(int n, int n2) {
        WorldMapStyleLayer worldMapStyleLayer = this.m_style.m_layers.remove(n);
        this.m_style.m_layers.add(n2, worldMapStyleLayer);
        WorldMapStyleLayerV1 worldMapStyleLayerV1 = this.m_layers.remove(n);
        this.m_layers.add(n2, worldMapStyleLayerV1);
    }

    public void removeLayerById(String string) {
        int n = this.indexOfLayer(string);
        if (n == -1) {
            return;
        }
        this.removeLayerByIndex(n);
    }

    public void removeLayerByIndex(int n) {
        this.m_style.m_layers.remove(n);
        this.m_layers.remove(n);
    }

    public void clear() {
        this.m_style.m_layers.clear();
        this.m_layers.clear();
    }

    public static void setExposed(LuaManager.Exposer exposer) {
        exposer.setExposed(WorldMapStyleV1.class);
        exposer.setExposed(WorldMapStyleLayerV1.class);
        exposer.setExposed(WorldMapLineStyleLayerV1.class);
        exposer.setExposed(WorldMapPolygonStyleLayerV1.class);
        exposer.setExposed(WorldMapTextureStyleLayerV1.class);
    }

    public static class WorldMapLineStyleLayerV1
    extends WorldMapStyleLayerV1 {
        WorldMapLineStyleLayer m_lineStyle;

        WorldMapLineStyleLayerV1(WorldMapStyleV1 worldMapStyleV1, String string) {
            super(worldMapStyleV1, new WorldMapLineStyleLayer(string));
            this.m_lineStyle = (WorldMapLineStyleLayer)this.m_layer;
        }

        public void setFilter(String string, String string2) {
            this.m_lineStyle.m_filterKey = string;
            this.m_lineStyle.m_filterValue = string2;
            this.m_lineStyle.m_filter = (worldMapFeature, filterArgs) -> worldMapFeature.hasLineString() && string2.equals(worldMapFeature.m_properties.get(string));
        }

        public void addFill(float f, int n, int n2, int n3, int n4) {
            this.m_lineStyle.m_fill.add(new WorldMapStyleLayer.ColorStop(f, n, n2, n3, n4));
        }

        public void addLineWidth(float f, float f2) {
            this.m_lineStyle.m_lineWidth.add(new WorldMapStyleLayer.FloatStop(f, f2));
        }
    }

    public static class WorldMapPolygonStyleLayerV1
    extends WorldMapStyleLayerV1 {
        WorldMapPolygonStyleLayer m_polygonStyle;

        WorldMapPolygonStyleLayerV1(WorldMapStyleV1 worldMapStyleV1, String string) {
            super(worldMapStyleV1, new WorldMapPolygonStyleLayer(string));
            this.m_polygonStyle = (WorldMapPolygonStyleLayer)this.m_layer;
        }

        public void setFilter(String string, String string2) {
            this.m_polygonStyle.m_filterKey = string;
            this.m_polygonStyle.m_filterValue = string2;
            this.m_polygonStyle.m_filter = (worldMapFeature, filterArgs) -> worldMapFeature.hasPolygon() && string2.equals(worldMapFeature.m_properties.get(string));
        }

        public String getFilterKey() {
            return this.m_polygonStyle.m_filterKey;
        }

        public String getFilterValue() {
            return this.m_polygonStyle.m_filterValue;
        }

        public void addFill(float f, int n, int n2, int n3, int n4) {
            this.m_polygonStyle.m_fill.add(new WorldMapStyleLayer.ColorStop(f, n, n2, n3, n4));
        }

        public void addScale(float f, float f2) {
            this.m_polygonStyle.m_scale.add(new WorldMapStyleLayer.FloatStop(f, f2));
        }

        public void addTexture(float f, String string) {
            this.m_polygonStyle.m_texture.add(new WorldMapStyleLayer.TextureStop(f, string));
        }

        public void removeFill(int n) {
            this.m_polygonStyle.m_fill.remove(n);
        }

        public void removeTexture(int n) {
            this.m_polygonStyle.m_texture.remove(n);
        }

        public void moveFill(int n, int n2) {
            WorldMapStyleLayer.ColorStop colorStop = this.m_polygonStyle.m_fill.remove(n);
            this.m_polygonStyle.m_fill.add(n2, colorStop);
        }

        public void moveTexture(int n, int n2) {
            WorldMapStyleLayer.TextureStop textureStop = this.m_polygonStyle.m_texture.remove(n);
            this.m_polygonStyle.m_texture.add(n2, textureStop);
        }

        public int getFillStops() {
            return this.m_polygonStyle.m_fill.size();
        }

        public void setFillRGBA(int n, int n2, int n3, int n4, int n5) {
            this.m_polygonStyle.m_fill.get((int)n).r = n2;
            this.m_polygonStyle.m_fill.get((int)n).g = n3;
            this.m_polygonStyle.m_fill.get((int)n).b = n4;
            this.m_polygonStyle.m_fill.get((int)n).a = n5;
        }

        public void setFillZoom(int n, float f) {
            this.m_polygonStyle.m_fill.get((int)n).m_zoom = PZMath.clamp(f, 0.0f, 24.0f);
        }

        public float getFillZoom(int n) {
            return this.m_polygonStyle.m_fill.get((int)n).m_zoom;
        }

        public int getFillRed(int n) {
            return this.m_polygonStyle.m_fill.get((int)n).r;
        }

        public int getFillGreen(int n) {
            return this.m_polygonStyle.m_fill.get((int)n).g;
        }

        public int getFillBlue(int n) {
            return this.m_polygonStyle.m_fill.get((int)n).b;
        }

        public int getFillAlpha(int n) {
            return this.m_polygonStyle.m_fill.get((int)n).a;
        }

        public int getTextureStops() {
            return this.m_polygonStyle.m_texture.size();
        }

        public void setTextureZoom(int n, float f) {
            this.m_polygonStyle.m_texture.get((int)n).m_zoom = PZMath.clamp(f, 0.0f, 24.0f);
        }

        public float getTextureZoom(int n) {
            return this.m_polygonStyle.m_texture.get((int)n).m_zoom;
        }

        public void setTexturePath(int n, String string) {
            this.m_polygonStyle.m_texture.get((int)n).texturePath = string;
            this.m_polygonStyle.m_texture.get((int)n).texture = Texture.getTexture(string);
        }

        public String getTexturePath(int n) {
            return this.m_polygonStyle.m_texture.get((int)n).texturePath;
        }

        public Texture getTexture(int n) {
            return this.m_polygonStyle.m_texture.get((int)n).texture;
        }
    }

    public static class WorldMapTextureStyleLayerV1
    extends WorldMapStyleLayerV1 {
        WorldMapTextureStyleLayer m_textureStyle;

        WorldMapTextureStyleLayerV1(WorldMapStyleV1 worldMapStyleV1, String string) {
            super(worldMapStyleV1, new WorldMapTextureStyleLayer(string));
            this.m_textureStyle = (WorldMapTextureStyleLayer)this.m_layer;
        }

        public void addFill(float f, int n, int n2, int n3, int n4) {
            this.m_textureStyle.m_fill.add(new WorldMapStyleLayer.ColorStop(f, n, n2, n3, n4));
        }

        public void addTexture(float f, String string) {
            this.m_textureStyle.m_texture.add(new WorldMapStyleLayer.TextureStop(f, string));
        }

        public void removeFill(int n) {
            this.m_textureStyle.m_fill.remove(n);
        }

        public void removeAllFill() {
            this.m_textureStyle.m_fill.clear();
        }

        public void removeTexture(int n) {
            this.m_textureStyle.m_texture.remove(n);
        }

        public void removeAllTexture() {
            this.m_textureStyle.m_texture.clear();
        }

        public void moveFill(int n, int n2) {
            WorldMapStyleLayer.ColorStop colorStop = this.m_textureStyle.m_fill.remove(n);
            this.m_textureStyle.m_fill.add(n2, colorStop);
        }

        public void moveTexture(int n, int n2) {
            WorldMapStyleLayer.TextureStop textureStop = this.m_textureStyle.m_texture.remove(n);
            this.m_textureStyle.m_texture.add(n2, textureStop);
        }

        public void setBoundsInSquares(int n, int n2, int n3, int n4) {
            this.m_textureStyle.m_worldX1 = n;
            this.m_textureStyle.m_worldY1 = n2;
            this.m_textureStyle.m_worldX2 = n3;
            this.m_textureStyle.m_worldY2 = n4;
        }

        public int getMinXInSquares() {
            return this.m_textureStyle.m_worldX1;
        }

        public int getMinYInSquares() {
            return this.m_textureStyle.m_worldY1;
        }

        public int getMaxXInSquares() {
            return this.m_textureStyle.m_worldX2;
        }

        public int getMaxYInSquares() {
            return this.m_textureStyle.m_worldY2;
        }

        public int getWidthInSquares() {
            return this.m_textureStyle.m_worldX2 - this.m_textureStyle.m_worldX1;
        }

        public int getHeightInSquares() {
            return this.m_textureStyle.m_worldY2 - this.m_textureStyle.m_worldY1;
        }

        public void setTile(boolean bl) {
            this.m_textureStyle.m_tile = bl;
        }

        public boolean isTile() {
            return this.m_textureStyle.m_tile;
        }

        public void setUseWorldBounds(boolean bl) {
            this.m_textureStyle.m_useWorldBounds = bl;
        }

        public boolean isUseWorldBounds() {
            return this.m_textureStyle.m_useWorldBounds;
        }

        public int getFillStops() {
            return this.m_textureStyle.m_fill.size();
        }

        public void setFillRGBA(int n, int n2, int n3, int n4, int n5) {
            this.m_textureStyle.m_fill.get((int)n).r = n2;
            this.m_textureStyle.m_fill.get((int)n).g = n3;
            this.m_textureStyle.m_fill.get((int)n).b = n4;
            this.m_textureStyle.m_fill.get((int)n).a = n5;
        }

        public void setFillZoom(int n, float f) {
            this.m_textureStyle.m_fill.get((int)n).m_zoom = PZMath.clamp(f, 0.0f, 24.0f);
        }

        public float getFillZoom(int n) {
            return this.m_textureStyle.m_fill.get((int)n).m_zoom;
        }

        public int getFillRed(int n) {
            return this.m_textureStyle.m_fill.get((int)n).r;
        }

        public int getFillGreen(int n) {
            return this.m_textureStyle.m_fill.get((int)n).g;
        }

        public int getFillBlue(int n) {
            return this.m_textureStyle.m_fill.get((int)n).b;
        }

        public int getFillAlpha(int n) {
            return this.m_textureStyle.m_fill.get((int)n).a;
        }

        public int getTextureStops() {
            return this.m_textureStyle.m_texture.size();
        }

        public void setTextureZoom(int n, float f) {
            this.m_textureStyle.m_texture.get((int)n).m_zoom = PZMath.clamp(f, 0.0f, 24.0f);
        }

        public float getTextureZoom(int n) {
            return this.m_textureStyle.m_texture.get((int)n).m_zoom;
        }

        public void setTexturePath(int n, String string) {
            this.m_textureStyle.m_texture.get((int)n).texturePath = string;
            this.m_textureStyle.m_texture.get((int)n).texture = Texture.getTexture(string);
        }

        public String getTexturePath(int n) {
            return this.m_textureStyle.m_texture.get((int)n).texturePath;
        }

        public Texture getTexture(int n) {
            return this.m_textureStyle.m_texture.get((int)n).texture;
        }
    }

    public static class WorldMapStyleLayerV1 {
        WorldMapStyleV1 m_owner;
        WorldMapStyleLayer m_layer;

        WorldMapStyleLayerV1(WorldMapStyleV1 worldMapStyleV1, WorldMapStyleLayer worldMapStyleLayer) {
            this.m_owner = worldMapStyleV1;
            this.m_layer = worldMapStyleLayer;
            worldMapStyleV1.m_style.m_layers.add(this.m_layer);
        }

        public String getTypeString() {
            return this.m_layer.getTypeString();
        }

        public void setId(String string) {
            this.m_layer.m_id = string;
        }

        public String getId() {
            return this.m_layer.m_id;
        }

        public void setMinZoom(float f) {
            this.m_layer.m_minZoom = f;
        }

        public float getMinZoom() {
            return this.m_layer.m_minZoom;
        }
    }
}

