/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.styles;

import java.util.ArrayList;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.popman.ObjectPool;
import zombie.worldMap.WorldMapFeature;
import zombie.worldMap.WorldMapRenderer;

public abstract class WorldMapStyleLayer {
    public String m_id;
    public float m_minZoom = 0.0f;
    public IWorldMapStyleFilter m_filter;
    public String m_filterKey;
    public String m_filterValue;

    public WorldMapStyleLayer(String string) {
        this.m_id = string;
    }

    public abstract String getTypeString();

    static <S extends Stop> int findStop(float f, ArrayList<S> arrayList) {
        if (arrayList.isEmpty()) {
            return -2;
        }
        if (f <= ((Stop)arrayList.get((int)0)).m_zoom) {
            return -1;
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            if (!(f <= ((Stop)arrayList.get((int)(i + 1))).m_zoom)) continue;
            return i;
        }
        return arrayList.size() - 1;
    }

    protected RGBAf evalColor(RenderArgs renderArgs, ArrayList<ColorStop> arrayList) {
        if (arrayList.isEmpty()) {
            return RGBAf.s_pool.alloc().init(1.0f, 1.0f, 1.0f, 1.0f);
        }
        float f = renderArgs.drawer.m_zoomF;
        int n = WorldMapStyleLayer.findStop(f, arrayList);
        int n2 = n == -1 ? 0 : n;
        int n3 = PZMath.min(n + 1, arrayList.size() - 1);
        ColorStop colorStop = arrayList.get(n2);
        ColorStop colorStop2 = arrayList.get(n3);
        float f2 = n2 == n3 ? 1.0f : (PZMath.clamp(f, colorStop.m_zoom, colorStop2.m_zoom) - colorStop.m_zoom) / (colorStop2.m_zoom - colorStop.m_zoom);
        float f3 = PZMath.lerp(colorStop.r, colorStop2.r, f2) / 255.0f;
        float f4 = PZMath.lerp(colorStop.g, colorStop2.g, f2) / 255.0f;
        float f5 = PZMath.lerp(colorStop.b, colorStop2.b, f2) / 255.0f;
        float f6 = PZMath.lerp(colorStop.a, colorStop2.a, f2) / 255.0f;
        return RGBAf.s_pool.alloc().init(f3, f4, f5, f6);
    }

    protected float evalFloat(RenderArgs renderArgs, ArrayList<FloatStop> arrayList) {
        if (arrayList.isEmpty()) {
            return 1.0f;
        }
        float f = renderArgs.drawer.m_zoomF;
        int n = WorldMapStyleLayer.findStop(f, arrayList);
        int n2 = n == -1 ? 0 : n;
        int n3 = PZMath.min(n + 1, arrayList.size() - 1);
        FloatStop floatStop = arrayList.get(n2);
        FloatStop floatStop2 = arrayList.get(n3);
        float f2 = n2 == n3 ? 1.0f : (PZMath.clamp(f, floatStop.m_zoom, floatStop2.m_zoom) - floatStop.m_zoom) / (floatStop2.m_zoom - floatStop.m_zoom);
        return PZMath.lerp(floatStop.f, floatStop2.f, f2);
    }

    protected Texture evalTexture(RenderArgs renderArgs, ArrayList<TextureStop> arrayList) {
        TextureStop textureStop;
        if (arrayList.isEmpty()) {
            return null;
        }
        float f = renderArgs.drawer.m_zoomF;
        int n = WorldMapStyleLayer.findStop(f, arrayList);
        int n2 = n == -1 ? 0 : n;
        int n3 = PZMath.min(n + 1, arrayList.size() - 1);
        TextureStop textureStop2 = arrayList.get(n2);
        if (textureStop2 == (textureStop = arrayList.get(n3))) {
            return f < textureStop2.m_zoom ? null : textureStop2.texture;
        }
        if (f < textureStop2.m_zoom || f > textureStop.m_zoom) {
            return null;
        }
        float f2 = n2 == n3 ? 1.0f : (PZMath.clamp(f, textureStop2.m_zoom, textureStop.m_zoom) - textureStop2.m_zoom) / (textureStop.m_zoom - textureStop2.m_zoom);
        return f2 < 0.5f ? textureStop2.texture : textureStop.texture;
    }

    public boolean filter(WorldMapFeature worldMapFeature, FilterArgs filterArgs) {
        if (this.m_filter == null) {
            return false;
        }
        return this.m_filter.filter(worldMapFeature, filterArgs);
    }

    public abstract void render(WorldMapFeature var1, RenderArgs var2);

    public void renderCell(RenderArgs renderArgs) {
    }

    public static class Stop {
        public float m_zoom;

        Stop(float f) {
            this.m_zoom = f;
        }
    }

    public static final class RGBAf {
        public float r = 1.0f;
        public float g = 1.0f;
        public float b = 1.0f;
        public float a = 1.0f;
        public static final ObjectPool<RGBAf> s_pool = new ObjectPool<RGBAf>(RGBAf::new);

        public RGBAf init(float f, float f2, float f3, float f4) {
            this.r = f;
            this.g = f2;
            this.b = f3;
            this.a = f4;
            return this;
        }
    }

    public static final class RenderArgs {
        public WorldMapRenderer renderer;
        public WorldMapRenderer.Drawer drawer;
        public int cellX;
        public int cellY;
    }

    public static class ColorStop
    extends Stop {
        public int r;
        public int g;
        public int b;
        public int a;

        public ColorStop(float f, int n, int n2, int n3, int n4) {
            super(f);
            this.r = n;
            this.g = n2;
            this.b = n3;
            this.a = n4;
        }
    }

    public static class FloatStop
    extends Stop {
        public float f;

        public FloatStop(float f, float f2) {
            super(f);
            this.f = f2;
        }
    }

    public static class TextureStop
    extends Stop {
        public String texturePath;
        public Texture texture;

        public TextureStop(float f, String string) {
            super(f);
            this.texturePath = string;
            this.texture = Texture.getTexture(string);
        }
    }

    public static interface IWorldMapStyleFilter {
        public boolean filter(WorldMapFeature var1, FilterArgs var2);
    }

    public static final class FilterArgs {
        public WorldMapRenderer renderer;
    }
}

