/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.markers;

import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.markers.WorldMapMarker;

public final class WorldMapGridSquareMarker
extends WorldMapMarker {
    Texture m_texture1 = Texture.getSharedTexture("media/textures/worldMap/circle_center.png");
    Texture m_texture2 = Texture.getSharedTexture("media/textures/worldMap/circle_only_highlight.png");
    float m_r = 1.0f;
    float m_g = 1.0f;
    float m_b = 1.0f;
    float m_a = 1.0f;
    int m_worldX;
    int m_worldY;
    int m_radius = 10;
    int m_minScreenRadius = 64;
    boolean m_blink = true;

    WorldMapGridSquareMarker init(int n, int n2, int n3, float f, float f2, float f3, float f4) {
        this.m_worldX = n;
        this.m_worldY = n2;
        this.m_radius = n3;
        this.m_r = f;
        this.m_g = f2;
        this.m_b = f3;
        this.m_a = f4;
        return this;
    }

    public void setBlink(boolean bl) {
        this.m_blink = bl;
    }

    public void setMinScreenRadius(int n) {
        this.m_minScreenRadius = n;
    }

    @Override
    void render(UIWorldMap uIWorldMap) {
        float f = PZMath.max((float)this.m_radius, (float)this.m_minScreenRadius / uIWorldMap.getAPI().getWorldScale());
        float f2 = uIWorldMap.getAPI().worldToUIX((float)this.m_worldX - f, (float)this.m_worldY - f);
        float f3 = uIWorldMap.getAPI().worldToUIY((float)this.m_worldX - f, (float)this.m_worldY - f);
        float f4 = uIWorldMap.getAPI().worldToUIX((float)this.m_worldX + f, (float)this.m_worldY - f);
        float f5 = uIWorldMap.getAPI().worldToUIY((float)this.m_worldX + f, (float)this.m_worldY - f);
        float f6 = uIWorldMap.getAPI().worldToUIX((float)this.m_worldX + f, (float)this.m_worldY + f);
        float f7 = uIWorldMap.getAPI().worldToUIY((float)this.m_worldX + f, (float)this.m_worldY + f);
        float f8 = uIWorldMap.getAPI().worldToUIX((float)this.m_worldX - f, (float)this.m_worldY + f);
        float f9 = uIWorldMap.getAPI().worldToUIY((float)this.m_worldX - f, (float)this.m_worldY + f);
        f2 = (float)((double)f2 + uIWorldMap.getAbsoluteX());
        f3 = (float)((double)f3 + uIWorldMap.getAbsoluteY());
        f4 = (float)((double)f4 + uIWorldMap.getAbsoluteX());
        f5 = (float)((double)f5 + uIWorldMap.getAbsoluteY());
        f6 = (float)((double)f6 + uIWorldMap.getAbsoluteX());
        f7 = (float)((double)f7 + uIWorldMap.getAbsoluteY());
        f8 = (float)((double)f8 + uIWorldMap.getAbsoluteX());
        f9 = (float)((double)f9 + uIWorldMap.getAbsoluteY());
        float f10 = this.m_a * (this.m_blink ? Core.blinkAlpha : 1.0f);
        if (this.m_texture1 != null && this.m_texture1.isReady()) {
            SpriteRenderer.instance.render(this.m_texture1, f2, f3, f4, f5, f6, f7, f8, f9, this.m_r, this.m_g, this.m_b, f10, null);
        }
        if (this.m_texture2 != null && this.m_texture2.isReady()) {
            SpriteRenderer.instance.render(this.m_texture2, f2, f3, f4, f5, f6, f7, f8, f9, this.m_r, this.m_g, this.m_b, f10, null);
        }
    }
}

