/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;
import org.w3c.dom.Element;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.util.Lambda;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;
import zombie.util.SharedStrings;
import zombie.worldMap.WorldMapCell;
import zombie.worldMap.WorldMapData;
import zombie.worldMap.WorldMapFeature;
import zombie.worldMap.WorldMapGeometry;
import zombie.worldMap.WorldMapPoint;
import zombie.worldMap.WorldMapPoints;
import zombie.worldMap.WorldMapProperties;

public final class WorldMapXML {
    private final SharedStrings m_sharedStrings = new SharedStrings();
    private final WorldMapPoint m_point = new WorldMapPoint();
    private final WorldMapProperties m_properties = new WorldMapProperties();
    private final ArrayList<WorldMapProperties> m_sharedProperties = new ArrayList();

    public boolean read(String string, WorldMapData worldMapData) throws PZXmlParserException {
        Element element = PZXmlUtil.parseXml(string);
        if (element.getNodeName().equals("world")) {
            this.parseWorld(element, worldMapData);
            return true;
        }
        return false;
    }

    private void parseWorld(Element element2, WorldMapData worldMapData2) {
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, worldMapData2, (element, worldMapData) -> {
            if (!element.getNodeName().equals("cell")) {
                DebugLog.General.warn("Warning: Unrecognised element '" + element.getNodeName());
                return;
            }
            WorldMapCell worldMapCell = this.parseCell((Element)element);
            worldMapData.m_cells.add(worldMapCell);
        });
    }

    private WorldMapCell parseCell(Element element2) {
        WorldMapCell worldMapCell = new WorldMapCell();
        worldMapCell.m_x = PZMath.tryParseInt(element2.getAttribute("x"), 0);
        worldMapCell.m_y = PZMath.tryParseInt(element2.getAttribute("y"), 0);
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, worldMapCell, (element, worldMapCell2) -> {
            try {
                String string = element.getNodeName();
                if ("feature".equalsIgnoreCase(string)) {
                    WorldMapFeature worldMapFeature = this.parseFeature(worldMapCell, (Element)element);
                    worldMapCell2.m_features.add(worldMapFeature);
                }
            }
            catch (Exception exception) {
                DebugLog.General.error("Error while parsing xml element: " + element.getNodeName());
                DebugLog.General.error(exception);
            }
        });
        return worldMapCell;
    }

    private WorldMapFeature parseFeature(WorldMapCell worldMapCell, Element element2) {
        WorldMapFeature worldMapFeature2 = new WorldMapFeature(worldMapCell);
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, worldMapFeature2, (element, worldMapFeature) -> {
            try {
                String string = element.getNodeName();
                if ("geometry".equalsIgnoreCase(string)) {
                    WorldMapGeometry worldMapGeometry = this.parseGeometry((Element)element);
                    worldMapFeature.m_geometries.add(worldMapGeometry);
                }
                if ("properties".equalsIgnoreCase(string)) {
                    this.parseFeatureProperties((Element)element, (WorldMapFeature)worldMapFeature);
                }
            }
            catch (Exception exception) {
                DebugLog.General.error("Error while parsing xml element: " + element.getNodeName());
                DebugLog.General.error(exception);
            }
        });
        return worldMapFeature2;
    }

    private void parseFeatureProperties(Element element2, WorldMapFeature worldMapFeature2) {
        this.m_properties.clear();
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, worldMapFeature2, (element, worldMapFeature) -> {
            try {
                String string = element.getNodeName();
                if ("property".equalsIgnoreCase(string)) {
                    String string2 = this.m_sharedStrings.get(element.getAttribute("name"));
                    String string3 = this.m_sharedStrings.get(element.getAttribute("value"));
                    this.m_properties.put(string2, string3);
                }
            }
            catch (Exception exception) {
                DebugLog.General.error("Error while parsing xml element: " + element.getNodeName());
                DebugLog.General.error(exception);
            }
        });
        worldMapFeature2.m_properties = this.getOrCreateProperties(this.m_properties);
    }

    private WorldMapProperties getOrCreateProperties(WorldMapProperties worldMapProperties) {
        for (int i = 0; i < this.m_sharedProperties.size(); ++i) {
            if (!this.m_sharedProperties.get(i).equals(worldMapProperties)) continue;
            return this.m_sharedProperties.get(i);
        }
        WorldMapProperties worldMapProperties2 = new WorldMapProperties();
        worldMapProperties2.putAll(worldMapProperties);
        this.m_sharedProperties.add(worldMapProperties2);
        return worldMapProperties2;
    }

    private WorldMapGeometry parseGeometry(Element element2) {
        WorldMapGeometry worldMapGeometry2 = new WorldMapGeometry();
        worldMapGeometry2.m_type = WorldMapGeometry.Type.valueOf(element2.getAttribute("type"));
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, worldMapGeometry2, (element, worldMapGeometry) -> {
            try {
                String string = element.getNodeName();
                if ("coordinates".equalsIgnoreCase(string)) {
                    WorldMapPoints worldMapPoints = new WorldMapPoints();
                    this.parseGeometryCoordinates((Element)element, worldMapPoints);
                    worldMapGeometry.m_points.add(worldMapPoints);
                }
            }
            catch (Exception exception) {
                DebugLog.General.error("Error while parsing xml element: " + element.getNodeName());
                DebugLog.General.error(exception);
            }
        });
        worldMapGeometry2.calculateBounds();
        return worldMapGeometry2;
    }

    private void parseGeometryCoordinates(Element element2, WorldMapPoints worldMapPoints2) {
        Lambda.forEachFrom(PZXmlUtil::forEachElement, element2, worldMapPoints2, (element, worldMapPoints) -> {
            try {
                String string = element.getNodeName();
                if ("point".equalsIgnoreCase(string)) {
                    WorldMapPoint worldMapPoint = this.parsePoint((Element)element, this.m_point);
                    worldMapPoints.add(worldMapPoint.x);
                    worldMapPoints.add(worldMapPoint.y);
                }
            }
            catch (Exception exception) {
                DebugLog.General.error("Error while parsing xml element: " + element.getNodeName());
                DebugLog.General.error(exception);
            }
        });
    }

    private WorldMapPoint parsePoint(Element element, WorldMapPoint worldMapPoint) {
        worldMapPoint.x = PZMath.tryParseInt(element.getAttribute("x"), 0);
        worldMapPoint.y = PZMath.tryParseInt(element.getAttribute("y"), 0);
        return worldMapPoint;
    }
}

