/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.config.DoubleConfigOption;

public final class WorldMapSettings {
    public static int VERSION1;
    public static int VERSION;
    private static WorldMapSettings instance;
    final ArrayList<ConfigOption> m_options = new ArrayList();
    final WorldMap mWorldMap = new WorldMap();
    final MiniMap mMiniMap = new MiniMap();
    private int m_readVersion = 0;

    public static WorldMapSettings getInstance() {
        if (instance == null) {
            instance = new WorldMapSettings();
            instance.load();
        }
        return instance;
    }

    private BooleanConfigOption newOption(String string, boolean bl) {
        BooleanConfigOption booleanConfigOption = new BooleanConfigOption(string, bl);
        this.m_options.add(booleanConfigOption);
        return booleanConfigOption;
    }

    private DoubleConfigOption newOption(String string, double d, double d2, double d3) {
        DoubleConfigOption doubleConfigOption = new DoubleConfigOption(string, d, d2, d3);
        this.m_options.add(doubleConfigOption);
        return doubleConfigOption;
    }

    public ConfigOption getOptionByName(String string) {
        for (int i = 0; i < this.m_options.size(); ++i) {
            ConfigOption configOption = this.m_options.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getOptionCount() {
        return this.m_options.size();
    }

    public ConfigOption getOptionByIndex(int n) {
        return this.m_options.get(n);
    }

    public void setBoolean(String string, boolean bl) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            ((BooleanConfigOption)configOption).setValue(bl);
        }
    }

    public boolean getBoolean(String string) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            return ((BooleanConfigOption)configOption).getValue();
        }
        return false;
    }

    public void setDouble(String string, double d) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof DoubleConfigOption) {
            ((DoubleConfigOption)configOption).setValue(d);
        }
    }

    public double getDouble(String string, double d) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof DoubleConfigOption) {
            return ((DoubleConfigOption)configOption).getValue();
        }
        return d;
    }

    public int getFileVersion() {
        return this.m_readVersion;
    }

    public void save() {
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("InGameMap.ini");
        ConfigFile configFile = new ConfigFile();
        configFile.write(string, VERSION, this.m_options);
        this.m_readVersion = VERSION;
    }

    public void load() {
        this.m_readVersion = 0;
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("InGameMap.ini");
        if (!configFile.read(string)) {
            return;
        }
        this.m_readVersion = configFile.getVersion();
        if (this.m_readVersion < VERSION1 || this.m_readVersion > VERSION) {
            return;
        }
        for (int i = 0; i < configFile.getOptions().size(); ++i) {
            ConfigOption configOption = configFile.getOptions().get(i);
            try {
                ConfigOption configOption2 = this.getOptionByName(configOption.getName());
                if (configOption2 == null) continue;
                configOption2.parse(configOption.getValueAsString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        WorldMapSettings.instance.m_options.clear();
        instance = null;
    }

    static {
        VERSION = VERSION1 = 1;
    }

    public final class WorldMap {
        public DoubleConfigOption CenterX;
        public DoubleConfigOption CenterY;
        public DoubleConfigOption Zoom;
        public BooleanConfigOption Isometric;
        public BooleanConfigOption ShowSymbolsUI;

        public WorldMap() {
            this.CenterX = WorldMapSettings.this.newOption("WorldMap.CenterX", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.CenterY = WorldMapSettings.this.newOption("WorldMap.CenterY", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.Zoom = WorldMapSettings.this.newOption("WorldMap.Zoom", 0.0, 24.0, 0.0);
            this.Isometric = WorldMapSettings.this.newOption("WorldMap.Isometric", true);
            this.ShowSymbolsUI = WorldMapSettings.this.newOption("WorldMap.ShowSymbolsUI", true);
        }
    }

    public class MiniMap {
        public DoubleConfigOption Zoom;
        public BooleanConfigOption Isometric;
        public BooleanConfigOption ShowSymbols;
        public BooleanConfigOption StartVisible;

        public MiniMap() {
            this.Zoom = WorldMapSettings.this.newOption("MiniMap.Zoom", 0.0, 24.0, 19.0);
            this.Isometric = WorldMapSettings.this.newOption("MiniMap.Isometric", true);
            this.ShowSymbols = WorldMapSettings.this.newOption("MiniMap.ShowSymbols", false);
            this.StartVisible = WorldMapSettings.this.newOption("MiniMap.StartVisible", true);
        }
    }
}

