/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import zombie.asset.Asset;
import zombie.characters.IsoPlayer;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigOption;
import zombie.config.DoubleConfigOption;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.VBOLines;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureID;
import zombie.iso.IsoCamera;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.popman.ObjectPool;
import zombie.ui.UIManager;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.UI3DScene;
import zombie.worldMap.MapProjection;
import zombie.worldMap.Rasterize;
import zombie.worldMap.StrokeGeometry;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.VBOLinesUV;
import zombie.worldMap.WorldMap;
import zombie.worldMap.WorldMapCell;
import zombie.worldMap.WorldMapData;
import zombie.worldMap.WorldMapFeature;
import zombie.worldMap.WorldMapGeometry;
import zombie.worldMap.WorldMapImages;
import zombie.worldMap.WorldMapPoints;
import zombie.worldMap.WorldMapRenderLayer;
import zombie.worldMap.WorldMapVBOs;
import zombie.worldMap.WorldMapVisited;
import zombie.worldMap.styles.WorldMapStyle;
import zombie.worldMap.styles.WorldMapStyleLayer;
import zombie.worldMap.styles.WorldMapTextureStyleLayer;

public final class WorldMapRenderer {
    private WorldMap m_worldMap;
    private int m_x;
    private int m_y;
    private int m_width;
    private int m_height;
    private int m_zoom = 0;
    private float m_zoomF = 0.0f;
    private float m_displayZoomF = 0.0f;
    private float m_centerWorldX;
    private float m_centerWorldY;
    private float m_zoomUIX;
    private float m_zoomUIY;
    private float m_zoomWorldX;
    private float m_zoomWorldY;
    private final Matrix4f m_projection = new Matrix4f();
    private final Matrix4f m_modelView = new Matrix4f();
    private final Quaternionf m_modelViewChange = new Quaternionf();
    private long m_viewChangeTime;
    private static long VIEW_CHANGE_TIME = 350L;
    private boolean m_isometric;
    private boolean m_firstUpdate = false;
    private WorldMapVisited m_visited;
    private final Drawer[] m_drawer = new Drawer[3];
    private final CharacterModelCamera m_CharacterModelCamera = new CharacterModelCamera();
    private int m_dropShadowWidth = 12;
    public WorldMapStyle m_style = null;
    protected static final VBOLines m_vboLines = new VBOLines();
    protected static final VBOLinesUV m_vboLinesUV = new VBOLinesUV();
    private final int[] m_viewport = new int[]{0, 0, 0, 0};
    private static final ThreadLocal<ObjectPool<UI3DScene.Plane>> TL_Plane_pool = ThreadLocal.withInitial(UI3DScene.PlaneObjectPool::new);
    private static final ThreadLocal<ObjectPool<UI3DScene.Ray>> TL_Ray_pool = ThreadLocal.withInitial(UI3DScene.RayObjectPool::new);
    static final float SMALL_NUM = 1.0E-8f;
    private final ArrayList<ConfigOption> options = new ArrayList();
    private final WorldMapBooleanOption BlurUnvisited = new WorldMapBooleanOption("BlurUnvisited", true);
    private final WorldMapBooleanOption BuildingsWithoutFeatures = new WorldMapBooleanOption("BuildingsWithoutFeatures", false);
    private final WorldMapBooleanOption DebugInfo = new WorldMapBooleanOption("DebugInfo", false);
    private final WorldMapBooleanOption CellGrid = new WorldMapBooleanOption("CellGrid", false);
    private final WorldMapBooleanOption TileGrid = new WorldMapBooleanOption("TileGrid", false);
    private final WorldMapBooleanOption UnvisitedGrid = new WorldMapBooleanOption("UnvisitedGrid", true);
    private final WorldMapBooleanOption Features = new WorldMapBooleanOption("Features", true);
    private final WorldMapBooleanOption ForestZones = new WorldMapBooleanOption("ForestZones", false);
    private final WorldMapBooleanOption HideUnvisited = new WorldMapBooleanOption("HideUnvisited", false);
    private final WorldMapBooleanOption HitTest = new WorldMapBooleanOption("HitTest", false);
    private final WorldMapBooleanOption ImagePyramid = new WorldMapBooleanOption("ImagePyramid", false);
    private final WorldMapBooleanOption Isometric = new WorldMapBooleanOption("Isometric", true);
    private final WorldMapBooleanOption LineString = new WorldMapBooleanOption("LineString", true);
    private final WorldMapBooleanOption Players = new WorldMapBooleanOption("Players", false);
    private final WorldMapBooleanOption RemotePlayers = new WorldMapBooleanOption("RemotePlayers", false);
    private final WorldMapBooleanOption PlayerNames = new WorldMapBooleanOption("PlayerNames", false);
    private final WorldMapBooleanOption Symbols = new WorldMapBooleanOption("Symbols", true);
    private final WorldMapBooleanOption Wireframe = new WorldMapBooleanOption("Wireframe", false);
    private final WorldMapBooleanOption WorldBounds = new WorldMapBooleanOption("WorldBounds", true);
    private final WorldMapBooleanOption MiniMapSymbols = new WorldMapBooleanOption("MiniMapSymbols", false);
    private final WorldMapBooleanOption VisibleCells = new WorldMapBooleanOption("VisibleCells", false);

    public WorldMapRenderer() {
        PZArrayUtil.arrayPopulate(this.m_drawer, Drawer::new);
    }

    public int getAbsoluteX() {
        return this.m_x;
    }

    public int getAbsoluteY() {
        return this.m_y;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    private void calcMatrices(float f, float f2, float f3, Matrix4f matrix4f, Matrix4f matrix4f2) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        matrix4f.setOrtho((float)(-n) / 2.0f, (float)n / 2.0f, (float)n2 / 2.0f, (float)(-n2) / 2.0f, -2000.0f, 2000.0f);
        matrix4f2.identity();
        if (this.Isometric.getValue()) {
            matrix4f2.rotateXYZ(1.0471976f, 0.0f, 0.7853982f);
        }
    }

    public Vector3f uiToScene(float f, float f2, Matrix4f matrix4f, Matrix4f matrix4f2, Vector3f vector3f) {
        UI3DScene.Plane plane = WorldMapRenderer.allocPlane();
        plane.point.set(0.0f);
        plane.normal.set(0.0f, 0.0f, 1.0f);
        UI3DScene.Ray ray = this.getCameraRay(f, (float)this.getHeight() - f2, matrix4f, matrix4f2, WorldMapRenderer.allocRay());
        if (this.intersect_ray_plane(plane, ray, vector3f) != 1) {
            vector3f.set(0.0f);
        }
        WorldMapRenderer.releasePlane(plane);
        WorldMapRenderer.releaseRay(ray);
        return vector3f;
    }

    public Vector3f sceneToUI(float f, float f2, float f3, Matrix4f matrix4f, Matrix4f matrix4f2, Vector3f vector3f) {
        Matrix4f matrix4f3 = WorldMapRenderer.allocMatrix4f();
        matrix4f3.set((Matrix4fc)matrix4f);
        matrix4f3.mul((Matrix4fc)matrix4f2);
        this.m_viewport[0] = 0;
        this.m_viewport[1] = 0;
        this.m_viewport[2] = this.getWidth();
        this.m_viewport[3] = this.getHeight();
        matrix4f3.project(f, f2, f3, this.m_viewport, vector3f);
        WorldMapRenderer.releaseMatrix4f(matrix4f3);
        return vector3f;
    }

    public float uiToWorldX(float f, float f2, float f3, float f4, float f5) {
        Matrix4f matrix4f = WorldMapRenderer.allocMatrix4f();
        Matrix4f matrix4f2 = WorldMapRenderer.allocMatrix4f();
        this.calcMatrices(f4, f5, f3, matrix4f, matrix4f2);
        float f6 = this.uiToWorldX(f, f2, f3, f4, f5, matrix4f, matrix4f2);
        WorldMapRenderer.releaseMatrix4f(matrix4f);
        WorldMapRenderer.releaseMatrix4f(matrix4f2);
        return f6;
    }

    public float uiToWorldY(float f, float f2, float f3, float f4, float f5) {
        Matrix4f matrix4f = WorldMapRenderer.allocMatrix4f();
        Matrix4f matrix4f2 = WorldMapRenderer.allocMatrix4f();
        this.calcMatrices(f4, f5, f3, matrix4f, matrix4f2);
        float f6 = this.uiToWorldY(f, f2, f3, f4, f5, matrix4f, matrix4f2);
        WorldMapRenderer.releaseMatrix4f(matrix4f);
        WorldMapRenderer.releaseMatrix4f(matrix4f2);
        return f6;
    }

    public float uiToWorldX(float f, float f2, float f3, float f4, float f5, Matrix4f matrix4f, Matrix4f matrix4f2) {
        Vector3f vector3f = this.uiToScene(f, f2, matrix4f, matrix4f2, WorldMapRenderer.allocVector3f());
        float f6 = this.getWorldScale(f3);
        vector3f.mul(1.0f / f6);
        float f7 = vector3f.x() + f4;
        WorldMapRenderer.releaseVector3f(vector3f);
        return f7;
    }

    public float uiToWorldY(float f, float f2, float f3, float f4, float f5, Matrix4f matrix4f, Matrix4f matrix4f2) {
        Vector3f vector3f = this.uiToScene(f, f2, matrix4f, matrix4f2, WorldMapRenderer.allocVector3f());
        float f6 = this.getWorldScale(f3);
        vector3f.mul(1.0f / f6);
        float f7 = vector3f.y() + f5;
        WorldMapRenderer.releaseVector3f(vector3f);
        return f7;
    }

    public float worldToUIX(float f, float f2, float f3, float f4, float f5, Matrix4f matrix4f, Matrix4f matrix4f2) {
        float f6 = this.getWorldScale(f3);
        Vector3f vector3f = this.sceneToUI((f - f4) * f6, (f2 - f5) * f6, 0.0f, matrix4f, matrix4f2, WorldMapRenderer.allocVector3f());
        float f7 = vector3f.x();
        WorldMapRenderer.releaseVector3f(vector3f);
        return f7;
    }

    public float worldToUIY(float f, float f2, float f3, float f4, float f5, Matrix4f matrix4f, Matrix4f matrix4f2) {
        float f6 = this.getWorldScale(f3);
        Vector3f vector3f = this.sceneToUI((f - f4) * f6, (f2 - f5) * f6, 0.0f, matrix4f, matrix4f2, WorldMapRenderer.allocVector3f());
        float f7 = (float)this.getHeight() - vector3f.y();
        WorldMapRenderer.releaseVector3f(vector3f);
        return f7;
    }

    public float worldOriginUIX(float f, float f2) {
        return this.worldToUIX(0.0f, 0.0f, f, f2, this.m_centerWorldY, this.m_projection, this.m_modelView);
    }

    public float worldOriginUIY(float f, float f2) {
        return this.worldToUIY(0.0f, 0.0f, f, this.m_centerWorldX, f2, this.m_projection, this.m_modelView);
    }

    public int getZoom() {
        return this.m_zoom;
    }

    public float getZoomF() {
        return this.m_zoomF;
    }

    public float getDisplayZoomF() {
        return this.m_displayZoomF;
    }

    public float zoomMult() {
        return this.zoomMult(this.m_zoomF);
    }

    public float zoomMult(float f) {
        return (float)Math.pow(2.0, f);
    }

    public float getWorldScale(float f) {
        int n = this.getHeight();
        double d = MapProjection.metersPerPixelAtZoom(f, n);
        return (float)(1.0 / d);
    }

    public void zoomAt(int n, int n2, int n3) {
        float f = this.uiToWorldX(n, n2, this.m_displayZoomF, this.m_centerWorldX, this.m_centerWorldY);
        float f2 = this.uiToWorldY(n, n2, this.m_displayZoomF, this.m_centerWorldX, this.m_centerWorldY);
        this.m_zoomF = PZMath.clamp(this.m_zoomF + (float)n3 / 2.0f, this.getBaseZoom(), 24.0f);
        this.m_zoom = (int)this.m_zoomF;
        this.m_zoomWorldX = f;
        this.m_zoomWorldY = f2;
        this.m_zoomUIX = n;
        this.m_zoomUIY = n2;
    }

    public float getCenterWorldX() {
        return this.m_centerWorldX;
    }

    public float getCenterWorldY() {
        return this.m_centerWorldY;
    }

    public void centerOn(float f, float f2) {
        this.m_centerWorldX = f;
        this.m_centerWorldY = f2;
        if (this.m_displayZoomF != this.m_zoomF) {
            this.m_zoomWorldX = f;
            this.m_zoomWorldY = f2;
            this.m_zoomUIX = (float)this.m_width / 2.0f;
            this.m_zoomUIY = (float)this.m_height / 2.0f;
        }
    }

    public void moveView(int n, int n2) {
        this.centerOn(this.m_centerWorldX + (float)n, this.m_centerWorldY + (float)n2);
    }

    public double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public float getBaseZoom() {
        double d = MapProjection.zoomAtMetersPerPixel((double)this.m_worldMap.getHeightInSquares() / (double)this.getHeight(), this.getHeight());
        if ((float)this.m_worldMap.getWidthInSquares() * this.getWorldScale((float)d) > (float)this.getWidth()) {
            d = MapProjection.zoomAtMetersPerPixel((double)this.m_worldMap.getWidthInSquares() / (double)this.getWidth(), this.getHeight());
        }
        d = (double)((int)(d * 2.0)) / 2.0;
        return (float)d;
    }

    public void setZoom(float f) {
        this.m_zoomF = PZMath.clamp(f, this.getBaseZoom(), 24.0f);
        this.m_zoom = (int)this.m_zoomF;
        this.m_displayZoomF = this.m_zoomF;
    }

    public void resetView() {
        this.m_zoomF = this.getBaseZoom();
        this.m_zoom = (int)this.m_zoomF;
        this.m_centerWorldX = (float)this.m_worldMap.getMinXInSquares() + (float)this.m_worldMap.getWidthInSquares() / 2.0f;
        this.m_centerWorldY = (float)this.m_worldMap.getMinYInSquares() + (float)this.m_worldMap.getHeightInSquares() / 2.0f;
        this.m_zoomWorldX = this.m_centerWorldX;
        this.m_zoomWorldY = this.m_centerWorldY;
        this.m_zoomUIX = (float)this.getWidth() / 2.0f;
        this.m_zoomUIY = (float)this.getHeight() / 2.0f;
    }

    public Matrix4f getProjectionMatrix() {
        return this.m_projection;
    }

    public Matrix4f getModelViewMatrix() {
        return this.m_modelView;
    }

    public void setMap(WorldMap worldMap, int n, int n2, int n3, int n4) {
        this.m_worldMap = worldMap;
        this.m_x = n;
        this.m_y = n2;
        this.m_width = n3;
        this.m_height = n4;
    }

    public WorldMap getWorldMap() {
        return this.m_worldMap;
    }

    public void setVisited(WorldMapVisited worldMapVisited) {
        this.m_visited = worldMapVisited;
    }

    public void updateView() {
        float f;
        if (this.m_displayZoomF != this.m_zoomF) {
            float f2 = (float)(UIManager.getMillisSinceLastRender() / 750.0);
            float f3 = Math.abs(this.m_zoomF - this.m_displayZoomF);
            float f4 = f = f3 > 0.25f ? f3 / 0.25f : 1.0f;
            if (this.m_displayZoomF < this.m_zoomF) {
                this.m_displayZoomF = PZMath.min(this.m_displayZoomF + f2 * f, this.m_zoomF);
            } else if (this.m_displayZoomF > this.m_zoomF) {
                this.m_displayZoomF = PZMath.max(this.m_displayZoomF - f2 * f, this.m_zoomF);
            }
            float f5 = this.uiToWorldX(this.m_zoomUIX, this.m_zoomUIY, this.m_displayZoomF, 0.0f, 0.0f);
            float f6 = this.uiToWorldY(this.m_zoomUIX, this.m_zoomUIY, this.m_displayZoomF, 0.0f, 0.0f);
            this.m_centerWorldX = this.m_zoomWorldX - f5;
            this.m_centerWorldY = this.m_zoomWorldY - f6;
        }
        if (!this.m_firstUpdate) {
            this.m_firstUpdate = true;
            this.m_isometric = this.Isometric.getValue();
        }
        if (this.m_isometric != this.Isometric.getValue()) {
            this.m_isometric = this.Isometric.getValue();
            long l = System.currentTimeMillis();
            if (this.m_viewChangeTime + VIEW_CHANGE_TIME < l) {
                this.m_modelViewChange.setFromUnnormalized((Matrix4fc)this.m_modelView);
            }
            this.m_viewChangeTime = l;
        }
        this.calcMatrices(this.m_centerWorldX, this.m_centerWorldY, this.m_displayZoomF, this.m_projection, this.m_modelView);
        long l = System.currentTimeMillis();
        if (this.m_viewChangeTime + VIEW_CHANGE_TIME > l) {
            f = (float)(this.m_viewChangeTime + VIEW_CHANGE_TIME - l) / (float)VIEW_CHANGE_TIME;
            Quaternionf quaternionf = WorldMapRenderer.allocQuaternionf().setFromUnnormalized((Matrix4fc)this.m_modelView);
            this.m_modelView.set((Quaternionfc)this.m_modelViewChange.slerp((Quaternionfc)quaternionf, 1.0f - f));
            WorldMapRenderer.releaseQuaternionf(quaternionf);
        }
    }

    public void render(UIWorldMap uIWorldMap) {
        this.m_style = uIWorldMap.getAPI().getStyle();
        int n = SpriteRenderer.instance.getMainStateIndex();
        this.m_drawer[n].init(this, uIWorldMap);
        SpriteRenderer.instance.drawGeneric(this.m_drawer[n]);
    }

    public void setDropShadowWidth(int n) {
        this.m_dropShadowWidth = n;
    }

    private static Matrix4f allocMatrix4f() {
        return (Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
    }

    private static void releaseMatrix4f(Matrix4f matrix4f) {
        BaseVehicle.TL_matrix4f_pool.get().release(matrix4f);
    }

    private static Quaternionf allocQuaternionf() {
        return (Quaternionf)BaseVehicle.TL_quaternionf_pool.get().alloc();
    }

    private static void releaseQuaternionf(Quaternionf quaternionf) {
        BaseVehicle.TL_quaternionf_pool.get().release(quaternionf);
    }

    private static UI3DScene.Ray allocRay() {
        return TL_Ray_pool.get().alloc();
    }

    private static void releaseRay(UI3DScene.Ray ray) {
        TL_Ray_pool.get().release(ray);
    }

    private static UI3DScene.Plane allocPlane() {
        return TL_Plane_pool.get().alloc();
    }

    private static void releasePlane(UI3DScene.Plane plane) {
        TL_Plane_pool.get().release(plane);
    }

    private static Vector2 allocVector2() {
        return (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
    }

    private static void releaseVector2(Vector2 vector22) {
        BaseVehicle.TL_vector2_pool.get().release(vector22);
    }

    private static Vector3f allocVector3f() {
        return (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
    }

    private static void releaseVector3f(Vector3f vector3f) {
        BaseVehicle.TL_vector3f_pool.get().release(vector3f);
    }

    UI3DScene.Ray getCameraRay(float f, float f2, UI3DScene.Ray ray) {
        return this.getCameraRay(f, f2, this.m_projection, this.m_modelView, ray);
    }

    UI3DScene.Ray getCameraRay(float f, float f2, Matrix4f matrix4f, Matrix4f matrix4f2, UI3DScene.Ray ray) {
        Matrix4f matrix4f3 = WorldMapRenderer.allocMatrix4f();
        matrix4f3.set((Matrix4fc)matrix4f);
        matrix4f3.mul((Matrix4fc)matrix4f2);
        matrix4f3.invert();
        this.m_viewport[0] = 0;
        this.m_viewport[1] = 0;
        this.m_viewport[2] = this.getWidth();
        this.m_viewport[3] = this.getHeight();
        Vector3f vector3f = matrix4f3.unprojectInv(f, f2, 0.0f, this.m_viewport, WorldMapRenderer.allocVector3f());
        Vector3f vector3f2 = matrix4f3.unprojectInv(f, f2, 1.0f, this.m_viewport, WorldMapRenderer.allocVector3f());
        ray.origin.set((Vector3fc)vector3f);
        ray.direction.set((Vector3fc)vector3f2.sub((Vector3fc)vector3f).normalize());
        WorldMapRenderer.releaseVector3f(vector3f2);
        WorldMapRenderer.releaseVector3f(vector3f);
        WorldMapRenderer.releaseMatrix4f(matrix4f3);
        return ray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int intersect_ray_plane(UI3DScene.Plane plane, UI3DScene.Ray ray, Vector3f vector3f) {
        Vector3f vector3f2 = WorldMapRenderer.allocVector3f().set((Vector3fc)ray.direction).mul(10000.0f);
        Vector3f vector3f3 = WorldMapRenderer.allocVector3f().set((Vector3fc)ray.origin).sub((Vector3fc)plane.point);
        try {
            float f = plane.normal.dot((Vector3fc)vector3f2);
            float f2 = -plane.normal.dot((Vector3fc)vector3f3);
            if (Math.abs(f) < 1.0E-8f) {
                if (f2 == 0.0f) {
                    int n = 2;
                    return n;
                }
                int n = 0;
                return n;
            }
            float f3 = f2 / f;
            if (f3 < 0.0f || f3 > 1.0f) {
                int n = 0;
                return n;
            }
            vector3f.set((Vector3fc)ray.origin).add((Vector3fc)vector3f2.mul(f3));
            int n = 1;
            return n;
        }
        finally {
            WorldMapRenderer.releaseVector3f(vector3f2);
            WorldMapRenderer.releaseVector3f(vector3f3);
        }
    }

    public ConfigOption getOptionByName(String string) {
        for (int i = 0; i < this.options.size(); ++i) {
            ConfigOption configOption = this.options.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public ConfigOption getOptionByIndex(int n) {
        return this.options.get(n);
    }

    public void setBoolean(String string, boolean bl) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            ((BooleanConfigOption)configOption).setValue(bl);
        }
    }

    public boolean getBoolean(String string) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            return ((BooleanConfigOption)configOption).getValue();
        }
        return false;
    }

    public void setDouble(String string, double d) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof DoubleConfigOption) {
            ((DoubleConfigOption)configOption).setValue(d);
        }
    }

    public double getDouble(String string, double d) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof DoubleConfigOption) {
            return ((DoubleConfigOption)configOption).getValue();
        }
        return d;
    }

    public static final class Drawer
    extends TextureDraw.GenericDrawer {
        WorldMapRenderer m_renderer;
        final WorldMapStyle m_style = new WorldMapStyle();
        WorldMap m_worldMap;
        int m_x;
        int m_y;
        int m_width;
        int m_height;
        float m_centerWorldX;
        float m_centerWorldY;
        int m_zoom = 0;
        public float m_zoomF = 0.0f;
        float m_worldScale;
        float m_renderOriginX;
        float m_renderOriginY;
        float m_renderCellX;
        float m_renderCellY;
        private final Matrix4f m_projection = new Matrix4f();
        private final Matrix4f m_modelView = new Matrix4f();
        private final PlayerRenderData[] m_playerRenderData = new PlayerRenderData[4];
        final WorldMapStyleLayer.FilterArgs m_filterArgs = new WorldMapStyleLayer.FilterArgs();
        final WorldMapStyleLayer.RenderArgs m_renderArgs = new WorldMapStyleLayer.RenderArgs();
        final ArrayList<WorldMapRenderLayer> m_renderLayers = new ArrayList();
        final ArrayList<WorldMapFeature> m_features = new ArrayList();
        final ArrayList<IsoMetaGrid.Zone> m_zones = new ArrayList();
        final HashSet<IsoMetaGrid.Zone> m_zoneSet = new HashSet();
        WorldMapStyleLayer.RGBAf m_fill;
        int m_triangulationsThisFrame = 0;
        float[] m_floatArray;
        final Vector2f m_vector2f = new Vector2f();
        final TIntArrayList m_rasterizeXY = new TIntArrayList();
        final TIntSet m_rasterizeSet = new TIntHashSet();
        float m_rasterizeMinTileX;
        float m_rasterizeMinTileY;
        float m_rasterizeMaxTileX;
        float m_rasterizeMaxTileY;
        final Rasterize m_rasterize = new Rasterize();
        int[] m_rasterizeXY_ints;
        int m_rasterizeMult = 1;

        Drawer() {
            PZArrayUtil.arrayPopulate(this.m_playerRenderData, PlayerRenderData::new);
        }

        void init(WorldMapRenderer worldMapRenderer, UIWorldMap uIWorldMap) {
            int n;
            this.m_renderer = worldMapRenderer;
            this.m_style.copyFrom(this.m_renderer.m_style);
            this.m_worldMap = worldMapRenderer.m_worldMap;
            this.m_x = worldMapRenderer.m_x;
            this.m_y = worldMapRenderer.m_y;
            this.m_width = worldMapRenderer.m_width;
            this.m_height = worldMapRenderer.m_height;
            this.m_centerWorldX = worldMapRenderer.m_centerWorldX;
            this.m_centerWorldY = worldMapRenderer.m_centerWorldY;
            this.m_zoomF = worldMapRenderer.m_displayZoomF;
            this.m_zoom = (int)this.m_zoomF;
            this.m_worldScale = this.getWorldScale();
            this.m_renderOriginX = ((float)this.m_renderer.m_worldMap.getMinXInSquares() - this.m_centerWorldX) * this.m_worldScale;
            this.m_renderOriginY = ((float)this.m_renderer.m_worldMap.getMinYInSquares() - this.m_centerWorldY) * this.m_worldScale;
            this.m_projection.set((Matrix4fc)worldMapRenderer.m_projection);
            this.m_modelView.set((Matrix4fc)worldMapRenderer.m_modelView);
            this.m_fill = uIWorldMap.m_color;
            this.m_triangulationsThisFrame = 0;
            if (this.m_renderer.m_visited != null) {
                this.m_renderer.m_visited.renderMain();
            }
            for (n = 0; n < 4; ++n) {
                this.m_playerRenderData[n].m_modelSlotRenderData = null;
            }
            if (this.m_renderer.Players.getValue() && this.m_zoomF >= 20.0f) {
                for (n = 0; n < 4; ++n) {
                    IsoPlayer isoPlayer = IsoPlayer.players[n];
                    if (isoPlayer == null || isoPlayer.isDead() || !isoPlayer.legsSprite.hasActiveModel()) continue;
                    float f = isoPlayer.x;
                    float f2 = isoPlayer.y;
                    if (isoPlayer.getVehicle() != null) {
                        f = isoPlayer.getVehicle().getX();
                        f2 = isoPlayer.getVehicle().getY();
                    }
                    float f3 = this.m_renderer.worldToUIX(f, f2, this.m_zoomF, this.m_centerWorldX, this.m_centerWorldY, this.m_projection, this.m_modelView);
                    float f4 = this.m_renderer.worldToUIY(f, f2, this.m_zoomF, this.m_centerWorldX, this.m_centerWorldY, this.m_projection, this.m_modelView);
                    if (f3 < -100.0f || f3 > (float)(this.m_width + 100) || f4 < -100.0f || f4 > (float)(this.m_height + 100)) continue;
                    this.m_playerRenderData[n].m_angle = isoPlayer.getVehicle() == null ? isoPlayer.getAnimationPlayer().getAngle() : 4.712389f;
                    this.m_playerRenderData[n].m_x = f - this.m_centerWorldX;
                    this.m_playerRenderData[n].m_y = f2 - this.m_centerWorldY;
                    isoPlayer.legsSprite.modelSlot.model.updateLights();
                    int n2 = IsoCamera.frameState.playerIndex;
                    IsoCamera.frameState.playerIndex = n;
                    isoPlayer.checkUpdateModelTextures();
                    this.m_playerRenderData[n].m_modelSlotRenderData = ModelSlotRenderData.alloc().init(isoPlayer.legsSprite.modelSlot);
                    this.m_playerRenderData[n].m_modelSlotRenderData.centerOfMassY = 0.0f;
                    IsoCamera.frameState.playerIndex = n2;
                    ++isoPlayer.legsSprite.modelSlot.renderRefCount;
                }
            }
        }

        public int getAbsoluteX() {
            return this.m_x;
        }

        public int getAbsoluteY() {
            return this.m_y;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public float getWorldScale() {
            return this.m_renderer.getWorldScale(this.m_zoomF);
        }

        public float uiToWorldX(float f, float f2) {
            return this.m_renderer.uiToWorldX(f, f2, this.m_zoomF, this.m_centerWorldX, this.m_centerWorldY, this.m_projection, this.m_modelView);
        }

        public float uiToWorldY(float f, float f2) {
            return this.m_renderer.uiToWorldY(f, f2, this.m_zoomF, this.m_centerWorldX, this.m_centerWorldY, this.m_projection, this.m_modelView);
        }

        public float worldOriginUIX(float f) {
            return this.m_renderer.worldOriginUIX(this.m_zoomF, f);
        }

        public float worldOriginUIY(float f) {
            return this.m_renderer.worldOriginUIY(this.m_zoomF, f);
        }

        private void renderCellFeatures() {
            for (int i = 0; i < this.m_rasterizeXY.size() - 1; i += 2) {
                Object object;
                int n;
                int n2 = this.m_rasterizeXY_ints[i];
                int n3 = this.m_rasterizeXY_ints[i + 1];
                if (this.m_renderer.m_visited != null && !this.m_renderer.m_visited.isCellVisible(n2, n3)) continue;
                this.m_features.clear();
                for (n = 0; n < this.m_worldMap.m_data.size(); ++n) {
                    WorldMapCell worldMapCell;
                    object = this.m_worldMap.m_data.get(n);
                    if (!((Asset)object).isReady() || (worldMapCell = ((WorldMapData)object).getCell(n2, n3)) == null || worldMapCell.m_features.isEmpty()) continue;
                    this.m_features.addAll(worldMapCell.m_features);
                    if (this.m_worldMap.isLastDataInDirectory((WorldMapData)object)) break;
                }
                if (this.m_features.isEmpty()) {
                    this.m_renderArgs.renderer = this.m_renderer;
                    this.m_renderArgs.drawer = this;
                    this.m_renderArgs.cellX = n2;
                    this.m_renderArgs.cellY = n3;
                    this.m_renderCellX = this.m_renderOriginX + (float)(n2 * 300 - this.m_worldMap.getMinXInSquares()) * this.m_worldScale;
                    this.m_renderCellY = this.m_renderOriginY + (float)(n3 * 300 - this.m_worldMap.getMinYInSquares()) * this.m_worldScale;
                    for (n = 0; n < this.m_style.m_layers.size(); ++n) {
                        object = this.m_style.m_layers.get(n);
                        if (!(object instanceof WorldMapTextureStyleLayer)) continue;
                        ((WorldMapStyleLayer)object).renderCell(this.m_renderArgs);
                    }
                    continue;
                }
                this.renderCell(n2, n3, this.m_features);
            }
        }

        private void renderCell(int n, int n2, ArrayList<WorldMapFeature> arrayList) {
            this.m_renderCellX = this.m_renderOriginX + (float)(n * 300 - this.m_worldMap.getMinXInSquares()) * this.m_worldScale;
            this.m_renderCellY = this.m_renderOriginY + (float)(n2 * 300 - this.m_worldMap.getMinYInSquares()) * this.m_worldScale;
            WorldMapRenderLayer.s_pool.release((List<WorldMapRenderLayer>)this.m_renderLayers);
            this.m_renderLayers.clear();
            this.m_filterArgs.renderer = this.m_renderer;
            this.filterFeatures(arrayList, this.m_filterArgs, this.m_renderLayers);
            this.m_renderArgs.renderer = this.m_renderer;
            this.m_renderArgs.drawer = this;
            this.m_renderArgs.cellX = n;
            this.m_renderArgs.cellY = n2;
            for (int i = 0; i < this.m_renderLayers.size(); ++i) {
                WorldMapRenderLayer worldMapRenderLayer = this.m_renderLayers.get(i);
                worldMapRenderLayer.m_styleLayer.renderCell(this.m_renderArgs);
                for (int j = 0; j < worldMapRenderLayer.m_features.size(); ++j) {
                    WorldMapFeature worldMapFeature = worldMapRenderLayer.m_features.get(j);
                    worldMapRenderLayer.m_styleLayer.render(worldMapFeature, this.m_renderArgs);
                }
            }
        }

        void filterFeatures(ArrayList<WorldMapFeature> arrayList, WorldMapStyleLayer.FilterArgs filterArgs, ArrayList<WorldMapRenderLayer> arrayList2) {
            for (int i = 0; i < this.m_style.m_layers.size(); ++i) {
                WorldMapStyleLayer worldMapStyleLayer = this.m_style.m_layers.get(i);
                if (worldMapStyleLayer.m_minZoom > this.m_zoomF) continue;
                if (worldMapStyleLayer.m_id.equals("mylayer")) {
                    boolean bl = true;
                }
                WorldMapRenderLayer worldMapRenderLayer = null;
                if (worldMapStyleLayer instanceof WorldMapTextureStyleLayer) {
                    worldMapRenderLayer = WorldMapRenderLayer.s_pool.alloc();
                    worldMapRenderLayer.m_styleLayer = worldMapStyleLayer;
                    worldMapRenderLayer.m_features.clear();
                    arrayList2.add(worldMapRenderLayer);
                    continue;
                }
                for (int j = 0; j < arrayList.size(); ++j) {
                    WorldMapFeature worldMapFeature = arrayList.get(j);
                    if (!worldMapStyleLayer.filter(worldMapFeature, filterArgs)) continue;
                    if (worldMapRenderLayer == null) {
                        worldMapRenderLayer = WorldMapRenderLayer.s_pool.alloc();
                        worldMapRenderLayer.m_styleLayer = worldMapStyleLayer;
                        worldMapRenderLayer.m_features.clear();
                        arrayList2.add(worldMapRenderLayer);
                    }
                    worldMapRenderLayer.m_features.add(worldMapFeature);
                }
            }
        }

        void renderCellGrid(int n, int n2, int n3, int n4) {
            int n5;
            float f = this.m_renderOriginX + (float)(n * 300 - this.m_worldMap.getMinXInSquares()) * this.m_worldScale;
            float f2 = this.m_renderOriginY + (float)(n2 * 300 - this.m_worldMap.getMinYInSquares()) * this.m_worldScale;
            float f3 = f + (float)((n3 - n + 1) * 300) * this.m_worldScale;
            float f4 = f2 + (float)((n4 - n2 + 1) * 300) * this.m_worldScale;
            m_vboLines.setMode(1);
            m_vboLines.setLineWidth(1.0f);
            for (n5 = n; n5 <= n3 + 1; ++n5) {
                m_vboLines.addLine(this.m_renderOriginX + (float)(n5 * 300 - this.m_worldMap.getMinXInSquares()) * this.m_worldScale, f2, 0.0f, this.m_renderOriginX + (float)(n5 * 300 - this.m_worldMap.getMinXInSquares()) * this.m_worldScale, f4, 0.0f, 0.25f, 0.25f, 0.25f, 1.0f);
            }
            for (n5 = n2; n5 <= n4 + 1; ++n5) {
                m_vboLines.addLine(f, this.m_renderOriginY + (float)(n5 * 300 - this.m_worldMap.getMinYInSquares()) * this.m_worldScale, 0.0f, f3, this.m_renderOriginY + (float)(n5 * 300 - this.m_worldMap.getMinYInSquares()) * this.m_worldScale, 0.0f, 0.25f, 0.25f, 0.25f, 1.0f);
            }
            m_vboLines.flush();
        }

        void renderPlayers() {
            boolean bl = true;
            for (int i = 0; i < this.m_playerRenderData.length; ++i) {
                PlayerRenderData playerRenderData = this.m_playerRenderData[i];
                if (playerRenderData.m_modelSlotRenderData == null) continue;
                if (bl) {
                    GL11.glClear((int)256);
                    bl = false;
                }
                this.m_renderer.m_CharacterModelCamera.m_worldScale = this.m_worldScale;
                this.m_renderer.m_CharacterModelCamera.m_bUseWorldIso = true;
                this.m_renderer.m_CharacterModelCamera.m_angle = playerRenderData.m_angle;
                this.m_renderer.m_CharacterModelCamera.m_playerX = playerRenderData.m_x;
                this.m_renderer.m_CharacterModelCamera.m_playerY = playerRenderData.m_y;
                this.m_renderer.m_CharacterModelCamera.m_bVehicle = playerRenderData.m_modelSlotRenderData.bInVehicle;
                ModelCamera.instance = this.m_renderer.m_CharacterModelCamera;
                playerRenderData.m_modelSlotRenderData.render();
            }
            if (UIManager.useUIFBO) {
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        }

        public void drawLineStringXXX(WorldMapStyleLayer.RenderArgs renderArgs, WorldMapFeature worldMapFeature, WorldMapStyleLayer.RGBAf rGBAf, float f) {
            float f2 = this.m_renderCellX;
            float f3 = this.m_renderCellY;
            float f4 = this.m_worldScale;
            float f5 = rGBAf.r;
            float f6 = rGBAf.g;
            float f7 = rGBAf.b;
            float f8 = rGBAf.a;
            block3: for (int i = 0; i < worldMapFeature.m_geometries.size(); ++i) {
                WorldMapGeometry worldMapGeometry = worldMapFeature.m_geometries.get(i);
                switch (worldMapGeometry.m_type) {
                    case LineString: {
                        m_vboLines.setMode(1);
                        m_vboLines.setLineWidth(f);
                        for (int j = 0; j < worldMapGeometry.m_points.size(); ++j) {
                            WorldMapPoints worldMapPoints = worldMapGeometry.m_points.get(j);
                            for (int k = 0; k < worldMapPoints.numPoints() - 1; ++k) {
                                float f9 = worldMapPoints.getX(k);
                                float f10 = worldMapPoints.getY(k);
                                float f11 = worldMapPoints.getX(k + 1);
                                float f12 = worldMapPoints.getY(k + 1);
                                m_vboLines.addLine(f2 + f9 * f4, f3 + f10 * f4, 0.0f, f2 + f11 * f4, f3 + f12 * f4, 0.0f, f5, f6, f7, f8);
                            }
                        }
                        continue block3;
                    }
                }
            }
        }

        public void drawLineStringYYY(WorldMapStyleLayer.RenderArgs renderArgs, WorldMapFeature worldMapFeature, WorldMapStyleLayer.RGBAf rGBAf, float f) {
            float f2 = this.m_renderCellX;
            float f3 = this.m_renderCellY;
            float f4 = this.m_worldScale;
            float f5 = rGBAf.r;
            float f6 = rGBAf.g;
            float f7 = rGBAf.b;
            float f8 = rGBAf.a;
            block3: for (int i = 0; i < worldMapFeature.m_geometries.size(); ++i) {
                WorldMapGeometry worldMapGeometry = worldMapFeature.m_geometries.get(i);
                switch (worldMapGeometry.m_type) {
                    case LineString: {
                        StrokeGeometry.Point[] pointArray = new StrokeGeometry.Point[worldMapGeometry.m_points.size()];
                        WorldMapPoints worldMapPoints = worldMapGeometry.m_points.get(0);
                        for (int j = 0; j < worldMapPoints.numPoints(); ++j) {
                            float f9 = worldMapPoints.getX(j);
                            float f10 = worldMapPoints.getY(j);
                            pointArray[j] = StrokeGeometry.newPoint(f2 + f9 * f4, f3 + f10 * f4);
                        }
                        StrokeGeometry.Attrs attrs = new StrokeGeometry.Attrs();
                        attrs.join = "miter";
                        attrs.width = f;
                        ArrayList<StrokeGeometry.Point> arrayList = StrokeGeometry.getStrokeGeometry(pointArray, attrs);
                        if (arrayList == null) continue block3;
                        m_vboLines.setMode(4);
                        for (int j = 0; j < arrayList.size(); ++j) {
                            float f11 = (float)arrayList.get((int)j).x;
                            float f12 = (float)arrayList.get((int)j).y;
                            m_vboLines.addElement(f11, f12, 0.0f, f5, f6, f7, f8);
                        }
                        StrokeGeometry.release(arrayList);
                        continue block3;
                    }
                }
            }
        }

        public void drawLineString(WorldMapStyleLayer.RenderArgs renderArgs, WorldMapFeature worldMapFeature, WorldMapStyleLayer.RGBAf rGBAf, float f) {
            if (!this.m_renderer.LineString.getValue()) {
                return;
            }
            float f2 = this.m_renderCellX;
            float f3 = this.m_renderCellY;
            float f4 = this.m_worldScale;
            float f5 = rGBAf.r;
            float f6 = rGBAf.g;
            float f7 = rGBAf.b;
            float f8 = rGBAf.a;
            m_vboLines.flush();
            m_vboLinesUV.flush();
            for (int i = 0; i < worldMapFeature.m_geometries.size(); ++i) {
                WorldMapGeometry worldMapGeometry = worldMapFeature.m_geometries.get(i);
                switch (worldMapGeometry.m_type) {
                    case LineString: {
                        WorldMapPoints worldMapPoints = worldMapGeometry.m_points.get(0);
                        if (this.m_floatArray == null || this.m_floatArray.length < worldMapPoints.numPoints() * 2) {
                            this.m_floatArray = new float[worldMapPoints.numPoints() * 2];
                        }
                        for (int j = 0; j < worldMapPoints.numPoints(); ++j) {
                            float f9 = worldMapPoints.getX(j);
                            float f10 = worldMapPoints.getY(j);
                            this.m_floatArray[j * 2] = f2 + f9 * f4;
                            this.m_floatArray[j * 2 + 1] = f3 + f10 * f4;
                        }
                        GL13.glActiveTexture((int)33984);
                        GL11.glDisable((int)3553);
                        GL11.glEnable((int)3042);
                    }
                }
            }
        }

        public void drawLineStringTexture(WorldMapStyleLayer.RenderArgs renderArgs, WorldMapFeature worldMapFeature, WorldMapStyleLayer.RGBAf rGBAf, float f, Texture texture) {
            float f2 = this.m_renderCellX;
            float f3 = this.m_renderCellY;
            float f4 = this.m_worldScale;
            if (texture == null || !texture.isReady()) {
                return;
            }
            if (texture.getID() == -1) {
                texture.bind();
            }
            for (int i = 0; i < worldMapFeature.m_geometries.size(); ++i) {
                WorldMapGeometry worldMapGeometry = worldMapFeature.m_geometries.get(i);
                if (worldMapGeometry.m_type != WorldMapGeometry.Type.LineString) continue;
                m_vboLinesUV.setMode(7);
                m_vboLinesUV.startRun(texture.getTextureId());
                float f5 = f;
                WorldMapPoints worldMapPoints = worldMapGeometry.m_points.get(0);
                for (int j = 0; j < worldMapPoints.numPoints() - 1; ++j) {
                    float f6 = f2 + (float)worldMapPoints.getX(j) * f4;
                    float f7 = f3 + (float)worldMapPoints.getY(j) * f4;
                    float f8 = f2 + (float)worldMapPoints.getX(j + 1) * f4;
                    float f9 = f3 + (float)worldMapPoints.getY(j + 1) * f4;
                    float f10 = f9 - f7;
                    float f11 = -(f8 - f6);
                    Vector2f vector2f = this.m_vector2f.set(f10, f11);
                    vector2f.normalize();
                    float f12 = f6 + vector2f.x * f5 / 2.0f;
                    float f13 = f7 + vector2f.y * f5 / 2.0f;
                    float f14 = f8 + vector2f.x * f5 / 2.0f;
                    float f15 = f9 + vector2f.y * f5 / 2.0f;
                    float f16 = f8 - vector2f.x * f5 / 2.0f;
                    float f17 = f9 - vector2f.y * f5 / 2.0f;
                    float f18 = f6 - vector2f.x * f5 / 2.0f;
                    float f19 = f7 - vector2f.y * f5 / 2.0f;
                    float f20 = Vector2f.length((float)(f8 - f6), (float)(f9 - f7));
                    float f21 = 0.0f;
                    float f22 = f20 / (f5 * ((float)texture.getHeight() / (float)texture.getWidth()));
                    float f23 = 0.0f;
                    float f24 = 0.0f;
                    float f25 = 1.0f;
                    float f26 = 0.0f;
                    float f27 = 1.0f;
                    float f28 = f20 / (f5 * ((float)texture.getHeight() / (float)texture.getWidth()));
                    m_vboLinesUV.addQuad(f12, f13, f21, f22, f14, f15, f23, f24, f16, f17, f25, f26, f18, f19, f27, f28, 0.0f, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
                }
            }
        }

        public void fillPolygon(WorldMapStyleLayer.RenderArgs renderArgs, WorldMapFeature worldMapFeature, WorldMapStyleLayer.RGBAf rGBAf) {
            m_vboLinesUV.flush();
            float f = this.m_renderCellX;
            float f2 = this.m_renderCellY;
            float f3 = this.m_worldScale;
            float f4 = rGBAf.r;
            float f5 = rGBAf.g;
            float f6 = rGBAf.b;
            float f7 = rGBAf.a;
            for (int i = 0; i < worldMapFeature.m_geometries.size(); ++i) {
                float f8;
                float f9;
                float f10;
                float f11;
                float f12;
                float f13;
                float[] fArray;
                int n;
                Object object;
                WorldMapGeometry worldMapGeometry = worldMapFeature.m_geometries.get(i);
                if (worldMapGeometry.m_type != WorldMapGeometry.Type.Polygon) continue;
                boolean bl = false;
                if (worldMapGeometry.m_triangles == null) {
                    double[] dArray;
                    if (this.m_triangulationsThisFrame > 500) continue;
                    ++this.m_triangulationsThisFrame;
                    if (worldMapFeature.m_properties.containsKey("highway")) {
                        double[] dArray2 = new double[6];
                        dArray2[0] = 1.0;
                        dArray2[1] = 2.0;
                        dArray2[2] = 4.0;
                        dArray2[3] = 8.0;
                        dArray2[4] = 12.0;
                        dArray = dArray2;
                        dArray2[5] = 18.0;
                    } else {
                        dArray = null;
                    }
                    double[] dArray3 = dArray;
                    worldMapGeometry.triangulate(dArray3);
                    if (worldMapGeometry.m_triangles == null) {
                        if (!Core.bDebug) continue;
                        m_vboLines.setMode(1);
                        f4 = 1.0f;
                        f6 = 0.0f;
                        f5 = 0.0f;
                        m_vboLines.setLineWidth(4.0f);
                        for (int j = 0; j < worldMapGeometry.m_points.size(); ++j) {
                            object = worldMapGeometry.m_points.get(j);
                            for (int k = 0; k < ((WorldMapPoints)((Object)object)).numPoints(); ++k) {
                                n = ((WorldMapPoints)((Object)object)).getX(k);
                                int n2 = ((WorldMapPoints)((Object)object)).getY(k);
                                int n3 = ((WorldMapPoints)((Object)object)).getX((k + 1) % ((WorldMapPoints)((Object)object)).numPoints());
                                int n4 = ((WorldMapPoints)((Object)object)).getY((k + 1) % ((WorldMapPoints)((Object)object)).numPoints());
                                m_vboLines.reserve(2);
                                m_vboLines.addElement(f + (float)n * f3, f2 + (float)n2 * f3, 0.0f, f4, f5, f6, f7);
                                m_vboLines.addElement(f + (float)n3 * f3, f2 + (float)n4 * f3, 0.0f, f4, f5, f6, f7);
                            }
                        }
                        m_vboLines.setLineWidth(1.0f);
                        continue;
                    }
                    if (bl) {
                        this.uploadTrianglesToVBO(worldMapGeometry);
                    }
                }
                if (bl) {
                    GL11.glTranslatef((float)f, (float)f2, (float)0.0f);
                    GL11.glScalef((float)f3, (float)f3, (float)f3);
                    GL11.glColor4f((float)f4, (float)f5, (float)f6, (float)f7);
                    if (worldMapGeometry.m_triangles.length / 2 > 2340) {
                        int n5 = PZMath.min(worldMapGeometry.m_triangles.length / 2, 2340);
                        WorldMapVBOs.getInstance().drawElements(4, worldMapGeometry.m_vboIndex1, worldMapGeometry.m_vboIndex2, n5);
                        WorldMapVBOs.getInstance().drawElements(4, worldMapGeometry.m_vboIndex3, worldMapGeometry.m_vboIndex4, worldMapGeometry.m_triangles.length / 2 - n5);
                    } else {
                        WorldMapVBOs.getInstance().drawElements(4, worldMapGeometry.m_vboIndex1, worldMapGeometry.m_vboIndex2, worldMapGeometry.m_triangles.length / 2);
                    }
                    GL11.glScalef((float)(1.0f / f3), (float)(1.0f / f3), (float)(1.0f / f3));
                    GL11.glTranslatef((float)(-f), (float)(-f2), (float)0.0f);
                    continue;
                }
                m_vboLines.setMode(4);
                double d = 0.0;
                if ((double)this.m_zoomF <= 11.5) {
                    d = 18.0;
                } else if ((double)this.m_zoomF <= 12.0) {
                    d = 12.0;
                } else if ((double)this.m_zoomF <= 12.5) {
                    d = 8.0;
                } else if ((double)this.m_zoomF <= 13.0) {
                    d = 4.0;
                } else if ((double)this.m_zoomF <= 13.5) {
                    d = 2.0;
                } else if ((double)this.m_zoomF <= 14.0) {
                    d = 1.0;
                }
                Object object2 = object = d == 0.0 ? null : worldMapGeometry.findTriangles(d);
                if (object != null) {
                    fArray = ((WorldMapGeometry.TrianglesPerZoom)object).m_triangles;
                    for (n = 0; n < fArray.length; n += 6) {
                        f13 = fArray[n];
                        f12 = fArray[n + 1];
                        f11 = fArray[n + 2];
                        f10 = fArray[n + 3];
                        f9 = fArray[n + 4];
                        f8 = fArray[n + 5];
                        m_vboLines.reserve(3);
                        float f14 = 1.0f;
                        float f15 = f7;
                        m_vboLines.addElement(f + f13 * f3, f2 + f12 * f3, 0.0f, f4 * f14, f5 * f14, f6 * f14, f15);
                        m_vboLines.addElement(f + f11 * f3, f2 + f10 * f3, 0.0f, f4 * f14, f5 * f14, f6 * f14, f15);
                        m_vboLines.addElement(f + f9 * f3, f2 + f8 * f3, 0.0f, f4 * f14, f5 * f14, f6 * f14, f15);
                    }
                    continue;
                }
                fArray = worldMapGeometry.m_triangles;
                for (n = 0; n < fArray.length; n += 6) {
                    f13 = fArray[n];
                    f12 = fArray[n + 1];
                    f11 = fArray[n + 2];
                    f10 = fArray[n + 3];
                    f9 = fArray[n + 4];
                    f8 = fArray[n + 5];
                    m_vboLines.reserve(3);
                    m_vboLines.addElement(f + f13 * f3, f2 + f12 * f3, 0.0f, f4, f5, f6, f7);
                    m_vboLines.addElement(f + f11 * f3, f2 + f10 * f3, 0.0f, f4, f5, f6, f7);
                    m_vboLines.addElement(f + f9 * f3, f2 + f8 * f3, 0.0f, f4, f5, f6, f7);
                }
            }
        }

        public void fillPolygon(WorldMapStyleLayer.RenderArgs renderArgs, WorldMapFeature worldMapFeature, WorldMapStyleLayer.RGBAf rGBAf, Texture texture, float f) {
            m_vboLines.flush();
            float f2 = this.m_renderCellX;
            float f3 = this.m_renderCellY;
            float f4 = this.m_worldScale;
            float f5 = rGBAf.r;
            float f6 = rGBAf.g;
            float f7 = rGBAf.b;
            float f8 = rGBAf.a;
            for (int i = 0; i < worldMapFeature.m_geometries.size(); ++i) {
                WorldMapGeometry worldMapGeometry = worldMapFeature.m_geometries.get(i);
                if (worldMapGeometry.m_type != WorldMapGeometry.Type.Polygon) continue;
                if (worldMapGeometry.m_triangles == null) {
                    worldMapGeometry.triangulate(null);
                    if (worldMapGeometry.m_triangles == null) continue;
                }
                GL11.glEnable((int)3553);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                m_vboLinesUV.setMode(4);
                m_vboLinesUV.startRun(texture.getTextureId());
                float[] fArray = worldMapGeometry.m_triangles;
                float f9 = renderArgs.cellX * 300 + worldMapGeometry.m_minX;
                float f10 = renderArgs.cellY * 300 + worldMapGeometry.m_minY;
                float f11 = (float)texture.getWidth() * f;
                float f12 = (float)texture.getHeight() * f;
                float f13 = texture.getWidthHW();
                float f14 = texture.getHeightHW();
                float f15 = PZMath.floor(f9 / f11) * f11;
                float f16 = PZMath.floor(f10 / f12) * f12;
                for (int j = 0; j < fArray.length; j += 6) {
                    float f17 = fArray[j];
                    float f18 = fArray[j + 1];
                    float f19 = fArray[j + 2];
                    float f20 = fArray[j + 3];
                    float f21 = fArray[j + 4];
                    float f22 = fArray[j + 5];
                    float f23 = (f17 + (float)(renderArgs.cellX * 300) - f15) / f;
                    float f24 = (f18 + (float)(renderArgs.cellY * 300) - f16) / f;
                    float f25 = (f19 + (float)(renderArgs.cellX * 300) - f15) / f;
                    float f26 = (f20 + (float)(renderArgs.cellY * 300) - f16) / f;
                    float f27 = (f21 + (float)(renderArgs.cellX * 300) - f15) / f;
                    float f28 = (f22 + (float)(renderArgs.cellY * 300) - f16) / f;
                    f17 = f2 + f17 * f4;
                    f18 = f3 + f18 * f4;
                    f19 = f2 + f19 * f4;
                    f20 = f3 + f20 * f4;
                    f21 = f2 + f21 * f4;
                    f22 = f3 + f22 * f4;
                    float f29 = f23 / f13;
                    float f30 = f24 / f14;
                    float f31 = f25 / f13;
                    float f32 = f26 / f14;
                    float f33 = f27 / f13;
                    float f34 = f28 / f14;
                    m_vboLinesUV.reserve(3);
                    m_vboLinesUV.addElement(f17, f18, 0.0f, f29, f30, f5, f6, f7, f8);
                    m_vboLinesUV.addElement(f19, f20, 0.0f, f31, f32, f5, f6, f7, f8);
                    m_vboLinesUV.addElement(f21, f22, 0.0f, f33, f34, f5, f6, f7, f8);
                }
                GL11.glDisable((int)3553);
            }
        }

        void uploadTrianglesToVBO(WorldMapGeometry worldMapGeometry) {
            int[] nArray = new int[2];
            int n = worldMapGeometry.m_triangles.length / 2;
            if (n > 2340) {
                int n2 = 0;
                while (n > 0) {
                    int n3 = PZMath.min(n / 3, 780);
                    WorldMapVBOs.getInstance().reserveVertices(n3 * 3, nArray);
                    if (worldMapGeometry.m_vboIndex1 == -1) {
                        worldMapGeometry.m_vboIndex1 = nArray[0];
                        worldMapGeometry.m_vboIndex2 = nArray[1];
                    } else {
                        worldMapGeometry.m_vboIndex3 = nArray[0];
                        worldMapGeometry.m_vboIndex4 = nArray[1];
                    }
                    float[] fArray = worldMapGeometry.m_triangles;
                    int n4 = (n2 + n3) * 3 * 2;
                    for (int i = n2 * 3 * 2; i < n4; i += 6) {
                        float f = fArray[i];
                        float f2 = fArray[i + 1];
                        float f3 = fArray[i + 2];
                        float f4 = fArray[i + 3];
                        float f5 = fArray[i + 4];
                        float f6 = fArray[i + 5];
                        WorldMapVBOs.getInstance().addElement(f, f2, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                        WorldMapVBOs.getInstance().addElement(f3, f4, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                        WorldMapVBOs.getInstance().addElement(f5, f6, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    n2 += n3;
                    n -= n3 * 3;
                }
            } else {
                WorldMapVBOs.getInstance().reserveVertices(n, nArray);
                worldMapGeometry.m_vboIndex1 = nArray[0];
                worldMapGeometry.m_vboIndex2 = nArray[1];
                float[] fArray = worldMapGeometry.m_triangles;
                for (int i = 0; i < fArray.length; i += 6) {
                    float f = fArray[i];
                    float f7 = fArray[i + 1];
                    float f8 = fArray[i + 2];
                    float f9 = fArray[i + 3];
                    float f10 = fArray[i + 4];
                    float f11 = fArray[i + 5];
                    WorldMapVBOs.getInstance().addElement(f, f7, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                    WorldMapVBOs.getInstance().addElement(f8, f9, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                    WorldMapVBOs.getInstance().addElement(f10, f11, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }

        void outlineTriangles(WorldMapGeometry worldMapGeometry, float f, float f2, float f3) {
            m_vboLines.setMode(1);
            float f4 = 1.0f;
            float f5 = 1.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float[] fArray = worldMapGeometry.m_triangles;
            for (int i = 0; i < fArray.length; i += 6) {
                float f8 = fArray[i];
                float f9 = fArray[i + 1];
                float f10 = fArray[i + 2];
                float f11 = fArray[i + 3];
                float f12 = fArray[i + 4];
                float f13 = fArray[i + 5];
                m_vboLines.addElement(f + f8 * f3, f2 + f9 * f3, 0.0f, f5, f7, f6, f4);
                m_vboLines.addElement(f + f10 * f3, f2 + f11 * f3, 0.0f, f5, f7, f6, f4);
                m_vboLines.addElement(f + f10 * f3, f2 + f11 * f3, 0.0f, f5, f7, f6, f4);
                m_vboLines.addElement(f + f12 * f3, f2 + f13 * f3, 0.0f, f5, f7, f6, f4);
                m_vboLines.addElement(f + f12 * f3, f2 + f13 * f3, 0.0f, f5, f7, f6, f4);
                m_vboLines.addElement(f + f8 * f3, f2 + f9 * f3, 0.0f, f5, f7, f6, f4);
            }
        }

        void outlinePolygon(WorldMapGeometry worldMapGeometry, float f, float f2, float f3) {
            m_vboLines.setMode(1);
            float f4 = 1.0f;
            float f5 = 0.8f;
            float f6 = 0.8f;
            float f7 = 0.8f;
            m_vboLines.setLineWidth(4.0f);
            for (int i = 0; i < worldMapGeometry.m_points.size(); ++i) {
                WorldMapPoints worldMapPoints = worldMapGeometry.m_points.get(i);
                for (int j = 0; j < worldMapPoints.numPoints(); ++j) {
                    int n = worldMapPoints.getX(j);
                    int n2 = worldMapPoints.getY(j);
                    int n3 = worldMapPoints.getX((j + 1) % worldMapPoints.numPoints());
                    int n4 = worldMapPoints.getY((j + 1) % worldMapPoints.numPoints());
                    m_vboLines.addElement(f + (float)n * f3, f2 + (float)n2 * f3, 0.0f, f7, f6, f5, f4);
                    m_vboLines.addElement(f + (float)n3 * f3, f2 + (float)n4 * f3, 0.0f, f7, f6, f5, f4);
                }
            }
            m_vboLines.setLineWidth(1.0f);
        }

        public void drawTexture(Texture texture, WorldMapStyleLayer.RGBAf rGBAf, int n, int n2, int n3, int n4) {
            if (texture == null || !texture.isReady()) {
                return;
            }
            m_vboLines.flush();
            m_vboLinesUV.flush();
            float f = this.m_worldScale;
            float f2 = ((float)n - this.m_centerWorldX) * f;
            float f3 = ((float)n2 - this.m_centerWorldY) * f;
            float f4 = f2 + (float)(n3 - n) * f;
            float f5 = f3 + (float)(n4 - n2) * f;
            float f6 = PZMath.clamp(f2, this.m_renderCellX, this.m_renderCellX + 300.0f * f);
            float f7 = PZMath.clamp(f3, this.m_renderCellY, this.m_renderCellY + 300.0f * f);
            float f8 = PZMath.clamp(f4, this.m_renderCellX, this.m_renderCellX + 300.0f * f);
            float f9 = PZMath.clamp(f5, this.m_renderCellY, this.m_renderCellY + 300.0f * f);
            if (f6 >= f8 || f7 >= f9) {
                return;
            }
            float f10 = (float)texture.getWidth() / (float)(n3 - n);
            float f11 = (float)texture.getHeight() / (float)(n4 - n2);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            if (texture.getID() == -1) {
                texture.bind();
            } else {
                Texture.lastTextureID = texture.getID();
                GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            }
            float f12 = (f6 - f2) / ((float)texture.getWidthHW() * f) * f10;
            float f13 = (f7 - f3) / ((float)texture.getHeightHW() * f) * f11;
            float f14 = (f8 - f2) / ((float)texture.getWidthHW() * f) * f10;
            float f15 = (f9 - f3) / ((float)texture.getHeightHW() * f) * f11;
            m_vboLinesUV.setMode(7);
            m_vboLinesUV.startRun(texture.getTextureId());
            m_vboLinesUV.addQuad(f6, f7, f12, f13, f8, f9, f14, f15, 0.0f, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
        }

        public void drawTextureTiled(Texture texture, WorldMapStyleLayer.RGBAf rGBAf, int n, int n2, int n3, int n4, int n5, int n6) {
            if (texture == null || !texture.isReady()) {
                return;
            }
            if (n5 * 300 >= n3 || (n5 + 1) * 300 <= n) {
                return;
            }
            if (n6 * 300 >= n4 || (n6 + 1) * 300 <= n2) {
                return;
            }
            m_vboLines.flush();
            float f = this.m_worldScale;
            int n7 = texture.getWidth();
            int n8 = texture.getHeight();
            int n9 = (int)(PZMath.floor((float)n5 * 300.0f / (float)n7) * (float)n7);
            int n10 = (int)(PZMath.floor((float)n6 * 300.0f / (float)n8) * (float)n8);
            int n11 = n9 + (int)Math.ceil(((float)(n5 + 1) * 300.0f - (float)n9) / (float)n7) * n7;
            int n12 = n10 + (int)Math.ceil(((float)(n6 + 1) * 300.0f - (float)n10) / (float)n8) * n8;
            float f2 = PZMath.clamp(n9, n5 * 300, (n5 + 1) * 300);
            float f3 = PZMath.clamp(n10, n6 * 300, (n6 + 1) * 300);
            float f4 = PZMath.clamp(n11, n5 * 300, (n5 + 1) * 300);
            float f5 = PZMath.clamp(n12, n6 * 300, (n6 + 1) * 300);
            f2 = PZMath.clamp(f2, (float)n, (float)n3);
            f3 = PZMath.clamp(f3, (float)n2, (float)n4);
            f4 = PZMath.clamp(f4, (float)n, (float)n3);
            f5 = PZMath.clamp(f5, (float)n2, (float)n4);
            float f6 = (f2 - (float)n) / (float)n7;
            float f7 = (f3 - (float)n2) / (float)n8;
            float f8 = (f4 - (float)n) / (float)n7;
            float f9 = (f5 - (float)n2) / (float)n8;
            f2 = (f2 - this.m_centerWorldX) * f;
            f3 = (f3 - this.m_centerWorldY) * f;
            f4 = (f4 - this.m_centerWorldX) * f;
            f5 = (f5 - this.m_centerWorldY) * f;
            float f10 = f6 * texture.xEnd;
            float f11 = f7 * texture.yEnd;
            float f12 = (float)((int)f8) + (f8 - (float)((int)f8)) * texture.xEnd;
            float f13 = (float)((int)f9) + (f9 - (float)((int)f9)) * texture.yEnd;
            GL11.glEnable((int)3553);
            if (texture.getID() == -1) {
                texture.bind();
            } else {
                Texture.lastTextureID = texture.getID();
                GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
                GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
            }
            m_vboLinesUV.setMode(7);
            m_vboLinesUV.startRun(texture.getTextureId());
            m_vboLinesUV.addQuad(f2, f3, f10, f11, f4, f5, f12, f13, 0.0f, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
            GL11.glDisable((int)3553);
        }

        public void drawTextureTiled(Texture texture, WorldMapStyleLayer.RGBAf rGBAf, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            if (texture == null || !texture.isReady()) {
                return;
            }
            m_vboLines.flush();
            m_vboLinesUV.flush();
            float f = this.m_worldScale;
            float f2 = n;
            float f3 = n2;
            float f4 = n3;
            float f5 = n4;
            float f6 = PZMath.clamp(f2, (float)(n7 * 300), (float)((n7 + 1) * 300));
            float f7 = PZMath.clamp(f3, (float)(n8 * 300), (float)((n8 + 1) * 300));
            float f8 = PZMath.clamp(f4, (float)(n7 * 300), (float)((n7 + 1) * 300));
            float f9 = PZMath.clamp(f5, (float)(n8 * 300), (float)((n8 + 1) * 300));
            float f10 = (f6 - (float)n) / (float)n5;
            float f11 = (f7 - (float)n2) / (float)n6;
            float f12 = (f8 - (float)n) / (float)n5;
            float f13 = (f9 - (float)n2) / (float)n6;
            f6 = (f6 - this.m_centerWorldX) * f;
            f7 = (f7 - this.m_centerWorldY) * f;
            f8 = (f8 - this.m_centerWorldX) * f;
            f9 = (f9 - this.m_centerWorldY) * f;
            float f14 = f10 * texture.xEnd;
            float f15 = f11 * texture.yEnd;
            float f16 = (float)((int)f12) + (f12 - (float)((int)f12)) * texture.xEnd;
            float f17 = (float)((int)f13) + (f13 - (float)((int)f13)) * texture.yEnd;
            GL11.glEnable((int)3553);
            if (texture.getID() == -1) {
                texture.bind();
            } else {
                Texture.lastTextureID = texture.getID();
                GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
                GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
            }
            GL11.glColor4f((float)rGBAf.r, (float)rGBAf.g, (float)rGBAf.b, (float)rGBAf.a);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)f14, (float)f15);
            GL11.glVertex2f((float)f6, (float)f7);
            GL11.glTexCoord2f((float)f16, (float)f15);
            GL11.glVertex2f((float)f8, (float)f7);
            GL11.glTexCoord2f((float)f16, (float)f17);
            GL11.glVertex2f((float)f8, (float)f9);
            GL11.glTexCoord2f((float)f14, (float)f17);
            GL11.glVertex2f((float)f6, (float)f9);
            GL11.glEnd();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
        }

        void renderZones() {
            this.m_zoneSet.clear();
            for (int i = 0; i < this.m_rasterizeXY.size() - 1; i += 2) {
                IsoMetaCell isoMetaCell;
                int n = this.m_rasterizeXY_ints[i];
                int n2 = this.m_rasterizeXY_ints[i + 1];
                if (this.m_renderer.m_visited != null && !this.m_renderer.m_visited.isCellVisible(n, n2) || (isoMetaCell = IsoWorld.instance.MetaGrid.getCellData(n, n2)) == null) continue;
                isoMetaCell.getZonesUnique(this.m_zoneSet);
            }
            this.m_zones.clear();
            this.m_zones.addAll(this.m_zoneSet);
            this.renderZones(this.m_zones, "Forest", 0.0f, 1.0f, 0.0f, 0.25f);
            this.renderZones(this.m_zones, "DeepForest", 0.0f, 0.5f, 0.0f, 0.25f);
            this.renderZones(this.m_zones, "Nav", 0.0f, 0.0f, 1.0f, 0.25f);
            this.renderZones(this.m_zones, "Vegitation", 1.0f, 1.0f, 0.0f, 0.25f);
        }

        void renderZones(ArrayList<IsoMetaGrid.Zone> arrayList, String string, float f, float f2, float f3, float f4) {
            float f5;
            float f6;
            float f7;
            float f8;
            m_vboLinesUV.flush();
            float f9 = this.m_worldScale;
            m_vboLines.setMode(4);
            for (IsoMetaGrid.Zone zone : arrayList) {
                float f10;
                float f11;
                int n;
                float[] fArray;
                if (!string.equals(zone.type)) continue;
                if (zone.isRectangle()) {
                    m_vboLines.addQuad(((float)zone.x - this.m_centerWorldX) * f9, ((float)zone.y - this.m_centerWorldY) * f9, ((float)(zone.x + zone.w) - this.m_centerWorldX) * f9, ((float)(zone.y + zone.h) - this.m_centerWorldY) * f9, 0.0f, f, f2, f3, f4);
                }
                if (zone.isPolygon()) {
                    fArray = zone.getPolygonTriangles();
                    if (fArray == null) continue;
                    for (n = 0; n < fArray.length; n += 6) {
                        f8 = (fArray[n] - this.m_centerWorldX) * f9;
                        f7 = (fArray[n + 1] - this.m_centerWorldY) * f9;
                        f6 = (fArray[n + 2] - this.m_centerWorldX) * f9;
                        f5 = (fArray[n + 3] - this.m_centerWorldY) * f9;
                        f11 = (fArray[n + 4] - this.m_centerWorldX) * f9;
                        f10 = (fArray[n + 5] - this.m_centerWorldY) * f9;
                        m_vboLines.addTriangle(f8, f7, 0.0f, f6, f5, 0.0f, f11, f10, 0.0f, f, f2, f3, f4);
                    }
                }
                if (!zone.isPolyline() || (fArray = zone.getPolylineOutlineTriangles()) == null) continue;
                for (n = 0; n < fArray.length; n += 6) {
                    f8 = (fArray[n] - this.m_centerWorldX) * f9;
                    f7 = (fArray[n + 1] - this.m_centerWorldY) * f9;
                    f6 = (fArray[n + 2] - this.m_centerWorldX) * f9;
                    f5 = (fArray[n + 3] - this.m_centerWorldY) * f9;
                    f11 = (fArray[n + 4] - this.m_centerWorldX) * f9;
                    f10 = (fArray[n + 5] - this.m_centerWorldY) * f9;
                    m_vboLines.addTriangle(f8, f7, 0.0f, f6, f5, 0.0f, f11, f10, 0.0f, f, f2, f3, f4);
                }
            }
            m_vboLines.setMode(1);
            m_vboLines.setLineWidth(2.0f);
            for (IsoMetaGrid.Zone zone : arrayList) {
                float[] fArray;
                if (!string.equals(zone.type)) continue;
                if (zone.isRectangle()) {
                    float f12 = ((float)zone.x - this.m_centerWorldX) * f9;
                    float f13 = ((float)zone.y - this.m_centerWorldY) * f9;
                    f8 = ((float)(zone.x + zone.w) - this.m_centerWorldX) * f9;
                    f7 = ((float)(zone.y + zone.h) - this.m_centerWorldY) * f9;
                    m_vboLines.addLine(f12, f13, 0.0f, f8, f13, 0.0f, f, f2, f3, 1.0f);
                    m_vboLines.addLine(f8, f13, 0.0f, f8, f7, 0.0f, f, f2, f3, 1.0f);
                    m_vboLines.addLine(f8, f7, 0.0f, f12, f7, 0.0f, f, f2, f3, 1.0f);
                    m_vboLines.addLine(f12, f7, 0.0f, f12, f13, 0.0f, f, f2, f3, 1.0f);
                }
                if (zone.isPolygon()) {
                    for (int i = 0; i < zone.points.size(); i += 2) {
                        float f14 = ((float)zone.points.getQuick(i) - this.m_centerWorldX) * f9;
                        f8 = ((float)zone.points.getQuick(i + 1) - this.m_centerWorldY) * f9;
                        f7 = ((float)zone.points.getQuick((i + 2) % zone.points.size()) - this.m_centerWorldX) * f9;
                        f6 = ((float)zone.points.getQuick((i + 3) % zone.points.size()) - this.m_centerWorldY) * f9;
                        m_vboLines.addLine(f14, f8, 0.0f, f7, f6, 0.0f, f, f2, f3, 1.0f);
                    }
                }
                if (!zone.isPolyline() || (fArray = zone.polylineOutlinePoints) == null) continue;
                for (int i = 0; i < fArray.length; i += 2) {
                    f8 = (fArray[i] - this.m_centerWorldX) * f9;
                    f7 = (fArray[i + 1] - this.m_centerWorldY) * f9;
                    f6 = (fArray[(i + 2) % fArray.length] - this.m_centerWorldX) * f9;
                    f5 = (fArray[(i + 3) % fArray.length] - this.m_centerWorldY) * f9;
                    m_vboLines.addLine(f8, f7, 0.0f, f6, f5, 0.0f, f, f2, f3, 1.0f);
                }
            }
        }

        @Override
        public void render() {
            try {
                PZGLUtil.pushAndLoadMatrix(5889, this.m_projection);
                PZGLUtil.pushAndLoadMatrix(5888, this.m_modelView);
                this.renderInternal();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            finally {
                PZGLUtil.popMatrix(5889);
                PZGLUtil.popMatrix(5888);
            }
        }

        private void renderInternal() {
            float f = this.m_worldScale;
            int n = (int)Math.max(this.uiToWorldX(0.0f, 0.0f), (float)this.m_worldMap.getMinXInSquares()) / 300;
            int n2 = (int)Math.max(this.uiToWorldY(0.0f, 0.0f), (float)this.m_worldMap.getMinYInSquares()) / 300;
            int n3 = (int)Math.min(this.uiToWorldX(this.getWidth(), this.getHeight()), (float)(this.m_worldMap.m_maxX * 300)) / 300;
            int n4 = (int)Math.min(this.uiToWorldY(this.getWidth(), this.getHeight()), (float)(this.m_worldMap.m_maxY * 300)) / 300;
            n = this.m_worldMap.getMinXInSquares();
            n2 = this.m_worldMap.getMinYInSquares();
            n3 = this.m_worldMap.m_maxX;
            n4 = this.m_worldMap.m_maxY;
            GL11.glViewport((int)this.m_x, (int)(Core.height - this.m_height - this.m_y), (int)this.m_width, (int)this.m_height);
            GLVertexBufferObject.funcs.glBindBuffer(GLVertexBufferObject.funcs.GL_ARRAY_BUFFER(), 0);
            GLVertexBufferObject.funcs.glBindBuffer(GLVertexBufferObject.funcs.GL_ELEMENT_ARRAY_BUFFER(), 0);
            GL11.glPolygonMode((int)1032, (int)(this.m_renderer.Wireframe.getValue() ? 6913 : 6914));
            if (this.m_renderer.ImagePyramid.getValue()) {
                this.renderImagePyramids();
            }
            this.calculateVisibleCells();
            if (this.m_renderer.Features.getValue()) {
                this.renderCellFeatures();
            }
            if (this.m_renderer.ForestZones.getValue()) {
                this.renderZones();
            }
            if (this.m_renderer.VisibleCells.getValue()) {
                this.renderVisibleCells();
            }
            m_vboLines.flush();
            m_vboLinesUV.flush();
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            GL13.glActiveTexture((int)33984);
            GL13.glClientActiveTexture((int)33984);
            GL11.glEnableClientState((int)32888);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glEnable((int)3042);
            SpriteRenderer.ringBuffer.restoreBoundTextures = true;
            SpriteRenderer.ringBuffer.restoreVBOs = true;
            if (this.m_renderer.m_visited != null) {
                this.m_renderer.m_visited.render(this.m_renderOriginX - (float)(this.m_worldMap.getMinXInSquares() - this.m_renderer.m_visited.getMinX() * 300) * f, this.m_renderOriginY - (float)(this.m_worldMap.getMinYInSquares() - this.m_renderer.m_visited.getMinY() * 300) * f, n / 300, n2 / 300, n3 / 300, n4 / 300, f, this.m_renderer.BlurUnvisited.getValue());
                if (this.m_renderer.UnvisitedGrid.getValue()) {
                    this.m_renderer.m_visited.renderGrid(this.m_renderOriginX - (float)(this.m_worldMap.getMinXInSquares() - this.m_renderer.m_visited.getMinX() * 300) * f, this.m_renderOriginY - (float)(this.m_worldMap.getMinYInSquares() - this.m_renderer.m_visited.getMinY() * 300) * f, n / 300, n2 / 300, n3 / 300, n4 / 300, f, this.m_zoomF);
                }
            }
            this.renderPlayers();
            if (this.m_renderer.CellGrid.getValue()) {
                this.renderCellGrid(n / 300, n2 / 300, n3 / 300, n4 / 300);
            }
            if (Core.bDebug) {
                // empty if block
            }
            this.paintAreasOutsideBounds(n, n2, n3, n4, f);
            if (this.m_renderer.WorldBounds.getValue()) {
                this.renderWorldBounds();
            }
            m_vboLines.flush();
            m_vboLinesUV.flush();
            GL11.glViewport((int)0, (int)0, (int)Core.width, (int)Core.height);
        }

        private void rasterizeCellsCallback(int n, int n2) {
            int n3 = n + n2 * this.m_worldMap.getWidthInCells();
            if (this.m_rasterizeSet.contains(n3)) {
                return;
            }
            for (int i = n2 * this.m_rasterizeMult; i < n2 * this.m_rasterizeMult + this.m_rasterizeMult; ++i) {
                for (int j = n * this.m_rasterizeMult; j < n * this.m_rasterizeMult + this.m_rasterizeMult; ++j) {
                    if (j < this.m_worldMap.getMinXInCells() || j > this.m_worldMap.getMaxXInCells() || i < this.m_worldMap.getMinYInCells() || i > this.m_worldMap.getMaxYInCells()) continue;
                    this.m_rasterizeSet.add(n3);
                    this.m_rasterizeXY.add(j);
                    this.m_rasterizeXY.add(i);
                }
            }
        }

        private void rasterizeTilesCallback(int n, int n2) {
            int n3 = n + n2 * 1000;
            if (this.m_rasterizeSet.contains(n3)) {
                return;
            }
            if ((float)n < this.m_rasterizeMinTileX || (float)n > this.m_rasterizeMaxTileX || (float)n2 < this.m_rasterizeMinTileY || (float)n2 > this.m_rasterizeMaxTileY) {
                return;
            }
            this.m_rasterizeSet.add(n3);
            this.m_rasterizeXY.add(n);
            this.m_rasterizeXY.add(n2);
        }

        private void calculateVisibleCells() {
            boolean bl = Core.bDebug && this.m_renderer.VisibleCells.getValue();
            int n = bl ? 200 : 0;
            float f = this.m_worldScale;
            if (1.0f / f > 100.0f) {
                this.m_rasterizeXY.clear();
                for (int i = this.m_worldMap.getMinYInCells(); i <= this.m_worldMap.getMaxYInCells(); ++i) {
                    for (int j = this.m_worldMap.getMinXInCells(); j <= this.m_worldMap.getMaxYInCells(); ++j) {
                        this.m_rasterizeXY.add(j);
                        this.m_rasterizeXY.add(i);
                    }
                }
                if (this.m_rasterizeXY_ints == null || this.m_rasterizeXY_ints.length < this.m_rasterizeXY.size()) {
                    this.m_rasterizeXY_ints = new int[this.m_rasterizeXY.size()];
                }
                this.m_rasterizeXY_ints = this.m_rasterizeXY.toArray(this.m_rasterizeXY_ints);
                return;
            }
            float f2 = this.uiToWorldX((float)n + 0.0f, (float)n + 0.0f) / 300.0f;
            float f3 = this.uiToWorldY((float)n + 0.0f, (float)n + 0.0f) / 300.0f;
            float f4 = this.uiToWorldX(this.getWidth() - n, 0.0f + (float)n) / 300.0f;
            float f5 = this.uiToWorldY(this.getWidth() - n, 0.0f + (float)n) / 300.0f;
            float f6 = this.uiToWorldX(this.getWidth() - n, this.getHeight() - n) / 300.0f;
            float f7 = this.uiToWorldY(this.getWidth() - n, this.getHeight() - n) / 300.0f;
            float f8 = this.uiToWorldX(0.0f + (float)n, this.getHeight() - n) / 300.0f;
            float f9 = this.uiToWorldY(0.0f + (float)n, this.getHeight() - n) / 300.0f;
            int n2 = 1;
            while (this.triangleArea(f8 / (float)n2, f9 / (float)n2, f6 / (float)n2, f7 / (float)n2, f4 / (float)n2, f5 / (float)n2) + this.triangleArea(f4 / (float)n2, f5 / (float)n2, f2 / (float)n2, f3 / (float)n2, f8 / (float)n2, f9 / (float)n2) > 80.0f) {
                ++n2;
            }
            this.m_rasterizeMult = n2;
            this.m_rasterizeXY.clear();
            this.m_rasterizeSet.clear();
            this.m_rasterize.scanTriangle(f8 / (float)n2, f9 / (float)n2, f6 / (float)n2, f7 / (float)n2, f4 / (float)n2, f5 / (float)n2, 0, 1000, this::rasterizeCellsCallback);
            this.m_rasterize.scanTriangle(f4 / (float)n2, f5 / (float)n2, f2 / (float)n2, f3 / (float)n2, f8 / (float)n2, f9 / (float)n2, 0, 1000, this::rasterizeCellsCallback);
            if (this.m_rasterizeXY_ints == null || this.m_rasterizeXY_ints.length < this.m_rasterizeXY.size()) {
                this.m_rasterizeXY_ints = new int[this.m_rasterizeXY.size()];
            }
            this.m_rasterizeXY_ints = this.m_rasterizeXY.toArray(this.m_rasterizeXY_ints);
        }

        void renderVisibleCells() {
            float f;
            float f2;
            float f3;
            float f4;
            boolean bl = Core.bDebug && this.m_renderer.VisibleCells.getValue();
            int n = bl ? 200 : 0;
            float f5 = this.m_worldScale;
            if (1.0f / f5 > 100.0f) {
                return;
            }
            m_vboLines.setMode(4);
            for (int i = 0; i < this.m_rasterizeXY.size(); i += 2) {
                int n2 = this.m_rasterizeXY.get(i);
                int n3 = this.m_rasterizeXY.get(i + 1);
                f4 = this.m_renderOriginX + (float)(n2 * 300 - this.m_worldMap.getMinXInSquares()) * f5;
                f3 = this.m_renderOriginY + (float)(n3 * 300 - this.m_worldMap.getMinYInSquares()) * f5;
                f2 = this.m_renderOriginX + (float)((n2 + 1) * 300 - this.m_worldMap.getMinXInSquares()) * f5;
                f = this.m_renderOriginY + (float)((n3 + 1) * 300 - this.m_worldMap.getMinYInSquares()) * f5;
                m_vboLines.addElement(f4, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.2f);
                m_vboLines.addElement(f2, f3, 0.0f, 0.0f, 1.0f, 0.0f, 0.2f);
                m_vboLines.addElement(f4, f, 0.0f, 0.0f, 1.0f, 0.0f, 0.2f);
                m_vboLines.addElement(f2, f3, 0.0f, 0.0f, 0.0f, 1.0f, 0.2f);
                m_vboLines.addElement(f2, f, 0.0f, 0.0f, 0.0f, 1.0f, 0.2f);
                m_vboLines.addElement(f4, f, 0.0f, 0.0f, 0.0f, 1.0f, 0.2f);
            }
            m_vboLines.flush();
            float f6 = this.uiToWorldX((float)n + 0.0f, (float)n + 0.0f) / 300.0f;
            float f7 = this.uiToWorldY((float)n + 0.0f, (float)n + 0.0f) / 300.0f;
            float f8 = this.uiToWorldX(this.getWidth() - n, 0.0f + (float)n) / 300.0f;
            f4 = this.uiToWorldY(this.getWidth() - n, 0.0f + (float)n) / 300.0f;
            f3 = this.uiToWorldX(this.getWidth() - n, this.getHeight() - n) / 300.0f;
            f2 = this.uiToWorldY(this.getWidth() - n, this.getHeight() - n) / 300.0f;
            f = this.uiToWorldX(0.0f + (float)n, this.getHeight() - n) / 300.0f;
            float f9 = this.uiToWorldY(0.0f + (float)n, this.getHeight() - n) / 300.0f;
            m_vboLines.setMode(1);
            m_vboLines.setLineWidth(4.0f);
            m_vboLines.addLine(this.m_renderOriginX + (f * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f9 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, this.m_renderOriginX + (f3 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f2 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            m_vboLines.addLine(this.m_renderOriginX + (f3 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f2 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, this.m_renderOriginX + (f8 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f4 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            m_vboLines.addLine(this.m_renderOriginX + (f8 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f4 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, this.m_renderOriginX + (f * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f9 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f);
            m_vboLines.addLine(this.m_renderOriginX + (f8 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f4 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, this.m_renderOriginX + (f6 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f7 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
            m_vboLines.addLine(this.m_renderOriginX + (f6 * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f7 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, this.m_renderOriginX + (f * 300.0f - (float)this.m_worldMap.getMinXInSquares()) * f5, this.m_renderOriginY + (f9 * 300.0f - (float)this.m_worldMap.getMinYInSquares()) * f5, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        void calcVisiblePyramidTiles(WorldMapImages worldMapImages) {
            boolean bl;
            if (Core.bDebug) {
                // empty if block
            }
            int n = (bl = false) ? 200 : 0;
            float f = this.m_worldScale;
            int n2 = worldMapImages.getZoom(this.m_zoomF);
            int n3 = 256;
            float f2 = n3 * (1 << n2);
            int n4 = worldMapImages.getMinX();
            int n5 = worldMapImages.getMinY();
            float f3 = (this.uiToWorldX((float)n + 0.0f, (float)n + 0.0f) - (float)n4) / f2;
            float f4 = (this.uiToWorldY((float)n + 0.0f, (float)n + 0.0f) - (float)n5) / f2;
            float f5 = (this.uiToWorldX(this.getWidth() - n, 0.0f + (float)n) - (float)n4) / f2;
            float f6 = (this.uiToWorldY(this.getWidth() - n, 0.0f + (float)n) - (float)n5) / f2;
            float f7 = (this.uiToWorldX(this.getWidth() - n, this.getHeight() - n) - (float)n4) / f2;
            float f8 = (this.uiToWorldY(this.getWidth() - n, this.getHeight() - n) - (float)n5) / f2;
            float f9 = (this.uiToWorldX(0.0f + (float)n, this.getHeight() - n) - (float)n4) / f2;
            float f10 = (this.uiToWorldY(0.0f + (float)n, this.getHeight() - n) - (float)n5) / f2;
            if (bl) {
                m_vboLines.setMode(1);
                m_vboLines.setLineWidth(4.0f);
                m_vboLines.addLine(this.m_renderOriginX + f9 * f2 * f, this.m_renderOriginY + f10 * f2 * f, 0.0f, this.m_renderOriginX + f7 * f2 * f, this.m_renderOriginY + f8 * f2 * f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
                m_vboLines.addLine(this.m_renderOriginX + f7 * f2 * f, this.m_renderOriginY + f8 * f2 * f, 0.0f, this.m_renderOriginX + f5 * f2 * f, this.m_renderOriginY + f6 * f2 * f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
                m_vboLines.addLine(this.m_renderOriginX + f5 * f2 * f, this.m_renderOriginY + f6 * f2 * f, 0.0f, this.m_renderOriginX + f9 * f2 * f, this.m_renderOriginY + f10 * f2 * f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f);
                m_vboLines.addLine(this.m_renderOriginX + f5 * f2 * f, this.m_renderOriginY + f6 * f2 * f, 0.0f, this.m_renderOriginX + f3 * f2 * f, this.m_renderOriginY + f4 * f2 * f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
                m_vboLines.addLine(this.m_renderOriginX + f3 * f2 * f, this.m_renderOriginY + f4 * f2 * f, 0.0f, this.m_renderOriginX + f9 * f2 * f, this.m_renderOriginY + f10 * f2 * f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            this.m_rasterizeXY.clear();
            this.m_rasterizeSet.clear();
            this.m_rasterizeMinTileX = (int)((float)(this.m_worldMap.getMinXInSquares() - worldMapImages.getMinX()) / f2);
            this.m_rasterizeMinTileY = (int)((float)(this.m_worldMap.getMinYInSquares() - worldMapImages.getMinY()) / f2);
            this.m_rasterizeMaxTileX = (float)(this.m_worldMap.getMaxXInSquares() - worldMapImages.getMinX()) / f2;
            this.m_rasterizeMaxTileY = (float)(this.m_worldMap.getMaxYInSquares() - worldMapImages.getMinY()) / f2;
            this.m_rasterize.scanTriangle(f9, f10, f7, f8, f5, f6, 0, 1000, this::rasterizeTilesCallback);
            this.m_rasterize.scanTriangle(f5, f6, f3, f4, f9, f10, 0, 1000, this::rasterizeTilesCallback);
            if (this.m_rasterizeXY_ints == null || this.m_rasterizeXY_ints.length < this.m_rasterizeXY.size()) {
                this.m_rasterizeXY_ints = new int[this.m_rasterizeXY.size()];
            }
            this.m_rasterizeXY_ints = this.m_rasterizeXY.toArray(this.m_rasterizeXY_ints);
            if (bl) {
                m_vboLines.setMode(4);
                for (int i = 0; i < this.m_rasterizeXY.size(); i += 2) {
                    int n6 = this.m_rasterizeXY.get(i);
                    int n7 = this.m_rasterizeXY.get(i + 1);
                    float f11 = this.m_renderOriginX + (float)n6 * f2 * f;
                    float f12 = this.m_renderOriginY + (float)n7 * f2 * f;
                    float f13 = this.m_renderOriginX + (float)(n6 + 1) * f2 * f;
                    float f14 = this.m_renderOriginY + (float)(n7 + 1) * f2 * f;
                    m_vboLines.addElement(f11, f12, 0.0f, 0.0f, 1.0f, 0.0f, 0.2f);
                    m_vboLines.addElement(f13, f12, 0.0f, 0.0f, 1.0f, 0.0f, 0.2f);
                    m_vboLines.addElement(f11, f14, 0.0f, 0.0f, 1.0f, 0.0f, 0.2f);
                    m_vboLines.addElement(f13, f12, 0.0f, 0.0f, 0.0f, 1.0f, 0.2f);
                    m_vboLines.addElement(f13, f14, 0.0f, 0.0f, 0.0f, 1.0f, 0.2f);
                    m_vboLines.addElement(f11, f14, 0.0f, 0.0f, 0.0f, 1.0f, 0.2f);
                }
                m_vboLines.flush();
            }
        }

        void renderImagePyramids() {
            for (int i = this.m_worldMap.getImagesCount() - 1; i >= 0; --i) {
                WorldMapImages worldMapImages = this.m_worldMap.getImagesByIndex(i);
                this.renderImagePyramid(worldMapImages);
                GL11.glDisable((int)3553);
            }
        }

        void renderImagePyramid(WorldMapImages worldMapImages) {
            float f = this.m_worldScale;
            int n = 256;
            int n2 = worldMapImages.getZoom(this.m_zoomF);
            float f2 = n * (1 << n2);
            this.calcVisiblePyramidTiles(worldMapImages);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            m_vboLinesUV.setMode(4);
            int n3 = PZMath.clamp(worldMapImages.getMinX(), this.m_worldMap.getMinXInSquares(), this.m_worldMap.getMaxXInSquares());
            int n4 = PZMath.clamp(worldMapImages.getMinY(), this.m_worldMap.getMinYInSquares(), this.m_worldMap.getMaxYInSquares());
            int n5 = PZMath.clamp(worldMapImages.getMaxX(), this.m_worldMap.getMinXInSquares(), this.m_worldMap.getMaxXInSquares() + 1);
            int n6 = PZMath.clamp(worldMapImages.getMaxY(), this.m_worldMap.getMinYInSquares(), this.m_worldMap.getMaxYInSquares() + 1);
            for (int i = 0; i < this.m_rasterizeXY.size() - 1; i += 2) {
                int n7 = this.m_rasterizeXY_ints[i];
                int n8 = this.m_rasterizeXY_ints[i + 1];
                TextureID textureID = worldMapImages.getPyramid().getTexture(n7, n8, n2);
                if (textureID == null || !textureID.isReady()) continue;
                m_vboLinesUV.startRun(textureID);
                float f3 = (float)worldMapImages.getMinX() + (float)n7 * f2;
                float f4 = (float)worldMapImages.getMinY() + (float)n8 * f2;
                float f5 = f3 + f2;
                float f6 = f4 + f2;
                float f7 = PZMath.clamp(f3, (float)n3, (float)n5);
                float f8 = PZMath.clamp(f4, (float)n4, (float)n6);
                float f9 = PZMath.clamp(f5, (float)n3, (float)n5);
                float f10 = PZMath.clamp(f6, (float)n4, (float)n6);
                float f11 = (f7 - this.m_centerWorldX) * f;
                float f12 = (f8 - this.m_centerWorldY) * f;
                float f13 = (f9 - this.m_centerWorldX) * f;
                float f14 = (f8 - this.m_centerWorldY) * f;
                float f15 = (f9 - this.m_centerWorldX) * f;
                float f16 = (f10 - this.m_centerWorldY) * f;
                float f17 = (f7 - this.m_centerWorldX) * f;
                float f18 = (f10 - this.m_centerWorldY) * f;
                float f19 = (f7 - f3) / f2;
                float f20 = (f8 - f4) / f2;
                float f21 = (f9 - f3) / f2;
                float f22 = (f8 - f4) / f2;
                float f23 = (f9 - f3) / f2;
                float f24 = (f10 - f4) / f2;
                float f25 = (f7 - f3) / f2;
                float f26 = (f10 - f4) / f2;
                float f27 = 1.0f;
                float f28 = 1.0f;
                float f29 = 1.0f;
                float f30 = 1.0f;
                m_vboLinesUV.addElement(f11, f12, 0.0f, f19, f20, f27, f28, f29, f30);
                m_vboLinesUV.addElement(f13, f14, 0.0f, f21, f22, f27, f28, f29, f30);
                m_vboLinesUV.addElement(f17, f18, 0.0f, f25, f26, f27, f28, f29, f30);
                m_vboLinesUV.addElement(f13, f14, 0.0f, f21, f22, f27, f28, f29, f30);
                m_vboLinesUV.addElement(f15, f16, 0.0f, f23, f24, f27, f28, f29, f30);
                m_vboLinesUV.addElement(f17, f18, 0.0f, f25, f26, f27, f28, f29, f30);
                if (!this.m_renderer.TileGrid.getValue()) continue;
                m_vboLinesUV.flush();
                m_vboLines.setMode(1);
                m_vboLines.setLineWidth(2.0f);
                m_vboLines.addLine((f3 - this.m_centerWorldX) * f, (f4 - this.m_centerWorldY) * f, 0.0f, (f5 - this.m_centerWorldX) * f, (f4 - this.m_centerWorldY) * f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
                m_vboLines.addLine((f3 - this.m_centerWorldX) * f, (f6 - this.m_centerWorldY) * f, 0.0f, (f5 - this.m_centerWorldX) * f, (f6 - this.m_centerWorldY) * f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
                m_vboLines.addLine((f5 - this.m_centerWorldX) * f, (f4 - this.m_centerWorldY) * f, 0.0f, (f5 - this.m_centerWorldX) * f, (f6 - this.m_centerWorldY) * f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
                m_vboLines.addLine((f3 - this.m_centerWorldX) * f, (f4 - this.m_centerWorldY) * f, 0.0f, (f3 - this.m_centerWorldX) * f, (f6 - this.m_centerWorldY) * f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
                m_vboLines.flush();
            }
        }

        void renderImagePyramidGrid(WorldMapImages worldMapImages) {
            int n;
            float f = this.m_worldScale;
            int n2 = 256;
            int n3 = worldMapImages.getZoom(this.m_zoomF);
            float f2 = n2 * (1 << n3);
            float f3 = ((float)worldMapImages.getMinX() - this.m_centerWorldX) * f;
            float f4 = ((float)worldMapImages.getMinY() - this.m_centerWorldY) * f;
            int n4 = (int)Math.ceil((float)(worldMapImages.getMaxX() - worldMapImages.getMinX()) / f2);
            int n5 = (int)Math.ceil((float)(worldMapImages.getMaxY() - worldMapImages.getMinY()) / f2);
            float f5 = f3;
            float f6 = f4;
            float f7 = f5 + (float)n4 * f2 * f;
            float f8 = f6 + (float)n5 * f2 * f;
            m_vboLines.setMode(1);
            m_vboLines.setLineWidth(2.0f);
            for (n = 0; n < n4 + 1; ++n) {
                m_vboLines.addLine(f3 + (float)n * f2 * f, f6, 0.0f, f3 + (float)n * f2 * f, f8, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
            }
            for (n = 0; n < n5 + 1; ++n) {
                m_vboLines.addLine(f5, f4 + (float)n * f2 * f, 0.0f, f7, f4 + (float)n * f2 * f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
            }
            m_vboLines.flush();
        }

        float triangleArea(float f, float f2, float f3, float f4, float f5, float f6) {
            float f7 = Vector2f.length((float)(f3 - f), (float)(f4 - f2));
            float f8 = Vector2f.length((float)(f5 - f3), (float)(f6 - f4));
            float f9 = Vector2f.length((float)(f - f5), (float)(f2 - f6));
            float f10 = (f7 + f8 + f9) / 2.0f;
            return (float)Math.sqrt(f10 * (f10 - f7) * (f10 - f8) * (f10 - f9));
        }

        void paintAreasOutsideBounds(int n, int n2, int n3, int n4, float f) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6 = this.m_renderOriginX - (float)(n % 300) * f;
            float f7 = this.m_renderOriginY - (float)(n2 % 300) * f;
            float f8 = this.m_renderOriginX + (float)((this.m_worldMap.getMaxXInCells() + 1) * 300 - n) * f;
            float f9 = this.m_renderOriginY + (float)((this.m_worldMap.getMaxYInCells() + 1) * 300 - n2) * f;
            float f10 = 0.0f;
            WorldMapStyleLayer.RGBAf rGBAf = this.m_fill;
            if (n % 300 != 0) {
                f5 = f6;
                f4 = f7;
                f3 = this.m_renderOriginX;
                f2 = f9;
                m_vboLines.setMode(4);
                m_vboLines.addQuad(f5, f4, f3, f2, f10, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
            }
            if (n2 % 300 != 0) {
                f5 = this.m_renderOriginX;
                f4 = f7;
                f3 = f5 + (float)this.m_worldMap.getWidthInSquares() * this.m_worldScale;
                f2 = this.m_renderOriginY;
                m_vboLines.setMode(4);
                m_vboLines.addQuad(f5, f4, f3, f2, f10, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
            }
            if (n3 + 1 != 0) {
                f5 = this.m_renderOriginX + (float)(n3 - n + 1) * f;
                f4 = f7;
                f3 = f8;
                f2 = f9;
                m_vboLines.setMode(4);
                m_vboLines.addQuad(f5, f4, f3, f2, f10, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
            }
            if (n4 + 1 != 0) {
                f5 = this.m_renderOriginX;
                f4 = this.m_renderOriginY + (float)this.m_worldMap.getHeightInSquares() * f;
                f3 = this.m_renderOriginX + (float)this.m_worldMap.getWidthInSquares() * f;
                f2 = f9;
                m_vboLines.setMode(4);
                m_vboLines.addQuad(f5, f4, f3, f2, f10, rGBAf.r, rGBAf.g, rGBAf.b, rGBAf.a);
            }
        }

        void renderWorldBounds() {
            float f = this.m_renderOriginX;
            float f2 = this.m_renderOriginY;
            float f3 = f + (float)this.m_worldMap.getWidthInSquares() * this.m_worldScale;
            float f4 = f2 + (float)this.m_worldMap.getHeightInSquares() * this.m_worldScale;
            this.renderDropShadow();
            m_vboLines.setMode(1);
            m_vboLines.setLineWidth(2.0f);
            float f5 = 0.5f;
            m_vboLines.addLine(f, f2, 0.0f, f3, f2, 0.0f, f5, f5, f5, 1.0f);
            m_vboLines.addLine(f3, f2, 0.0f, f3, f4, 0.0f, f5, f5, f5, 1.0f);
            m_vboLines.addLine(f3, f4, 0.0f, f, f4, 0.0f, f5, f5, f5, 1.0f);
            m_vboLines.addLine(f, f4, 0.0f, f, f2, 0.0f, f5, f5, f5, 1.0f);
        }

        private void renderDropShadow() {
            float f = (float)this.m_renderer.m_dropShadowWidth * ((float)this.m_renderer.getHeight() / 1080.0f) * this.m_worldScale / this.m_renderer.getWorldScale(this.m_renderer.getBaseZoom());
            if (f < 2.0f) {
                return;
            }
            float f2 = this.m_renderOriginX;
            float f3 = this.m_renderOriginY;
            float f4 = f2 + (float)this.m_worldMap.getWidthInSquares() * this.m_worldScale;
            float f5 = f3 + (float)this.m_worldMap.getHeightInSquares() * this.m_worldScale;
            m_vboLines.setMode(4);
            m_vboLines.addElement(f2 + f, f5, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);
            m_vboLines.addElement(f4, f5, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);
            m_vboLines.addElement(f2 + f, f5 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f);
            m_vboLines.addElement(f4, f5, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);
            m_vboLines.addElement(f4 + f, f5 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f);
            m_vboLines.addElement(f2 + f, f5 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f);
            m_vboLines.addElement(f4, f3 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);
            m_vboLines.addElement(f4 + f, f3 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f);
            m_vboLines.addElement(f4, f5, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);
            m_vboLines.addElement(f4 + f, f3 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f);
            m_vboLines.addElement(f4 + f, f5 + f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f);
            m_vboLines.addElement(f4, f5, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);
        }

        @Override
        public void postRender() {
            for (int i = 0; i < this.m_playerRenderData.length; ++i) {
                PlayerRenderData playerRenderData = this.m_playerRenderData[i];
                if (playerRenderData.m_modelSlotRenderData == null) continue;
                playerRenderData.m_modelSlotRenderData.postRender();
            }
        }
    }

    private static final class CharacterModelCamera
    extends ModelCamera {
        float m_worldScale;
        float m_angle;
        float m_playerX;
        float m_playerY;
        boolean m_bVehicle;

        private CharacterModelCamera() {
        }

        @Override
        public void Begin() {
            Matrix4f matrix4f = WorldMapRenderer.allocMatrix4f();
            matrix4f.identity();
            matrix4f.translate(this.m_playerX * this.m_worldScale, this.m_playerY * this.m_worldScale, 0.0f);
            matrix4f.rotateX(1.5707964f);
            matrix4f.rotateY(this.m_angle + 4.712389f);
            if (this.m_bVehicle) {
                matrix4f.scale(this.m_worldScale);
            } else {
                matrix4f.scale(1.5f * this.m_worldScale);
            }
            PZGLUtil.pushAndMultMatrix(5888, matrix4f);
            WorldMapRenderer.releaseMatrix4f(matrix4f);
        }

        @Override
        public void End() {
            PZGLUtil.popMatrix(5888);
        }
    }

    public final class WorldMapBooleanOption
    extends BooleanConfigOption {
        public WorldMapBooleanOption(String string, boolean bl) {
            super(string, bl);
            WorldMapRenderer.this.options.add(this);
        }
    }

    public final class WorldMapDoubleOption
    extends DoubleConfigOption {
        public WorldMapDoubleOption(String string, double d, double d2, double d3) {
            super(string, d, d2, d3);
            WorldMapRenderer.this.options.add(this);
        }
    }

    private static final class PlayerRenderData {
        ModelSlotRenderData m_modelSlotRenderData;
        float m_angle;
        float m_x;
        float m_y;

        private PlayerRenderData() {
        }
    }
}

