/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;
import java.util.HashMap;
import zombie.characters.IsoPlayer;
import zombie.worldMap.WorldMapRemotePlayer;

public final class WorldMapRemotePlayers {
    public static final WorldMapRemotePlayers instance = new WorldMapRemotePlayers();
    private final ArrayList<WorldMapRemotePlayer> playerList = new ArrayList();
    private final HashMap<Short, WorldMapRemotePlayer> playerLookup = new HashMap();

    public WorldMapRemotePlayer getOrCreatePlayerByID(short s) {
        WorldMapRemotePlayer worldMapRemotePlayer = this.playerLookup.get(s);
        if (worldMapRemotePlayer == null) {
            worldMapRemotePlayer = new WorldMapRemotePlayer(s);
            this.playerList.add(worldMapRemotePlayer);
            this.playerLookup.put(s, worldMapRemotePlayer);
        }
        return worldMapRemotePlayer;
    }

    public WorldMapRemotePlayer getOrCreatePlayer(IsoPlayer isoPlayer) {
        return this.getOrCreatePlayerByID(isoPlayer.OnlineID);
    }

    public WorldMapRemotePlayer getPlayerByID(short s) {
        return this.playerLookup.get(s);
    }

    public ArrayList<WorldMapRemotePlayer> getPlayers() {
        return this.playerList;
    }

    public void removePlayerByID(short s) {
        this.playerList.removeIf(worldMapRemotePlayer -> worldMapRemotePlayer.getOnlineID() == s);
        this.playerLookup.remove(s);
    }

    public void Reset() {
        this.playerList.clear();
        this.playerLookup.clear();
    }
}

