/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import zombie.characters.IsoPlayer;
import zombie.network.GameClient;
import zombie.network.ServerOptions;

public final class WorldMapRemotePlayer {
    private short changeCount = 0;
    private final short OnlineID;
    private String username = "???";
    private String forename = "???";
    private String surname = "???";
    private String accessLevel = "None";
    private float x;
    private float y;
    private boolean invisible = false;
    private boolean bHasFullData = false;

    public WorldMapRemotePlayer(short s) {
        this.OnlineID = s;
    }

    public void setPlayer(IsoPlayer isoPlayer) {
        boolean bl = false;
        if (!this.username.equals(isoPlayer.username)) {
            this.username = isoPlayer.username;
            bl = true;
        }
        if (!this.forename.equals(isoPlayer.getDescriptor().getForename())) {
            this.forename = isoPlayer.getDescriptor().getForename();
            bl = true;
        }
        if (!this.surname.equals(isoPlayer.getDescriptor().getSurname())) {
            this.surname = isoPlayer.getDescriptor().getSurname();
            bl = true;
        }
        if (!this.accessLevel.equals(isoPlayer.accessLevel)) {
            this.accessLevel = isoPlayer.accessLevel;
            bl = true;
        }
        this.x = isoPlayer.x;
        this.y = isoPlayer.y;
        if (this.invisible != isoPlayer.isInvisible()) {
            this.invisible = isoPlayer.isInvisible();
            bl = true;
        }
        if (bl) {
            this.changeCount = (short)(this.changeCount + 1);
        }
    }

    public void setFullData(short s, String string, String string2, String string3, String string4, float f, float f2, boolean bl) {
        this.changeCount = s;
        this.username = string;
        this.forename = string2;
        this.surname = string3;
        this.accessLevel = string4;
        this.x = f;
        this.y = f2;
        this.invisible = bl;
        this.bHasFullData = true;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public short getOnlineID() {
        return this.OnlineID;
    }

    public String getForename() {
        return this.forename;
    }

    public String getSurname() {
        return this.surname;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public short getChangeCount() {
        return this.changeCount;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean hasFullData() {
        return this.bHasFullData;
    }

    public String getUsername(Boolean bl) {
        Object object = this.username;
        if (bl.booleanValue() && GameClient.bClient && ServerOptions.instance.ShowFirstAndLastName.getValue() && this.isAccessLevel("None")) {
            object = this.forename + " " + this.surname;
            if (ServerOptions.instance.DisplayUserName.getValue()) {
                object = (String)object + " (" + this.username + ")";
            }
        }
        return object;
    }

    public String getUsername() {
        return this.getUsername(false);
    }

    public String getAccessLevel() {
        return switch (this.accessLevel) {
            case "admin" -> "Admin";
            case "moderator" -> "Moderator";
            case "overseer" -> "Overseer";
            case "gm" -> "GM";
            case "observer" -> "Observer";
            default -> "None";
        };
    }

    public boolean isAccessLevel(String string) {
        return this.getAccessLevel().equalsIgnoreCase(string);
    }
}

