/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import zombie.ZomboidFileSystem;
import zombie.core.math.PZMath;
import zombie.worldMap.ImagePyramid;

public final class WorldMapImages {
    private static final HashMap<String, WorldMapImages> s_filenameToImages = new HashMap();
    private String m_directory;
    private ImagePyramid m_pyramid;

    public static WorldMapImages getOrCreate(String string) {
        String string2 = ZomboidFileSystem.instance.getString(string + "/pyramid.zip");
        if (!Files.exists(Paths.get(string2, new String[0]), new LinkOption[0])) {
            return null;
        }
        WorldMapImages worldMapImages = s_filenameToImages.get(string2);
        if (worldMapImages == null) {
            worldMapImages = new WorldMapImages();
            worldMapImages.m_directory = string;
            worldMapImages.m_pyramid = new ImagePyramid();
            worldMapImages.m_pyramid.setZipFile(string2);
            s_filenameToImages.put(string2, worldMapImages);
        }
        return worldMapImages;
    }

    public ImagePyramid getPyramid() {
        return this.m_pyramid;
    }

    public int getMinX() {
        return this.m_pyramid.m_minX;
    }

    public int getMinY() {
        return this.m_pyramid.m_minY;
    }

    public int getMaxX() {
        return this.m_pyramid.m_maxX;
    }

    public int getMaxY() {
        return this.m_pyramid.m_maxY;
    }

    public int getZoom(float f) {
        int n = 4;
        if ((double)f >= 16.0) {
            n = 0;
        } else if (f >= 15.0f) {
            n = 1;
        } else if (f >= 14.0f) {
            n = 2;
        } else if (f >= 13.0f) {
            n = 3;
        }
        n = PZMath.clamp(n, this.m_pyramid.m_minZ, this.m_pyramid.m_maxZ);
        return n;
    }

    public float getResolution() {
        return this.m_pyramid.m_resolution;
    }

    private void destroy() {
        this.m_pyramid.destroy();
    }

    public static void Reset() {
        for (WorldMapImages worldMapImages : s_filenameToImages.values()) {
            worldMapImages.destroy();
        }
        s_filenameToImages.clear();
    }
}

