/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import zombie.DebugFileWatcher;
import zombie.PredicatedFileWatcher;
import zombie.asset.Asset;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetTask;
import zombie.asset.AssetTask_RunFileTask;
import zombie.debug.DebugLog;
import zombie.fileSystem.FileSystem;
import zombie.fileSystem.FileTask;
import zombie.worldMap.FileTask_LoadWorldMapBinary;
import zombie.worldMap.FileTask_LoadWorldMapXML;
import zombie.worldMap.WorldMapData;

public final class WorldMapDataAssetManager
extends AssetManager {
    public static final WorldMapDataAssetManager instance = new WorldMapDataAssetManager();

    @Override
    protected void startLoading(Asset asset) {
        WorldMapData worldMapData = (WorldMapData)asset;
        FileSystem fileSystem = this.getOwner().getFileSystem();
        String string = asset.getPath().getPath();
        FileTask fileTask = Files.exists(Paths.get(string + ".bin", new String[0]), new LinkOption[0]) ? new FileTask_LoadWorldMapBinary(worldMapData, string + ".bin", fileSystem, object -> this.loadCallback(worldMapData, object)) : new FileTask_LoadWorldMapXML(worldMapData, string, fileSystem, object -> this.loadCallback(worldMapData, object));
        fileTask.setPriority(4);
        AssetTask_RunFileTask assetTask_RunFileTask = new AssetTask_RunFileTask(fileTask, asset);
        this.setTask(asset, assetTask_RunFileTask);
        ((AssetTask)assetTask_RunFileTask).execute();
    }

    private void loadCallback(WorldMapData worldMapData, Object object) {
        if (object == Boolean.TRUE) {
            worldMapData.onLoaded();
            this.onLoadingSucceeded(worldMapData);
        } else {
            DebugLog.General.warn("Failed to load asset: " + worldMapData.getPath());
            this.onLoadingFailed(worldMapData);
        }
    }

    @Override
    protected Asset createAsset(AssetPath assetPath, AssetManager.AssetParams assetParams) {
        WorldMapData worldMapData = new WorldMapData(assetPath, this, assetParams);
        DebugFileWatcher.instance.add(new PredicatedFileWatcher(assetPath.getPath(), string -> this.reload(worldMapData, assetParams)));
        return worldMapData;
    }

    @Override
    protected void destroyAsset(Asset asset) {
    }
}

