/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.asset.Asset;
import zombie.asset.AssetManager;
import zombie.asset.AssetPath;
import zombie.asset.AssetType;
import zombie.core.math.PZMath;
import zombie.worldMap.WorldMapCell;
import zombie.worldMap.WorldMapDataAssetManager;
import zombie.worldMap.WorldMapFeature;

public final class WorldMapData
extends Asset {
    public static final HashMap<String, WorldMapData> s_fileNameToData = new HashMap();
    public String m_relativeFileName;
    public final ArrayList<WorldMapCell> m_cells = new ArrayList();
    public final HashMap<Integer, WorldMapCell> m_cellLookup = new HashMap();
    public int m_minX;
    public int m_minY;
    public int m_maxX;
    public int m_maxY;
    public static final AssetType ASSET_TYPE = new AssetType("WorldMapData");

    public static WorldMapData getOrCreateData(String string) {
        WorldMapData worldMapData = s_fileNameToData.get(string);
        if (worldMapData == null && Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) {
            worldMapData = (WorldMapData)WorldMapDataAssetManager.instance.load(new AssetPath(string));
            s_fileNameToData.put(string, worldMapData);
        }
        return worldMapData;
    }

    public WorldMapData(AssetPath assetPath, AssetManager assetManager) {
        super(assetPath, assetManager);
    }

    public WorldMapData(AssetPath assetPath, AssetManager assetManager, AssetManager.AssetParams assetParams) {
        super(assetPath, assetManager);
    }

    public void clear() {
        for (WorldMapCell worldMapCell : this.m_cells) {
            worldMapCell.dispose();
        }
        this.m_cells.clear();
        this.m_cellLookup.clear();
        this.m_minX = 0;
        this.m_minY = 0;
        this.m_maxX = 0;
        this.m_maxY = 0;
    }

    public int getWidthInCells() {
        return this.m_maxX - this.m_minX + 1;
    }

    public int getHeightInCells() {
        return this.m_maxY - this.m_minY + 1;
    }

    public int getWidthInSquares() {
        return this.getWidthInCells() * 300;
    }

    public int getHeightInSquares() {
        return this.getHeightInCells() * 300;
    }

    public void onLoaded() {
        this.m_minX = Integer.MAX_VALUE;
        this.m_minY = Integer.MAX_VALUE;
        this.m_maxX = Integer.MIN_VALUE;
        this.m_maxY = Integer.MIN_VALUE;
        this.m_cellLookup.clear();
        for (WorldMapCell worldMapCell : this.m_cells) {
            Integer n = this.getCellKey(worldMapCell.m_x, worldMapCell.m_y);
            this.m_cellLookup.put(n, worldMapCell);
            this.m_minX = Math.min(this.m_minX, worldMapCell.m_x);
            this.m_minY = Math.min(this.m_minY, worldMapCell.m_y);
            this.m_maxX = Math.max(this.m_maxX, worldMapCell.m_x);
            this.m_maxY = Math.max(this.m_maxY, worldMapCell.m_y);
        }
    }

    public WorldMapCell getCell(int n, int n2) {
        Integer n3 = this.getCellKey(n, n2);
        return this.m_cellLookup.get(n3);
    }

    private Integer getCellKey(int n, int n2) {
        return n + n2 * 1000;
    }

    public void hitTest(float f, float f2, ArrayList<WorldMapFeature> arrayList) {
        int n = (int)PZMath.floor(f / 300.0f);
        int n2 = (int)PZMath.floor(f2 / 300.0f);
        if (n < this.m_minX || n > this.m_maxX || n2 < this.m_minY || n2 > this.m_maxY) {
            return;
        }
        WorldMapCell worldMapCell = this.getCell(n, n2);
        if (worldMapCell == null) {
            return;
        }
        worldMapCell.hitTest(f, f2, arrayList);
    }

    public static void Reset() {
    }

    @Override
    public AssetType getType() {
        return ASSET_TYPE;
    }

    @Override
    protected void onBeforeEmpty() {
        super.onBeforeEmpty();
        this.clear();
    }
}

