/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.util.SharedStrings;
import zombie.worldMap.WorldMapCell;
import zombie.worldMap.WorldMapData;
import zombie.worldMap.WorldMapFeature;
import zombie.worldMap.WorldMapGeometry;
import zombie.worldMap.WorldMapPoints;
import zombie.worldMap.WorldMapProperties;

public final class WorldMapBinary {
    private static final int VERSION1 = 1;
    private static final int VERSION_LATEST = 1;
    private final SharedStrings m_sharedStrings = new SharedStrings();
    private final TIntObjectHashMap<String> m_stringTable = new TIntObjectHashMap();
    private final WorldMapProperties m_properties = new WorldMapProperties();
    private final ArrayList<WorldMapProperties> m_sharedProperties = new ArrayList();

    public boolean read(String string, WorldMapData worldMapData) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            int n;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                int n2 = bufferedInputStream.read();
                int n3 = bufferedInputStream.read();
                int n4 = bufferedInputStream.read();
                int n5 = bufferedInputStream.read();
                if (n2 != 73 || n3 != 71 || n4 != 77 || n5 != 66) {
                    throw new IOException("invalid format (magic doesn't match)");
                }
                int n6 = this.readInt(bufferedInputStream);
                if (n6 < 1 || n6 > 1) {
                    throw new IOException("unrecognized version " + n6);
                }
                int n7 = this.readInt(bufferedInputStream);
                int n8 = this.readInt(bufferedInputStream);
                this.readStringTable(bufferedInputStream);
                for (n = 0; n < n8; n += 1) {
                    for (int i = 0; i < n7; ++i) {
                        WorldMapCell worldMapCell = this.parseCell(bufferedInputStream);
                        if (worldMapCell == null) continue;
                        worldMapData.m_cells.add(worldMapCell);
                    }
                }
                n = 1;
            }
            return n != 0;
        }
    }

    private int readByte(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    private int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 0) + (n3 << 8) + (n2 << 16) + (n << 24);
    }

    private int readShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 0) + (n << 8));
    }

    private void readStringTable(InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        byte[] byArray = new byte[1024];
        int n = this.readInt(inputStream);
        for (int i = 0; i < n; ++i) {
            byteBuffer.clear();
            int n2 = this.readShort(inputStream);
            byteBuffer.putShort((short)n2);
            inputStream.read(byArray, 0, n2);
            byteBuffer.put(byArray, 0, n2);
            byteBuffer.flip();
            this.m_stringTable.put(i, (Object)GameWindow.ReadStringUTF(byteBuffer));
        }
    }

    private String readStringIndexed(InputStream inputStream) throws IOException {
        int n = this.readShort(inputStream);
        if (!this.m_stringTable.containsKey(n)) {
            throw new IOException("invalid string-table index " + n);
        }
        return (String)this.m_stringTable.get(n);
    }

    private WorldMapCell parseCell(InputStream inputStream) throws IOException {
        int n = this.readInt(inputStream);
        if (n == -1) {
            return null;
        }
        int n2 = this.readInt(inputStream);
        WorldMapCell worldMapCell = new WorldMapCell();
        worldMapCell.m_x = n;
        worldMapCell.m_y = n2;
        int n3 = this.readInt(inputStream);
        for (int i = 0; i < n3; ++i) {
            WorldMapFeature worldMapFeature = this.parseFeature(worldMapCell, inputStream);
            worldMapCell.m_features.add(worldMapFeature);
        }
        return worldMapCell;
    }

    private WorldMapFeature parseFeature(WorldMapCell worldMapCell, InputStream inputStream) throws IOException {
        WorldMapFeature worldMapFeature = new WorldMapFeature(worldMapCell);
        WorldMapGeometry worldMapGeometry = this.parseGeometry(inputStream);
        worldMapFeature.m_geometries.add(worldMapGeometry);
        this.parseFeatureProperties(inputStream, worldMapFeature);
        return worldMapFeature;
    }

    private void parseFeatureProperties(InputStream inputStream, WorldMapFeature worldMapFeature) throws IOException {
        this.m_properties.clear();
        int n = this.readByte(inputStream);
        for (int i = 0; i < n; ++i) {
            String string = this.m_sharedStrings.get(this.readStringIndexed(inputStream));
            String string2 = this.m_sharedStrings.get(this.readStringIndexed(inputStream));
            this.m_properties.put(string, string2);
        }
        worldMapFeature.m_properties = this.getOrCreateProperties(this.m_properties);
    }

    private WorldMapProperties getOrCreateProperties(WorldMapProperties worldMapProperties) {
        for (int i = 0; i < this.m_sharedProperties.size(); ++i) {
            if (!this.m_sharedProperties.get(i).equals(worldMapProperties)) continue;
            return this.m_sharedProperties.get(i);
        }
        WorldMapProperties worldMapProperties2 = new WorldMapProperties();
        worldMapProperties2.putAll(worldMapProperties);
        this.m_sharedProperties.add(worldMapProperties2);
        return worldMapProperties2;
    }

    private WorldMapGeometry parseGeometry(InputStream inputStream) throws IOException {
        WorldMapGeometry worldMapGeometry = new WorldMapGeometry();
        worldMapGeometry.m_type = WorldMapGeometry.Type.valueOf(this.readStringIndexed(inputStream));
        int n = this.readByte(inputStream);
        for (int i = 0; i < n; ++i) {
            WorldMapPoints worldMapPoints = new WorldMapPoints();
            this.parseGeometryCoordinates(inputStream, worldMapPoints);
            worldMapGeometry.m_points.add(worldMapPoints);
        }
        worldMapGeometry.calculateBounds();
        return worldMapGeometry;
    }

    private void parseGeometryCoordinates(InputStream inputStream, WorldMapPoints worldMapPoints) throws IOException {
        int n = this.readShort(inputStream);
        for (int i = 0; i < n; ++i) {
            worldMapPoints.add(this.readShort(inputStream));
            worldMapPoints.add(this.readShort(inputStream));
        }
    }
}

