/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import zombie.core.SpriteRenderer;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.VBO.IGLBufferObject;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureID;
import zombie.popman.ObjectPool;

public final class VBOLinesUV {
    private final int VERTEX_SIZE = 12;
    private final int COLOR_SIZE = 16;
    private final int UV_SIZE = 8;
    private final int ELEMENT_SIZE = 36;
    private final int COLOR_OFFSET = 12;
    private final int UV_OFFSET = 28;
    private final int NUM_ELEMENTS = 128;
    private final int INDEX_SIZE = 2;
    private GLVertexBufferObject m_vbo;
    private GLVertexBufferObject m_ibo;
    private ByteBuffer m_elements;
    private ByteBuffer m_indices;
    private float m_lineWidth = 1.0f;
    private float m_dx = 0.0f;
    private float m_dy = 0.0f;
    private float m_dz = 0.0f;
    private int m_mode = 1;
    private final ObjectPool<Run> m_runPool = new ObjectPool<Run>(Run::new);
    private final ArrayList<Run> m_runs = new ArrayList();

    private Run currentRun() {
        return this.m_runs.isEmpty() ? null : this.m_runs.get(this.m_runs.size() - 1);
    }

    private void create() {
        this.m_elements = BufferUtils.createByteBuffer((int)4608);
        this.m_indices = BufferUtils.createByteBuffer((int)256);
        IGLBufferObject iGLBufferObject = GLVertexBufferObject.funcs;
        this.m_vbo = new GLVertexBufferObject(4608L, iGLBufferObject.GL_ARRAY_BUFFER(), iGLBufferObject.GL_STREAM_DRAW());
        this.m_vbo.create();
        this.m_ibo = new GLVertexBufferObject(256L, iGLBufferObject.GL_ELEMENT_ARRAY_BUFFER(), iGLBufferObject.GL_STREAM_DRAW());
        this.m_ibo.create();
    }

    public void setOffset(float f, float f2, float f3) {
        this.m_dx = f;
        this.m_dy = f2;
        this.m_dz = f3;
    }

    public void addElement(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.isFull()) {
            TextureID textureID = this.currentRun().textureID;
            this.flush();
            this.startRun(textureID);
        }
        if (this.m_elements == null) {
            this.create();
        }
        this.m_elements.putFloat(this.m_dx + f);
        this.m_elements.putFloat(this.m_dy + f2);
        this.m_elements.putFloat(this.m_dz + f3);
        this.m_elements.putFloat(f6);
        this.m_elements.putFloat(f7);
        this.m_elements.putFloat(f8);
        this.m_elements.putFloat(f9);
        this.m_elements.putFloat(f4);
        this.m_elements.putFloat(f5);
        short s = (short)(this.m_indices.position() / 2);
        this.m_indices.putShort(s);
        ++this.currentRun().count;
    }

    public void addElement(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.addElement(f, f2, f3, 0.0f, 0.0f, f4, f5, f6, f7);
    }

    public void addLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.addElement(f, f2, f3, f7, f8, f9, f10);
        this.addElement(f4, f5, f6, f7, f8, f9, f10);
    }

    public void addLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        this.addElement(f, f2, f3, f7, f8, f9, f10);
        this.addElement(f4, f5, f6, f11, f12, f13, f14);
    }

    public void addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19) {
        this.reserve(3);
        this.addElement(f, f2, f3, f4, f5, f16, f17, f18, f19);
        this.addElement(f6, f7, f8, f9, f10, f16, f17, f18, f19);
        this.addElement(f11, f12, f13, f14, f15, f16, f17, f18, f19);
    }

    public void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.reserve(4);
        this.addElement(f, f2, f9, f3, f4, f10, f11, f12, f13);
        this.addElement(f5, f2, f9, f7, f4, f10, f11, f12, f13);
        this.addElement(f5, f6, f9, f7, f8, f10, f11, f12, f13);
        this.addElement(f, f6, f9, f3, f8, f10, f11, f12, f13);
    }

    public void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21) {
        this.reserve(4);
        this.addElement(f, f2, f17, f3, f4, f18, f19, f20, f21);
        this.addElement(f5, f6, f17, f7, f8, f18, f19, f20, f21);
        this.addElement(f9, f10, f17, f11, f12, f18, f19, f20, f21);
        this.addElement(f13, f14, f17, f15, f16, f18, f19, f20, f21);
    }

    boolean isFull() {
        if (this.m_elements == null) {
            return false;
        }
        if (this.m_mode == 4 && this.m_elements.position() % 108 == 0 && this.m_elements.position() + 108 > 4608) {
            return true;
        }
        return this.m_elements.position() == 4608;
    }

    public void reserve(int n) {
        if (!this.hasRoomFor(n)) {
            TextureID textureID = this.currentRun() == null ? null : this.currentRun().textureID;
            this.flush();
            if (textureID != null) {
                this.startRun(textureID);
            }
        }
    }

    boolean hasRoomFor(int n) {
        return this.m_elements == null || this.m_elements.position() / 36 + n <= 128;
    }

    public void flush() {
        if (this.m_elements == null || this.m_elements.position() == 0) {
            return;
        }
        this.m_elements.flip();
        this.m_indices.flip();
        GL13.glClientActiveTexture((int)33984);
        GL11.glEnableClientState((int)32888);
        this.m_vbo.bind();
        this.m_vbo.bufferData(this.m_elements);
        this.m_ibo.bind();
        this.m_ibo.bufferData(this.m_indices);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        GL11.glVertexPointer((int)3, (int)5126, (int)36, (long)0L);
        GL11.glColorPointer((int)4, (int)5126, (int)36, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)36, (long)28L);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)this.m_lineWidth);
        for (int i = 0; i < this.m_runs.size(); ++i) {
            Run run = this.m_runs.get(i);
            int n = run.start;
            int n2 = run.count;
            int n3 = run.start;
            int n4 = n3 + run.count;
            if (run.textureID.getID() == -1) {
                run.textureID.bind();
            } else {
                Texture.lastTextureID = run.textureID.getID();
                GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            }
            GL12.glDrawRangeElements((int)this.m_mode, (int)n, (int)(n + n2), (int)(n4 - n3), (int)5123, (long)((long)n3 * 2L));
        }
        this.m_vbo.bindNone();
        this.m_ibo.bindNone();
        this.m_elements.clear();
        this.m_indices.clear();
        this.m_runPool.releaseAll(this.m_runs);
        this.m_runs.clear();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2848);
        GL13.glClientActiveTexture((int)33984);
        SpriteRenderer.ringBuffer.restoreVBOs = true;
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
    }

    public void setLineWidth(float f) {
        if (!PZMath.equal(this.m_lineWidth, f, 0.01f)) {
            TextureID textureID = this.currentRun() == null ? null : this.currentRun().textureID;
            this.flush();
            if (textureID != null) {
                this.startRun(textureID);
            }
            this.m_lineWidth = f;
        }
    }

    public void setMode(int n) {
        assert (n == 1 || n == 4 || n == 7);
        if (n != this.m_mode) {
            TextureID textureID = this.currentRun() == null ? null : this.currentRun().textureID;
            this.flush();
            if (textureID != null) {
                this.startRun(textureID);
            }
            this.m_mode = n;
        }
    }

    public void startRun(TextureID textureID) {
        Run run = this.m_runPool.alloc();
        run.start = this.m_elements == null ? 0 : this.m_elements.position() / 36;
        run.count = 0;
        run.textureID = textureID;
        this.m_runs.add(run);
    }

    private static final class Run {
        int start;
        int count;
        TextureID textureID;

        private Run() {
        }
    }
}

