/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.function.BiConsumer;

public final class Rasterize {
    final Edge edge1 = new Edge();
    final Edge edge2 = new Edge();
    final Edge edge3 = new Edge();

    void scanLine(int n, int n2, int n3, BiConsumer<Integer, Integer> biConsumer) {
        for (int i = n; i < n2; ++i) {
            biConsumer.accept(i, n3);
        }
    }

    void scanSpan(Edge edge, Edge edge2, int n, int n2, BiConsumer<Integer, Integer> biConsumer) {
        int n3 = (int)Math.max((double)n, Math.floor(edge2.y0));
        int n4 = (int)Math.min((double)n2, Math.ceil(edge2.y1));
        if (edge.x0 == edge2.x0 && edge.y0 == edge2.y0) {
            if (edge.x0 + edge2.dy / edge.dy * edge.dx < edge2.x1) {
                var8_8 = edge;
                edge = edge2;
                edge2 = var8_8;
            }
        } else if (edge.x1 - edge2.dy / edge.dy * edge.dx < edge2.x0) {
            var8_8 = edge;
            edge = edge2;
            edge2 = var8_8;
        }
        double d = edge.dx / edge.dy;
        double d2 = edge2.dx / edge2.dy;
        double d3 = edge.dx > 0.0f ? 1.0 : 0.0;
        double d4 = edge2.dx < 0.0f ? 1.0 : 0.0;
        for (int i = n3; i < n4; ++i) {
            double d5 = d * Math.max(0.0, Math.min((double)edge.dy, (double)i + d3 - (double)edge.y0)) + (double)edge.x0;
            double d6 = d2 * Math.max(0.0, Math.min((double)edge2.dy, (double)i + d4 - (double)edge2.y0)) + (double)edge2.x0;
            this.scanLine((int)Math.floor(d6), (int)Math.ceil(d5), i, biConsumer);
        }
    }

    void scanTriangle(float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, BiConsumer<Integer, Integer> biConsumer) {
        Edge edge;
        Edge edge2 = this.edge1.init(f, f2, f3, f4);
        Edge edge3 = this.edge2.init(f3, f4, f5, f6);
        Edge edge4 = this.edge3.init(f5, f6, f, f2);
        if (edge2.dy > edge4.dy) {
            edge = edge2;
            edge2 = edge4;
            edge4 = edge;
        }
        if (edge3.dy > edge4.dy) {
            edge = edge3;
            edge3 = edge4;
            edge4 = edge;
        }
        if (edge2.dy > 0.0f) {
            this.scanSpan(edge4, edge2, n, n2, biConsumer);
        }
        if (edge3.dy > 0.0f) {
            this.scanSpan(edge4, edge3, n, n2, biConsumer);
        }
    }

    private static final class Edge {
        float x0;
        float y0;
        float x1;
        float y1;
        float dx;
        float dy;

        private Edge() {
        }

        Edge init(float f, float f2, float f3, float f4) {
            if (f2 > f4) {
                this.x0 = f3;
                this.y0 = f4;
                this.x1 = f;
                this.y1 = f2;
            } else {
                this.x0 = f;
                this.y0 = f2;
                this.x1 = f3;
                this.y1 = f4;
            }
            this.dx = this.x1 - this.x0;
            this.dy = this.y1 - this.y0;
            return this;
        }
    }
}

