/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import org.joml.Vector2d;

public final class MapProjection {
    public static final double EARTH_RADIUS_METERS = 6378137.0;
    public static final double EARTH_HALF_CIRCUMFERENCE_METERS = 2.0037508342789244E7;
    public static final double EARTH_CIRCUMFERENCE_METERS = 4.007501668557849E7;
    public static final double MAX_LATITUDE_DEGREES = 85.05112878;
    private static final double LOG_2 = Math.log(2.0);

    static ProjectedMeters lngLatToProjectedMeters(LngLat lngLat) {
        ProjectedMeters projectedMeters = new ProjectedMeters();
        projectedMeters.x = lngLat.longitude * 2.0037508342789244E7 / 180.0;
        projectedMeters.y = Math.log(Math.tan(0.7853981633974483 + lngLat.latitude * Math.PI / 360.0)) * 6378137.0;
        return projectedMeters;
    }

    static double metersPerTileAtZoom(int n) {
        return 4.007501668557849E7 / (double)(1 << n);
    }

    static double metersPerPixelAtZoom(double d, double d2) {
        return 4.007501668557849E7 / (MapProjection.exp2(d) * d2);
    }

    static double zoomAtMetersPerPixel(double d, double d2) {
        return MapProjection.log2(4.007501668557849E7 / (d * d2));
    }

    static BoundingBox mapLngLatBounds() {
        return new BoundingBox(new Vector2d(-180.0, -85.05112878), new Vector2d(180.0, 85.05112878));
    }

    static BoundingBox mapProjectedMetersBounds() {
        BoundingBox boundingBox = MapProjection.mapLngLatBounds();
        return new BoundingBox(MapProjection.lngLatToProjectedMeters(new LngLat(boundingBox.min.x, boundingBox.min.y)), MapProjection.lngLatToProjectedMeters(new LngLat(boundingBox.max.x, boundingBox.max.y)));
    }

    public static double exp2(double d) {
        return Math.pow(2.0, d);
    }

    public static double log2(double d) {
        return Math.log(d) / LOG_2;
    }

    public static final class ProjectedMeters
    extends Vector2d {
    }

    public static final class LngLat {
        double longitude = 0.0;
        double latitude = 0.0;

        public LngLat(double d, double d2) {
            this.longitude = d;
            this.latitude = d2;
        }
    }

    public static final class BoundingBox {
        Vector2d min;
        Vector2d max;

        public BoundingBox(Vector2d vector2d, Vector2d vector2d2) {
            this.min = vector2d;
            this.max = vector2d2;
        }
    }
}

