/*
 * Decompiled with CFR 0.152.
 */
package zombie.world.moddata;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.world.WorldDictionary;

public final class GlobalModData {
    public static final String SAVE_EXT = ".bin";
    public static final String SAVE_FILE = "global_mod_data";
    public static GlobalModData instance = new GlobalModData();
    private Map<String, KahluaTable> modData = new HashMap<String, KahluaTable>();
    private static final int BLOCK_SIZE = 524288;
    private static int LAST_BLOCK_SIZE = -1;

    private KahluaTable createModDataTable() {
        return LuaManager.platform.newTable();
    }

    public GlobalModData() {
        this.reset();
    }

    public void init() throws IOException {
        this.reset();
        this.load();
        LuaEventManager.triggerEvent("OnInitGlobalModData", WorldDictionary.isIsNewGame());
    }

    public void reset() {
        LAST_BLOCK_SIZE = -1;
        this.modData.clear();
    }

    public void collectTableNames(List<String> list) {
        list.clear();
        for (Map.Entry<String, KahluaTable> entry : this.modData.entrySet()) {
            list.add(entry.getKey());
        }
    }

    public boolean exists(String string) {
        return this.modData.containsKey(string);
    }

    public KahluaTable getOrCreate(String string) {
        KahluaTable kahluaTable = this.get(string);
        if (kahluaTable == null) {
            kahluaTable = this.create(string);
        }
        return kahluaTable;
    }

    public KahluaTable get(String string) {
        return this.modData.get(string);
    }

    public String create() {
        String string = UUID.randomUUID().toString();
        this.create(string);
        return string;
    }

    public KahluaTable create(String string) {
        if (this.exists(string)) {
            DebugLog.log("GlobalModData -> Cannot create table '" + string + "', already exists. Returning null.");
            return null;
        }
        KahluaTable kahluaTable = this.createModDataTable();
        this.modData.put(string, kahluaTable);
        return kahluaTable;
    }

    public KahluaTable remove(String string) {
        return this.modData.remove(string);
    }

    public void add(String string, KahluaTable kahluaTable) {
        this.modData.put(string, kahluaTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(String string) {
        KahluaTable kahluaTable = this.get(string);
        if (kahluaTable != null) {
            if (GameClient.bClient) {
                ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                PacketTypes.PacketType.GlobalModData.doPacket(byteBufferWriter);
                ByteBuffer byteBuffer = byteBufferWriter.bb;
                try {
                    GameWindow.WriteString(byteBuffer, string);
                    byteBuffer.put((byte)1);
                    kahluaTable.save(byteBuffer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GameClient.connection.cancelPacket();
                }
                finally {
                    PacketTypes.PacketType.GlobalModData.send(GameClient.connection);
                }
            } else if (GameServer.bServer) {
                try {
                    for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                        UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                        PacketTypes.PacketType.GlobalModData.doPacket(byteBufferWriter);
                        ByteBuffer byteBuffer = byteBufferWriter.bb;
                        try {
                            GameWindow.WriteString(byteBuffer, string);
                            byteBuffer.put((byte)1);
                            kahluaTable.save(byteBuffer);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            udpConnection.cancelPacket();
                            continue;
                        }
                        finally {
                            PacketTypes.PacketType.GlobalModData.send(udpConnection);
                        }
                    }
                }
                catch (Exception exception) {
                    DebugLog.log(exception.getMessage());
                }
            }
        } else {
            DebugLog.log("GlobalModData -> cannot transmit moddata not found: " + string);
        }
    }

    public void receive(ByteBuffer byteBuffer) {
        try {
            String string = GameWindow.ReadString(byteBuffer);
            if (byteBuffer.get() != 1) {
                LuaEventManager.triggerEvent("OnReceiveGlobalModData", string, false);
                return;
            }
            KahluaTable kahluaTable = this.createModDataTable();
            kahluaTable.load(byteBuffer, 195);
            LuaEventManager.triggerEvent("OnReceiveGlobalModData", string, kahluaTable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(String string) {
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.GlobalModDataRequest.doPacket(byteBufferWriter);
            ByteBuffer byteBuffer = byteBufferWriter.bb;
            try {
                GameWindow.WriteString(byteBuffer, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GameClient.connection.cancelPacket();
            }
            finally {
                PacketTypes.PacketType.GlobalModDataRequest.send(GameClient.connection);
            }
        } else {
            DebugLog.log("GlobalModData -> can only request from Client.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveRequest(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        String string = GameWindow.ReadString(byteBuffer);
        KahluaTable kahluaTable = this.get(string);
        if (kahluaTable == null) {
            DebugLog.log("GlobalModData -> received request for non-existing table, table: " + string);
        }
        if (GameServer.bServer) {
            try {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                    if (udpConnection2 != udpConnection) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.GlobalModData.doPacket(byteBufferWriter);
                    ByteBuffer byteBuffer2 = byteBufferWriter.bb;
                    try {
                        GameWindow.WriteString(byteBuffer2, string);
                        byteBuffer2.put(kahluaTable != null ? (byte)1 : 0);
                        if (kahluaTable == null) continue;
                        kahluaTable.save(byteBuffer2);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        udpConnection2.cancelPacket();
                        continue;
                    }
                    finally {
                        PacketTypes.PacketType.GlobalModData.send(udpConnection2);
                    }
                }
            }
            catch (Exception exception) {
                DebugLog.log(exception.getMessage());
            }
        }
    }

    private static ByteBuffer ensureCapacity(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            LAST_BLOCK_SIZE = 0x100000;
            return ByteBuffer.allocate(LAST_BLOCK_SIZE);
        }
        LAST_BLOCK_SIZE = byteBuffer.capacity() + 524288;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(LAST_BLOCK_SIZE);
        return byteBuffer2.put(byteBuffer.array(), 0, byteBuffer.position());
    }

    public void save() throws IOException {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        try {
            DebugLog.log("Saving GlobalModData");
            ByteBuffer byteBuffer = ByteBuffer.allocate(LAST_BLOCK_SIZE == -1 ? 0x100000 : LAST_BLOCK_SIZE);
            byteBuffer.putInt(195);
            byteBuffer.putInt(this.modData.size());
            int n = 0;
            for (Map.Entry<String, KahluaTable> object2 : this.modData.entrySet()) {
                if (byteBuffer.capacity() - byteBuffer.position() < 4) {
                    n = byteBuffer.position();
                    GlobalModData.ensureCapacity(byteBuffer);
                    byteBuffer.position(n);
                }
                int file2 = byteBuffer.position();
                byteBuffer.putInt(0);
                int n2 = byteBuffer.position();
                while (true) {
                    try {
                        n = byteBuffer.position();
                        GameWindow.WriteString(byteBuffer, object2.getKey());
                        object2.getValue().save(byteBuffer);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        byteBuffer = GlobalModData.ensureCapacity(byteBuffer);
                        byteBuffer.position(n);
                        continue;
                    }
                    break;
                }
                int bufferOverflowException = byteBuffer.position();
                byteBuffer.position(file2);
                byteBuffer.putInt(bufferOverflowException - n2);
                byteBuffer.position(bufferOverflowException);
            }
            byteBuffer.flip();
            File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("global_mod_data.tmp"));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().truncate(0L);
            fileOutputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
            fileOutputStream.flush();
            fileOutputStream.close();
            File file2 = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("global_mod_data.bin"));
            Files.copy((File)file, (File)file2);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Error saving GlobalModData.", exception);
        }
    }

    public void load() throws IOException {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("global_mod_data.bin");
        File file = new File(string);
        if (!file.exists()) {
            if (!WorldDictionary.isIsNewGame()) {
                // empty if block
            }
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            DebugLog.log("Loading GlobalModData:" + string);
            this.modData.clear();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            byteBuffer.clear();
            int n = fileInputStream.read(byteBuffer.array());
            byteBuffer.limit(n);
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            for (int i = 0; i < n3; ++i) {
                int n4 = byteBuffer.getInt();
                String string2 = GameWindow.ReadString(byteBuffer);
                KahluaTable kahluaTable = this.createModDataTable();
                kahluaTable.load(byteBuffer, n2);
                this.modData.put(string2, kahluaTable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Error loading GlobalModData.", exception);
        }
    }
}

