/*
 * Decompiled with CFR 0.152.
 */
package zombie.world;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import zombie.GameWindow;
import zombie.core.utils.Bits;
import zombie.debug.DebugLog;
import zombie.scripting.objects.Item;

public class ItemInfo {
    protected String itemName;
    protected String moduleName;
    protected String fullType;
    protected short registryID;
    protected boolean existsAsVanilla = false;
    protected boolean isModded = false;
    protected String modID;
    protected boolean obsolete = false;
    protected boolean removed = false;
    protected boolean isLoaded = false;
    protected List<String> modOverrides;
    protected Item scriptItem;

    public String getFullType() {
        return this.fullType;
    }

    public short getRegistryID() {
        return this.registryID;
    }

    public boolean isExistsAsVanilla() {
        return this.existsAsVanilla;
    }

    public boolean isModded() {
        return this.isModded;
    }

    public String getModID() {
        return this.modID;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public Item getScriptItem() {
        return this.scriptItem;
    }

    public List<String> getModOverrides() {
        return this.modOverrides;
    }

    public ItemInfo copy() {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.fullType = this.fullType;
        itemInfo.registryID = this.registryID;
        itemInfo.existsAsVanilla = this.existsAsVanilla;
        itemInfo.isModded = this.isModded;
        itemInfo.modID = this.modID;
        itemInfo.obsolete = this.obsolete;
        itemInfo.removed = this.removed;
        itemInfo.isLoaded = this.isLoaded;
        itemInfo.scriptItem = this.scriptItem;
        if (this.modOverrides != null) {
            itemInfo.modOverrides = new ArrayList<String>();
            itemInfo.modOverrides.addAll(this.modOverrides);
        }
        return itemInfo;
    }

    public boolean isValid() {
        return !this.obsolete && !this.removed && this.isLoaded;
    }

    public void DebugPrint() {
        DebugLog.log(this.GetDebugString());
    }

    public String GetDebugString() {
        String string = "=== Dictionary Item Debug Print ===\nregistryID = " + this.registryID + ",\nfulltype = \"" + this.fullType + "\",\nmodID = \"" + this.modID + "\",\nexistsAsVanilla = " + this.existsAsVanilla + ",\nisModded = " + this.isModded + ",\nobsolete = " + this.obsolete + ",\nremoved = " + this.removed + ",\nisModdedOverride = " + (this.modOverrides != null ? this.modOverrides.size() : 0) + ",\n";
        if (this.modOverrides != null) {
            string = string + "modOverrides = { ";
            if (this.existsAsVanilla) {
                string = string + "PZ-Vanilla, ";
            }
            for (int i = 0; i < this.modOverrides.size(); ++i) {
                string = string + "\"" + this.modOverrides.get(i) + "\"";
                if (i >= this.modOverrides.size() - 1) continue;
                string = string + ", ";
            }
            string = string + " },\n";
        }
        string = string + "===================================\n";
        return string;
    }

    public String ToString() {
        return "registryID = " + this.registryID + ",fulltype = \"" + this.fullType + "\",modID = \"" + this.modID + "\",existsAsVanilla = " + this.existsAsVanilla + ",isModded = " + this.isModded + ",obsolete = " + this.obsolete + ",removed = " + this.removed + ",modOverrides = " + (this.modOverrides != null ? this.modOverrides.size() : 0) + ",";
    }

    protected void saveAsText(FileWriter fileWriter, String string) throws IOException {
        fileWriter.write(string + "registryID = " + this.registryID + "," + System.lineSeparator());
        fileWriter.write(string + "fulltype = \"" + this.fullType + "\"," + System.lineSeparator());
        fileWriter.write(string + "modID = \"" + this.modID + "\"," + System.lineSeparator());
        fileWriter.write(string + "existsAsVanilla = " + this.existsAsVanilla + "," + System.lineSeparator());
        fileWriter.write(string + "isModded = " + this.isModded + "," + System.lineSeparator());
        fileWriter.write(string + "obsolete = " + this.obsolete + "," + System.lineSeparator());
        fileWriter.write(string + "removed = " + this.removed + "," + System.lineSeparator());
        if (this.modOverrides != null) {
            Object object = "modOverrides = { ";
            for (int i = 0; i < this.modOverrides.size(); ++i) {
                object = (String)object + "\"" + this.modOverrides.get(i) + "\"";
                if (i >= this.modOverrides.size() - 1) continue;
                object = (String)object + ", ";
            }
            object = (String)object + " },";
            fileWriter.write(string + (String)object + System.lineSeparator());
        }
    }

    protected void save(ByteBuffer byteBuffer, List<String> list, List<String> list2) {
        int n;
        byteBuffer.putShort(this.registryID);
        if (list2.size() > 127) {
            byteBuffer.putShort((short)list2.indexOf(this.moduleName));
        } else {
            byteBuffer.put((byte)list2.indexOf(this.moduleName));
        }
        GameWindow.WriteString(byteBuffer, this.itemName);
        byte by = 0;
        int n2 = byteBuffer.position();
        byteBuffer.put((byte)0);
        if (this.isModded) {
            by = Bits.addFlags(by, 1);
            if (list.size() > 127) {
                byteBuffer.putShort((short)list.indexOf(this.modID));
            } else {
                byteBuffer.put((byte)list.indexOf(this.modID));
            }
        }
        if (this.existsAsVanilla) {
            by = Bits.addFlags(by, 2);
        }
        if (this.obsolete) {
            by = Bits.addFlags(by, 4);
        }
        if (this.removed) {
            by = Bits.addFlags(by, 8);
        }
        if (this.modOverrides != null) {
            by = Bits.addFlags(by, 16);
            if (this.modOverrides.size() == 1) {
                if (list.size() > 127) {
                    byteBuffer.putShort((short)list.indexOf(this.modOverrides.get(0)));
                } else {
                    byteBuffer.put((byte)list.indexOf(this.modOverrides.get(0)));
                }
            } else {
                by = Bits.addFlags(by, 32);
                byteBuffer.put((byte)this.modOverrides.size());
                for (n = 0; n < this.modOverrides.size(); ++n) {
                    if (list.size() > 127) {
                        byteBuffer.putShort((short)list.indexOf(this.modOverrides.get(n)));
                        continue;
                    }
                    byteBuffer.put((byte)list.indexOf(this.modOverrides.get(n)));
                }
            }
        }
        n = byteBuffer.position();
        byteBuffer.position(n2);
        byteBuffer.put(by);
        byteBuffer.position(n);
    }

    protected void load(ByteBuffer byteBuffer, int n, List<String> list, List<String> list2) {
        this.registryID = byteBuffer.getShort();
        this.moduleName = list2.get(list2.size() > 127 ? byteBuffer.getShort() : (short)byteBuffer.get());
        this.itemName = GameWindow.ReadString(byteBuffer);
        this.fullType = this.moduleName + "." + this.itemName;
        byte by = byteBuffer.get();
        if (Bits.hasFlags(by, 1)) {
            this.modID = list.get(list.size() > 127 ? byteBuffer.getShort() : (short)byteBuffer.get());
            this.isModded = true;
        } else {
            this.modID = "pz-vanilla";
            this.isModded = false;
        }
        this.existsAsVanilla = Bits.hasFlags(by, 2);
        this.obsolete = Bits.hasFlags(by, 4);
        this.removed = Bits.hasFlags(by, 8);
        if (Bits.hasFlags(by, 16)) {
            if (this.modOverrides == null) {
                this.modOverrides = new ArrayList<String>();
            }
            this.modOverrides.clear();
            if (!Bits.hasFlags(by, 32)) {
                this.modOverrides.add(list.get(list.size() > 127 ? byteBuffer.getShort() : (short)byteBuffer.get()));
            } else {
                int n2 = byteBuffer.get();
                for (int i = 0; i < n2; ++i) {
                    this.modOverrides.add(list.get(list.size() > 127 ? byteBuffer.getShort() : (short)byteBuffer.get()));
                }
            }
        }
    }
}

