/*
 * Decompiled with CFR 0.152.
 */
package zombie.world;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zombie.GameWindow;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.world.ItemInfo;
import zombie.world.WorldDictionary;
import zombie.world.WorldDictionaryException;
import zombie.world.logger.Log;
import zombie.world.logger.WorldDictionaryLogger;

public class DictionaryData {
    protected final Map<Short, ItemInfo> itemIdToInfoMap = new HashMap<Short, ItemInfo>();
    protected final Map<String, ItemInfo> itemTypeToInfoMap = new HashMap<String, ItemInfo>();
    protected final Map<String, Integer> spriteNameToIdMap = new HashMap<String, Integer>();
    protected final Map<Integer, String> spriteIdToNameMap = new HashMap<Integer, String>();
    protected final Map<String, Byte> objectNameToIdMap = new HashMap<String, Byte>();
    protected final Map<Byte, String> objectIdToNameMap = new HashMap<Byte, String>();
    protected final ArrayList<String> unsetObject = new ArrayList();
    protected final ArrayList<String> unsetSprites = new ArrayList();
    protected short NextItemID = 0;
    protected int NextSpriteNameID = 0;
    protected byte NextObjectNameID = 0;
    protected byte[] serverDataCache;
    private File dataBackupPath;

    protected boolean isClient() {
        return false;
    }

    protected void reset() {
        this.NextItemID = 0;
        this.NextSpriteNameID = 0;
        this.NextObjectNameID = 0;
        this.itemIdToInfoMap.clear();
        this.itemTypeToInfoMap.clear();
        this.objectIdToNameMap.clear();
        this.objectNameToIdMap.clear();
        this.spriteIdToNameMap.clear();
        this.spriteNameToIdMap.clear();
    }

    protected final ItemInfo getItemInfoFromType(String string) {
        return this.itemTypeToInfoMap.get(string);
    }

    protected final ItemInfo getItemInfoFromID(short s) {
        return this.itemIdToInfoMap.get(s);
    }

    protected final short getItemRegistryID(String string) {
        ItemInfo itemInfo = this.itemTypeToInfoMap.get(string);
        if (itemInfo != null) {
            return itemInfo.registryID;
        }
        if (Core.bDebug) {
            DebugLog.log("WARNING: Cannot get registry id for item: " + string);
        }
        return -1;
    }

    protected final String getItemTypeFromID(short s) {
        ItemInfo itemInfo = this.itemIdToInfoMap.get(s);
        if (itemInfo != null) {
            return itemInfo.fullType;
        }
        return null;
    }

    protected final String getItemTypeDebugString(short s) {
        String string = this.getItemTypeFromID(s);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    protected final String getSpriteNameFromID(int n) {
        if (n >= 0) {
            if (this.spriteIdToNameMap.containsKey(n)) {
                return this.spriteIdToNameMap.get(n);
            }
            IsoSprite isoSprite = IsoSprite.getSprite(IsoSpriteManager.instance, n);
            if (isoSprite != null && isoSprite.name != null) {
                return isoSprite.name;
            }
        }
        DebugLog.log("WorldDictionary, Couldnt find sprite name for ID '" + n + "'.");
        return null;
    }

    protected final int getIdForSpriteName(String string) {
        if (string != null) {
            if (this.spriteNameToIdMap.containsKey(string)) {
                return this.spriteNameToIdMap.get(string);
            }
            IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(string);
            if (isoSprite != null && isoSprite.ID >= 0 && isoSprite.ID != 20000000 && isoSprite.name.equals(string)) {
                return isoSprite.ID;
            }
        }
        return -1;
    }

    protected final String getObjectNameFromID(byte by) {
        if (by >= 0) {
            if (this.objectIdToNameMap.containsKey(by)) {
                return this.objectIdToNameMap.get(by);
            }
            if (Core.bDebug) {
                DebugLog.log("WorldDictionary, Couldnt find object name for ID '" + by + "'.");
            }
        }
        return null;
    }

    protected final byte getIdForObjectName(String string) {
        if (string != null) {
            if (this.objectNameToIdMap.containsKey(string)) {
                return this.objectNameToIdMap.get(string);
            }
            if (Core.bDebug) {
                // empty if block
            }
        }
        return -1;
    }

    protected final void getItemMods(List<String> list) {
        list.clear();
        for (Map.Entry<Short, ItemInfo> entry : this.itemIdToInfoMap.entrySet()) {
            if (!list.contains(entry.getValue().modID)) {
                list.add(entry.getValue().modID);
            }
            if (entry.getValue().modOverrides == null) continue;
            List<String> list2 = entry.getValue().modOverrides;
            for (int i = 0; i < list2.size(); ++i) {
                if (list.contains(list2.get(i))) continue;
                list.add(list2.get(i));
            }
        }
    }

    protected final void getModuleList(List<String> list) {
        for (Map.Entry<Short, ItemInfo> entry : this.itemIdToInfoMap.entrySet()) {
            if (list.contains(entry.getValue().moduleName)) continue;
            list.add(entry.getValue().moduleName);
        }
    }

    protected void parseItemLoadList(Map<String, ItemInfo> map) throws WorldDictionaryException {
        for (Map.Entry<String, ItemInfo> entry : map.entrySet()) {
            ItemInfo itemInfo = entry.getValue();
            ItemInfo itemInfo2 = this.itemTypeToInfoMap.get(itemInfo.fullType);
            if (itemInfo2 == null) {
                if (itemInfo.obsolete) continue;
                if (this.NextItemID >= Short.MAX_VALUE) {
                    throw new WorldDictionaryException("Max item ID value reached for WorldDictionary!");
                }
                this.NextItemID = (short)(this.NextItemID + 1);
                itemInfo.registryID = itemInfo.registryID;
                itemInfo.isLoaded = true;
                this.itemTypeToInfoMap.put(itemInfo.fullType, itemInfo);
                this.itemIdToInfoMap.put(itemInfo.registryID, itemInfo);
                WorldDictionaryLogger.log(new Log.RegisterItem(itemInfo.copy()));
                continue;
            }
            if (itemInfo2.removed && !itemInfo.obsolete) {
                itemInfo2.removed = false;
                WorldDictionaryLogger.log(new Log.ReinstateItem(itemInfo2.copy()));
            }
            if (!itemInfo2.modID.equals(itemInfo.modID)) {
                String string = itemInfo2.modID;
                itemInfo2.modID = itemInfo.modID;
                itemInfo2.isModded = !itemInfo.modID.equals("pz-vanilla");
                WorldDictionaryLogger.log(new Log.ModIDChangedItem(itemInfo2.copy(), string, itemInfo2.modID));
            }
            if (!(!itemInfo.obsolete || itemInfo2.obsolete && itemInfo2.removed)) {
                itemInfo2.obsolete = true;
                itemInfo2.removed = true;
                WorldDictionaryLogger.log(new Log.ObsoleteItem(itemInfo2.copy()));
            }
            itemInfo2.isLoaded = true;
        }
    }

    protected void parseCurrentItemSet() throws WorldDictionaryException {
        for (Map.Entry<String, ItemInfo> entry : this.itemTypeToInfoMap.entrySet()) {
            ItemInfo itemInfo = entry.getValue();
            if (!itemInfo.isLoaded) {
                itemInfo.removed = true;
                WorldDictionaryLogger.log(new Log.RemovedItem(itemInfo.copy(), false));
            }
            if (itemInfo.scriptItem == null) {
                itemInfo.scriptItem = ScriptManager.instance.getSpecificItem(itemInfo.fullType);
            }
            if (itemInfo.scriptItem != null) {
                itemInfo.scriptItem.setRegistry_id(itemInfo.registryID);
                continue;
            }
            itemInfo.removed = true;
            WorldDictionaryLogger.log(new Log.RemovedItem(itemInfo.copy(), true));
        }
    }

    protected void parseObjectNameLoadList(List<String> list) throws WorldDictionaryException {
        for (int i = 0; i < list.size(); ++i) {
            byte by;
            String string = list.get(i);
            if (this.objectNameToIdMap.containsKey(string)) continue;
            if (this.NextObjectNameID >= 127) {
                WorldDictionaryLogger.log("Max value for object names reached.");
                if (!Core.bDebug) continue;
                throw new WorldDictionaryException("Max value for object names reached.");
            }
            this.NextObjectNameID = (byte)(this.NextObjectNameID + 1);
            this.objectIdToNameMap.put(by, string);
            this.objectNameToIdMap.put(string, by);
            WorldDictionaryLogger.log(new Log.RegisterObject(string, by));
        }
    }

    protected void backupCurrentDataSet() throws IOException {
        this.dataBackupPath = null;
        if (Core.getInstance().isNoSave()) {
            return;
        }
        File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionary.bin"));
        if (file.exists()) {
            long l = Instant.now().getEpochSecond();
            this.dataBackupPath = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionary_" + l + ".bak"));
            Files.copy((File)file, (File)this.dataBackupPath);
        }
    }

    protected void deleteBackupCurrentDataSet() throws IOException {
        if (Core.getInstance().isNoSave()) {
            this.dataBackupPath = null;
            return;
        }
        if (this.dataBackupPath != null) {
            this.dataBackupPath.delete();
        }
        this.dataBackupPath = null;
    }

    protected void createErrorBackups() {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        try {
            File file;
            WorldDictionary.log("Attempting to copy WorldDictionary backups...");
            long l = Instant.now().getEpochSecond();
            String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("WD_ERROR_" + l) + File.separator;
            WorldDictionary.log("path = " + string);
            File file2 = new File(string);
            boolean bl = true;
            if (!file2.exists()) {
                bl = file2.mkdir();
            }
            if (!bl) {
                WorldDictionary.log("Could not create backup folder folder.");
                return;
            }
            if (this.dataBackupPath != null) {
                file = new File(string + "WorldDictionary_backup.bin");
                if (this.dataBackupPath.exists()) {
                    Files.copy((File)this.dataBackupPath, (File)file);
                }
            }
            file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionaryLog.lua"));
            File file3 = new File(string + "WorldDictionaryLog.lua");
            if (file.exists()) {
                Files.copy((File)file, (File)file3);
            }
            File file4 = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionaryReadable.lua"));
            File file5 = new File(string + "WorldDictionaryReadable.lua");
            if (file4.exists()) {
                Files.copy((File)file4, (File)file5);
            }
            File file6 = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionary.bin"));
            File file7 = new File(string + "WorldDictionary.bin");
            if (file6.exists()) {
                Files.copy((File)file6, (File)file7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void load() throws IOException, WorldDictionaryException {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionary.bin");
        File file = new File(string);
        if (!file.exists()) {
            if (!WorldDictionary.isIsNewGame()) {
                throw new WorldDictionaryException("WorldDictionary data file is missing from world folder.");
            }
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            DebugLog.log("Loading WorldDictionary:" + string);
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            byteBuffer.clear();
            int n = fileInputStream.read(byteBuffer.array());
            byteBuffer.limit(n);
            this.loadFromByteBuffer(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WorldDictionaryException("Error loading WorldDictionary.", exception);
        }
    }

    protected void loadFromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        this.NextItemID = byteBuffer.getShort();
        this.NextObjectNameID = byteBuffer.get();
        this.NextSpriteNameID = byteBuffer.getInt();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n5 = byteBuffer.getInt();
        for (int i = 0; i < n5; ++i) {
            arrayList.add(GameWindow.ReadString(byteBuffer));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n6 = byteBuffer.getInt();
        for (n4 = 0; n4 < n6; ++n4) {
            arrayList2.add(GameWindow.ReadString(byteBuffer));
        }
        n4 = byteBuffer.getInt();
        for (n3 = 0; n3 < n4; ++n3) {
            ItemInfo itemInfo = new ItemInfo();
            itemInfo.load(byteBuffer, 195, arrayList, arrayList2);
            this.itemIdToInfoMap.put(itemInfo.registryID, itemInfo);
            this.itemTypeToInfoMap.put(itemInfo.fullType, itemInfo);
        }
        n3 = byteBuffer.getInt();
        for (n2 = 0; n2 < n3; ++n2) {
            n = byteBuffer.get();
            String string = GameWindow.ReadString(byteBuffer);
            this.objectIdToNameMap.put((byte)n, string);
            this.objectNameToIdMap.put(string, (byte)n);
        }
        n2 = byteBuffer.getInt();
        for (n = 0; n < n2; ++n) {
            int n7 = byteBuffer.getInt();
            String string = GameWindow.ReadString(byteBuffer);
            this.spriteIdToNameMap.put(n7, string);
            this.spriteNameToIdMap.put(string, n7);
        }
    }

    protected void save() throws IOException, WorldDictionaryException {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        try {
            byte[] byArray = new byte[0x500000];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.saveToByteBuffer(byteBuffer);
            byteBuffer.flip();
            if (GameServer.bServer) {
                byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, 0, byArray.length);
                this.serverDataCache = byArray;
            }
            File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionary.tmp"));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().truncate(0L);
            fileOutputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
            fileOutputStream.flush();
            fileOutputStream.close();
            File file2 = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("WorldDictionary.bin"));
            Files.copy((File)file, (File)file2);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WorldDictionaryException("Error saving WorldDictionary.", exception);
        }
    }

    protected void saveToByteBuffer(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putShort(this.NextItemID);
        byteBuffer.put(this.NextObjectNameID);
        byteBuffer.putInt(this.NextSpriteNameID);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getItemMods(arrayList);
        byteBuffer.putInt(arrayList.size());
        for (String iterator2 : arrayList) {
            GameWindow.WriteString(byteBuffer, iterator2);
        }
        ArrayList arrayList2 = new ArrayList();
        this.getModuleList(arrayList2);
        byteBuffer.putInt(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            GameWindow.WriteString(byteBuffer, string);
        }
        byteBuffer.putInt(this.itemIdToInfoMap.size());
        for (Map.Entry<Short, ItemInfo> entry : this.itemIdToInfoMap.entrySet()) {
            ItemInfo itemInfo = entry.getValue();
            itemInfo.save(byteBuffer, arrayList, arrayList2);
        }
        byteBuffer.putInt(this.objectIdToNameMap.size());
        for (Map.Entry<Byte, String> entry : this.objectIdToNameMap.entrySet()) {
            byteBuffer.put(entry.getKey());
            GameWindow.WriteString(byteBuffer, entry.getValue());
        }
        byteBuffer.putInt(this.spriteIdToNameMap.size());
        for (Map.Entry<Integer, String> entry : this.spriteIdToNameMap.entrySet()) {
            byteBuffer.putInt(entry.getKey());
            GameWindow.WriteString(byteBuffer, entry.getValue());
        }
    }

    protected void saveAsText(String string) throws IOException, WorldDictionaryException {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        File file = new File(ZomboidFileSystem.instance.getCurrentSaveDir() + File.separator);
        if (file.exists() && file.isDirectory()) {
            String string2 = ZomboidFileSystem.instance.getFileNameInCurrentSave(string);
            File file2 = new File(string2);
            try (FileWriter fileWriter = new FileWriter(file2, false);){
                fileWriter.write("--[[ ---- ITEMS ---- --]]" + System.lineSeparator());
                fileWriter.write("items = {" + System.lineSeparator());
                for (Map.Entry<Short, ItemInfo> entry : this.itemIdToInfoMap.entrySet()) {
                    fileWriter.write("\t{" + System.lineSeparator());
                    entry.getValue().saveAsText(fileWriter, "\t\t");
                    fileWriter.write("\t}," + System.lineSeparator());
                }
                fileWriter.write("}" + System.lineSeparator());
                fileWriter.write(System.lineSeparator());
                fileWriter.write("--[[ ---- OBJECTS ---- --]]" + System.lineSeparator());
                fileWriter.write("objects = {" + System.lineSeparator());
                for (Map.Entry<Number, Object> entry : this.objectIdToNameMap.entrySet()) {
                    fileWriter.write("\t" + entry.getKey() + " = \"" + (String)entry.getValue() + "\"," + System.lineSeparator());
                }
                fileWriter.write("}" + System.lineSeparator());
                fileWriter.write(System.lineSeparator());
                fileWriter.write("--[[ ---- SPRITES ---- --]]" + System.lineSeparator());
                fileWriter.write("sprites = {" + System.lineSeparator());
                for (Map.Entry<Number, Object> entry : this.spriteIdToNameMap.entrySet()) {
                    fileWriter.write("\t" + entry.getKey() + " = \"" + (String)entry.getValue() + "\"," + System.lineSeparator());
                }
                fileWriter.write("}" + System.lineSeparator());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new WorldDictionaryException("Error saving WorldDictionary as text.", exception);
            }
        }
    }
}

