/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.WorldStreamer;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.popman.ZombiePopulationRenderer;
import zombie.util.ByteBufferBackedInputStream;
import zombie.util.ByteBufferOutputStream;
import zombie.util.PZSQLUtils;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class VehiclesDB2 {
    public static final int INVALID_ID = -1;
    private static final int MIN_ID = 1;
    public static final VehiclesDB2 instance = new VehiclesDB2();
    private static final ThreadLocal<ByteBuffer> TL_SliceBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(32768));
    private static final ThreadLocal<byte[]> TL_Bytes = ThreadLocal.withInitial(() -> new byte[1024]);
    private final MainThread m_main = new MainThread();
    private final WorldStreamerThread m_worldStreamer = new WorldStreamerThread();

    public void init() {
        this.m_worldStreamer.m_store.init(this.m_main.m_usedIDs, this.m_main.m_seenChunks);
    }

    public void Reset() {
        assert (WorldStreamer.instance.worldStreamer == null);
        this.updateWorldStreamer();
        QueueItem queueItem = this.m_main.m_queue.poll();
        while (queueItem != null) {
            queueItem.release();
            queueItem = this.m_main.m_queue.poll();
        }
        this.m_main.Reset();
        this.m_worldStreamer.Reset();
    }

    public void updateMain() throws IOException {
        this.m_main.update();
    }

    public void updateWorldStreamer() {
        this.m_worldStreamer.update();
    }

    public void setForceSave() {
        this.m_main.m_forceSave = true;
    }

    public void renderDebug(ZombiePopulationRenderer zombiePopulationRenderer) {
    }

    public void setChunkSeen(int n, int n2) {
        this.m_main.setChunkSeen(n, n2);
    }

    public boolean isChunkSeen(int n, int n2) {
        return this.m_main.isChunkSeen(n, n2);
    }

    public void setVehicleLoaded(BaseVehicle baseVehicle) {
        this.m_main.setVehicleLoaded(baseVehicle);
    }

    public void setVehicleUnloaded(BaseVehicle baseVehicle) {
        this.m_main.setVehicleUnloaded(baseVehicle);
    }

    public boolean isVehicleLoaded(BaseVehicle baseVehicle) {
        return this.m_main.m_loadedIDs.contains(baseVehicle.sqlID);
    }

    public void loadChunkMain(IsoChunk isoChunk) {
        this.m_main.loadChunk(isoChunk);
    }

    public void loadChunk(IsoChunk isoChunk) throws IOException {
        this.m_worldStreamer.loadChunk(isoChunk);
    }

    public void unloadChunk(IsoChunk isoChunk) {
        if (Thread.currentThread() != WorldStreamer.instance.worldStreamer) {
            boolean bl = true;
        }
        this.m_worldStreamer.unloadChunk(isoChunk);
    }

    public void addVehicle(BaseVehicle baseVehicle) {
        try {
            this.m_main.addVehicle(baseVehicle);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void removeVehicle(BaseVehicle baseVehicle) {
        this.m_main.removeVehicle(baseVehicle);
    }

    public void updateVehicle(BaseVehicle baseVehicle) {
        try {
            this.m_main.updateVehicle(baseVehicle);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void updateVehicleAndTrailer(BaseVehicle baseVehicle) {
        if (baseVehicle == null) {
            return;
        }
        this.updateVehicle(baseVehicle);
        BaseVehicle baseVehicle2 = baseVehicle.getVehicleTowing();
        if (baseVehicle2 != null) {
            this.updateVehicle(baseVehicle2);
        }
    }

    public void importPlayersFromOldDB(IImportPlayerFromOldDB iImportPlayerFromOldDB) {
        AutoCloseable autoCloseable;
        Object object;
        SQLStore sQLStore = Type.tryCastTo(this.m_worldStreamer.m_store, SQLStore.class);
        if (sQLStore == null || sQLStore.m_conn == null) {
            return;
        }
        try {
            object = sQLStore.m_conn.getMetaData();
            autoCloseable = object.getTables(null, null, "localPlayers", null);
            try {
                if (!autoCloseable.next()) {
                    return;
                }
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return;
        }
        object = "SELECT id, name, wx, wy, x, y, z, worldversion, data, isDead FROM localPlayers";
        try {
            autoCloseable = sQLStore.m_conn.prepareStatement((String)object);
            try {
                ResultSet resultSet = autoCloseable.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    String string = resultSet.getString(2);
                    int n2 = resultSet.getInt(3);
                    int n3 = resultSet.getInt(4);
                    float f = resultSet.getFloat(5);
                    float f2 = resultSet.getFloat(6);
                    float f3 = resultSet.getFloat(7);
                    int n4 = resultSet.getInt(8);
                    byte[] byArray = resultSet.getBytes(9);
                    boolean bl = resultSet.getBoolean(10);
                    iImportPlayerFromOldDB.accept(n, string, n2, n3, f, f2, f3, n4, byArray, bl);
                }
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        try {
            autoCloseable = sQLStore.m_conn.createStatement();
            autoCloseable.executeUpdate("DROP TABLE localPlayers");
            autoCloseable.executeUpdate("DROP TABLE networkPlayers");
            sQLStore.m_conn.commit();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    private static final class MainThread {
        final TIntHashSet m_seenChunks = new TIntHashSet();
        final TIntHashSet m_usedIDs = new TIntHashSet();
        final TIntHashSet m_loadedIDs = new TIntHashSet();
        boolean m_forceSave = false;
        final ConcurrentLinkedQueue<QueueItem> m_queue = new ConcurrentLinkedQueue();

        MainThread() {
            this.m_seenChunks.setAutoCompactionFactor(0.0f);
            this.m_usedIDs.setAutoCompactionFactor(0.0f);
            this.m_loadedIDs.setAutoCompactionFactor(0.0f);
        }

        void Reset() {
            this.m_seenChunks.clear();
            this.m_usedIDs.clear();
            this.m_loadedIDs.clear();
            assert (this.m_queue.isEmpty());
            this.m_queue.clear();
            this.m_forceSave = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() throws IOException {
            if (!GameClient.bClient && !GameServer.bServer && this.m_forceSave) {
                this.m_forceSave = false;
                for (int i = 0; i < 4; ++i) {
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (isoPlayer == null || isoPlayer.getVehicle() == null || !isoPlayer.getVehicle().isEngineRunning()) continue;
                    this.updateVehicle(isoPlayer.getVehicle());
                    BaseVehicle baseVehicle = isoPlayer.getVehicle().getVehicleTowing();
                    if (baseVehicle == null) continue;
                    this.updateVehicle(baseVehicle);
                }
            }
            QueueItem queueItem = this.m_queue.poll();
            while (queueItem != null) {
                try {
                    queueItem.processMain();
                }
                finally {
                    queueItem.release();
                }
                queueItem = this.m_queue.poll();
            }
        }

        void setChunkSeen(int n, int n2) {
            int n3 = n2 << 16 | n;
            this.m_seenChunks.add(n3);
        }

        boolean isChunkSeen(int n, int n2) {
            int n3 = n2 << 16 | n;
            return this.m_seenChunks.contains(n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int allocateID() {
            TIntHashSet tIntHashSet = this.m_usedIDs;
            synchronized (tIntHashSet) {
                for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                    if (this.m_usedIDs.contains(i)) continue;
                    this.m_usedIDs.add(i);
                    return i;
                }
            }
            throw new RuntimeException("ran out of unused vehicle ids");
        }

        void setVehicleLoaded(BaseVehicle baseVehicle) {
            if (baseVehicle.sqlID == -1) {
                baseVehicle.sqlID = this.allocateID();
            }
            assert (!this.m_loadedIDs.contains(baseVehicle.sqlID));
            this.m_loadedIDs.add(baseVehicle.sqlID);
        }

        void setVehicleUnloaded(BaseVehicle baseVehicle) {
            if (baseVehicle.sqlID == -1) {
                return;
            }
            this.m_loadedIDs.remove(baseVehicle.sqlID);
        }

        void addVehicle(BaseVehicle baseVehicle) throws IOException {
            if (baseVehicle.sqlID == -1) {
                baseVehicle.sqlID = this.allocateID();
            }
            QueueAddVehicle queueAddVehicle = QueueAddVehicle.s_pool.alloc();
            queueAddVehicle.init(baseVehicle);
            VehiclesDB2.instance.m_worldStreamer.m_queue.add(queueAddVehicle);
        }

        void removeVehicle(BaseVehicle baseVehicle) {
            QueueRemoveVehicle queueRemoveVehicle = QueueRemoveVehicle.s_pool.alloc();
            queueRemoveVehicle.init(baseVehicle);
            VehiclesDB2.instance.m_worldStreamer.m_queue.add(queueRemoveVehicle);
        }

        void updateVehicle(BaseVehicle baseVehicle) throws IOException {
            if (baseVehicle.sqlID == -1) {
                baseVehicle.sqlID = this.allocateID();
            }
            QueueUpdateVehicle queueUpdateVehicle = QueueUpdateVehicle.s_pool.alloc();
            queueUpdateVehicle.init(baseVehicle);
            VehiclesDB2.instance.m_worldStreamer.m_queue.add(queueUpdateVehicle);
        }

        void loadChunk(IsoChunk isoChunk) {
            QueueLoadChunk queueLoadChunk = QueueLoadChunk.s_pool.alloc();
            queueLoadChunk.init(isoChunk.wx, isoChunk.wy);
            isoChunk.m_loadVehiclesObject = queueLoadChunk;
            VehiclesDB2.instance.m_worldStreamer.m_queue.add(queueLoadChunk);
        }
    }

    private static final class WorldStreamerThread {
        final IVehicleStore m_store = new SQLStore();
        final ConcurrentLinkedQueue<QueueItem> m_queue = new ConcurrentLinkedQueue();
        final VehicleBuffer m_vehicleBuffer = new VehicleBuffer();

        private WorldStreamerThread() {
        }

        void Reset() {
            this.m_store.Reset();
            assert (this.m_queue.isEmpty());
            this.m_queue.clear();
        }

        void update() {
            QueueItem queueItem = this.m_queue.poll();
            while (queueItem != null) {
                try {
                    queueItem.processWorldStreamer();
                }
                finally {
                    VehiclesDB2.instance.m_main.m_queue.add(queueItem);
                }
                queueItem = this.m_queue.poll();
            }
        }

        void loadChunk(IsoChunk isoChunk) throws IOException {
            this.m_store.loadChunk(isoChunk, this::vehicleLoaded);
        }

        void vehicleLoaded(IsoChunk isoChunk, VehicleBuffer vehicleBuffer) throws IOException {
            assert (vehicleBuffer.m_id >= 1);
            IsoGridSquare isoGridSquare = isoChunk.getGridSquare((int)(vehicleBuffer.m_x - (float)(isoChunk.wx * 10)), (int)(vehicleBuffer.m_y - (float)(isoChunk.wy * 10)), 0);
            BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
            baseVehicle.setSquare(isoGridSquare);
            baseVehicle.setCurrent(isoGridSquare);
            try {
                baseVehicle.load(vehicleBuffer.m_bb, vehicleBuffer.m_WorldVersion);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                DebugLog.General.error("vehicle %d is being deleted because an error occurred loading it", vehicleBuffer.m_id);
                this.m_store.removeVehicle(vehicleBuffer.m_id);
                return;
            }
            baseVehicle.sqlID = vehicleBuffer.m_id;
            baseVehicle.chunk = isoChunk;
            if (isoChunk.jobType == IsoChunk.JobType.SoftReset) {
                baseVehicle.softReset();
            }
            isoChunk.vehicles.add(baseVehicle);
        }

        void unloadChunk(IsoChunk isoChunk) {
            for (int i = 0; i < isoChunk.vehicles.size(); ++i) {
                try {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(i);
                    this.m_vehicleBuffer.set(baseVehicle);
                    this.m_store.updateVehicle(this.m_vehicleBuffer);
                    continue;
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
        }
    }

    private static abstract class IVehicleStore {
        private IVehicleStore() {
        }

        abstract void init(TIntHashSet var1, TIntHashSet var2);

        abstract void Reset();

        abstract void loadChunk(IsoChunk var1, ThrowingBiConsumer<IsoChunk, VehicleBuffer, IOException> var2) throws IOException;

        abstract void loadChunk(int var1, int var2, ThrowingConsumer<VehicleBuffer, IOException> var3) throws IOException;

        abstract void updateVehicle(VehicleBuffer var1);

        abstract void removeVehicle(int var1);
    }

    private static abstract class QueueItem
    extends PooledObject {
        private QueueItem() {
        }

        abstract void processMain();

        abstract void processWorldStreamer();
    }

    private static final class SQLStore
    extends IVehicleStore {
        Connection m_conn = null;
        final VehicleBuffer m_vehicleBuffer = new VehicleBuffer();

        private SQLStore() {
        }

        @Override
        void init(TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2) {
            tIntHashSet.clear();
            tIntHashSet2.clear();
            if (Core.getInstance().isNoSave()) {
                return;
            }
            this.create();
            try {
                this.initUsedIDs(tIntHashSet, tIntHashSet2);
            }
            catch (SQLException sQLException) {
                ExceptionLogger.logException(sQLException);
            }
        }

        @Override
        void Reset() {
            if (this.m_conn == null) {
                return;
            }
            try {
                this.m_conn.close();
            }
            catch (SQLException sQLException) {
                ExceptionLogger.logException(sQLException);
            }
            this.m_conn = null;
        }

        @Override
        void loadChunk(IsoChunk isoChunk, ThrowingBiConsumer<IsoChunk, VehicleBuffer, IOException> throwingBiConsumer) throws IOException {
            if (this.m_conn == null || isoChunk == null) {
                return;
            }
            String string = "SELECT id, x, y, data, worldversion FROM vehicles WHERE wx=? AND wy=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, isoChunk.wx);
                preparedStatement.setInt(2, isoChunk.wy);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    boolean bl;
                    this.m_vehicleBuffer.m_id = resultSet.getInt(1);
                    this.m_vehicleBuffer.m_wx = isoChunk.wx;
                    this.m_vehicleBuffer.m_wy = isoChunk.wy;
                    this.m_vehicleBuffer.m_x = resultSet.getFloat(2);
                    this.m_vehicleBuffer.m_y = resultSet.getFloat(3);
                    InputStream inputStream = resultSet.getBinaryStream(4);
                    this.m_vehicleBuffer.setBytes(inputStream);
                    this.m_vehicleBuffer.m_WorldVersion = resultSet.getInt(5);
                    boolean bl2 = bl = this.m_vehicleBuffer.m_bb.get() != 0;
                    byte by = this.m_vehicleBuffer.m_bb.get();
                    if (by != IsoObject.getFactoryVehicle().getClassID() || !bl) continue;
                    throwingBiConsumer.accept(isoChunk, this.m_vehicleBuffer);
                }
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }

        @Override
        void loadChunk(int n, int n2, ThrowingConsumer<VehicleBuffer, IOException> throwingConsumer) throws IOException {
            if (this.m_conn == null) {
                return;
            }
            String string = "SELECT id, x, y, data, worldversion FROM vehicles WHERE wx=? AND wy=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    boolean bl;
                    this.m_vehicleBuffer.m_id = resultSet.getInt(1);
                    this.m_vehicleBuffer.m_wx = n;
                    this.m_vehicleBuffer.m_wy = n2;
                    this.m_vehicleBuffer.m_x = resultSet.getFloat(2);
                    this.m_vehicleBuffer.m_y = resultSet.getFloat(3);
                    InputStream inputStream = resultSet.getBinaryStream(4);
                    this.m_vehicleBuffer.setBytes(inputStream);
                    this.m_vehicleBuffer.m_WorldVersion = resultSet.getInt(5);
                    boolean bl2 = bl = this.m_vehicleBuffer.m_bb.get() != 0;
                    byte by = this.m_vehicleBuffer.m_bb.get();
                    if (by != IsoObject.getFactoryVehicle().getClassID() || !bl) continue;
                    throwingConsumer.accept(this.m_vehicleBuffer);
                }
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void updateVehicle(VehicleBuffer vehicleBuffer) {
            if (this.m_conn == null) {
                return;
            }
            assert (vehicleBuffer.m_id >= 1);
            TIntHashSet tIntHashSet = VehiclesDB2.instance.m_main.m_usedIDs;
            synchronized (tIntHashSet) {
                assert (VehiclesDB2.instance.m_main.m_usedIDs.contains(vehicleBuffer.m_id));
            }
            try {
                if (this.isInDB(vehicleBuffer.m_id)) {
                    this.updateDB(vehicleBuffer);
                } else {
                    this.addToDB(vehicleBuffer);
                }
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                this.rollback();
            }
        }

        boolean isInDB(int n) throws SQLException {
            String string = "SELECT 1 FROM vehicles WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                boolean bl = resultSet.next();
                return bl;
            }
        }

        void addToDB(VehicleBuffer vehicleBuffer) throws SQLException {
            String string = "INSERT INTO vehicles(wx,wy,x,y,worldversion,data,id) VALUES(?,?,?,?,?,?,?)";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, vehicleBuffer.m_wx);
                preparedStatement.setInt(2, vehicleBuffer.m_wy);
                preparedStatement.setFloat(3, vehicleBuffer.m_x);
                preparedStatement.setFloat(4, vehicleBuffer.m_y);
                preparedStatement.setInt(5, vehicleBuffer.m_WorldVersion);
                ByteBuffer byteBuffer = vehicleBuffer.m_bb;
                byteBuffer.rewind();
                preparedStatement.setBinaryStream(6, (InputStream)new ByteBufferBackedInputStream(byteBuffer), byteBuffer.remaining());
                preparedStatement.setInt(7, vehicleBuffer.m_id);
                int n = preparedStatement.executeUpdate();
                this.m_conn.commit();
            }
            catch (Exception exception) {
                this.rollback();
                throw exception;
            }
        }

        void updateDB(VehicleBuffer vehicleBuffer) throws SQLException {
            String string = "UPDATE vehicles SET wx = ?, wy = ?, x = ?, y = ?, worldversion = ?, data = ? WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, vehicleBuffer.m_wx);
                preparedStatement.setInt(2, vehicleBuffer.m_wy);
                preparedStatement.setFloat(3, vehicleBuffer.m_x);
                preparedStatement.setFloat(4, vehicleBuffer.m_y);
                preparedStatement.setInt(5, vehicleBuffer.m_WorldVersion);
                ByteBuffer byteBuffer = vehicleBuffer.m_bb;
                byteBuffer.rewind();
                preparedStatement.setBinaryStream(6, (InputStream)new ByteBufferBackedInputStream(byteBuffer), byteBuffer.remaining());
                preparedStatement.setInt(7, vehicleBuffer.m_id);
                int n = preparedStatement.executeUpdate();
                this.m_conn.commit();
            }
            catch (Exception exception) {
                this.rollback();
                throw exception;
            }
        }

        @Override
        void removeVehicle(int n) {
            if (this.m_conn == null || n < 1) {
                return;
            }
            String string = "DELETE FROM vehicles WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, n);
                int n2 = preparedStatement.executeUpdate();
                this.m_conn.commit();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                this.rollback();
            }
        }

        void create() {
            Statement statement;
            String string = ZomboidFileSystem.instance.getCurrentSaveDir();
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = new File(string + File.separator + "vehicles.db");
            file2.setReadable(true, false);
            file2.setExecutable(true, false);
            file2.setWritable(true, false);
            if (!file2.exists()) {
                try {
                    file2.createNewFile();
                    this.m_conn = PZSQLUtils.getConnection(file2.getAbsolutePath());
                    statement = this.m_conn.createStatement();
                    statement.executeUpdate("CREATE TABLE vehicles (id   INTEGER PRIMARY KEY NOT NULL,wx    INTEGER,wy    INTEGER,x    FLOAT,y    FLOAT,worldversion    INTEGER,data BLOB);");
                    statement.executeUpdate("CREATE INDEX ivwx ON vehicles (wx);");
                    statement.executeUpdate("CREATE INDEX ivwy ON vehicles (wy);");
                    statement.close();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                    DebugLog.log("failed to create vehicles database");
                    System.exit(1);
                }
            }
            if (this.m_conn == null) {
                try {
                    this.m_conn = PZSQLUtils.getConnection(file2.getAbsolutePath());
                }
                catch (Exception exception) {
                    DebugLog.log("failed to create vehicles database");
                    ExceptionLogger.logException(exception);
                    System.exit(1);
                }
            }
            try {
                statement = this.m_conn.createStatement();
                statement.executeQuery("PRAGMA JOURNAL_MODE=TRUNCATE;");
                statement.close();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                System.exit(1);
            }
            try {
                this.m_conn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                ExceptionLogger.logException(sQLException);
            }
        }

        private String searchPathForSqliteLib(String string) {
            for (String string2 : System.getProperty("java.library.path", "").split(File.pathSeparator)) {
                File file = new File(string2, string);
                if (!file.exists()) continue;
                return string2;
            }
            return "";
        }

        void initUsedIDs(TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2) throws SQLException {
            String string = "SELECT wx,wy,id FROM vehicles";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    tIntHashSet2.add(n2 << 16 | n);
                    tIntHashSet.add(resultSet.getInt(3));
                }
            }
        }

        private void rollback() {
            if (this.m_conn == null) {
                return;
            }
            try {
                this.m_conn.rollback();
            }
            catch (SQLException sQLException) {
                ExceptionLogger.logException(sQLException);
            }
        }
    }

    public static interface IImportPlayerFromOldDB {
        public void accept(int var1, String var2, int var3, int var4, float var5, float var6, float var7, int var8, byte[] var9, boolean var10);
    }

    private static final class QueueUpdateVehicle
    extends QueueItem {
        static final Pool<QueueUpdateVehicle> s_pool = new Pool<QueueUpdateVehicle>(QueueUpdateVehicle::new);
        final VehicleBuffer m_vehicleBuffer = new VehicleBuffer();

        private QueueUpdateVehicle() {
        }

        void init(BaseVehicle baseVehicle) throws IOException {
            this.m_vehicleBuffer.set(baseVehicle);
        }

        @Override
        void processMain() {
        }

        @Override
        void processWorldStreamer() {
            VehiclesDB2.instance.m_worldStreamer.m_store.updateVehicle(this.m_vehicleBuffer);
        }
    }

    private static class QueueRemoveVehicle
    extends QueueItem {
        static final Pool<QueueRemoveVehicle> s_pool = new Pool<QueueRemoveVehicle>(QueueRemoveVehicle::new);
        int m_id;

        private QueueRemoveVehicle() {
        }

        void init(BaseVehicle baseVehicle) {
            this.m_id = baseVehicle.sqlID;
        }

        @Override
        void processMain() {
        }

        @Override
        void processWorldStreamer() {
            VehiclesDB2.instance.m_worldStreamer.m_store.removeVehicle(this.m_id);
        }
    }

    private static class QueueLoadChunk
    extends QueueItem {
        static final Pool<QueueLoadChunk> s_pool = new Pool<QueueLoadChunk>(QueueLoadChunk::new);
        int m_wx;
        int m_wy;
        final ArrayList<BaseVehicle> m_vehicles = new ArrayList();
        IsoGridSquare m_dummySquare;

        private QueueLoadChunk() {
        }

        void init(int n, int n2) {
            this.m_wx = n;
            this.m_wy = n2;
            this.m_vehicles.clear();
            if (this.m_dummySquare == null) {
                this.m_dummySquare = IsoGridSquare.getNew(IsoWorld.instance.CurrentCell, null, 0, 0, 0);
            }
        }

        @Override
        void processMain() {
            IsoChunk isoChunk = ServerMap.instance.getChunk(this.m_wx, this.m_wy);
            if (isoChunk == null) {
                this.m_vehicles.clear();
                return;
            }
            if (isoChunk.m_loadVehiclesObject != this) {
                this.m_vehicles.clear();
                return;
            }
            isoChunk.m_loadVehiclesObject = null;
            for (int i = 0; i < this.m_vehicles.size(); ++i) {
                BaseVehicle baseVehicle = this.m_vehicles.get(i);
                IsoGridSquare isoGridSquare = isoChunk.getGridSquare((int)(baseVehicle.x - (float)(isoChunk.wx * 10)), (int)(baseVehicle.y - (float)(isoChunk.wy * 10)), 0);
                baseVehicle.setSquare(isoGridSquare);
                baseVehicle.setCurrent(isoGridSquare);
                baseVehicle.chunk = isoChunk;
                if (isoChunk.jobType == IsoChunk.JobType.SoftReset) {
                    baseVehicle.softReset();
                }
                if (!baseVehicle.addedToWorld && instance.isVehicleLoaded(baseVehicle)) {
                    baseVehicle.removeFromSquare();
                    this.m_vehicles.remove(i);
                    --i;
                    continue;
                }
                isoChunk.vehicles.add(baseVehicle);
                if (baseVehicle.addedToWorld) continue;
                baseVehicle.addToWorld();
            }
            this.m_vehicles.clear();
        }

        @Override
        void processWorldStreamer() {
            try {
                VehiclesDB2.instance.m_worldStreamer.m_store.loadChunk(this.m_wx, this.m_wy, this::vehicleLoaded);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }

        void vehicleLoaded(VehicleBuffer vehicleBuffer) throws IOException {
            assert (vehicleBuffer.m_id >= 1);
            int n = (int)(vehicleBuffer.m_x - (float)(this.m_wx * 10));
            int n2 = (int)(vehicleBuffer.m_y - (float)(this.m_wy * 10));
            this.m_dummySquare.x = n;
            this.m_dummySquare.y = n2;
            IsoGridSquare isoGridSquare = this.m_dummySquare;
            BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
            baseVehicle.setSquare(isoGridSquare);
            baseVehicle.setCurrent(isoGridSquare);
            try {
                baseVehicle.load(vehicleBuffer.m_bb, vehicleBuffer.m_WorldVersion);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                DebugLog.General.error("vehicle %d is being deleted because an error occurred loading it", vehicleBuffer.m_id);
                VehiclesDB2.instance.m_worldStreamer.m_store.removeVehicle(vehicleBuffer.m_id);
                return;
            }
            baseVehicle.sqlID = vehicleBuffer.m_id;
            this.m_vehicles.add(baseVehicle);
        }
    }

    private static final class QueueAddVehicle
    extends QueueItem {
        static final Pool<QueueAddVehicle> s_pool = new Pool<QueueAddVehicle>(QueueAddVehicle::new);
        final VehicleBuffer m_vehicleBuffer = new VehicleBuffer();

        private QueueAddVehicle() {
        }

        void init(BaseVehicle baseVehicle) throws IOException {
            this.m_vehicleBuffer.set(baseVehicle);
        }

        @Override
        void processMain() {
        }

        @Override
        void processWorldStreamer() {
            VehiclesDB2.instance.m_worldStreamer.m_store.updateVehicle(this.m_vehicleBuffer);
        }
    }

    private static class MemoryStore
    extends IVehicleStore {
        final TIntObjectHashMap<VehicleBuffer> m_IDToVehicle = new TIntObjectHashMap();
        final TIntObjectHashMap<ArrayList<VehicleBuffer>> m_ChunkToVehicles = new TIntObjectHashMap();

        private MemoryStore() {
        }

        @Override
        void init(TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2) {
            tIntHashSet.clear();
            tIntHashSet2.clear();
        }

        @Override
        void Reset() {
            this.m_IDToVehicle.clear();
            this.m_ChunkToVehicles.clear();
        }

        @Override
        void loadChunk(IsoChunk isoChunk, ThrowingBiConsumer<IsoChunk, VehicleBuffer, IOException> throwingBiConsumer) throws IOException {
            int n = isoChunk.wy << 16 | isoChunk.wx;
            ArrayList arrayList = (ArrayList)this.m_ChunkToVehicles.get(n);
            if (arrayList == null) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                VehicleBuffer vehicleBuffer = (VehicleBuffer)arrayList.get(i);
                vehicleBuffer.m_bb.rewind();
                boolean bl = vehicleBuffer.m_bb.get() == 1;
                int n2 = vehicleBuffer.m_bb.getInt();
                throwingBiConsumer.accept(isoChunk, vehicleBuffer);
            }
        }

        @Override
        void loadChunk(int n, int n2, ThrowingConsumer<VehicleBuffer, IOException> throwingConsumer) throws IOException {
            int n3 = n2 << 16 | n;
            ArrayList arrayList = (ArrayList)this.m_ChunkToVehicles.get(n3);
            if (arrayList == null) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                VehicleBuffer vehicleBuffer = (VehicleBuffer)arrayList.get(i);
                vehicleBuffer.m_bb.rewind();
                boolean bl = vehicleBuffer.m_bb.get() == 1;
                int n4 = vehicleBuffer.m_bb.getInt();
                throwingConsumer.accept(vehicleBuffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void updateVehicle(VehicleBuffer vehicleBuffer) {
            int n;
            assert (vehicleBuffer.m_id >= 1);
            Object object = VehiclesDB2.instance.m_main.m_usedIDs;
            synchronized (object) {
                assert (VehiclesDB2.instance.m_main.m_usedIDs.contains(vehicleBuffer.m_id));
            }
            vehicleBuffer.m_bb.rewind();
            object = (VehicleBuffer)this.m_IDToVehicle.get(vehicleBuffer.m_id);
            if (object == null) {
                object = new VehicleBuffer();
                ((VehicleBuffer)object).m_id = vehicleBuffer.m_id;
                this.m_IDToVehicle.put(vehicleBuffer.m_id, object);
            } else {
                n = ((VehicleBuffer)object).m_wy << 16 | ((VehicleBuffer)object).m_wx;
                ((ArrayList)this.m_ChunkToVehicles.get(n)).remove(object);
            }
            ((VehicleBuffer)object).m_wx = vehicleBuffer.m_wx;
            ((VehicleBuffer)object).m_wy = vehicleBuffer.m_wy;
            ((VehicleBuffer)object).m_x = vehicleBuffer.m_x;
            ((VehicleBuffer)object).m_y = vehicleBuffer.m_y;
            ((VehicleBuffer)object).m_WorldVersion = vehicleBuffer.m_WorldVersion;
            ((VehicleBuffer)object).setBytes(vehicleBuffer.m_bb);
            n = ((VehicleBuffer)object).m_wy << 16 | ((VehicleBuffer)object).m_wx;
            if (this.m_ChunkToVehicles.get(n) == null) {
                this.m_ChunkToVehicles.put(n, new ArrayList());
            }
            ((ArrayList)this.m_ChunkToVehicles.get(n)).add(object);
        }

        @Override
        void removeVehicle(int n) {
            VehicleBuffer vehicleBuffer = (VehicleBuffer)this.m_IDToVehicle.remove(n);
            if (vehicleBuffer == null) {
                return;
            }
            int n2 = vehicleBuffer.m_wy << 16 | vehicleBuffer.m_wx;
            ((ArrayList)this.m_ChunkToVehicles.get(n2)).remove(vehicleBuffer);
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T1, T2, E extends Exception> {
        public void accept(T1 var1, T2 var2) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T1, E extends Exception> {
        public void accept(T1 var1) throws E;
    }

    private static final class VehicleBuffer {
        int m_id = -1;
        int m_wx;
        int m_wy;
        float m_x;
        float m_y;
        int m_WorldVersion;
        ByteBuffer m_bb = ByteBuffer.allocate(32768);

        private VehicleBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(BaseVehicle baseVehicle) throws IOException {
            assert (baseVehicle.sqlID >= 1);
            Object object = VehiclesDB2.instance.m_main.m_usedIDs;
            synchronized (object) {
                assert (VehiclesDB2.instance.m_main.m_usedIDs.contains(baseVehicle.sqlID));
            }
            this.m_id = baseVehicle.sqlID;
            this.m_wx = baseVehicle.chunk.wx;
            this.m_wy = baseVehicle.chunk.wy;
            this.m_x = baseVehicle.getX();
            this.m_y = baseVehicle.getY();
            this.m_WorldVersion = IsoWorld.getWorldVersion();
            object = TL_SliceBuffer.get();
            ((ByteBuffer)object).clear();
            while (true) {
                try {
                    baseVehicle.save((ByteBuffer)object);
                }
                catch (BufferOverflowException bufferOverflowException) {
                    if (((Buffer)object).capacity() >= 0x200000) {
                        DebugLog.General.error("the vehicle %d cannot be saved", baseVehicle.sqlID);
                        throw bufferOverflowException;
                    }
                    object = ByteBuffer.allocate(((Buffer)object).capacity() + 32768);
                    TL_SliceBuffer.set((ByteBuffer)object);
                    continue;
                }
                break;
            }
            ((ByteBuffer)object).flip();
            this.setBytes((ByteBuffer)object);
        }

        void setBytes(ByteBuffer byteBuffer) {
            int n;
            byteBuffer.rewind();
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.m_bb, true);
            byteBufferOutputStream.clear();
            byte[] byArray = TL_Bytes.get();
            for (int i = byteBuffer.limit(); i > 0; i -= n) {
                n = Math.min(byArray.length, i);
                byteBuffer.get(byArray, 0, n);
                byteBufferOutputStream.write(byArray, 0, n);
            }
            byteBufferOutputStream.flip();
            this.m_bb = byteBufferOutputStream.getWrappedBuffer();
        }

        void setBytes(byte[] byArray) {
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.m_bb, true);
            byteBufferOutputStream.clear();
            byteBufferOutputStream.write(byArray);
            byteBufferOutputStream.flip();
            this.m_bb = byteBufferOutputStream.getWrappedBuffer();
        }

        void setBytes(InputStream inputStream) throws IOException {
            int n;
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.m_bb, true);
            byteBufferOutputStream.clear();
            byte[] byArray = TL_Bytes.get();
            while ((n = inputStream.read(byArray)) >= 1) {
                byteBufferOutputStream.write(byArray, 0, n);
            }
            byteBufferOutputStream.flip();
            this.m_bb = byteBufferOutputStream.getWrappedBuffer();
        }
    }
}

