/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.characters.IsoGameCharacter;
import zombie.iso.IsoGridSquare;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.scripting.objects.VehicleScript;
import zombie.vehicles.VehiclePart;

public final class VehicleWindow {
    protected VehiclePart part;
    protected int health;
    protected boolean openable;
    protected boolean open;
    protected float openDelta = 0.0f;

    VehicleWindow(VehiclePart vehiclePart) {
        this.part = vehiclePart;
    }

    public void init(VehicleScript.Window window) {
        this.health = 100;
        this.openable = window.openable;
        this.open = false;
    }

    public int getHealth() {
        return this.part.getCondition();
    }

    public void setHealth(int n) {
        n = Math.max(n, 0);
        this.health = n = Math.min(n, 100);
    }

    public boolean isDestroyed() {
        return this.getHealth() == 0;
    }

    public boolean isOpenable() {
        return this.openable;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
        this.part.getVehicle().bDoDamageOverlay = true;
    }

    public void setOpenDelta(float f) {
        this.openDelta = f;
    }

    public float getOpenDelta() {
        return this.openDelta;
    }

    public boolean isHittable() {
        if (this.isDestroyed()) {
            return false;
        }
        if (this.isOpen()) {
            return false;
        }
        return this.part.getItemType() == null || this.part.getInventoryItem() != null;
    }

    public void hit(IsoGameCharacter isoGameCharacter) {
        this.damage(this.getHealth());
        this.part.setCondition(0);
    }

    public void damage(int n) {
        if (n <= 0) {
            return;
        }
        if (!this.isHittable()) {
            return;
        }
        if (GameClient.bClient) {
            GameClient.instance.sendClientCommandV(null, "vehicle", "damageWindow", "vehicle", this.part.vehicle.getId(), "part", this.part.getId(), "amount", n);
            return;
        }
        if (this.part.getVehicle().isAlarmed()) {
            this.part.getVehicle().triggerAlarm();
        }
        this.part.setCondition(this.part.getCondition() - n);
        if (this.isDestroyed()) {
            if (this.part.getInventoryItem() != null) {
                this.part.setInventoryItem(null);
                this.part.getVehicle().transmitPartItem(this.part);
            }
            IsoGridSquare isoGridSquare = this.part.vehicle.square;
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer("SmashWindow", false, isoGridSquare, 0.2f, 20.0f, 1.1f, true);
            } else {
                SoundManager.instance.PlayWorldSound("SmashWindow", isoGridSquare, 0.2f, 20.0f, 1.0f, true);
            }
            this.part.getVehicle().getSquare().addBrokenGlass();
            WorldSoundManager.instance.addSound(null, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), 10, 20, true, 4.0f, 15.0f);
        }
        this.part.getVehicle().transmitPartWindow(this.part);
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)this.part.getCondition());
        byteBuffer.put((byte)(this.open ? 1 : 0));
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.part.setCondition(byteBuffer.get());
        this.health = this.part.getCondition();
        this.open = byteBuffer.get() == 1;
        this.openDelta = this.open ? 1.0f : 0.0f;
    }
}

