/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import gnu.trove.list.array.TShortArrayList;
import gnu.trove.map.hash.TShortShortHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.SoundManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.physics.Bullet;
import zombie.core.physics.Transform;
import zombie.core.physics.WorldSimulation;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.DrainableComboItem;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.packets.VehicleAuthorizationPacket;
import zombie.network.packets.vehicle.Physics;
import zombie.scripting.objects.VehicleScript;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleCache;
import zombie.vehicles.VehicleIDMap;
import zombie.vehicles.VehiclePart;

public final class VehicleManager {
    public static VehicleManager instance;
    private final VehicleIDMap IDToVehicle = VehicleIDMap.instance;
    private final ArrayList<BaseVehicle> vehicles = new ArrayList();
    private boolean idMapDirty = true;
    private final Transform tempTransform = new Transform();
    private final ArrayList<BaseVehicle> sendReliable = new ArrayList();
    private final ArrayList<BaseVehicle> sendUnreliable = new ArrayList();
    private final TShortArrayList vehiclesWaitUpdates = new TShortArrayList(128);
    private final TShortShortHashMap towedVehicleMap = new TShortShortHashMap();
    public static HashMap<Byte, String> vehiclePacketTypes;
    public final UdpConnection[] connected = new UdpConnection[512];
    private final float[] tempFloats = new float[27];
    private final float[] engineSound = new float[2];
    private final PosUpdateVars posUpdateVars = new PosUpdateVars();
    private final UpdateLimit vehiclesWaitUpdatesFrequency = new UpdateLimit(1000L);
    private BaseVehicle tempVehicle;
    private final ArrayList<BaseVehicle.ModelInfo> oldModels = new ArrayList();
    private final ArrayList<BaseVehicle.ModelInfo> curModels = new ArrayList();
    private final UpdateLimit sendRequestGetPositionFrequency = new UpdateLimit(500L);
    private final UpdateLimit VehiclePhysicSyncPacketLimit = new UpdateLimit(500L);

    public void registerVehicle(BaseVehicle baseVehicle) {
        this.IDToVehicle.put(baseVehicle.VehicleID, baseVehicle);
        this.idMapDirty = true;
    }

    public void unregisterVehicle(BaseVehicle baseVehicle) {
        this.IDToVehicle.remove(baseVehicle.VehicleID);
        this.idMapDirty = true;
    }

    public BaseVehicle getVehicleByID(short s) {
        return this.IDToVehicle.get(s);
    }

    public ArrayList<BaseVehicle> getVehicles() {
        if (this.idMapDirty) {
            this.vehicles.clear();
            this.IDToVehicle.toArrayList(this.vehicles);
            this.idMapDirty = false;
        }
        return this.vehicles;
    }

    public void removeFromWorld(BaseVehicle baseVehicle) {
        if (baseVehicle.VehicleID != -1) {
            DebugLog.Vehicle.trace("removeFromWorld vehicle id=%d", baseVehicle.VehicleID);
            this.unregisterVehicle(baseVehicle);
            if (GameServer.bServer) {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                    if (baseVehicle.connectionState[udpConnection.index] == null) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                    PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
                    byteBufferWriter.bb.put((byte)8);
                    byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
                    PacketTypes.PacketType.Vehicles.send(udpConnection);
                }
            }
            if (GameClient.bClient) {
                baseVehicle.serverRemovedFromWorld = false;
                if (baseVehicle.interpolation != null) {
                    baseVehicle.interpolation.clear();
                }
            }
        }
    }

    public void serverUpdate() {
        int n;
        ArrayList<BaseVehicle> arrayList = IsoWorld.instance.CurrentCell.getVehicles();
        for (n = 0; n < this.connected.length; ++n) {
            int n2;
            if (this.connected[n] != null && !GameServer.udpEngine.connections.contains(this.connected[n])) {
                DebugLog.Vehicle.trace("vehicles: dropped connection %d", n);
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList.get((int)n2).connectionState[n] = null;
                }
                this.connected[n] = null;
                continue;
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (arrayList.get((int)n2).connectionState[n] == null) continue;
                arrayList.get((int)n2).connectionState[n].flags = (short)(arrayList.get((int)n2).connectionState[n].flags | arrayList.get((int)n2).updateFlags);
            }
        }
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(n);
            this.sendVehicles(udpConnection, PacketTypes.PacketType.VehiclesUnreliable.getId());
            this.connected[udpConnection.index] = udpConnection;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            BaseVehicle baseVehicle = arrayList.get(n);
            if ((baseVehicle.updateFlags & 0x4BF0) != 0) {
                for (int i = 0; i < baseVehicle.getPartCount(); ++i) {
                    VehiclePart vehiclePart = baseVehicle.getPartByIndex(i);
                    vehiclePart.updateFlags = 0;
                }
            }
            baseVehicle.updateFlags = 0;
        }
    }

    private void sendVehicles(UdpConnection udpConnection, short s) {
        if (!udpConnection.isFullyConnected()) {
            return;
        }
        this.sendReliable.clear();
        this.sendUnreliable.clear();
        ArrayList<BaseVehicle> arrayList = IsoWorld.instance.CurrentCell.getVehicles();
        for (int i = 0; i < arrayList.size(); ++i) {
            BaseVehicle.ServerVehicleState serverVehicleState;
            BaseVehicle baseVehicle = arrayList.get(i);
            if (baseVehicle.VehicleID == -1) {
                baseVehicle.VehicleID = this.IDToVehicle.allocateID();
                this.registerVehicle(baseVehicle);
            }
            if (!udpConnection.RelevantTo(baseVehicle.x, baseVehicle.y)) continue;
            if (baseVehicle.connectionState[udpConnection.index] == null) {
                baseVehicle.connectionState[udpConnection.index] = new BaseVehicle.ServerVehicleState();
            }
            if (!(serverVehicleState = baseVehicle.connectionState[udpConnection.index]).shouldSend(baseVehicle)) continue;
            if (baseVehicle.isReliable || PacketTypes.PacketType.Vehicles.getId() == s) {
                this.sendReliable.add(baseVehicle);
                continue;
            }
            this.sendUnreliable.add(baseVehicle);
        }
        this.sendVehiclesInternal(udpConnection, this.sendReliable, PacketTypes.PacketType.Vehicles);
        this.sendVehiclesInternal(udpConnection, this.sendUnreliable, PacketTypes.PacketType.VehiclesUnreliable);
    }

    private void sendVehiclesInternal(UdpConnection udpConnection, ArrayList<BaseVehicle> arrayList, PacketTypes.PacketType packetType) {
        Object object;
        Object object2;
        if (arrayList.isEmpty()) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        packetType.doPacket(byteBufferWriter);
        try {
            ByteBuffer byteBuffer = byteBufferWriter.bb;
            byteBuffer.put((byte)5);
            byteBuffer.putShort((short)arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                int n2;
                boolean bl;
                object2 = arrayList.get(i);
                object = ((BaseVehicle)object2).connectionState[udpConnection.index];
                byteBuffer.putShort(((BaseVehicle)object2).VehicleID);
                byteBuffer.putShort(((BaseVehicle.ServerVehicleState)object).flags);
                byteBuffer.putFloat(((BaseVehicle)object2).x);
                byteBuffer.putFloat(((BaseVehicle)object2).y);
                byteBuffer.putFloat(((BaseVehicle)object2).jniTransform.origin.y);
                int n3 = byteBuffer.position();
                byteBuffer.putShort((short)0);
                int n4 = byteBuffer.position();
                boolean bl2 = bl = (((BaseVehicle.ServerVehicleState)object).flags & 1) != 0;
                if (bl) {
                    ((BaseVehicle.ServerVehicleState)object).flags = (short)(((BaseVehicle.ServerVehicleState)object).flags & 0xFFFFFFFE);
                    ((BaseVehicle)object2).netPlayerServerSendAuthorisation(byteBuffer);
                    ((BaseVehicle.ServerVehicleState)object).setAuthorization((BaseVehicle)object2);
                    n2 = byteBuffer.position();
                    byteBuffer.putShort((short)0);
                    ((IsoObject)object2).save(byteBuffer);
                    n = byteBuffer.position();
                    byteBuffer.position(n2);
                    byteBuffer.putShort((short)(n - n2));
                    byteBuffer.position(n);
                    int n5 = byteBuffer.position();
                    int n6 = byteBuffer.position() - n4;
                    byteBuffer.position(n3);
                    byteBuffer.putShort((short)n6);
                    byteBuffer.position(n5);
                    this.writePositionOrientation(byteBuffer, (BaseVehicle)object2);
                    ((BaseVehicle.ServerVehicleState)object).x = ((BaseVehicle)object2).x;
                    ((BaseVehicle.ServerVehicleState)object).y = ((BaseVehicle)object2).y;
                    ((BaseVehicle.ServerVehicleState)object).z = ((BaseVehicle)object2).jniTransform.origin.y;
                    ((BaseVehicle.ServerVehicleState)object).orient.set((Quaternionfc)((BaseVehicle)object2).savedRot);
                    continue;
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 2) != 0) {
                    this.writePositionOrientation(byteBuffer, (BaseVehicle)object2);
                    ((BaseVehicle.ServerVehicleState)object).x = ((BaseVehicle)object2).x;
                    ((BaseVehicle.ServerVehicleState)object).y = ((BaseVehicle)object2).y;
                    ((BaseVehicle.ServerVehicleState)object).z = ((BaseVehicle)object2).jniTransform.origin.y;
                    ((BaseVehicle.ServerVehicleState)object).orient.set((Quaternionfc)((BaseVehicle)object2).savedRot);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 4) != 0) {
                    byteBuffer.put((byte)((BaseVehicle)object2).engineState.ordinal());
                    byteBuffer.putInt(((BaseVehicle)object2).engineLoudness);
                    byteBuffer.putInt(((BaseVehicle)object2).enginePower);
                    byteBuffer.putInt(((BaseVehicle)object2).engineQuality);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x1000) != 0) {
                    byteBuffer.put((byte)(((BaseVehicle)object2).isHotwired() ? 1 : 0));
                    byteBuffer.put((byte)(((BaseVehicle)object2).isHotwiredBroken() ? 1 : 0));
                    byteBuffer.putFloat(((BaseVehicle)object2).getRegulatorSpeed());
                    byteBuffer.put((byte)(((BaseVehicle)object2).isPreviouslyEntered() ? 1 : 0));
                    byteBuffer.put((byte)(((BaseVehicle)object2).isKeysInIgnition() ? 1 : 0));
                    byteBuffer.put((byte)(((BaseVehicle)object2).isKeyIsOnDoor() ? 1 : 0));
                    InventoryItem inventoryItem = ((BaseVehicle)object2).getCurrentKey();
                    if (inventoryItem == null) {
                        byteBuffer.put((byte)0);
                    } else {
                        byteBuffer.put((byte)1);
                        inventoryItem.saveWithSize(byteBuffer, false);
                    }
                    byteBuffer.putFloat(((BaseVehicle)object2).getRust());
                    byteBuffer.putFloat(((BaseVehicle)object2).getBloodIntensity("Front"));
                    byteBuffer.putFloat(((BaseVehicle)object2).getBloodIntensity("Rear"));
                    byteBuffer.putFloat(((BaseVehicle)object2).getBloodIntensity("Left"));
                    byteBuffer.putFloat(((BaseVehicle)object2).getBloodIntensity("Right"));
                    byteBuffer.putFloat(((BaseVehicle)object2).getColorHue());
                    byteBuffer.putFloat(((BaseVehicle)object2).getColorSaturation());
                    byteBuffer.putFloat(((BaseVehicle)object2).getColorValue());
                    byteBuffer.putInt(((BaseVehicle)object2).getSkinIndex());
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 8) != 0) {
                    byteBuffer.put((byte)(((BaseVehicle)object2).getHeadlightsOn() ? 1 : 0));
                    byteBuffer.put((byte)(((BaseVehicle)object2).getStoplightsOn() ? 1 : 0));
                    for (int j = 0; j < ((BaseVehicle)object2).getLightCount(); ++j) {
                        byteBuffer.put((byte)(((BaseVehicle)object2).getLightByIndex(j).getLight().getActive() ? 1 : 0));
                    }
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x400) != 0) {
                    byteBuffer.put((byte)(((BaseVehicle)object2).soundHornOn ? 1 : 0));
                    byteBuffer.put((byte)(((BaseVehicle)object2).soundBackMoveOn ? 1 : 0));
                    byteBuffer.put((byte)((BaseVehicle)object2).lightbarLightsMode.get());
                    byteBuffer.put((byte)((BaseVehicle)object2).lightbarSirenMode.get());
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x800) != 0) {
                    for (int j = 0; j < ((BaseVehicle)object2).getPartCount(); ++j) {
                        VehiclePart vehiclePart = ((BaseVehicle)object2).getPartByIndex(j);
                        if ((vehiclePart.updateFlags & 0x800) == 0) continue;
                        byteBuffer.put((byte)j);
                        byteBuffer.putInt(vehiclePart.getCondition());
                    }
                    byteBuffer.put((byte)-1);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x10) != 0) {
                    for (int j = 0; j < ((BaseVehicle)object2).getPartCount(); ++j) {
                        VehiclePart vehiclePart = ((BaseVehicle)object2).getPartByIndex(j);
                        if ((vehiclePart.updateFlags & 0x10) == 0) continue;
                        byteBuffer.put((byte)j);
                        vehiclePart.getModData().save(byteBuffer);
                    }
                    byteBuffer.put((byte)-1);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x20) != 0) {
                    for (int j = 0; j < ((BaseVehicle)object2).getPartCount(); ++j) {
                        InventoryItem inventoryItem;
                        VehiclePart vehiclePart = ((BaseVehicle)object2).getPartByIndex(j);
                        if ((vehiclePart.updateFlags & 0x20) == 0 || !((inventoryItem = vehiclePart.getInventoryItem()) instanceof DrainableComboItem)) continue;
                        byteBuffer.put((byte)j);
                        byteBuffer.putFloat(((DrainableComboItem)inventoryItem).getUsedDelta());
                    }
                    byteBuffer.put((byte)-1);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x80) != 0) {
                    for (int j = 0; j < ((BaseVehicle)object2).getPartCount(); ++j) {
                        VehiclePart vehiclePart = ((BaseVehicle)object2).getPartByIndex(j);
                        if ((vehiclePart.updateFlags & 0x80) == 0) continue;
                        byteBuffer.put((byte)j);
                        InventoryItem inventoryItem = vehiclePart.getInventoryItem();
                        if (inventoryItem == null) {
                            byteBuffer.put((byte)0);
                            continue;
                        }
                        byteBuffer.put((byte)1);
                        try {
                            vehiclePart.getInventoryItem().saveWithSize(byteBuffer, false);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    byteBuffer.put((byte)-1);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x200) != 0) {
                    for (int j = 0; j < ((BaseVehicle)object2).getPartCount(); ++j) {
                        VehiclePart vehiclePart = ((BaseVehicle)object2).getPartByIndex(j);
                        if ((vehiclePart.updateFlags & 0x200) == 0) continue;
                        byteBuffer.put((byte)j);
                        vehiclePart.getDoor().save(byteBuffer);
                    }
                    byteBuffer.put((byte)-1);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x100) != 0) {
                    for (int j = 0; j < ((BaseVehicle)object2).getPartCount(); ++j) {
                        VehiclePart vehiclePart = ((BaseVehicle)object2).getPartByIndex(j);
                        if ((vehiclePart.updateFlags & 0x100) == 0) continue;
                        byteBuffer.put((byte)j);
                        vehiclePart.getWindow().save(byteBuffer);
                    }
                    byteBuffer.put((byte)-1);
                }
                if ((((BaseVehicle.ServerVehicleState)object).flags & 0x40) != 0) {
                    byteBuffer.put((byte)((BaseVehicle)object2).models.size());
                    for (int j = 0; j < ((BaseVehicle)object2).models.size(); ++j) {
                        BaseVehicle.ModelInfo modelInfo = ((BaseVehicle)object2).models.get(j);
                        byteBuffer.put((byte)modelInfo.part.getIndex());
                        byteBuffer.put((byte)modelInfo.part.getScriptPart().models.indexOf(modelInfo.scriptModel));
                    }
                }
                n2 = byteBuffer.position();
                n = byteBuffer.position() - n4;
                byteBuffer.position(n3);
                byteBuffer.putShort((short)n);
                byteBuffer.position(n2);
            }
            packetType.send(udpConnection);
        }
        catch (Exception exception) {
            udpConnection.cancelPacket();
            exception.printStackTrace();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BaseVehicle baseVehicle = arrayList.get(i);
            object2 = baseVehicle.connectionState[udpConnection.index];
            if ((((BaseVehicle.ServerVehicleState)object2).flags & 0x4000) == 0) continue;
            object = new VehicleAuthorizationPacket();
            ((VehicleAuthorizationPacket)object).set(baseVehicle, udpConnection);
            ByteBufferWriter byteBufferWriter2 = udpConnection.startPacket();
            PacketTypes.PacketType.VehicleAuthorization.doPacket(byteBufferWriter2);
            ((VehicleAuthorizationPacket)object).write(byteBufferWriter2);
            PacketTypes.PacketType.VehicleAuthorization.send(udpConnection);
        }
    }

    public void serverPacket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        switch (by) {
            case 1: {
                IsoGameCharacter isoGameCharacter;
                short s2 = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s2);
                byte by2 = byteBuffer.get();
                String string = GameWindow.ReadString(byteBuffer);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s2);
                if (baseVehicle == null || (isoGameCharacter = baseVehicle.getCharacter(by2)) == null) break;
                baseVehicle.setCharacterPosition(isoGameCharacter, by2, string);
                this.sendPassengerPosition(baseVehicle, by2, string, udpConnection);
                break;
            }
            case 15: {
                short s3 = byteBuffer.getShort();
                short s4 = byteBuffer.getShort();
                boolean bl = byteBuffer.get() == 1;
                DebugLog.Vehicle.trace("%s vid=%d pid=%d %b", vehiclePacketTypes.get(by), s3, s4, bl);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s3);
                if (baseVehicle == null) break;
                baseVehicle.authorizationServerCollide(s4, bl);
                break;
            }
            case 4: {
                short s5 = byteBuffer.getShort();
                short s6 = byteBuffer.getShort();
                byte by3 = byteBuffer.get();
                byte by4 = byteBuffer.get();
                DebugLog.Vehicle.trace("Vehicle switch seat vid=%d pid=%d seats=%d=>%d", s5, s6, by3, by4);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s5);
                if (baseVehicle == null) {
                    DebugLog.Vehicle.warn("Vehicle vid=%d not found", s5);
                    break;
                }
                IsoPlayer isoPlayer = GameServer.IDToPlayerMap.get(s6);
                if (isoPlayer == null) {
                    DebugLog.Vehicle.warn("Player pid=%d not found", s6);
                    break;
                }
                IsoPlayer isoPlayer2 = Type.tryCastTo(baseVehicle.getCharacter(by4), IsoPlayer.class);
                if (isoPlayer2 != null && isoPlayer2 != isoPlayer) {
                    DebugLog.Vehicle.warn(isoPlayer.getUsername() + " switched to same seat as " + isoPlayer2.getUsername());
                    break;
                }
                baseVehicle.switchSeat(isoPlayer, by4);
                if (by4 == 0 && baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.Server)) {
                    baseVehicle.authorizationServerOnSeat(isoPlayer, true);
                } else if (by3 == 0) {
                    baseVehicle.authorizationServerOnSeat(isoPlayer, false);
                }
                this.sendSwitchSeat(baseVehicle, isoPlayer, by3, by4);
                break;
            }
            case 2: {
                short s7 = byteBuffer.getShort();
                short s8 = byteBuffer.getShort();
                byte by5 = byteBuffer.get();
                DebugLog.Vehicle.trace("Vehicle enter vid=%d pid=%d seat=%d", s7, s8, by5);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s7);
                if (baseVehicle == null) {
                    DebugLog.Vehicle.warn("Vehicle vid=%d not found", s7);
                    break;
                }
                IsoPlayer isoPlayer = GameServer.IDToPlayerMap.get(s8);
                if (isoPlayer == null) {
                    DebugLog.Vehicle.warn("Player pid=%d not found", s8);
                    break;
                }
                IsoPlayer isoPlayer3 = Type.tryCastTo(baseVehicle.getCharacter(by5), IsoPlayer.class);
                if (isoPlayer3 != null && isoPlayer3 != isoPlayer) {
                    DebugLog.Vehicle.warn(isoPlayer.getUsername() + " got in same seat as " + isoPlayer3.getUsername());
                    break;
                }
                baseVehicle.enter(by5, isoPlayer);
                if (by5 == 0 && baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.Server)) {
                    baseVehicle.authorizationServerOnSeat(isoPlayer, true);
                }
                this.sendEnter(baseVehicle, isoPlayer, by5);
                break;
            }
            case 3: {
                short s9 = byteBuffer.getShort();
                short s10 = byteBuffer.getShort();
                byte by6 = byteBuffer.get();
                DebugLog.Vehicle.trace("Vehicle exit vid=%d pid=%d seat=%d", s9, s10, by6);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s9);
                if (baseVehicle == null) {
                    DebugLog.Vehicle.warn("Vehicle vid=%d not found", s9);
                    break;
                }
                IsoPlayer isoPlayer = GameServer.IDToPlayerMap.get(s10);
                if (isoPlayer == null) {
                    DebugLog.Vehicle.warn("Player pid=%d not found", s10);
                    break;
                }
                baseVehicle.exit(isoPlayer);
                if (by6 == 0) {
                    baseVehicle.authorizationServerOnSeat(isoPlayer, false);
                }
                this.sendExit(baseVehicle, isoPlayer, by6);
                break;
            }
            case 16: {
                short s11 = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s11);
                byte by7 = byteBuffer.get();
                BaseVehicle baseVehicle = this.IDToVehicle.get(s11);
                if (baseVehicle == null) break;
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                    if (udpConnection2 == udpConnection) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
                    byteBufferWriter.bb.put((byte)16);
                    byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
                    byteBufferWriter.bb.put(by7);
                    PacketTypes.PacketType.Vehicles.send(udpConnection2);
                }
                break;
            }
            case 9: {
                Physics physics = new Physics();
                physics.parse(byteBuffer, udpConnection);
                physics.process();
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection3 = GameServer.udpEngine.connections.get(i);
                    if (udpConnection == udpConnection3 || !physics.isRelevant(udpConnection3)) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection3.startPacket();
                    PacketTypes.PacketType packetType = PacketTypes.packetTypes.get(s);
                    packetType.doPacket(byteBufferWriter);
                    byteBufferWriter.bb.put((byte)9);
                    physics.write(byteBufferWriter);
                    packetType.send(udpConnection3);
                }
                break;
            }
            case 11: {
                int n = byteBuffer.getShort();
                for (int i = 0; i < n; ++i) {
                    short s12 = byteBuffer.getShort();
                    DebugLog.Vehicle.trace("Vehicle vid=%d full update response ", s12);
                    BaseVehicle baseVehicle = this.IDToVehicle.get(s12);
                    if (baseVehicle == null) continue;
                    if (baseVehicle.connectionState[udpConnection.index] == null) {
                        baseVehicle.connectionState[udpConnection.index] = new BaseVehicle.ServerVehicleState();
                    }
                    baseVehicle.connectionState[udpConnection.index].flags = (short)(baseVehicle.connectionState[udpConnection.index].flags | 1);
                    this.sendVehicles(udpConnection, s);
                }
                break;
            }
            case 12: {
                short s13 = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s13);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s13);
                if (baseVehicle == null) break;
                baseVehicle.updateFlags = (short)(baseVehicle.updateFlags | 2);
                this.sendVehicles(udpConnection, s);
                break;
            }
            default: {
                DebugLog.Vehicle.warn("Unknown vehicle packet %d", by);
            }
        }
    }

    public void serverSendInitialWorldState(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)19);
        byteBufferWriter.bb.putShort((short)this.towedVehicleMap.size());
        this.towedVehicleMap.forEachEntry((s, s2) -> {
            byteBufferWriter.putShort(s);
            byteBufferWriter.putShort(s2);
            return true;
        });
        PacketTypes.PacketType.Vehicles.send(udpConnection);
    }

    private void vehiclePosUpdate(BaseVehicle baseVehicle, float[] fArray) {
        int n = 0;
        Transform transform = this.posUpdateVars.transform;
        Vector3f vector3f = this.posUpdateVars.vector3f;
        Quaternionf quaternionf = this.posUpdateVars.quatf;
        float[] fArray2 = this.posUpdateVars.wheelSteer;
        float[] fArray3 = this.posUpdateVars.wheelRotation;
        float[] fArray4 = this.posUpdateVars.wheelSkidInfo;
        float[] fArray5 = this.posUpdateVars.wheelSuspensionLength;
        float f = fArray[n++] - WorldSimulation.instance.offsetX;
        float f2 = fArray[n++] - WorldSimulation.instance.offsetY;
        float f3 = fArray[n++];
        transform.origin.set(f, f3, f2);
        float f4 = fArray[n++];
        float f5 = fArray[n++];
        float f6 = fArray[n++];
        float f7 = fArray[n++];
        quaternionf.set(f4, f5, f6, f7);
        quaternionf.normalize();
        transform.setRotation(quaternionf);
        float f8 = fArray[n++];
        float f9 = fArray[n++];
        float f10 = fArray[n++];
        vector3f.set(f8, f9, f10);
        int n2 = (int)fArray[n++];
        for (int i = 0; i < n2; ++i) {
            fArray2[i] = fArray[n++];
            fArray3[i] = fArray[n++];
            fArray4[i] = fArray[n++];
            fArray5[i] = fArray[n++];
        }
        baseVehicle.jniTransform.set(transform);
        baseVehicle.jniLinearVelocity.set((Vector3fc)vector3f);
        baseVehicle.jniTransform.basis.getScale(vector3f);
        if ((double)vector3f.x < 0.99 || (double)vector3f.y < 0.99 || (double)vector3f.z < 0.99) {
            baseVehicle.jniTransform.basis.scale(1.0f / vector3f.x, 1.0f / vector3f.y, 1.0f / vector3f.z);
        }
        baseVehicle.jniSpeed = baseVehicle.jniLinearVelocity.length() * 3.6f;
        Vector3f vector3f2 = baseVehicle.getForwardVector(BaseVehicle.allocVector3f());
        if (vector3f2.dot((Vector3fc)baseVehicle.jniLinearVelocity) < 0.0f) {
            baseVehicle.jniSpeed *= -1.0f;
        }
        BaseVehicle.releaseVector3f(vector3f2);
        for (int i = 0; i < 4; ++i) {
            baseVehicle.wheelInfo[i].steering = fArray2[i];
            baseVehicle.wheelInfo[i].rotation = fArray3[i];
            baseVehicle.wheelInfo[i].skidInfo = fArray4[i];
            baseVehicle.wheelInfo[i].suspensionLength = fArray5[i];
        }
        baseVehicle.polyDirty = true;
    }

    public void clientUpdate() {
        int n;
        Object object;
        if (this.vehiclesWaitUpdatesFrequency.Check()) {
            if (this.vehiclesWaitUpdates.size() > 0) {
                object = GameClient.connection.startPacket();
                PacketTypes.PacketType.Vehicles.doPacket((ByteBufferWriter)object);
                ((ByteBufferWriter)object).bb.put((byte)11);
                ((ByteBufferWriter)object).bb.putShort((short)this.vehiclesWaitUpdates.size());
                for (n = 0; n < this.vehiclesWaitUpdates.size(); ++n) {
                    ((ByteBufferWriter)object).bb.putShort(this.vehiclesWaitUpdates.get(n));
                }
                PacketTypes.PacketType.Vehicles.send(GameClient.connection);
            }
            this.vehiclesWaitUpdates.clear();
        }
        object = this.getVehicles();
        for (n = 0; n < ((ArrayList)object).size(); ++n) {
            float[] fArray;
            BaseVehicle baseVehicle = (BaseVehicle)((ArrayList)object).get(n);
            if (GameClient.bClient) {
                if (baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.Local) || baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.LocalCollide)) {
                    baseVehicle.interpolation.clear();
                    continue;
                }
            } else if (baseVehicle.isKeyboardControlled() || baseVehicle.getJoypad() != -1) {
                baseVehicle.interpolation.clear();
                continue;
            }
            if (baseVehicle.interpolation.interpolationDataGet(fArray = this.tempFloats, this.engineSound)) {
                if (baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.Local) || baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.LocalCollide)) continue;
                Bullet.setOwnVehiclePhysics(baseVehicle.VehicleID, fArray);
                float f = fArray[0];
                float f2 = fArray[1];
                float f3 = fArray[2];
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, 0.0);
                this.clientUpdateVehiclePos(baseVehicle, f, f2, f3, isoGridSquare);
                baseVehicle.limitPhysicValid.BlockCheck();
                if (GameClient.bClient) {
                    this.vehiclePosUpdate(baseVehicle, fArray);
                }
                baseVehicle.engineSpeed = this.engineSound[0];
                baseVehicle.throttle = this.engineSound[1];
                continue;
            }
            baseVehicle.getController().control_NoControl();
            baseVehicle.throttle = 0.0f;
            baseVehicle.jniSpeed = 0.0f;
        }
    }

    private void clientUpdateVehiclePos(BaseVehicle baseVehicle, float f, float f2, float f3, IsoGridSquare isoGridSquare) {
        baseVehicle.setX(f);
        baseVehicle.setY(f2);
        baseVehicle.setZ(0.0f);
        baseVehicle.square = isoGridSquare;
        baseVehicle.setCurrent(isoGridSquare);
        if (isoGridSquare != null) {
            if (baseVehicle.chunk != null && baseVehicle.chunk != isoGridSquare.chunk) {
                baseVehicle.chunk.vehicles.remove(baseVehicle);
            }
            baseVehicle.chunk = baseVehicle.square.chunk;
            if (!baseVehicle.chunk.vehicles.contains(baseVehicle)) {
                baseVehicle.chunk.vehicles.add(baseVehicle);
                IsoChunk.addFromCheckedVehicles(baseVehicle);
            }
            if (!baseVehicle.addedToWorld) {
                baseVehicle.addToWorld();
            }
        } else {
            baseVehicle.removeFromWorld();
            baseVehicle.removeFromSquare();
        }
        baseVehicle.polyDirty = true;
    }

    private void clientReceiveUpdateFull(ByteBuffer byteBuffer, short s, float f, float f2, float f3) throws IOException {
        BaseVehicle.Authorization authorization = BaseVehicle.Authorization.valueOf(byteBuffer.get());
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, 0.0);
        if (this.IDToVehicle.containsKey(s)) {
            BaseVehicle baseVehicle = this.IDToVehicle.get(s);
            DebugLog.Vehicle.noise("ERROR: got full update for KNOWN vehicle id=%d", s);
            byteBuffer.get();
            byteBuffer.get();
            this.tempVehicle.parts.clear();
            this.tempVehicle.load(byteBuffer, 195);
            if (!(baseVehicle.physics == null || baseVehicle.getDriver() != null && baseVehicle.getDriver().isLocal())) {
                this.tempTransform.setRotation(this.tempVehicle.savedRot);
                this.tempTransform.origin.set(f - WorldSimulation.instance.offsetX, f3, f2 - WorldSimulation.instance.offsetY);
                baseVehicle.setWorldTransform(this.tempTransform);
            }
            baseVehicle.netPlayerFromServerUpdate(authorization, s2);
            this.clientUpdateVehiclePos(baseVehicle, f, f2, f3, isoGridSquare);
        } else {
            boolean bl = byteBuffer.get() != 0;
            byte by = byteBuffer.get();
            if (!bl || by != IsoObject.getFactoryVehicle().getClassID()) {
                DebugLog.Vehicle.error("clientReceiveUpdateFull: packet broken");
            }
            BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
            baseVehicle.VehicleID = s;
            baseVehicle.square = isoGridSquare;
            baseVehicle.setCurrent(isoGridSquare);
            baseVehicle.load(byteBuffer, 195);
            if (isoGridSquare != null) {
                baseVehicle.chunk = baseVehicle.square.chunk;
                baseVehicle.chunk.vehicles.add(baseVehicle);
                baseVehicle.addToWorld();
            }
            IsoChunk.addFromCheckedVehicles(baseVehicle);
            baseVehicle.netPlayerFromServerUpdate(authorization, s2);
            this.registerVehicle(baseVehicle);
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.isDead() || isoPlayer.getVehicle() != null) continue;
                IsoWorld.instance.CurrentCell.putInVehicle(isoPlayer);
            }
            DebugLog.Vehicle.trace("added vehicle id=%d %s", baseVehicle.VehicleID, isoGridSquare == null ? " (delayed)" : "");
        }
    }

    private void clientReceiveUpdate(ByteBuffer byteBuffer) throws IOException {
        boolean bl;
        int n;
        short s = byteBuffer.getShort();
        DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get((byte)5), s);
        short s2 = byteBuffer.getShort();
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        short s3 = byteBuffer.getShort();
        VehicleCache.vehicleUpdate(s, f, f2, 0.0f);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, 0.0);
        BaseVehicle baseVehicle = this.IDToVehicle.get(s);
        if (baseVehicle == null && isoGridSquare == null) {
            if (byteBuffer.limit() > byteBuffer.position() + s3) {
                byteBuffer.position(byteBuffer.position() + s3);
            }
            return;
        }
        if (baseVehicle != null && isoGridSquare == null) {
            boolean bl2 = true;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.getVehicle() != baseVehicle) continue;
                bl2 = false;
                isoPlayer.setPosition(f, f2, 0.0f);
                this.sendRequestGetPosition(s, PacketTypes.PacketType.VehiclesUnreliable);
            }
            if (bl2) {
                baseVehicle.removeFromWorld();
                baseVehicle.removeFromSquare();
            }
            if (byteBuffer.limit() > byteBuffer.position() + s3) {
                byteBuffer.position(byteBuffer.position() + s3);
            }
            return;
        }
        if ((s2 & 1) != 0) {
            int n2;
            DebugLog.Vehicle.trace("Vehicle vid=%d full update received", s);
            this.clientReceiveUpdateFull(byteBuffer, s, f, f2, f3);
            if (baseVehicle == null) {
                baseVehicle = this.IDToVehicle.get(s);
            }
            if (!baseVehicle.isKeyboardControlled() && baseVehicle.getJoypad() == -1) {
                byteBuffer.getLong();
                n2 = 0;
                float[] fArray = this.tempFloats;
                fArray[n2++] = f;
                fArray[n2++] = f2;
                fArray[n2++] = f3;
                while (n2 < 10) {
                    fArray[n2++] = byteBuffer.getFloat();
                }
                float f4 = byteBuffer.getFloat();
                float f5 = byteBuffer.getFloat();
                int n3 = byteBuffer.getShort();
                fArray[n2++] = n3;
                for (int i = 0; i < n3; ++i) {
                    fArray[n2++] = byteBuffer.getFloat();
                    fArray[n2++] = byteBuffer.getFloat();
                    fArray[n2++] = byteBuffer.getFloat();
                    fArray[n2++] = byteBuffer.getFloat();
                }
                Bullet.setOwnVehiclePhysics(s, fArray);
            } else if (byteBuffer.limit() > byteBuffer.position() + 102) {
                byteBuffer.position(byteBuffer.position() + 102);
            }
            n2 = this.vehiclesWaitUpdates.indexOf(s);
            if (n2 >= 0) {
                this.vehiclesWaitUpdates.removeAt(n2);
            }
            return;
        }
        if (baseVehicle == null && isoGridSquare != null) {
            this.sendRequestGetFull(s, PacketTypes.PacketType.Vehicles);
            if (byteBuffer.limit() > byteBuffer.position() + s3) {
                byteBuffer.position(byteBuffer.position() + s3);
            }
            return;
        }
        if ((s2 & 2) != 0) {
            if (!baseVehicle.isKeyboardControlled() && baseVehicle.getJoypad() == -1) {
                baseVehicle.interpolation.interpolationDataAdd(byteBuffer, byteBuffer.getLong(), f, f2, f3, GameTime.getServerTimeMills());
            } else if (byteBuffer.limit() > byteBuffer.position() + 102) {
                byteBuffer.position(byteBuffer.position() + 102);
            }
        }
        if ((s2 & 4) != 0) {
            DebugLog.Vehicle.trace("received update Engine id=%d", s);
            n = byteBuffer.get();
            if (n >= 0 && n < BaseVehicle.engineStateTypes.Values.length) {
                switch (BaseVehicle.engineStateTypes.Values[n]) {
                    case Idle: {
                        baseVehicle.engineDoIdle();
                        break;
                    }
                    case Starting: {
                        break;
                    }
                    case RetryingStarting: {
                        baseVehicle.engineDoRetryingStarting();
                        break;
                    }
                    case StartingSuccess: {
                        baseVehicle.engineDoStartingSuccess();
                        break;
                    }
                    case StartingFailed: {
                        baseVehicle.engineDoStartingFailed();
                        break;
                    }
                    case StartingFailedNoPower: {
                        baseVehicle.engineDoStartingFailedNoPower();
                        break;
                    }
                    case Running: {
                        baseVehicle.engineDoRunning();
                        break;
                    }
                    case Stalling: {
                        baseVehicle.engineDoStalling();
                        break;
                    }
                    case ShutingDown: {
                        baseVehicle.engineDoShuttingDown();
                    }
                }
                baseVehicle.engineLoudness = byteBuffer.getInt();
                baseVehicle.enginePower = byteBuffer.getInt();
                baseVehicle.engineQuality = byteBuffer.getInt();
            } else {
                DebugLog.Vehicle.error("VehicleManager.clientReceiveUpdate get invalid data");
            }
        }
        if ((s2 & 0x1000) != 0) {
            DebugLog.Vehicle.trace("received car properties update id=%d", s);
            baseVehicle.setHotwired(byteBuffer.get() == 1);
            baseVehicle.setHotwiredBroken(byteBuffer.get() == 1);
            baseVehicle.setRegulatorSpeed(byteBuffer.getFloat());
            baseVehicle.setPreviouslyEntered(byteBuffer.get() == 1);
            n = byteBuffer.get() == 1 ? 1 : 0;
            bl = byteBuffer.get() == 1;
            InventoryItem inventoryItem = null;
            if (byteBuffer.get() == 1) {
                try {
                    inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            baseVehicle.syncKeyInIgnition(n != 0, bl, inventoryItem);
            baseVehicle.setRust(byteBuffer.getFloat());
            baseVehicle.setBloodIntensity("Front", byteBuffer.getFloat());
            baseVehicle.setBloodIntensity("Rear", byteBuffer.getFloat());
            baseVehicle.setBloodIntensity("Left", byteBuffer.getFloat());
            baseVehicle.setBloodIntensity("Right", byteBuffer.getFloat());
            baseVehicle.setColorHSV(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat());
            baseVehicle.setSkinIndex(byteBuffer.getInt());
            baseVehicle.updateSkin();
        }
        if ((s2 & 8) != 0) {
            DebugLog.Vehicle.trace("received update Lights id=%d", s);
            baseVehicle.setHeadlightsOn(byteBuffer.get() == 1);
            baseVehicle.setStoplightsOn(byteBuffer.get() == 1);
            for (n = 0; n < baseVehicle.getLightCount(); ++n) {
                bl = byteBuffer.get() == 1;
                baseVehicle.getLightByIndex(n).getLight().setActive(bl);
            }
        }
        if ((s2 & 0x400) != 0) {
            DebugLog.Vehicle.trace("received update Sounds id=%d", s);
            n = byteBuffer.get() == 1 ? 1 : 0;
            bl = byteBuffer.get() == 1;
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            if (n != baseVehicle.soundHornOn) {
                if (n != 0) {
                    baseVehicle.onHornStart();
                } else {
                    baseVehicle.onHornStop();
                }
            }
            if (bl != baseVehicle.soundBackMoveOn) {
                if (bl) {
                    baseVehicle.onBackMoveSignalStart();
                } else {
                    baseVehicle.onBackMoveSignalStop();
                }
            }
            if (baseVehicle.lightbarLightsMode.get() != by) {
                baseVehicle.setLightbarLightsMode(by);
            }
            if (baseVehicle.lightbarSirenMode.get() != by2) {
                baseVehicle.setLightbarSirenMode(by2);
            }
        }
        if ((s2 & 0x800) != 0) {
            n = byteBuffer.get();
            while (n != -1) {
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(n);
                DebugLog.Vehicle.trace("received update PartCondition id=%d part=%s", s, vehiclePart.getId());
                vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x800);
                vehiclePart.setCondition(byteBuffer.getInt());
                n = byteBuffer.get();
            }
            baseVehicle.doDamageOverlay();
        }
        if ((s2 & 0x10) != 0) {
            n = byteBuffer.get();
            while (n != -1) {
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(n);
                DebugLog.Vehicle.trace("received update PartModData id=%d part=%s", s, vehiclePart.getId());
                vehiclePart.getModData().load(byteBuffer, 195);
                if (vehiclePart.isContainer()) {
                    vehiclePart.setContainerContentAmount(vehiclePart.getContainerContentAmount());
                }
                n = byteBuffer.get();
            }
        }
        if ((s2 & 0x20) != 0) {
            n = byteBuffer.get();
            while (n != -1) {
                float f6 = byteBuffer.getFloat();
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(n);
                DebugLog.Vehicle.trace("received update PartUsedDelta id=%d part=%s", s, vehiclePart.getId());
                InventoryItem inventoryItem = vehiclePart.getInventoryItem();
                if (inventoryItem instanceof DrainableComboItem) {
                    ((DrainableComboItem)inventoryItem).setUsedDelta(f6);
                }
                n = byteBuffer.get();
            }
        }
        if ((s2 & 0x80) != 0) {
            n = byteBuffer.get();
            while (n != -1) {
                boolean bl3;
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(n);
                DebugLog.Vehicle.trace("received update PartItem id=%d part=%s", s, vehiclePart.getId());
                vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x80);
                boolean bl4 = bl3 = byteBuffer.get() != 0;
                if (bl3) {
                    InventoryItem inventoryItem;
                    try {
                        inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    if (inventoryItem != null) {
                        vehiclePart.setInventoryItem(inventoryItem);
                    }
                } else {
                    vehiclePart.setInventoryItem(null);
                }
                int n4 = vehiclePart.getWheelIndex();
                if (n4 != -1) {
                    baseVehicle.setTireRemoved(n4, !bl3);
                }
                if (vehiclePart.isContainer()) {
                    LuaEventManager.triggerEvent("OnContainerUpdate");
                }
                n = byteBuffer.get();
            }
        }
        if ((s2 & 0x200) != 0) {
            n = byteBuffer.get();
            while (n != -1) {
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(n);
                DebugLog.Vehicle.trace("received update PartDoor id=%d part=%s", s, vehiclePart.getId());
                vehiclePart.getDoor().load(byteBuffer, 195);
                n = byteBuffer.get();
            }
            LuaEventManager.triggerEvent("OnContainerUpdate");
            baseVehicle.doDamageOverlay();
        }
        if ((s2 & 0x100) != 0) {
            n = byteBuffer.get();
            while (n != -1) {
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(n);
                DebugLog.Vehicle.trace("received update PartWindow id=%d part=%s", s, vehiclePart.getId());
                vehiclePart.getWindow().load(byteBuffer, 195);
                n = byteBuffer.get();
            }
            baseVehicle.doDamageOverlay();
        }
        if ((s2 & 0x40) != 0) {
            int n5;
            this.oldModels.clear();
            this.oldModels.addAll(baseVehicle.models);
            this.curModels.clear();
            n = byteBuffer.get();
            for (n5 = 0; n5 < n; ++n5) {
                byte by = byteBuffer.get();
                byte by3 = byteBuffer.get();
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(by);
                VehicleScript.Model model = vehiclePart.getScriptPart().models.get(by3);
                BaseVehicle.ModelInfo modelInfo = baseVehicle.setModelVisible(vehiclePart, model, true);
                this.curModels.add(modelInfo);
            }
            for (n5 = 0; n5 < this.oldModels.size(); ++n5) {
                BaseVehicle.ModelInfo modelInfo = this.oldModels.get(n5);
                if (this.curModels.contains(modelInfo)) continue;
                baseVehicle.setModelVisible(modelInfo.part, modelInfo.scriptModel, false);
            }
            baseVehicle.doDamageOverlay();
        }
        n = 0;
        for (int i = 0; i < baseVehicle.getPartCount(); ++i) {
            VehiclePart vehiclePart = baseVehicle.getPartByIndex(i);
            if (vehiclePart.updateFlags == 0) continue;
            if ((vehiclePart.updateFlags & 0x800) != 0 && (vehiclePart.updateFlags & 0x80) == 0) {
                vehiclePart.doInventoryItemStats(vehiclePart.getInventoryItem(), vehiclePart.getMechanicSkillInstaller());
                n = 1;
            }
            vehiclePart.updateFlags = 0;
        }
        if (n != 0) {
            baseVehicle.updatePartStats();
            baseVehicle.updateBulletStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientPacket(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        block2 : switch (by) {
            case 1: {
                IsoGameCharacter isoGameCharacter;
                short s = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s);
                byte by2 = byteBuffer.get();
                String string = GameWindow.ReadString(byteBuffer);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                if (baseVehicle == null || (isoGameCharacter = baseVehicle.getCharacter(by2)) == null) break;
                baseVehicle.setCharacterPosition(isoGameCharacter, by2, string);
                break;
            }
            case 16: {
                short s = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s);
                byte by3 = byteBuffer.get();
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                if (baseVehicle == null) break;
                SoundManager.instance.PlayWorldSound("VehicleCrash", baseVehicle.square, 1.0f, 20.0f, 1.0f, true);
                break;
            }
            case 18: {
                short s = byteBuffer.getShort();
                short s2 = byteBuffer.getShort();
                DebugLog.Vehicle.trace("Vehicle detach A=%d B=%d", s, s2);
                if (this.towedVehicleMap.containsKey(s)) {
                    this.towedVehicleMap.remove(s);
                }
                if (this.towedVehicleMap.containsKey(s2)) {
                    this.towedVehicleMap.remove(s2);
                }
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                BaseVehicle baseVehicle2 = this.IDToVehicle.get(s2);
                if (baseVehicle != null) {
                    baseVehicle.breakConstraint(true, true);
                }
                if (baseVehicle2 == null) break;
                baseVehicle2.breakConstraint(true, true);
                break;
            }
            case 17: {
                short s = byteBuffer.getShort();
                short s3 = byteBuffer.getShort();
                String string = GameWindow.ReadString(byteBuffer);
                String string2 = GameWindow.ReadString(byteBuffer);
                DebugLog.Vehicle.trace("Vehicle attach A=%d/%s B=%d/%s", s, string, s3, string2);
                this.towedVehicleMap.put(s, s3);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                BaseVehicle baseVehicle3 = this.IDToVehicle.get(s3);
                if (baseVehicle == null || baseVehicle3 == null) break;
                baseVehicle.addPointConstraint(null, baseVehicle3, string, string2);
                break;
            }
            case 5: {
                if (this.tempVehicle == null || this.tempVehicle.getCell() != IsoWorld.instance.CurrentCell) {
                    this.tempVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                }
                int n = byteBuffer.getShort();
                for (int i = 0; i < n; ++i) {
                    try {
                        this.clientReceiveUpdate(byteBuffer);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break block2;
                    }
                }
                break;
            }
            case 8: {
                short s = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s);
                if (this.IDToVehicle.containsKey(s)) {
                    BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                    baseVehicle.serverRemovedFromWorld = true;
                    try {
                        baseVehicle.removeFromWorld();
                        baseVehicle.removeFromSquare();
                    }
                    finally {
                        if (this.IDToVehicle.containsKey(s)) {
                            this.unregisterVehicle(baseVehicle);
                        }
                    }
                }
                VehicleCache.remove(s);
                break;
            }
            case 2: {
                short s = byteBuffer.getShort();
                short s4 = byteBuffer.getShort();
                byte by4 = byteBuffer.get();
                DebugLog.Vehicle.trace("Vehicle enter vid=%d pid=%d seat=%d", s, s4, by4);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                if (baseVehicle == null) {
                    DebugLog.Vehicle.warn("Vehicle vid=%d not found", s);
                    break;
                }
                IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(s4);
                if (isoPlayer == null) {
                    DebugLog.Vehicle.warn("Player pid=%d not found", s4);
                    break;
                }
                IsoPlayer isoPlayer2 = Type.tryCastTo(baseVehicle.getCharacter(by4), IsoPlayer.class);
                if (isoPlayer2 != null && isoPlayer2 != isoPlayer) {
                    DebugLog.Vehicle.warn(isoPlayer.getUsername() + " got in same seat as " + isoPlayer2.getUsername());
                    break;
                }
                baseVehicle.enterRSync(by4, isoPlayer, baseVehicle);
                break;
            }
            case 3: {
                short s = byteBuffer.getShort();
                short s5 = byteBuffer.getShort();
                byte by5 = byteBuffer.get();
                DebugLog.Vehicle.trace("Vehicle exit vid=%d pid=%d seat=%d", s, s5, by5);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                if (baseVehicle == null) {
                    DebugLog.Vehicle.warn("Vehicle vid=%d not found", s);
                    break;
                }
                IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(s5);
                if (isoPlayer == null) {
                    DebugLog.Vehicle.warn("Player pid=%d not found", s5);
                    break;
                }
                baseVehicle.exitRSync(isoPlayer);
                break;
            }
            case 4: {
                short s = byteBuffer.getShort();
                short s6 = byteBuffer.getShort();
                byte by6 = byteBuffer.get();
                byte by7 = byteBuffer.get();
                DebugLog.Vehicle.trace("Vehicle switch seat vid=%d pid=%d seats=%d=>%d", s, s6, by6, by7);
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                if (baseVehicle == null) {
                    DebugLog.Vehicle.warn("Vehicle vid=%d not found", s);
                    break;
                }
                IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(s6);
                if (isoPlayer == null) {
                    DebugLog.Vehicle.warn("Player pid=%d not found", s6);
                    break;
                }
                IsoPlayer isoPlayer3 = Type.tryCastTo(baseVehicle.getCharacter(by7), IsoPlayer.class);
                if (isoPlayer3 != null && isoPlayer3 != isoPlayer) {
                    DebugLog.Vehicle.warn(isoPlayer.getUsername() + " switched to same seat as " + isoPlayer3.getUsername());
                    break;
                }
                baseVehicle.switchSeat(isoPlayer, by7);
                break;
            }
            case 13: {
                short s = byteBuffer.getShort();
                DebugLog.Vehicle.trace("%s vid=%d", vehiclePacketTypes.get(by), s);
                Vector3f vector3f = new Vector3f();
                Vector3f vector3f2 = new Vector3f();
                vector3f.x = byteBuffer.getFloat();
                vector3f.y = byteBuffer.getFloat();
                vector3f.z = byteBuffer.getFloat();
                vector3f2.x = byteBuffer.getFloat();
                vector3f2.y = byteBuffer.getFloat();
                vector3f2.z = byteBuffer.getFloat();
                BaseVehicle baseVehicle = this.IDToVehicle.get(s);
                if (baseVehicle == null) break;
                Bullet.applyCentralForceToVehicle(baseVehicle.VehicleID, vector3f.x, vector3f.y, vector3f.z);
                Vector3f vector3f3 = vector3f2.cross((Vector3fc)vector3f);
                Bullet.applyTorqueToVehicle(baseVehicle.VehicleID, vector3f3.x, vector3f3.y, vector3f3.z);
                break;
            }
            case 19: {
                int n = byteBuffer.getShort();
                for (int i = 0; i < n; ++i) {
                    short s = byteBuffer.getShort();
                    short s7 = byteBuffer.getShort();
                    this.towedVehicleMap.put(s, s7);
                }
                break;
            }
            case 9: {
                Physics physics = new Physics();
                physics.parse(byteBuffer, GameClient.connection);
                physics.process();
                break;
            }
            default: {
                DebugLog.Vehicle.warn("Unknown vehicle packet %d", by);
            }
        }
    }

    public void sendCollide(BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, boolean bl) {
        short s = isoGameCharacter == null ? (short)-1 : (short)((IsoPlayer)isoGameCharacter).OnlineID;
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)15);
        byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
        byteBufferWriter.bb.putShort(s);
        byteBufferWriter.bb.put((byte)(bl ? 1 : 0));
        PacketTypes.PacketType.Vehicles.send(GameClient.connection);
        DebugLog.Vehicle.trace("vid=%d pid=%d collide=%b", baseVehicle.VehicleID, s, bl);
    }

    public static void sendSound(BaseVehicle baseVehicle, byte by) {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)16);
        byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
        byteBufferWriter.bb.put(by);
        PacketTypes.PacketType.Vehicles.send(GameClient.connection);
    }

    public static void sendSoundFromServer(BaseVehicle baseVehicle, byte by) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)16);
            byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
            byteBufferWriter.bb.put(by);
            PacketTypes.PacketType.Vehicles.send(udpConnection);
        }
    }

    public void sendPassengerPosition(BaseVehicle baseVehicle, int n, String string) {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)1);
        byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
        byteBufferWriter.bb.put((byte)n);
        byteBufferWriter.putUTF(string);
        PacketTypes.PacketType.Vehicles.send(GameClient.connection);
    }

    public void sendPassengerPosition(BaseVehicle baseVehicle, int n, String string, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2 == udpConnection) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)1);
            byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
            byteBufferWriter.bb.put((byte)n);
            byteBufferWriter.putUTF(string);
            PacketTypes.PacketType.Vehicles.send(udpConnection2);
        }
    }

    public void sendRequestGetFull(short s, PacketTypes.PacketType packetType) {
        if (!this.vehiclesWaitUpdates.contains(s)) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)11);
            byteBufferWriter.bb.putShort((short)1);
            byteBufferWriter.bb.putShort(s);
            PacketTypes.PacketType.Vehicles.send(GameClient.connection);
            this.vehiclesWaitUpdates.add(s);
        }
    }

    public void sendRequestGetFull(List<VehicleCache> list) {
        if (list != null && !list.isEmpty()) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)11);
            byteBufferWriter.bb.putShort((short)list.size());
            for (int i = 0; i < list.size(); ++i) {
                byteBufferWriter.bb.putShort(list.get((int)i).id);
                this.vehiclesWaitUpdates.add(list.get((int)i).id);
            }
            PacketTypes.PacketType.Vehicles.send(GameClient.connection);
        }
    }

    public void sendRequestGetPosition(short s, PacketTypes.PacketType packetType) {
        if (this.sendRequestGetPositionFrequency.Check()) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            packetType.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)12);
            byteBufferWriter.bb.putShort(s);
            packetType.send(GameClient.connection);
            this.vehiclesWaitUpdates.add(s);
        }
    }

    public void sendAddImpulse(BaseVehicle baseVehicle, Vector3f vector3f, Vector3f vector3f2) {
        UdpConnection udpConnection = null;
        block0: for (int i = 0; i < GameServer.udpEngine.connections.size() && udpConnection == null; ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < udpConnection2.players.length; ++j) {
                IsoPlayer isoPlayer = udpConnection2.players[j];
                if (isoPlayer == null || isoPlayer.getVehicle() == null || isoPlayer.getVehicle().VehicleID != baseVehicle.VehicleID) continue;
                udpConnection = udpConnection2;
                continue block0;
            }
        }
        if (udpConnection != null) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)13);
            byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
            byteBufferWriter.bb.putFloat(vector3f.x);
            byteBufferWriter.bb.putFloat(vector3f.y);
            byteBufferWriter.bb.putFloat(vector3f.z);
            byteBufferWriter.bb.putFloat(vector3f2.x);
            byteBufferWriter.bb.putFloat(vector3f2.y);
            byteBufferWriter.bb.putFloat(vector3f2.z);
            PacketTypes.PacketType.Vehicles.send(udpConnection);
        }
    }

    public void sendSwitchSeat(UdpConnection udpConnection, BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, int n, int n2) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)4);
        byteBufferWriter.bb.putShort(baseVehicle.getId());
        byteBufferWriter.bb.putShort(isoGameCharacter.getOnlineID());
        byteBufferWriter.bb.put((byte)n);
        byteBufferWriter.bb.put((byte)n2);
        PacketTypes.PacketType.Vehicles.send(udpConnection);
    }

    public void sendSwitchSeat(BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, int n, int n2) {
        for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
            this.sendSwitchSeat(udpConnection, baseVehicle, isoGameCharacter, n, n2);
        }
    }

    public void sendEnter(UdpConnection udpConnection, BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, int n) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)2);
        byteBufferWriter.bb.putShort(baseVehicle.getId());
        byteBufferWriter.bb.putShort(isoGameCharacter.getOnlineID());
        byteBufferWriter.bb.put((byte)n);
        PacketTypes.PacketType.Vehicles.send(udpConnection);
    }

    public void sendEnter(BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, int n) {
        for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
            this.sendEnter(udpConnection, baseVehicle, isoGameCharacter, n);
        }
    }

    public void sendExit(UdpConnection udpConnection, BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, int n) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)3);
        byteBufferWriter.bb.putShort(baseVehicle.getId());
        byteBufferWriter.bb.putShort(isoGameCharacter.getOnlineID());
        byteBufferWriter.bb.put((byte)n);
        PacketTypes.PacketType.Vehicles.send(udpConnection);
    }

    public void sendExit(BaseVehicle baseVehicle, IsoGameCharacter isoGameCharacter, int n) {
        for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
            this.sendExit(udpConnection, baseVehicle, isoGameCharacter, (byte)n);
        }
    }

    public void sendPhysic(BaseVehicle baseVehicle) {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType packetType = baseVehicle.isReliable ? PacketTypes.PacketType.Vehicles : PacketTypes.PacketType.VehiclesUnreliable;
        packetType.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)9);
        Physics physics = new Physics();
        if (physics.set(baseVehicle)) {
            physics.write(byteBufferWriter);
            packetType.send(GameClient.connection);
        } else {
            GameClient.connection.cancelPacket();
        }
    }

    public void sendTowing(UdpConnection udpConnection, BaseVehicle baseVehicle, BaseVehicle baseVehicle2, String string, String string2) {
        DebugLog.Vehicle.trace("vidA=%d vidB=%d", baseVehicle.VehicleID, baseVehicle2.VehicleID);
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)17);
        byteBufferWriter.bb.putShort(baseVehicle.VehicleID);
        byteBufferWriter.bb.putShort(baseVehicle2.VehicleID);
        GameWindow.WriteString(byteBufferWriter.bb, string);
        GameWindow.WriteString(byteBufferWriter.bb, string2);
        PacketTypes.PacketType.Vehicles.send(udpConnection);
    }

    public void sendTowing(BaseVehicle baseVehicle, BaseVehicle baseVehicle2, String string, String string2) {
        if (!this.towedVehicleMap.containsKey(baseVehicle.VehicleID)) {
            this.towedVehicleMap.put(baseVehicle.VehicleID, baseVehicle2.VehicleID);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                this.sendTowing(udpConnection, baseVehicle, baseVehicle2, string, string2);
            }
        }
    }

    public void sendDetachTowing(UdpConnection udpConnection, BaseVehicle baseVehicle, BaseVehicle baseVehicle2) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Vehicles.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)18);
        byteBufferWriter.bb.putShort(baseVehicle == null ? (short)-1 : (short)baseVehicle.VehicleID);
        byteBufferWriter.bb.putShort(baseVehicle2 == null ? (short)-1 : (short)baseVehicle2.VehicleID);
        PacketTypes.PacketType.Vehicles.send(udpConnection);
    }

    public void sendDetachTowing(BaseVehicle baseVehicle, BaseVehicle baseVehicle2) {
        if (baseVehicle != null && this.towedVehicleMap.containsKey(baseVehicle.VehicleID)) {
            this.towedVehicleMap.remove(baseVehicle.VehicleID);
        }
        if (baseVehicle2 != null && this.towedVehicleMap.containsKey(baseVehicle2.VehicleID)) {
            this.towedVehicleMap.remove(baseVehicle2.VehicleID);
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            this.sendDetachTowing(udpConnection, baseVehicle, baseVehicle2);
        }
    }

    public short getTowedVehicleID(short s) {
        if (this.towedVehicleMap.containsKey(s)) {
            return this.towedVehicleMap.get(s);
        }
        return -1;
    }

    private void writePositionOrientation(ByteBuffer byteBuffer, BaseVehicle baseVehicle) {
        byteBuffer.putLong(WorldSimulation.instance.time);
        Quaternionf quaternionf = baseVehicle.savedRot;
        Transform transform = baseVehicle.getWorldTransform(this.tempTransform);
        transform.getRotation(quaternionf);
        byteBuffer.putFloat(quaternionf.x);
        byteBuffer.putFloat(quaternionf.y);
        byteBuffer.putFloat(quaternionf.z);
        byteBuffer.putFloat(quaternionf.w);
        byteBuffer.putFloat(baseVehicle.jniLinearVelocity.x);
        byteBuffer.putFloat(baseVehicle.jniLinearVelocity.y);
        byteBuffer.putFloat(baseVehicle.jniLinearVelocity.z);
        byteBuffer.putFloat((float)baseVehicle.engineSpeed);
        byteBuffer.putFloat(baseVehicle.throttle);
        byteBuffer.putShort((short)baseVehicle.wheelInfo.length);
        for (int i = 0; i < baseVehicle.wheelInfo.length; ++i) {
            byteBuffer.putFloat(baseVehicle.wheelInfo[i].steering);
            byteBuffer.putFloat(baseVehicle.wheelInfo[i].rotation);
            byteBuffer.putFloat(baseVehicle.wheelInfo[i].skidInfo);
            byteBuffer.putFloat(baseVehicle.wheelInfo[i].suspensionLength);
        }
    }

    static {
        vehiclePacketTypes = new HashMap();
        vehiclePacketTypes.put((byte)1, "PassengerPosition");
        vehiclePacketTypes.put((byte)2, "Enter");
        vehiclePacketTypes.put((byte)3, "Exit");
        vehiclePacketTypes.put((byte)4, "SwitchSeat");
        vehiclePacketTypes.put((byte)5, "Update");
        vehiclePacketTypes.put((byte)8, "Remove");
        vehiclePacketTypes.put((byte)9, "Physic");
        vehiclePacketTypes.put((byte)10, "Config");
        vehiclePacketTypes.put((byte)11, "RequestGetFull");
        vehiclePacketTypes.put((byte)12, "RequestGetPosition");
        vehiclePacketTypes.put((byte)13, "AddImpulse");
        vehiclePacketTypes.put((byte)15, "Collide");
        vehiclePacketTypes.put((byte)16, "Sound");
        vehiclePacketTypes.put((byte)17, "TowingCar");
        vehiclePacketTypes.put((byte)18, "DetachTowingCar");
        vehiclePacketTypes.put((byte)19, "InitialWorldState");
    }

    public static final class PosUpdateVars {
        final Transform transform = new Transform();
        final Vector3f vector3f = new Vector3f();
        final Quaternionf quatf = new Quaternionf();
        final float[] wheelSteer = new float[4];
        final float[] wheelRotation = new float[4];
        final float[] wheelSkidInfo = new float[4];
        final float[] wheelSuspensionLength = new float[4];
    }

    public static final class VehiclePacket {
        public static final byte PassengerPosition = 1;
        public static final byte Enter = 2;
        public static final byte Exit = 3;
        public static final byte SwitchSeat = 4;
        public static final byte Update = 5;
        public static final byte Remove = 8;
        public static final byte Physic = 9;
        public static final byte Config = 10;
        public static final byte RequestGetFull = 11;
        public static final byte RequestGetPosition = 12;
        public static final byte AddImpulse = 13;
        public static final byte Collide = 15;
        public static final byte Sound = 16;
        public static final byte TowingCar = 17;
        public static final byte DetachTowingCar = 18;
        public static final byte InitialWorldState = 19;
        public static final byte Sound_Crash = 1;
    }
}

