/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import zombie.vehicles.VehicleInterpolation;
import zombie.vehicles.VehicleInterpolationData;

public class VehicleInterpolationTest
extends Assert {
    final VehicleInterpolation interpolation = new VehicleInterpolation();
    final float[] physics = new float[27];
    final float[] engineSound = new float[2];
    final ByteBuffer bb = ByteBuffer.allocateDirect(255);
    final int tick = 100;
    final int delay = 300;
    final int history = 200;
    final int bufferingIterations = 4;
    @Rule
    public TestRule watchman = new TestWatcher(){

        protected void failed(Throwable throwable, Description description) {
            System.out.println("interpolation.buffer:");
            System.out.print("TIME: ");
            for (VehicleInterpolationData vehicleInterpolationData : VehicleInterpolationTest.this.interpolation.buffer) {
                System.out.print(String.format(" %5d", vehicleInterpolationData.time));
            }
            System.out.println();
            System.out.print("   X: ");
            for (VehicleInterpolationData vehicleInterpolationData : VehicleInterpolationTest.this.interpolation.buffer) {
                System.out.print(String.format(" %5.0f", Float.valueOf(vehicleInterpolationData.x)));
            }
        }
    };

    @Before
    public void setup() {
        this.interpolation.clear();
        this.interpolation.delay = 300;
        this.interpolation.history = 500;
        this.interpolation.reset();
    }

    @Test
    public void normalTest() {
        long l = 9223372036853775807L;
        for (int i = 1; i < 30; ++i) {
            this.bb.position(0);
            this.interpolation.interpolationDataAdd(this.bb, l, i * 2, i * 2, 0.0f, l);
            boolean bl = this.interpolation.interpolationDataGet(this.physics, this.engineSound, l - 298L);
            if (i < 4) {
                VehicleInterpolationTest.assertFalse((boolean)bl);
            } else {
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)((float)(i - 4 + 1) * 2.0f), (float)this.physics[0], (float)0.2f);
            }
            boolean bl2 = this.interpolation.interpolationDataGet(this.physics, this.engineSound, l - 298L + 50L);
            if (i < 4) {
                VehicleInterpolationTest.assertFalse((boolean)bl);
            } else {
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)((float)(i - 4 + 1) * 2.0f + 1.0f), (float)this.physics[0], (float)0.2f);
            }
            l += 100L;
        }
    }

    @Test
    public void interpolationTest() {
        int n = 0;
        for (int i = 1; i < 30; ++i) {
            this.bb.position(0);
            if (i % 2 == 1) {
                this.interpolation.interpolationDataAdd(this.bb, n, i, i, 0.0f, n);
            }
            boolean bl = this.interpolation.interpolationDataGet(this.physics, this.engineSound, n - 298);
            if (i < 4) {
                VehicleInterpolationTest.assertFalse((boolean)bl);
            } else {
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)(i - 4 + 1), (float)this.physics[0], (float)0.2f);
            }
            n += 100;
        }
    }

    @Test
    public void interpolationMicroStepTest() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < 30; ++n2) {
            this.bb.position(0);
            this.interpolation.interpolationDataAdd(this.bb, n3, n2, n2, 0.0f, n3);
            n = this.interpolation.interpolationDataGet(this.physics, this.engineSound, n3 - 298) ? 1 : 0;
            if (n2 < 4) {
                VehicleInterpolationTest.assertFalse(n != 0);
            } else {
                VehicleInterpolationTest.assertTrue(n != 0);
                VehicleInterpolationTest.assertEquals((float)(n2 - 4 + 1), (float)this.physics[0], (float)0.2f);
            }
            n3 += 100;
        }
        for (n2 = 30; n2 < 35; ++n2) {
            this.interpolation.interpolationDataAdd(this.bb, n3, n2, n2, 0.0f, n3);
            for (n = 0; n < 100; ++n) {
                boolean bl = this.interpolation.interpolationDataGet(this.physics, this.engineSound, n3 - 300 + 100 * n / 100);
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)((float)(n2 - 4 + 1) + (float)n / 100.0f), (float)this.physics[0], (float)0.001f);
            }
            n3 += 100;
        }
    }

    @Test
    public void interpolationMicroStepTest2() {
        int n;
        int n2;
        long l = 0L;
        int n3 = 50;
        for (n2 = 1; n2 < 30; ++n2) {
            this.bb.position(0);
            this.interpolation.interpolationDataAdd(this.bb, l, n2, n2, 0.0f, l);
            n = this.interpolation.interpolationDataGet(this.physics, this.engineSound, l - 298L) ? 1 : 0;
            System.out.println(n2 + "   " + l + " " + (n != 0) + " " + this.physics[0]);
            l += (long)n3;
        }
        for (n2 = 30; n2 < 35; ++n2) {
            this.interpolation.interpolationDataAdd(this.bb, l, n2, n2, 0.0f, l);
            for (n = 0; n < 10; ++n) {
                boolean bl = this.interpolation.interpolationDataGet(this.physics, this.engineSound, l - 300L + (long)(n3 * n / 10));
                System.out.println(n2 + "." + n + " " + (l + (long)(n3 * n / 10)) + " " + bl + " " + this.physics[0] + " " + ((float)n2 - 6.0f + (float)n / 10.0f));
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)((float)n2 - 6.0f + (float)n / 10.0f), (float)this.physics[0], (float)0.001f);
            }
            l += (long)n3;
        }
    }

    @Test
    public void testBufferRestoring() {
        int n = 0;
        for (int i = 1; i < 30; ++i) {
            this.bb.position(0);
            this.interpolation.interpolationDataAdd(this.bb, n, i, i, 0.0f, n);
            boolean bl = this.interpolation.interpolationDataGet(this.physics, this.engineSound, n - 298);
            System.out.println(i + " " + n + " " + bl + " " + this.physics[0]);
            if (i >= 4 && (i <= 10 || i >= 14)) {
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)(i - 4 + 1), (float)this.physics[0], (float)0.2f);
            }
            if (i == 10) {
                n += 500;
            }
            n += 100;
        }
    }

    @Test
    public void normalTestBufferRestoring2() {
        int n = 0;
        for (int i = 1; i < 100; ++i) {
            boolean bl;
            this.bb.position(0);
            boolean bl2 = bl = i < 15 || i > 21;
            if (bl) {
                this.interpolation.interpolationDataAdd(this.bb, n, i, 0.0f, 0.0f, n);
            }
            boolean bl3 = this.interpolation.interpolationDataGet(this.physics, this.engineSound, n - 298);
            System.out.println(i + " " + bl3 + " " + this.physics[0]);
            if (i < 4 || i > 17 && i < 25) {
                VehicleInterpolationTest.assertFalse((boolean)bl3);
            } else {
                VehicleInterpolationTest.assertTrue((boolean)bl3);
                if (i < 17 || i > 21) {
                    VehicleInterpolationTest.assertEquals((float)(i - 4 + 1), (float)this.physics[0], (float)0.1f);
                } else {
                    VehicleInterpolationTest.assertEquals((float)14.0f, (float)this.physics[0], (float)0.1f);
                }
            }
            n += 100;
        }
    }

    @Test
    public void normalTestBufferRestoring3() {
        int n = 0;
        for (int i = 1; i < 40; ++i) {
            this.bb.position(0);
            if (i != 10 && i != 12 && i != 13 && i != 15 && i != 16) {
                this.interpolation.interpolationDataAdd(this.bb, n, i, 0.0f, 0.0f, n);
            }
            if (i > 26 && i < 33) {
                this.interpolation.interpolationDataAdd(this.bb, n + 50, (float)i + 0.5f, 0.0f, 0.0f, n);
            }
            boolean bl = this.interpolation.interpolationDataGet(this.physics, this.engineSound, n - 298);
            System.out.println(i + " " + bl + " " + this.physics[0]);
            if (i < 4) {
                VehicleInterpolationTest.assertFalse((boolean)bl);
            } else {
                VehicleInterpolationTest.assertTrue((boolean)bl);
                VehicleInterpolationTest.assertEquals((float)(i - 4 + 1), (float)this.physics[0], (float)0.1f);
            }
            n += 100;
        }
    }
}

