/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import zombie.GameTime;
import zombie.core.physics.WorldSimulation;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleInterpolationData;

public class VehicleInterpolation {
    int delay;
    int history;
    boolean buffering;
    private static final ArrayDeque<VehicleInterpolationData> pool = new ArrayDeque();
    private static final List<VehicleInterpolationData> outdated = new ArrayList<VehicleInterpolationData>();
    TreeSet<VehicleInterpolationData> buffer = new TreeSet();
    private static final Quaternionf tempQuaternionA = new Quaternionf();
    private static final Quaternionf tempQuaternionB = new Quaternionf();
    private static final VehicleInterpolationData temp = new VehicleInterpolationData();

    VehicleInterpolation() {
        this.reset();
        this.delay = 500;
        this.history = 800;
    }

    public void reset() {
        this.buffering = true;
        this.clear();
    }

    public void clear() {
        if (!this.buffer.isEmpty()) {
            pool.addAll(this.buffer);
            this.buffer.clear();
            outdated.clear();
        }
    }

    public void update(long l) {
        VehicleInterpolation.temp.time = l - (long)this.delay;
        VehicleInterpolationData vehicleInterpolationData = this.buffer.floor(temp);
        for (VehicleInterpolationData vehicleInterpolationData2 : this.buffer) {
            if (l - vehicleInterpolationData2.time <= (long)this.history || vehicleInterpolationData2 == vehicleInterpolationData) continue;
            outdated.add(vehicleInterpolationData2);
        }
        outdated.forEach(this.buffer::remove);
        pool.addAll(outdated);
        outdated.clear();
        if (this.buffer.isEmpty()) {
            this.buffering = true;
        }
    }

    private void interpolationDataCurrentAdd(BaseVehicle baseVehicle) {
        VehicleInterpolationData vehicleInterpolationData = pool.isEmpty() ? new VehicleInterpolationData() : pool.pop();
        vehicleInterpolationData.time = GameTime.getServerTimeMills() - (long)this.delay;
        vehicleInterpolationData.x = baseVehicle.jniTransform.origin.x + WorldSimulation.instance.offsetX;
        vehicleInterpolationData.y = baseVehicle.jniTransform.origin.z + WorldSimulation.instance.offsetY;
        vehicleInterpolationData.z = baseVehicle.jniTransform.origin.y;
        Quaternionf quaternionf = baseVehicle.jniTransform.getRotation(new Quaternionf());
        vehicleInterpolationData.qx = quaternionf.x;
        vehicleInterpolationData.qy = quaternionf.y;
        vehicleInterpolationData.qz = quaternionf.z;
        vehicleInterpolationData.qw = quaternionf.w;
        vehicleInterpolationData.vx = baseVehicle.jniLinearVelocity.x;
        vehicleInterpolationData.vy = baseVehicle.jniLinearVelocity.y;
        vehicleInterpolationData.vz = baseVehicle.jniLinearVelocity.z;
        vehicleInterpolationData.engineSpeed = (float)baseVehicle.engineSpeed;
        vehicleInterpolationData.throttle = baseVehicle.throttle;
        vehicleInterpolationData.setNumWheels((short)baseVehicle.wheelInfo.length);
        for (int i = 0; i < vehicleInterpolationData.wheelsCount; ++i) {
            vehicleInterpolationData.wheelSteering[i] = baseVehicle.wheelInfo[i].steering;
            vehicleInterpolationData.wheelRotation[i] = baseVehicle.wheelInfo[i].rotation;
            vehicleInterpolationData.wheelSkidInfo[i] = baseVehicle.wheelInfo[i].skidInfo;
            vehicleInterpolationData.wheelSuspensionLength[i] = baseVehicle.wheelInfo[i].suspensionLength;
        }
        this.buffer.add(vehicleInterpolationData);
    }

    public void interpolationDataAdd(BaseVehicle baseVehicle, VehicleInterpolationData vehicleInterpolationData) {
        VehicleInterpolationData vehicleInterpolationData2 = pool.isEmpty() ? new VehicleInterpolationData() : pool.pop();
        vehicleInterpolationData2.copy(vehicleInterpolationData);
        if (this.buffer.isEmpty()) {
            this.interpolationDataCurrentAdd(baseVehicle);
        }
        this.buffer.add(vehicleInterpolationData2);
        this.update(GameTime.getServerTimeMills());
    }

    public void interpolationDataAdd(ByteBuffer byteBuffer, long l, float f, float f2, float f3, long l2) {
        VehicleInterpolationData vehicleInterpolationData = pool.isEmpty() ? new VehicleInterpolationData() : pool.pop();
        vehicleInterpolationData.time = l;
        vehicleInterpolationData.x = f;
        vehicleInterpolationData.y = f2;
        vehicleInterpolationData.z = f3;
        vehicleInterpolationData.qx = byteBuffer.getFloat();
        vehicleInterpolationData.qy = byteBuffer.getFloat();
        vehicleInterpolationData.qz = byteBuffer.getFloat();
        vehicleInterpolationData.qw = byteBuffer.getFloat();
        vehicleInterpolationData.vx = byteBuffer.getFloat();
        vehicleInterpolationData.vy = byteBuffer.getFloat();
        vehicleInterpolationData.vz = byteBuffer.getFloat();
        vehicleInterpolationData.engineSpeed = byteBuffer.getFloat();
        vehicleInterpolationData.throttle = byteBuffer.getFloat();
        vehicleInterpolationData.setNumWheels(byteBuffer.getShort());
        for (int i = 0; i < vehicleInterpolationData.wheelsCount; ++i) {
            vehicleInterpolationData.wheelSteering[i] = byteBuffer.getFloat();
            vehicleInterpolationData.wheelRotation[i] = byteBuffer.getFloat();
            vehicleInterpolationData.wheelSkidInfo[i] = byteBuffer.getFloat();
            vehicleInterpolationData.wheelSuspensionLength[i] = byteBuffer.getFloat();
        }
        this.buffer.add(vehicleInterpolationData);
        this.update(l2);
    }

    public boolean interpolationDataGet(float[] fArray, float[] fArray2) {
        long l = WorldSimulation.instance.time - (long)this.delay;
        return this.interpolationDataGet(fArray, fArray2, l);
    }

    public boolean interpolationDataGet(float[] fArray, float[] fArray2, long l) {
        VehicleInterpolation.temp.time = l;
        VehicleInterpolationData vehicleInterpolationData = this.buffer.higher(temp);
        VehicleInterpolationData vehicleInterpolationData2 = this.buffer.floor(temp);
        if (this.buffering) {
            if (this.buffer.size() < 2 || vehicleInterpolationData == null || vehicleInterpolationData2 == null) {
                return false;
            }
            this.buffering = false;
        } else if (this.buffer.isEmpty()) {
            this.reset();
            return false;
        }
        int n = 0;
        if (vehicleInterpolationData == null) {
            if (vehicleInterpolationData2 != null) {
                fArray2[0] = vehicleInterpolationData2.engineSpeed;
                fArray2[1] = vehicleInterpolationData2.throttle;
                fArray[n++] = vehicleInterpolationData2.x;
                fArray[n++] = vehicleInterpolationData2.y;
                fArray[n++] = vehicleInterpolationData2.z;
                fArray[n++] = vehicleInterpolationData2.qx;
                fArray[n++] = vehicleInterpolationData2.qy;
                fArray[n++] = vehicleInterpolationData2.qz;
                fArray[n++] = vehicleInterpolationData2.qw;
                fArray[n++] = vehicleInterpolationData2.vx;
                fArray[n++] = vehicleInterpolationData2.vy;
                fArray[n++] = vehicleInterpolationData2.vz;
                fArray[n++] = vehicleInterpolationData2.wheelsCount;
                for (int i = 0; i < vehicleInterpolationData2.wheelsCount; ++i) {
                    fArray[n++] = vehicleInterpolationData2.wheelSteering[i];
                    fArray[n++] = vehicleInterpolationData2.wheelRotation[i];
                    fArray[n++] = vehicleInterpolationData2.wheelSkidInfo[i];
                    fArray[n++] = vehicleInterpolationData2.wheelSuspensionLength[i];
                }
                this.reset();
                return true;
            }
            this.reset();
            return false;
        }
        if (vehicleInterpolationData2 == null || Math.abs(vehicleInterpolationData.time - vehicleInterpolationData2.time) < 10L) {
            return false;
        }
        float f = (float)(l - vehicleInterpolationData2.time) / (float)(vehicleInterpolationData.time - vehicleInterpolationData2.time);
        fArray2[0] = (vehicleInterpolationData.engineSpeed - vehicleInterpolationData2.engineSpeed) * f + vehicleInterpolationData2.engineSpeed;
        fArray2[1] = (vehicleInterpolationData.throttle - vehicleInterpolationData2.throttle) * f + vehicleInterpolationData2.throttle;
        fArray[n++] = (vehicleInterpolationData.x - vehicleInterpolationData2.x) * f + vehicleInterpolationData2.x;
        fArray[n++] = (vehicleInterpolationData.y - vehicleInterpolationData2.y) * f + vehicleInterpolationData2.y;
        fArray[n++] = (vehicleInterpolationData.z - vehicleInterpolationData2.z) * f + vehicleInterpolationData2.z;
        tempQuaternionA.set(vehicleInterpolationData2.qx, vehicleInterpolationData2.qy, vehicleInterpolationData2.qz, vehicleInterpolationData2.qw);
        tempQuaternionB.set(vehicleInterpolationData.qx, vehicleInterpolationData.qy, vehicleInterpolationData.qz, vehicleInterpolationData.qw);
        tempQuaternionA.nlerp((Quaternionfc)tempQuaternionB, f);
        fArray[n++] = VehicleInterpolation.tempQuaternionA.x;
        fArray[n++] = VehicleInterpolation.tempQuaternionA.y;
        fArray[n++] = VehicleInterpolation.tempQuaternionA.z;
        fArray[n++] = VehicleInterpolation.tempQuaternionA.w;
        fArray[n++] = (vehicleInterpolationData.vx - vehicleInterpolationData2.vx) * f + vehicleInterpolationData2.vx;
        fArray[n++] = (vehicleInterpolationData.vy - vehicleInterpolationData2.vy) * f + vehicleInterpolationData2.vy;
        fArray[n++] = (vehicleInterpolationData.vz - vehicleInterpolationData2.vz) * f + vehicleInterpolationData2.vz;
        fArray[n++] = vehicleInterpolationData.wheelsCount;
        for (int i = 0; i < vehicleInterpolationData.wheelsCount; ++i) {
            fArray[n++] = (vehicleInterpolationData.wheelSteering[i] - vehicleInterpolationData2.wheelSteering[i]) * f + vehicleInterpolationData2.wheelSteering[i];
            fArray[n++] = (vehicleInterpolationData.wheelRotation[i] - vehicleInterpolationData2.wheelRotation[i]) * f + vehicleInterpolationData2.wheelRotation[i];
            fArray[n++] = (vehicleInterpolationData.wheelSkidInfo[i] - vehicleInterpolationData2.wheelSkidInfo[i]) * f + vehicleInterpolationData2.wheelSkidInfo[i];
            fArray[n++] = (vehicleInterpolationData.wheelSuspensionLength[i] - vehicleInterpolationData2.wheelSuspensionLength[i]) * f + vehicleInterpolationData2.wheelSuspensionLength[i];
        }
        return true;
    }
}

