/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joml.Vector2f;
import org.joml.Vector3f;
import zombie.VirtualZombieManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.iso.IsoUtils;
import zombie.popman.ObjectPool;
import zombie.scripting.objects.VehicleScript;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;

public final class SurroundVehicle {
    private static final ObjectPool<Position> s_positionPool = new ObjectPool<Position>(Position::new);
    private static final Vector3f s_tempVector3f = new Vector3f();
    private final BaseVehicle m_vehicle;
    public float x1;
    public float y1;
    public float x2;
    public float y2;
    public float x3;
    public float y3;
    public float x4;
    public float y4;
    private float x1p;
    private float y1p;
    private float x2p;
    private float y2p;
    private float x3p;
    private float y3p;
    private float x4p;
    private float y4p;
    private boolean m_bMoved = false;
    private final ArrayList<Position> m_positions = new ArrayList();
    private long m_updateMS = 0L;

    public SurroundVehicle(BaseVehicle baseVehicle) {
        Objects.requireNonNull(baseVehicle);
        this.m_vehicle = baseVehicle;
    }

    private void calcPositionsLocal() {
        s_positionPool.release((List<Position>)this.m_positions);
        this.m_positions.clear();
        VehicleScript vehicleScript = this.m_vehicle.getScript();
        if (vehicleScript == null) {
            return;
        }
        Vector3f vector3f = vehicleScript.getExtents();
        Vector3f vector3f2 = vehicleScript.getCenterOfMassOffset();
        float f = vector3f.x;
        float f2 = vector3f.z;
        float f3 = 0.005f;
        float f4 = BaseVehicle.PLUS_RADIUS + f3;
        float f5 = vector3f2.x - f / 2.0f - f4;
        float f6 = vector3f2.z - f2 / 2.0f - f4;
        float f7 = vector3f2.x + f / 2.0f + f4;
        float f8 = vector3f2.z + f2 / 2.0f + f4;
        this.addPositions(f5, vector3f2.z - f2 / 2.0f, f5, vector3f2.z + f2 / 2.0f, PositionSide.Right);
        this.addPositions(f7, vector3f2.z - f2 / 2.0f, f7, vector3f2.z + f2 / 2.0f, PositionSide.Left);
        this.addPositions(f5, f6, f7, f6, PositionSide.Rear);
        this.addPositions(f5, f8, f7, f8, PositionSide.Front);
    }

    private void addPositions(float f, float f2, float f3, float f4, PositionSide positionSide) {
        Vector3f vector3f = this.m_vehicle.getPassengerLocalPos(0, s_tempVector3f);
        if (vector3f == null) {
            return;
        }
        float f5 = 0.3f;
        if (positionSide == PositionSide.Left || positionSide == PositionSide.Right) {
            float f6;
            float f7;
            float f8 = f;
            for (f7 = f6 = vector3f.z; f7 >= f2 + f5; f7 -= f5 * 2.0f) {
                this.addPosition(f8, f7, positionSide);
            }
            for (f7 = f6 + f5 * 2.0f; f7 < f4 - f5; f7 += f5 * 2.0f) {
                this.addPosition(f8, f7, positionSide);
            }
        } else {
            float f9;
            float f10 = 0.0f;
            float f11 = f2;
            for (f9 = f10; f9 >= f + f5; f9 -= f5 * 2.0f) {
                this.addPosition(f9, f11, positionSide);
            }
            for (f9 = f10 + f5 * 2.0f; f9 < f3 - f5; f9 += f5 * 2.0f) {
                this.addPosition(f9, f11, positionSide);
            }
        }
    }

    private Position addPosition(float f, float f2, PositionSide positionSide) {
        Position position = s_positionPool.alloc();
        position.posLocal.set(f, f2);
        position.side = positionSide;
        this.m_positions.add(position);
        return position;
    }

    private void calcPositionsWorld() {
        block4: for (int i = 0; i < this.m_positions.size(); ++i) {
            Position position = this.m_positions.get(i);
            this.m_vehicle.getWorldPos(position.posLocal.x, 0.0f, position.posLocal.y, position.posWorld);
            switch (position.side) {
                case Front: 
                case Rear: {
                    this.m_vehicle.getWorldPos(position.posLocal.x, 0.0f, 0.0f, position.posAxis);
                    continue block4;
                }
                case Left: 
                case Right: {
                    this.m_vehicle.getWorldPos(0.0f, 0.0f, position.posLocal.y, position.posAxis);
                }
            }
        }
        PolygonalMap2.VehiclePoly vehiclePoly = this.m_vehicle.getPoly();
        this.x1p = vehiclePoly.x1;
        this.x2p = vehiclePoly.x2;
        this.x3p = vehiclePoly.x3;
        this.x4p = vehiclePoly.x4;
        this.y1p = vehiclePoly.y1;
        this.y2p = vehiclePoly.y2;
        this.y3p = vehiclePoly.y3;
        this.y4p = vehiclePoly.y4;
    }

    private Position getClosestPositionFor(IsoZombie isoZombie) {
        if (isoZombie == null || isoZombie.getTarget() == null) {
            return null;
        }
        float f = Float.MAX_VALUE;
        Position position = null;
        for (int i = 0; i < this.m_positions.size(); ++i) {
            float f2;
            Position position2 = this.m_positions.get(i);
            if (position2.bBlocked) continue;
            float f3 = IsoUtils.DistanceToSquared(isoZombie.x, isoZombie.y, position2.posWorld.x, position2.posWorld.y);
            if (position2.isOccupied() && (f2 = IsoUtils.DistanceToSquared(position2.zombie.x, position2.zombie.y, position2.posWorld.x, position2.posWorld.y)) < f3 || !((f2 = IsoUtils.DistanceToSquared(isoZombie.getTarget().x, isoZombie.getTarget().y, position2.posWorld.x, position2.posWorld.y)) < f)) continue;
            f = f2;
            position = position2;
        }
        return position;
    }

    public Vector2f getPositionForZombie(IsoZombie isoZombie, Vector2f vector2f) {
        if (isoZombie.isOnFloor() && !isoZombie.isCanWalk() || (int)isoZombie.getZ() != (int)this.m_vehicle.getZ()) {
            return vector2f.set(this.m_vehicle.x, this.m_vehicle.y);
        }
        float f = IsoUtils.DistanceToSquared(isoZombie.x, isoZombie.y, this.m_vehicle.x, this.m_vehicle.y);
        if (f > 100.0f) {
            return vector2f.set(this.m_vehicle.x, this.m_vehicle.y);
        }
        if (this.checkPosition()) {
            this.m_bMoved = true;
        }
        for (int i = 0; i < this.m_positions.size(); ++i) {
            Position position = this.m_positions.get(i);
            if (position.bBlocked) {
                position.zombie = null;
            }
            if (position.zombie != isoZombie) continue;
            return vector2f.set(position.posWorld.x, position.posWorld.y);
        }
        Position position = this.getClosestPositionFor(isoZombie);
        if (position == null) {
            return null;
        }
        position.zombie = isoZombie;
        position.targetX = isoZombie.getTarget().x;
        position.targetY = isoZombie.getTarget().y;
        return vector2f.set(position.posWorld.x, position.posWorld.y);
    }

    private boolean checkPosition() {
        if (this.m_vehicle.getScript() == null) {
            return false;
        }
        if (this.m_positions.isEmpty()) {
            this.calcPositionsLocal();
            this.x1 = -1.0f;
        }
        PolygonalMap2.VehiclePoly vehiclePoly = this.m_vehicle.getPoly();
        if (this.x1 != vehiclePoly.x1 || this.x2 != vehiclePoly.x2 || this.x3 != vehiclePoly.x3 || this.x4 != vehiclePoly.x4 || this.y1 != vehiclePoly.y1 || this.y2 != vehiclePoly.y2 || this.y3 != vehiclePoly.y3 || this.y4 != vehiclePoly.y4) {
            this.x1 = vehiclePoly.x1;
            this.x2 = vehiclePoly.x2;
            this.x3 = vehiclePoly.x3;
            this.x4 = vehiclePoly.x4;
            this.y1 = vehiclePoly.y1;
            this.y2 = vehiclePoly.y2;
            this.y3 = vehiclePoly.y3;
            this.y4 = vehiclePoly.y4;
            this.calcPositionsWorld();
            return true;
        }
        return false;
    }

    private boolean movedSincePositionsWereCalculated() {
        PolygonalMap2.VehiclePoly vehiclePoly = this.m_vehicle.getPoly();
        return this.x1p != vehiclePoly.x1 || this.x2p != vehiclePoly.x2 || this.x3p != vehiclePoly.x3 || this.x4p != vehiclePoly.x4 || this.y1p != vehiclePoly.y1 || this.y2p != vehiclePoly.y2 || this.y3p != vehiclePoly.y3 || this.y4p != vehiclePoly.y4;
    }

    private boolean hasOccupiedPositions() {
        for (int i = 0; i < this.m_positions.size(); ++i) {
            Position position = this.m_positions.get(i);
            if (position.zombie == null) continue;
            return true;
        }
        return false;
    }

    public void update() {
        int n;
        long l;
        if (this.hasOccupiedPositions() && this.checkPosition()) {
            this.m_bMoved = true;
        }
        if ((l = System.currentTimeMillis()) - this.m_updateMS < 1000L) {
            return;
        }
        this.m_updateMS = l;
        if (this.m_bMoved) {
            this.m_bMoved = false;
            for (n = 0; n < this.m_positions.size(); ++n) {
                Position position = this.m_positions.get(n);
                position.zombie = null;
            }
        }
        n = this.movedSincePositionsWereCalculated();
        for (int i = 0; i < this.m_positions.size(); ++i) {
            Position position = this.m_positions.get(i);
            if (n == 0) {
                position.checkBlocked(this.m_vehicle);
            }
            if (position.zombie == null) continue;
            float f = IsoUtils.DistanceToSquared(position.zombie.x, position.zombie.y, this.m_vehicle.x, this.m_vehicle.y);
            if (f > 100.0f) {
                position.zombie = null;
                continue;
            }
            IsoGameCharacter isoGameCharacter = Type.tryCastTo(position.zombie.getTarget(), IsoGameCharacter.class);
            if (position.zombie.isDead() || VirtualZombieManager.instance.isReused(position.zombie) || position.zombie.isOnFloor() || isoGameCharacter == null || this.m_vehicle.getSeat(isoGameCharacter) == -1) {
                position.zombie = null;
                continue;
            }
            if (!(IsoUtils.DistanceToSquared(position.targetX, position.targetY, isoGameCharacter.x, isoGameCharacter.y) > 0.1f)) continue;
            position.zombie = null;
        }
    }

    public void render() {
        if (!this.hasOccupiedPositions()) {
            return;
        }
        for (int i = 0; i < this.m_positions.size(); ++i) {
            Position position = this.m_positions.get(i);
            Vector3f vector3f = position.posWorld;
            float f = 1.0f;
            float f2 = 1.0f;
            float f3 = 1.0f;
            if (position.isOccupied()) {
                f3 = 0.0f;
                f = 0.0f;
            } else if (position.bBlocked) {
                f3 = 0.0f;
                f2 = 0.0f;
            }
            this.m_vehicle.getController().drawCircle(vector3f.x, vector3f.y, 0.3f, f, f2, f3, 1.0f);
        }
    }

    public void reset() {
        s_positionPool.release((List<Position>)this.m_positions);
        this.m_positions.clear();
    }

    private static enum PositionSide {
        Front,
        Rear,
        Left,
        Right;

    }

    private static final class Position {
        final Vector2f posLocal = new Vector2f();
        final Vector3f posWorld = new Vector3f();
        final Vector3f posAxis = new Vector3f();
        PositionSide side;
        IsoZombie zombie;
        float targetX;
        float targetY;
        boolean bBlocked;

        private Position() {
        }

        boolean isOccupied() {
            return this.zombie != null;
        }

        void checkBlocked(BaseVehicle baseVehicle) {
            this.bBlocked = PolygonalMap2.instance.lineClearCollide(this.posWorld.x, this.posWorld.y, this.posAxis.x, this.posAxis.y, (int)baseVehicle.z, baseVehicle);
            if (!this.bBlocked) {
                this.bBlocked = !PolygonalMap2.instance.canStandAt(this.posWorld.x, this.posWorld.y, (int)baseVehicle.z, baseVehicle, false, false);
            }
        }
    }
}

