/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import astar.ASearchNode;
import astar.AStar;
import astar.IGoalNode;
import astar.ISearchNode;
import gnu.trove.TFloatCollection;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.awt.geom.Line2D;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import zombie.Lua.LuaManager;
import zombie.ai.KnownBlockedEdges;
import zombie.ai.astar.Mover;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.physics.Transform;
import zombie.core.utils.BooleanGrid;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistic;
import zombie.network.ServerMap;
import zombie.popman.ObjectPool;
import zombie.scripting.objects.VehicleScript;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.Clipper;
import zombie.vehicles.CollideWithObstacles;
import zombie.vehicles.CollideWithObstaclesPoly;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.QuadranglesIntersection;

public final class PolygonalMap2 {
    public static final float RADIUS = 0.3f;
    private static final float RADIUS_DIAGONAL = (float)Math.sqrt(0.18f);
    public static final boolean CLOSE_TO_WALLS = true;
    public static final boolean PATHS_UNDER_VEHICLES = true;
    public static final boolean COLLIDE_CLIPPER = false;
    public static final boolean COLLIDE_BEVEL = false;
    public static final int CXN_FLAG_CAN_PATH = 1;
    public static final int CXN_FLAG_THUMP = 2;
    public static final int NODE_FLAG_CRAWL = 1;
    public static final int NODE_FLAG_CRAWL_INTERIOR = 2;
    public static final int NODE_FLAG_IN_CHUNK_DATA = 4;
    public static final int NODE_FLAG_PERIMETER = 8;
    public static final int NODE_FLAG_KEEP = 65536;
    private static final Vector2 temp = new Vector2();
    private static final Vector3f tempVec3f_1 = new Vector3f();
    private final ArrayList<VehicleCluster> clusters = new ArrayList();
    private ClosestPointOnEdge closestPointOnEdge = new ClosestPointOnEdge();
    private final TIntObjectHashMap<Node> squareToNode = new TIntObjectHashMap();
    private final ArrayList<Square> tempSquares = new ArrayList();
    public static final PolygonalMap2 instance = new PolygonalMap2();
    private final ArrayList<VisibilityGraph> graphs = new ArrayList();
    private Clipper clipperThread;
    private final ByteBuffer xyBufferThread = ByteBuffer.allocateDirect(8192);
    private final AdjustStartEndNodeData adjustStartData = new AdjustStartEndNodeData();
    private final AdjustStartEndNodeData adjustGoalData = new AdjustStartEndNodeData();
    private final LineClearCollide lcc = new LineClearCollide();
    private final VGAStar astar = new VGAStar();
    private final TestRequest testRequest = new TestRequest();
    private int testZ = 0;
    private final PathFindBehavior2.PointOnPath pointOnPath = new PathFindBehavior2.PointOnPath();
    private static final int SQUARES_PER_CHUNK = 10;
    private static final int LEVELS_PER_CHUNK = 8;
    private static final int SQUARES_PER_CELL = 300;
    private static final int CHUNKS_PER_CELL = 30;
    private static final int BIT_SOLID = 1;
    private static final int BIT_COLLIDE_W = 2;
    private static final int BIT_COLLIDE_N = 4;
    private static final int BIT_STAIR_TW = 8;
    private static final int BIT_STAIR_MW = 16;
    private static final int BIT_STAIR_BW = 32;
    private static final int BIT_STAIR_TN = 64;
    private static final int BIT_STAIR_MN = 128;
    private static final int BIT_STAIR_BN = 256;
    private static final int BIT_SOLID_FLOOR = 512;
    private static final int BIT_SOLID_TRANS = 1024;
    private static final int BIT_WINDOW_W = 2048;
    private static final int BIT_WINDOW_N = 4096;
    private static final int BIT_CAN_PATH_W = 8192;
    private static final int BIT_CAN_PATH_N = 16384;
    private static final int BIT_THUMP_W = 32768;
    private static final int BIT_THUMP_N = 65536;
    private static final int BIT_THUMPABLE = 131072;
    private static final int BIT_DOOR_E = 262144;
    private static final int BIT_DOOR_S = 524288;
    private static final int BIT_WINDOW_W_UNBLOCKED = 0x100000;
    private static final int BIT_WINDOW_N_UNBLOCKED = 0x200000;
    private static final int ALL_SOLID_BITS = 1025;
    private static final int ALL_STAIR_BITS = 504;
    private final ConcurrentLinkedQueue<IChunkTask> chunkTaskQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<SquareUpdateTask> squareTaskQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IVehicleTask> vehicleTaskQueue = new ConcurrentLinkedQueue();
    private final ArrayList<Vehicle> vehicles = new ArrayList();
    private final HashMap<BaseVehicle, Vehicle> vehicleMap = new HashMap();
    private int minX;
    private int minY;
    private int width;
    private int height;
    private Cell[][] cells;
    private final HashMap<BaseVehicle, VehicleState> vehicleState = new HashMap();
    private final TObjectProcedure<Node> releaseNodeProc = new TObjectProcedure<Node>(){

        public boolean execute(Node node) {
            node.release();
            return true;
        }
    };
    private boolean rebuild;
    private final Path shortestPath = new Path();
    private final Sync sync = new Sync();
    private final Object renderLock = new Object();
    private PMThread thread;
    private final RequestQueue requests = new RequestQueue();
    private final ConcurrentLinkedQueue<PathFindRequest> requestToMain = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PathRequestTask> requestTaskQueue = new ConcurrentLinkedQueue();
    private final HashMap<Mover, PathFindRequest> requestMap = new HashMap();
    public static final int LCC_ZERO = 0;
    public static final int LCC_IGNORE_DOORS = 1;
    public static final int LCC_CLOSE_TO_WALLS = 2;
    public static final int LCC_CHECK_COST = 4;
    public static final int LCC_RENDER = 8;
    public static final int LCC_ALLOW_ON_EDGE = 16;
    private final LineClearCollideMain lccMain = new LineClearCollideMain();
    private final float[] tempFloats = new float[8];
    private final CollideWithObstacles collideWithObstacles = new CollideWithObstacles();
    private final CollideWithObstaclesPoly collideWithObstaclesPoly = new CollideWithObstaclesPoly();

    private void createVehicleCluster(VehicleRect vehicleRect, ArrayList<VehicleRect> arrayList, ArrayList<VehicleCluster> arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            VehicleCluster vehicleCluster;
            VehicleRect vehicleRect2 = arrayList.get(i);
            if (vehicleRect == vehicleRect2 || vehicleRect.z != vehicleRect2.z || vehicleRect.cluster != null && vehicleRect.cluster == vehicleRect2.cluster || !vehicleRect.isAdjacent(vehicleRect2)) continue;
            if (vehicleRect.cluster != null) {
                if (vehicleRect2.cluster == null) {
                    vehicleRect2.cluster = vehicleRect.cluster;
                    vehicleRect2.cluster.rects.add(vehicleRect2);
                    continue;
                }
                arrayList2.remove(vehicleRect2.cluster);
                vehicleRect.cluster.merge(vehicleRect2.cluster);
                continue;
            }
            if (vehicleRect2.cluster != null) {
                if (vehicleRect.cluster == null) {
                    vehicleRect.cluster = vehicleRect2.cluster;
                    vehicleRect.cluster.rects.add(vehicleRect);
                    continue;
                }
                arrayList2.remove(vehicleRect.cluster);
                vehicleRect2.cluster.merge(vehicleRect.cluster);
                continue;
            }
            vehicleRect.cluster = vehicleCluster = VehicleCluster.alloc().init();
            vehicleRect2.cluster = vehicleCluster;
            vehicleCluster.rects.add(vehicleRect);
            vehicleCluster.rects.add(vehicleRect2);
            arrayList2.add(vehicleCluster);
        }
        if (vehicleRect.cluster == null) {
            VehicleCluster vehicleCluster;
            vehicleRect.cluster = vehicleCluster = VehicleCluster.alloc().init();
            vehicleCluster.rects.add(vehicleRect);
            arrayList2.add(vehicleCluster);
        }
    }

    private void createVehicleClusters() {
        Object object;
        int n;
        this.clusters.clear();
        ArrayList<VehicleRect> arrayList = new ArrayList<VehicleRect>();
        for (n = 0; n < this.vehicles.size(); ++n) {
            object = this.vehicles.get(n);
            VehicleRect vehicleRect = VehicleRect.alloc();
            ((Vehicle)object).polyPlusRadius.getAABB(vehicleRect);
            vehicleRect.vehicle = object;
            arrayList.add(vehicleRect);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (VehicleRect)arrayList.get(n);
            this.createVehicleCluster((VehicleRect)object, arrayList, this.clusters);
        }
    }

    private Node getNodeForSquare(Square square) {
        Node node = (Node)this.squareToNode.get(square.ID.intValue());
        if (node == null) {
            node = Node.alloc().init(square);
            this.squareToNode.put(square.ID.intValue(), (Object)node);
        }
        return node;
    }

    private VisibilityGraph getVisGraphAt(float f, float f2, int n) {
        for (int i = 0; i < this.graphs.size(); ++i) {
            VisibilityGraph visibilityGraph = this.graphs.get(i);
            if (!visibilityGraph.contains(f, f2, n)) continue;
            return visibilityGraph;
        }
        return null;
    }

    private VisibilityGraph getVisGraphAt(float f, float f2, int n, int n2) {
        for (int i = 0; i < this.graphs.size(); ++i) {
            VisibilityGraph visibilityGraph = this.graphs.get(i);
            if (!visibilityGraph.contains(f, f2, n, n2)) continue;
            return visibilityGraph;
        }
        return null;
    }

    private VisibilityGraph getVisGraphForSquare(Square square) {
        for (int i = 0; i < this.graphs.size(); ++i) {
            VisibilityGraph visibilityGraph = this.graphs.get(i);
            if (!visibilityGraph.contains(square)) continue;
            return visibilityGraph;
        }
        return null;
    }

    private Connection connectTwoNodes(Node node, Node node2, int n) {
        Connection connection = Connection.alloc().init(node, node2, n);
        node.visible.add(connection);
        node2.visible.add(connection);
        return connection;
    }

    private Connection connectTwoNodes(Node node, Node node2) {
        return this.connectTwoNodes(node, node2, 0);
    }

    private void breakConnection(Connection connection) {
        connection.node1.visible.remove(connection);
        connection.node2.visible.remove(connection);
        connection.release();
    }

    private void breakConnection(Node node, Node node2) {
        for (int i = 0; i < node.visible.size(); ++i) {
            Connection connection = node.visible.get(i);
            if (connection.otherNode(node) != node2) continue;
            this.breakConnection(connection);
            break;
        }
    }

    private void addStairNodes() {
        Object object;
        int n;
        ArrayList<Square> arrayList = this.tempSquares;
        arrayList.clear();
        for (n = 0; n < this.graphs.size(); ++n) {
            object = this.graphs.get(n);
            ((VisibilityGraph)object).getStairSquares(arrayList);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            Square square = null;
            Object object3 = null;
            Square square2 = null;
            Square square3 = null;
            Square square4 = null;
            if (((Square)object).has(8)) {
                square = this.getSquare(((Square)object).x - 1, ((Square)object).y, ((Square)object).z + 1);
                object3 = object;
                square2 = this.getSquare(((Square)object).x + 1, ((Square)object).y, ((Square)object).z);
                square3 = this.getSquare(((Square)object).x + 2, ((Square)object).y, ((Square)object).z);
                square4 = this.getSquare(((Square)object).x + 3, ((Square)object).y, ((Square)object).z);
            }
            if (((Square)object).has(64)) {
                square = this.getSquare(((Square)object).x, ((Square)object).y - 1, ((Square)object).z + 1);
                object3 = object;
                square2 = this.getSquare(((Square)object).x, ((Square)object).y + 1, ((Square)object).z);
                square3 = this.getSquare(((Square)object).x, ((Square)object).y + 2, ((Square)object).z);
                square4 = this.getSquare(((Square)object).x, ((Square)object).y + 3, ((Square)object).z);
            }
            if (square == null || object3 == null || square2 == null || square3 == null || square4 == null) continue;
            Node node = null;
            Node node2 = null;
            VisibilityGraph visibilityGraph = this.getVisGraphForSquare(square);
            if (visibilityGraph == null) {
                node = this.getNodeForSquare(square);
            } else {
                node = Node.alloc().init(square);
                for (Obstacle obstacle : visibilityGraph.obstacles) {
                    if (!obstacle.isNodeInsideOf(node)) continue;
                    node.ignore = true;
                }
                node.addGraph(visibilityGraph);
                visibilityGraph.addNode(node);
                this.squareToNode.put(square.ID.intValue(), (Object)node);
            }
            visibilityGraph = this.getVisGraphForSquare(square4);
            if (visibilityGraph == null) {
                node2 = this.getNodeForSquare(square4);
            } else {
                node2 = Node.alloc().init(square4);
                for (Obstacle obstacle : visibilityGraph.obstacles) {
                    if (!obstacle.isNodeInsideOf(node2)) continue;
                    node2.ignore = true;
                }
                node2.addGraph(visibilityGraph);
                visibilityGraph.addNode(node2);
                this.squareToNode.put(square4.ID.intValue(), (Object)node2);
            }
            if (node == null || node2 == null) continue;
            Node node3 = this.getNodeForSquare((Square)object3);
            Node node4 = this.getNodeForSquare(square2);
            Node node5 = this.getNodeForSquare(square3);
            this.connectTwoNodes(node, node3);
            this.connectTwoNodes(node3, node4);
            this.connectTwoNodes(node4, node5);
            this.connectTwoNodes(node5, node2);
        }
    }

    private void addCanPathNodes() {
        Object object;
        int n;
        ArrayList<Square> arrayList = this.tempSquares;
        arrayList.clear();
        for (n = 0; n < this.graphs.size(); ++n) {
            object = this.graphs.get(n);
            ((VisibilityGraph)object).getCanPathSquares(arrayList);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n2;
            Node node;
            Node node2;
            int n3;
            int n4;
            Square square;
            object = arrayList.get(n);
            if (((Square)object).isNonThumpableSolid() || ((Square)object).has(504) || !((Square)object).has(512)) continue;
            if (((Square)object).isCanPathW() && (square = this.getSquare(n4 = ((Square)object).x - 1, n3 = ((Square)object).y, ((Square)object).z)) != null && !square.isNonThumpableSolid() && !square.has(504) && square.has(512)) {
                node2 = this.getOrCreateCanPathNode((Square)object);
                node = this.getOrCreateCanPathNode(square);
                n2 = 1;
                if (((Square)object).has(163840) || square.has(131072)) {
                    n2 |= 2;
                }
                this.connectTwoNodes(node2, node, n2);
            }
            if (!((Square)object).isCanPathN() || (square = this.getSquare(n4 = ((Square)object).x, n3 = ((Square)object).y - 1, ((Square)object).z)) == null || square.isNonThumpableSolid() || square.has(504) || !square.has(512)) continue;
            node2 = this.getOrCreateCanPathNode((Square)object);
            node = this.getOrCreateCanPathNode(square);
            n2 = 1;
            if (((Square)object).has(196608) || square.has(131072)) {
                n2 |= 2;
            }
            this.connectTwoNodes(node2, node, n2);
        }
    }

    private Node getOrCreateCanPathNode(Square square) {
        VisibilityGraph visibilityGraph = this.getVisGraphForSquare(square);
        Node node = this.getNodeForSquare(square);
        if (visibilityGraph != null && !visibilityGraph.nodes.contains(node)) {
            for (Obstacle obstacle : visibilityGraph.obstacles) {
                if (!obstacle.isNodeInsideOf(node)) continue;
                node.ignore = true;
                break;
            }
            visibilityGraph.addNode(node);
        }
        return node;
    }

    private Node getPointOutsideObjects(Square square, float f, float f2) {
        float f3;
        float f4;
        boolean bl;
        Square square2 = instance.getSquare(square.x - 1, square.y, square.z);
        Square square3 = instance.getSquare(square.x - 1, square.y - 1, square.z);
        Square square4 = instance.getSquare(square.x, square.y - 1, square.z);
        Square square5 = instance.getSquare(square.x + 1, square.y - 1, square.z);
        Square square6 = instance.getSquare(square.x + 1, square.y, square.z);
        Square square7 = instance.getSquare(square.x + 1, square.y + 1, square.z);
        Square square8 = instance.getSquare(square.x, square.y + 1, square.z);
        Square square9 = instance.getSquare(square.x - 1, square.y + 1, square.z);
        float f5 = square.x;
        float f6 = square.y;
        float f7 = square.x + 1;
        float f8 = square.y + 1;
        if (square.isCollideW()) {
            f5 += 0.35000002f;
        }
        if (square.isCollideN()) {
            f6 += 0.35000002f;
        }
        if (square6 != null && (square6.has(2) || square6.has(504) || square6.isReallySolid())) {
            f7 -= 0.35000002f;
        }
        if (square8 != null && (square8.has(4) || square8.has(504) || square8.isReallySolid())) {
            f8 -= 0.35000002f;
        }
        float f9 = PZMath.clamp(f, f5, f7);
        float f10 = PZMath.clamp(f2, f6, f8);
        if (f9 <= (float)square.x + 0.3f && f10 <= (float)square.y + 0.3f) {
            bl = square3 != null && (square3.has(504) || square3.isReallySolid());
            bl |= square4 != null && square4.has(2);
            if (bl |= square2 != null && square2.has(4)) {
                f4 = (float)square.x + 0.3f + 0.05f;
                f3 = (float)square.y + 0.3f + 0.05f;
                if (f4 - f9 <= f3 - f10) {
                    f9 = f4;
                } else {
                    f10 = f3;
                }
            }
        }
        if (f9 >= (float)(square.x + 1) - 0.3f && f10 <= (float)square.y + 0.3f) {
            bl = square5 != null && (square5.has(2) || square5.has(504) || square5.isReallySolid());
            if (bl |= square6 != null && square6.has(4)) {
                f4 = (float)(square.x + 1) - 0.3f - 0.05f;
                f3 = (float)square.y + 0.3f + 0.05f;
                if (f9 - f4 <= f3 - f10) {
                    f9 = f4;
                } else {
                    f10 = f3;
                }
            }
        }
        if (f9 <= (float)square.x + 0.3f && f10 >= (float)(square.y + 1) - 0.3f) {
            bl = square9 != null && (square9.has(4) || square9.has(504) || square9.isReallySolid());
            if (bl |= square8 != null && square8.has(2)) {
                f4 = (float)square.x + 0.3f + 0.05f;
                f3 = (float)(square.y + 1) - 0.3f - 0.05f;
                if (f4 - f9 <= f10 - f3) {
                    f9 = f4;
                } else {
                    f10 = f3;
                }
            }
        }
        if (f9 >= (float)(square.x + 1) - 0.3f && f10 >= (float)(square.y + 1) - 0.3f) {
            boolean bl2 = bl = square7 != null && (square7.has(2) || square7.has(4) || square7.has(504) || square7.isReallySolid());
            if (bl) {
                f4 = (float)(square.x + 1) - 0.3f - 0.05f;
                f3 = (float)(square.y + 1) - 0.3f - 0.05f;
                if (f9 - f4 <= f10 - f3) {
                    f9 = f4;
                } else {
                    f10 = f3;
                }
            }
        }
        return Node.alloc().init(f9, f10, square.z);
    }

    private void createVisibilityGraph(VehicleCluster vehicleCluster) {
        VisibilityGraph visibilityGraph = VisibilityGraph.alloc().init(vehicleCluster);
        visibilityGraph.addPerimeterEdges();
        this.graphs.add(visibilityGraph);
    }

    private void createVisibilityGraphs() {
        this.createVehicleClusters();
        this.graphs.clear();
        this.squareToNode.clear();
        for (int i = 0; i < this.clusters.size(); ++i) {
            VehicleCluster vehicleCluster = this.clusters.get(i);
            this.createVisibilityGraph(vehicleCluster);
        }
        this.addStairNodes();
        this.addCanPathNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean findPath(PathFindRequest var1_1, boolean var2_2) {
        block112: {
            block115: {
                block113: {
                    block114: {
                        block119: {
                            block110: {
                                block111: {
                                    block118: {
                                        block108: {
                                            block109: {
                                                block106: {
                                                    block107: {
                                                        block117: {
                                                            block104: {
                                                                block105: {
                                                                    block116: {
                                                                        block102: {
                                                                            block103: {
                                                                                var3_3 = 16;
                                                                                if (!(var1_1.mover instanceof IsoZombie)) {
                                                                                    var3_3 |= 4;
                                                                                }
                                                                                if ((int)var1_1.startZ == (int)var1_1.targetZ && !this.lcc.isNotClear(this, var1_1.startX, var1_1.startY, var1_1.targetX, var1_1.targetY, (int)var1_1.startZ, var3_3)) {
                                                                                    var1_1.path.addNode(var1_1.startX, var1_1.startY, var1_1.startZ);
                                                                                    var1_1.path.addNode(var1_1.targetX, var1_1.targetY, var1_1.targetZ);
                                                                                    if (var2_2) {
                                                                                        for (VisibilityGraph var5_7 : this.graphs) {
                                                                                            var5_7.render();
                                                                                        }
                                                                                    }
                                                                                    return true;
                                                                                }
                                                                                this.astar.init(this.graphs, this.squareToNode);
                                                                                this.astar.knownBlockedEdges.clear();
                                                                                for (var4_5 = 0; var4_5 < var1_1.knownBlockedEdges.size(); ++var4_5) {
                                                                                    var5_8 = var1_1.knownBlockedEdges.get(var4_5);
                                                                                    var6_9 /* !! */  = this.getSquare(var5_8.x, var5_8.y, var5_8.z);
                                                                                    if (var6_9 /* !! */  == null) continue;
                                                                                    this.astar.knownBlockedEdges.put(var6_9 /* !! */ .ID.intValue(), var5_8);
                                                                                }
                                                                                var4_6 = null;
                                                                                var5_8 = null;
                                                                                var6_9 /* !! */  = null;
                                                                                var7_10 = null;
                                                                                var8_11 = false;
                                                                                var9_12 = false;
                                                                                var10_13 = this.getSquare((int)var1_1.startX, (int)var1_1.startY, (int)var1_1.startZ);
                                                                                if (var10_13 != null && !var10_13.isReallySolid()) break block102;
                                                                                var11_15 = false;
                                                                                if (!var2_2) break block103;
                                                                                for (Object var13_27 : this.graphs) {
                                                                                    var13_27.render();
                                                                                }
                                                                            }
                                                                            if (var4_6 != null) {
                                                                                var4_6.removeNode(var6_9 /* !! */ .vgNode);
                                                                            }
                                                                            if (var5_8 != null) {
                                                                                var5_8.removeNode(var7_10.vgNode);
                                                                            }
                                                                            for (var12_20 = 0; var12_20 < this.astar.searchNodes.size(); ++var12_20) {
                                                                                this.astar.searchNodes.get(var12_20).release();
                                                                            }
                                                                            if (var8_11 && this.adjustStartData.isNodeNew) {
                                                                                for (var12_20 = 0; var12_20 < this.adjustStartData.node.edges.size(); ++var12_20) {
                                                                                    var13_27 = this.adjustStartData.node.edges.get(var12_20);
                                                                                    var13_27.obstacle.unsplit(this.adjustStartData.node, var13_27.edgeRing);
                                                                                }
                                                                                this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                                                                            }
                                                                            if (var9_12 && this.adjustGoalData.isNodeNew) {
                                                                                for (var12_20 = 0; var12_20 < this.adjustGoalData.node.edges.size(); ++var12_20) {
                                                                                    var13_27 = this.adjustGoalData.node.edges.get(var12_20);
                                                                                    var13_27.obstacle.unsplit(this.adjustGoalData.node, var13_27.edgeRing);
                                                                                }
                                                                                this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                                                                            }
                                                                            return var11_15;
                                                                        }
                                                                        if (!var10_13.has(504)) break block116;
                                                                        var6_9 /* !! */  = this.astar.getSearchNode((Square)var10_13);
                                                                        ** GOTO lbl114
                                                                    }
                                                                    var11_16 = this.astar.getVisGraphForSquare((Square)var10_13);
                                                                    if (var11_16 == null) ** GOTO lbl114
                                                                    if (!var11_16.created) {
                                                                        var11_16.create();
                                                                    }
                                                                    var12_21 = null;
                                                                    var13_28 = var11_16.getPointOutsideObstacles(var1_1.startX, var1_1.startY, var1_1.startZ, this.adjustStartData);
                                                                    if (var13_28 != -1) break block104;
                                                                    var14_39 = false;
                                                                    if (!var2_2) break block105;
                                                                    for (Object var16_49 : this.graphs) {
                                                                        var16_49.render();
                                                                    }
                                                                }
                                                                if (var4_6 != null) {
                                                                    var4_6.removeNode(var6_9 /* !! */ .vgNode);
                                                                }
                                                                if (var5_8 != null) {
                                                                    var5_8.removeNode(var7_10.vgNode);
                                                                }
                                                                for (var15_45 = 0; var15_45 < this.astar.searchNodes.size(); ++var15_45) {
                                                                    this.astar.searchNodes.get(var15_45).release();
                                                                }
                                                                if (var8_11 && this.adjustStartData.isNodeNew) {
                                                                    for (var15_45 = 0; var15_45 < this.adjustStartData.node.edges.size(); ++var15_45) {
                                                                        var16_49 = this.adjustStartData.node.edges.get(var15_45);
                                                                        var16_49.obstacle.unsplit(this.adjustStartData.node, var16_49.edgeRing);
                                                                    }
                                                                    this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                                                                }
                                                                if (var9_12 && this.adjustGoalData.isNodeNew) {
                                                                    for (var15_45 = 0; var15_45 < this.adjustGoalData.node.edges.size(); ++var15_45) {
                                                                        var16_49 = this.adjustGoalData.node.edges.get(var15_45);
                                                                        var16_49.obstacle.unsplit(this.adjustGoalData.node, var16_49.edgeRing);
                                                                    }
                                                                    this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                                                                }
                                                                return var14_39;
                                                            }
                                                            if (var13_28 == 1) {
                                                                var8_11 = true;
                                                                var12_21 = this.adjustStartData.node;
                                                                if (this.adjustStartData.isNodeNew) {
                                                                    var4_6 = var11_16;
                                                                }
                                                            }
                                                            if (var12_21 == null) {
                                                                var12_21 = Node.alloc().init(var1_1.startX, var1_1.startY, (int)var1_1.startZ);
                                                                var11_16.addNode((Node)var12_21);
                                                                var4_6 = var11_16;
                                                            }
                                                            var6_9 /* !! */  = this.astar.getSearchNode((Node)var12_21);
lbl114:
                                                            // 3 sources

                                                            if (var6_9 /* !! */  == null) {
                                                                var6_9 /* !! */  = this.astar.getSearchNode((Square)var10_13);
                                                            }
                                                            if (!(var1_1.targetX < 0.0f) && !(var1_1.targetY < 0.0f) && this.getChunkFromSquarePos((int)var1_1.targetX, (int)var1_1.targetY) != null) break block117;
                                                            var7_10 = this.astar.getSearchNode((int)var1_1.targetX, (int)var1_1.targetY);
                                                            ** GOTO lbl249
                                                        }
                                                        var10_13 = this.getSquare((int)var1_1.targetX, (int)var1_1.targetY, (int)var1_1.targetZ);
                                                        if (var10_13 != null && !var10_13.isReallySolid()) break block106;
                                                        var11_17 = false;
                                                        if (!var2_2) break block107;
                                                        for (VisibilityGraph var13_29 : this.graphs) {
                                                            var13_29.render();
                                                        }
                                                    }
                                                    if (var4_6 != null) {
                                                        var4_6.removeNode(var6_9 /* !! */ .vgNode);
                                                    }
                                                    if (var5_8 != null) {
                                                        var5_8.removeNode(var7_10.vgNode);
                                                    }
                                                    for (var12_22 = 0; var12_22 < this.astar.searchNodes.size(); ++var12_22) {
                                                        this.astar.searchNodes.get(var12_22).release();
                                                    }
                                                    if (var8_11 && this.adjustStartData.isNodeNew) {
                                                        for (var12_22 = 0; var12_22 < this.adjustStartData.node.edges.size(); ++var12_22) {
                                                            var13_30 = this.adjustStartData.node.edges.get(var12_22);
                                                            var13_30.obstacle.unsplit(this.adjustStartData.node, var13_30.edgeRing);
                                                        }
                                                        this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                                                    }
                                                    if (var9_12 && this.adjustGoalData.isNodeNew) {
                                                        for (var12_22 = 0; var12_22 < this.adjustGoalData.node.edges.size(); ++var12_22) {
                                                            var13_31 = this.adjustGoalData.node.edges.get(var12_22);
                                                            var13_31.obstacle.unsplit(this.adjustGoalData.node, var13_31.edgeRing);
                                                        }
                                                        this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                                                    }
                                                    return var11_17;
                                                }
                                                if ((int)var1_1.startX == (int)var1_1.targetX && (int)var1_1.startY == (int)var1_1.targetY && (int)var1_1.startZ == (int)var1_1.targetZ || !this.isBlockedInAllDirections((int)var1_1.targetX, (int)var1_1.targetY, (int)var1_1.targetZ)) break block108;
                                                var11_18 = false;
                                                if (!var2_2) break block109;
                                                for (VisibilityGraph var13_32 : this.graphs) {
                                                    var13_32.render();
                                                }
                                            }
                                            if (var4_6 != null) {
                                                var4_6.removeNode(var6_9 /* !! */ .vgNode);
                                            }
                                            if (var5_8 != null) {
                                                var5_8.removeNode(var7_10.vgNode);
                                            }
                                            for (var12_23 = 0; var12_23 < this.astar.searchNodes.size(); ++var12_23) {
                                                this.astar.searchNodes.get(var12_23).release();
                                            }
                                            if (var8_11 && this.adjustStartData.isNodeNew) {
                                                for (var12_23 = 0; var12_23 < this.adjustStartData.node.edges.size(); ++var12_23) {
                                                    var13_33 = this.adjustStartData.node.edges.get(var12_23);
                                                    var13_33.obstacle.unsplit(this.adjustStartData.node, var13_33.edgeRing);
                                                }
                                                this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                                            }
                                            if (var9_12 && this.adjustGoalData.isNodeNew) {
                                                for (var12_23 = 0; var12_23 < this.adjustGoalData.node.edges.size(); ++var12_23) {
                                                    var13_34 = this.adjustGoalData.node.edges.get(var12_23);
                                                    var13_34.obstacle.unsplit(this.adjustGoalData.node, var13_34.edgeRing);
                                                }
                                                this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                                            }
                                            return var11_18;
                                        }
                                        if (!var10_13.has(504)) break block118;
                                        var7_10 = this.astar.getSearchNode((Square)var10_13);
                                        ** GOTO lbl246
                                    }
                                    var11_16 = this.astar.getVisGraphForSquare((Square)var10_13);
                                    if (var11_16 == null) ** GOTO lbl235
                                    if (!var11_16.created) {
                                        var11_16.create();
                                    }
                                    var12_21 = null;
                                    var13_28 = var11_16.getPointOutsideObstacles(var1_1.targetX, var1_1.targetY, var1_1.targetZ, this.adjustGoalData);
                                    if (var13_28 != -1) break block110;
                                    var14_40 = false;
                                    if (!var2_2) break block111;
                                    for (Object var16_50 : this.graphs) {
                                        var16_50.render();
                                    }
                                }
                                if (var4_6 != null) {
                                    var4_6.removeNode(var6_9 /* !! */ .vgNode);
                                }
                                if (var5_8 != null) {
                                    var5_8.removeNode(var7_10.vgNode);
                                }
                                for (var15_47 = 0; var15_47 < this.astar.searchNodes.size(); ++var15_47) {
                                    this.astar.searchNodes.get(var15_47).release();
                                }
                                if (var8_11 && this.adjustStartData.isNodeNew) {
                                    for (var15_47 = 0; var15_47 < this.adjustStartData.node.edges.size(); ++var15_47) {
                                        var16_50 = this.adjustStartData.node.edges.get(var15_47);
                                        var16_50.obstacle.unsplit(this.adjustStartData.node, var16_50.edgeRing);
                                    }
                                    this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                                }
                                if (var9_12 && this.adjustGoalData.isNodeNew) {
                                    for (var15_47 = 0; var15_47 < this.adjustGoalData.node.edges.size(); ++var15_47) {
                                        var16_50 = this.adjustGoalData.node.edges.get(var15_47);
                                        var16_50.obstacle.unsplit(this.adjustGoalData.node, var16_50.edgeRing);
                                    }
                                    this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                                }
                                return var14_40;
                            }
                            if (var13_28 == 1) {
                                var9_12 = true;
                                var12_21 = this.adjustGoalData.node;
                                if (this.adjustGoalData.isNodeNew) {
                                    var5_8 = var11_16;
                                }
                            }
                            if (var12_21 == null) {
                                var12_21 = Node.alloc().init(var1_1.targetX, var1_1.targetY, (int)var1_1.targetZ);
                                var11_16.addNode((Node)var12_21);
                                var5_8 = var11_16;
                            }
                            var7_10 = this.astar.getSearchNode((Node)var12_21);
                            break block119;
lbl235:
                            // 2 sources

                            for (var12_24 = 0; var12_24 < this.graphs.size(); ++var12_24) {
                                var11_16 = this.graphs.get(var12_24);
                                if (!var11_16.contains((Square)var10_13, 1)) continue;
                                var13_35 = this.getPointOutsideObjects((Square)var10_13, var1_1.targetX, var1_1.targetY);
                                var11_16.addNode(var13_35);
                                if (var13_35.x != var1_1.targetX || var13_35.y != var1_1.targetY) {
                                    var9_12 = true;
                                    this.adjustGoalData.isNodeNew = false;
                                }
                                var5_8 = var11_16;
                                var7_10 = this.astar.getSearchNode(var13_35);
                                break;
                            }
                        }
                        if (var7_10 == null) {
                            var7_10 = this.astar.getSearchNode((Square)var10_13);
                        }
lbl249:
                        // 4 sources

                        var11_16 = this.astar.shortestPath(var1_1, (SearchNode)var6_9 /* !! */ , var7_10);
                        if (var11_16 == null) break block112;
                        if (var11_16.size() != 1) break block113;
                        var12_25 /* !! */  = var6_9 /* !! */ ;
                        var1_1.path.addNode((SearchNode)var12_25 /* !! */ );
                        var12_25 /* !! */  = var7_10;
                        if (!var9_12 && var12_25 /* !! */ .square != null && (float)var12_25 /* !! */ .square.x + 0.5f != var1_1.targetX && (float)var7_10.square.y + 0.5f != var1_1.targetY) {
                            var1_1.path.addNode(var1_1.targetX, var1_1.targetY, var1_1.targetZ, 0);
                        } else {
                            var1_1.path.addNode((SearchNode)var12_25 /* !! */ );
                        }
                        var13_36 = true;
                        if (!var2_2) break block114;
                        for (Object var15_48 : this.graphs) {
                            var15_48.render();
                        }
                    }
                    if (var4_6 != null) {
                        var4_6.removeNode(var6_9 /* !! */ .vgNode);
                    }
                    if (var5_8 != null) {
                        var5_8.removeNode(var7_10.vgNode);
                    }
                    for (var14_42 = 0; var14_42 < this.astar.searchNodes.size(); ++var14_42) {
                        this.astar.searchNodes.get(var14_42).release();
                    }
                    if (var8_11 && this.adjustStartData.isNodeNew) {
                        for (var14_42 = 0; var14_42 < this.adjustStartData.node.edges.size(); ++var14_42) {
                            var15_48 = this.adjustStartData.node.edges.get(var14_42);
                            var15_48.obstacle.unsplit(this.adjustStartData.node, var15_48.edgeRing);
                        }
                        this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                    }
                    if (var9_12 && this.adjustGoalData.isNodeNew) {
                        for (var14_42 = 0; var14_42 < this.adjustGoalData.node.edges.size(); ++var14_42) {
                            var15_48 = this.adjustGoalData.node.edges.get(var14_42);
                            var15_48.obstacle.unsplit(this.adjustGoalData.node, var15_48.edgeRing);
                        }
                        this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                    }
                    return var13_36;
                }
                try {
                    this.cleanPath((ArrayList<ISearchNode>)var11_16, var1_1, var8_11, var9_12, var7_10);
                    if (var1_1.mover instanceof IsoPlayer && !((IsoPlayer)var1_1.mover).isNPC()) {
                        this.smoothPath(var1_1.path);
                    }
                    var12_26 = true;
                    if (!var2_2) break block115;
                }
                catch (Throwable var17_51) {
                    if (var2_2) {
                        for (Object var19_54 : this.graphs) {
                            var19_54.render();
                        }
                    }
                    if (var4_6 != null) {
                        var4_6.removeNode(var6_9 /* !! */ .vgNode);
                    }
                    if (var5_8 != null) {
                        var5_8.removeNode(var7_10.vgNode);
                    }
                    for (var18_53 = 0; var18_53 < this.astar.searchNodes.size(); ++var18_53) {
                        this.astar.searchNodes.get(var18_53).release();
                    }
                    if (var8_11 && this.adjustStartData.isNodeNew) {
                        for (var18_53 = 0; var18_53 < this.adjustStartData.node.edges.size(); ++var18_53) {
                            var19_54 = this.adjustStartData.node.edges.get(var18_53);
                            var19_54.obstacle.unsplit(this.adjustStartData.node, var19_54.edgeRing);
                        }
                        this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
                    }
                    if (var9_12 && this.adjustGoalData.isNodeNew) {
                        for (var18_53 = 0; var18_53 < this.adjustGoalData.node.edges.size(); ++var18_53) {
                            var19_54 = this.adjustGoalData.node.edges.get(var18_53);
                            var19_54.obstacle.unsplit(this.adjustGoalData.node, var19_54.edgeRing);
                        }
                        this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
                    }
                    throw var17_51;
                }
                for (Object var14_43 : this.graphs) {
                    var14_43.render();
                }
            }
            if (var4_6 != null) {
                var4_6.removeNode(var6_9 /* !! */ .vgNode);
            }
            if (var5_8 != null) {
                var5_8.removeNode(var7_10.vgNode);
            }
            for (var13_38 = 0; var13_38 < this.astar.searchNodes.size(); ++var13_38) {
                this.astar.searchNodes.get(var13_38).release();
            }
            if (var8_11 && this.adjustStartData.isNodeNew) {
                for (var13_38 = 0; var13_38 < this.adjustStartData.node.edges.size(); ++var13_38) {
                    var14_43 = this.adjustStartData.node.edges.get(var13_38);
                    var14_43.obstacle.unsplit(this.adjustStartData.node, var14_43.edgeRing);
                }
                this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
            }
            if (var9_12 && this.adjustGoalData.isNodeNew) {
                for (var13_38 = 0; var13_38 < this.adjustGoalData.node.edges.size(); ++var13_38) {
                    var14_43 = this.adjustGoalData.node.edges.get(var13_38);
                    var14_43.obstacle.unsplit(this.adjustGoalData.node, var14_43.edgeRing);
                }
                this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
            }
            return var12_26;
        }
        if (var2_2) {
            for (Object var11_16 : this.graphs) {
                var11_16.render();
            }
        }
        if (var4_6 != null) {
            var4_6.removeNode(var6_9 /* !! */ .vgNode);
        }
        if (var5_8 != null) {
            var5_8.removeNode(var7_10.vgNode);
        }
        for (var10_14 = 0; var10_14 < this.astar.searchNodes.size(); ++var10_14) {
            this.astar.searchNodes.get(var10_14).release();
        }
        if (var8_11 && this.adjustStartData.isNodeNew) {
            for (var10_14 = 0; var10_14 < this.adjustStartData.node.edges.size(); ++var10_14) {
                var11_16 = this.adjustStartData.node.edges.get(var10_14);
                var11_16.obstacle.unsplit(this.adjustStartData.node, var11_16.edgeRing);
            }
            this.adjustStartData.graph.edges.remove(this.adjustStartData.newEdge);
        }
        if (var9_12 && this.adjustGoalData.isNodeNew) {
            for (var10_14 = 0; var10_14 < this.adjustGoalData.node.edges.size(); ++var10_14) {
                var11_16 = this.adjustGoalData.node.edges.get(var10_14);
                var11_16.obstacle.unsplit(this.adjustGoalData.node, var11_16.edgeRing);
            }
            this.adjustGoalData.graph.edges.remove(this.adjustGoalData.newEdge);
        }
        return false;
    }

    private void cleanPath(ArrayList<ISearchNode> arrayList, PathFindRequest pathFindRequest, boolean bl, boolean bl2, SearchNode searchNode) {
        boolean bl3 = pathFindRequest.mover instanceof IsoPlayer && ((IsoPlayer)pathFindRequest.mover).isNPC();
        Square square = null;
        int n = -123;
        int n2 = -123;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            SearchNode searchNode2 = (SearchNode)arrayList.get(i);
            float f = searchNode2.getX();
            float f2 = searchNode2.getY();
            float f3 = searchNode2.getZ();
            int n4 = searchNode2.vgNode == null ? 0 : searchNode2.vgNode.flags;
            Square square2 = searchNode2.square;
            boolean bl4 = false;
            if (square2 != null && square != null && square2.z == square.z) {
                int n5 = square2.x - square.x;
                n3 = square2.y - square.y;
                if (n5 == n && n3 == n2) {
                    if (pathFindRequest.path.nodes.size() > 1) {
                        bl4 = true;
                        if (pathFindRequest.path.getLastNode().hasFlag(65536)) {
                            bl4 = false;
                        }
                    }
                    if (n5 == 0 && n3 == -1 && square.has(16384)) {
                        bl4 = false;
                    } else if (n5 == 0 && n3 == 1 && square2.has(16384)) {
                        bl4 = false;
                    } else if (n5 == -1 && n3 == 0 && square.has(8192)) {
                        bl4 = false;
                    } else if (n5 == 1 && n3 == 0 && square2.has(8192)) {
                        bl4 = false;
                    }
                } else {
                    n = n5;
                    n2 = n3;
                }
            } else {
                n2 = -123;
                n = -123;
            }
            square = square2 != null ? square2 : null;
            if (bl3) {
                bl4 = false;
            }
            if (bl4) {
                PathNode pathNode = pathFindRequest.path.getLastNode();
                pathNode.x = (float)square2.x + 0.5f;
                pathNode.y = (float)square2.y + 0.5f;
                continue;
            }
            if (pathFindRequest.path.nodes.size() > 1) {
                PathNode pathNode = pathFindRequest.path.getLastNode();
                if (Math.abs(pathNode.x - f) < 0.01f && Math.abs(pathNode.y - f2) < 0.01f && Math.abs(pathNode.z - f3) < 0.01f) {
                    pathNode.x = f;
                    pathNode.y = f2;
                    pathNode.z = f3;
                    continue;
                }
            }
            if (i > 0 && searchNode2.square != null) {
                SearchNode searchNode3 = (SearchNode)arrayList.get(i - 1);
                if (searchNode3.square != null) {
                    n3 = searchNode2.square.x - searchNode3.square.x;
                    int n6 = searchNode2.square.y - searchNode3.square.y;
                    if (n3 == 0 && n6 == -1 && searchNode3.square.has(16384)) {
                        n4 |= 0x10000;
                    } else if (n3 == 0 && n6 == 1 && searchNode2.square.has(16384)) {
                        n4 |= 0x10000;
                    } else if (n3 == -1 && n6 == 0 && searchNode3.square.has(8192)) {
                        n4 |= 0x10000;
                    } else if (n3 == 1 && n6 == 0 && searchNode2.square.has(8192)) {
                        n4 |= 0x10000;
                    }
                }
            }
            pathFindRequest.path.addNode(f, f2, f3, n4);
        }
        if (pathFindRequest.mover instanceof IsoPlayer && !bl3) {
            PathNode pathNode;
            PathNode pathNode2 = pathNode = pathFindRequest.path.isEmpty() ? null : pathFindRequest.path.getNode(0);
            if (!bl2 && searchNode.square != null && (double)IsoUtils.DistanceToSquared((float)searchNode.square.x + 0.5f, (float)searchNode.square.y + 0.5f, pathFindRequest.targetX, pathFindRequest.targetY) > 0.010000000000000002) {
                pathFindRequest.path.addNode(pathFindRequest.targetX, pathFindRequest.targetY, pathFindRequest.targetZ, 0);
            }
        }
        PathNode pathNode = null;
        for (int i = 0; i < pathFindRequest.path.nodes.size(); ++i) {
            PathNode pathNode3;
            PathNode pathNode4 = pathFindRequest.path.nodes.get(i);
            PathNode pathNode5 = pathNode3 = i < pathFindRequest.path.nodes.size() - 1 ? pathFindRequest.path.nodes.get(i + 1) : null;
            if (pathNode4.hasFlag(1)) {
                boolean bl5;
                boolean bl6 = bl5 = pathNode != null && pathNode.hasFlag(2) || pathNode3 != null && pathNode3.hasFlag(2);
                if (!bl5) {
                    pathNode4.flags &= 0xFFFFFFFC;
                }
            }
            pathNode = pathNode4;
        }
    }

    private void smoothPath(Path path) {
        int n = 0;
        while (n < path.nodes.size() - 2) {
            PathNode pathNode = path.nodes.get(n);
            PathNode pathNode2 = path.nodes.get(n + 1);
            PathNode pathNode3 = path.nodes.get(n + 2);
            if ((int)pathNode.z != (int)pathNode2.z || (int)pathNode.z != (int)pathNode3.z) {
                ++n;
                continue;
            }
            if (!this.lcc.isNotClear(this, pathNode.x, pathNode.y, pathNode3.x, pathNode3.y, (int)pathNode.z, 20)) {
                path.nodes.remove(n + 1);
                path.nodePool.push(pathNode2);
                continue;
            }
            ++n;
        }
    }

    float getApparentZ(IsoGridSquare isoGridSquare) {
        if (isoGridSquare.Has(IsoObjectType.stairsTW) || isoGridSquare.Has(IsoObjectType.stairsTN)) {
            return (float)isoGridSquare.z + 0.75f;
        }
        if (isoGridSquare.Has(IsoObjectType.stairsMW) || isoGridSquare.Has(IsoObjectType.stairsMN)) {
            return (float)isoGridSquare.z + 0.5f;
        }
        if (isoGridSquare.Has(IsoObjectType.stairsBW) || isoGridSquare.Has(IsoObjectType.stairsBN)) {
            return (float)isoGridSquare.z + 0.25f;
        }
        return isoGridSquare.z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        float f;
        int n;
        float f2;
        float f3;
        float f4;
        VisibilityGraph visibilityGraph;
        Object object;
        boolean bl;
        if (!Core.bDebug) {
            return;
        }
        boolean bl2 = bl = DebugOptions.instance.PathfindPathToMouseEnable.getValue() && !this.testRequest.done && IsoPlayer.getInstance().getPath2() == null;
        if (DebugOptions.instance.PolymapRenderClusters.getValue()) {
            Object object2 = this.renderLock;
            synchronized (object2) {
                for (VehicleCluster object3 : this.clusters) {
                    for (VehicleRect f12 : object3.rects) {
                        LineDrawer.addLine(f12.x, f12.y, f12.z, f12.right(), f12.bottom(), f12.z, 0.0f, 0.0f, 1.0f, null, false);
                    }
                    VehicleRect vehicleRect = object3.bounds();
                    vehicleRect.release();
                }
                if (!bl) {
                    for (VisibilityGraph n5 : this.graphs) {
                        n5.render();
                    }
                }
            }
        }
        if (DebugOptions.instance.PolymapRenderLineClearCollide.getValue()) {
            float f5 = Mouse.getX();
            float f6 = Mouse.getY();
            int pathNode2 = (int)IsoPlayer.getInstance().getZ();
            float f11 = IsoUtils.XToIso(f5, f6, pathNode2);
            float f24 = IsoUtils.YToIso(f5, f6, pathNode2);
            LineDrawer.addLine(IsoPlayer.getInstance().x, IsoPlayer.getInstance().y, (float)pathNode2, f11, f24, (float)pathNode2, 1, 1, 1, null);
            int f25 = 9;
            if (this.lccMain.isNotClear(this, IsoPlayer.getInstance().x, IsoPlayer.getInstance().y, f11, f24, pathNode2, null, f25 |= 2)) {
                object = this.resolveCollision(IsoPlayer.getInstance(), f11, f24, L_render.vector2f);
                LineDrawer.addLine(((Vector2f)object).x - 0.05f, ((Vector2f)object).y - 0.05f, pathNode2, ((Vector2f)object).x + 0.05f, ((Vector2f)object).y + 0.05f, pathNode2, 1.0f, 1.0f, 0.0f, null, false);
            }
        }
        if (GameKeyboard.isKeyDown(209) && !GameKeyboard.wasKeyDown(209)) {
            this.testZ = Math.max(this.testZ - 1, 0);
        }
        if (GameKeyboard.isKeyDown(201) && !GameKeyboard.wasKeyDown(201)) {
            this.testZ = Math.min(this.testZ + 1, 7);
        }
        if (bl) {
            Object object2;
            int n2;
            float f9 = Mouse.getX();
            float f10 = Mouse.getY();
            int n3 = this.testZ;
            float f42 = IsoUtils.XToIso(f9, f10, n3);
            float f5 = IsoUtils.YToIso(f9, f10, n3);
            float visibilityGraph2 = n3;
            for (n2 = -1; n2 <= 2; ++n2) {
                LineDrawer.addLine((int)f42 - 1, (int)f5 + n2, (int)visibilityGraph2, (int)f42 + 2, (int)f5 + n2, (int)visibilityGraph2, 0.3f, 0.3f, 0.3f, null, false);
            }
            for (n2 = -1; n2 <= 2; ++n2) {
                LineDrawer.addLine((int)f42 + n2, (int)f5 - 1, (int)visibilityGraph2, (int)f42 + n2, (int)f5 + 2, (int)visibilityGraph2, 0.3f, 0.3f, 0.3f, null, false);
            }
            for (n2 = -1; n2 <= 1; ++n2) {
                for (int i = -1; i <= 1; ++i) {
                    float connection = 0.3f;
                    float object6 = 0.0f;
                    float pathNode = 0.0f;
                    object2 = IsoWorld.instance.CurrentCell.getGridSquare((int)f42 + i, (int)f5 + n2, (int)visibilityGraph2);
                    if (object2 != null && !((IsoGridSquare)object2).isSolid() && !((IsoGridSquare)object2).isSolidTrans() && !((IsoGridSquare)object2).HasStairs()) continue;
                    LineDrawer.addLine((int)f42 + i, (int)f5 + n2, (int)visibilityGraph2, (int)f42 + i + 1, (int)f5 + n2 + 1, (int)visibilityGraph2, connection, object6, pathNode, null, false);
                }
            }
            if (n3 < (int)IsoPlayer.getInstance().getZ()) {
                LineDrawer.addLine((int)f42, (int)f5, (int)visibilityGraph2, (int)f42, (int)f5, (int)IsoPlayer.getInstance().getZ(), 0.3f, 0.3f, 0.3f, null, true);
            } else if (n3 > (int)IsoPlayer.getInstance().getZ()) {
                LineDrawer.addLine((int)f42, (int)f5, (int)visibilityGraph2, (int)f42, (int)f5, (int)IsoPlayer.getInstance().getZ(), 0.3f, 0.3f, 0.3f, null, true);
            }
            object = PathFindRequest.alloc().init(this.testRequest, IsoPlayer.getInstance(), IsoPlayer.getInstance().x, IsoPlayer.getInstance().y, IsoPlayer.getInstance().z, f42, f5, visibilityGraph2);
            if (DebugOptions.instance.PathfindPathToMouseAllowCrawl.getValue()) {
                ((PathFindRequest)object).bCanCrawl = true;
                if (DebugOptions.instance.PathfindPathToMouseIgnoreCrawlCost.getValue()) {
                    ((PathFindRequest)object).bIgnoreCrawlCost = true;
                }
            }
            if (DebugOptions.instance.PathfindPathToMouseAllowThump.getValue()) {
                ((PathFindRequest)object).bCanThump = true;
            }
            this.testRequest.done = false;
            Object object3 = this.renderLock;
            synchronized (object3) {
                boolean bl3 = DebugOptions.instance.PolymapRenderClusters.getValue();
                if (this.findPath((PathFindRequest)object, bl3) && !((PathFindRequest)object).path.isEmpty()) {
                    float f6;
                    float f7;
                    IsoGridSquare isoGridSquare;
                    for (int node = 0; node < ((PathFindRequest)object).path.nodes.size() - 1; ++node) {
                        PathNode pathNode = ((PathFindRequest)object).path.nodes.get(node);
                        object2 = ((PathFindRequest)object).path.nodes.get(node + 1);
                        isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(pathNode.x, pathNode.y, pathNode.z);
                        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(((PathNode)object2).x, ((PathNode)object2).y, ((PathNode)object2).z);
                        f7 = isoGridSquare == null ? pathNode.z : this.getApparentZ(isoGridSquare);
                        f6 = isoGridSquare2 == null ? ((PathNode)object2).z : this.getApparentZ(isoGridSquare2);
                        float f8 = 1.0f;
                        float f11 = 1.0f;
                        float f12 = 0.0f;
                        if (f7 != (float)((int)f7) || f6 != (float)((int)f6)) {
                            f11 = 0.0f;
                        }
                        LineDrawer.addLine(pathNode.x, pathNode.y, f7, ((PathNode)object2).x, ((PathNode)object2).y, f6, f8, f11, f12, null, true);
                        LineDrawer.addRect(pathNode.x - 0.05f, pathNode.y - 0.05f, f7, 0.1f, 0.1f, f8, f11, f12);
                    }
                    PathFindBehavior2.closestPointOnPath(IsoPlayer.getInstance().x, IsoPlayer.getInstance().y, IsoPlayer.getInstance().z, IsoPlayer.getInstance(), ((PathFindRequest)object).path, this.pointOnPath);
                    Object object4 = ((PathFindRequest)object).path.nodes.get(this.pointOnPath.pathIndex);
                    PathNode pathNode = ((PathFindRequest)object).path.nodes.get(this.pointOnPath.pathIndex + 1);
                    object2 = IsoWorld.instance.CurrentCell.getGridSquare(((PathNode)object4).x, ((PathNode)object4).y, ((PathNode)object4).z);
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(pathNode.x, pathNode.y, pathNode.z);
                    float f13 = object2 == null ? ((PathNode)object4).z : this.getApparentZ((IsoGridSquare)object2);
                    f7 = isoGridSquare == null ? pathNode.z : this.getApparentZ(isoGridSquare);
                    f6 = f13 + (f7 - f13) * this.pointOnPath.dist;
                    LineDrawer.addLine(this.pointOnPath.x - 0.05f, this.pointOnPath.y - 0.05f, f6, this.pointOnPath.x + 0.05f, this.pointOnPath.y + 0.05f, f6, 0.0f, 1.0f, 0.0f, null, true);
                    LineDrawer.addLine(this.pointOnPath.x - 0.05f, this.pointOnPath.y + 0.05f, f6, this.pointOnPath.x + 0.05f, this.pointOnPath.y - 0.05f, f6, 0.0f, 1.0f, 0.0f, null, true);
                    if (GameKeyboard.isKeyDown(207) && !GameKeyboard.wasKeyDown(207) && (object4 = LuaManager.env.rawget((Object)"ISPathFindAction_pathToLocationF")) != null) {
                        LuaManager.caller.pcall(LuaManager.thread, object4, new Object[]{Float.valueOf(f42), Float.valueOf(f5), Float.valueOf(visibilityGraph2)});
                    }
                }
                ((PathFindRequest)object).release();
            }
        } else {
            for (int i = 0; i < this.testRequest.path.nodes.size() - 1; ++i) {
                PathNode pathNode = this.testRequest.path.nodes.get(i);
                PathNode pathNode2 = this.testRequest.path.nodes.get(i + 1);
                float f14 = 1.0f;
                float f15 = 1.0f;
                float f16 = 0.0f;
                if (pathNode.z != (float)((int)pathNode.z) || pathNode2.z != (float)((int)pathNode2.z)) {
                    f15 = 0.0f;
                }
                LineDrawer.addLine(pathNode.x, pathNode.y, pathNode.z, pathNode2.x, pathNode2.y, pathNode2.z, f14, f15, f16, null, true);
            }
            this.testRequest.done = false;
        }
        if (DebugOptions.instance.PolymapRenderConnections.getValue() && (visibilityGraph = this.getVisGraphAt(f4 = IsoUtils.XToIso(f3 = (float)Mouse.getX(), f2 = (float)Mouse.getY(), n = this.testZ), f = IsoUtils.YToIso(f3, f2, n), n, 1)) != null && (object = visibilityGraph.getClosestNodeTo(f4, f)) != null) {
            for (Connection connection : ((Node)object).visible) {
                Node node = connection.otherNode((Node)object);
                LineDrawer.addLine(((Node)object).x, ((Node)object).y, n, node.x, node.y, n, 1.0f, 0.0f, 0.0f, null, true);
            }
        }
        this.updateMain();
    }

    public void squareChanged(IsoGridSquare isoGridSquare) {
        SquareUpdateTask squareUpdateTask = SquareUpdateTask.alloc().init(this, isoGridSquare);
        this.squareTaskQueue.add(squareUpdateTask);
        this.thread.wake();
    }

    public void addChunkToWorld(IsoChunk isoChunk) {
        ChunkUpdateTask chunkUpdateTask = ChunkUpdateTask.alloc().init(this, isoChunk);
        this.chunkTaskQueue.add(chunkUpdateTask);
        this.thread.wake();
    }

    public void removeChunkFromWorld(IsoChunk isoChunk) {
        if (this.thread == null) {
            return;
        }
        ChunkRemoveTask chunkRemoveTask = ChunkRemoveTask.alloc().init(this, isoChunk);
        this.chunkTaskQueue.add(chunkRemoveTask);
        this.thread.wake();
    }

    public void addVehicleToWorld(BaseVehicle baseVehicle) {
        VehicleAddTask vehicleAddTask = VehicleAddTask.alloc();
        vehicleAddTask.init(this, baseVehicle);
        this.vehicleTaskQueue.add(vehicleAddTask);
        VehicleState vehicleState = VehicleState.alloc().init(baseVehicle);
        this.vehicleState.put(baseVehicle, vehicleState);
        this.thread.wake();
    }

    public void updateVehicle(BaseVehicle baseVehicle) {
        VehicleUpdateTask vehicleUpdateTask = VehicleUpdateTask.alloc();
        vehicleUpdateTask.init(this, baseVehicle);
        this.vehicleTaskQueue.add(vehicleUpdateTask);
        this.thread.wake();
    }

    public void removeVehicleFromWorld(BaseVehicle baseVehicle) {
        if (this.thread == null) {
            return;
        }
        VehicleRemoveTask vehicleRemoveTask = VehicleRemoveTask.alloc();
        vehicleRemoveTask.init(this, baseVehicle);
        this.vehicleTaskQueue.add(vehicleRemoveTask);
        VehicleState vehicleState = this.vehicleState.remove(baseVehicle);
        if (vehicleState != null) {
            vehicleState.vehicle = null;
            vehicleState.release();
        }
        this.thread.wake();
    }

    private Cell getCellFromSquarePos(int n, int n2) {
        if ((n -= this.minX * 300) < 0 || (n2 -= this.minY * 300) < 0) {
            return null;
        }
        int n3 = n / 300;
        int n4 = n2 / 300;
        if (n3 >= this.width || n4 >= this.height) {
            return null;
        }
        return this.cells[n3][n4];
    }

    private Cell getCellFromChunkPos(int n, int n2) {
        return this.getCellFromSquarePos(n * 10, n2 * 10);
    }

    private Chunk allocChunkIfNeeded(int n, int n2) {
        Cell cell = this.getCellFromChunkPos(n, n2);
        if (cell == null) {
            return null;
        }
        return cell.allocChunkIfNeeded(n, n2);
    }

    private Chunk getChunkFromChunkPos(int n, int n2) {
        Cell cell = this.getCellFromChunkPos(n, n2);
        if (cell == null) {
            return null;
        }
        return cell.getChunkFromChunkPos(n, n2);
    }

    private Chunk getChunkFromSquarePos(int n, int n2) {
        Cell cell = this.getCellFromSquarePos(n, n2);
        if (cell == null) {
            return null;
        }
        return cell.getChunkFromChunkPos(n / 10, n2 / 10);
    }

    private Square getSquare(int n, int n2, int n3) {
        Chunk chunk = this.getChunkFromSquarePos(n, n2);
        if (chunk == null) {
            return null;
        }
        return chunk.getSquare(n, n2, n3);
    }

    private boolean isBlockedInAllDirections(int n, int n2, int n3) {
        Square square = this.getSquare(n, n2, n3);
        if (square == null) {
            return false;
        }
        Square square2 = this.getSquare(n, n2 - 1, n3);
        Square square3 = this.getSquare(n, n2 + 1, n3);
        Square square4 = this.getSquare(n - 1, n2, n3);
        Square square5 = this.getSquare(n + 1, n2, n3);
        boolean bl = square2 != null && this.astar.canNotMoveBetween(square, square2, false);
        boolean bl2 = square3 != null && this.astar.canNotMoveBetween(square, square3, false);
        boolean bl3 = square4 != null && this.astar.canNotMoveBetween(square, square4, false);
        boolean bl4 = square5 != null && this.astar.canNotMoveBetween(square, square5, false);
        return bl && bl2 && bl3 && bl4;
    }

    public void init(IsoMetaGrid isoMetaGrid) {
        this.minX = isoMetaGrid.getMinX();
        this.minY = isoMetaGrid.getMinY();
        this.width = isoMetaGrid.getWidth();
        this.height = isoMetaGrid.getHeight();
        this.cells = new Cell[this.width][this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.cells[j][i] = Cell.alloc().init(this, this.minX + j, this.minY + i);
            }
        }
        this.thread = new PMThread();
        this.thread.setName("PolyPathThread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.thread.bStop = true;
        this.thread.wake();
        while (this.thread.isAlive()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.cells[j][i] == null) continue;
                this.cells[j][i].release();
            }
        }
        Object object = this.chunkTaskQueue.poll();
        while (object != null) {
            object.release();
            object = this.chunkTaskQueue.poll();
        }
        object = this.squareTaskQueue.poll();
        while (object != null) {
            ((SquareUpdateTask)object).release();
            object = this.squareTaskQueue.poll();
        }
        object = this.vehicleTaskQueue.poll();
        while (object != null) {
            object.release();
            object = this.vehicleTaskQueue.poll();
        }
        object = this.requestTaskQueue.poll();
        while (object != null) {
            ((PathRequestTask)object).release();
            object = this.requestTaskQueue.poll();
        }
        while (!this.requests.isEmpty()) {
            this.requests.removeLast().release();
        }
        while (!this.requestToMain.isEmpty()) {
            ((PathFindRequest)this.requestToMain.remove()).release();
        }
        for (int i = 0; i < this.vehicles.size(); ++i) {
            Vehicle vehicle = this.vehicles.get(i);
            vehicle.release();
        }
        for (VehicleState vehicleState : this.vehicleState.values()) {
            vehicleState.release();
        }
        this.requestMap.clear();
        this.vehicles.clear();
        this.vehicleState.clear();
        this.vehicleMap.clear();
        this.cells = null;
        this.thread = null;
        this.rebuild = true;
    }

    public void updateMain() {
        ArrayList<BaseVehicle> arrayList = IsoWorld.instance.CurrentCell.getVehicles();
        for (int i = 0; i < arrayList.size(); ++i) {
            BaseVehicle baseVehicle = arrayList.get(i);
            VehicleState vehicleState = this.vehicleState.get(baseVehicle);
            if (vehicleState == null || !vehicleState.check()) continue;
            this.updateVehicle(baseVehicle);
        }
        PathFindRequest pathFindRequest = this.requestToMain.poll();
        while (pathFindRequest != null) {
            if (this.requestMap.get(pathFindRequest.mover) == pathFindRequest) {
                this.requestMap.remove(pathFindRequest.mover);
            }
            if (!pathFindRequest.cancel) {
                if (pathFindRequest.path.isEmpty()) {
                    pathFindRequest.finder.Failed(pathFindRequest.mover);
                } else {
                    pathFindRequest.finder.Succeeded(pathFindRequest.path, pathFindRequest.mover);
                }
            }
            pathFindRequest.release();
            pathFindRequest = this.requestToMain.poll();
        }
    }

    public void updateThread() {
        Object object;
        Object object2 = this.chunkTaskQueue.poll();
        while (object2 != null) {
            object2.execute();
            object2.release();
            this.rebuild = true;
            object2 = this.chunkTaskQueue.poll();
        }
        object2 = this.squareTaskQueue.poll();
        while (object2 != null) {
            ((SquareUpdateTask)object2).execute();
            ((SquareUpdateTask)object2).release();
            object2 = this.squareTaskQueue.poll();
        }
        object2 = this.vehicleTaskQueue.poll();
        while (object2 != null) {
            object2.execute();
            object2.release();
            this.rebuild = true;
            object2 = this.vehicleTaskQueue.poll();
        }
        object2 = this.requestTaskQueue.poll();
        while (object2 != null) {
            ((PathRequestTask)object2).execute();
            ((PathRequestTask)object2).release();
            object2 = this.requestTaskQueue.poll();
        }
        if (this.rebuild) {
            for (int i = 0; i < this.graphs.size(); ++i) {
                object = this.graphs.get(i);
                ((VisibilityGraph)object).release();
            }
            this.squareToNode.forEachValue(this.releaseNodeProc);
            this.createVisibilityGraphs();
            this.rebuild = false;
            ChunkDataZ.EPOCH = (short)(ChunkDataZ.EPOCH + 1);
        }
        int n = 2;
        while (!this.requests.isEmpty()) {
            object = this.requests.removeFirst();
            if (((PathFindRequest)object).cancel) {
                this.requestToMain.add((PathFindRequest)object);
                continue;
            }
            try {
                this.findPath((PathFindRequest)object, false);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            if (!((PathFindRequest)object).targetXYZ.isEmpty()) {
                this.shortestPath.copyFrom(((PathFindRequest)object).path);
                float f = ((PathFindRequest)object).targetX;
                float f2 = ((PathFindRequest)object).targetY;
                float f3 = ((PathFindRequest)object).targetZ;
                float f4 = this.shortestPath.isEmpty() ? Float.MAX_VALUE : this.shortestPath.length();
                for (int i = 0; i < ((PathFindRequest)object).targetXYZ.size(); i += 3) {
                    float f5;
                    ((PathFindRequest)object).targetX = ((PathFindRequest)object).targetXYZ.get(i);
                    ((PathFindRequest)object).targetY = ((PathFindRequest)object).targetXYZ.get(i + 1);
                    ((PathFindRequest)object).targetZ = ((PathFindRequest)object).targetXYZ.get(i + 2);
                    ((PathFindRequest)object).path.clear();
                    this.findPath((PathFindRequest)object, false);
                    if (((PathFindRequest)object).path.isEmpty() || !((f5 = ((PathFindRequest)object).path.length()) < f4)) continue;
                    f4 = f5;
                    this.shortestPath.copyFrom(((PathFindRequest)object).path);
                    f = ((PathFindRequest)object).targetX;
                    f2 = ((PathFindRequest)object).targetY;
                    f3 = ((PathFindRequest)object).targetZ;
                }
                ((PathFindRequest)object).path.copyFrom(this.shortestPath);
                ((PathFindRequest)object).targetX = f;
                ((PathFindRequest)object).targetY = f2;
                ((PathFindRequest)object).targetZ = f3;
            }
            this.requestToMain.add((PathFindRequest)object);
            if (--n != 0) continue;
            break;
        }
    }

    public PathFindRequest addRequest(IPathfinder iPathfinder, Mover mover, float f, float f2, float f3, float f4, float f5, float f6) {
        this.cancelRequest(mover);
        PathFindRequest pathFindRequest = PathFindRequest.alloc().init(iPathfinder, mover, f, f2, f3, f4, f5, f6);
        this.requestMap.put(mover, pathFindRequest);
        PathRequestTask pathRequestTask = PathRequestTask.alloc().init(this, pathFindRequest);
        this.requestTaskQueue.add(pathRequestTask);
        this.thread.wake();
        return pathFindRequest;
    }

    public void cancelRequest(Mover mover) {
        PathFindRequest pathFindRequest = this.requestMap.remove(mover);
        if (pathFindRequest != null) {
            pathFindRequest.cancel = true;
        }
    }

    public ArrayList<Point> getPointInLine(float f, float f2, float f3, float f4, int n) {
        PointPool pointPool = new PointPool();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        this.supercover(f, f2, f3, f4, n, pointPool, arrayList);
        return arrayList;
    }

    private void supercover(float f, float f2, float f3, float f4, int n, PointPool pointPool, ArrayList<Point> arrayList) {
        int n2;
        double d;
        int n3;
        double d2 = Math.abs(f3 - f);
        double d3 = Math.abs(f4 - f2);
        int n4 = (int)Math.floor(f);
        int n5 = (int)Math.floor(f2);
        int n6 = 1;
        if (d2 == 0.0) {
            n3 = 0;
            d = Double.POSITIVE_INFINITY;
        } else if (f3 > f) {
            n3 = 1;
            n6 += (int)Math.floor(f3) - n4;
            d = (Math.floor(f) + 1.0 - (double)f) * d3;
        } else {
            n3 = -1;
            n6 += n4 - (int)Math.floor(f3);
            d = ((double)f - Math.floor(f)) * d3;
        }
        if (d3 == 0.0) {
            n2 = 0;
            d -= Double.POSITIVE_INFINITY;
        } else if (f4 > f2) {
            n2 = 1;
            n6 += (int)Math.floor(f4) - n5;
            d -= (Math.floor(f2) + 1.0 - (double)f2) * d2;
        } else {
            n2 = -1;
            n6 += n5 - (int)Math.floor(f4);
            d -= ((double)f2 - Math.floor(f2)) * d2;
        }
        while (n6 > 0) {
            Point point = pointPool.alloc().init(n4, n5);
            if (arrayList.contains(point)) {
                pointPool.release(point);
            } else {
                arrayList.add(point);
            }
            if (d > 0.0) {
                n5 += n2;
                d -= d2;
            } else {
                n4 += n3;
                d += d3;
            }
            --n6;
        }
    }

    public boolean lineClearCollide(float f, float f2, float f3, float f4, int n) {
        return this.lineClearCollide(f, f2, f3, f4, n, null);
    }

    public boolean lineClearCollide(float f, float f2, float f3, float f4, int n, IsoMovingObject isoMovingObject) {
        return this.lineClearCollide(f, f2, f3, f4, n, isoMovingObject, true, true);
    }

    public boolean lineClearCollide(float f, float f2, float f3, float f4, int n, IsoMovingObject isoMovingObject, boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        if (Core.bDebug && DebugOptions.instance.PolymapRenderLineClearCollide.getValue()) {
            n2 |= 8;
        }
        return this.lineClearCollide(f, f2, f3, f4, n, isoMovingObject, n2);
    }

    public boolean lineClearCollide(float f, float f2, float f3, float f4, int n, IsoMovingObject isoMovingObject, int n2) {
        BaseVehicle baseVehicle = null;
        if (isoMovingObject instanceof IsoGameCharacter) {
            baseVehicle = ((IsoGameCharacter)isoMovingObject).getVehicle();
        } else if (isoMovingObject instanceof BaseVehicle) {
            baseVehicle = (BaseVehicle)isoMovingObject;
        }
        return this.lccMain.isNotClear(this, f, f2, f3, f4, n, baseVehicle, n2);
    }

    public Vector2 getCollidepoint(float f, float f2, float f3, float f4, int n, IsoMovingObject isoMovingObject, int n2) {
        BaseVehicle baseVehicle = null;
        if (isoMovingObject instanceof IsoGameCharacter) {
            baseVehicle = ((IsoGameCharacter)isoMovingObject).getVehicle();
        } else if (isoMovingObject instanceof BaseVehicle) {
            baseVehicle = (BaseVehicle)isoMovingObject;
        }
        return this.lccMain.getCollidepoint(this, f, f2, f3, f4, n, baseVehicle, n2);
    }

    public boolean canStandAt(float f, float f2, int n, IsoMovingObject isoMovingObject, boolean bl, boolean bl2) {
        BaseVehicle baseVehicle = null;
        if (isoMovingObject instanceof IsoGameCharacter) {
            baseVehicle = ((IsoGameCharacter)isoMovingObject).getVehicle();
        } else if (isoMovingObject instanceof BaseVehicle) {
            baseVehicle = (BaseVehicle)isoMovingObject;
        }
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        if (Core.bDebug && DebugOptions.instance.PolymapRenderLineClearCollide.getValue()) {
            n2 |= 8;
        }
        return this.canStandAt(f, f2, n, baseVehicle, n2);
    }

    public boolean canStandAt(float f, float f2, int n, BaseVehicle baseVehicle, int n2) {
        return this.lccMain.canStandAtOld(this, f, f2, n, baseVehicle, n2);
    }

    public boolean intersectLineWithVehicle(float f, float f2, float f3, float f4, BaseVehicle baseVehicle, Vector2 vector22) {
        if (baseVehicle == null || baseVehicle.getScript() == null) {
            return false;
        }
        float[] fArray = this.tempFloats;
        fArray[0] = baseVehicle.getPoly().x1;
        fArray[1] = baseVehicle.getPoly().y1;
        fArray[2] = baseVehicle.getPoly().x2;
        fArray[3] = baseVehicle.getPoly().y2;
        fArray[4] = baseVehicle.getPoly().x3;
        fArray[5] = baseVehicle.getPoly().y3;
        fArray[6] = baseVehicle.getPoly().x4;
        fArray[7] = baseVehicle.getPoly().y4;
        float f5 = Float.MAX_VALUE;
        for (int i = 0; i < 8; i += 2) {
            float f6;
            float f7;
            float f8;
            float f9 = fArray[(i + 3) % 8];
            float f10 = fArray[(i + 1) % 8];
            float f11 = fArray[(i + 2) % 8];
            float f12 = fArray[i % 8];
            double d = (f9 - f10) * (f3 - f) - (f11 - f12) * (f4 - f2);
            if (d == 0.0) {
                return false;
            }
            double d2 = (double)((f11 - f12) * (f2 - f10) - (f9 - f10) * (f - f12)) / d;
            double d3 = (double)((f3 - f) * (f2 - f10) - (f4 - f2) * (f - f12)) / d;
            if (!(d2 >= 0.0) || !(d2 <= 1.0) || !(d3 >= 0.0) || !(d3 <= 1.0) || !((f8 = IsoUtils.DistanceTo(f, f2, f7 = (float)((double)f + d2 * (double)(f3 - f)), f6 = (float)((double)f2 + d2 * (double)(f4 - f2)))) < f5)) continue;
            vector22.set(f7, f6);
            f5 = f8;
        }
        return f5 < Float.MAX_VALUE;
    }

    public Vector2f resolveCollision(IsoGameCharacter isoGameCharacter, float f, float f2, Vector2f vector2f) {
        if (GameClient.bClient && isoGameCharacter.isSkipResolveCollision()) {
            return vector2f.set(f, f2);
        }
        return this.collideWithObstacles.resolveCollision(isoGameCharacter, f, f2, vector2f);
    }

    private static final class ClosestPointOnEdge {
        Edge edge;
        Node node;
        final Vector2f point = new Vector2f();
        double distSq;

        private ClosestPointOnEdge() {
        }
    }

    private static final class AdjustStartEndNodeData {
        Obstacle obstacle;
        Node node;
        Edge newEdge;
        boolean isNodeNew;
        VisibilityGraph graph;

        private AdjustStartEndNodeData() {
        }
    }

    private static final class LineClearCollide {
        final Vector2 perp = new Vector2();
        final ArrayList<Point> pts = new ArrayList();
        final VehicleRect sweepAABB = new VehicleRect();
        final VehicleRect vehicleAABB = new VehicleRect();
        final Vector2[] polyVec = new Vector2[4];
        final Vector2[] vehicleVec = new Vector2[4];
        final PointPool pointPool = new PointPool();
        final LiangBarsky LB = new LiangBarsky();

        LineClearCollide() {
            for (int i = 0; i < 4; ++i) {
                this.polyVec[i] = new Vector2();
                this.vehicleVec[i] = new Vector2();
            }
        }

        private float clamp(float f, float f2, float f3) {
            if (f < f2) {
                f = f2;
            }
            if (f > f3) {
                f = f3;
            }
            return f;
        }

        @Deprecated
        boolean canStandAt(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, float f5, Vehicle vehicle) {
            int n;
            if (((int)f != (int)f3 || (int)f2 != (int)f4) && polygonalMap2.isBlockedInAllDirections((int)f3, (int)f4, (int)f5)) {
                return false;
            }
            int n2 = (int)Math.floor(f3 - 0.3f);
            int n3 = (int)Math.floor(f4 - 0.3f);
            int n4 = (int)Math.ceil(f3 + 0.3f);
            int n5 = (int)Math.ceil(f4 + 0.3f);
            for (n = n3; n < n5; ++n) {
                for (int i = n2; i < n4; ++i) {
                    Square square = polygonalMap2.getSquare(i, n, (int)f5);
                    boolean bl = f3 >= (float)i && f4 >= (float)n && f3 < (float)(i + 1) && f4 < (float)(n + 1);
                    boolean bl2 = false;
                    if (!bl && square != null && square.has(448)) {
                        bl2 = f3 < (float)square.x || f3 >= (float)(square.x + 1) || square.has(64) && f4 < (float)square.y;
                    } else if (!bl && square != null && square.has(56)) {
                        boolean bl3 = bl2 = f4 < (float)square.y || f4 >= (float)(square.y + 1) || square.has(8) && f3 < (float)square.x;
                    }
                    if (square != null && !square.isReallySolid() && !bl2 && square.has(512) || !bl) continue;
                    return false;
                }
            }
            for (n = 0; n < polygonalMap2.vehicles.size(); ++n) {
                Vehicle vehicle2 = polygonalMap2.vehicles.get(n);
                if (vehicle2 == vehicle || (int)vehicle2.polyPlusRadius.z != (int)f5 || !vehicle2.polyPlusRadius.containsPoint(f3, f4)) continue;
                return false;
            }
            return true;
        }

        boolean canStandAtClipper(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, float f5, Vehicle vehicle, int n) {
            if (((int)f != (int)f3 || (int)f2 != (int)f4) && polygonalMap2.isBlockedInAllDirections((int)f3, (int)f4, (int)f5)) {
                return false;
            }
            Chunk chunk = polygonalMap2.getChunkFromSquarePos((int)f3, (int)f4);
            if (chunk == null) {
                return false;
            }
            ChunkDataZ chunkDataZ = chunk.collision.init(chunk, (int)f5);
            for (int i = 0; i < chunkDataZ.obstacles.size(); ++i) {
                Obstacle obstacle = chunkDataZ.obstacles.get(i);
                if (vehicle != null && obstacle.vehicle == vehicle || !obstacle.bounds.containsPoint(f3, f4) || !obstacle.isPointInside(f3, f4, n)) continue;
                return false;
            }
            return true;
        }

        float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
            return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        }

        boolean isPointInPolygon_WindingNumber(float f, float f2, VehiclePoly vehiclePoly) {
            this.polyVec[0].set(vehiclePoly.x1, vehiclePoly.y1);
            this.polyVec[1].set(vehiclePoly.x2, vehiclePoly.y2);
            this.polyVec[2].set(vehiclePoly.x3, vehiclePoly.y3);
            this.polyVec[3].set(vehiclePoly.x4, vehiclePoly.y4);
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                Vector2 vector22;
                Vector2 vector23 = this.polyVec[i];
                Vector2 vector24 = vector22 = i == 3 ? this.polyVec[0] : this.polyVec[i + 1];
                if (vector23.y <= f2) {
                    if (!(vector22.y > f2) || !(this.isLeft(vector23.x, vector23.y, vector22.x, vector22.y, f, f2) > 0.0f)) continue;
                    ++n;
                    continue;
                }
                if (!(vector22.y <= f2) || !(this.isLeft(vector23.x, vector23.y, vector22.x, vector22.y, f, f2) < 0.0f)) continue;
                --n;
            }
            return n != 0;
        }

        @Deprecated
        boolean isNotClearOld(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, int n2) {
            float f5;
            float f6;
            float f7;
            int n3;
            boolean bl = (n2 & 4) != 0;
            Square square = polygonalMap2.getSquare((int)f, (int)f2, n);
            if (square != null && square.has(504)) {
                return true;
            }
            if (!this.canStandAt(polygonalMap2, f, f2, f3, f4, n, null)) {
                return true;
            }
            float f8 = f4 - f2;
            float f9 = -(f3 - f);
            this.perp.set(f8, f9);
            this.perp.normalize();
            float f10 = f + this.perp.x * RADIUS_DIAGONAL;
            float f11 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f12 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f13 = f4 + this.perp.y * RADIUS_DIAGONAL;
            this.perp.set(-f8, -f9);
            this.perp.normalize();
            float f14 = f + this.perp.x * RADIUS_DIAGONAL;
            float f15 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f16 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f17 = f4 + this.perp.y * RADIUS_DIAGONAL;
            for (n3 = 0; n3 < this.pts.size(); ++n3) {
                this.pointPool.release(this.pts.get(n3));
            }
            this.pts.clear();
            this.pts.add(this.pointPool.alloc().init((int)f, (int)f2));
            if ((int)f != (int)f3 || (int)f2 != (int)f4) {
                this.pts.add(this.pointPool.alloc().init((int)f3, (int)f4));
            }
            polygonalMap2.supercover(f10, f11, f12, f13, n, this.pointPool, this.pts);
            polygonalMap2.supercover(f14, f15, f16, f17, n, this.pointPool, this.pts);
            for (n3 = 0; n3 < this.pts.size(); ++n3) {
                float f18;
                Point point = this.pts.get(n3);
                square = polygonalMap2.getSquare(point.x, point.y, n);
                if (bl && square != null && square.cost > 0) {
                    return true;
                }
                if (square == null || square.isReallySolid() || square.has(504) || !square.has(512)) {
                    f7 = 0.3f;
                    f6 = 0.3f;
                    f5 = 0.3f;
                    f18 = 0.3f;
                    if (f < (float)point.x && f3 < (float)point.x) {
                        f7 = 0.0f;
                    } else if (f >= (float)(point.x + 1) && f3 >= (float)(point.x + 1)) {
                        f5 = 0.0f;
                    }
                    if (f2 < (float)point.y && f4 < (float)point.y) {
                        f6 = 0.0f;
                    } else if (f2 >= (float)(point.y + 1) && f4 >= (float)(point.y + 1)) {
                        f18 = 0.0f;
                    }
                    if (!this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point.x - f7, (float)point.y - f6, (float)point.x + 1.0f + f5, (float)point.y + 1.0f + f18)) continue;
                    return true;
                }
                if (square.isCollideW()) {
                    f7 = 0.3f;
                    f6 = 0.3f;
                    f5 = 0.3f;
                    f18 = 0.3f;
                    if (f < (float)point.x && f3 < (float)point.x) {
                        f7 = 0.0f;
                    } else if (f >= (float)point.x && f3 >= (float)point.x) {
                        f5 = 0.0f;
                    }
                    if (f2 < (float)point.y && f4 < (float)point.y) {
                        f6 = 0.0f;
                    } else if (f2 >= (float)(point.y + 1) && f4 >= (float)(point.y + 1)) {
                        f18 = 0.0f;
                    }
                    if (this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point.x - f7, (float)point.y - f6, (float)point.x + f5, (float)point.y + 1.0f + f18)) {
                        return true;
                    }
                }
                if (!square.isCollideN()) continue;
                f7 = 0.3f;
                f6 = 0.3f;
                f5 = 0.3f;
                f18 = 0.3f;
                if (f < (float)point.x && f3 < (float)point.x) {
                    f7 = 0.0f;
                } else if (f >= (float)(point.x + 1) && f3 >= (float)(point.x + 1)) {
                    f5 = 0.0f;
                }
                if (f2 < (float)point.y && f4 < (float)point.y) {
                    f6 = 0.0f;
                } else if (f2 >= (float)point.y && f4 >= (float)point.y) {
                    f18 = 0.0f;
                }
                if (!this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point.x - f7, (float)point.y - f6, (float)point.x + 1.0f + f5, (float)point.y + f18)) continue;
                return true;
            }
            float f19 = BaseVehicle.PLUS_RADIUS;
            this.perp.set(f8, f9);
            this.perp.normalize();
            f10 = f + this.perp.x * f19;
            f11 = f2 + this.perp.y * f19;
            f12 = f3 + this.perp.x * f19;
            f13 = f4 + this.perp.y * f19;
            this.perp.set(-f8, -f9);
            this.perp.normalize();
            f14 = f + this.perp.x * f19;
            f15 = f2 + this.perp.y * f19;
            f16 = f3 + this.perp.x * f19;
            f17 = f4 + this.perp.y * f19;
            float f20 = Math.min(f10, Math.min(f12, Math.min(f14, f16)));
            f7 = Math.min(f11, Math.min(f13, Math.min(f15, f17)));
            f6 = Math.max(f10, Math.max(f12, Math.max(f14, f16)));
            f5 = Math.max(f11, Math.max(f13, Math.max(f15, f17)));
            this.sweepAABB.init((int)f20, (int)f7, (int)Math.ceil(f6) - (int)f20, (int)Math.ceil(f5) - (int)f7, n);
            this.polyVec[0].set(f10, f11);
            this.polyVec[1].set(f12, f13);
            this.polyVec[2].set(f16, f17);
            this.polyVec[3].set(f14, f15);
            for (int i = 0; i < polygonalMap2.vehicles.size(); ++i) {
                Vehicle vehicle = polygonalMap2.vehicles.get(i);
                VehicleRect vehicleRect = vehicle.poly.getAABB(this.vehicleAABB);
                if (!vehicleRect.intersects(this.sweepAABB) || !this.polyVehicleIntersect(vehicle.poly)) continue;
                return true;
            }
            return false;
        }

        boolean isNotClearClipper(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, int n2) {
            int n3;
            double d;
            int n4;
            boolean bl = (n2 & 4) != 0;
            Square square = polygonalMap2.getSquare((int)f, (int)f2, n);
            if (square != null && square.has(504)) {
                return true;
            }
            if (!this.canStandAtClipper(polygonalMap2, f, f2, f3, f4, n, null, n2)) {
                return true;
            }
            float f5 = f / 10.0f;
            float f6 = f2 / 10.0f;
            float f7 = f3 / 10.0f;
            float f8 = f4 / 10.0f;
            double d2 = Math.abs(f7 - f5);
            double d3 = Math.abs(f8 - f6);
            int n5 = (int)Math.floor(f5);
            int n6 = (int)Math.floor(f6);
            int n7 = 1;
            if (d2 == 0.0) {
                n4 = 0;
                d = Double.POSITIVE_INFINITY;
            } else if (f7 > f5) {
                n4 = 1;
                n7 += (int)Math.floor(f7) - n5;
                d = (Math.floor(f5) + 1.0 - (double)f5) * d3;
            } else {
                n4 = -1;
                n7 += n5 - (int)Math.floor(f7);
                d = ((double)f5 - Math.floor(f5)) * d3;
            }
            if (d3 == 0.0) {
                n3 = 0;
                d -= Double.POSITIVE_INFINITY;
            } else if (f8 > f6) {
                n3 = 1;
                n7 += (int)Math.floor(f8) - n6;
                d -= (Math.floor(f6) + 1.0 - (double)f6) * d2;
            } else {
                n3 = -1;
                n7 += n6 - (int)Math.floor(f8);
                d -= ((double)f6 - Math.floor(f6)) * d2;
            }
            while (n7 > 0) {
                Chunk chunk = instance.getChunkFromChunkPos(n5, n6);
                if (chunk != null) {
                    ChunkDataZ chunkDataZ = chunk.collision.init(chunk, n);
                    ArrayList<Obstacle> arrayList = chunkDataZ.obstacles;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Obstacle obstacle = arrayList.get(i);
                        if (!obstacle.lineSegmentIntersects(f, f2, f3, f4)) continue;
                        return true;
                    }
                }
                if (d > 0.0) {
                    n6 += n3;
                    d -= d2;
                } else {
                    n5 += n4;
                    d += d3;
                }
                --n7;
            }
            return bl && this.isNotClearCost(f, f2, f3, f4, n);
        }

        boolean isNotClearCost(float f, float f2, float f3, float f4, int n) {
            int n2;
            float f5 = f4 - f2;
            float f6 = -(f3 - f);
            this.perp.set(f5, f6);
            this.perp.normalize();
            float f7 = f + this.perp.x * RADIUS_DIAGONAL;
            float f8 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f9 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f10 = f4 + this.perp.y * RADIUS_DIAGONAL;
            this.perp.set(-f5, -f6);
            this.perp.normalize();
            float f11 = f + this.perp.x * RADIUS_DIAGONAL;
            float f12 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f13 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f14 = f4 + this.perp.y * RADIUS_DIAGONAL;
            for (n2 = 0; n2 < this.pts.size(); ++n2) {
                this.pointPool.release(this.pts.get(n2));
            }
            this.pts.clear();
            this.pts.add(this.pointPool.alloc().init((int)f, (int)f2));
            if ((int)f != (int)f3 || (int)f2 != (int)f4) {
                this.pts.add(this.pointPool.alloc().init((int)f3, (int)f4));
            }
            instance.supercover(f7, f8, f9, f10, n, this.pointPool, this.pts);
            instance.supercover(f11, f12, f13, f14, n, this.pointPool, this.pts);
            for (n2 = 0; n2 < this.pts.size(); ++n2) {
                Point point = this.pts.get(n2);
                Square square = instance.getSquare(point.x, point.y, n);
                if (square == null || square.cost <= 0) continue;
                return true;
            }
            return false;
        }

        boolean isNotClear(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, int n2) {
            return this.isNotClearOld(polygonalMap2, f, f2, f3, f4, n, n2);
        }

        boolean polyVehicleIntersect(VehiclePoly vehiclePoly) {
            this.vehicleVec[0].set(vehiclePoly.x1, vehiclePoly.y1);
            this.vehicleVec[1].set(vehiclePoly.x2, vehiclePoly.y2);
            this.vehicleVec[2].set(vehiclePoly.x3, vehiclePoly.y3);
            this.vehicleVec[3].set(vehiclePoly.x4, vehiclePoly.y4);
            boolean bl = false;
            for (int i = 0; i < 4; ++i) {
                Vector2 vector22 = this.polyVec[i];
                Vector2 vector23 = i == 3 ? this.polyVec[0] : this.polyVec[i + 1];
                for (int j = 0; j < 4; ++j) {
                    Vector2 vector24;
                    Vector2 vector25 = this.vehicleVec[j];
                    Vector2 vector26 = vector24 = j == 3 ? this.vehicleVec[0] : this.vehicleVec[j + 1];
                    if (!Line2D.linesIntersect(vector22.x, vector22.y, vector23.x, vector23.y, vector25.x, vector25.y, vector24.x, vector24.y)) continue;
                    bl = true;
                }
            }
            return bl;
        }
    }

    private static final class VGAStar
    extends AStar {
        ArrayList<VisibilityGraph> graphs;
        final ArrayList<SearchNode> searchNodes = new ArrayList();
        final TIntObjectHashMap<SearchNode> nodeMap = new TIntObjectHashMap();
        final GoalNode goalNode = new GoalNode();
        final TIntObjectHashMap<SearchNode> squareToNode = new TIntObjectHashMap();
        Mover mover;
        boolean bCanCrawl;
        boolean bIgnoreCrawlCost;
        boolean bCanThump;
        final TIntObjectHashMap<KnownBlockedEdges> knownBlockedEdges = new TIntObjectHashMap();
        final InitProc initProc = new InitProc();

        private VGAStar() {
        }

        VGAStar init(ArrayList<VisibilityGraph> arrayList, TIntObjectHashMap<Node> tIntObjectHashMap) {
            this.setMaxSteps(5000);
            this.graphs = arrayList;
            this.searchNodes.clear();
            this.nodeMap.clear();
            this.squareToNode.clear();
            this.mover = null;
            tIntObjectHashMap.forEachEntry((TIntObjectProcedure)this.initProc);
            return this;
        }

        VisibilityGraph getVisGraphForSquare(Square square) {
            for (int i = 0; i < this.graphs.size(); ++i) {
                VisibilityGraph visibilityGraph = this.graphs.get(i);
                if (!visibilityGraph.contains(square)) continue;
                return visibilityGraph;
            }
            return null;
        }

        boolean isSquareInCluster(Square square) {
            return this.getVisGraphForSquare(square) != null;
        }

        SearchNode getSearchNode(Node node) {
            if (node.square != null) {
                return this.getSearchNode(node.square);
            }
            SearchNode searchNode = (SearchNode)((Object)this.nodeMap.get(node.ID));
            if (searchNode == null) {
                searchNode = SearchNode.alloc().init(this, node);
                this.searchNodes.add(searchNode);
                this.nodeMap.put(node.ID, (Object)searchNode);
            }
            return searchNode;
        }

        SearchNode getSearchNode(Square square) {
            SearchNode searchNode = (SearchNode)((Object)this.squareToNode.get(square.ID.intValue()));
            if (searchNode == null) {
                searchNode = SearchNode.alloc().init(this, square);
                this.searchNodes.add(searchNode);
                this.squareToNode.put(square.ID.intValue(), (Object)searchNode);
            }
            return searchNode;
        }

        SearchNode getSearchNode(int n, int n2) {
            SearchNode searchNode = SearchNode.alloc().init(this, n, n2);
            this.searchNodes.add(searchNode);
            return searchNode;
        }

        ArrayList<ISearchNode> shortestPath(PathFindRequest pathFindRequest, SearchNode searchNode, SearchNode searchNode2) {
            this.mover = pathFindRequest.mover;
            this.bCanCrawl = pathFindRequest.bCanCrawl;
            this.bIgnoreCrawlCost = pathFindRequest.bIgnoreCrawlCost;
            this.bCanThump = pathFindRequest.bCanThump;
            this.goalNode.init(searchNode2);
            return this.shortestPath((ISearchNode)searchNode, this.goalNode);
        }

        boolean canNotMoveBetween(Square square, Square square2, boolean bl) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            assert (Math.abs(square.x - square2.x) <= 1);
            assert (Math.abs(square.y - square2.y) <= 1);
            assert (square.z == square2.z);
            assert (square != square2);
            if (square.x == 10921 && square.y == 10137 && square2.x == square.x - 1 && square2.y == square.y) {
                bl6 = true;
            }
            bl6 = square2.x < square.x;
            boolean bl7 = square2.x > square.x;
            boolean bl8 = square2.y < square.y;
            boolean bl9 = bl5 = square2.y > square.y;
            if (square2.isNonThumpableSolid() || !this.bCanThump && square2.isReallySolid()) {
                return true;
            }
            if (square2.y < square.y && square.has(64)) {
                return true;
            }
            if (square2.x < square.x && square.has(8)) {
                return true;
            }
            if (square2.y > square.y && square2.x == square.x && square2.has(64)) {
                return true;
            }
            if (square2.x > square.x && square2.y == square.y && square2.has(8)) {
                return true;
            }
            if (square2.x != square.x && square2.has(448)) {
                return true;
            }
            if (square2.y != square.y && square2.has(56)) {
                return true;
            }
            if (square2.x != square.x && square.has(448)) {
                return true;
            }
            if (square2.y != square.y && square.has(56)) {
                return true;
            }
            if (!square2.has(512) && !square2.has(504)) {
                return true;
            }
            if (this.isKnownBlocked(square, square2)) {
                return true;
            }
            if (square.x == 11920 && square2.y == 6803 && square2.has(131072)) {
                bl4 = true;
            }
            bl4 = square.isCanPathN() && (this.bCanThump || !square.isThumpN());
            boolean bl10 = square.isCanPathW() && (this.bCanThump || !square.isThumpW());
            boolean bl11 = bl8 && square.isCollideN() && (square.x != square2.x || bl || !bl4);
            boolean bl12 = bl6 && square.isCollideW() && (square.y != square2.y || bl || !bl10);
            bl4 = square2.isCanPathN() && (this.bCanThump || !square2.isThumpN());
            bl10 = square2.isCanPathW() && (this.bCanThump || !square2.isThumpW());
            boolean bl13 = bl5 && square2.has(131076) && (square.x != square2.x || bl || !bl4);
            boolean bl14 = bl3 = bl7 && square2.has(131074) && (square.y != square2.y || bl || !bl10);
            if (bl11 || bl12 || bl13 || bl3) {
                return true;
            }
            boolean bl15 = bl2 = square2.x != square.x && square2.y != square.y;
            if (bl2) {
                Square square3 = instance.getSquare(square.x, square2.y, square.z);
                Square square4 = instance.getSquare(square2.x, square.y, square.z);
                assert (square3 != square && square3 != square2);
                assert (square4 != square && square4 != square2);
                if (square2.x == square.x + 1 && square2.y == square.y + 1 && square3 != null && square4 != null) {
                    if (square3.has(4096) && square4.has(2048)) {
                        return true;
                    }
                    if (square3.isThumpN() && square4.isThumpW()) {
                        return true;
                    }
                }
                if (square2.x == square.x - 1 && square2.y == square.y - 1 && square3 != null && square4 != null) {
                    if (square3.has(2048) && square4.has(4096)) {
                        return true;
                    }
                    if (square3.isThumpW() && square4.isThumpN()) {
                        return true;
                    }
                }
                if (square3 != null && this.canNotMoveBetween(square, square3, true)) {
                    return true;
                }
                if (square4 != null && this.canNotMoveBetween(square, square4, true)) {
                    return true;
                }
                if (square3 != null && this.canNotMoveBetween(square2, square3, true)) {
                    return true;
                }
                if (square4 != null && this.canNotMoveBetween(square2, square4, true)) {
                    return true;
                }
            }
            return false;
        }

        boolean isKnownBlocked(Square square, Square square2) {
            if (square.z != square2.z) {
                return false;
            }
            KnownBlockedEdges knownBlockedEdges = (KnownBlockedEdges)this.knownBlockedEdges.get(square.ID.intValue());
            KnownBlockedEdges knownBlockedEdges2 = (KnownBlockedEdges)this.knownBlockedEdges.get(square2.ID.intValue());
            if (knownBlockedEdges != null && knownBlockedEdges.isBlocked(square2.x, square2.y)) {
                return true;
            }
            return knownBlockedEdges2 != null && knownBlockedEdges2.isBlocked(square.x, square.y);
        }

        final class InitProc
        implements TIntObjectProcedure<Node> {
            InitProc() {
            }

            public boolean execute(int n, Node node) {
                SearchNode searchNode = SearchNode.alloc().init(VGAStar.this, node);
                searchNode.square = node.square;
                VGAStar.this.squareToNode.put(n, (Object)searchNode);
                VGAStar.this.nodeMap.put(node.ID, (Object)searchNode);
                VGAStar.this.searchNodes.add(searchNode);
                return true;
            }
        }
    }

    private static final class TestRequest
    implements IPathfinder {
        final Path path = new Path();
        boolean done;

        private TestRequest() {
        }

        @Override
        public void Succeeded(Path path, Mover mover) {
            this.path.copyFrom(path);
            this.done = true;
        }

        @Override
        public void Failed(Mover mover) {
            this.path.clear();
            this.done = true;
        }
    }

    public static final class Path {
        final ArrayList<PathNode> nodes = new ArrayList();
        final ArrayDeque<PathNode> nodePool = new ArrayDeque();

        void clear() {
            for (int i = 0; i < this.nodes.size(); ++i) {
                this.nodePool.push(this.nodes.get(i));
            }
            this.nodes.clear();
        }

        boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        PathNode addNode(float f, float f2, float f3) {
            return this.addNode(f, f2, f3, 0);
        }

        PathNode addNode(float f, float f2, float f3, int n) {
            PathNode pathNode = this.nodePool.isEmpty() ? new PathNode() : this.nodePool.pop();
            pathNode.init(f, f2, f3, n);
            this.nodes.add(pathNode);
            return pathNode;
        }

        PathNode addNode(SearchNode searchNode) {
            return this.addNode(searchNode.getX(), searchNode.getY(), searchNode.getZ(), searchNode.vgNode == null ? 0 : searchNode.vgNode.flags);
        }

        PathNode getNode(int n) {
            return this.nodes.get(n);
        }

        PathNode getLastNode() {
            return this.nodes.get(this.nodes.size() - 1);
        }

        void copyFrom(Path path) {
            assert (this != path);
            this.clear();
            for (int i = 0; i < path.nodes.size(); ++i) {
                PathNode pathNode = path.nodes.get(i);
                this.addNode(pathNode.x, pathNode.y, pathNode.z, pathNode.flags);
            }
        }

        float length() {
            float f = 0.0f;
            for (int i = 0; i < this.nodes.size() - 1; ++i) {
                PathNode pathNode = this.nodes.get(i);
                PathNode pathNode2 = this.nodes.get(i + 1);
                f += IsoUtils.DistanceTo(pathNode.x, pathNode.y, pathNode.z, pathNode2.x, pathNode2.y, pathNode2.z);
            }
            return f;
        }

        public boolean crossesSquare(int n, int n2, int n3) {
            for (int i = 0; i < this.nodes.size() - 1; ++i) {
                PathNode pathNode = this.nodes.get(i);
                PathNode pathNode2 = this.nodes.get(i + 1);
                if ((int)pathNode.z != n3 && (int)pathNode2.z != n3) continue;
                if (Line2D.linesIntersect(pathNode.x, pathNode.y, pathNode2.x, pathNode2.y, n, n2, n + 1, n2)) {
                    return true;
                }
                if (Line2D.linesIntersect(pathNode.x, pathNode.y, pathNode2.x, pathNode2.y, n + 1, n2, n + 1, n2 + 1)) {
                    return true;
                }
                if (Line2D.linesIntersect(pathNode.x, pathNode.y, pathNode2.x, pathNode2.y, n + 1, n2 + 1, n, n2 + 1)) {
                    return true;
                }
                if (!Line2D.linesIntersect(pathNode.x, pathNode.y, pathNode2.x, pathNode2.y, n, n2 + 1, n, n2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Sync {
        private int fps = 20;
        private long period = 1000000000L / (long)this.fps;
        private long excess;
        private long beforeTime = System.nanoTime();
        private long overSleepTime = 0L;

        private Sync() {
        }

        void begin() {
            this.beforeTime = System.nanoTime();
            this.overSleepTime = 0L;
        }

        void startFrame() {
            this.excess = 0L;
        }

        void endFrame() {
            long l = System.nanoTime();
            long l2 = l - this.beforeTime;
            long l3 = this.period - l2 - this.overSleepTime;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3 / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.overSleepTime = System.nanoTime() - l - l3;
            } else {
                this.excess -= l3;
                this.overSleepTime = 0L;
            }
            this.beforeTime = System.nanoTime();
        }
    }

    private static final class RequestQueue {
        final ArrayDeque<PathFindRequest> playerQ = new ArrayDeque();
        final ArrayDeque<PathFindRequest> aggroZombieQ = new ArrayDeque();
        final ArrayDeque<PathFindRequest> otherQ = new ArrayDeque();

        private RequestQueue() {
        }

        boolean isEmpty() {
            return this.playerQ.isEmpty() && this.aggroZombieQ.isEmpty() && this.otherQ.isEmpty();
        }

        PathFindRequest removeFirst() {
            if (!this.playerQ.isEmpty()) {
                return this.playerQ.removeFirst();
            }
            if (!this.aggroZombieQ.isEmpty()) {
                return this.aggroZombieQ.removeFirst();
            }
            return this.otherQ.removeFirst();
        }

        PathFindRequest removeLast() {
            if (!this.otherQ.isEmpty()) {
                return this.otherQ.removeLast();
            }
            if (!this.aggroZombieQ.isEmpty()) {
                return this.aggroZombieQ.removeLast();
            }
            return this.playerQ.removeLast();
        }
    }

    private static final class LineClearCollideMain {
        final Vector2 perp = new Vector2();
        final ArrayList<Point> pts = new ArrayList();
        final VehicleRect sweepAABB = new VehicleRect();
        final VehicleRect vehicleAABB = new VehicleRect();
        final VehiclePoly vehiclePoly = new VehiclePoly();
        final Vector2[] polyVec = new Vector2[4];
        final Vector2[] vehicleVec = new Vector2[4];
        final PointPool pointPool = new PointPool();
        final LiangBarsky LB = new LiangBarsky();

        LineClearCollideMain() {
            for (int i = 0; i < 4; ++i) {
                this.polyVec[i] = new Vector2();
                this.vehicleVec[i] = new Vector2();
            }
        }

        private float clamp(float f, float f2, float f3) {
            if (f < f2) {
                f = f2;
            }
            if (f > f3) {
                f = f3;
            }
            return f;
        }

        @Deprecated
        boolean canStandAtOld(PolygonalMap2 polygonalMap2, float f, float f2, float f3, BaseVehicle baseVehicle, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            boolean bl = (n & 1) != 0;
            boolean bl2 = (n & 2) != 0;
            int n6 = (int)Math.floor(f - 0.3f);
            int n7 = (int)Math.floor(f2 - 0.3f);
            int n8 = (int)Math.ceil(f + 0.3f);
            int n9 = (int)Math.ceil(f2 + 0.3f);
            for (n5 = n7; n5 < n9; ++n5) {
                for (n4 = n6; n4 < n8; ++n4) {
                    float f4;
                    float f5;
                    float f6;
                    float f7;
                    float f8;
                    n3 = f >= (float)n4 && f2 >= (float)n5 && f < (float)(n4 + 1) && f2 < (float)(n5 + 1) ? 1 : 0;
                    IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, (int)f3);
                    n2 = 0;
                    if (n3 == 0 && isoGridSquare != null && isoGridSquare.HasStairsNorth()) {
                        n2 = f < (float)isoGridSquare.x || f >= (float)(isoGridSquare.x + 1) || isoGridSquare.Has(IsoObjectType.stairsTN) && f2 < (float)isoGridSquare.y ? 1 : 0;
                    } else if (n3 == 0 && isoGridSquare != null && isoGridSquare.HasStairsWest()) {
                        int n10 = n2 = f2 < (float)isoGridSquare.y || f2 >= (float)(isoGridSquare.y + 1) || isoGridSquare.Has(IsoObjectType.stairsTW) && f < (float)isoGridSquare.x ? 1 : 0;
                    }
                    if (isoGridSquare == null || isoGridSquare.isSolid() || isoGridSquare.isSolidTrans() && !isoGridSquare.isAdjacentToWindow() || n2 != 0 || !(!isoGridSquare.SolidFloorCached ? isoGridSquare.TreatAsSolidFloor() : isoGridSquare.SolidFloor)) {
                        if (!(bl2 ? n3 != 0 : (f8 = (f7 = f - (f6 = this.clamp(f, n4, n4 + 1))) * f7 + (f5 = f2 - (f4 = this.clamp(f2, n5, n5 + 1))) * f5) < 0.09f)) continue;
                        return false;
                    }
                    if (bl2) continue;
                    if ((isoGridSquare.Is(IsoFlagType.collideW) || !bl && isoGridSquare.hasBlockedDoor(false)) && (f8 = (f7 = f - (f6 = (float)n4)) * f7 + (f5 = f2 - (f4 = this.clamp(f2, n5, n5 + 1))) * f5) < 0.09f) {
                        return false;
                    }
                    if (!isoGridSquare.Is(IsoFlagType.collideN) && (bl || !isoGridSquare.hasBlockedDoor(true)) || !((f8 = (f7 = f - (f6 = this.clamp(f, n4, n4 + 1))) * f7 + (f5 = f2 - (f4 = (float)n5)) * f5) < 0.09f)) continue;
                    return false;
                }
            }
            n5 = ((int)f - 4) / 10 - 1;
            n4 = ((int)f2 - 4) / 10 - 1;
            n3 = (int)Math.ceil((f + 4.0f) / 10.0f) + 1;
            int n11 = (int)Math.ceil((f2 + 4.0f) / 10.0f) + 1;
            for (n2 = n4; n2 < n11; ++n2) {
                for (int i = n5; i < n3; ++i) {
                    IsoChunk isoChunk;
                    IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(i, n2) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(i * 10, n2 * 10, 0);
                    if (isoChunk == null) continue;
                    for (int j = 0; j < isoChunk.vehicles.size(); ++j) {
                        BaseVehicle baseVehicle2 = isoChunk.vehicles.get(j);
                        if (baseVehicle2 == baseVehicle || !baseVehicle2.addedToWorld || (int)baseVehicle2.z != (int)f3 || !baseVehicle2.getPolyPlusRadius().containsPoint(f, f2)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        boolean canStandAtClipper(PolygonalMap2 polygonalMap2, float f, float f2, float f3, BaseVehicle baseVehicle, int n) {
            return PolygonalMap2.instance.collideWithObstaclesPoly.canStandAt(f, f2, f3, baseVehicle, n);
        }

        public void drawCircle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            LineDrawer.DrawIsoCircle(f, f2, f3, f4, 16, f5, f6, f7, f8);
        }

        boolean isNotClearOld(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, BaseVehicle baseVehicle, int n2) {
            float f5;
            float f6;
            float f7;
            int n3;
            boolean bl = (n2 & 1) != 0;
            boolean bl2 = (n2 & 2) != 0;
            boolean bl3 = (n2 & 4) != 0;
            boolean bl4 = (n2 & 8) != 0;
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)f, (int)f2, n);
            if (isoGridSquare != null && isoGridSquare.HasStairs()) {
                return !isoGridSquare.isSameStaircase((int)f3, (int)f4, n);
            }
            if (!this.canStandAtOld(polygonalMap2, f3, f4, n, baseVehicle, n2)) {
                if (bl4) {
                    this.drawCircle(f3, f4, n, 0.3f, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                return true;
            }
            float f8 = f4 - f2;
            float f9 = -(f3 - f);
            this.perp.set(f8, f9);
            this.perp.normalize();
            float f10 = f + this.perp.x * RADIUS_DIAGONAL;
            float f11 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f12 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f13 = f4 + this.perp.y * RADIUS_DIAGONAL;
            this.perp.set(-f8, -f9);
            this.perp.normalize();
            float f14 = f + this.perp.x * RADIUS_DIAGONAL;
            float f15 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f16 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f17 = f4 + this.perp.y * RADIUS_DIAGONAL;
            for (n3 = 0; n3 < this.pts.size(); n3 += 1) {
                this.pointPool.release(this.pts.get(n3));
            }
            this.pts.clear();
            this.pts.add(this.pointPool.alloc().init((int)f, (int)f2));
            if ((int)f != (int)f3 || (int)f2 != (int)f4) {
                this.pts.add(this.pointPool.alloc().init((int)f3, (int)f4));
            }
            polygonalMap2.supercover(f10, f11, f12, f13, n, this.pointPool, this.pts);
            polygonalMap2.supercover(f14, f15, f16, f17, n, this.pointPool, this.pts);
            if (bl4) {
                for (n3 = 0; n3 < this.pts.size(); n3 += 1) {
                    Point point = this.pts.get(n3);
                    LineDrawer.addLine(point.x, point.y, n, (float)point.x + 1.0f, (float)point.y + 1.0f, n, 1.0f, 1.0f, 0.0f, null, false);
                }
            }
            n3 = 0;
            for (int i = 0; i < this.pts.size(); ++i) {
                float f18;
                Point point = this.pts.get(i);
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(point.x, point.y, n);
                if (bl3 && isoGridSquare != null && SquareUpdateTask.getCost(isoGridSquare) > 0) {
                    return true;
                }
                if (isoGridSquare == null || isoGridSquare.isSolid() || isoGridSquare.isSolidTrans() && !isoGridSquare.isAdjacentToWindow() || isoGridSquare.HasStairs() || !(!isoGridSquare.SolidFloorCached ? isoGridSquare.TreatAsSolidFloor() : isoGridSquare.SolidFloor)) {
                    f7 = 0.3f;
                    f6 = 0.3f;
                    f5 = 0.3f;
                    f18 = 0.3f;
                    if (f < (float)point.x && f3 < (float)point.x) {
                        f7 = 0.0f;
                    } else if (f >= (float)(point.x + 1) && f3 >= (float)(point.x + 1)) {
                        f5 = 0.0f;
                    }
                    if (f2 < (float)point.y && f4 < (float)point.y) {
                        f6 = 0.0f;
                    } else if (f2 >= (float)(point.y + 1) && f4 >= (float)(point.y + 1)) {
                        f18 = 0.0f;
                    }
                    if (!this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point.x - f7, (float)point.y - f6, (float)point.x + 1.0f + f5, (float)point.y + 1.0f + f18)) continue;
                    if (bl4) {
                        LineDrawer.addLine((float)point.x - f7, (float)point.y - f6, n, (float)point.x + 1.0f + f5, (float)point.y + 1.0f + f18, n, 1.0f, 0.0f, 0.0f, null, false);
                        n3 = 1;
                        continue;
                    }
                    return true;
                }
                if (isoGridSquare.Is(IsoFlagType.collideW) || !bl && isoGridSquare.hasBlockedDoor(false)) {
                    f7 = 0.3f;
                    f6 = 0.3f;
                    f5 = 0.3f;
                    f18 = 0.3f;
                    if (f < (float)point.x && f3 < (float)point.x) {
                        f7 = 0.0f;
                    } else if (f >= (float)point.x && f3 >= (float)point.x) {
                        f5 = 0.0f;
                    }
                    if (f2 < (float)point.y && f4 < (float)point.y) {
                        f6 = 0.0f;
                    } else if (f2 >= (float)(point.y + 1) && f4 >= (float)(point.y + 1)) {
                        f18 = 0.0f;
                    }
                    if (this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point.x - f7, (float)point.y - f6, (float)point.x + f5, (float)point.y + 1.0f + f18)) {
                        if (bl4) {
                            LineDrawer.addLine((float)point.x - f7, (float)point.y - f6, n, (float)point.x + f5, (float)point.y + 1.0f + f18, n, 1.0f, 0.0f, 0.0f, null, false);
                            n3 = 1;
                        } else {
                            return true;
                        }
                    }
                }
                if (!isoGridSquare.Is(IsoFlagType.collideN) && (bl || !isoGridSquare.hasBlockedDoor(true))) continue;
                f7 = 0.3f;
                f6 = 0.3f;
                f5 = 0.3f;
                f18 = 0.3f;
                if (f < (float)point.x && f3 < (float)point.x) {
                    f7 = 0.0f;
                } else if (f >= (float)(point.x + 1) && f3 >= (float)(point.x + 1)) {
                    f5 = 0.0f;
                }
                if (f2 < (float)point.y && f4 < (float)point.y) {
                    f6 = 0.0f;
                } else if (f2 >= (float)point.y && f4 >= (float)point.y) {
                    f18 = 0.0f;
                }
                if (!this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point.x - f7, (float)point.y - f6, (float)point.x + 1.0f + f5, (float)point.y + f18)) continue;
                if (bl4) {
                    LineDrawer.addLine((float)point.x - f7, (float)point.y - f6, n, (float)point.x + 1.0f + f5, (float)point.y + f18, n, 1.0f, 0.0f, 0.0f, null, false);
                    n3 = 1;
                    continue;
                }
                return true;
            }
            float f19 = BaseVehicle.PLUS_RADIUS;
            this.perp.set(f8, f9);
            this.perp.normalize();
            f10 = f + this.perp.x * f19;
            f11 = f2 + this.perp.y * f19;
            f12 = f3 + this.perp.x * f19;
            f13 = f4 + this.perp.y * f19;
            this.perp.set(-f8, -f9);
            this.perp.normalize();
            f14 = f + this.perp.x * f19;
            f15 = f2 + this.perp.y * f19;
            f16 = f3 + this.perp.x * f19;
            f17 = f4 + this.perp.y * f19;
            float f20 = Math.min(f10, Math.min(f12, Math.min(f14, f16)));
            f7 = Math.min(f11, Math.min(f13, Math.min(f15, f17)));
            f6 = Math.max(f10, Math.max(f12, Math.max(f14, f16)));
            f5 = Math.max(f11, Math.max(f13, Math.max(f15, f17)));
            this.sweepAABB.init((int)f20, (int)f7, (int)Math.ceil(f6) - (int)f20, (int)Math.ceil(f5) - (int)f7, n);
            this.polyVec[0].set(f10, f11);
            this.polyVec[1].set(f12, f13);
            this.polyVec[2].set(f16, f17);
            this.polyVec[3].set(f14, f15);
            int n4 = this.sweepAABB.left() / 10 - 1;
            int n5 = this.sweepAABB.top() / 10 - 1;
            int n6 = (int)Math.ceil((float)this.sweepAABB.right() / 10.0f) + 1;
            int n7 = (int)Math.ceil((float)this.sweepAABB.bottom() / 10.0f) + 1;
            for (int i = n5; i < n7; ++i) {
                for (int j = n4; j < n6; ++j) {
                    IsoChunk isoChunk;
                    IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                    if (isoChunk == null) continue;
                    for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                        BaseVehicle baseVehicle2 = isoChunk.vehicles.get(k);
                        if (baseVehicle2 == baseVehicle || baseVehicle2.VehicleID == -1) continue;
                        this.vehiclePoly.init(baseVehicle2.getPoly());
                        this.vehiclePoly.getAABB(this.vehicleAABB);
                        if (!this.vehicleAABB.intersects(this.sweepAABB) || !this.polyVehicleIntersect(this.vehiclePoly, bl4)) continue;
                        n3 = 1;
                        if (bl4) continue;
                        return true;
                    }
                }
            }
            return n3 != 0;
        }

        boolean isNotClearClipper(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, BaseVehicle baseVehicle, int n2) {
            boolean bl = (n2 & 1) != 0;
            boolean bl2 = (n2 & 2) != 0;
            boolean bl3 = (n2 & 4) != 0;
            boolean bl4 = (n2 & 8) != 0;
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)f, (int)f2, n);
            if (isoGridSquare != null && isoGridSquare.HasStairs()) {
                return !isoGridSquare.isSameStaircase((int)f3, (int)f4, n);
            }
            if (!this.canStandAtClipper(polygonalMap2, f3, f4, n, baseVehicle, n2)) {
                if (bl4) {
                    this.drawCircle(f3, f4, n, 0.3f, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                return true;
            }
            return PolygonalMap2.instance.collideWithObstaclesPoly.isNotClear(f, f2, f3, f4, n, bl4, baseVehicle, bl, bl2);
        }

        boolean isNotClear(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, BaseVehicle baseVehicle, int n2) {
            return this.isNotClearOld(polygonalMap2, f, f2, f3, f4, n, baseVehicle, n2);
        }

        Vector2 getCollidepoint(PolygonalMap2 polygonalMap2, float f, float f2, float f3, float f4, int n, BaseVehicle baseVehicle, int n2) {
            Point point3;
            int n3;
            boolean bl = (n2 & 1) != 0;
            boolean bl2 = (n2 & 2) != 0;
            boolean bl3 = (n2 & 4) != 0;
            boolean bl4 = (n2 & 8) != 0;
            float f5 = f4 - f2;
            float f6 = -(f3 - f);
            this.perp.set(f5, f6);
            this.perp.normalize();
            float f7 = f + this.perp.x * RADIUS_DIAGONAL;
            float f8 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f9 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f10 = f4 + this.perp.y * RADIUS_DIAGONAL;
            this.perp.set(-f5, -f6);
            this.perp.normalize();
            float f11 = f + this.perp.x * RADIUS_DIAGONAL;
            float f12 = f2 + this.perp.y * RADIUS_DIAGONAL;
            float f13 = f3 + this.perp.x * RADIUS_DIAGONAL;
            float f14 = f4 + this.perp.y * RADIUS_DIAGONAL;
            for (n3 = 0; n3 < this.pts.size(); ++n3) {
                this.pointPool.release(this.pts.get(n3));
            }
            this.pts.clear();
            this.pts.add(this.pointPool.alloc().init((int)f, (int)f2));
            if ((int)f != (int)f3 || (int)f2 != (int)f4) {
                this.pts.add(this.pointPool.alloc().init((int)f3, (int)f4));
            }
            polygonalMap2.supercover(f7, f8, f9, f10, n, this.pointPool, this.pts);
            polygonalMap2.supercover(f11, f12, f13, f14, n, this.pointPool, this.pts);
            this.pts.sort((point, point2) -> (int)(IsoUtils.DistanceManhatten(f, f2, point.x, point.y) - IsoUtils.DistanceManhatten(f, f2, point2.x, point2.y)));
            if (bl4) {
                for (n3 = 0; n3 < this.pts.size(); ++n3) {
                    point3 = this.pts.get(n3);
                    LineDrawer.addLine(point3.x, point3.y, n, (float)point3.x + 1.0f, (float)point3.y + 1.0f, n, 1.0f, 1.0f, 0.0f, null, false);
                }
            }
            for (n3 = 0; n3 < this.pts.size(); ++n3) {
                float f15;
                float f16;
                float f17;
                float f18;
                point3 = this.pts.get(n3);
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(point3.x, point3.y, n);
                if (bl3 && isoGridSquare != null && SquareUpdateTask.getCost(isoGridSquare) > 0) {
                    return temp.set((float)point3.x + 0.5f, (float)point3.y + 0.5f);
                }
                if (isoGridSquare == null || isoGridSquare.isSolid() || isoGridSquare.isSolidTrans() && !isoGridSquare.isAdjacentToWindow() || isoGridSquare.HasStairs() || !(!isoGridSquare.SolidFloorCached ? isoGridSquare.TreatAsSolidFloor() : isoGridSquare.SolidFloor)) {
                    f18 = 0.3f;
                    f17 = 0.3f;
                    f16 = 0.3f;
                    f15 = 0.3f;
                    if (f < (float)point3.x && f3 < (float)point3.x) {
                        f18 = 0.0f;
                    } else if (f >= (float)(point3.x + 1) && f3 >= (float)(point3.x + 1)) {
                        f16 = 0.0f;
                    }
                    if (f2 < (float)point3.y && f4 < (float)point3.y) {
                        f17 = 0.0f;
                    } else if (f2 >= (float)(point3.y + 1) && f4 >= (float)(point3.y + 1)) {
                        f15 = 0.0f;
                    }
                    if (!this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point3.x - f18, (float)point3.y - f17, (float)point3.x + 1.0f + f16, (float)point3.y + 1.0f + f15)) continue;
                    if (bl4) {
                        LineDrawer.addLine((float)point3.x - f18, (float)point3.y - f17, n, (float)point3.x + 1.0f + f16, (float)point3.y + 1.0f + f15, n, 1.0f, 0.0f, 0.0f, null, false);
                    }
                    return temp.set((float)point3.x + 0.5f, (float)point3.y + 0.5f);
                }
                if (isoGridSquare.Is(IsoFlagType.collideW) || !bl && isoGridSquare.hasBlockedDoor(false)) {
                    f18 = 0.3f;
                    f17 = 0.3f;
                    f16 = 0.3f;
                    f15 = 0.3f;
                    if (f < (float)point3.x && f3 < (float)point3.x) {
                        f18 = 0.0f;
                    } else if (f >= (float)point3.x && f3 >= (float)point3.x) {
                        f16 = 0.0f;
                    }
                    if (f2 < (float)point3.y && f4 < (float)point3.y) {
                        f17 = 0.0f;
                    } else if (f2 >= (float)(point3.y + 1) && f4 >= (float)(point3.y + 1)) {
                        f15 = 0.0f;
                    }
                    if (this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point3.x - f18, (float)point3.y - f17, (float)point3.x + f16, (float)point3.y + 1.0f + f15)) {
                        if (bl4) {
                            LineDrawer.addLine((float)point3.x - f18, (float)point3.y - f17, n, (float)point3.x + f16, (float)point3.y + 1.0f + f15, n, 1.0f, 0.0f, 0.0f, null, false);
                        }
                        return temp.set((float)point3.x + (f - f3 < 0.0f ? -0.5f : 0.5f), (float)point3.y + 0.5f);
                    }
                }
                if (!isoGridSquare.Is(IsoFlagType.collideN) && (bl || !isoGridSquare.hasBlockedDoor(true))) continue;
                f18 = 0.3f;
                f17 = 0.3f;
                f16 = 0.3f;
                f15 = 0.3f;
                if (f < (float)point3.x && f3 < (float)point3.x) {
                    f18 = 0.0f;
                } else if (f >= (float)(point3.x + 1) && f3 >= (float)(point3.x + 1)) {
                    f16 = 0.0f;
                }
                if (f2 < (float)point3.y && f4 < (float)point3.y) {
                    f17 = 0.0f;
                } else if (f2 >= (float)point3.y && f4 >= (float)point3.y) {
                    f15 = 0.0f;
                }
                if (!this.LB.lineRectIntersect(f, f2, f3 - f, f4 - f2, (float)point3.x - f18, (float)point3.y - f17, (float)point3.x + 1.0f + f16, (float)point3.y + f15)) continue;
                if (bl4) {
                    LineDrawer.addLine((float)point3.x - f18, (float)point3.y - f17, n, (float)point3.x + 1.0f + f16, (float)point3.y + f15, n, 1.0f, 0.0f, 0.0f, null, false);
                }
                return temp.set((float)point3.x + 0.5f, (float)point3.y + (f2 - f4 < 0.0f ? -0.5f : 0.5f));
            }
            return temp.set(f3, f4);
        }

        boolean polyVehicleIntersect(VehiclePoly vehiclePoly, boolean bl) {
            this.vehicleVec[0].set(vehiclePoly.x1, vehiclePoly.y1);
            this.vehicleVec[1].set(vehiclePoly.x2, vehiclePoly.y2);
            this.vehicleVec[2].set(vehiclePoly.x3, vehiclePoly.y3);
            this.vehicleVec[3].set(vehiclePoly.x4, vehiclePoly.y4);
            boolean bl2 = false;
            for (int i = 0; i < 4; ++i) {
                Vector2 vector22 = this.polyVec[i];
                Vector2 vector23 = i == 3 ? this.polyVec[0] : this.polyVec[i + 1];
                for (int j = 0; j < 4; ++j) {
                    Vector2 vector24;
                    Vector2 vector25 = this.vehicleVec[j];
                    Vector2 vector26 = vector24 = j == 3 ? this.vehicleVec[0] : this.vehicleVec[j + 1];
                    if (!Line2D.linesIntersect(vector22.x, vector22.y, vector23.x, vector23.y, vector25.x, vector25.y, vector24.x, vector24.y)) continue;
                    if (bl) {
                        LineDrawer.addLine(vector22.x, vector22.y, 0.0f, vector23.x, vector23.y, 0.0f, 1.0f, 0.0f, 0.0f, null, true);
                        LineDrawer.addLine(vector25.x, vector25.y, 0.0f, vector24.x, vector24.y, 0.0f, 1.0f, 0.0f, 0.0f, null, true);
                    }
                    bl2 = true;
                }
            }
            return bl2;
        }
    }

    private static final class VehicleRect {
        VehicleCluster cluster;
        Vehicle vehicle;
        int x;
        int y;
        int w;
        int h;
        int z;
        static final ArrayDeque<VehicleRect> pool = new ArrayDeque();

        private VehicleRect() {
        }

        VehicleRect init(Vehicle vehicle, int n, int n2, int n3, int n4, int n5) {
            this.cluster = null;
            this.vehicle = vehicle;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.z = n5;
            return this;
        }

        VehicleRect init(int n, int n2, int n3, int n4, int n5) {
            this.cluster = null;
            this.vehicle = null;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.z = n5;
            return this;
        }

        int left() {
            return this.x;
        }

        int top() {
            return this.y;
        }

        int right() {
            return this.x + this.w;
        }

        int bottom() {
            return this.y + this.h;
        }

        boolean containsPoint(float f, float f2, float f3) {
            return f >= (float)this.left() && f < (float)this.right() && f2 >= (float)this.top() && f2 < (float)this.bottom() && (int)f3 == this.z;
        }

        boolean containsPoint(float f, float f2, float f3, int n) {
            int n2 = this.x - n;
            int n3 = this.y - n;
            int n4 = this.right() + n;
            int n5 = this.bottom() + n;
            return f >= (float)n2 && f < (float)n4 && f2 >= (float)n3 && f2 < (float)n5 && (int)f3 == this.z;
        }

        boolean intersects(VehicleRect vehicleRect) {
            return this.left() < vehicleRect.right() && this.right() > vehicleRect.left() && this.top() < vehicleRect.bottom() && this.bottom() > vehicleRect.top();
        }

        boolean isAdjacent(VehicleRect vehicleRect) {
            --this.x;
            --this.y;
            this.w += 2;
            this.h += 2;
            boolean bl = this.intersects(vehicleRect);
            ++this.x;
            ++this.y;
            this.w -= 2;
            this.h -= 2;
            return bl;
        }

        static VehicleRect alloc() {
            if (pool.isEmpty()) {
                boolean bl = false;
            } else {
                boolean bl = false;
            }
            return pool.isEmpty() ? new VehicleRect() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class VehicleCluster {
        int z;
        final ArrayList<VehicleRect> rects = new ArrayList();
        static final ArrayDeque<VehicleCluster> pool = new ArrayDeque();

        private VehicleCluster() {
        }

        VehicleCluster init() {
            this.rects.clear();
            return this;
        }

        void merge(VehicleCluster vehicleCluster) {
            for (int i = 0; i < vehicleCluster.rects.size(); ++i) {
                VehicleRect vehicleRect = vehicleCluster.rects.get(i);
                vehicleRect.cluster = this;
            }
            this.rects.addAll(vehicleCluster.rects);
            vehicleCluster.rects.clear();
        }

        VehicleRect bounds() {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            int n4 = Integer.MIN_VALUE;
            for (int i = 0; i < this.rects.size(); ++i) {
                VehicleRect vehicleRect = this.rects.get(i);
                n = Math.min(n, vehicleRect.left());
                n2 = Math.min(n2, vehicleRect.top());
                n3 = Math.max(n3, vehicleRect.right());
                n4 = Math.max(n4, vehicleRect.bottom());
            }
            return VehicleRect.alloc().init(n, n2, n3 - n, n4 - n2, this.z);
        }

        static VehicleCluster alloc() {
            return pool.isEmpty() ? new VehicleCluster() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class Vehicle {
        final VehiclePoly poly = new VehiclePoly();
        final VehiclePoly polyPlusRadius = new VehiclePoly();
        final TFloatArrayList crawlOffsets = new TFloatArrayList();
        float upVectorDot;
        static final ArrayDeque<Vehicle> pool = new ArrayDeque();

        private Vehicle() {
        }

        static Vehicle alloc() {
            return pool.isEmpty() ? new Vehicle() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    public static final class VehiclePoly {
        public Transform t = new Transform();
        public float x1;
        public float y1;
        public float x2;
        public float y2;
        public float x3;
        public float y3;
        public float x4;
        public float y4;
        public float z;
        public final Vector2[] borders = new Vector2[4];
        private static final Quaternionf tempQuat = new Quaternionf();

        VehiclePoly() {
            for (int i = 0; i < this.borders.length; ++i) {
                this.borders[i] = new Vector2();
            }
        }

        VehiclePoly init(VehiclePoly vehiclePoly) {
            this.x1 = vehiclePoly.x1;
            this.y1 = vehiclePoly.y1;
            this.x2 = vehiclePoly.x2;
            this.y2 = vehiclePoly.y2;
            this.x3 = vehiclePoly.x3;
            this.y3 = vehiclePoly.y3;
            this.x4 = vehiclePoly.x4;
            this.y4 = vehiclePoly.y4;
            this.z = vehiclePoly.z;
            return this;
        }

        VehiclePoly init(BaseVehicle baseVehicle, float f) {
            Vector2 vector22;
            Vector2 vector23;
            VehicleScript vehicleScript = baseVehicle.getScript();
            Vector3f vector3f = vehicleScript.getExtents();
            Vector3f vector3f2 = vehicleScript.getCenterOfMassOffset();
            float f2 = 1.0f;
            Vector2[] vector2Array = this.borders;
            Quaternionf quaternionf = tempQuat;
            baseVehicle.getWorldTransform(this.t);
            this.t.getRotation(quaternionf);
            float f3 = vector3f.x * f2 + f * 2.0f;
            float f4 = vector3f.z * f2 + f * 2.0f;
            float f5 = vector3f.y * f2 + f * 2.0f;
            f3 /= 2.0f;
            f4 /= 2.0f;
            f5 /= 2.0f;
            Vector3f vector3f3 = tempVec3f_1;
            if (quaternionf.x < 0.0f) {
                baseVehicle.getWorldPos(vector3f2.x - f3, 0.0f, vector3f2.z + f4, vector3f3);
                vector2Array[0].set(vector3f3.x, vector3f3.y);
                baseVehicle.getWorldPos(vector3f2.x + f3, f5, vector3f2.z + f4, vector3f3);
                vector2Array[1].set(vector3f3.x, vector3f3.y);
                baseVehicle.getWorldPos(vector3f2.x + f3, f5, vector3f2.z - f4, vector3f3);
                vector2Array[2].set(vector3f3.x, vector3f3.y);
                baseVehicle.getWorldPos(vector3f2.x - f3, 0.0f, vector3f2.z - f4, vector3f3);
                vector2Array[3].set(vector3f3.x, vector3f3.y);
                this.z = baseVehicle.z;
            } else {
                baseVehicle.getWorldPos(vector3f2.x - f3, f5, vector3f2.z + f4, vector3f3);
                vector2Array[0].set(vector3f3.x, vector3f3.y);
                baseVehicle.getWorldPos(vector3f2.x + f3, 0.0f, vector3f2.z + f4, vector3f3);
                vector2Array[1].set(vector3f3.x, vector3f3.y);
                baseVehicle.getWorldPos(vector3f2.x + f3, 0.0f, vector3f2.z - f4, vector3f3);
                vector2Array[2].set(vector3f3.x, vector3f3.y);
                baseVehicle.getWorldPos(vector3f2.x - f3, f5, vector3f2.z - f4, vector3f3);
                vector2Array[3].set(vector3f3.x, vector3f3.y);
                this.z = baseVehicle.z;
            }
            int n = 0;
            for (int i = 0; i < vector2Array.length; ++i) {
                vector23 = vector2Array[i];
                vector22 = vector2Array[(i + 1) % vector2Array.length];
                n = (int)((float)n + (vector22.x - vector23.x) * (vector22.y + vector23.y));
            }
            if (n < 0) {
                Vector2 vector24 = vector2Array[1];
                vector23 = vector2Array[2];
                vector2Array[1] = vector22 = vector2Array[3];
                vector2Array[2] = vector23;
                vector2Array[3] = vector24;
            }
            this.x1 = vector2Array[0].x;
            this.y1 = vector2Array[0].y;
            this.x2 = vector2Array[1].x;
            this.y2 = vector2Array[1].y;
            this.x3 = vector2Array[2].x;
            this.y3 = vector2Array[2].y;
            this.x4 = vector2Array[3].x;
            this.y4 = vector2Array[3].y;
            return this;
        }

        public static Vector2 lineIntersection(Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
            Vector2 vector26 = new Vector2();
            float f = vector22.y - vector23.y;
            float f2 = vector23.x - vector22.x;
            float f3 = -f * vector22.x - f2 * vector22.y;
            float f4 = vector24.y - vector25.y;
            float f5 = vector25.x - vector24.x;
            float f6 = -f4 * vector24.x - f5 * vector24.y;
            float f7 = QuadranglesIntersection.det(f, f2, f4, f5);
            if (f7 != 0.0f) {
                vector26.x = -QuadranglesIntersection.det(f3, f2, f6, f5) * 1.0f / f7;
                vector26.y = -QuadranglesIntersection.det(f, f3, f4, f6) * 1.0f / f7;
                return vector26;
            }
            return null;
        }

        VehicleRect getAABB(VehicleRect vehicleRect) {
            float f = Math.min(this.x1, Math.min(this.x2, Math.min(this.x3, this.x4)));
            float f2 = Math.min(this.y1, Math.min(this.y2, Math.min(this.y3, this.y4)));
            float f3 = Math.max(this.x1, Math.max(this.x2, Math.max(this.x3, this.x4)));
            float f4 = Math.max(this.y1, Math.max(this.y2, Math.max(this.y3, this.y4)));
            return vehicleRect.init(null, (int)f, (int)f2, (int)Math.ceil(f3) - (int)f, (int)Math.ceil(f4) - (int)f2, (int)this.z);
        }

        float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
            return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        }

        public boolean containsPoint(float f, float f2) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                Vector2 vector22;
                Vector2 vector23 = this.borders[i];
                Vector2 vector24 = vector22 = i == 3 ? this.borders[0] : this.borders[i + 1];
                if (vector23.y <= f2) {
                    if (!(vector22.y > f2) || !(this.isLeft(vector23.x, vector23.y, vector22.x, vector22.y, f, f2) > 0.0f)) continue;
                    ++n;
                    continue;
                }
                if (!(vector22.y <= f2) || !(this.isLeft(vector23.x, vector23.y, vector22.x, vector22.y, f, f2) < 0.0f)) continue;
                --n;
            }
            return n != 0;
        }
    }

    private static final class Square {
        static int nextID = 1;
        Integer ID = nextID++;
        int x;
        int y;
        int z;
        int bits;
        short cost;
        static final ArrayDeque<Square> pool = new ArrayDeque();

        Square() {
        }

        Square init(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            return this;
        }

        boolean has(int n) {
            return (this.bits & n) != 0;
        }

        boolean isReallySolid() {
            return this.has(1) || this.has(1024) && !this.isAdjacentToWindow();
        }

        boolean isNonThumpableSolid() {
            return this.isReallySolid() && !this.has(131072);
        }

        boolean isCanPathW() {
            if (this.has(8192)) {
                return true;
            }
            Square square = instance.getSquare(this.x - 1, this.y, this.z);
            return square != null && (square.has(131072) || square.has(262144));
        }

        boolean isCanPathN() {
            if (this.has(16384)) {
                return true;
            }
            Square square = instance.getSquare(this.x, this.y - 1, this.z);
            return square != null && (square.has(131072) || square.has(524288));
        }

        boolean isCollideW() {
            if (this.has(2)) {
                return true;
            }
            Square square = instance.getSquare(this.x - 1, this.y, this.z);
            return square != null && (square.has(262144) || square.has(448) || square.isReallySolid());
        }

        boolean isCollideN() {
            if (this.has(4)) {
                return true;
            }
            Square square = instance.getSquare(this.x, this.y - 1, this.z);
            return square != null && (square.has(524288) || square.has(56) || square.isReallySolid());
        }

        boolean isThumpW() {
            if (this.has(32768)) {
                return true;
            }
            Square square = instance.getSquare(this.x - 1, this.y, this.z);
            return square != null && square.has(131072);
        }

        boolean isThumpN() {
            if (this.has(65536)) {
                return true;
            }
            Square square = instance.getSquare(this.x, this.y - 1, this.z);
            return square != null && square.has(131072);
        }

        boolean isAdjacentToWindow() {
            if (this.has(2048) || this.has(4096)) {
                return true;
            }
            Square square = instance.getSquare(this.x, this.y + 1, this.z);
            if (square != null && square.has(4096)) {
                return true;
            }
            Square square2 = instance.getSquare(this.x + 1, this.y, this.z);
            return square2 != null && square2.has(2048);
        }

        static Square alloc() {
            return pool.isEmpty() ? new Square() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class Node {
        static int nextID = 1;
        final int ID;
        float x;
        float y;
        int z;
        boolean ignore;
        Square square;
        ArrayList<VisibilityGraph> graphs;
        final ArrayList<Edge> edges = new ArrayList();
        final ArrayList<Connection> visible = new ArrayList();
        int flags = 0;
        static final ArrayList<Obstacle> tempObstacles = new ArrayList();
        static final ArrayDeque<Node> pool = new ArrayDeque();

        Node() {
            this.ID = nextID++;
        }

        Node init(float f, float f2, int n) {
            this.x = f;
            this.y = f2;
            this.z = n;
            this.ignore = false;
            this.square = null;
            if (this.graphs != null) {
                this.graphs.clear();
            }
            this.edges.clear();
            this.visible.clear();
            this.flags = 0;
            return this;
        }

        Node init(Square square) {
            this.x = (float)square.x + 0.5f;
            this.y = (float)square.y + 0.5f;
            this.z = square.z;
            this.ignore = false;
            this.square = square;
            if (this.graphs != null) {
                this.graphs.clear();
            }
            this.edges.clear();
            this.visible.clear();
            this.flags = 0;
            return this;
        }

        Node setXY(float f, float f2) {
            this.x = f;
            this.y = f2;
            return this;
        }

        void addGraph(VisibilityGraph visibilityGraph) {
            if (this.graphs == null) {
                this.graphs = new ArrayList();
            }
            assert (!this.graphs.contains(visibilityGraph));
            this.graphs.add(visibilityGraph);
        }

        boolean sharesEdge(Node node) {
            for (int i = 0; i < this.edges.size(); ++i) {
                Edge edge = this.edges.get(i);
                if (!edge.hasNode(node)) continue;
                return true;
            }
            return false;
        }

        boolean sharesShape(Node node) {
            for (int i = 0; i < this.edges.size(); ++i) {
                Edge edge = this.edges.get(i);
                for (int j = 0; j < node.edges.size(); ++j) {
                    Edge edge2 = node.edges.get(j);
                    if (edge.obstacle == null || edge.obstacle != edge2.obstacle) continue;
                    return true;
                }
            }
            return false;
        }

        void getObstacles(ArrayList<Obstacle> arrayList) {
            for (int i = 0; i < this.edges.size(); ++i) {
                Edge edge = this.edges.get(i);
                if (arrayList.contains(edge.obstacle)) continue;
                arrayList.add(edge.obstacle);
            }
        }

        boolean onSameShapeButDoesNotShareAnEdge(Node node) {
            tempObstacles.clear();
            this.getObstacles(tempObstacles);
            for (int i = 0; i < tempObstacles.size(); ++i) {
                Obstacle obstacle = tempObstacles.get(i);
                if (!obstacle.hasNode(node) || obstacle.hasAdjacentNodes(this, node)) continue;
                return true;
            }
            return false;
        }

        boolean hasFlag(int n) {
            return (this.flags & n) != 0;
        }

        boolean isConnectedTo(Node node) {
            if (this.hasFlag(4)) {
                return true;
            }
            for (int i = 0; i < this.visible.size(); ++i) {
                Connection connection = this.visible.get(i);
                if (connection.node1 != node && connection.node2 != node) continue;
                return true;
            }
            return false;
        }

        static Node alloc() {
            if (pool.isEmpty()) {
                boolean bl = false;
            } else {
                boolean bl = false;
            }
            return pool.isEmpty() ? new Node() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            for (int i = this.visible.size() - 1; i >= 0; --i) {
                instance.breakConnection(this.visible.get(i));
            }
            pool.push(this);
        }

        static void releaseAll(ArrayList<Node> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).release();
            }
        }
    }

    private static final class VisibilityGraph {
        boolean created;
        VehicleCluster cluster;
        final ArrayList<Node> nodes = new ArrayList();
        final ArrayList<Edge> edges = new ArrayList();
        final ArrayList<Obstacle> obstacles = new ArrayList();
        final ArrayList<Node> intersectNodes = new ArrayList();
        final ArrayList<Node> perimeterNodes = new ArrayList();
        final ArrayList<Edge> perimeterEdges = new ArrayList();
        final ArrayList<Node> obstacleTraceNodes = new ArrayList();
        final TIntArrayList splitXY = new TIntArrayList();
        static final CompareIntersection comparator = new CompareIntersection();
        private static final ClusterOutlineGrid clusterOutlineGrid = new ClusterOutlineGrid();
        private static final ArrayDeque<VisibilityGraph> pool = new ArrayDeque();

        private VisibilityGraph() {
        }

        VisibilityGraph init(VehicleCluster vehicleCluster) {
            this.created = false;
            this.cluster = vehicleCluster;
            this.edges.clear();
            this.nodes.clear();
            this.obstacles.clear();
            this.intersectNodes.clear();
            this.perimeterEdges.clear();
            this.perimeterNodes.clear();
            return this;
        }

        void addEdgesForVehicle(Vehicle vehicle) {
            VehiclePoly vehiclePoly = vehicle.polyPlusRadius;
            int n = (int)vehiclePoly.z;
            Node node = Node.alloc().init(vehiclePoly.x1, vehiclePoly.y1, n);
            Node node2 = Node.alloc().init(vehiclePoly.x2, vehiclePoly.y2, n);
            Node node3 = Node.alloc().init(vehiclePoly.x3, vehiclePoly.y3, n);
            Node node4 = Node.alloc().init(vehiclePoly.x4, vehiclePoly.y4, n);
            Obstacle obstacle = Obstacle.alloc().init(vehicle);
            this.obstacles.add(obstacle);
            Edge edge = Edge.alloc().init(node, node2, obstacle, obstacle.outer);
            Edge edge2 = Edge.alloc().init(node2, node3, obstacle, obstacle.outer);
            Edge edge3 = Edge.alloc().init(node3, node4, obstacle, obstacle.outer);
            Edge edge4 = Edge.alloc().init(node4, node, obstacle, obstacle.outer);
            obstacle.outer.add(edge);
            obstacle.outer.add(edge2);
            obstacle.outer.add(edge3);
            obstacle.outer.add(edge4);
            obstacle.calcBounds();
            this.nodes.add(node);
            this.nodes.add(node2);
            this.nodes.add(node3);
            this.nodes.add(node4);
            this.edges.add(edge);
            this.edges.add(edge2);
            this.edges.add(edge3);
            this.edges.add(edge4);
            if (vehicle.upVectorDot < 0.95f) {
                return;
            }
            obstacle.nodeCrawlFront = Node.alloc().init((vehiclePoly.x1 + vehiclePoly.x2) / 2.0f, (vehiclePoly.y1 + vehiclePoly.y2) / 2.0f, n);
            obstacle.nodeCrawlRear = Node.alloc().init((vehiclePoly.x3 + vehiclePoly.x4) / 2.0f, (vehiclePoly.y3 + vehiclePoly.y4) / 2.0f, n);
            obstacle.nodeCrawlFront.flags |= 1;
            obstacle.nodeCrawlRear.flags |= 1;
            this.nodes.add(obstacle.nodeCrawlFront);
            this.nodes.add(obstacle.nodeCrawlRear);
            Edge edge5 = edge.split(obstacle.nodeCrawlFront);
            Edge edge6 = edge3.split(obstacle.nodeCrawlRear);
            this.edges.add(edge5);
            this.edges.add(edge6);
            BaseVehicle.Vector2fObjectPool vector2fObjectPool = BaseVehicle.TL_vector2f_pool.get();
            Vector2f vector2f = (Vector2f)vector2fObjectPool.alloc();
            Vector2f vector2f2 = (Vector2f)vector2fObjectPool.alloc();
            obstacle.crawlNodes.clear();
            for (int i = 0; i < vehicle.crawlOffsets.size(); ++i) {
                float f = vehicle.crawlOffsets.get(i);
                vector2f.set(node3.x, node3.y);
                vector2f2.set(node2.x, node2.y);
                vector2f2.sub((Vector2fc)vector2f).mul(f).add((Vector2fc)vector2f);
                Node node5 = Node.alloc().init(vector2f2.x, vector2f2.y, n);
                node5.flags |= 1;
                vector2f.set(node4.x, node4.y);
                vector2f2.set(node.x, node.y);
                vector2f2.sub((Vector2fc)vector2f).mul(f).add((Vector2fc)vector2f);
                Node node6 = Node.alloc().init(vector2f2.x, vector2f2.y, n);
                node6.flags |= 1;
                Node node7 = Node.alloc().init((node5.x + node6.x) / 2.0f, (node5.y + node6.y) / 2.0f, n);
                node7.flags |= 3;
                obstacle.crawlNodes.add(node5);
                obstacle.crawlNodes.add(node7);
                obstacle.crawlNodes.add(node6);
                this.nodes.add(node5);
                this.nodes.add(node7);
                this.nodes.add(node6);
                Edge edge7 = edge2.split(node5);
                edge4 = edge4.split(node6);
                this.edges.add(edge7);
                this.edges.add(edge4);
            }
            vector2fObjectPool.release(vector2f);
            vector2fObjectPool.release(vector2f2);
        }

        boolean isVisible(Node node, Node node2) {
            Edge edge;
            int n;
            if (node.sharesEdge(node2)) {
                return !node.onSameShapeButDoesNotShareAnEdge(node2);
            }
            if (node.sharesShape(node2)) {
                return false;
            }
            for (n = 0; n < this.edges.size(); ++n) {
                edge = this.edges.get(n);
                if (!this.intersects(node, node2, edge)) continue;
                return false;
            }
            for (n = 0; n < this.perimeterEdges.size(); ++n) {
                edge = this.perimeterEdges.get(n);
                if (!this.intersects(node, node2, edge)) continue;
                return false;
            }
            return true;
        }

        boolean intersects(Node node, Node node2, Edge edge) {
            if (edge.hasNode(node) || edge.hasNode(node2)) {
                return false;
            }
            return Line2D.linesIntersect(node.x, node.y, node2.x, node2.y, edge.node1.x, edge.node1.y, edge.node2.x, edge.node2.y);
        }

        public Intersection getIntersection(Edge edge, Edge edge2) {
            float f = edge2.node2.y;
            float f2 = edge2.node1.y;
            float f3 = edge.node2.x;
            float f4 = edge.node1.x;
            float f5 = edge2.node2.x;
            float f6 = edge2.node1.x;
            float f7 = edge.node2.y;
            float f8 = edge.node1.y;
            double d = (f - f2) * (f3 - f4) - (f5 - f6) * (f7 - f8);
            if (d == 0.0) {
                return null;
            }
            double d2 = (double)((f5 - f6) * (f8 - f2) - (f - f2) * (f4 - f6)) / d;
            double d3 = (double)((f3 - f4) * (f8 - f2) - (f7 - f8) * (f4 - f6)) / d;
            if (d2 >= 0.0 && d2 <= 1.0 && d3 >= 0.0 && d3 <= 1.0) {
                float f9 = (float)((double)f4 + d2 * (double)(f3 - f4));
                float f10 = (float)((double)f8 + d2 * (double)(f7 - f8));
                return new Intersection(edge, edge2, (float)d2, (float)d3, f9, f10);
            }
            return null;
        }

        @Deprecated
        void addWorldObstacles() {
            Object object;
            int n;
            int n2;
            VehicleRect vehicleRect = this.cluster.bounds();
            --vehicleRect.x;
            --vehicleRect.y;
            vehicleRect.w += 3;
            vehicleRect.h += 3;
            ObjectOutline[][] objectOutlineArray = new ObjectOutline[vehicleRect.w][vehicleRect.h];
            int n3 = this.cluster.z;
            for (n2 = vehicleRect.top(); n2 < vehicleRect.bottom() - 1; ++n2) {
                for (n = vehicleRect.left(); n < vehicleRect.right() - 1; ++n) {
                    object = instance.getSquare(n, n2, n3);
                    if (object == null || !this.contains((Square)object, 1)) continue;
                    if (((Square)object).has(504) || ((Square)object).isReallySolid()) {
                        ObjectOutline.setSolid(n - vehicleRect.left(), n2 - vehicleRect.top(), n3, objectOutlineArray);
                    }
                    if (((Square)object).has(2)) {
                        ObjectOutline.setWest(n - vehicleRect.left(), n2 - vehicleRect.top(), n3, objectOutlineArray);
                    }
                    if (((Square)object).has(4)) {
                        ObjectOutline.setNorth(n - vehicleRect.left(), n2 - vehicleRect.top(), n3, objectOutlineArray);
                    }
                    if (((Square)object).has(262144)) {
                        ObjectOutline.setWest(n - vehicleRect.left() + 1, n2 - vehicleRect.top(), n3, objectOutlineArray);
                    }
                    if (!((Square)object).has(524288)) continue;
                    ObjectOutline.setNorth(n - vehicleRect.left(), n2 - vehicleRect.top() + 1, n3, objectOutlineArray);
                }
            }
            for (n2 = 0; n2 < vehicleRect.h; ++n2) {
                for (n = 0; n < vehicleRect.w; ++n) {
                    object = ObjectOutline.get(n, n2, n3, objectOutlineArray);
                    if (object == null || !((ObjectOutline)object).nw || !((ObjectOutline)object).nw_w || !((ObjectOutline)object).nw_n) continue;
                    ((ObjectOutline)object).trace(objectOutlineArray, this.obstacleTraceNodes);
                    if (((ObjectOutline)object).nodes.isEmpty()) continue;
                    Obstacle obstacle = Obstacle.alloc().init((IsoGridSquare)null);
                    for (int i = 0; i < ((ObjectOutline)object).nodes.size() - 1; ++i) {
                        Node node = ((ObjectOutline)object).nodes.get(i);
                        Node node2 = ((ObjectOutline)object).nodes.get(i + 1);
                        node.x += (float)vehicleRect.left();
                        node.y += (float)vehicleRect.top();
                        if (!this.contains(node.x, node.y, node.z)) {
                            node.ignore = true;
                        }
                        Edge edge = Edge.alloc().init(node, node2, obstacle, obstacle.outer);
                        obstacle.outer.add(edge);
                        this.nodes.add(node);
                    }
                    obstacle.calcBounds();
                    this.obstacles.add(obstacle);
                    this.edges.addAll(obstacle.outer);
                }
            }
            for (n2 = 0; n2 < vehicleRect.h; ++n2) {
                for (n = 0; n < vehicleRect.w; ++n) {
                    if (objectOutlineArray[n][n2] == null) continue;
                    objectOutlineArray[n][n2].release();
                }
            }
            vehicleRect.release();
        }

        void addWorldObstaclesClipper() {
            int n;
            VehicleRect vehicleRect = this.cluster.bounds();
            --vehicleRect.x;
            --vehicleRect.y;
            vehicleRect.w += 2;
            vehicleRect.h += 2;
            if (PolygonalMap2.instance.clipperThread == null) {
                PolygonalMap2.instance.clipperThread = new Clipper();
            }
            Clipper clipper = PolygonalMap2.instance.clipperThread;
            clipper.clear();
            int n2 = this.cluster.z;
            for (int i = vehicleRect.top(); i < vehicleRect.bottom(); ++i) {
                for (n = vehicleRect.left(); n < vehicleRect.right(); ++n) {
                    Square square = instance.getSquare(n, i, n2);
                    if (square == null || !this.contains(square, 1)) continue;
                    if (square.has(504) || square.isReallySolid()) {
                        clipper.addAABB((float)n - 0.3f, (float)i - 0.3f, (float)(n + 1) + 0.3f, (float)(i + 1) + 0.3f);
                    }
                    if (square.has(2)) {
                        clipper.addAABB((float)n - 0.3f, (float)i - 0.3f, (float)n + 0.3f, (float)(i + 1) + 0.3f);
                    }
                    if (!square.has(4)) continue;
                    clipper.addAABB((float)n - 0.3f, (float)i - 0.3f, (float)(n + 1) + 0.3f, (float)i + 0.3f);
                }
            }
            vehicleRect.release();
            ByteBuffer byteBuffer = PolygonalMap2.instance.xyBufferThread;
            n = clipper.generatePolygons();
            for (int i = 0; i < n; ++i) {
                int n3;
                byteBuffer.clear();
                clipper.getPolygon(i, byteBuffer);
                Obstacle obstacle = Obstacle.alloc().init((IsoGridSquare)null);
                this.getEdgesFromBuffer(byteBuffer, obstacle, true, n2);
                int n4 = byteBuffer.getShort();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.getEdgesFromBuffer(byteBuffer, obstacle, false, n2);
                }
                obstacle.calcBounds();
                this.obstacles.add(obstacle);
                this.edges.addAll(obstacle.outer);
                for (n3 = 0; n3 < obstacle.inner.size(); ++n3) {
                    this.edges.addAll(obstacle.inner.get(n3));
                }
            }
        }

        void getEdgesFromBuffer(ByteBuffer byteBuffer, Obstacle obstacle, boolean bl, int n) {
            Object object;
            int n2;
            short s = byteBuffer.getShort();
            if (s < 3) {
                byteBuffer.position(byteBuffer.position() + s * 4 * 2);
                return;
            }
            EdgeRing edgeRing = obstacle.outer;
            if (!bl) {
                edgeRing = EdgeRing.alloc();
                edgeRing.clear();
                obstacle.inner.add(edgeRing);
            }
            int n3 = this.nodes.size();
            for (n2 = s - 1; n2 >= 0; --n2) {
                float f = byteBuffer.getFloat();
                float f2 = byteBuffer.getFloat();
                object = Node.alloc().init(f, f2, n);
                this.nodes.add((Node)object);
            }
            for (n2 = n3; n2 < this.nodes.size() - 1; ++n2) {
                Node node = this.nodes.get(n2);
                Node node2 = this.nodes.get(n2 + 1);
                if (!this.contains(node.x, node.y, node.z)) {
                    node.ignore = true;
                }
                object = Edge.alloc().init(node, node2, obstacle, edgeRing);
                edgeRing.add((Edge)object);
            }
            Node node = this.nodes.get(this.nodes.size() - 1);
            Node node3 = this.nodes.get(n3);
            Edge edge = Edge.alloc().init(node, node3, obstacle, edgeRing);
            edgeRing.add(edge);
        }

        void trySplit(Edge edge, VehicleRect vehicleRect, TIntArrayList tIntArrayList) {
            if (Math.abs(edge.node1.x - edge.node2.x) > Math.abs(edge.node1.y - edge.node2.y)) {
                float f = Math.min(edge.node1.x, edge.node2.x);
                float f2 = Math.max(edge.node1.x, edge.node2.x);
                float f3 = edge.node1.y;
                if ((float)vehicleRect.left() > f && (float)vehicleRect.left() < f2 && (float)vehicleRect.top() < f3 && (float)vehicleRect.bottom() > f3 && !tIntArrayList.contains(vehicleRect.left()) && !this.contains((float)vehicleRect.left() - 0.5f, f3, this.cluster.z)) {
                    tIntArrayList.add(vehicleRect.left());
                }
                if ((float)vehicleRect.right() > f && (float)vehicleRect.right() < f2 && (float)vehicleRect.top() < f3 && (float)vehicleRect.bottom() > f3 && !tIntArrayList.contains(vehicleRect.right()) && !this.contains((float)vehicleRect.right() + 0.5f, f3, this.cluster.z)) {
                    tIntArrayList.add(vehicleRect.right());
                }
            } else {
                float f = Math.min(edge.node1.y, edge.node2.y);
                float f4 = Math.max(edge.node1.y, edge.node2.y);
                float f5 = edge.node1.x;
                if ((float)vehicleRect.top() > f && (float)vehicleRect.top() < f4 && (float)vehicleRect.left() < f5 && (float)vehicleRect.right() > f5 && !tIntArrayList.contains(vehicleRect.top()) && !this.contains(f5, (float)vehicleRect.top() - 0.5f, this.cluster.z)) {
                    tIntArrayList.add(vehicleRect.top());
                }
                if ((float)vehicleRect.bottom() > f && (float)vehicleRect.bottom() < f4 && (float)vehicleRect.left() < f5 && (float)vehicleRect.right() > f5 && !tIntArrayList.contains(vehicleRect.bottom()) && !this.contains(f5, (float)vehicleRect.bottom() + 0.5f, this.cluster.z)) {
                    tIntArrayList.add(vehicleRect.bottom());
                }
            }
        }

        void splitWorldObstacleEdges(EdgeRing edgeRing) {
            for (int i = edgeRing.size() - 1; i >= 0; --i) {
                Edge edge;
                Object object;
                int n;
                Edge edge2 = (Edge)edgeRing.get(i);
                this.splitXY.clear();
                for (n = 0; n < this.cluster.rects.size(); ++n) {
                    object = this.cluster.rects.get(n);
                    this.trySplit(edge2, (VehicleRect)object, this.splitXY);
                }
                if (this.splitXY.isEmpty()) continue;
                this.splitXY.sort();
                if (Math.abs(edge2.node1.x - edge2.node2.x) > Math.abs(edge2.node1.y - edge2.node2.y)) {
                    if (edge2.node1.x < edge2.node2.x) {
                        for (n = this.splitXY.size() - 1; n >= 0; --n) {
                            object = Node.alloc().init(this.splitXY.get(n), edge2.node1.y, this.cluster.z);
                            edge = edge2.split((Node)object);
                            this.nodes.add((Node)object);
                            this.edges.add(edge);
                        }
                        continue;
                    }
                    for (n = 0; n < this.splitXY.size(); ++n) {
                        object = Node.alloc().init(this.splitXY.get(n), edge2.node1.y, this.cluster.z);
                        edge = edge2.split((Node)object);
                        this.nodes.add((Node)object);
                        this.edges.add(edge);
                    }
                    continue;
                }
                if (edge2.node1.y < edge2.node2.y) {
                    for (n = this.splitXY.size() - 1; n >= 0; --n) {
                        object = Node.alloc().init(edge2.node1.x, this.splitXY.get(n), this.cluster.z);
                        edge = edge2.split((Node)object);
                        this.nodes.add((Node)object);
                        this.edges.add(edge);
                    }
                    continue;
                }
                for (n = 0; n < this.splitXY.size(); ++n) {
                    object = Node.alloc().init(edge2.node1.x, this.splitXY.get(n), this.cluster.z);
                    edge = edge2.split((Node)object);
                    this.nodes.add((Node)object);
                    this.edges.add(edge);
                }
            }
        }

        void getStairSquares(ArrayList<Square> arrayList) {
            VehicleRect vehicleRect = this.cluster.bounds();
            vehicleRect.x -= 4;
            vehicleRect.w += 4;
            ++vehicleRect.w;
            vehicleRect.y -= 4;
            vehicleRect.h += 4;
            ++vehicleRect.h;
            for (int i = vehicleRect.top(); i < vehicleRect.bottom(); ++i) {
                for (int j = vehicleRect.left(); j < vehicleRect.right(); ++j) {
                    Square square = instance.getSquare(j, i, this.cluster.z);
                    if (square == null || !square.has(72) || arrayList.contains(square)) continue;
                    arrayList.add(square);
                }
            }
            vehicleRect.release();
        }

        void getCanPathSquares(ArrayList<Square> arrayList) {
            VehicleRect vehicleRect = this.cluster.bounds();
            --vehicleRect.x;
            vehicleRect.w += 2;
            --vehicleRect.y;
            vehicleRect.h += 2;
            for (int i = vehicleRect.top(); i < vehicleRect.bottom(); ++i) {
                for (int j = vehicleRect.left(); j < vehicleRect.right(); ++j) {
                    Square square = instance.getSquare(j, i, this.cluster.z);
                    if (square == null || !square.isCanPathW() && !square.isCanPathN() || arrayList.contains(square)) continue;
                    arrayList.add(square);
                }
            }
            vehicleRect.release();
        }

        void connectVehicleCrawlNodes() {
            for (int i = 0; i < this.obstacles.size(); ++i) {
                Node node;
                int n;
                Obstacle obstacle = this.obstacles.get(i);
                if (obstacle.vehicle == null || obstacle.nodeCrawlFront == null) continue;
                for (n = 0; n < obstacle.crawlNodes.size(); n += 3) {
                    node = obstacle.crawlNodes.get(n);
                    Node node2 = obstacle.crawlNodes.get(n + 1);
                    Node node3 = obstacle.crawlNodes.get(n + 2);
                    instance.connectTwoNodes(node, node2);
                    instance.connectTwoNodes(node3, node2);
                    if (n + 3 >= obstacle.crawlNodes.size()) continue;
                    Node node4 = obstacle.crawlNodes.get(n + 3 + 1);
                    instance.connectTwoNodes(node2, node4);
                }
                if (!obstacle.crawlNodes.isEmpty()) {
                    n = obstacle.crawlNodes.size() - 2;
                    node = obstacle.crawlNodes.get(n);
                    instance.connectTwoNodes(obstacle.nodeCrawlFront, node);
                    n = 1;
                    node = obstacle.crawlNodes.get(n);
                    instance.connectTwoNodes(obstacle.nodeCrawlRear, node);
                }
                if (!obstacle.crawlNodes.isEmpty()) {
                    ImmutableRectF immutableRectF = obstacle.bounds;
                    int n2 = (int)immutableRectF.x;
                    int n3 = (int)immutableRectF.y;
                    int n4 = (int)Math.ceil(immutableRectF.right());
                    int n5 = (int)Math.ceil(immutableRectF.bottom());
                    for (int j = n3; j < n5; ++j) {
                        for (int k = n2; k < n4; ++k) {
                            Square square = instance.getSquare(k, j, this.cluster.z);
                            if (square == null || !obstacle.isPointInside((float)k + 0.5f, (float)j + 0.5f)) continue;
                            Node node5 = instance.getNodeForSquare(square);
                            for (int i2 = node5.visible.size() - 1; i2 >= 0; --i2) {
                                Connection connection = node5.visible.get(i2);
                                if (!connection.has(1)) continue;
                                Node node6 = connection.otherNode(node5);
                                Node node7 = obstacle.getClosestInteriorCrawlNode(node5.x, node5.y);
                                for (int i3 = 0; i3 < obstacle.outer.size(); ++i3) {
                                    Edge edge = (Edge)obstacle.outer.get(i3);
                                    float f = connection.node2.y;
                                    float f2 = connection.node1.y;
                                    float f3 = edge.node2.x;
                                    float f4 = edge.node1.x;
                                    float f5 = connection.node2.x;
                                    float f6 = connection.node1.x;
                                    float f7 = edge.node2.y;
                                    float f8 = edge.node1.y;
                                    double d = (f - f2) * (f3 - f4) - (f5 - f6) * (f7 - f8);
                                    if (d == 0.0) continue;
                                    double d2 = (double)((f5 - f6) * (f8 - f2) - (f - f2) * (f4 - f6)) / d;
                                    double d3 = (double)((f3 - f4) * (f8 - f2) - (f7 - f8) * (f4 - f6)) / d;
                                    if (!(d2 >= 0.0) || !(d2 <= 1.0) || !(d3 >= 0.0) || !(d3 <= 1.0)) continue;
                                    float f9 = (float)((double)f4 + d2 * (double)(f3 - f4));
                                    float f10 = (float)((double)f8 + d2 * (double)(f7 - f8));
                                    Node node8 = Node.alloc().init(f9, f10, this.cluster.z);
                                    node8.flags |= 1;
                                    boolean bl = edge.node1.isConnectedTo(edge.node2);
                                    Edge edge2 = edge.split(node8);
                                    if (bl) {
                                        instance.connectTwoNodes(edge.node1, edge.node2);
                                        instance.connectTwoNodes(edge2.node1, edge2.node2);
                                    }
                                    this.edges.add(edge2);
                                    this.nodes.add(node8);
                                    instance.connectTwoNodes(node6, node8, connection.flags & 2 | 1);
                                    instance.connectTwoNodes(node8, node7, 0);
                                    break;
                                }
                                instance.breakConnection(connection);
                            }
                        }
                    }
                }
                for (n = i + 1; n < this.obstacles.size(); ++n) {
                    Obstacle obstacle2 = this.obstacles.get(n);
                    if (obstacle2.vehicle == null || obstacle2.nodeCrawlFront == null) continue;
                    obstacle.connectCrawlNodes(this, obstacle2);
                    obstacle2.connectCrawlNodes(this, obstacle);
                }
            }
        }

        void checkEdgeIntersection() {
            int n;
            Obstacle obstacle;
            int n2;
            for (n2 = 0; n2 < this.obstacles.size(); ++n2) {
                obstacle = this.obstacles.get(n2);
                for (n = n2 + 1; n < this.obstacles.size(); ++n) {
                    EdgeRing edgeRing;
                    int n3;
                    Obstacle obstacle2 = this.obstacles.get(n);
                    if (!obstacle.bounds.intersects(obstacle2.bounds)) continue;
                    this.checkEdgeIntersection(obstacle.outer, obstacle2.outer);
                    for (n3 = 0; n3 < obstacle2.inner.size(); ++n3) {
                        edgeRing = obstacle2.inner.get(n3);
                        this.checkEdgeIntersection(obstacle.outer, edgeRing);
                    }
                    for (n3 = 0; n3 < obstacle.inner.size(); ++n3) {
                        edgeRing = obstacle.inner.get(n3);
                        this.checkEdgeIntersection(edgeRing, obstacle2.outer);
                        for (int i = 0; i < obstacle2.inner.size(); ++i) {
                            EdgeRing edgeRing2 = obstacle2.inner.get(i);
                            this.checkEdgeIntersection(edgeRing, edgeRing2);
                        }
                    }
                }
            }
            for (n2 = 0; n2 < this.obstacles.size(); ++n2) {
                obstacle = this.obstacles.get(n2);
                this.checkEdgeIntersectionSplit(obstacle.outer);
                for (n = 0; n < obstacle.inner.size(); ++n) {
                    this.checkEdgeIntersectionSplit(obstacle.inner.get(n));
                }
            }
        }

        void checkEdgeIntersection(EdgeRing edgeRing, EdgeRing edgeRing2) {
            for (int i = 0; i < edgeRing.size(); ++i) {
                Edge edge = (Edge)edgeRing.get(i);
                for (int j = 0; j < edgeRing2.size(); ++j) {
                    Intersection intersection;
                    Edge edge2 = (Edge)edgeRing2.get(j);
                    if (!this.intersects(edge.node1, edge.node2, edge2) || (intersection = this.getIntersection(edge, edge2)) == null) continue;
                    edge.intersections.add(intersection);
                    edge2.intersections.add(intersection);
                    this.nodes.add(intersection.nodeSplit);
                    this.intersectNodes.add(intersection.nodeSplit);
                }
            }
        }

        void checkEdgeIntersectionSplit(EdgeRing edgeRing) {
            for (int i = edgeRing.size() - 1; i >= 0; --i) {
                Edge edge = (Edge)edgeRing.get(i);
                if (edge.intersections.isEmpty()) continue;
                VisibilityGraph.comparator.edge = edge;
                Collections.sort(edge.intersections, comparator);
                for (int j = edge.intersections.size() - 1; j >= 0; --j) {
                    Intersection intersection = edge.intersections.get(j);
                    Edge edge2 = intersection.split(edge);
                    this.edges.add(edge2);
                }
            }
        }

        void checkNodesInObstacles() {
            Obstacle obstacle;
            int n;
            Node node;
            int n2;
            block0: for (n2 = 0; n2 < this.nodes.size(); ++n2) {
                node = this.nodes.get(n2);
                for (n = 0; n < this.obstacles.size(); ++n) {
                    obstacle = this.obstacles.get(n);
                    if (!obstacle.isNodeInsideOf(node)) continue;
                    node.ignore = true;
                    continue block0;
                }
            }
            block2: for (n2 = 0; n2 < this.perimeterNodes.size(); ++n2) {
                node = this.perimeterNodes.get(n2);
                for (n = 0; n < this.obstacles.size(); ++n) {
                    obstacle = this.obstacles.get(n);
                    if (!obstacle.isNodeInsideOf(node)) continue;
                    node.ignore = true;
                    continue block2;
                }
            }
        }

        void addPerimeterEdges() {
            int n;
            VehicleRect vehicleRect = this.cluster.bounds();
            --vehicleRect.x;
            --vehicleRect.y;
            vehicleRect.w += 2;
            vehicleRect.h += 2;
            ClusterOutlineGrid clusterOutlineGrid = VisibilityGraph.clusterOutlineGrid.setSize(vehicleRect.w, vehicleRect.h);
            int n2 = this.cluster.z;
            for (n = 0; n < this.cluster.rects.size(); ++n) {
                VehicleRect vehicleRect2 = this.cluster.rects.get(n);
                vehicleRect2 = VehicleRect.alloc().init(vehicleRect2.x - 1, vehicleRect2.y - 1, vehicleRect2.w + 2, vehicleRect2.h + 2, vehicleRect2.z);
                for (int i = vehicleRect2.top(); i < vehicleRect2.bottom(); ++i) {
                    for (int j = vehicleRect2.left(); j < vehicleRect2.right(); ++j) {
                        clusterOutlineGrid.setInner(j - vehicleRect.left(), i - vehicleRect.top(), n2);
                    }
                }
                vehicleRect2.release();
            }
            for (n = 0; n < vehicleRect.h; ++n) {
                for (int i = 0; i < vehicleRect.w; ++i) {
                    ClusterOutline clusterOutline = clusterOutlineGrid.get(i, n, n2);
                    if (!clusterOutline.inner) continue;
                    if (!clusterOutlineGrid.isInner(i - 1, n, n2)) {
                        clusterOutline.w = true;
                    }
                    if (!clusterOutlineGrid.isInner(i, n - 1, n2)) {
                        clusterOutline.n = true;
                    }
                    if (!clusterOutlineGrid.isInner(i + 1, n, n2)) {
                        clusterOutline.e = true;
                    }
                    if (clusterOutlineGrid.isInner(i, n + 1, n2)) continue;
                    clusterOutline.s = true;
                }
            }
            for (n = 0; n < vehicleRect.h; ++n) {
                for (int i = 0; i < vehicleRect.w; ++i) {
                    Object object;
                    ClusterOutline clusterOutline = clusterOutlineGrid.get(i, n, n2);
                    if (clusterOutline != null && (clusterOutline.w || clusterOutline.n || clusterOutline.e || clusterOutline.s || clusterOutline.innerCorner) && (object = instance.getSquare(vehicleRect.x + i, vehicleRect.y + n, n2)) != null && !((Square)object).isNonThumpableSolid() && !((Square)object).has(504)) {
                        Node node = instance.getNodeForSquare((Square)object);
                        node.flags |= 8;
                        node.addGraph(this);
                        this.perimeterNodes.add(node);
                    }
                    if (clusterOutline == null || !clusterOutline.n || !clusterOutline.w || !clusterOutline.inner || clusterOutline.tw | clusterOutline.tn | clusterOutline.te | clusterOutline.ts || ((ArrayList)(object = clusterOutlineGrid.trace(clusterOutline))).isEmpty()) continue;
                    for (int j = 0; j < ((ArrayList)object).size() - 1; ++j) {
                        Node node = (Node)((ArrayList)object).get(j);
                        Node node2 = (Node)((ArrayList)object).get(j + 1);
                        node.x += (float)vehicleRect.left();
                        node.y += (float)vehicleRect.top();
                        Edge edge = Edge.alloc().init(node, node2, null, null);
                        this.perimeterEdges.add(edge);
                    }
                    if (((ArrayList)object).get(((ArrayList)object).size() - 1) == ((ArrayList)object).get(0)) continue;
                    ((Node)((ArrayList)object).get((int)(((ArrayList)object).size() - 1))).x += (float)vehicleRect.left();
                    ((Node)((ArrayList)object).get((int)(((ArrayList)object).size() - 1))).y += (float)vehicleRect.top();
                }
            }
            clusterOutlineGrid.releaseElements();
            vehicleRect.release();
        }

        void calculateNodeVisibility() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.addAll(this.nodes);
            arrayList.addAll(this.perimeterNodes);
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node = (Node)arrayList.get(i);
                if (node.ignore || node.square != null && node.square.has(504)) continue;
                for (int j = i + 1; j < arrayList.size(); ++j) {
                    Node node2 = (Node)arrayList.get(j);
                    if (node2.ignore || node2.square != null && node2.square.has(504) || node.hasFlag(8) && node2.hasFlag(8)) continue;
                    if (node.isConnectedTo(node2)) {
                        if ((node.square == null || !node.square.isCanPathW() && !node.square.isCanPathN()) && (node2.square == null || !node2.square.isCanPathW() && !node2.square.isCanPathN())) assert (false);
                        continue;
                    }
                    if (!this.isVisible(node, node2)) continue;
                    instance.connectTwoNodes(node, node2);
                }
            }
        }

        void addNode(Node node) {
            if (this.created && !node.ignore) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                arrayList.addAll(this.nodes);
                arrayList.addAll(this.perimeterNodes);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Node node2 = (Node)arrayList.get(i);
                    if (node2.ignore || !this.isVisible(node2, node)) continue;
                    instance.connectTwoNodes(node, node2);
                }
            }
            this.nodes.add(node);
        }

        void removeNode(Node node) {
            this.nodes.remove(node);
            for (int i = node.visible.size() - 1; i >= 0; --i) {
                Connection connection = node.visible.get(i);
                instance.breakConnection(connection);
            }
        }

        boolean contains(float f, float f2, int n) {
            for (int i = 0; i < this.cluster.rects.size(); ++i) {
                VehicleRect vehicleRect = this.cluster.rects.get(i);
                if (!vehicleRect.containsPoint(f, f2, n)) continue;
                return true;
            }
            return false;
        }

        boolean contains(float f, float f2, int n, int n2) {
            for (int i = 0; i < this.cluster.rects.size(); ++i) {
                VehicleRect vehicleRect = this.cluster.rects.get(i);
                if (!vehicleRect.containsPoint(f, f2, n, n2)) continue;
                return true;
            }
            return false;
        }

        boolean contains(Square square) {
            for (int i = 0; i < this.cluster.rects.size(); ++i) {
                VehicleRect vehicleRect = this.cluster.rects.get(i);
                if (!vehicleRect.containsPoint((float)square.x + 0.5f, (float)square.y + 0.5f, square.z)) continue;
                return true;
            }
            return false;
        }

        boolean contains(Square square, int n) {
            for (int i = 0; i < this.cluster.rects.size(); ++i) {
                VehicleRect vehicleRect = this.cluster.rects.get(i);
                if (!vehicleRect.containsPoint((float)square.x + 0.5f, (float)square.y + 0.5f, square.z, n)) continue;
                return true;
            }
            return false;
        }

        private int getPointOutsideObstacles(float f, float f2, float f3, AdjustStartEndNodeData adjustStartEndNodeData) {
            ClosestPointOnEdge closestPointOnEdge = PolygonalMap2.instance.closestPointOnEdge;
            double d = Double.MAX_VALUE;
            Edge edge = null;
            Node node = null;
            float f4 = 0.0f;
            float f5 = 0.0f;
            for (int i = 0; i < this.obstacles.size(); ++i) {
                Obstacle obstacle = this.obstacles.get(i);
                if (!obstacle.bounds.containsPoint(f, f2) || !obstacle.isPointInside(f, f2)) continue;
                obstacle.getClosestPointOnEdge(f, f2, closestPointOnEdge);
                if (closestPointOnEdge.edge == null || !(closestPointOnEdge.distSq < d)) continue;
                d = closestPointOnEdge.distSq;
                edge = closestPointOnEdge.edge;
                node = closestPointOnEdge.node;
                f4 = closestPointOnEdge.point.x;
                f5 = closestPointOnEdge.point.y;
            }
            if (edge != null) {
                closestPointOnEdge.edge = edge;
                closestPointOnEdge.node = node;
                closestPointOnEdge.point.set(f4, f5);
                closestPointOnEdge.distSq = d;
                if (edge.obstacle.splitEdgeAtNearestPoint(closestPointOnEdge, (int)f3, adjustStartEndNodeData)) {
                    adjustStartEndNodeData.graph = this;
                    if (adjustStartEndNodeData.isNodeNew) {
                        this.edges.add(adjustStartEndNodeData.newEdge);
                        this.addNode(adjustStartEndNodeData.node);
                    }
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        Node getClosestNodeTo(float f, float f2) {
            Node node = null;
            float f3 = Float.MAX_VALUE;
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node node2 = this.nodes.get(i);
                float f4 = IsoUtils.DistanceToSquared(node2.x, node2.y, f, f2);
                if (!(f4 < f3)) continue;
                node = node2;
                f3 = f4;
            }
            return node;
        }

        void create() {
            Object object;
            int n;
            for (n = 0; n < this.cluster.rects.size(); ++n) {
                object = this.cluster.rects.get(n);
                this.addEdgesForVehicle(((VehicleRect)object).vehicle);
            }
            this.addWorldObstaclesClipper();
            for (n = 0; n < this.obstacles.size(); ++n) {
                object = this.obstacles.get(n);
                if (((Obstacle)object).vehicle != null) continue;
                this.splitWorldObstacleEdges(((Obstacle)object).outer);
                for (int i = 0; i < ((Obstacle)object).inner.size(); ++i) {
                    this.splitWorldObstacleEdges(((Obstacle)object).inner.get(i));
                }
            }
            this.checkEdgeIntersection();
            this.checkNodesInObstacles();
            this.calculateNodeVisibility();
            this.connectVehicleCrawlNodes();
            this.created = true;
        }

        static VisibilityGraph alloc() {
            return pool.isEmpty() ? new VisibilityGraph() : pool.pop();
        }

        void release() {
            int n;
            for (n = 0; n < this.nodes.size(); ++n) {
                if (PolygonalMap2.instance.squareToNode.containsValue((Object)this.nodes.get(n))) continue;
                this.nodes.get(n).release();
            }
            for (n = 0; n < this.perimeterEdges.size(); ++n) {
                this.perimeterEdges.get((int)n).node1.release();
                this.perimeterEdges.get(n).release();
            }
            for (n = 0; n < this.obstacles.size(); ++n) {
                Obstacle obstacle = this.obstacles.get(n);
                obstacle.release();
            }
            for (n = 0; n < this.cluster.rects.size(); ++n) {
                this.cluster.rects.get(n).release();
            }
            this.cluster.release();
            assert (!pool.contains(this));
            pool.push(this);
        }

        void render() {
            float f = 1.0f;
            for (Edge object : this.perimeterEdges) {
                LineDrawer.addLine(object.node1.x, object.node1.y, this.cluster.z, object.node2.x, object.node2.y, this.cluster.z, f, 0.5f, 0.5f, null, true);
                f = 1.0f - f;
            }
            for (Obstacle obstacle : this.obstacles) {
                f = 1.0f;
                for (Edge edge : obstacle.outer) {
                    LineDrawer.addLine(edge.node1.x, edge.node1.y, this.cluster.z, edge.node2.x, edge.node2.y, this.cluster.z, f, 0.5f, 0.5f, null, true);
                    f = 1.0f - f;
                }
                for (EdgeRing edgeRing : obstacle.inner) {
                    for (Edge edge : edgeRing) {
                        LineDrawer.addLine(edge.node1.x, edge.node1.y, this.cluster.z, edge.node2.x, edge.node2.y, this.cluster.z, f, 0.5f, 0.5f, null, true);
                        f = 1.0f - f;
                    }
                }
                if (!DebugOptions.instance.PolymapRenderCrawling.getValue()) continue;
                for (Node node : obstacle.crawlNodes) {
                    LineDrawer.addLine(node.x - 0.05f, node.y - 0.05f, this.cluster.z, node.x + 0.05f, node.y + 0.05f, this.cluster.z, 0.5f, 1.0f, 0.5f, null, false);
                    for (Connection connection : node.visible) {
                        Node node2 = connection.otherNode(node);
                        if (!node2.hasFlag(1)) continue;
                        LineDrawer.addLine(node.x, node.y, this.cluster.z, node2.x, node2.y, this.cluster.z, 0.5f, 1.0f, 0.5f, null, true);
                    }
                }
            }
            for (Node node : this.perimeterNodes) {
                if (DebugOptions.instance.PolymapRenderConnections.getValue()) {
                    for (Connection connection : node.visible) {
                        Node node3 = connection.otherNode(node);
                        LineDrawer.addLine(node.x, node.y, this.cluster.z, node3.x, node3.y, this.cluster.z, 0.0f, 0.25f, 0.0f, null, true);
                    }
                }
                if (!DebugOptions.instance.PolymapRenderNodes.getValue()) continue;
                float f2 = 1.0f;
                float f3 = 0.5f;
                float f4 = 0.0f;
                if (node.ignore) {
                    f3 = 1.0f;
                }
                LineDrawer.addLine(node.x - 0.05f, node.y - 0.05f, this.cluster.z, node.x + 0.05f, node.y + 0.05f, this.cluster.z, f2, f3, f4, null, false);
            }
            for (Node node : this.nodes) {
                if (DebugOptions.instance.PolymapRenderConnections.getValue()) {
                    for (Connection connection : node.visible) {
                        Node node4 = connection.otherNode(node);
                        if (!this.nodes.contains(node4)) continue;
                        LineDrawer.addLine(node.x, node.y, this.cluster.z, node4.x, node4.y, this.cluster.z, 0.0f, 1.0f, 0.0f, null, true);
                    }
                }
                if (!DebugOptions.instance.PolymapRenderNodes.getValue() && !node.ignore) continue;
                LineDrawer.addLine(node.x - 0.05f, node.y - 0.05f, this.cluster.z, node.x + 0.05f, node.y + 0.05f, this.cluster.z, 1.0f, 1.0f, 0.0f, null, false);
            }
            for (Node node : this.intersectNodes) {
                LineDrawer.addLine(node.x - 0.1f, node.y - 0.1f, this.cluster.z, node.x + 0.1f, node.y + 0.1f, this.cluster.z, 1.0f, 0.0f, 0.0f, null, false);
            }
        }

        static final class CompareIntersection
        implements Comparator<Intersection> {
            Edge edge;

            CompareIntersection() {
            }

            @Override
            public int compare(Intersection intersection, Intersection intersection2) {
                float f;
                float f2 = this.edge == intersection.edge1 ? intersection.dist1 : intersection.dist2;
                float f3 = f = this.edge == intersection2.edge1 ? intersection2.dist1 : intersection2.dist2;
                if (f2 < f) {
                    return -1;
                }
                if (f2 > f) {
                    return 1;
                }
                return 0;
            }
        }
    }

    private static final class Connection {
        Node node1;
        Node node2;
        int flags;
        static final ArrayDeque<Connection> pool = new ArrayDeque();

        private Connection() {
        }

        Connection init(Node node, Node node2, int n) {
            this.node1 = node;
            this.node2 = node2;
            this.flags = n;
            return this;
        }

        Node otherNode(Node node) {
            assert (node == this.node1 || node == this.node2);
            return node == this.node1 ? this.node2 : this.node1;
        }

        boolean has(int n) {
            return (this.flags & n) != 0;
        }

        static Connection alloc() {
            if (pool.isEmpty()) {
                boolean bl = false;
            } else {
                boolean bl = false;
            }
            return pool.isEmpty() ? new Connection() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class Obstacle {
        Vehicle vehicle;
        final EdgeRing outer = new EdgeRing();
        final ArrayList<EdgeRing> inner = new ArrayList();
        ImmutableRectF bounds;
        Node nodeCrawlFront;
        Node nodeCrawlRear;
        final ArrayList<Node> crawlNodes = new ArrayList();
        static final ArrayDeque<Obstacle> pool = new ArrayDeque();

        private Obstacle() {
        }

        Obstacle init(Vehicle vehicle) {
            this.vehicle = vehicle;
            this.outer.clear();
            this.inner.clear();
            this.nodeCrawlRear = null;
            this.nodeCrawlFront = null;
            this.crawlNodes.clear();
            return this;
        }

        Obstacle init(IsoGridSquare isoGridSquare) {
            this.vehicle = null;
            this.outer.clear();
            this.inner.clear();
            this.nodeCrawlRear = null;
            this.nodeCrawlFront = null;
            this.crawlNodes.clear();
            return this;
        }

        boolean hasNode(Node node) {
            if (this.outer.hasNode(node)) {
                return true;
            }
            for (int i = 0; i < this.inner.size(); ++i) {
                EdgeRing edgeRing = this.inner.get(i);
                if (!edgeRing.hasNode(node)) continue;
                return true;
            }
            return false;
        }

        boolean hasAdjacentNodes(Node node, Node node2) {
            if (this.outer.hasAdjacentNodes(node, node2)) {
                return true;
            }
            for (int i = 0; i < this.inner.size(); ++i) {
                EdgeRing edgeRing = this.inner.get(i);
                if (!edgeRing.hasAdjacentNodes(node, node2)) continue;
                return true;
            }
            return false;
        }

        boolean isPointInside(float f, float f2, int n) {
            if (this.outer.isPointInPolygon_WindingNumber(f, f2, n) != EdgeRingHit.Inside) {
                return false;
            }
            if (this.inner.isEmpty()) {
                return true;
            }
            for (int i = 0; i < this.inner.size(); ++i) {
                EdgeRing edgeRing = this.inner.get(i);
                if (edgeRing.isPointInPolygon_WindingNumber(f, f2, n) == EdgeRingHit.Outside) continue;
                return false;
            }
            return true;
        }

        boolean isPointInside(float f, float f2) {
            int n = 0;
            return this.isPointInside(f, f2, n);
        }

        boolean lineSegmentIntersects(float f, float f2, float f3, float f4) {
            if (this.outer.lineSegmentIntersects(f, f2, f3, f4)) {
                return true;
            }
            for (int i = 0; i < this.inner.size(); ++i) {
                EdgeRing edgeRing = this.inner.get(i);
                if (!edgeRing.lineSegmentIntersects(f, f2, f3, f4)) continue;
                return true;
            }
            return false;
        }

        boolean isNodeInsideOf(Node node) {
            if (this.hasNode(node)) {
                return false;
            }
            if (!this.bounds.containsPoint(node.x, node.y)) {
                return false;
            }
            return this.isPointInside(node.x, node.y);
        }

        void getClosestPointOnEdge(float f, float f2, ClosestPointOnEdge closestPointOnEdge) {
            closestPointOnEdge.edge = null;
            closestPointOnEdge.node = null;
            closestPointOnEdge.distSq = Double.MAX_VALUE;
            this.outer.getClosestPointOnEdge(f, f2, closestPointOnEdge);
            for (int i = 0; i < this.inner.size(); ++i) {
                EdgeRing edgeRing = this.inner.get(i);
                edgeRing.getClosestPointOnEdge(f, f2, closestPointOnEdge);
            }
        }

        boolean splitEdgeAtNearestPoint(ClosestPointOnEdge closestPointOnEdge, int n, AdjustStartEndNodeData adjustStartEndNodeData) {
            if (closestPointOnEdge.edge == null) {
                return false;
            }
            adjustStartEndNodeData.obstacle = this;
            if (closestPointOnEdge.node == null) {
                adjustStartEndNodeData.node = Node.alloc().init(closestPointOnEdge.point.x, closestPointOnEdge.point.y, n);
                adjustStartEndNodeData.newEdge = closestPointOnEdge.edge.split(adjustStartEndNodeData.node);
                adjustStartEndNodeData.isNodeNew = true;
            } else {
                adjustStartEndNodeData.node = closestPointOnEdge.node;
                adjustStartEndNodeData.newEdge = null;
                adjustStartEndNodeData.isNodeNew = false;
            }
            return true;
        }

        void unsplit(Node node, ArrayList<Edge> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Edge edge = arrayList.get(i);
                if (edge.node1 != node) continue;
                if (i > 0) {
                    Edge edge2 = arrayList.get(i - 1);
                    edge2.node2 = edge.node2;
                    assert (edge.node2.edges.contains(edge));
                    edge.node2.edges.remove(edge);
                    assert (!edge.node2.edges.contains(edge2));
                    edge.node2.edges.add(edge2);
                    instance.connectTwoNodes(edge2.node1, edge2.node2);
                } else {
                    arrayList.get((int)(i + 1)).node1 = arrayList.get((int)(arrayList.size() - 1)).node2;
                }
                edge.release();
                arrayList.remove(i);
                break;
            }
        }

        void calcBounds() {
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            float f3 = Float.MIN_VALUE;
            float f4 = Float.MIN_VALUE;
            for (int i = 0; i < this.outer.size(); ++i) {
                Edge edge = (Edge)this.outer.get(i);
                f = Math.min(f, edge.node1.x);
                f2 = Math.min(f2, edge.node1.y);
                f3 = Math.max(f3, edge.node1.x);
                f4 = Math.max(f4, edge.node1.y);
            }
            if (this.bounds != null) {
                this.bounds.release();
            }
            float f5 = 0.01f;
            this.bounds = ImmutableRectF.alloc().init(f - f5, f2 - f5, f3 - f + f5 * 2.0f, f4 - f2 + f5 * 2.0f);
        }

        void render(ArrayList<Edge> arrayList, boolean bl) {
            if (arrayList.isEmpty()) {
                return;
            }
            float f = 0.0f;
            float f2 = bl ? 1.0f : 0.5f;
            float f3 = bl ? 0.0f : 0.5f;
            for (Edge edge : arrayList) {
                Node node = edge.node1;
                Node node2 = edge.node2;
                LineDrawer.addLine(node.x, node.y, node.z, node2.x, node2.y, node2.z, f, f2, f3, null, true);
                Vector3f vector3f = new Vector3f(node2.x - node.x, node2.y - node.y, (float)(node2.z - node.z)).normalize();
                Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross(0.0f, 0.0f, 1.0f).normalize();
                vector3f.mul(0.9f);
                LineDrawer.addLine(node2.x - vector3f.x * 0.1f - vector3f2.x * 0.1f, node2.y - vector3f.y * 0.1f - vector3f2.y * 0.1f, node2.z, node2.x, node2.y, node2.z, f, f2, f3, null, true);
                LineDrawer.addLine(node2.x - vector3f.x * 0.1f + vector3f2.x * 0.1f, node2.y - vector3f.y * 0.1f + vector3f2.y * 0.1f, node2.z, node2.x, node2.y, node2.z, f, f2, f3, null, true);
                f = 1.0f - f;
            }
            Node node = arrayList.get((int)0).node1;
            LineDrawer.addLine(node.x - 0.1f, node.y - 0.1f, node.z, node.x + 0.1f, node.y + 0.1f, node.z, 1.0f, 0.0f, 0.0f, null, false);
        }

        void render() {
            this.render(this.outer, true);
            for (int i = 0; i < this.inner.size(); ++i) {
                this.render(this.inner.get(i), false);
            }
        }

        void connectCrawlNodes(VisibilityGraph visibilityGraph, Obstacle obstacle) {
            this.connectCrawlNode(visibilityGraph, obstacle, this.nodeCrawlFront, obstacle.nodeCrawlFront);
            this.connectCrawlNode(visibilityGraph, obstacle, this.nodeCrawlFront, obstacle.nodeCrawlRear);
            this.connectCrawlNode(visibilityGraph, obstacle, this.nodeCrawlRear, obstacle.nodeCrawlFront);
            this.connectCrawlNode(visibilityGraph, obstacle, this.nodeCrawlRear, obstacle.nodeCrawlRear);
            for (int i = 0; i < this.crawlNodes.size(); i += 3) {
                Node node = this.crawlNodes.get(i);
                Node node2 = this.crawlNodes.get(i + 2);
                for (int j = 0; j < obstacle.crawlNodes.size(); j += 3) {
                    Node node3 = obstacle.crawlNodes.get(j);
                    Node node4 = obstacle.crawlNodes.get(j + 2);
                    this.connectCrawlNode(visibilityGraph, obstacle, node, node3);
                    this.connectCrawlNode(visibilityGraph, obstacle, node, node4);
                    this.connectCrawlNode(visibilityGraph, obstacle, node2, node3);
                    this.connectCrawlNode(visibilityGraph, obstacle, node2, node4);
                }
            }
        }

        void connectCrawlNode(VisibilityGraph visibilityGraph, Obstacle obstacle, Node node, Node node2) {
            if (this.isNodeInsideOf(node2)) {
                node2.flags |= 2;
                node = this.getClosestInteriorCrawlNode(node2.x, node2.y);
                if (node == null) {
                    return;
                }
                if (node.isConnectedTo(node2)) {
                    return;
                }
                instance.connectTwoNodes(node, node2);
                return;
            }
            if (node.ignore || node2.ignore) {
                return;
            }
            if (node.isConnectedTo(node2)) {
                return;
            }
            if (visibilityGraph.isVisible(node, node2)) {
                instance.connectTwoNodes(node, node2);
            }
        }

        Node getClosestInteriorCrawlNode(float f, float f2) {
            Node node = null;
            float f3 = Float.MAX_VALUE;
            for (int i = 0; i < this.crawlNodes.size(); i += 3) {
                Node node2 = this.crawlNodes.get(i + 1);
                float f4 = IsoUtils.DistanceToSquared(node2.x, node2.y, f, f2);
                if (!(f4 < f3)) continue;
                node = node2;
                f3 = f4;
            }
            return node;
        }

        static Obstacle alloc() {
            return pool.isEmpty() ? new Obstacle() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            this.outer.release();
            this.outer.clear();
            EdgeRing.releaseAll(this.inner);
            this.inner.clear();
            pool.push(this);
        }

        static void releaseAll(ArrayList<Obstacle> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).release();
            }
        }
    }

    static final class PathFindRequest {
        IPathfinder finder;
        Mover mover;
        boolean bCanCrawl;
        boolean bIgnoreCrawlCost;
        boolean bCanThump;
        final ArrayList<KnownBlockedEdges> knownBlockedEdges = new ArrayList();
        float startX;
        float startY;
        float startZ;
        float targetX;
        float targetY;
        float targetZ;
        final TFloatArrayList targetXYZ = new TFloatArrayList();
        final Path path = new Path();
        boolean cancel = false;
        static final ArrayDeque<PathFindRequest> pool = new ArrayDeque();

        PathFindRequest() {
        }

        PathFindRequest init(IPathfinder iPathfinder, Mover mover, float f, float f2, float f3, float f4, float f5, float f6) {
            this.finder = iPathfinder;
            this.mover = mover;
            this.bCanCrawl = false;
            this.bIgnoreCrawlCost = false;
            this.bCanThump = false;
            IsoZombie isoZombie = Type.tryCastTo(mover, IsoZombie.class);
            if (isoZombie != null) {
                this.bCanCrawl = isoZombie.isCrawling() || isoZombie.isCanCrawlUnderVehicle();
                this.bIgnoreCrawlCost = isoZombie.isCrawling() && !isoZombie.isCanWalk();
                this.bCanThump = true;
            }
            this.startX = f;
            this.startY = f2;
            this.startZ = f3;
            this.targetX = f4;
            this.targetY = f5;
            this.targetZ = f6;
            this.targetXYZ.resetQuick();
            this.path.clear();
            this.cancel = false;
            IsoGameCharacter isoGameCharacter = Type.tryCastTo(mover, IsoGameCharacter.class);
            if (isoGameCharacter != null) {
                ArrayList<KnownBlockedEdges> arrayList = isoGameCharacter.getMapKnowledge().getKnownBlockedEdges();
                for (int i = 0; i < arrayList.size(); ++i) {
                    KnownBlockedEdges knownBlockedEdges = arrayList.get(i);
                    this.knownBlockedEdges.add(KnownBlockedEdges.alloc().init(knownBlockedEdges));
                }
            }
            return this;
        }

        void addTargetXYZ(float f, float f2, float f3) {
            this.targetXYZ.add(f);
            this.targetXYZ.add(f2);
            this.targetXYZ.add(f3);
        }

        static PathFindRequest alloc() {
            return pool.isEmpty() ? new PathFindRequest() : pool.pop();
        }

        public void release() {
            KnownBlockedEdges.releaseAll(this.knownBlockedEdges);
            this.knownBlockedEdges.clear();
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    static final class PathNode {
        float x;
        float y;
        float z;
        int flags;

        PathNode() {
        }

        PathNode init(float f, float f2, float f3, int n) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.flags = n;
            return this;
        }

        PathNode init(PathNode pathNode) {
            this.x = pathNode.x;
            this.y = pathNode.y;
            this.z = pathNode.z;
            this.flags = pathNode.flags;
            return this;
        }

        boolean hasFlag(int n) {
            return (this.flags & n) != 0;
        }
    }

    private static final class SearchNode
    extends ASearchNode {
        VGAStar astar;
        Node vgNode;
        Square square;
        int tx;
        int ty;
        SearchNode parent;
        static int nextID = 1;
        Integer ID = nextID++;
        private static final double SQRT2 = Math.sqrt(2.0);
        static final ArrayDeque<SearchNode> pool = new ArrayDeque();

        SearchNode() {
        }

        SearchNode init(VGAStar vGAStar, Node node) {
            this.setG(0.0);
            this.astar = vGAStar;
            this.vgNode = node;
            this.square = null;
            this.ty = -1;
            this.tx = -1;
            this.parent = null;
            return this;
        }

        SearchNode init(VGAStar vGAStar, Square square) {
            this.setG(0.0);
            this.astar = vGAStar;
            this.vgNode = null;
            this.square = square;
            this.ty = -1;
            this.tx = -1;
            this.parent = null;
            return this;
        }

        SearchNode init(VGAStar vGAStar, int n, int n2) {
            this.setG(0.0);
            this.astar = vGAStar;
            this.vgNode = null;
            this.square = null;
            this.tx = n;
            this.ty = n2;
            this.parent = null;
            return this;
        }

        public double h() {
            return this.dist(this.astar.goalNode.searchNode);
        }

        public double c(ISearchNode iSearchNode) {
            boolean bl;
            Object object;
            boolean bl2;
            SearchNode searchNode = (SearchNode)iSearchNode;
            double d = 0.0;
            boolean bl3 = this.astar.mover instanceof IsoZombie && ((IsoZombie)this.astar.mover).bCrawling;
            boolean bl4 = bl2 = !(this.astar.mover instanceof IsoZombie) || ((IsoZombie)this.astar.mover).bCrawling;
            if (bl2 && this.square != null && searchNode.square != null) {
                if (this.square.x == searchNode.square.x - 1 && this.square.y == searchNode.square.y) {
                    if (searchNode.square.has(2048)) {
                        d = !bl3 && searchNode.square.has(0x100000) ? 20.0 : 200.0;
                    }
                } else if (this.square.x == searchNode.square.x + 1 && this.square.y == searchNode.square.y) {
                    if (this.square.has(2048)) {
                        d = !bl3 && this.square.has(0x100000) ? 20.0 : 200.0;
                    }
                } else if (this.square.y == searchNode.square.y - 1 && this.square.x == searchNode.square.x) {
                    if (searchNode.square.has(4096)) {
                        d = !bl3 && searchNode.square.has(0x200000) ? 20.0 : 200.0;
                    }
                } else if (this.square.y == searchNode.square.y + 1 && this.square.x == searchNode.square.x && this.square.has(4096)) {
                    double d2 = d = !bl3 && this.square.has(0x200000) ? 20.0 : 200.0;
                }
            }
            if (searchNode.square != null && searchNode.square.has(131072)) {
                d = 20.0;
            }
            if (this.vgNode != null && searchNode.vgNode != null) {
                for (int i = 0; i < this.vgNode.visible.size(); ++i) {
                    object = this.vgNode.visible.get(i);
                    if (((Connection)object).otherNode(this.vgNode) != searchNode.vgNode) continue;
                    if (this.vgNode.square != null && this.vgNode.square.has(131072) || !((Connection)object).has(2)) break;
                    d = 20.0;
                    break;
                }
            }
            Square square = this.square == null ? instance.getSquare((int)this.vgNode.x, (int)this.vgNode.y, 0) : this.square;
            Object object2 = object = searchNode.square == null ? instance.getSquare((int)searchNode.vgNode.x, (int)searchNode.vgNode.y, 0) : searchNode.square;
            if (square != null && object != null) {
                if (square.x == ((Square)object).x - 1 && square.y == ((Square)object).y) {
                    if (((Square)object).has(32768)) {
                        d = 20.0;
                    }
                } else if (square.x == ((Square)object).x + 1 && square.y == ((Square)object).y) {
                    if (square.has(32768)) {
                        d = 20.0;
                    }
                } else if (square.y == ((Square)object).y - 1 && square.x == ((Square)object).x) {
                    if (((Square)object).has(65536)) {
                        d = 20.0;
                    }
                } else if (square.y == ((Square)object).y + 1 && square.x == ((Square)object).x && square.has(65536)) {
                    d = 20.0;
                }
                if (bl3) {
                    if (square.x == ((Square)object).x - 1 && square.y == ((Square)object).y) {
                        if (((Square)object).has(2) && ((Square)object).has(8192)) {
                            d = 20.0;
                        }
                    } else if (square.x == ((Square)object).x + 1 && square.y == ((Square)object).y) {
                        if (square.has(2) && square.has(8192)) {
                            d = 20.0;
                        }
                    } else if (square.y == ((Square)object).y - 1 && square.x == ((Square)object).x) {
                        if (((Square)object).has(4) && ((Square)object).has(16384)) {
                            d = 20.0;
                        }
                    } else if (square.y == ((Square)object).y + 1 && square.x == ((Square)object).x && square.has(4) && square.has(16384)) {
                        d = 20.0;
                    }
                }
            }
            boolean bl5 = this.vgNode != null && this.vgNode.hasFlag(2);
            boolean bl6 = bl = searchNode.vgNode != null && searchNode.vgNode.hasFlag(2);
            if (!bl5 && bl && !this.astar.bIgnoreCrawlCost) {
                d += 10.0;
            }
            if (searchNode.square != null) {
                d += (double)searchNode.square.cost;
            }
            return this.dist(searchNode) + d;
        }

        public void getSuccessors(ArrayList<ISearchNode> arrayList) {
            SearchNode searchNode;
            Object object;
            int n;
            ArrayList<ISearchNode> arrayList2 = arrayList;
            if (this.vgNode != null) {
                Object object2;
                if (this.vgNode.graphs != null) {
                    for (n = 0; n < this.vgNode.graphs.size(); ++n) {
                        object2 = this.vgNode.graphs.get(n);
                        if (((VisibilityGraph)object2).created) continue;
                        ((VisibilityGraph)object2).create();
                    }
                }
                for (n = 0; n < this.vgNode.visible.size(); ++n) {
                    object2 = this.vgNode.visible.get(n);
                    object = ((Connection)object2).otherNode(this.vgNode);
                    searchNode = this.astar.getSearchNode((Node)object);
                    if (this.vgNode.square != null && searchNode.square != null && this.astar.isKnownBlocked(this.vgNode.square, searchNode.square) || !this.astar.bCanCrawl && ((Node)object).hasFlag(2) || !this.astar.bCanThump && ((Connection)object2).has(2)) continue;
                    arrayList2.add((ISearchNode)searchNode);
                }
                if (!this.vgNode.hasFlag(8)) {
                    return;
                }
            }
            if (this.square != null) {
                Square square;
                Square square2;
                for (n = -1; n <= 1; ++n) {
                    for (int i = -1; i <= 1; ++i) {
                        if (i == 0 && n == 0 || (object = instance.getSquare(this.square.x + i, this.square.y + n, this.square.z)) == null || this.astar.isSquareInCluster((Square)object) || this.astar.canNotMoveBetween(this.square, (Square)object, false)) continue;
                        searchNode = this.astar.getSearchNode((Square)object);
                        if (arrayList2.contains((Object)searchNode)) {
                            boolean bl = false;
                            continue;
                        }
                        arrayList2.add((ISearchNode)searchNode);
                    }
                }
                if (this.square.z > 0) {
                    Square square3 = instance.getSquare(this.square.x, this.square.y + 1, this.square.z - 1);
                    if (square3 != null && square3.has(64) && !this.astar.isSquareInCluster(square3)) {
                        SearchNode searchNode2 = this.astar.getSearchNode(square3);
                        if (arrayList2.contains((Object)searchNode2)) {
                            boolean bl = false;
                        } else {
                            arrayList2.add((ISearchNode)searchNode2);
                        }
                    }
                    if ((square3 = instance.getSquare(this.square.x + 1, this.square.y, this.square.z - 1)) != null && square3.has(8) && !this.astar.isSquareInCluster(square3)) {
                        SearchNode searchNode3 = this.astar.getSearchNode(square3);
                        if (arrayList2.contains((Object)searchNode3)) {
                            boolean bl = false;
                        } else {
                            arrayList2.add((ISearchNode)searchNode3);
                        }
                    }
                }
                if (this.square.z < 8 && this.square.has(64) && (square2 = instance.getSquare(this.square.x, this.square.y - 1, this.square.z + 1)) != null && !this.astar.isSquareInCluster(square2)) {
                    SearchNode searchNode4 = this.astar.getSearchNode(square2);
                    if (arrayList2.contains((Object)searchNode4)) {
                        boolean bl = false;
                    } else {
                        arrayList2.add((ISearchNode)searchNode4);
                    }
                }
                if (this.square.z < 8 && this.square.has(8) && (square = instance.getSquare(this.square.x - 1, this.square.y, this.square.z + 1)) != null && !this.astar.isSquareInCluster(square)) {
                    SearchNode searchNode5 = this.astar.getSearchNode(square);
                    if (arrayList2.contains((Object)searchNode5)) {
                        boolean bl = false;
                    } else {
                        arrayList2.add((ISearchNode)searchNode5);
                    }
                }
            }
        }

        public ISearchNode getParent() {
            return this.parent;
        }

        public void setParent(ISearchNode iSearchNode) {
            this.parent = (SearchNode)iSearchNode;
        }

        public Integer keyCode() {
            return this.ID;
        }

        public float getX() {
            if (this.square != null) {
                return (float)this.square.x + 0.5f;
            }
            if (this.vgNode != null) {
                return this.vgNode.x;
            }
            return this.tx;
        }

        public float getY() {
            if (this.square != null) {
                return (float)this.square.y + 0.5f;
            }
            if (this.vgNode != null) {
                return this.vgNode.y;
            }
            return this.ty;
        }

        public float getZ() {
            if (this.square != null) {
                return this.square.z;
            }
            if (this.vgNode != null) {
                return this.vgNode.z;
            }
            return 0.0f;
        }

        public double dist(SearchNode searchNode) {
            if (this.square != null && searchNode.square != null && Math.abs(this.square.x - searchNode.square.x) <= 1 && Math.abs(this.square.y - searchNode.square.y) <= 1) {
                if (this.square.x != searchNode.square.x && this.square.y != searchNode.square.y) {
                    return SQRT2;
                }
                return 1.0;
            }
            float f = this.getX();
            float f2 = this.getY();
            float f3 = searchNode.getX();
            float f4 = searchNode.getY();
            return Math.sqrt(Math.pow(f - f3, 2.0) + Math.pow(f2 - f4, 2.0));
        }

        float getApparentZ() {
            if (this.square == null) {
                return this.vgNode.z;
            }
            if (this.square.has(8) || this.square.has(64)) {
                return (float)this.square.z + 0.75f;
            }
            if (this.square.has(16) || this.square.has(128)) {
                return (float)this.square.z + 0.5f;
            }
            if (this.square.has(32) || this.square.has(256)) {
                return (float)this.square.z + 0.25f;
            }
            return this.square.z;
        }

        static SearchNode alloc() {
            return pool.isEmpty() ? new SearchNode() : pool.pop();
        }

        void release() {
            assert (!pool.contains((Object)this));
            pool.push(this);
        }
    }

    private static final class Edge {
        Node node1;
        Node node2;
        Obstacle obstacle;
        EdgeRing edgeRing;
        final ArrayList<Intersection> intersections = new ArrayList();
        final Vector2 normal = new Vector2();
        static final ArrayDeque<Edge> pool = new ArrayDeque();

        private Edge() {
        }

        Edge init(Node node, Node node2, Obstacle obstacle, EdgeRing edgeRing) {
            if (node == null) {
                boolean bl = true;
            }
            this.node1 = node;
            this.node2 = node2;
            node.edges.add(this);
            node2.edges.add(this);
            this.obstacle = obstacle;
            this.edgeRing = edgeRing;
            this.intersections.clear();
            this.normal.set(node2.x - node.x, node2.y - node.y);
            this.normal.normalize();
            this.normal.rotate(1.5707964f);
            return this;
        }

        boolean hasNode(Node node) {
            return node == this.node1 || node == this.node2;
        }

        void getClosestPointOnEdge(float f, float f2, ClosestPointOnEdge closestPointOnEdge) {
            if (!this.node1.isConnectedTo(this.node2)) {
                return;
            }
            float f3 = this.node1.x;
            float f4 = this.node1.y;
            float f5 = this.node2.x;
            float f6 = this.node2.y;
            double d = (double)((f - f3) * (f5 - f3) + (f2 - f4) * (f6 - f4)) / (Math.pow(f5 - f3, 2.0) + Math.pow(f6 - f4, 2.0));
            double d2 = (double)f3 + d * (double)(f5 - f3);
            double d3 = (double)f4 + d * (double)(f6 - f4);
            Node node = null;
            if (d <= 0.0) {
                d2 = f3;
                d3 = f4;
                node = this.node1;
            } else if (d >= 1.0) {
                d2 = f5;
                d3 = f6;
                node = this.node2;
            }
            double d4 = ((double)f - d2) * ((double)f - d2) + ((double)f2 - d3) * ((double)f2 - d3);
            if (d4 < closestPointOnEdge.distSq) {
                closestPointOnEdge.point.set((float)d2, (float)d3);
                closestPointOnEdge.distSq = d4;
                closestPointOnEdge.edge = this;
                closestPointOnEdge.node = node;
            }
        }

        boolean isPointOn(float f, float f2) {
            if (!this.node1.isConnectedTo(this.node2)) {
                return false;
            }
            float f3 = this.node1.x;
            float f4 = this.node1.y;
            float f5 = this.node2.x;
            float f6 = this.node2.y;
            double d = (double)((f - f3) * (f5 - f3) + (f2 - f4) * (f6 - f4)) / (Math.pow(f5 - f3, 2.0) + Math.pow(f6 - f4, 2.0));
            double d2 = (double)f3 + d * (double)(f5 - f3);
            double d3 = (double)f4 + d * (double)(f6 - f4);
            if (d <= 0.0) {
                d2 = f3;
                d3 = f4;
            } else if (d >= 1.0) {
                d2 = f5;
                d3 = f6;
            }
            double d4 = ((double)f - d2) * ((double)f - d2) + ((double)f2 - d3) * ((double)f2 - d3);
            return d4 < 1.0E-6;
        }

        Edge split(Node node) {
            Edge edge = Edge.alloc().init(node, this.node2, this.obstacle, this.edgeRing);
            this.edgeRing.add(this.edgeRing.indexOf(this) + 1, edge);
            instance.breakConnection(this.node1, this.node2);
            this.node2.edges.remove(this);
            this.node2 = node;
            this.node2.edges.add(this);
            return edge;
        }

        static Edge alloc() {
            return pool.isEmpty() ? new Edge() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            this.node1 = null;
            this.node2 = null;
            this.obstacle = null;
            this.edgeRing = null;
            this.intersections.clear();
            pool.push(this);
        }

        static void releaseAll(ArrayList<Edge> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).release();
            }
        }
    }

    private static final class EdgeRing
    extends ArrayList<Edge> {
        static final ArrayDeque<EdgeRing> pool = new ArrayDeque();

        private EdgeRing() {
        }

        @Override
        public boolean add(Edge edge) {
            assert (!this.contains(edge));
            return super.add(edge);
        }

        public boolean hasNode(Node node) {
            for (int i = 0; i < this.size(); ++i) {
                Edge edge = (Edge)this.get(i);
                if (!edge.hasNode(node)) continue;
                return true;
            }
            return false;
        }

        boolean hasAdjacentNodes(Node node, Node node2) {
            for (int i = 0; i < this.size(); ++i) {
                Edge edge = (Edge)this.get(i);
                if (!edge.hasNode(node) || !edge.hasNode(node2)) continue;
                return true;
            }
            return false;
        }

        boolean isPointInPolygon_CrossingNumber(float f, float f2) {
            int n = 0;
            for (int i = 0; i < this.size(); ++i) {
                float f3;
                Edge edge = (Edge)this.get(i);
                if (!(edge.node1.y <= f2 && edge.node2.y > f2) && (!(edge.node1.y > f2) || !(edge.node2.y <= f2)) || !(f < edge.node1.x + (f3 = (f2 - edge.node1.y) / (edge.node2.y - edge.node1.y)) * (edge.node2.x - edge.node1.x))) continue;
                ++n;
            }
            return n % 2 == 1;
        }

        float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
            return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        }

        EdgeRingHit isPointInPolygon_WindingNumber(float f, float f2, int n) {
            int n2 = 0;
            for (int i = 0; i < this.size(); ++i) {
                Edge edge = (Edge)this.get(i);
                if ((n & 0x10) != 0 && edge.isPointOn(f, f2)) {
                    return EdgeRingHit.OnEdge;
                }
                if (edge.node1.y <= f2) {
                    if (!(edge.node2.y > f2) || !(this.isLeft(edge.node1.x, edge.node1.y, edge.node2.x, edge.node2.y, f, f2) > 0.0f)) continue;
                    ++n2;
                    continue;
                }
                if (!(edge.node2.y <= f2) || !(this.isLeft(edge.node1.x, edge.node1.y, edge.node2.x, edge.node2.y, f, f2) < 0.0f)) continue;
                --n2;
            }
            return n2 == 0 ? EdgeRingHit.Outside : EdgeRingHit.Inside;
        }

        boolean lineSegmentIntersects(float f, float f2, float f3, float f4) {
            Vector2 vector22 = L_lineSegmentIntersects.v1;
            vector22.set(f3 - f, f4 - f2);
            float f5 = vector22.getLength();
            vector22.normalize();
            float f6 = vector22.x;
            float f7 = vector22.y;
            for (int i = 0; i < this.size(); ++i) {
                float f8;
                float f9;
                float f10;
                float f11;
                float f12;
                float f13;
                float f14;
                float f15;
                float f16;
                float f17;
                float f18;
                Edge edge = (Edge)this.get(i);
                if (edge.isPointOn(f, f2) || edge.isPointOn(f3, f4)) continue;
                float f19 = edge.normal.dot(vector22);
                if (f19 >= 0.01f) {
                    // empty if block
                }
                if (!((f18 = ((f17 = (f16 = edge.node2.x) - (f15 = edge.node1.x)) * (f14 = f2 - (f13 = edge.node1.y)) - (f12 = (f11 = edge.node2.y) - f13) * (f10 = f - f15)) * (f9 = 1.0f / (f12 * f6 - f17 * f7))) >= 0.0f) || !(f18 <= f5) || !((f8 = (f14 * f6 - f10 * f7) * f9) >= 0.0f) || !(f8 <= 1.0f)) continue;
                return true;
            }
            return this.isPointInPolygon_WindingNumber((f + f3) / 2.0f, (f2 + f4) / 2.0f, 0) != EdgeRingHit.Outside;
        }

        void getClosestPointOnEdge(float f, float f2, ClosestPointOnEdge closestPointOnEdge) {
            for (int i = 0; i < this.size(); ++i) {
                Edge edge = (Edge)this.get(i);
                edge.getClosestPointOnEdge(f, f2, closestPointOnEdge);
            }
        }

        static EdgeRing alloc() {
            return pool.isEmpty() ? new EdgeRing() : pool.pop();
        }

        public void release() {
            Edge.releaseAll(this);
        }

        static void releaseAll(ArrayList<EdgeRing> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).release();
            }
        }
    }

    private static final class Chunk {
        short wx;
        short wy;
        Square[][][] squares = new Square[10][10][8];
        final ChunkData collision = new ChunkData();
        static final ArrayDeque<Chunk> pool = new ArrayDeque();

        private Chunk() {
        }

        void init(int n, int n2) {
            this.wx = (short)n;
            this.wy = (short)n2;
        }

        Square getSquare(int n, int n2, int n3) {
            if ((n -= this.wx * 10) < 0 || n >= 10 || (n2 -= this.wy * 10) < 0 || n2 >= 10 || n3 < 0 || n3 >= 8) {
                return null;
            }
            return this.squares[n][n2][n3];
        }

        void setData(ChunkUpdateTask chunkUpdateTask) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 10; ++j) {
                    for (int k = 0; k < 10; ++k) {
                        Square square = this.squares[k][j][i];
                        int n = chunkUpdateTask.data[k][j][i];
                        if (n == 0) {
                            if (square == null) continue;
                            square.release();
                            this.squares[k][j][i] = null;
                            continue;
                        }
                        if (square == null) {
                            this.squares[k][j][i] = square = Square.alloc();
                        }
                        square.init(this.wx * 10 + k, this.wy * 10 + j, i);
                        square.bits = n;
                        square.cost = chunkUpdateTask.cost[k][j][i];
                    }
                }
            }
            ChunkDataZ.EPOCH = (short)(ChunkDataZ.EPOCH + 1);
        }

        boolean setData(SquareUpdateTask squareUpdateTask) {
            int n = squareUpdateTask.x - this.wx * 10;
            int n2 = squareUpdateTask.y - this.wy * 10;
            if (n < 0 || n >= 10) {
                return false;
            }
            if (n2 < 0 || n2 >= 10) {
                return false;
            }
            Square square = this.squares[n][n2][squareUpdateTask.z];
            if (squareUpdateTask.bits == 0) {
                if (square != null) {
                    square.release();
                    this.squares[n][n2][squareUpdateTask.z] = null;
                    return true;
                }
            } else {
                if (square == null) {
                    this.squares[n][n2][squareUpdateTask.z] = square = Square.alloc().init(squareUpdateTask.x, squareUpdateTask.y, squareUpdateTask.z);
                }
                if (square.bits != squareUpdateTask.bits || square.cost != squareUpdateTask.cost) {
                    square.bits = squareUpdateTask.bits;
                    square.cost = squareUpdateTask.cost;
                    return true;
                }
            }
            return false;
        }

        static Chunk alloc() {
            return pool.isEmpty() ? new Chunk() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class L_render {
        static final Vector2f vector2f = new Vector2f();

        private L_render() {
        }
    }

    public static interface IPathfinder {
        public void Succeeded(Path var1, Mover var2);

        public void Failed(Mover var1);
    }

    private static final class SquareUpdateTask {
        PolygonalMap2 map;
        int x;
        int y;
        int z;
        int bits;
        short cost;
        static final ArrayDeque<SquareUpdateTask> pool = new ArrayDeque();

        private SquareUpdateTask() {
        }

        SquareUpdateTask init(PolygonalMap2 polygonalMap2, IsoGridSquare isoGridSquare) {
            this.map = polygonalMap2;
            this.x = isoGridSquare.x;
            this.y = isoGridSquare.y;
            this.z = isoGridSquare.z;
            this.bits = SquareUpdateTask.getBits(isoGridSquare);
            this.cost = SquareUpdateTask.getCost(isoGridSquare);
            return this;
        }

        void execute() {
            Chunk chunk = this.map.getChunkFromChunkPos(this.x / 10, this.y / 10);
            if (chunk != null && chunk.setData(this)) {
                ChunkDataZ.EPOCH = (short)(ChunkDataZ.EPOCH + 1);
                this.map.rebuild = true;
            }
        }

        static int getBits(IsoGridSquare isoGridSquare) {
            int n = 0;
            if (isoGridSquare.Is(IsoFlagType.solidfloor)) {
                n |= 0x200;
            }
            if (isoGridSquare.isSolid()) {
                n |= 1;
            }
            if (isoGridSquare.isSolidTrans()) {
                n |= 0x400;
            }
            if (isoGridSquare.Is(IsoFlagType.collideW)) {
                n |= 2;
            }
            if (isoGridSquare.Is(IsoFlagType.collideN)) {
                n |= 4;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsTW)) {
                n |= 8;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsMW)) {
                n |= 0x10;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBW)) {
                n |= 0x20;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsTN)) {
                n |= 0x40;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsMN)) {
                n |= 0x80;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBN)) {
                n |= 0x100;
            }
            if (isoGridSquare.Is(IsoFlagType.windowW) || isoGridSquare.Is(IsoFlagType.WindowW)) {
                n |= 0x802;
                if (SquareUpdateTask.isWindowUnblocked(isoGridSquare, false)) {
                    n |= 0x100000;
                }
            }
            if (isoGridSquare.Is(IsoFlagType.windowN) || isoGridSquare.Is(IsoFlagType.WindowN)) {
                n |= 0x1004;
                if (SquareUpdateTask.isWindowUnblocked(isoGridSquare, true)) {
                    n |= 0x200000;
                }
            }
            if (isoGridSquare.Is(IsoFlagType.canPathW)) {
                n |= 0x2000;
            }
            if (isoGridSquare.Is(IsoFlagType.canPathN)) {
                n |= 0x4000;
            }
            for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
                IsoObject isoObject = isoGridSquare.getSpecialObjects().get(i);
                IsoDirections isoDirections = IsoDirections.Max;
                if (isoObject instanceof IsoDoor) {
                    isoDirections = ((IsoDoor)isoObject).getSpriteEdge(false);
                    if (((IsoDoor)isoObject).IsOpen()) {
                        isoDirections = IsoDirections.Max;
                    }
                } else if (isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor()) {
                    isoDirections = ((IsoThumpable)isoObject).getSpriteEdge(false);
                    if (((IsoThumpable)isoObject).IsOpen()) {
                        isoDirections = IsoDirections.Max;
                    }
                }
                if (isoDirections == IsoDirections.W) {
                    n |= 0x2000;
                    n |= 2;
                    continue;
                }
                if (isoDirections == IsoDirections.N) {
                    n |= 0x4000;
                    n |= 4;
                    continue;
                }
                if (isoDirections == IsoDirections.S) {
                    n |= 0x80000;
                    continue;
                }
                if (isoDirections != IsoDirections.E) continue;
                n |= 0x40000;
            }
            if (isoGridSquare.Is(IsoFlagType.DoorWallW)) {
                n |= 0x2000;
                n |= 2;
            }
            if (isoGridSquare.Is(IsoFlagType.DoorWallN)) {
                n |= 0x4000;
                n |= 4;
            }
            if (SquareUpdateTask.hasSquareThumpable(isoGridSquare)) {
                n |= 0x2000;
                n |= 0x4000;
                n |= 0x20000;
            }
            if (SquareUpdateTask.hasWallThumpableN(isoGridSquare)) {
                n |= 0x14000;
            }
            if (SquareUpdateTask.hasWallThumpableW(isoGridSquare)) {
                n |= 0xA000;
            }
            return n;
        }

        static boolean isWindowUnblocked(IsoGridSquare isoGridSquare, boolean bl) {
            for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
                IsoObject isoObject;
                IsoObject isoObject2 = isoGridSquare.getSpecialObjects().get(i);
                if (isoObject2 instanceof IsoThumpable && ((IsoThumpable)(isoObject = (IsoThumpable)isoObject2)).isWindow() && bl == ((IsoThumpable)isoObject).north) {
                    return !((IsoThumpable)isoObject).isBarricaded();
                }
                if (!(isoObject2 instanceof IsoWindow)) continue;
                isoObject = (IsoWindow)isoObject2;
                if (bl != ((IsoWindow)isoObject).north) continue;
                if (((IsoWindow)isoObject).isBarricaded()) {
                    return false;
                }
                if (((IsoWindow)isoObject).isInvincible()) {
                    return false;
                }
                if (((IsoWindow)isoObject).IsOpen()) {
                    return true;
                }
                return ((IsoWindow)isoObject).isDestroyed() && ((IsoWindow)isoObject).isGlassRemoved();
            }
            IsoObject isoObject = isoGridSquare.getWindowFrame(bl);
            return IsoWindowFrame.canClimbThrough(isoObject, null);
        }

        static boolean hasSquareThumpable(IsoGridSquare isoGridSquare) {
            IsoObject isoObject;
            int n;
            for (n = 0; n < isoGridSquare.getSpecialObjects().size(); ++n) {
                isoObject = Type.tryCastTo(isoGridSquare.getSpecialObjects().get(n), IsoThumpable.class);
                if (isoObject == null || !((IsoThumpable)isoObject).isThumpable() || !((IsoThumpable)isoObject).isBlockAllTheSquare()) continue;
                return true;
            }
            for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
                isoObject = isoGridSquare.getObjects().get(n);
                if (!isoObject.isMovedThumpable()) continue;
                return true;
            }
            return false;
        }

        static boolean hasWallThumpableN(IsoGridSquare isoGridSquare) {
            IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.N);
            if (isoGridSquare2 == null) {
                return false;
            }
            for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
                IsoThumpable isoThumpable = Type.tryCastTo(isoGridSquare.getSpecialObjects().get(i), IsoThumpable.class);
                if (isoThumpable == null || isoThumpable.canClimbThrough(null) || isoThumpable.canClimbOver(null) || !isoThumpable.isThumpable() || isoThumpable.isBlockAllTheSquare() || isoThumpable.isDoor() || !isoThumpable.TestCollide(null, isoGridSquare, isoGridSquare2)) continue;
                return true;
            }
            return false;
        }

        static boolean hasWallThumpableW(IsoGridSquare isoGridSquare) {
            IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.W);
            if (isoGridSquare2 == null) {
                return false;
            }
            for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
                IsoThumpable isoThumpable = Type.tryCastTo(isoGridSquare.getSpecialObjects().get(i), IsoThumpable.class);
                if (isoThumpable == null || isoThumpable.canClimbThrough(null) || isoThumpable.canClimbOver(null) || !isoThumpable.isThumpable() || isoThumpable.isBlockAllTheSquare() || isoThumpable.isDoor() || !isoThumpable.TestCollide(null, isoGridSquare, isoGridSquare2)) continue;
                return true;
            }
            return false;
        }

        static short getCost(IsoGridSquare isoGridSquare) {
            short s = 0;
            if (isoGridSquare.HasTree() || isoGridSquare.getProperties().Is("Bush")) {
                s = (short)(s + 5);
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SquareUpdateTask alloc() {
            ArrayDeque<SquareUpdateTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new SquareUpdateTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ArrayDeque<SquareUpdateTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private final class PMThread
    extends Thread {
        public boolean bStop;
        public final Object notifier = new Object();

        private PMThread() {
        }

        @Override
        public void run() {
            while (!this.bStop) {
                try {
                    this.runInner();
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInner() {
            MPStatistic.getInstance().PolyPathThread.Start();
            PolygonalMap2.this.sync.startFrame();
            Object object = PolygonalMap2.this.renderLock;
            synchronized (object) {
                instance.updateThread();
            }
            PolygonalMap2.this.sync.endFrame();
            MPStatistic.getInstance().PolyPathThread.End();
            while (this.shouldWait()) {
                object = this.notifier;
                synchronized (object) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean shouldWait() {
            if (this.bStop) {
                return false;
            }
            if (!PolygonalMap2.instance.chunkTaskQueue.isEmpty()) {
                return false;
            }
            if (!PolygonalMap2.instance.squareTaskQueue.isEmpty()) {
                return false;
            }
            if (!PolygonalMap2.instance.vehicleTaskQueue.isEmpty()) {
                return false;
            }
            if (!PolygonalMap2.instance.requestTaskQueue.isEmpty()) {
                return false;
            }
            return PolygonalMap2.instance.requests.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wake() {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notify();
            }
        }
    }

    private static final class ChunkUpdateTask
    implements IChunkTask {
        PolygonalMap2 map;
        int wx;
        int wy;
        final int[][][] data = new int[10][10][8];
        final short[][][] cost = new short[10][10][8];
        static final ArrayDeque<ChunkUpdateTask> pool = new ArrayDeque();

        private ChunkUpdateTask() {
        }

        ChunkUpdateTask init(PolygonalMap2 polygonalMap2, IsoChunk isoChunk) {
            this.map = polygonalMap2;
            this.wx = isoChunk.wx;
            this.wy = isoChunk.wy;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 10; ++j) {
                    for (int k = 0; k < 10; ++k) {
                        IsoGridSquare isoGridSquare = isoChunk.getGridSquare(k, j, i);
                        if (isoGridSquare == null) {
                            this.data[k][j][i] = 0;
                            this.cost[k][j][i] = 0;
                            continue;
                        }
                        this.data[k][j][i] = SquareUpdateTask.getBits(isoGridSquare);
                        this.cost[k][j][i] = SquareUpdateTask.getCost(isoGridSquare);
                    }
                }
            }
            return this;
        }

        @Override
        public void execute() {
            Chunk chunk = this.map.allocChunkIfNeeded(this.wx, this.wy);
            chunk.setData(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ChunkUpdateTask alloc() {
            ArrayDeque<ChunkUpdateTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new ChunkUpdateTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ArrayDeque<ChunkUpdateTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private static final class ChunkRemoveTask
    implements IChunkTask {
        PolygonalMap2 map;
        int wx;
        int wy;
        static final ArrayDeque<ChunkRemoveTask> pool = new ArrayDeque();

        private ChunkRemoveTask() {
        }

        ChunkRemoveTask init(PolygonalMap2 polygonalMap2, IsoChunk isoChunk) {
            this.map = polygonalMap2;
            this.wx = isoChunk.wx;
            this.wy = isoChunk.wy;
            return this;
        }

        @Override
        public void execute() {
            Cell cell = this.map.getCellFromChunkPos(this.wx, this.wy);
            cell.removeChunk(this.wx, this.wy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ChunkRemoveTask alloc() {
            ArrayDeque<ChunkRemoveTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new ChunkRemoveTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ArrayDeque<ChunkRemoveTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private static final class VehicleAddTask
    implements IVehicleTask {
        PolygonalMap2 map;
        BaseVehicle vehicle;
        final VehiclePoly poly = new VehiclePoly();
        final VehiclePoly polyPlusRadius = new VehiclePoly();
        final TFloatArrayList crawlOffsets = new TFloatArrayList();
        float upVectorDot;
        static final ArrayDeque<VehicleAddTask> pool = new ArrayDeque();

        private VehicleAddTask() {
        }

        @Override
        public void init(PolygonalMap2 polygonalMap2, BaseVehicle baseVehicle) {
            this.map = polygonalMap2;
            this.vehicle = baseVehicle;
            this.poly.init(baseVehicle.getPoly());
            this.polyPlusRadius.init(baseVehicle.getPolyPlusRadius());
            this.crawlOffsets.resetQuick();
            this.crawlOffsets.addAll((TFloatCollection)baseVehicle.getScript().getCrawlOffsets());
            this.upVectorDot = baseVehicle.getUpVectorDot();
        }

        @Override
        public void execute() {
            Vehicle vehicle = Vehicle.alloc();
            vehicle.poly.init(this.poly);
            vehicle.polyPlusRadius.init(this.polyPlusRadius);
            vehicle.crawlOffsets.resetQuick();
            vehicle.crawlOffsets.addAll((TFloatCollection)this.crawlOffsets);
            vehicle.upVectorDot = this.upVectorDot;
            this.map.vehicles.add(vehicle);
            this.map.vehicleMap.put(this.vehicle, vehicle);
            this.vehicle = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static VehicleAddTask alloc() {
            ArrayDeque<VehicleAddTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new VehicleAddTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ArrayDeque<VehicleAddTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private static final class VehicleState {
        BaseVehicle vehicle;
        float x;
        float y;
        float z;
        final Vector3f forward = new Vector3f();
        final VehiclePoly polyPlusRadius = new VehiclePoly();
        static final ArrayDeque<VehicleState> pool = new ArrayDeque();

        private VehicleState() {
        }

        VehicleState init(BaseVehicle baseVehicle) {
            this.vehicle = baseVehicle;
            this.x = baseVehicle.x;
            this.y = baseVehicle.y;
            this.z = baseVehicle.z;
            baseVehicle.getForwardVector(this.forward);
            this.polyPlusRadius.init(baseVehicle.getPolyPlusRadius());
            return this;
        }

        boolean check() {
            boolean bl;
            boolean bl2 = bl = this.x != this.vehicle.x || this.y != this.vehicle.y || (int)this.z != (int)this.vehicle.z;
            if (!bl) {
                BaseVehicle.Vector3fObjectPool vector3fObjectPool = BaseVehicle.TL_vector3f_pool.get();
                Vector3f vector3f = this.vehicle.getForwardVector((Vector3f)vector3fObjectPool.alloc());
                boolean bl3 = bl = this.forward.dot((Vector3fc)vector3f) < 0.999f;
                if (bl) {
                    this.forward.set((Vector3fc)vector3f);
                }
                vector3fObjectPool.release(vector3f);
            }
            if (bl) {
                this.x = this.vehicle.x;
                this.y = this.vehicle.y;
                this.z = this.vehicle.z;
            }
            return bl;
        }

        static VehicleState alloc() {
            return pool.isEmpty() ? new VehicleState() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class VehicleUpdateTask
    implements IVehicleTask {
        PolygonalMap2 map;
        BaseVehicle vehicle;
        final VehiclePoly poly = new VehiclePoly();
        final VehiclePoly polyPlusRadius = new VehiclePoly();
        float upVectorDot;
        static final ArrayDeque<VehicleUpdateTask> pool = new ArrayDeque();

        private VehicleUpdateTask() {
        }

        @Override
        public void init(PolygonalMap2 polygonalMap2, BaseVehicle baseVehicle) {
            this.map = polygonalMap2;
            this.vehicle = baseVehicle;
            this.poly.init(baseVehicle.getPoly());
            this.polyPlusRadius.init(baseVehicle.getPolyPlusRadius());
            this.upVectorDot = baseVehicle.getUpVectorDot();
        }

        @Override
        public void execute() {
            Vehicle vehicle = this.map.vehicleMap.get(this.vehicle);
            vehicle.poly.init(this.poly);
            vehicle.polyPlusRadius.init(this.polyPlusRadius);
            vehicle.upVectorDot = this.upVectorDot;
            this.vehicle = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static VehicleUpdateTask alloc() {
            ArrayDeque<VehicleUpdateTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new VehicleUpdateTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ArrayDeque<VehicleUpdateTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private static final class VehicleRemoveTask
    implements IVehicleTask {
        PolygonalMap2 map;
        BaseVehicle vehicle;
        static final ArrayDeque<VehicleRemoveTask> pool = new ArrayDeque();

        private VehicleRemoveTask() {
        }

        @Override
        public void init(PolygonalMap2 polygonalMap2, BaseVehicle baseVehicle) {
            this.map = polygonalMap2;
            this.vehicle = baseVehicle;
        }

        @Override
        public void execute() {
            Vehicle vehicle = this.map.vehicleMap.remove(this.vehicle);
            if (vehicle != null) {
                this.map.vehicles.remove(vehicle);
                vehicle.release();
            }
            this.vehicle = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static VehicleRemoveTask alloc() {
            ArrayDeque<VehicleRemoveTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new VehicleRemoveTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ArrayDeque<VehicleRemoveTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private static final class Cell {
        PolygonalMap2 map;
        public short cx;
        public short cy;
        public Chunk[][] chunks;
        static final ArrayDeque<Cell> pool = new ArrayDeque();

        private Cell() {
        }

        Cell init(PolygonalMap2 polygonalMap2, int n, int n2) {
            this.map = polygonalMap2;
            this.cx = (short)n;
            this.cy = (short)n2;
            return this;
        }

        Chunk getChunkFromChunkPos(int n, int n2) {
            if (this.chunks == null) {
                return null;
            }
            if ((n -= this.cx * 30) < 0 || n >= 30 || (n2 -= this.cy * 30) < 0 || n2 >= 30) {
                return null;
            }
            return this.chunks[n][n2];
        }

        Chunk allocChunkIfNeeded(int n, int n2) {
            if ((n -= this.cx * 30) < 0 || n >= 30 || (n2 -= this.cy * 30) < 0 || n2 >= 30) {
                return null;
            }
            if (this.chunks == null) {
                this.chunks = new Chunk[30][30];
            }
            if (this.chunks[n][n2] == null) {
                this.chunks[n][n2] = Chunk.alloc();
            }
            this.chunks[n][n2].init(this.cx * 30 + n, this.cy * 30 + n2);
            return this.chunks[n][n2];
        }

        void removeChunk(int n, int n2) {
            if (this.chunks == null) {
                return;
            }
            if ((n -= this.cx * 30) < 0 || n >= 30 || (n2 -= this.cy * 30) < 0 || n2 >= 30) {
                return;
            }
            Chunk chunk = this.chunks[n][n2];
            if (chunk != null) {
                chunk.release();
                this.chunks[n][n2] = null;
            }
        }

        static Cell alloc() {
            return pool.isEmpty() ? new Cell() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static interface IChunkTask {
        public void execute();

        public void release();
    }

    private static interface IVehicleTask {
        public void init(PolygonalMap2 var1, BaseVehicle var2);

        public void execute();

        public void release();
    }

    private static final class PathRequestTask {
        PolygonalMap2 map;
        PathFindRequest request;
        static final ArrayDeque<PathRequestTask> pool = new ArrayDeque();

        private PathRequestTask() {
        }

        PathRequestTask init(PolygonalMap2 polygonalMap2, PathFindRequest pathFindRequest) {
            this.map = polygonalMap2;
            this.request = pathFindRequest;
            return this;
        }

        void execute() {
            if (this.request.mover instanceof IsoPlayer) {
                this.map.requests.playerQ.add(this.request);
            } else if (this.request.mover instanceof IsoZombie && ((IsoZombie)this.request.mover).target != null) {
                this.map.requests.aggroZombieQ.add(this.request);
            } else {
                this.map.requests.otherQ.add(this.request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static PathRequestTask alloc() {
            ArrayDeque<PathRequestTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                return pool.isEmpty() ? new PathRequestTask() : pool.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ArrayDeque<PathRequestTask> arrayDeque = pool;
            synchronized (arrayDeque) {
                assert (!pool.contains(this));
                pool.push(this);
            }
        }
    }

    private static final class ChunkDataZ {
        public Chunk chunk;
        public final ArrayList<Obstacle> obstacles = new ArrayList();
        public final ArrayList<Node> nodes = new ArrayList();
        public int z;
        static short EPOCH = 0;
        short epoch;
        public static final ObjectPool<ChunkDataZ> pool = new ObjectPool<ChunkDataZ>(ChunkDataZ::new);

        private ChunkDataZ() {
        }

        public void init(Chunk chunk, int n) {
            int n2;
            int n3;
            int n4;
            Object object;
            int n5;
            this.chunk = chunk;
            this.z = n;
            this.epoch = EPOCH;
            if (PolygonalMap2.instance.clipperThread == null) {
                PolygonalMap2.instance.clipperThread = new Clipper();
            }
            Clipper clipper = PolygonalMap2.instance.clipperThread;
            clipper.clear();
            int n6 = chunk.wx * 10;
            int n7 = chunk.wy * 10;
            for (int i = n7 - 2; i < n7 + 10 + 2; ++i) {
                for (n5 = n6 - 2; n5 < n6 + 10 + 2; ++n5) {
                    Square square = instance.getSquare(n5, i, n);
                    if (square == null || !square.has(512)) {
                        clipper.addAABB(n5, i, (float)n5 + 1.0f, (float)i + 1.0f);
                        continue;
                    }
                    if (square.isReallySolid() || square.has(128) || square.has(64) || square.has(16) || square.has(8)) {
                        clipper.addAABBBevel((float)n5 - 0.3f, (float)i - 0.3f, (float)n5 + 1.0f + 0.3f, (float)i + 1.0f + 0.3f, 0.19800001f);
                    }
                    if (square.has(2) || square.has(256)) {
                        clipper.addAABBBevel((float)n5 - 0.3f, (float)i - 0.3f, (float)n5 + 0.3f, (float)i + 1.0f + 0.3f, 0.19800001f);
                    }
                    if (square.has(4) || square.has(32)) {
                        clipper.addAABBBevel((float)n5 - 0.3f, (float)i - 0.3f, (float)n5 + 1.0f + 0.3f, (float)i + 0.3f, 0.19800001f);
                    }
                    if (square.has(256) && (object = instance.getSquare(n5 + 1, i, n)) != null) {
                        clipper.addAABBBevel((float)(n5 + 1) - 0.3f, (float)i - 0.3f, (float)(n5 + 1) + 0.3f, (float)i + 1.0f + 0.3f, 0.19800001f);
                    }
                    if (!square.has(32) || (object = instance.getSquare(n5, i + 1, n)) == null) continue;
                    clipper.addAABBBevel((float)n5 - 0.3f, (float)(i + 1) - 0.3f, (float)n5 + 1.0f + 0.3f, (float)(i + 1) + 0.3f, 0.19800001f);
                }
            }
            ByteBuffer byteBuffer = PolygonalMap2.instance.xyBufferThread;
            n5 = clipper.generatePolygons();
            for (n4 = 0; n4 < n5; ++n4) {
                byteBuffer.clear();
                clipper.getPolygon(n4, byteBuffer);
                object = Obstacle.alloc().init((IsoGridSquare)null);
                this.getEdgesFromBuffer(byteBuffer, (Obstacle)object, true);
                n3 = byteBuffer.getShort();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.getEdgesFromBuffer(byteBuffer, (Obstacle)object, false);
                }
                ((Obstacle)object).calcBounds();
                this.obstacles.add((Obstacle)object);
            }
            n4 = chunk.wx * 10;
            int n8 = chunk.wy * 10;
            n3 = n4 + 10;
            n2 = n8 + 10;
            ImmutableRectF immutableRectF = ImmutableRectF.alloc();
            immutableRectF.init(n4 -= 2, n8 -= 2, (n3 += 2) - n4, (n2 += 2) - n8);
            ImmutableRectF immutableRectF2 = ImmutableRectF.alloc();
            for (int i = 0; i < PolygonalMap2.instance.vehicles.size(); ++i) {
                Vehicle vehicle = PolygonalMap2.instance.vehicles.get(i);
                VehiclePoly vehiclePoly = vehicle.polyPlusRadius;
                float f = Math.min(vehiclePoly.x1, Math.min(vehiclePoly.x2, Math.min(vehiclePoly.x3, vehiclePoly.x4)));
                float f2 = Math.min(vehiclePoly.y1, Math.min(vehiclePoly.y2, Math.min(vehiclePoly.y3, vehiclePoly.y4)));
                float f3 = Math.max(vehiclePoly.x1, Math.max(vehiclePoly.x2, Math.max(vehiclePoly.x3, vehiclePoly.x4)));
                float f4 = Math.max(vehiclePoly.y1, Math.max(vehiclePoly.y2, Math.max(vehiclePoly.y3, vehiclePoly.y4)));
                immutableRectF2.init(f, f2, f3 - f, f4 - f2);
                if (!immutableRectF.intersects(immutableRectF2)) continue;
                this.addEdgesForVehicle(vehicle);
            }
            immutableRectF.release();
            immutableRectF2.release();
        }

        private void getEdgesFromBuffer(ByteBuffer byteBuffer, Obstacle obstacle, boolean bl) {
            Object object;
            int n;
            int n2 = byteBuffer.getShort();
            if (n2 < 3) {
                byteBuffer.position(byteBuffer.position() + n2 * 4 * 2);
                return;
            }
            EdgeRing edgeRing = obstacle.outer;
            if (!bl) {
                edgeRing = EdgeRing.alloc();
                edgeRing.clear();
                obstacle.inner.add(edgeRing);
            }
            int n3 = this.nodes.size();
            for (n = 0; n < n2; ++n) {
                float f = byteBuffer.getFloat();
                float f2 = byteBuffer.getFloat();
                object = Node.alloc().init(f, f2, this.z);
                ((Node)object).flags |= 4;
                this.nodes.add(n3, (Node)object);
            }
            for (n = n3; n < this.nodes.size() - 1; ++n) {
                Node node = this.nodes.get(n);
                Node node2 = this.nodes.get(n + 1);
                object = Edge.alloc().init(node, node2, obstacle, edgeRing);
                edgeRing.add((Edge)object);
            }
            Node node = this.nodes.get(this.nodes.size() - 1);
            Node node3 = this.nodes.get(n3);
            Edge edge = Edge.alloc().init(node, node3, obstacle, edgeRing);
            edgeRing.add(edge);
        }

        private void addEdgesForVehicle(Vehicle vehicle) {
            VehiclePoly vehiclePoly = vehicle.polyPlusRadius;
            int n = (int)vehiclePoly.z;
            Node node = Node.alloc().init(vehiclePoly.x1, vehiclePoly.y1, n);
            Node node2 = Node.alloc().init(vehiclePoly.x2, vehiclePoly.y2, n);
            Node node3 = Node.alloc().init(vehiclePoly.x3, vehiclePoly.y3, n);
            Node node4 = Node.alloc().init(vehiclePoly.x4, vehiclePoly.y4, n);
            node.flags |= 4;
            node2.flags |= 4;
            node3.flags |= 4;
            node4.flags |= 4;
            Obstacle obstacle = Obstacle.alloc().init(vehicle);
            this.obstacles.add(obstacle);
            Edge edge = Edge.alloc().init(node, node2, obstacle, obstacle.outer);
            Edge edge2 = Edge.alloc().init(node2, node3, obstacle, obstacle.outer);
            Edge edge3 = Edge.alloc().init(node3, node4, obstacle, obstacle.outer);
            Edge edge4 = Edge.alloc().init(node4, node, obstacle, obstacle.outer);
            obstacle.outer.add(edge);
            obstacle.outer.add(edge2);
            obstacle.outer.add(edge3);
            obstacle.outer.add(edge4);
            obstacle.calcBounds();
            this.nodes.add(node);
            this.nodes.add(node2);
            this.nodes.add(node3);
            this.nodes.add(node4);
        }

        public void clear() {
            Node.releaseAll(this.nodes);
            this.nodes.clear();
            Obstacle.releaseAll(this.obstacles);
            this.obstacles.clear();
        }
    }

    private static final class PointPool {
        final ArrayDeque<Point> pool = new ArrayDeque();

        private PointPool() {
        }

        Point alloc() {
            return this.pool.isEmpty() ? new Point() : this.pool.pop();
        }

        void release(Point point) {
            this.pool.push(point);
        }
    }

    public static final class Point {
        public int x;
        public int y;

        Point init(int n, int n2) {
            this.x = n;
            this.y = n2;
            return this;
        }

        public boolean equals(Object object) {
            return object instanceof Point && ((Point)object).x == this.x && ((Point)object).y == this.y;
        }
    }

    private static final class ConnectedRegions {
        PolygonalMap2 map;
        HashSet<Chunk> doneChunks = new HashSet();
        int minX;
        int minY;
        int maxX;
        int maxY;
        int MINX;
        int MINY;
        int WIDTH;
        int HEIGHT;
        BooleanGrid visited = new BooleanGrid(this.WIDTH, this.WIDTH);
        int[] stack;
        int stackLen;
        int[] choices;
        int choicesLen;

        private ConnectedRegions() {
        }

        void findAdjacentChunks(int n, int n2) {
            this.doneChunks.clear();
            this.minY = Integer.MAX_VALUE;
            this.minX = Integer.MAX_VALUE;
            this.maxY = Integer.MIN_VALUE;
            this.maxX = Integer.MIN_VALUE;
            Chunk chunk = this.map.getChunkFromSquarePos(n, n2);
            this.findAdjacentChunks(chunk);
        }

        void findAdjacentChunks(Chunk chunk) {
            if (chunk == null || this.doneChunks.contains(chunk)) {
                return;
            }
            this.minX = Math.min(this.minX, chunk.wx);
            this.minY = Math.min(this.minY, chunk.wy);
            this.maxX = Math.max(this.maxX, chunk.wx);
            this.maxY = Math.max(this.maxY, chunk.wy);
            this.doneChunks.add(chunk);
            Chunk chunk2 = this.map.getChunkFromChunkPos(chunk.wx - 1, chunk.wy);
            Chunk chunk3 = this.map.getChunkFromChunkPos(chunk.wx, chunk.wy - 1);
            Chunk chunk4 = this.map.getChunkFromChunkPos(chunk.wx + 1, chunk.wy);
            Chunk chunk5 = this.map.getChunkFromChunkPos(chunk.wx, chunk.wy + 1);
            this.findAdjacentChunks(chunk2);
            this.findAdjacentChunks(chunk3);
            this.findAdjacentChunks(chunk4);
            this.findAdjacentChunks(chunk5);
        }

        void floodFill(int n, int n2) {
            int n3;
            this.findAdjacentChunks(n, n2);
            this.MINX = this.minX * 10;
            this.MINY = this.minY * 10;
            this.WIDTH = (this.maxX - this.minX + 1) * 10;
            this.HEIGHT = (this.maxY - this.minY + 1) * 10;
            this.visited = new BooleanGrid(this.WIDTH, this.WIDTH);
            this.stack = new int[this.WIDTH * this.WIDTH];
            this.choices = new int[this.WIDTH * this.HEIGHT];
            this.stackLen = 0;
            this.choicesLen = 0;
            if (!this.push(n, n2)) {
                return;
            }
            while ((n3 = this.pop()) != -1) {
                int n4 = this.MINX + (n3 & 0xFFFF);
                int n5 = this.MINY + (n3 >> 16) & 0xFFFF;
                while (this.shouldVisit(n4, n5, n4, n5 - 1)) {
                    --n5;
                }
                boolean bl = false;
                boolean bl2 = false;
                do {
                    if (!this.visit(n4, n5)) {
                        return;
                    }
                    if (!bl && this.shouldVisit(n4, n5, n4 - 1, n5)) {
                        if (!this.push(n4 - 1, n5)) {
                            return;
                        }
                        bl = true;
                    } else if (bl && !this.shouldVisit(n4, n5, n4 - 1, n5)) {
                        bl = false;
                    } else if (bl && !this.shouldVisit(n4 - 1, n5, n4 - 1, n5 - 1) && !this.push(n4 - 1, n5)) {
                        return;
                    }
                    if (!bl2 && this.shouldVisit(n4, n5, n4 + 1, n5)) {
                        if (!this.push(n4 + 1, n5)) {
                            return;
                        }
                        bl2 = true;
                        continue;
                    }
                    if (bl2 && !this.shouldVisit(n4, n5, n4 + 1, n5)) {
                        bl2 = false;
                        continue;
                    }
                    if (!bl2 || this.shouldVisit(n4 + 1, n5, n4 + 1, n5 - 1) || this.push(n4 + 1, n5)) continue;
                    return;
                } while (this.shouldVisit(n4, ++n5 - 1, n4, n5));
            }
            System.out.println("#choices=" + this.choicesLen);
        }

        boolean shouldVisit(int n, int n2, int n3, int n4) {
            if (n3 >= this.MINX + this.WIDTH || n3 < this.MINX) {
                return false;
            }
            if (n4 >= this.MINY + this.WIDTH || n4 < this.MINY) {
                return false;
            }
            if (this.visited.getValue(this.gridX(n3), this.gridY(n4))) {
                return false;
            }
            Square square = instance.getSquare(n, n2, 0);
            Square square2 = instance.getSquare(n3, n4, 0);
            if (square == null || square2 == null) {
                return false;
            }
            return !this.isBlocked(square, square2, false);
        }

        boolean visit(int n, int n2) {
            if (this.choicesLen >= this.WIDTH * this.WIDTH) {
                return false;
            }
            this.choices[this.choicesLen++] = this.gridY(n2) << 16 | (short)this.gridX(n);
            this.visited.setValue(this.gridX(n), this.gridY(n2), true);
            return true;
        }

        boolean push(int n, int n2) {
            if (this.stackLen >= this.WIDTH * this.WIDTH) {
                return false;
            }
            this.stack[this.stackLen++] = this.gridY(n2) << 16 | (short)this.gridX(n);
            return true;
        }

        int pop() {
            return this.stackLen == 0 ? -1 : this.stack[--this.stackLen];
        }

        int gridX(int n) {
            return n - this.MINX;
        }

        int gridY(int n) {
            return n - this.MINY;
        }

        boolean isBlocked(Square square, Square square2, boolean bl) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            assert (Math.abs(square.x - square2.x) <= 1);
            assert (Math.abs(square.y - square2.y) <= 1);
            assert (square.z == square2.z);
            assert (square != square2);
            boolean bl5 = square2.x < square.x;
            boolean bl6 = square2.x > square.x;
            boolean bl7 = square2.y < square.y;
            boolean bl8 = bl4 = square2.y > square.y;
            if (square2.isReallySolid()) {
                return true;
            }
            if (square2.y < square.y && square.has(64)) {
                return true;
            }
            if (square2.x < square.x && square.has(8)) {
                return true;
            }
            if (square2.y > square.y && square2.x == square.x && square2.has(64)) {
                return true;
            }
            if (square2.x > square.x && square2.y == square.y && square2.has(8)) {
                return true;
            }
            if (square2.x != square.x && square2.has(448)) {
                return true;
            }
            if (square2.y != square.y && square2.has(56)) {
                return true;
            }
            if (square2.x != square.x && square.has(448)) {
                return true;
            }
            if (square2.y != square.y && square.has(56)) {
                return true;
            }
            if (!square2.has(512) && !square2.has(504)) {
                return true;
            }
            boolean bl9 = bl7 && square.has(4) && (square.x != square2.x || bl || !square.has(16384));
            boolean bl10 = bl5 && square.has(2) && (square.y != square2.y || bl || !square.has(8192));
            boolean bl11 = bl4 && square2.has(4) && (square.x != square2.x || bl || !square2.has(16384));
            boolean bl12 = bl3 = bl6 && square2.has(2) && (square.y != square2.y || bl || !square2.has(8192));
            if (bl9 || bl10 || bl11 || bl3) {
                return true;
            }
            boolean bl13 = bl2 = square2.x != square.x && square2.y != square.y;
            if (bl2) {
                Square square3 = instance.getSquare(square.x, square2.y, square.z);
                Square square4 = instance.getSquare(square2.x, square.y, square.z);
                assert (square3 != square && square3 != square2);
                assert (square4 != square && square4 != square2);
                if (square2.x == square.x + 1 && square2.y == square.y + 1 && square3 != null && square4 != null && square3.has(4096) && square4.has(2048)) {
                    return true;
                }
                if (square2.x == square.x - 1 && square2.y == square.y - 1 && square3 != null && square4 != null && square3.has(2048) && square4.has(4096)) {
                    return true;
                }
                if (square3 != null && this.isBlocked(square, square3, true)) {
                    return true;
                }
                if (square4 != null && this.isBlocked(square, square4, true)) {
                    return true;
                }
                if (square3 != null && this.isBlocked(square2, square3, true)) {
                    return true;
                }
                if (square4 != null && this.isBlocked(square2, square4, true)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static final class LiangBarsky {
        private final double[] p = new double[4];
        private final double[] q = new double[4];

        public boolean lineRectIntersect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            return this.lineRectIntersect(f, f2, f3, f4, f5, f6, f7, f8, null);
        }

        public boolean lineRectIntersect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, double[] dArray) {
            this.p[0] = -f3;
            this.p[1] = f3;
            this.p[2] = -f4;
            this.p[3] = f4;
            this.q[0] = f - f5;
            this.q[1] = f7 - f;
            this.q[2] = f2 - f6;
            this.q[3] = f8 - f2;
            double d = 0.0;
            double d2 = 1.0;
            for (int i = 0; i < 4; ++i) {
                if (this.p[i] == 0.0) {
                    if (!(this.q[i] < 0.0)) continue;
                    return false;
                }
                double d3 = this.q[i] / this.p[i];
                if (this.p[i] < 0.0 && d < d3) {
                    d = d3;
                    continue;
                }
                if (!(this.p[i] > 0.0) || !(d2 > d3)) continue;
                d2 = d3;
            }
            if (d >= d2) {
                return false;
            }
            if (dArray != null) {
                dArray[0] = d;
                dArray[1] = d2;
            }
            return true;
        }
    }

    private static final class ChunkData {
        final ChunkDataZ[] data = new ChunkDataZ[8];

        private ChunkData() {
        }

        public ChunkDataZ init(Chunk chunk, int n) {
            if (this.data[n] == null) {
                this.data[n] = ChunkDataZ.pool.alloc();
                this.data[n].init(chunk, n);
            } else if (this.data[n].epoch != ChunkDataZ.EPOCH) {
                this.data[n].clear();
                this.data[n].init(chunk, n);
            }
            return this.data[n];
        }

        public void clear() {
            PZArrayUtil.forEach(this.data, chunkDataZ -> {
                if (chunkDataZ != null) {
                    chunkDataZ.clear();
                    ChunkDataZ.pool.release((ChunkDataZ)chunkDataZ);
                }
            });
            Arrays.fill(this.data, null);
        }
    }

    private static final class GoalNode
    implements IGoalNode {
        SearchNode searchNode;

        private GoalNode() {
        }

        GoalNode init(SearchNode searchNode) {
            this.searchNode = searchNode;
            return this;
        }

        public boolean inGoal(ISearchNode iSearchNode) {
            if (this.searchNode.tx != -1) {
                SearchNode searchNode = (SearchNode)iSearchNode;
                int n = (int)searchNode.getX();
                int n2 = (int)searchNode.getY();
                if (n % 10 == 0 && instance.getChunkFromSquarePos(n - 1, n2) == null) {
                    return true;
                }
                if (n % 10 == 9 && instance.getChunkFromSquarePos(n + 1, n2) == null) {
                    return true;
                }
                if (n2 % 10 == 0 && instance.getChunkFromSquarePos(n, n2 - 1) == null) {
                    return true;
                }
                return n2 % 10 == 9 && instance.getChunkFromSquarePos(n, n2 + 1) == null;
            }
            return iSearchNode == this.searchNode;
        }
    }

    private static final class ImmutableRectF {
        private float x;
        private float y;
        private float w;
        private float h;
        static final ArrayDeque<ImmutableRectF> pool = new ArrayDeque();

        private ImmutableRectF() {
        }

        ImmutableRectF init(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
            return this;
        }

        float left() {
            return this.x;
        }

        float top() {
            return this.y;
        }

        float right() {
            return this.x + this.w;
        }

        float bottom() {
            return this.y + this.h;
        }

        float width() {
            return this.w;
        }

        float height() {
            return this.h;
        }

        boolean containsPoint(float f, float f2) {
            return f >= this.left() && f < this.right() && f2 >= this.top() && f2 < this.bottom();
        }

        boolean intersects(ImmutableRectF immutableRectF) {
            return this.left() < immutableRectF.right() && this.right() > immutableRectF.left() && this.top() < immutableRectF.bottom() && this.bottom() > immutableRectF.top();
        }

        static ImmutableRectF alloc() {
            return pool.isEmpty() ? new ImmutableRectF() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static final class Intersection {
        Edge edge1;
        Edge edge2;
        float dist1;
        float dist2;
        Node nodeSplit;

        Intersection(Edge edge, Edge edge2, float f, float f2, float f3, float f4) {
            this.edge1 = edge;
            this.edge2 = edge2;
            this.dist1 = f;
            this.dist2 = f2;
            this.nodeSplit = Node.alloc().init(f3, f4, edge.node1.z);
        }

        Intersection(Edge edge, Edge edge2, float f, float f2, Node node) {
            this.edge1 = edge;
            this.edge2 = edge2;
            this.dist1 = f;
            this.dist2 = f2;
            this.nodeSplit = node;
        }

        Edge split(Edge edge) {
            return edge.split(this.nodeSplit);
        }
    }

    private static final class ClusterOutlineGrid {
        ClusterOutline[] elements;
        int W;
        int H;

        private ClusterOutlineGrid() {
        }

        ClusterOutlineGrid setSize(int n, int n2) {
            if (this.elements == null || this.elements.length < n * n2) {
                this.elements = new ClusterOutline[n * n2];
            }
            this.W = n;
            this.H = n2;
            return this;
        }

        void releaseElements() {
            for (int i = 0; i < this.H; ++i) {
                for (int j = 0; j < this.W; ++j) {
                    if (this.elements[j + i * this.W] == null) continue;
                    this.elements[j + i * this.W].release();
                    this.elements[j + i * this.W] = null;
                }
            }
        }

        void setInner(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            if (clusterOutline != null) {
                clusterOutline.inner = true;
            }
        }

        void setWest(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            if (clusterOutline != null) {
                clusterOutline.w = true;
            }
        }

        void setNorth(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            if (clusterOutline != null) {
                clusterOutline.n = true;
            }
        }

        void setEast(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            if (clusterOutline != null) {
                clusterOutline.e = true;
            }
        }

        void setSouth(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            if (clusterOutline != null) {
                clusterOutline.s = true;
            }
        }

        boolean canTrace_W(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            return clusterOutline != null && clusterOutline.inner && clusterOutline.w && !clusterOutline.tw;
        }

        boolean canTrace_N(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            return clusterOutline != null && clusterOutline.inner && clusterOutline.n && !clusterOutline.tn;
        }

        boolean canTrace_E(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            return clusterOutline != null && clusterOutline.inner && clusterOutline.e && !clusterOutline.te;
        }

        boolean canTrace_S(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            return clusterOutline != null && clusterOutline.inner && clusterOutline.s && !clusterOutline.ts;
        }

        boolean isInner(int n, int n2, int n3) {
            ClusterOutline clusterOutline = this.get(n, n2, n3);
            return clusterOutline != null && (clusterOutline.start || clusterOutline.inner);
        }

        ClusterOutline get(int n, int n2, int n3) {
            if (n < 0 || n >= this.W) {
                return null;
            }
            if (n2 < 0 || n2 >= this.H) {
                return null;
            }
            if (this.elements[n + n2 * this.W] == null) {
                this.elements[n + n2 * this.W] = ClusterOutline.alloc().init(n, n2, n3);
            }
            return this.elements[n + n2 * this.W];
        }

        void trace_W(ClusterOutline clusterOutline, ArrayList<Node> arrayList, Node node) {
            int n = clusterOutline.x;
            int n2 = clusterOutline.y;
            int n3 = clusterOutline.z;
            if (node != null) {
                node.setXY(n, n2);
            } else {
                Node node2 = Node.alloc().init(n, n2, n3);
                arrayList.add(node2);
            }
            clusterOutline.tw = true;
            if (this.canTrace_S(n - 1, n2 - 1, n3)) {
                this.get((int)n, (int)(n2 - 1), (int)n3).innerCorner = true;
                this.trace_S(this.get(n - 1, n2 - 1, n3), arrayList, null);
            } else if (this.canTrace_W(n, n2 - 1, n3)) {
                this.trace_W(this.get(n, n2 - 1, n3), arrayList, arrayList.get(arrayList.size() - 1));
            } else if (this.canTrace_N(n, n2, n3)) {
                this.trace_N(clusterOutline, arrayList, null);
            }
        }

        void trace_N(ClusterOutline clusterOutline, ArrayList<Node> arrayList, Node node) {
            int n = clusterOutline.x;
            int n2 = clusterOutline.y;
            int n3 = clusterOutline.z;
            if (node != null) {
                node.setXY(n + 1, n2);
            } else {
                Node node2 = Node.alloc().init(n + 1, n2, n3);
                arrayList.add(node2);
            }
            clusterOutline.tn = true;
            if (this.canTrace_W(n + 1, n2 - 1, n3)) {
                this.get((int)(n + 1), (int)n2, (int)n3).innerCorner = true;
                this.trace_W(this.get(n + 1, n2 - 1, n3), arrayList, null);
            } else if (this.canTrace_N(n + 1, n2, n3)) {
                this.trace_N(this.get(n + 1, n2, n3), arrayList, arrayList.get(arrayList.size() - 1));
            } else if (this.canTrace_E(n, n2, n3)) {
                this.trace_E(clusterOutline, arrayList, null);
            }
        }

        void trace_E(ClusterOutline clusterOutline, ArrayList<Node> arrayList, Node node) {
            int n = clusterOutline.x;
            int n2 = clusterOutline.y;
            int n3 = clusterOutline.z;
            if (node != null) {
                node.setXY(n + 1, n2 + 1);
            } else {
                Node node2 = Node.alloc().init(n + 1, n2 + 1, n3);
                arrayList.add(node2);
            }
            clusterOutline.te = true;
            if (this.canTrace_N(n + 1, n2 + 1, n3)) {
                this.get((int)n, (int)(n2 + 1), (int)n3).innerCorner = true;
                this.trace_N(this.get(n + 1, n2 + 1, n3), arrayList, null);
            } else if (this.canTrace_E(n, n2 + 1, n3)) {
                this.trace_E(this.get(n, n2 + 1, n3), arrayList, arrayList.get(arrayList.size() - 1));
            } else if (this.canTrace_S(n, n2, n3)) {
                this.trace_S(clusterOutline, arrayList, null);
            }
        }

        void trace_S(ClusterOutline clusterOutline, ArrayList<Node> arrayList, Node node) {
            int n = clusterOutline.x;
            int n2 = clusterOutline.y;
            int n3 = clusterOutline.z;
            if (node != null) {
                node.setXY(n, n2 + 1);
            } else {
                Node node2 = Node.alloc().init(n, n2 + 1, n3);
                arrayList.add(node2);
            }
            clusterOutline.ts = true;
            if (this.canTrace_E(n - 1, n2 + 1, n3)) {
                this.get((int)(n - 1), (int)n2, (int)n3).innerCorner = true;
                this.trace_E(this.get(n - 1, n2 + 1, n3), arrayList, null);
            } else if (this.canTrace_S(n - 1, n2, n3)) {
                this.trace_S(this.get(n - 1, n2, n3), arrayList, arrayList.get(arrayList.size() - 1));
            } else if (this.canTrace_W(n, n2, n3)) {
                this.trace_W(clusterOutline, arrayList, null);
            }
        }

        ArrayList<Node> trace(ClusterOutline clusterOutline) {
            int n = clusterOutline.x;
            int n2 = clusterOutline.y;
            int n3 = clusterOutline.z;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node = Node.alloc().init(n, n2, n3);
            arrayList.add(node);
            clusterOutline.start = true;
            this.trace_N(clusterOutline, arrayList, null);
            Node node2 = arrayList.get(arrayList.size() - 1);
            float f = 0.1f;
            if ((int)(node.x + f) == (int)(node2.x + f) && (int)(node.y + f) == (int)(node2.y + f)) {
                node2.release();
                arrayList.set(arrayList.size() - 1, node);
            }
            return arrayList;
        }
    }

    private static final class ClusterOutline {
        int x;
        int y;
        int z;
        boolean w;
        boolean n;
        boolean e;
        boolean s;
        boolean tw;
        boolean tn;
        boolean te;
        boolean ts;
        boolean inner;
        boolean innerCorner;
        boolean start;
        static final ArrayDeque<ClusterOutline> pool = new ArrayDeque();

        private ClusterOutline() {
        }

        ClusterOutline init(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.s = false;
            this.e = false;
            this.n = false;
            this.w = false;
            this.ts = false;
            this.te = false;
            this.tn = false;
            this.tw = false;
            this.start = false;
            this.innerCorner = false;
            this.inner = false;
            return this;
        }

        static ClusterOutline alloc() {
            return pool.isEmpty() ? new ClusterOutline() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    @Deprecated
    private static final class ObjectOutline {
        int x;
        int y;
        int z;
        boolean nw;
        boolean nw_w;
        boolean nw_n;
        boolean nw_e;
        boolean nw_s;
        boolean w_w;
        boolean w_e;
        boolean w_cutoff;
        boolean n_n;
        boolean n_s;
        boolean n_cutoff;
        ArrayList<Node> nodes;
        static final ArrayDeque<ObjectOutline> pool = new ArrayDeque();

        private ObjectOutline() {
        }

        ObjectOutline init(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.nw_e = false;
            this.nw_n = false;
            this.nw_w = false;
            this.nw = false;
            this.w_cutoff = false;
            this.w_e = false;
            this.w_w = false;
            this.n_cutoff = false;
            this.n_s = false;
            this.n_n = false;
            return this;
        }

        static void setSolid(int n, int n2, int n3, ObjectOutline[][] objectOutlineArray) {
            ObjectOutline.setWest(n, n2, n3, objectOutlineArray);
            ObjectOutline.setNorth(n, n2, n3, objectOutlineArray);
            ObjectOutline.setWest(n + 1, n2, n3, objectOutlineArray);
            ObjectOutline.setNorth(n, n2 + 1, n3, objectOutlineArray);
        }

        static void setWest(int n, int n2, int n3, ObjectOutline[][] objectOutlineArray) {
            ObjectOutline objectOutline = ObjectOutline.get(n, n2, n3, objectOutlineArray);
            if (objectOutline != null) {
                if (objectOutline.nw) {
                    objectOutline.nw_s = false;
                } else {
                    objectOutline.nw = true;
                    objectOutline.nw_w = true;
                    objectOutline.nw_n = true;
                    objectOutline.nw_e = true;
                    objectOutline.nw_s = false;
                }
                objectOutline.w_w = true;
                objectOutline.w_e = true;
            }
            ObjectOutline objectOutline2 = objectOutline;
            objectOutline = ObjectOutline.get(n, n2 + 1, n3, objectOutlineArray);
            if (objectOutline == null) {
                if (objectOutline2 != null) {
                    objectOutline2.w_cutoff = true;
                }
            } else if (objectOutline.nw) {
                objectOutline.nw_n = false;
            } else {
                objectOutline.nw = true;
                objectOutline.nw_n = false;
                objectOutline.nw_w = true;
                objectOutline.nw_e = true;
                objectOutline.nw_s = true;
            }
        }

        static void setNorth(int n, int n2, int n3, ObjectOutline[][] objectOutlineArray) {
            ObjectOutline objectOutline = ObjectOutline.get(n, n2, n3, objectOutlineArray);
            if (objectOutline != null) {
                if (objectOutline.nw) {
                    objectOutline.nw_e = false;
                } else {
                    objectOutline.nw = true;
                    objectOutline.nw_w = true;
                    objectOutline.nw_n = true;
                    objectOutline.nw_e = false;
                    objectOutline.nw_s = true;
                }
                objectOutline.n_n = true;
                objectOutline.n_s = true;
            }
            ObjectOutline objectOutline2 = objectOutline;
            objectOutline = ObjectOutline.get(n + 1, n2, n3, objectOutlineArray);
            if (objectOutline == null) {
                if (objectOutline2 != null) {
                    objectOutline2.n_cutoff = true;
                }
            } else if (objectOutline.nw) {
                objectOutline.nw_w = false;
            } else {
                objectOutline.nw = true;
                objectOutline.nw_n = true;
                objectOutline.nw_w = false;
                objectOutline.nw_e = true;
                objectOutline.nw_s = true;
            }
        }

        static ObjectOutline get(int n, int n2, int n3, ObjectOutline[][] objectOutlineArray) {
            if (n < 0 || n >= objectOutlineArray.length) {
                return null;
            }
            if (n2 < 0 || n2 >= objectOutlineArray[0].length) {
                return null;
            }
            if (objectOutlineArray[n][n2] == null) {
                objectOutlineArray[n][n2] = ObjectOutline.alloc().init(n, n2, n3);
            }
            return objectOutlineArray[n][n2];
        }

        void trace_NW_N(ObjectOutline[][] objectOutlineArray, Node node) {
            if (node != null) {
                node.setXY((float)this.x + 0.3f, (float)this.y - 0.3f);
            } else {
                Node node2 = Node.alloc().init((float)this.x + 0.3f, (float)this.y - 0.3f, this.z);
                this.nodes.add(node2);
            }
            this.nw_n = false;
            if (this.nw_e) {
                this.trace_NW_E(objectOutlineArray, null);
            } else if (this.n_n) {
                this.trace_N_N(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            }
        }

        void trace_NW_S(ObjectOutline[][] objectOutlineArray, Node node) {
            Object object;
            if (node != null) {
                node.setXY((float)this.x - 0.3f, (float)this.y + 0.3f);
            } else {
                object = Node.alloc().init((float)this.x - 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((Node)object);
            }
            this.nw_s = false;
            if (this.nw_w) {
                this.trace_NW_W(objectOutlineArray, null);
            } else {
                object = ObjectOutline.get(this.x - 1, this.y, this.z, objectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((ObjectOutline)object).n_s) {
                    ((ObjectOutline)object).nodes = this.nodes;
                    ((ObjectOutline)object).trace_N_S(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
                }
            }
        }

        void trace_NW_W(ObjectOutline[][] objectOutlineArray, Node node) {
            Object object;
            if (node != null) {
                node.setXY((float)this.x - 0.3f, (float)this.y - 0.3f);
            } else {
                object = Node.alloc().init((float)this.x - 0.3f, (float)this.y - 0.3f, this.z);
                this.nodes.add((Node)object);
            }
            this.nw_w = false;
            if (this.nw_n) {
                this.trace_NW_N(objectOutlineArray, null);
            } else {
                object = ObjectOutline.get(this.x, this.y - 1, this.z, objectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((ObjectOutline)object).w_w) {
                    ((ObjectOutline)object).nodes = this.nodes;
                    ((ObjectOutline)object).trace_W_W(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
                }
            }
        }

        void trace_NW_E(ObjectOutline[][] objectOutlineArray, Node node) {
            if (node != null) {
                node.setXY((float)this.x + 0.3f, (float)this.y + 0.3f);
            } else {
                Node node2 = Node.alloc().init((float)this.x + 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add(node2);
            }
            this.nw_e = false;
            if (this.nw_s) {
                this.trace_NW_S(objectOutlineArray, null);
            } else if (this.w_e) {
                this.trace_W_E(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            }
        }

        void trace_W_E(ObjectOutline[][] objectOutlineArray, Node node) {
            Object object;
            if (node != null) {
                node.setXY((float)this.x + 0.3f, (float)(this.y + 1) - 0.3f);
            } else {
                object = Node.alloc().init((float)this.x + 0.3f, (float)(this.y + 1) - 0.3f, this.z);
                this.nodes.add((Node)object);
            }
            this.w_e = false;
            if (this.w_cutoff) {
                object = this.nodes.get(this.nodes.size() - 1);
                ((Node)object).setXY((float)this.x + 0.3f, (float)(this.y + 1) + 0.3f);
                object = Node.alloc().init((float)this.x - 0.3f, (float)(this.y + 1) + 0.3f, this.z);
                this.nodes.add((Node)object);
                object = Node.alloc().init((float)this.x - 0.3f, (float)(this.y + 1) - 0.3f, this.z);
                this.nodes.add((Node)object);
                this.trace_W_W(objectOutlineArray, (Node)object);
                return;
            }
            object = ObjectOutline.get(this.x, this.y + 1, this.z, objectOutlineArray);
            if (object == null) {
                return;
            }
            if (((ObjectOutline)object).nw && ((ObjectOutline)object).nw_e) {
                ((ObjectOutline)object).nodes = this.nodes;
                ((ObjectOutline)object).trace_NW_E(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else if (((ObjectOutline)object).n_n) {
                ((ObjectOutline)object).nodes = this.nodes;
                ((ObjectOutline)object).trace_N_N(objectOutlineArray, null);
            }
        }

        void trace_W_W(ObjectOutline[][] objectOutlineArray, Node node) {
            Object object;
            if (node != null) {
                node.setXY((float)this.x - 0.3f, (float)this.y + 0.3f);
            } else {
                object = Node.alloc().init((float)this.x - 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((Node)object);
            }
            this.w_w = false;
            if (this.nw_w) {
                this.trace_NW_W(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else {
                object = ObjectOutline.get(this.x - 1, this.y, this.z, objectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((ObjectOutline)object).n_s) {
                    ((ObjectOutline)object).nodes = this.nodes;
                    ((ObjectOutline)object).trace_N_S(objectOutlineArray, null);
                }
            }
        }

        void trace_N_N(ObjectOutline[][] objectOutlineArray, Node node) {
            Object object;
            if (node != null) {
                node.setXY((float)(this.x + 1) - 0.3f, (float)this.y - 0.3f);
            } else {
                object = Node.alloc().init((float)(this.x + 1) - 0.3f, (float)this.y - 0.3f, this.z);
                this.nodes.add((Node)object);
            }
            this.n_n = false;
            if (this.n_cutoff) {
                object = this.nodes.get(this.nodes.size() - 1);
                ((Node)object).setXY((float)(this.x + 1) + 0.3f, (float)this.y - 0.3f);
                object = Node.alloc().init((float)(this.x + 1) + 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((Node)object);
                object = Node.alloc().init((float)(this.x + 1) - 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add((Node)object);
                this.trace_N_S(objectOutlineArray, (Node)object);
                return;
            }
            object = ObjectOutline.get(this.x + 1, this.y, this.z, objectOutlineArray);
            if (object == null) {
                return;
            }
            if (((ObjectOutline)object).nw_n) {
                ((ObjectOutline)object).nodes = this.nodes;
                ((ObjectOutline)object).trace_NW_N(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else {
                object = ObjectOutline.get(this.x + 1, this.y - 1, this.z, objectOutlineArray);
                if (object == null) {
                    return;
                }
                if (((ObjectOutline)object).w_w) {
                    ((ObjectOutline)object).nodes = this.nodes;
                    ((ObjectOutline)object).trace_W_W(objectOutlineArray, null);
                }
            }
        }

        void trace_N_S(ObjectOutline[][] objectOutlineArray, Node node) {
            if (node != null) {
                node.setXY((float)this.x + 0.3f, (float)this.y + 0.3f);
            } else {
                Node node2 = Node.alloc().init((float)this.x + 0.3f, (float)this.y + 0.3f, this.z);
                this.nodes.add(node2);
            }
            this.n_s = false;
            if (this.nw_s) {
                this.trace_NW_S(objectOutlineArray, this.nodes.get(this.nodes.size() - 1));
            } else if (this.w_e) {
                this.trace_W_E(objectOutlineArray, null);
            }
        }

        void trace(ObjectOutline[][] objectOutlineArray, ArrayList<Node> arrayList) {
            arrayList.clear();
            this.nodes = arrayList;
            Node node = Node.alloc().init((float)this.x - 0.3f, (float)this.y - 0.3f, this.z);
            arrayList.add(node);
            this.trace_NW_N(objectOutlineArray, null);
            if (arrayList.size() == 2 || node.x != arrayList.get((int)(arrayList.size() - 1)).x || node.y != arrayList.get((int)(arrayList.size() - 1)).y) {
                arrayList.clear();
            } else {
                arrayList.get(arrayList.size() - 1).release();
                arrayList.set(arrayList.size() - 1, node);
            }
        }

        static ObjectOutline alloc() {
            return pool.isEmpty() ? new ObjectOutline() : pool.pop();
        }

        void release() {
            assert (!pool.contains(this));
            pool.push(this);
        }
    }

    private static enum EdgeRingHit {
        OnEdge,
        Inside,
        Outside;

    }

    static final class L_lineSegmentIntersects {
        static final Vector2 v1 = new Vector2();

        L_lineSegmentIntersects() {
        }
    }
}

