/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import java.util.HashMap;
import zombie.ai.State;
import zombie.ai.astar.AStarPathFinder;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.gameStates.IngameState;
import zombie.iso.IsoChunk;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.PolygonalMap2;

public final class PathFindState2
extends State {
    private static final Integer PARAM_TICK_COUNT = 0;

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setVariable("bPathfind", true);
        isoGameCharacter.setVariable("bMoving", false);
        ((IsoZombie)isoGameCharacter).networkAI.extraUpdate();
        hashMap.put(PARAM_TICK_COUNT, IngameState.instance.numberTicks);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        long l;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        PathFindBehavior2.BehaviorResult behaviorResult = isoGameCharacter.getPathFindBehavior2().update();
        if (behaviorResult == PathFindBehavior2.BehaviorResult.Failed) {
            isoGameCharacter.setPathFindIndex(-1);
            isoGameCharacter.setVariable("bPathfind", false);
            isoGameCharacter.setVariable("bMoving", false);
            return;
        }
        if (behaviorResult == PathFindBehavior2.BehaviorResult.Succeeded) {
            IsoChunk isoChunk;
            int n = (int)isoGameCharacter.getPathFindBehavior2().getTargetX();
            int n2 = (int)isoGameCharacter.getPathFindBehavior2().getTargetY();
            IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n / 10, n2 / 10) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(n, n2, 0);
            if (isoChunk == null) {
                isoGameCharacter.setVariable("bPathfind", false);
                isoGameCharacter.setVariable("bMoving", true);
                return;
            }
            isoGameCharacter.setVariable("bPathfind", false);
            isoGameCharacter.setVariable("bMoving", false);
            isoGameCharacter.setPath2(null);
            return;
        }
        if (isoGameCharacter instanceof IsoZombie && IngameState.instance.numberTicks - (l = ((Long)hashMap.get(PARAM_TICK_COUNT)).longValue()) == 2L) {
            ((IsoZombie)isoGameCharacter).parameterZombieState.setState(ParameterZombieState.State.Idle);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter instanceof IsoZombie) {
            ((IsoZombie)isoGameCharacter).networkAI.extraUpdate();
            ((IsoZombie)isoGameCharacter).AllowRepathDelay = 0.0f;
        }
        isoGameCharacter.setVariable("bPathfind", false);
        isoGameCharacter.setVariable("bMoving", false);
        isoGameCharacter.setVariable("ShouldBeCrawling", false);
        PolygonalMap2.instance.cancelRequest(isoGameCharacter);
        isoGameCharacter.getFinder().progress = AStarPathFinder.PathFindProgress.notrunning;
        isoGameCharacter.setPath2(null);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
    }

    @Override
    public boolean isMoving(IsoGameCharacter isoGameCharacter) {
        return isoGameCharacter.isMoving();
    }
}

