/*
 * Decompiled with CFR 0.152.
 */
package zombie.vehicles;

import fmod.fmod.FMODManager;
import fmod.fmod.FMODSoundEmitter;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import fmod.fmod.IFMODParameterUpdater;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.WorldSoundManager;
import zombie.ai.states.StaggerBackState;
import zombie.ai.states.ZombieFallDownState;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.DummySoundEmitter;
import zombie.audio.FMODParameter;
import zombie.audio.FMODParameterList;
import zombie.audio.GameSoundClip;
import zombie.audio.parameters.ParameterVehicleBrake;
import zombie.audio.parameters.ParameterVehicleEngineCondition;
import zombie.audio.parameters.ParameterVehicleGear;
import zombie.audio.parameters.ParameterVehicleLoad;
import zombie.audio.parameters.ParameterVehicleRPM;
import zombie.audio.parameters.ParameterVehicleRoadMaterial;
import zombie.audio.parameters.ParameterVehicleSkid;
import zombie.audio.parameters.ParameterVehicleSpeed;
import zombie.audio.parameters.ParameterVehicleSteer;
import zombie.audio.parameters.ParameterVehicleTireMissing;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.Shader;
import zombie.core.physics.Bullet;
import zombie.core.physics.CarController;
import zombie.core.physics.Transform;
import zombie.core.physics.WorldSimulation;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationMultiTrack;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.VehicleModelInstance;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureID;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.input.GameKeyboard;
import zombie.inventory.CompressIdenticalItems;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Key;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.areas.SafeHouse;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.RainManager;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.weather.ClimateManager;
import zombie.network.ClientServerMap;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.PassengerMap;
import zombie.network.ServerOptions;
import zombie.popman.ObjectPool;
import zombie.radio.ZomboidRadio;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.TextManager;
import zombie.ui.UIManager;
import zombie.util.Pool;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.LightbarLightsMode;
import zombie.vehicles.LightbarSirenMode;
import zombie.vehicles.PolyPolyIntersect;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.QuadranglesIntersection;
import zombie.vehicles.SurroundVehicle;
import zombie.vehicles.TransmissionNumber;
import zombie.vehicles.VehicleDoor;
import zombie.vehicles.VehicleEngineRPM;
import zombie.vehicles.VehicleIDMap;
import zombie.vehicles.VehicleInterpolation;
import zombie.vehicles.VehicleInterpolationData;
import zombie.vehicles.VehicleLight;
import zombie.vehicles.VehicleManager;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleType;
import zombie.vehicles.VehicleWindow;
import zombie.vehicles.VehiclesDB2;

public final class BaseVehicle
extends IsoMovingObject
implements Thumpable,
IFMODParameterUpdater {
    public static final float RADIUS = 0.3f;
    public static final int FADE_DISTANCE = 15;
    public static final int RANDOMIZE_CONTAINER_CHANCE = 100;
    public static final byte noAuthorization = -1;
    private static final Vector3f _UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final PolygonalMap2.VehiclePoly tempPoly = new PolygonalMap2.VehiclePoly();
    public static final boolean YURI_FORCE_FIELD = false;
    public static boolean RENDER_TO_TEXTURE = false;
    public static float CENTER_OF_MASS_MAGIC = 0.7f;
    private static final float[] wheelParams = new float[24];
    private static final float[] physicsParams = new float[27];
    static final byte POSITION_ORIENTATION_PACKET_SIZE = 102;
    public static Texture vehicleShadow = null;
    public int justBreakConstraintTimer = 0;
    public BaseVehicle wasTowedBy = null;
    protected static final ColorInfo inf = new ColorInfo();
    private static final float[] lowRiderParam = new float[4];
    private final VehicleImpulse impulseFromServer = new VehicleImpulse();
    private final VehicleImpulse[] impulseFromSquishedZombie = new VehicleImpulse[4];
    private final ArrayList<VehicleImpulse> impulseFromHitZombie = new ArrayList();
    private final int netPlayerTimeoutMax = 30;
    private final Vector4f tempVector4f = new Vector4f();
    public final ArrayList<ModelInfo> models = new ArrayList();
    public IsoChunk chunk;
    public boolean polyDirty = true;
    private boolean polyGarageCheck = true;
    private float radiusReductionInGarage = 0.0f;
    public short VehicleID = (short)-1;
    public int sqlID = -1;
    public boolean serverRemovedFromWorld = false;
    public VehicleInterpolation interpolation = null;
    public boolean waitFullUpdate;
    public float throttle = 0.0f;
    public double engineSpeed;
    public TransmissionNumber transmissionNumber;
    public final UpdateLimit transmissionChangeTime = new UpdateLimit(1000L);
    public boolean hasExtendOffset = true;
    public boolean hasExtendOffsetExiting = false;
    public float savedPhysicsZ = Float.NaN;
    public final Quaternionf savedRot = new Quaternionf();
    public final Transform jniTransform = new Transform();
    public float jniSpeed;
    public boolean jniIsCollide;
    public final Vector3f jniLinearVelocity = new Vector3f();
    private final Vector3f lastLinearVelocity = new Vector3f();
    public Authorization netPlayerAuthorization = Authorization.Server;
    public short netPlayerId = (short)-1;
    public int netPlayerTimeout = 0;
    public int authSimulationHash = 0;
    public long authSimulationTime = 0L;
    public int frontEndDurability = 100;
    public int rearEndDurability = 100;
    public float rust = 0.0f;
    public float colorHue = 0.0f;
    public float colorSaturation = 0.0f;
    public float colorValue = 0.0f;
    public int currentFrontEndDurability = 100;
    public int currentRearEndDurability = 100;
    public float collideX = -1.0f;
    public float collideY = -1.0f;
    public final PolygonalMap2.VehiclePoly shadowCoord = new PolygonalMap2.VehiclePoly();
    public engineStateTypes engineState = engineStateTypes.Idle;
    public long engineLastUpdateStateTime;
    public static final int MAX_WHEELS = 4;
    public static final int PHYSICS_PARAM_COUNT = 27;
    public final WheelInfo[] wheelInfo = new WheelInfo[4];
    public boolean skidding = false;
    public long skidSound;
    public long ramSound;
    public long ramSoundTime;
    private VehicleEngineRPM vehicleEngineRPM = null;
    public final long[] new_EngineSoundId = new long[8];
    private long combinedEngineSound = 0L;
    public int engineSoundIndex = 0;
    public BaseSoundEmitter hornemitter = null;
    public float startTime = 0.0f;
    public boolean headlightsOn = false;
    public boolean stoplightsOn = false;
    public boolean windowLightsOn = false;
    public boolean soundHornOn = false;
    public boolean soundBackMoveOn = false;
    public boolean previouslyEntered = false;
    public final LightbarLightsMode lightbarLightsMode = new LightbarLightsMode();
    public final LightbarSirenMode lightbarSirenMode = new LightbarSirenMode();
    private final IsoLightSource leftLight1 = new IsoLightSource(0, 0, 0, 1.0f, 0.0f, 0.0f, 8);
    private final IsoLightSource leftLight2 = new IsoLightSource(0, 0, 0, 1.0f, 0.0f, 0.0f, 8);
    private final IsoLightSource rightLight1 = new IsoLightSource(0, 0, 0, 0.0f, 0.0f, 1.0f, 8);
    private final IsoLightSource rightLight2 = new IsoLightSource(0, 0, 0, 0.0f, 0.0f, 1.0f, 8);
    private int leftLightIndex = -1;
    private int rightLightIndex = -1;
    public final ServerVehicleState[] connectionState = new ServerVehicleState[512];
    protected Passenger[] passengers = new Passenger[1];
    protected String scriptName;
    protected VehicleScript script;
    protected final ArrayList<VehiclePart> parts = new ArrayList();
    protected VehiclePart battery;
    protected int engineQuality;
    protected int engineLoudness;
    protected int enginePower;
    protected long engineCheckTime;
    protected final ArrayList<VehiclePart> lights = new ArrayList();
    protected boolean createdModel = false;
    protected int skinIndex = -1;
    protected CarController physics;
    protected boolean bCreated;
    protected final PolygonalMap2.VehiclePoly poly = new PolygonalMap2.VehiclePoly();
    protected final PolygonalMap2.VehiclePoly polyPlusRadius = new PolygonalMap2.VehiclePoly();
    protected boolean bDoDamageOverlay = false;
    protected boolean loaded = false;
    protected short updateFlags;
    protected long updateLockTimeout = 0L;
    final UpdateLimit limitPhysicSend = new UpdateLimit(300L);
    Vector2 limitPhysicPositionSent = null;
    final UpdateLimit limitPhysicValid = new UpdateLimit(1000L);
    private final UpdateLimit limitCrash = new UpdateLimit(600L);
    public boolean addedToWorld = false;
    boolean removedFromWorld = false;
    private float polyPlusRadiusMinX = -123.0f;
    private float polyPlusRadiusMinY;
    private float polyPlusRadiusMaxX;
    private float polyPlusRadiusMaxY;
    private float maxSpeed;
    private boolean keyIsOnDoor = false;
    private boolean hotwired = false;
    private boolean hotwiredBroken = false;
    private boolean keysInIgnition = false;
    private long soundHorn = -1L;
    private long soundScrapePastPlant = -1L;
    private long soundBackMoveSignal = -1L;
    public long soundSirenSignal = -1L;
    private final HashMap<String, String> choosenParts = new HashMap();
    private String type = "";
    private String respawnZone;
    private float mass = 0.0f;
    private float initialMass = 0.0f;
    private float brakingForce = 0.0f;
    private float baseQuality = 0.0f;
    private float currentSteering = 0.0f;
    private boolean isBraking = false;
    private int mechanicalID = 0;
    private boolean needPartsUpdate = false;
    private boolean alarmed = false;
    private int alarmTime = -1;
    private float alarmAccumulator;
    private double sirenStartTime = 0.0;
    private boolean mechanicUIOpen = false;
    private boolean isGoodCar = false;
    private InventoryItem currentKey = null;
    private boolean doColor = true;
    private float brekingSlowFactor = 0.0f;
    private final ArrayList<IsoObject> brekingObjectsList = new ArrayList();
    private final UpdateLimit limitUpdate = new UpdateLimit(333L);
    public byte keySpawned = 0;
    public final Matrix4f vehicleTransform = new Matrix4f();
    public final Matrix4f renderTransform = new Matrix4f();
    private final Matrix4f tempMatrix4fLWJGL_1 = new Matrix4f();
    private final Quaternionf tempQuat4f = new Quaternionf();
    private final Transform tempTransform = new Transform();
    private final Transform tempTransform2 = new Transform();
    private final Transform tempTransform3 = new Transform();
    private BaseSoundEmitter emitter;
    private float brakeBetweenUpdatesSpeed = 0.0f;
    public long physicActiveCheck = -1L;
    private long constraintChangedTime = -1L;
    private AnimationPlayer m_animPlayer = null;
    public String specificDistributionId = null;
    private boolean bAddThumpWorldSound = false;
    private final SurroundVehicle m_surroundVehicle = new SurroundVehicle(this);
    private boolean regulator = false;
    private float regulatorSpeed = 0.0f;
    private static final HashMap<String, Integer> s_PartToMaskMap = new HashMap();
    private static final Byte BYTE_ZERO = 0;
    private final HashMap<String, Byte> bloodIntensity = new HashMap();
    private boolean OptionBloodDecals = false;
    private long createPhysicsTime = -1L;
    private BaseVehicle vehicleTowing = null;
    private BaseVehicle vehicleTowedBy = null;
    public int constraintTowing = -1;
    private int vehicleTowingID = -1;
    private int vehicleTowedByID = -1;
    private String towAttachmentSelf = null;
    private String towAttachmentOther = null;
    private float towConstraintZOffset = 0.0f;
    private final ParameterVehicleBrake parameterVehicleBrake = new ParameterVehicleBrake(this);
    private final ParameterVehicleEngineCondition parameterVehicleEngineCondition = new ParameterVehicleEngineCondition(this);
    private final ParameterVehicleGear parameterVehicleGear = new ParameterVehicleGear(this);
    private final ParameterVehicleLoad parameterVehicleLoad = new ParameterVehicleLoad(this);
    private final ParameterVehicleRoadMaterial parameterVehicleRoadMaterial = new ParameterVehicleRoadMaterial(this);
    private final ParameterVehicleRPM parameterVehicleRPM = new ParameterVehicleRPM(this);
    private final ParameterVehicleSkid parameterVehicleSkid = new ParameterVehicleSkid(this);
    private final ParameterVehicleSpeed parameterVehicleSpeed = new ParameterVehicleSpeed(this);
    private final ParameterVehicleSteer parameterVehicleSteer = new ParameterVehicleSteer(this);
    private final ParameterVehicleTireMissing parameterVehicleTireMissing = new ParameterVehicleTireMissing(this);
    private final FMODParameterList fmodParameters = new FMODParameterList();
    public boolean isActive = false;
    public boolean isStatic = false;
    private final UpdateLimit physicReliableLimit = new UpdateLimit(500L);
    public boolean isReliable = false;
    public static final ThreadLocal<Vector2ObjectPool> TL_vector2_pool = ThreadLocal.withInitial(Vector2ObjectPool::new);
    public static final ThreadLocal<Vector2fObjectPool> TL_vector2f_pool = ThreadLocal.withInitial(Vector2fObjectPool::new);
    public static final ThreadLocal<Vector3fObjectPool> TL_vector3f_pool = ThreadLocal.withInitial(Vector3fObjectPool::new);
    public static final ThreadLocal<Matrix4fObjectPool> TL_matrix4f_pool = ThreadLocal.withInitial(Matrix4fObjectPool::new);
    public static final ThreadLocal<QuaternionfObjectPool> TL_quaternionf_pool = ThreadLocal.withInitial(QuaternionfObjectPool::new);
    public static final float PHYSICS_Z_SCALE = 0.82f;
    public static float PLUS_RADIUS = 0.15f;
    private int zombiesHits = 0;
    private long zombieHitTimestamp = 0L;
    public static final int MASK1_FRONT = 0;
    public static final int MASK1_REAR = 4;
    public static final int MASK1_DOOR_RIGHT_FRONT = 8;
    public static final int MASK1_DOOR_RIGHT_REAR = 12;
    public static final int MASK1_DOOR_LEFT_FRONT = 1;
    public static final int MASK1_DOOR_LEFT_REAR = 5;
    public static final int MASK1_WINDOW_RIGHT_FRONT = 9;
    public static final int MASK1_WINDOW_RIGHT_REAR = 13;
    public static final int MASK1_WINDOW_LEFT_FRONT = 2;
    public static final int MASK1_WINDOW_LEFT_REAR = 6;
    public static final int MASK1_WINDOW_FRONT = 10;
    public static final int MASK1_WINDOW_REAR = 14;
    public static final int MASK1_GUARD_RIGHT_FRONT = 3;
    public static final int MASK1_GUARD_RIGHT_REAR = 7;
    public static final int MASK1_GUARD_LEFT_FRONT = 11;
    public static final int MASK1_GUARD_LEFT_REAR = 15;
    public static final int MASK2_ROOF = 0;
    public static final int MASK2_LIGHT_RIGHT_FRONT = 4;
    public static final int MASK2_LIGHT_LEFT_FRONT = 8;
    public static final int MASK2_LIGHT_RIGHT_REAR = 12;
    public static final int MASK2_LIGHT_LEFT_REAR = 1;
    public static final int MASK2_BRAKE_RIGHT = 5;
    public static final int MASK2_BRAKE_LEFT = 9;
    public static final int MASK2_LIGHTBAR_RIGHT = 13;
    public static final int MASK2_LIGHTBAR_LEFT = 2;
    public static final int MASK2_HOOD = 6;
    public static final int MASK2_BOOT = 10;
    public float forcedFriction = -1.0f;
    protected final HitVars hitVars = new HitVars();

    public int getSqlId() {
        return this.sqlID;
    }

    public static Vector2 allocVector2() {
        return (Vector2)TL_vector2_pool.get().alloc();
    }

    public static void releaseVector2(Vector2 vector22) {
        TL_vector2_pool.get().release(vector22);
    }

    public static Vector3f allocVector3f() {
        return (Vector3f)TL_vector3f_pool.get().alloc();
    }

    public static void releaseVector3f(Vector3f vector3f) {
        TL_vector3f_pool.get().release(vector3f);
    }

    public BaseVehicle(IsoCell isoCell) {
        super(isoCell, false);
        int n;
        this.setCollidable(false);
        this.respawnZone = new String("");
        this.scriptName = "Base.PickUpTruck";
        this.passengers[0] = new Passenger();
        this.waitFullUpdate = false;
        this.savedRot.w = 1.0f;
        for (n = 0; n < this.wheelInfo.length; ++n) {
            this.wheelInfo[n] = new WheelInfo();
        }
        if (GameClient.bClient) {
            this.interpolation = new VehicleInterpolation();
        }
        this.setKeyId(Rand.Next(100000000));
        this.engineSpeed = 0.0;
        this.transmissionNumber = TransmissionNumber.N;
        this.rust = Rand.Next(0, 2);
        this.jniIsCollide = false;
        for (n = 0; n < 4; ++n) {
            BaseVehicle.lowRiderParam[n] = 0.0f;
        }
        this.fmodParameters.add(this.parameterVehicleBrake);
        this.fmodParameters.add(this.parameterVehicleEngineCondition);
        this.fmodParameters.add(this.parameterVehicleGear);
        this.fmodParameters.add(this.parameterVehicleLoad);
        this.fmodParameters.add(this.parameterVehicleRPM);
        this.fmodParameters.add(this.parameterVehicleRoadMaterial);
        this.fmodParameters.add(this.parameterVehicleSkid);
        this.fmodParameters.add(this.parameterVehicleSpeed);
        this.fmodParameters.add(this.parameterVehicleSteer);
        this.fmodParameters.add(this.parameterVehicleTireMissing);
    }

    public static void LoadAllVehicleTextures() {
        DebugLog.General.println("BaseVehicle.LoadAllVehicleTextures...");
        ArrayList<VehicleScript> arrayList = ScriptManager.instance.getAllVehicleScripts();
        for (VehicleScript vehicleScript : arrayList) {
            BaseVehicle.LoadVehicleTextures(vehicleScript);
        }
    }

    public static void LoadVehicleTextures(VehicleScript vehicleScript) {
        if (SystemDisabler.doVehiclesWithoutTextures) {
            VehicleScript.Skin skin = vehicleScript.getSkin(0);
            skin.textureData = BaseVehicle.LoadVehicleTexture(skin.texture);
            skin.textureDataMask = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_mask");
            skin.textureDataDamage1Overlay = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_damage1overlay");
            skin.textureDataDamage1Shell = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_damage1shell");
            skin.textureDataDamage2Overlay = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_damage2overlay");
            skin.textureDataDamage2Shell = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_damage2shell");
            skin.textureDataLights = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_lights");
            skin.textureDataRust = BaseVehicle.LoadVehicleTexture("vehicles_placeholder_rust");
        } else {
            for (int i = 0; i < vehicleScript.getSkinCount(); ++i) {
                VehicleScript.Skin skin = vehicleScript.getSkin(i);
                skin.copyMissingFrom(vehicleScript.getTextures());
                BaseVehicle.LoadVehicleTextures(skin);
            }
        }
    }

    private static void LoadVehicleTextures(VehicleScript.Skin skin) {
        skin.textureData = BaseVehicle.LoadVehicleTexture(skin.texture);
        if (skin.textureMask != null) {
            int n = 0;
            skin.textureDataMask = BaseVehicle.LoadVehicleTexture(skin.textureMask, n |= 0x100);
        }
        skin.textureDataDamage1Overlay = BaseVehicle.LoadVehicleTexture(skin.textureDamage1Overlay);
        skin.textureDataDamage1Shell = BaseVehicle.LoadVehicleTexture(skin.textureDamage1Shell);
        skin.textureDataDamage2Overlay = BaseVehicle.LoadVehicleTexture(skin.textureDamage2Overlay);
        skin.textureDataDamage2Shell = BaseVehicle.LoadVehicleTexture(skin.textureDamage2Shell);
        skin.textureDataLights = BaseVehicle.LoadVehicleTexture(skin.textureLights);
        skin.textureDataRust = BaseVehicle.LoadVehicleTexture(skin.textureRust);
        skin.textureDataShadow = BaseVehicle.LoadVehicleTexture(skin.textureShadow);
    }

    public static Texture LoadVehicleTexture(String string) {
        int n = 0;
        n |= TextureID.bUseCompression ? 4 : 0;
        return BaseVehicle.LoadVehicleTexture(string, n |= 0x100);
    }

    public static Texture LoadVehicleTexture(String string, int n) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        return Texture.getSharedTexture("media/textures/" + string + ".png", n);
    }

    public void setNetPlayerAuthorization(Authorization authorization, int n) {
        this.netPlayerAuthorization = authorization;
        this.netPlayerId = (short)n;
        int n2 = this.netPlayerTimeout = n == -1 ? 0 : 30;
        if (GameClient.bClient) {
            boolean bl;
            boolean bl2 = bl = Authorization.Local.equals((Object)authorization) || Authorization.LocalCollide.equals((Object)authorization);
            if (this.getVehicleTowing() != null) {
                Bullet.setVehicleStatic(this, !bl);
                Bullet.setVehicleActive(this, bl);
                Bullet.setVehicleStatic(this.getVehicleTowing(), !bl);
                Bullet.setVehicleActive(this.getVehicleTowing(), bl);
            } else if (this.getVehicleTowedBy() != null) {
                Bullet.setVehicleStatic(this, !bl);
                Bullet.setVehicleActive(this, bl);
            } else {
                Bullet.setVehicleStatic(this, !bl);
                Bullet.setVehicleActive(this, bl);
            }
        }
        DebugLog.Vehicle.trace("vid%s=%d pid=%d %s", this.getVehicleTowing() != null ? "-a" : (this.getVehicleTowedBy() != null ? "-b" : ""), this.getId(), n, authorization.name());
    }

    public boolean isNetPlayerAuthorization(Authorization authorization) {
        return this.netPlayerAuthorization.equals((Object)authorization);
    }

    public boolean isNetPlayerId(short s) {
        return this.netPlayerId == s;
    }

    public short getNetPlayerId() {
        return this.netPlayerId;
    }

    public String getAuthorizationDescription() {
        return String.format("vid:%s(%d) pid:(%d) auth=%s static=%b active=%b", this.scriptName, this.VehicleID, this.netPlayerId, this.netPlayerAuthorization.name(), this.isStatic, this.isActive);
    }

    public static float getFakeSpeedModifier() {
        if (GameClient.bClient || GameServer.bServer) {
            float f = (float)ServerOptions.instance.SpeedLimit.getValue();
            return 120.0f / Math.min(f, 120.0f);
        }
        return 1.0f;
    }

    public boolean isLocalPhysicSim() {
        if (GameServer.bServer) {
            return this.isNetPlayerAuthorization(Authorization.Server);
        }
        return this.isNetPlayerAuthorization(Authorization.LocalCollide) || this.isNetPlayerAuthorization(Authorization.Local);
    }

    public void addImpulse(Vector3f vector3f, Vector3f vector3f2) {
        if (!this.impulseFromServer.enable) {
            this.impulseFromServer.enable = true;
            this.impulseFromServer.impulse.set((Vector3fc)vector3f);
            this.impulseFromServer.rel_pos.set((Vector3fc)vector3f2);
        } else if (this.impulseFromServer.impulse.length() < vector3f.length()) {
            this.impulseFromServer.impulse.set((Vector3fc)vector3f);
            this.impulseFromServer.rel_pos.set((Vector3fc)vector3f2);
            this.impulseFromServer.enable = false;
            this.impulseFromServer.release();
        }
    }

    public double getEngineSpeed() {
        return this.engineSpeed;
    }

    public String getTransmissionNumberLetter() {
        return this.transmissionNumber.getString();
    }

    public int getTransmissionNumber() {
        return this.transmissionNumber.getIndex();
    }

    public void setClientForce(float f) {
        this.physics.clientForce = f;
    }

    public float getClientForce() {
        return this.physics.clientForce;
    }

    public float getForce() {
        return this.physics.EngineForce - this.physics.BrakingForce;
    }

    private void doVehicleColor() {
        if (!this.isDoColor()) {
            this.colorSaturation = 0.1f;
            this.colorValue = 0.9f;
            return;
        }
        this.colorHue = Rand.Next(0.0f, 0.0f);
        this.colorSaturation = 0.5f;
        this.colorValue = Rand.Next(0.3f, 0.6f);
        int n = Rand.Next(100);
        if (n < 20) {
            this.colorHue = Rand.Next(0.0f, 0.03f);
            this.colorSaturation = Rand.Next(0.85f, 1.0f);
            this.colorValue = Rand.Next(0.55f, 0.85f);
        } else if (n < 32) {
            this.colorHue = Rand.Next(0.55f, 0.61f);
            this.colorSaturation = Rand.Next(0.85f, 1.0f);
            this.colorValue = Rand.Next(0.65f, 0.75f);
        } else if (n < 67) {
            this.colorHue = 0.15f;
            this.colorSaturation = Rand.Next(0.0f, 0.1f);
            this.colorValue = Rand.Next(0.7f, 0.8f);
        } else if (n < 89) {
            this.colorHue = Rand.Next(0.0f, 1.0f);
            this.colorSaturation = Rand.Next(0.0f, 0.1f);
            this.colorValue = Rand.Next(0.1f, 0.25f);
        } else {
            this.colorHue = Rand.Next(0.0f, 1.0f);
            this.colorSaturation = Rand.Next(0.6f, 0.75f);
            this.colorValue = Rand.Next(0.3f, 0.7f);
        }
        if (this.getScript() != null) {
            if (this.getScript().getForcedHue() > -1.0f) {
                this.colorHue = this.getScript().getForcedHue();
            }
            if (this.getScript().getForcedSat() > -1.0f) {
                this.colorSaturation = this.getScript().getForcedSat();
            }
            if (this.getScript().getForcedVal() > -1.0f) {
                this.colorValue = this.getScript().getForcedVal();
            }
        }
    }

    @Override
    public String getObjectName() {
        return "Vehicle";
    }

    @Override
    public boolean Serialize() {
        return true;
    }

    public void createPhysics() {
        int n;
        if (!GameClient.bClient && this.VehicleID == -1) {
            this.VehicleID = VehicleIDMap.instance.allocateID();
            if (GameServer.bServer) {
                VehicleManager.instance.registerVehicle(this);
            } else {
                VehicleIDMap.instance.put(this.VehicleID, this);
            }
        }
        if (this.script == null) {
            this.setScript(this.scriptName);
        }
        if (this.script == null) {
            return;
        }
        if (this.skinIndex == -1) {
            this.setSkinIndex(Rand.Next(this.getSkinCount()));
        }
        if (!GameServer.bServer) {
            WorldSimulation.instance.create();
        }
        this.jniTransform.origin.set(this.getX() - WorldSimulation.instance.offsetX, Float.isNaN(this.savedPhysicsZ) ? this.getZ() : this.savedPhysicsZ, this.getY() - WorldSimulation.instance.offsetY);
        this.physics = new CarController(this);
        this.savedPhysicsZ = Float.NaN;
        this.createPhysicsTime = System.currentTimeMillis();
        if (!this.bCreated) {
            this.bCreated = true;
            n = 30;
            if (SandboxOptions.getInstance().RecentlySurvivorVehicles.getValue() == 1) {
                n = 0;
            }
            if (SandboxOptions.getInstance().RecentlySurvivorVehicles.getValue() == 2) {
                n = 10;
            }
            if (SandboxOptions.getInstance().RecentlySurvivorVehicles.getValue() == 3) {
                n = 30;
            }
            if (SandboxOptions.getInstance().RecentlySurvivorVehicles.getValue() == 4) {
                n = 50;
            }
            if (Rand.Next(100) < n) {
                this.setGoodCar(true);
            }
        }
        this.createParts();
        this.initParts();
        if (!this.createdModel) {
            ModelManager.instance.addVehicle(this);
            this.createdModel = true;
        }
        this.updateTransform();
        this.lights.clear();
        for (n = 0; n < this.parts.size(); ++n) {
            VehiclePart vehiclePart = this.parts.get(n);
            if (vehiclePart.getLight() == null) continue;
            this.lights.add(vehiclePart);
        }
        this.setMaxSpeed(this.getScript().maxSpeed);
        this.setInitialMass(this.getScript().getMass());
        if (!this.getCell().getVehicles().contains(this) && !this.getCell().addVehicles.contains(this)) {
            this.getCell().addVehicles.add(this);
        }
        this.square = this.getCell().getGridSquare(this.x, this.y, this.z);
        this.randomizeContainers();
        if (this.engineState == engineStateTypes.Running) {
            this.engineDoRunning();
        }
        this.updateTotalMass();
        this.bDoDamageOverlay = true;
        this.updatePartStats();
        this.mechanicalID = Rand.Next(100000);
    }

    public boolean isPreviouslyEntered() {
        return this.previouslyEntered;
    }

    public void setPreviouslyEntered(boolean bl) {
        this.previouslyEntered = bl;
    }

    @Override
    public int getKeyId() {
        return this.keyId;
    }

    public boolean getKeySpawned() {
        return this.keySpawned != 0;
    }

    public void putKeyToZombie(IsoZombie isoZombie) {
        if (Rand.Next(10) != 1) {
            InventoryItem inventoryItem = this.createVehicleKey();
            isoZombie.getInventory().AddItem(inventoryItem);
        } else {
            InventoryItem inventoryItem = isoZombie.getInventory().AddItem("Base.KeyRing");
            if (inventoryItem instanceof InventoryContainer) {
                InventoryContainer inventoryContainer = (InventoryContainer)inventoryItem;
                InventoryItem inventoryItem2 = this.createVehicleKey();
                inventoryContainer.getInventory().AddItem(inventoryItem2);
            }
        }
    }

    public void putKeyToContainer(ItemContainer itemContainer, IsoGridSquare isoGridSquare, IsoObject isoObject) {
        InventoryItem inventoryItem = this.createVehicleKey();
        itemContainer.AddItem(inventoryItem);
        if (GameServer.bServer) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                if (!udpConnection.RelevantTo(isoObject.square.x, isoObject.square.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
                byteBufferWriter.putShort((short)2);
                byteBufferWriter.putInt((int)isoObject.getX());
                byteBufferWriter.putInt((int)isoObject.getY());
                byteBufferWriter.putInt((int)isoObject.getZ());
                int n = isoGridSquare.getObjects().indexOf(isoObject);
                byteBufferWriter.putByte((byte)n);
                byteBufferWriter.putByte((byte)isoObject.getContainerIndex(itemContainer));
                try {
                    CompressIdenticalItems.save(byteBufferWriter.bb, inventoryItem);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                PacketTypes.PacketType.AddInventoryItemToContainer.send(udpConnection);
            }
        }
    }

    public void putKeyToWorld(IsoGridSquare isoGridSquare) {
        InventoryItem inventoryItem = this.createVehicleKey();
        isoGridSquare.AddWorldInventoryItem(inventoryItem, 0.0f, 0.0f, 0.0f);
    }

    public void addKeyToWorld() {
        IsoGridSquare isoGridSquare;
        if (this.haveOneDoorUnlocked() && Rand.Next(100) < 30) {
            if (Rand.Next(5) == 0) {
                this.keyIsOnDoor = true;
                this.currentKey = this.createVehicleKey();
            } else {
                this.addKeyToGloveBox();
            }
            return;
        }
        if (this.haveOneDoorUnlocked() && Rand.Next(100) < 30) {
            this.keysInIgnition = true;
            this.currentKey = this.createVehicleKey();
            return;
        }
        if (Rand.Next(100) < 50 && (isoGridSquare = this.getCell().getGridSquare(this.x, this.y, this.z)) != null) {
            this.addKeyToSquare(isoGridSquare);
            return;
        }
    }

    public void addKeyToGloveBox() {
        if (this.keySpawned != 0) {
            return;
        }
        if (this.getPartById("GloveBox") != null) {
            VehiclePart vehiclePart = this.getPartById("GloveBox");
            InventoryItem inventoryItem = this.createVehicleKey();
            vehiclePart.container.addItem(inventoryItem);
            this.keySpawned = 1;
        }
    }

    public InventoryItem createVehicleKey() {
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem("CarKey");
        inventoryItem.setKeyId(this.getKeyId());
        inventoryItem.setName(Translator.getText("IGUI_CarKey", Translator.getText("IGUI_VehicleName" + this.getScript().getName())));
        Color color = Color.HSBtoRGB(this.colorHue, this.colorSaturation * 0.5f, this.colorValue);
        inventoryItem.setColor(color);
        inventoryItem.setCustomColor(true);
        return inventoryItem;
    }

    public boolean addKeyToSquare(IsoGridSquare isoGridSquare) {
        int n;
        int n2;
        boolean bl = false;
        IsoGridSquare isoGridSquare2 = null;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = isoGridSquare.getX() - 10; n < isoGridSquare.getX() + 10; ++n) {
                for (int i = isoGridSquare.getY() - 10; i < isoGridSquare.getY() + 10; ++i) {
                    isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare(n, i, n2);
                    if (isoGridSquare2 != null) {
                        int n3;
                        for (n3 = 0; n3 < isoGridSquare2.getObjects().size(); ++n3) {
                            IsoObject isoObject = isoGridSquare2.getObjects().get(n3);
                            if (isoObject.container == null || !isoObject.container.type.equals("counter") && !isoObject.container.type.equals("officedrawers") && !isoObject.container.type.equals("shelves") && !isoObject.container.type.equals("desk")) continue;
                            this.putKeyToContainer(isoObject.container, isoGridSquare2, isoObject);
                            bl = true;
                            break;
                        }
                        for (n3 = 0; n3 < isoGridSquare2.getMovingObjects().size(); ++n3) {
                            if (!(isoGridSquare2.getMovingObjects().get(n3) instanceof IsoZombie)) continue;
                            ((IsoZombie)isoGridSquare2.getMovingObjects().get(n3)).addItemToSpawnAtDeath(this.createVehicleKey());
                            bl = true;
                            break;
                        }
                    }
                    if (bl) break;
                }
                if (bl) break;
            }
            if (bl) break;
        }
        if (Rand.Next(10) < 6) {
            while (!bl) {
                n2 = isoGridSquare.getX() - 10 + Rand.Next(20);
                n = isoGridSquare.getY() - 10 + Rand.Next(20);
                isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare((double)n2, (double)n, this.z);
                if (isoGridSquare2 == null || isoGridSquare2.isSolid() || isoGridSquare2.isSolidTrans() || isoGridSquare2.HasTree()) continue;
                this.putKeyToWorld(isoGridSquare2);
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void toggleLockedDoor(VehiclePart vehiclePart, IsoGameCharacter isoGameCharacter, boolean bl) {
        if (bl) {
            if (!this.canLockDoor(vehiclePart, isoGameCharacter)) {
                return;
            }
            vehiclePart.getDoor().setLocked(true);
        } else {
            if (!this.canUnlockDoor(vehiclePart, isoGameCharacter)) {
                return;
            }
            vehiclePart.getDoor().setLocked(false);
        }
    }

    public boolean canLockDoor(VehiclePart vehiclePart, IsoGameCharacter isoGameCharacter) {
        VehicleWindow vehicleWindow;
        if (vehiclePart == null) {
            return false;
        }
        if (isoGameCharacter == null) {
            return false;
        }
        VehicleDoor vehicleDoor = vehiclePart.getDoor();
        if (vehicleDoor == null) {
            return false;
        }
        if (vehicleDoor.lockBroken) {
            return false;
        }
        if (vehicleDoor.locked) {
            return false;
        }
        if (this.getSeat(isoGameCharacter) != -1) {
            return true;
        }
        if (isoGameCharacter.getInventory().haveThisKeyId(this.getKeyId()) != null) {
            return true;
        }
        VehiclePart vehiclePart2 = vehiclePart.getChildWindow();
        if (vehiclePart2 != null && vehiclePart2.getInventoryItem() == null) {
            return true;
        }
        VehicleWindow vehicleWindow2 = vehicleWindow = vehiclePart2 == null ? null : vehiclePart2.getWindow();
        return vehicleWindow != null && (vehicleWindow.isOpen() || vehicleWindow.isDestroyed());
    }

    public boolean canUnlockDoor(VehiclePart vehiclePart, IsoGameCharacter isoGameCharacter) {
        VehicleWindow vehicleWindow;
        if (vehiclePart == null) {
            return false;
        }
        if (isoGameCharacter == null) {
            return false;
        }
        VehicleDoor vehicleDoor = vehiclePart.getDoor();
        if (vehicleDoor == null) {
            return false;
        }
        if (vehicleDoor.lockBroken) {
            return false;
        }
        if (!vehicleDoor.locked) {
            return false;
        }
        if (this.getSeat(isoGameCharacter) != -1) {
            return true;
        }
        if (isoGameCharacter.getInventory().haveThisKeyId(this.getKeyId()) != null) {
            return true;
        }
        VehiclePart vehiclePart2 = vehiclePart.getChildWindow();
        if (vehiclePart2 != null && vehiclePart2.getInventoryItem() == null) {
            return true;
        }
        VehicleWindow vehicleWindow2 = vehicleWindow = vehiclePart2 == null ? null : vehiclePart2.getWindow();
        return vehicleWindow != null && (vehicleWindow.isOpen() || vehicleWindow.isDestroyed());
    }

    private void initParts() {
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            String string = vehiclePart.getLuaFunction("init");
            if (string == null) continue;
            this.callLuaVoid(string, this, vehiclePart);
        }
    }

    public void setGeneralPartCondition(float f, float f2) {
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            vehiclePart.setGeneralCondition(null, f, f2);
        }
    }

    private void createParts() {
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            ArrayList<String> arrayList = vehiclePart.getItemType();
            if (vehiclePart.bCreated && arrayList != null && !arrayList.isEmpty() && vehiclePart.getInventoryItem() == null && vehiclePart.getTable("install") == null) {
                vehiclePart.bCreated = false;
            } else if ((arrayList == null || arrayList.isEmpty()) && vehiclePart.getInventoryItem() != null) {
                vehiclePart.item = null;
            }
            if (vehiclePart.bCreated) continue;
            vehiclePart.bCreated = true;
            String string = vehiclePart.getLuaFunction("create");
            if (string == null) {
                vehiclePart.setRandomCondition(null);
                continue;
            }
            this.callLuaVoid(string, this, vehiclePart);
            if (vehiclePart.getCondition() != -1) continue;
            vehiclePart.setRandomCondition(null);
        }
        if (this.hasLightbar() && this.getScript().rightSirenCol != null && this.getScript().leftSirenCol != null) {
            this.leftLight1.r = this.leftLight2.r = this.getScript().leftSirenCol.r;
            this.leftLight1.g = this.leftLight2.g = this.getScript().leftSirenCol.g;
            this.leftLight1.b = this.leftLight2.b = this.getScript().leftSirenCol.b;
            this.rightLight1.r = this.rightLight2.r = this.getScript().rightSirenCol.r;
            this.rightLight1.g = this.rightLight2.g = this.getScript().rightSirenCol.g;
            this.rightLight1.b = this.rightLight2.b = this.getScript().rightSirenCol.b;
        }
    }

    public CarController getController() {
        return this.physics;
    }

    public SurroundVehicle getSurroundVehicle() {
        return this.m_surroundVehicle;
    }

    public int getSkinCount() {
        return this.script.getSkinCount();
    }

    public int getSkinIndex() {
        return this.skinIndex;
    }

    public void setSkinIndex(int n) {
        if (n < 0 || n > this.getSkinCount()) {
            return;
        }
        this.skinIndex = n;
    }

    public void updateSkin() {
        if (this.sprite == null || this.sprite.modelSlot == null || this.sprite.modelSlot.model == null) {
            return;
        }
        VehicleModelInstance vehicleModelInstance = (VehicleModelInstance)this.sprite.modelSlot.model;
        VehicleScript.Skin skin = this.script.getTextures();
        VehicleScript vehicleScript = this.getScript();
        if (this.getSkinIndex() >= 0 && this.getSkinIndex() < vehicleScript.getSkinCount()) {
            skin = vehicleScript.getSkin(this.getSkinIndex());
        }
        vehicleModelInstance.LoadTexture(skin.texture);
        vehicleModelInstance.tex = skin.textureData;
        vehicleModelInstance.textureMask = skin.textureDataMask;
        vehicleModelInstance.textureDamage1Overlay = skin.textureDataDamage1Overlay;
        vehicleModelInstance.textureDamage1Shell = skin.textureDataDamage1Shell;
        vehicleModelInstance.textureDamage2Overlay = skin.textureDataDamage2Overlay;
        vehicleModelInstance.textureDamage2Shell = skin.textureDataDamage2Shell;
        vehicleModelInstance.textureLights = skin.textureDataLights;
        vehicleModelInstance.textureRust = skin.textureDataRust;
        if (vehicleModelInstance.tex != null) {
            vehicleModelInstance.tex.bindAlways = true;
        } else {
            DebugLog.Animation.error("texture not found:", this.getSkin());
        }
    }

    public Texture getShadowTexture() {
        if (this.getScript() != null) {
            VehicleScript.Skin skin = this.getScript().getTextures();
            if (this.getSkinIndex() >= 0 && this.getSkinIndex() < this.getScript().getSkinCount()) {
                skin = this.getScript().getSkin(this.getSkinIndex());
            }
            if (skin.textureDataShadow != null) {
                return skin.textureDataShadow;
            }
        }
        if (vehicleShadow == null) {
            int n = 0;
            vehicleShadow = Texture.getSharedTexture("media/vehicleShadow.png", n |= TextureID.bUseCompression ? 4 : 0);
        }
        return vehicleShadow;
    }

    public VehicleScript getScript() {
        return this.script;
    }

    public void setScript(String string) {
        Object object;
        int n;
        Passenger[] passengerArray;
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        this.scriptName = string;
        boolean bl = this.script != null;
        this.script = ScriptManager.instance.getVehicle(this.scriptName);
        if (this.script == null && !(passengerArray = ScriptManager.instance.getAllVehicleScripts()).isEmpty()) {
            ArrayList<VehicleScript> arrayList = new ArrayList<VehicleScript>();
            for (n = 0; n < passengerArray.size(); ++n) {
                object = (VehicleScript)passengerArray.get(n);
                if (((VehicleScript)object).getWheelCount() != 0) continue;
                arrayList.add((VehicleScript)object);
                passengerArray.remove(n--);
            }
            int n2 = n = this.loaded && this.parts.isEmpty() || this.scriptName.contains("Burnt") ? 1 : 0;
            if (n != 0 && !arrayList.isEmpty()) {
                this.script = (VehicleScript)arrayList.get(Rand.Next(arrayList.size()));
            } else if (!passengerArray.isEmpty()) {
                this.script = (VehicleScript)passengerArray.get(Rand.Next(passengerArray.size()));
            }
            if (this.script != null) {
                this.scriptName = this.script.getFullName();
            }
        }
        this.battery = null;
        this.models.clear();
        if (this.script != null) {
            Object object2;
            this.scriptName = this.script.getFullName();
            passengerArray = this.passengers;
            this.passengers = new Passenger[this.script.getPassengerCount()];
            for (int i = 0; i < this.passengers.length; ++i) {
                this.passengers[i] = i < passengerArray.length ? passengerArray[i] : new Passenger();
            }
            ArrayList<VehiclePart> arrayList = new ArrayList<VehiclePart>();
            arrayList.addAll(this.parts);
            this.parts.clear();
            for (n = 0; n < this.script.getPartCount(); ++n) {
                object = this.script.getPart(n);
                object2 = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    VehiclePart vehiclePart = (VehiclePart)arrayList.get(i);
                    if (vehiclePart.getScriptPart() != null && ((VehicleScript.Part)object).id.equals(vehiclePart.getScriptPart().id)) {
                        object2 = vehiclePart;
                        break;
                    }
                    if (vehiclePart.partId == null || !((VehicleScript.Part)object).id.equals(vehiclePart.partId)) continue;
                    object2 = vehiclePart;
                    break;
                }
                if (object2 == null) {
                    object2 = new VehiclePart(this);
                }
                ((VehiclePart)object2).setScriptPart((VehicleScript.Part)object);
                ((VehiclePart)object2).category = ((VehicleScript.Part)object).category;
                ((VehiclePart)object2).specificItem = ((VehicleScript.Part)object).specificItem;
                if (((VehicleScript.Part)object).container == null || ((VehicleScript.Part)object).container.contentType != null) {
                    ((VehiclePart)object2).setItemContainer(null);
                } else {
                    if (((VehiclePart)object2).getItemContainer() == null) {
                        ItemContainer itemContainer = new ItemContainer(((VehicleScript.Part)object).id, null, this);
                        ((VehiclePart)object2).setItemContainer(itemContainer);
                        itemContainer.ID = 0;
                    }
                    ((VehiclePart)object2).getItemContainer().Capacity = ((VehicleScript.Part)object).container.capacity;
                }
                if (((VehicleScript.Part)object).door == null) {
                    ((VehiclePart)object2).door = null;
                } else if (((VehiclePart)object2).door == null) {
                    ((VehiclePart)object2).door = new VehicleDoor((VehiclePart)object2);
                    ((VehiclePart)object2).door.init(((VehicleScript.Part)object).door);
                }
                if (((VehicleScript.Part)object).window == null) {
                    ((VehiclePart)object2).window = null;
                } else if (((VehiclePart)object2).window == null) {
                    ((VehiclePart)object2).window = new VehicleWindow((VehiclePart)object2);
                    ((VehiclePart)object2).window.init(((VehicleScript.Part)object).window);
                } else {
                    ((VehiclePart)object2).window.openable = ((VehicleScript.Part)object).window.openable;
                }
                ((VehiclePart)object2).parent = null;
                if (((VehiclePart)object2).children != null) {
                    ((VehiclePart)object2).children.clear();
                }
                this.parts.add((VehiclePart)object2);
                if (!"Battery".equals(((VehiclePart)object2).getId())) continue;
                this.battery = object2;
            }
            for (n = 0; n < this.script.getPartCount(); ++n) {
                object = this.parts.get(n);
                object2 = ((VehiclePart)object).getScriptPart();
                if (((VehicleScript.Part)object2).parent == null) continue;
                ((VehiclePart)object).parent = this.getPartById(((VehicleScript.Part)object2).parent);
                if (((VehiclePart)object).parent == null) continue;
                ((VehiclePart)object).parent.addChild((VehiclePart)object);
            }
            if (!bl && !this.loaded) {
                this.rearEndDurability = 99999;
                this.frontEndDurability = 99999;
            }
            this.frontEndDurability = Math.min(this.frontEndDurability, this.script.getFrontEndHealth());
            this.rearEndDurability = Math.min(this.rearEndDurability, this.script.getRearEndHealth());
            this.currentFrontEndDurability = this.frontEndDurability;
            this.currentRearEndDurability = this.rearEndDurability;
            for (n = 0; n < this.script.getPartCount(); ++n) {
                object = this.parts.get(n);
                ((VehiclePart)object).setInventoryItem(((VehiclePart)object).item);
            }
        }
        if (!this.loaded || this.colorHue == 0.0f && this.colorSaturation == 0.0f && this.colorValue == 0.0f) {
            this.doVehicleColor();
        }
        this.m_surroundVehicle.reset();
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String string) {
        assert (string == null || string.contains("."));
        this.scriptName = string;
    }

    public void setScript() {
        this.setScript(this.scriptName);
    }

    public void scriptReloaded() {
        Object object;
        int n;
        this.tempTransform2.setIdentity();
        if (this.physics != null) {
            this.getWorldTransform(this.tempTransform2);
            this.tempTransform2.basis.getUnnormalizedRotation(this.savedRot);
            this.breakConstraint(false, false);
            Bullet.removeVehicle(this.VehicleID);
            this.physics = null;
        }
        if (this.createdModel) {
            ModelManager.instance.Remove(this);
            this.createdModel = false;
        }
        this.vehicleEngineRPM = null;
        for (n = 0; n < this.parts.size(); ++n) {
            object = this.parts.get(n);
            ((VehiclePart)object).setInventoryItem(null);
            ((VehiclePart)object).bCreated = false;
        }
        this.setScript(this.scriptName);
        this.createPhysics();
        if (this.script != null) {
            for (n = 0; n < this.passengers.length; ++n) {
                VehicleScript.Position position;
                object = this.passengers[n];
                if (object == null || ((Passenger)object).character == null || (position = this.getPassengerPosition(n, "inside")) == null) continue;
                ((Passenger)object).offset.set((Vector3fc)position.offset);
            }
        }
        this.polyDirty = true;
        if (this.isEngineRunning()) {
            this.engineDoShuttingDown();
            this.engineState = engineStateTypes.Idle;
        }
        if (this.addedToWorld) {
            PolygonalMap2.instance.removeVehicleFromWorld(this);
            PolygonalMap2.instance.addVehicleToWorld(this);
        }
    }

    public String getSkin() {
        if (this.script == null || this.script.getSkinCount() == 0) {
            return "BOGUS";
        }
        if (this.skinIndex < 0 || this.skinIndex >= this.script.getSkinCount()) {
            this.skinIndex = Rand.Next(this.script.getSkinCount());
        }
        return this.script.getSkin((int)this.skinIndex).texture;
    }

    protected ModelInfo setModelVisible(VehiclePart vehiclePart, VehicleScript.Model model, boolean bl) {
        for (int i = 0; i < this.models.size(); ++i) {
            ModelInfo modelInfo = this.models.get(i);
            if (modelInfo.part != vehiclePart || modelInfo.scriptModel != model) continue;
            if (bl) {
                return modelInfo;
            }
            if (modelInfo.m_animPlayer != null) {
                modelInfo.m_animPlayer = Pool.tryRelease(modelInfo.m_animPlayer);
            }
            this.models.remove(i);
            if (this.createdModel) {
                ModelManager.instance.Remove(this);
                ModelManager.instance.addVehicle(this);
            }
            vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x40);
            this.updateFlags = (short)(this.updateFlags | 0x40);
            return null;
        }
        if (bl) {
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.part = vehiclePart;
            modelInfo.scriptModel = model;
            modelInfo.modelScript = ScriptManager.instance.getModelScript(model.file);
            modelInfo.wheelIndex = vehiclePart.getWheelIndex();
            this.models.add(modelInfo);
            if (this.createdModel) {
                ModelManager.instance.Remove(this);
                ModelManager.instance.addVehicle(this);
            }
            vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x40);
            this.updateFlags = (short)(this.updateFlags | 0x40);
            return modelInfo;
        }
        return null;
    }

    protected ModelInfo getModelInfoForPart(VehiclePart vehiclePart) {
        for (int i = 0; i < this.models.size(); ++i) {
            ModelInfo modelInfo = this.models.get(i);
            if (modelInfo.part != vehiclePart) continue;
            return modelInfo;
        }
        return null;
    }

    protected VehicleScript.Passenger getScriptPassenger(int n) {
        if (this.getScript() == null) {
            return null;
        }
        if (n < 0 || n >= this.getScript().getPassengerCount()) {
            return null;
        }
        return this.getScript().getPassenger(n);
    }

    public int getMaxPassengers() {
        return this.passengers.length;
    }

    public boolean setPassenger(int n, IsoGameCharacter isoGameCharacter, Vector3f vector3f) {
        if (n >= 0 && n < this.passengers.length) {
            if (n == 0) {
                this.setNeedPartsUpdate(true);
            }
            this.passengers[n].character = isoGameCharacter;
            this.passengers[n].offset.set((Vector3fc)vector3f);
            return true;
        }
        return false;
    }

    public boolean clearPassenger(int n) {
        if (n >= 0 && n < this.passengers.length) {
            this.passengers[n].character = null;
            this.passengers[n].offset.set(0.0f, 0.0f, 0.0f);
            return true;
        }
        return false;
    }

    public Passenger getPassenger(int n) {
        if (n >= 0 && n < this.passengers.length) {
            return this.passengers[n];
        }
        return null;
    }

    public IsoGameCharacter getCharacter(int n) {
        Passenger passenger = this.getPassenger(n);
        if (passenger != null) {
            return passenger.character;
        }
        return null;
    }

    public int getSeat(IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            if (this.getCharacter(i) != isoGameCharacter) continue;
            return i;
        }
        return -1;
    }

    public boolean isDriver(IsoGameCharacter isoGameCharacter) {
        return this.getSeat(isoGameCharacter) == 0;
    }

    public Vector3f getWorldPos(Vector3f vector3f, Vector3f vector3f2, VehicleScript vehicleScript) {
        return this.getWorldPos(vector3f.x, vector3f.y, vector3f.z, vector3f2, vehicleScript);
    }

    public Vector3f getWorldPos(float f, float f2, float f3, Vector3f vector3f, VehicleScript vehicleScript) {
        Transform transform = this.getWorldTransform(this.tempTransform);
        transform.origin.set(0.0f, 0.0f, 0.0f);
        vector3f.set(f, f2, f3);
        transform.transform(vector3f);
        float f4 = this.jniTransform.origin.x + WorldSimulation.instance.offsetX;
        float f5 = this.jniTransform.origin.z + WorldSimulation.instance.offsetY;
        float f6 = this.jniTransform.origin.y / 2.46f;
        vector3f.set(f4 + vector3f.x, f5 + vector3f.z, f6 + vector3f.y);
        return vector3f;
    }

    public Vector3f getWorldPos(Vector3f vector3f, Vector3f vector3f2) {
        return this.getWorldPos(vector3f.x, vector3f.y, vector3f.z, vector3f2, this.getScript());
    }

    public Vector3f getWorldPos(float f, float f2, float f3, Vector3f vector3f) {
        return this.getWorldPos(f, f2, f3, vector3f, this.getScript());
    }

    public Vector3f getLocalPos(Vector3f vector3f, Vector3f vector3f2) {
        return this.getLocalPos(vector3f.x, vector3f.y, vector3f.z, vector3f2);
    }

    public Vector3f getLocalPos(float f, float f2, float f3, Vector3f vector3f) {
        Transform transform = this.getWorldTransform(this.tempTransform);
        transform.inverse();
        vector3f.set(f - WorldSimulation.instance.offsetX, 0.0f, f2 - WorldSimulation.instance.offsetY);
        transform.transform(vector3f);
        return vector3f;
    }

    public Vector3f getPassengerLocalPos(int n, Vector3f vector3f) {
        Passenger passenger = this.getPassenger(n);
        if (passenger == null) {
            return null;
        }
        return vector3f.set((Vector3fc)this.script.getModel().getOffset()).add((Vector3fc)passenger.offset);
    }

    public Vector3f getPassengerWorldPos(int n, Vector3f vector3f) {
        Passenger passenger = this.getPassenger(n);
        if (passenger == null) {
            return null;
        }
        return this.getPassengerPositionWorldPos(passenger.offset.x, passenger.offset.y, passenger.offset.z, vector3f);
    }

    public Vector3f getPassengerPositionWorldPos(VehicleScript.Position position, Vector3f vector3f) {
        return this.getPassengerPositionWorldPos(position.offset.x, position.offset.y, position.offset.z, vector3f);
    }

    public Vector3f getPassengerPositionWorldPos(float f, float f2, float f3, Vector3f vector3f) {
        vector3f.set((Vector3fc)this.script.getModel().offset);
        vector3f.add(f, f2, f3);
        this.getWorldPos(vector3f.x, vector3f.y, vector3f.z, vector3f);
        vector3f.z = (int)this.getZ();
        return vector3f;
    }

    public VehicleScript.Anim getPassengerAnim(int n, String string) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        for (int i = 0; i < passenger.anims.size(); ++i) {
            VehicleScript.Anim anim = passenger.anims.get(i);
            if (!string.equals(anim.id)) continue;
            return anim;
        }
        return null;
    }

    public VehicleScript.Position getPassengerPosition(int n, String string) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        return passenger.getPositionById(string);
    }

    public VehiclePart getPassengerDoor(int n) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        return this.getPartById(passenger.door);
    }

    public VehiclePart getPassengerDoor2(int n) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        return this.getPartById(passenger.door2);
    }

    public boolean isPositionOnLeftOrRight(float f, float f2) {
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(f, f2, 0.0f, vector3f);
        f = vector3f.x;
        TL_vector3f_pool.get().release(vector3f);
        Vector3f vector3f2 = this.script.getExtents();
        Vector3f vector3f3 = this.script.getCenterOfMassOffset();
        float f3 = vector3f3.x - vector3f2.x / 2.0f;
        float f4 = vector3f3.x + vector3f2.x / 2.0f;
        return f < f3 * 0.98f || f > f4 * 0.98f;
    }

    public boolean haveOneDoorUnlocked() {
        for (int i = 0; i < this.getPartCount(); ++i) {
            VehiclePart vehiclePart = this.getPartByIndex(i);
            if (vehiclePart.getDoor() == null || !vehiclePart.getId().contains("Left") && !vehiclePart.getId().contains("Right") || vehiclePart.getDoor().isLocked() && !vehiclePart.getDoor().isOpen()) continue;
            return true;
        }
        return false;
    }

    public String getPassengerArea(int n) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        return passenger.area;
    }

    public void playPassengerAnim(int n, String string) {
        IsoGameCharacter isoGameCharacter = this.getCharacter(n);
        this.playPassengerAnim(n, string, isoGameCharacter);
    }

    public void playPassengerAnim(int n, String string, IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null) {
            return;
        }
        VehicleScript.Anim anim = this.getPassengerAnim(n, string);
        if (anim == null) {
            return;
        }
        this.playCharacterAnim(isoGameCharacter, anim, true);
    }

    public void playPassengerSound(int n, String string) {
        VehicleScript.Anim anim = this.getPassengerAnim(n, string);
        if (anim == null || anim.sound == null) {
            return;
        }
        this.playSound(anim.sound);
    }

    public void playPartAnim(VehiclePart vehiclePart, String string) {
        AnimationTrack animationTrack;
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        VehicleScript.Anim anim = vehiclePart.getAnimById(string);
        if (anim == null || StringUtils.isNullOrWhitespace(anim.anim)) {
            return;
        }
        ModelInfo modelInfo = this.getModelInfoForPart(vehiclePart);
        if (modelInfo == null) {
            return;
        }
        AnimationPlayer animationPlayer = modelInfo.getAnimationPlayer();
        if (animationPlayer == null || !animationPlayer.isReady()) {
            return;
        }
        if (animationPlayer.getMultiTrack().getIndexOfTrack(modelInfo.m_track) != -1) {
            animationPlayer.getMultiTrack().removeTrack(modelInfo.m_track);
        }
        modelInfo.m_track = null;
        SkinningData skinningData = animationPlayer.getSkinningData();
        if (skinningData != null && !skinningData.AnimationClips.containsKey(anim.anim)) {
            return;
        }
        modelInfo.m_track = animationTrack = animationPlayer.play(anim.anim, anim.bLoop);
        if (animationTrack != null) {
            animationTrack.setLayerIdx(0);
            animationTrack.BlendDelta = 1.0f;
            animationTrack.SpeedDelta = anim.rate;
            animationTrack.IsPlaying = anim.bAnimate;
            animationTrack.reverse = anim.bReverse;
            if (!modelInfo.modelScript.boneWeights.isEmpty()) {
                animationTrack.setBoneWeights(modelInfo.modelScript.boneWeights);
                animationTrack.initBoneWeights(skinningData);
            }
            if (vehiclePart.getWindow() != null) {
                animationTrack.setCurrentTimeValue(animationTrack.getDuration() * vehiclePart.getWindow().getOpenDelta());
            }
        }
    }

    public void playActorAnim(VehiclePart vehiclePart, String string, IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        VehicleScript.Anim anim = vehiclePart.getAnimById("Actor" + string);
        if (anim == null) {
            return;
        }
        this.playCharacterAnim(isoGameCharacter, anim, !"EngineDoor".equals(vehiclePart.getId()));
    }

    private void playCharacterAnim(IsoGameCharacter isoGameCharacter, VehicleScript.Anim anim, boolean bl) {
        Object object;
        isoGameCharacter.PlayAnimUnlooped(anim.anim);
        isoGameCharacter.getSpriteDef().setFrameSpeedPerFrame(anim.rate);
        isoGameCharacter.getLegsSprite().Animate = true;
        Vector3f vector3f = this.getForwardVector((Vector3f)TL_vector3f_pool.get().alloc());
        if (anim.angle.lengthSquared() != 0.0f) {
            object = (Matrix4f)TL_matrix4f_pool.get().alloc();
            object.rotationXYZ((float)Math.toRadians(anim.angle.x), (float)Math.toRadians(anim.angle.y), (float)Math.toRadians(anim.angle.z));
            vector3f.rotate((Quaternionfc)object.getNormalizedRotation(this.tempQuat4f));
            TL_matrix4f_pool.get().release(object);
        }
        object = (Vector2)TL_vector2_pool.get().alloc();
        ((Vector2)object).set(vector3f.x, vector3f.z);
        isoGameCharacter.DirectionFromVector((Vector2)object);
        TL_vector2_pool.get().release(object);
        isoGameCharacter.setForwardDirection(vector3f.x, vector3f.z);
        if (isoGameCharacter.getAnimationPlayer() != null) {
            isoGameCharacter.getAnimationPlayer().setTargetAngle(isoGameCharacter.getForwardDirection().getDirection());
            if (bl) {
                isoGameCharacter.getAnimationPlayer().setAngleToTarget();
            }
        }
        TL_vector3f_pool.get().release(vector3f);
    }

    public void playPartSound(VehiclePart vehiclePart, IsoPlayer isoPlayer, String string) {
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        VehicleScript.Anim anim = vehiclePart.getAnimById(string);
        if (anim == null || anim.sound == null) {
            return;
        }
        this.getEmitter().playSound(anim.sound, isoPlayer);
    }

    public void setCharacterPosition(IsoGameCharacter isoGameCharacter, int n, String string) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return;
        }
        VehicleScript.Position position = passenger.getPositionById(string);
        if (position == null) {
            return;
        }
        if (this.getCharacter(n) == isoGameCharacter) {
            this.passengers[n].offset.set((Vector3fc)position.offset);
        } else {
            Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
            if (position.area == null) {
                this.getPassengerPositionWorldPos(position, vector3f);
            } else {
                VehicleScript.Area area = this.script.getAreaById(position.area);
                Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
                Vector2 vector23 = this.areaPositionWorld4PlayerInteract(area, vector22);
                vector3f.x = vector23.x;
                vector3f.y = vector23.y;
                vector3f.z = 0.0f;
                TL_vector2_pool.get().release(vector22);
            }
            isoGameCharacter.setX(vector3f.x);
            isoGameCharacter.setY(vector3f.y);
            isoGameCharacter.setZ(0.0f);
            TL_vector3f_pool.get().release(vector3f);
        }
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            ((IsoPlayer)isoGameCharacter).dirtyRecalcGridStackTime = 10.0f;
        }
    }

    public void transmitCharacterPosition(int n, String string) {
        if (GameClient.bClient) {
            VehicleManager.instance.sendPassengerPosition(this, n, string);
        }
    }

    public void setCharacterPositionToAnim(IsoGameCharacter isoGameCharacter, int n, String string) {
        VehicleScript.Anim anim = this.getPassengerAnim(n, string);
        if (anim == null) {
            return;
        }
        if (this.getCharacter(n) == isoGameCharacter) {
            this.passengers[n].offset.set((Vector3fc)anim.offset);
        } else {
            Vector3f vector3f = this.getWorldPos(anim.offset, (Vector3f)TL_vector3f_pool.get().alloc());
            isoGameCharacter.setX(vector3f.x);
            isoGameCharacter.setY(vector3f.y);
            isoGameCharacter.setZ(0.0f);
            TL_vector3f_pool.get().release(vector3f);
        }
    }

    public int getPassengerSwitchSeatCount(int n) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return -1;
        }
        return passenger.switchSeats.size();
    }

    public VehicleScript.Passenger.SwitchSeat getPassengerSwitchSeat(int n, int n2) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        if (n2 < 0 || n2 >= passenger.switchSeats.size()) {
            return null;
        }
        return passenger.switchSeats.get(n2);
    }

    private VehicleScript.Passenger.SwitchSeat getSwitchSeat(int n, int n2) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return null;
        }
        for (int i = 0; i < passenger.switchSeats.size(); ++i) {
            VehicleScript.Passenger.SwitchSeat switchSeat = passenger.switchSeats.get(i);
            if (switchSeat.seat != n2 || this.getPartForSeatContainer(n2) == null || this.getPartForSeatContainer(n2).getInventoryItem() == null) continue;
            return switchSeat;
        }
        return null;
    }

    public String getSwitchSeatAnimName(int n, int n2) {
        VehicleScript.Passenger.SwitchSeat switchSeat = this.getSwitchSeat(n, n2);
        if (switchSeat == null) {
            return null;
        }
        return switchSeat.anim;
    }

    public float getSwitchSeatAnimRate(int n, int n2) {
        VehicleScript.Passenger.SwitchSeat switchSeat = this.getSwitchSeat(n, n2);
        if (switchSeat == null) {
            return 0.0f;
        }
        return switchSeat.rate;
    }

    public String getSwitchSeatSound(int n, int n2) {
        VehicleScript.Passenger.SwitchSeat switchSeat = this.getSwitchSeat(n, n2);
        if (switchSeat == null) {
            return null;
        }
        return switchSeat.sound;
    }

    public boolean canSwitchSeat(int n, int n2) {
        VehicleScript.Passenger.SwitchSeat switchSeat = this.getSwitchSeat(n, n2);
        return switchSeat != null;
    }

    public void switchSeat(IsoGameCharacter isoGameCharacter, int n) {
        int n2 = this.getSeat(isoGameCharacter);
        if (n2 == -1) {
            return;
        }
        this.clearPassenger(n2);
        VehicleScript.Position position = this.getPassengerPosition(n, "inside");
        if (position == null) {
            Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
            vector3f.set(0.0f, 0.0f, 0.0f);
            this.setPassenger(n, isoGameCharacter, vector3f);
            TL_vector3f_pool.get().release(vector3f);
        } else {
            this.setPassenger(n, isoGameCharacter, position.offset);
        }
    }

    public void playSwitchSeatAnim(int n, int n2) {
        IsoGameCharacter isoGameCharacter = this.getCharacter(n);
        if (isoGameCharacter == null) {
            return;
        }
        VehicleScript.Passenger.SwitchSeat switchSeat = this.getSwitchSeat(n, n2);
        if (switchSeat == null) {
            return;
        }
        isoGameCharacter.PlayAnimUnlooped(switchSeat.anim);
        isoGameCharacter.getSpriteDef().setFrameSpeedPerFrame(switchSeat.rate);
        isoGameCharacter.getLegsSprite().Animate = true;
    }

    public boolean isSeatOccupied(int n) {
        VehiclePart vehiclePart = this.getPartForSeatContainer(n);
        if (vehiclePart != null && vehiclePart.getItemContainer() != null && !vehiclePart.getItemContainer().getItems().isEmpty()) {
            return true;
        }
        return this.getCharacter(n) != null;
    }

    public boolean isSeatInstalled(int n) {
        VehiclePart vehiclePart = this.getPartForSeatContainer(n);
        return vehiclePart != null && vehiclePart.getInventoryItem() != null;
    }

    public int getBestSeat(IsoGameCharacter isoGameCharacter) {
        if ((int)this.getZ() != (int)isoGameCharacter.getZ()) {
            return -1;
        }
        if (isoGameCharacter.DistTo(this) > 5.0f) {
            return -1;
        }
        VehicleScript vehicleScript = this.getScript();
        if (vehicleScript == null) {
            return -1;
        }
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector3f vector3f2 = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        for (int i = 0; i < vehicleScript.getPassengerCount(); ++i) {
            float f;
            float f2;
            float f3;
            if (this.isEnterBlocked(isoGameCharacter, i) || this.isSeatOccupied(i)) continue;
            VehicleScript.Position position = this.getPassengerPosition(i, "outside");
            if (position != null) {
                this.getPassengerPositionWorldPos(position, vector3f);
                f3 = vector3f.x;
                f2 = vector3f.y;
                this.getPassengerPositionWorldPos(0.0f, position.offset.y, position.offset.z, vector3f2);
                vector22.set(vector3f2.x - isoGameCharacter.getX(), vector3f2.y - isoGameCharacter.getY());
                vector22.normalize();
                f = vector22.dot(isoGameCharacter.getForwardDirection());
                if (f > 0.5f && IsoUtils.DistanceTo(isoGameCharacter.getX(), isoGameCharacter.getY(), f3, f2) < 1.0f) {
                    TL_vector3f_pool.get().release(vector3f);
                    TL_vector3f_pool.get().release(vector3f2);
                    TL_vector2_pool.get().release(vector22);
                    return i;
                }
            }
            if ((position = this.getPassengerPosition(i, "outside2")) == null) continue;
            this.getPassengerPositionWorldPos(position, vector3f);
            f3 = vector3f.x;
            f2 = vector3f.y;
            this.getPassengerPositionWorldPos(0.0f, position.offset.y, position.offset.z, vector3f2);
            vector22.set(vector3f2.x - isoGameCharacter.getX(), vector3f2.y - isoGameCharacter.getY());
            vector22.normalize();
            f = vector22.dot(isoGameCharacter.getForwardDirection());
            if (!(f > 0.5f) || !(IsoUtils.DistanceTo(isoGameCharacter.getX(), isoGameCharacter.getY(), f3, f2) < 1.0f)) continue;
            TL_vector3f_pool.get().release(vector3f);
            TL_vector3f_pool.get().release(vector3f2);
            TL_vector2_pool.get().release(vector22);
            return i;
        }
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector3f2);
        TL_vector2_pool.get().release(vector22);
        return -1;
    }

    public void updateHasExtendOffsetForExit(IsoGameCharacter isoGameCharacter) {
        this.hasExtendOffsetExiting = true;
        this.updateHasExtendOffset(isoGameCharacter);
        this.getPoly();
    }

    public void updateHasExtendOffsetForExitEnd(IsoGameCharacter isoGameCharacter) {
        this.hasExtendOffsetExiting = false;
        this.updateHasExtendOffset(isoGameCharacter);
        this.getPoly();
    }

    public void updateHasExtendOffset(IsoGameCharacter isoGameCharacter) {
        this.hasExtendOffset = false;
        this.hasExtendOffsetExiting = false;
    }

    public VehiclePart getUseablePart(IsoGameCharacter isoGameCharacter) {
        return this.getUseablePart(isoGameCharacter, true);
    }

    public VehiclePart getUseablePart(IsoGameCharacter isoGameCharacter, boolean bl) {
        if (isoGameCharacter.getVehicle() != null) {
            return null;
        }
        if ((int)this.getZ() != (int)isoGameCharacter.getZ()) {
            return null;
        }
        if (isoGameCharacter.DistTo(this) > 6.0f) {
            return null;
        }
        VehicleScript vehicleScript = this.getScript();
        if (vehicleScript == null) {
            return null;
        }
        Vector3f vector3f = vehicleScript.getExtents();
        Vector3f vector3f2 = vehicleScript.getCenterOfMassOffset();
        float f = vector3f2.z - vector3f.z / 2.0f;
        float f2 = vector3f2.z + vector3f.z / 2.0f;
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        for (int i = 0; i < this.parts.size(); ++i) {
            Vector2 vector23;
            VehicleScript.Area area;
            String string;
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.getArea() == null || !this.isInArea(vehiclePart.getArea(), isoGameCharacter) || (string = vehiclePart.getLuaFunction("use")) == null || string.equals("") || (area = vehicleScript.getAreaById(vehiclePart.getArea())) == null || (vector23 = this.areaPositionLocal(area, vector22)) == null) continue;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (vector23.y >= f2 || vector23.y <= f) {
                f3 = vector23.x;
            } else {
                f5 = vector23.y;
            }
            if (!bl) {
                return vehiclePart;
            }
            this.getWorldPos(f3, f4, f5, vector3f3);
            Vector2 vector24 = vector22;
            vector24.set(vector3f3.x - isoGameCharacter.getX(), vector3f3.y - isoGameCharacter.getY());
            vector24.normalize();
            float f6 = vector24.dot(isoGameCharacter.getForwardDirection());
            if (!(f6 > 0.5f) || PolygonalMap2.instance.lineClearCollide(isoGameCharacter.x, isoGameCharacter.y, vector3f3.x, vector3f3.y, (int)isoGameCharacter.z, this, false, true)) break;
            TL_vector2_pool.get().release(vector22);
            TL_vector3f_pool.get().release(vector3f3);
            return vehiclePart;
        }
        TL_vector2_pool.get().release(vector22);
        TL_vector3f_pool.get().release(vector3f3);
        return null;
    }

    public VehiclePart getClosestWindow(IsoGameCharacter isoGameCharacter) {
        if ((int)this.getZ() != (int)isoGameCharacter.getZ()) {
            return null;
        }
        if (isoGameCharacter.DistTo(this) > 5.0f) {
            return null;
        }
        Vector3f vector3f = this.script.getExtents();
        Vector3f vector3f2 = this.script.getCenterOfMassOffset();
        float f = vector3f2.z - vector3f.z / 2.0f;
        float f2 = vector3f2.z + vector3f.z / 2.0f;
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.getWindow() == null || vehiclePart.getArea() == null || !this.isInArea(vehiclePart.getArea(), isoGameCharacter)) continue;
            VehicleScript.Area area = this.script.getAreaById(vehiclePart.getArea());
            if (area.y >= f2 || area.y <= f) {
                vector3f3.set(area.x, 0.0f, 0.0f);
            } else {
                vector3f3.set(0.0f, 0.0f, area.y);
            }
            this.getWorldPos(vector3f3, vector3f3);
            Vector2 vector23 = vector22;
            vector23.set(vector3f3.x - isoGameCharacter.getX(), vector3f3.y - isoGameCharacter.getY());
            vector23.normalize();
            float f3 = vector23.dot(isoGameCharacter.getForwardDirection());
            if (!(f3 > 0.5f)) break;
            TL_vector2_pool.get().release(vector22);
            TL_vector3f_pool.get().release(vector3f3);
            return vehiclePart;
        }
        TL_vector2_pool.get().release(vector22);
        TL_vector3f_pool.get().release(vector3f3);
        return null;
    }

    public void getFacingPosition(IsoGameCharacter isoGameCharacter, Vector2 vector22) {
        Vector3f vector3f = this.getLocalPos(isoGameCharacter.getX(), isoGameCharacter.getY(), isoGameCharacter.getZ(), (Vector3f)TL_vector3f_pool.get().alloc());
        Vector3f vector3f2 = this.script.getExtents();
        Vector3f vector3f3 = this.script.getCenterOfMassOffset();
        float f = vector3f3.x - vector3f2.x / 2.0f;
        float f2 = vector3f3.x + vector3f2.x / 2.0f;
        float f3 = vector3f3.z - vector3f2.z / 2.0f;
        float f4 = vector3f3.z + vector3f2.z / 2.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (vector3f.x <= 0.0f && vector3f.z >= f3 && vector3f.z <= f4) {
            f6 = vector3f.z;
        } else if (vector3f.x > 0.0f && vector3f.z >= f3 && vector3f.z <= f4) {
            f6 = vector3f.z;
        } else if (vector3f.z <= 0.0f && vector3f.x >= f && vector3f.x <= f2) {
            f5 = vector3f.x;
        } else if (vector3f.z > 0.0f && vector3f.x >= f && vector3f.x <= f2) {
            f5 = vector3f.x;
        }
        this.getWorldPos(f5, 0.0f, f6, vector3f);
        vector22.set(vector3f.x, vector3f.y);
        TL_vector3f_pool.get().release(vector3f);
    }

    public boolean enter(int n, IsoGameCharacter isoGameCharacter, Vector3f vector3f) {
        if (!GameClient.bClient) {
            VehiclesDB2.instance.updateVehicleAndTrailer(this);
        }
        if (isoGameCharacter == null) {
            return false;
        }
        if (isoGameCharacter.getVehicle() != null && !isoGameCharacter.getVehicle().exit(isoGameCharacter)) {
            return false;
        }
        if (this.setPassenger(n, isoGameCharacter, vector3f)) {
            isoGameCharacter.setVehicle(this);
            isoGameCharacter.setCollidable(false);
            if (GameClient.bClient) {
                VehicleManager.instance.sendEnter(GameClient.connection, this, isoGameCharacter, n);
            }
            if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                ((IsoPlayer)isoGameCharacter).dirtyRecalcGridStackTime = 10.0f;
            }
            return true;
        }
        return false;
    }

    public boolean enter(int n, IsoGameCharacter isoGameCharacter) {
        if (this.getPartForSeatContainer(n) == null || this.getPartForSeatContainer(n).getInventoryItem() == null) {
            return false;
        }
        VehicleScript.Position position = this.getPassengerPosition(n, "outside");
        if (position != null) {
            return this.enter(n, isoGameCharacter, position.offset);
        }
        return false;
    }

    public boolean enterRSync(int n, IsoGameCharacter isoGameCharacter, BaseVehicle baseVehicle) {
        if (isoGameCharacter == null) {
            return false;
        }
        VehicleScript.Position position = this.getPassengerPosition(n, "inside");
        if (position != null) {
            if (this.setPassenger(n, isoGameCharacter, position.offset)) {
                isoGameCharacter.setVehicle(baseVehicle);
                isoGameCharacter.setCollidable(false);
                if (GameClient.bClient) {
                    LuaEventManager.triggerEvent("OnContainerUpdate");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean exit(IsoGameCharacter isoGameCharacter) {
        if (!GameClient.bClient) {
            VehiclesDB2.instance.updateVehicleAndTrailer(this);
        }
        if (isoGameCharacter == null) {
            return false;
        }
        int n = this.getSeat(isoGameCharacter);
        if (n == -1) {
            return false;
        }
        if (this.clearPassenger(n)) {
            this.enginePower = (int)this.getScript().getEngineForce();
            isoGameCharacter.setVehicle(null);
            isoGameCharacter.savedVehicleSeat = (short)-1;
            isoGameCharacter.setCollidable(true);
            if (GameClient.bClient) {
                VehicleManager.instance.sendExit(GameClient.connection, this, isoGameCharacter, n);
            }
            if (this.getDriver() == null && this.soundHornOn) {
                this.onHornStop();
            }
            this.polyGarageCheck = true;
            this.polyDirty = true;
            return true;
        }
        return false;
    }

    public boolean exitRSync(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null) {
            return false;
        }
        int n = this.getSeat(isoGameCharacter);
        if (n == -1) {
            return false;
        }
        if (this.clearPassenger(n)) {
            isoGameCharacter.setVehicle(null);
            isoGameCharacter.setCollidable(true);
            if (GameClient.bClient) {
                LuaEventManager.triggerEvent("OnContainerUpdate");
            }
            return true;
        }
        return false;
    }

    public boolean hasRoof(int n) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return false;
        }
        return passenger.hasRoof;
    }

    public boolean showPassenger(int n) {
        VehicleScript.Passenger passenger = this.getScriptPassenger(n);
        if (passenger == null) {
            return false;
        }
        return passenger.showPassenger;
    }

    public boolean showPassenger(IsoGameCharacter isoGameCharacter) {
        int n = this.getSeat(isoGameCharacter);
        return this.showPassenger(n);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.square != null) {
            float f = 5.0E-4f;
            this.x = PZMath.clamp(this.x, (float)this.square.x + f, (float)(this.square.x + 1) - f);
            this.y = PZMath.clamp(this.y, (float)this.square.y + f, (float)(this.square.y + 1) - f);
        }
        super.save(byteBuffer, bl);
        Quaternionf quaternionf = this.savedRot;
        Transform transform = this.getWorldTransform(this.tempTransform);
        byteBuffer.putFloat(transform.origin.y);
        transform.getRotation(quaternionf);
        byteBuffer.putFloat(quaternionf.x);
        byteBuffer.putFloat(quaternionf.y);
        byteBuffer.putFloat(quaternionf.z);
        byteBuffer.putFloat(quaternionf.w);
        GameWindow.WriteStringUTF(byteBuffer, this.scriptName);
        byteBuffer.putInt(this.skinIndex);
        byteBuffer.put((byte)(this.isEngineRunning() ? 1 : 0));
        byteBuffer.putInt(this.frontEndDurability);
        byteBuffer.putInt(this.rearEndDurability);
        byteBuffer.putInt(this.currentFrontEndDurability);
        byteBuffer.putInt(this.currentRearEndDurability);
        byteBuffer.putInt(this.engineLoudness);
        byteBuffer.putInt(this.engineQuality);
        byteBuffer.putInt(this.keyId);
        byteBuffer.put(this.keySpawned);
        byteBuffer.put((byte)(this.headlightsOn ? 1 : 0));
        byteBuffer.put((byte)(this.bCreated ? 1 : 0));
        byteBuffer.put((byte)(this.soundHornOn ? 1 : 0));
        byteBuffer.put((byte)(this.soundBackMoveOn ? 1 : 0));
        byteBuffer.put((byte)this.lightbarLightsMode.get());
        byteBuffer.put((byte)this.lightbarSirenMode.get());
        byteBuffer.putShort((short)this.parts.size());
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart object = this.parts.get(i);
            object.save(byteBuffer);
        }
        byteBuffer.put((byte)(this.keyIsOnDoor ? 1 : 0));
        byteBuffer.put((byte)(this.hotwired ? 1 : 0));
        byteBuffer.put((byte)(this.hotwiredBroken ? 1 : 0));
        byteBuffer.put((byte)(this.keysInIgnition ? 1 : 0));
        byteBuffer.putFloat(this.rust);
        byteBuffer.putFloat(this.colorHue);
        byteBuffer.putFloat(this.colorSaturation);
        byteBuffer.putFloat(this.colorValue);
        byteBuffer.putInt(this.enginePower);
        byteBuffer.putShort(this.VehicleID);
        GameWindow.WriteString(byteBuffer, null);
        byteBuffer.putInt(this.mechanicalID);
        byteBuffer.put((byte)(this.alarmed ? 1 : 0));
        byteBuffer.putDouble(this.sirenStartTime);
        if (this.getCurrentKey() != null) {
            byteBuffer.put((byte)1);
            this.getCurrentKey().saveWithSize(byteBuffer, false);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)this.bloodIntensity.size());
        for (Map.Entry<String, Byte> entry : this.bloodIntensity.entrySet()) {
            GameWindow.WriteStringUTF(byteBuffer, entry.getKey());
            byteBuffer.put(entry.getValue());
        }
        if (this.vehicleTowingID != -1) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.vehicleTowingID);
            GameWindow.WriteStringUTF(byteBuffer, this.towAttachmentSelf);
            GameWindow.WriteStringUTF(byteBuffer, this.towAttachmentOther);
            byteBuffer.putFloat(this.towConstraintZOffset);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.putFloat(this.getRegulatorSpeed());
        byteBuffer.put((byte)(this.previouslyEntered ? 1 : 0));
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        int n2;
        boolean bl2;
        super.load(byteBuffer, n, bl);
        if (this.z < 0.0f) {
            this.z = 0.0f;
        }
        if (n >= 173) {
            this.savedPhysicsZ = PZMath.clamp(byteBuffer.getFloat(), 0.0f, (float)((int)this.z) + 2.4477f);
        }
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        float f4 = byteBuffer.getFloat();
        this.savedRot.set(f, f2, f3, f4);
        this.jniTransform.origin.set(this.getX() - WorldSimulation.instance.offsetX, Float.isNaN(this.savedPhysicsZ) ? this.z : this.savedPhysicsZ, this.getY() - WorldSimulation.instance.offsetY);
        this.jniTransform.setRotation(this.savedRot);
        this.scriptName = GameWindow.ReadStringUTF(byteBuffer);
        this.skinIndex = byteBuffer.getInt();
        boolean bl3 = bl2 = byteBuffer.get() == 1;
        if (bl2) {
            this.engineState = engineStateTypes.Running;
        }
        this.frontEndDurability = byteBuffer.getInt();
        this.rearEndDurability = byteBuffer.getInt();
        this.currentFrontEndDurability = byteBuffer.getInt();
        this.currentRearEndDurability = byteBuffer.getInt();
        this.engineLoudness = byteBuffer.getInt();
        this.engineQuality = byteBuffer.getInt();
        this.engineQuality = PZMath.clamp(this.engineQuality, 0, 100);
        this.keyId = byteBuffer.getInt();
        this.keySpawned = byteBuffer.get();
        this.headlightsOn = byteBuffer.get() == 1;
        this.bCreated = byteBuffer.get() == 1;
        this.soundHornOn = byteBuffer.get() == 1;
        this.soundBackMoveOn = byteBuffer.get() == 1;
        this.lightbarLightsMode.set(byteBuffer.get());
        this.lightbarSirenMode.set(byteBuffer.get());
        int n3 = byteBuffer.getShort();
        for (n2 = 0; n2 < n3; ++n2) {
            VehiclePart vehiclePart = new VehiclePart(this);
            vehiclePart.load(byteBuffer, n);
            this.parts.add(vehiclePart);
        }
        if (n >= 112) {
            this.keyIsOnDoor = byteBuffer.get() == 1;
            this.hotwired = byteBuffer.get() == 1;
            this.hotwiredBroken = byteBuffer.get() == 1;
            boolean bl4 = this.keysInIgnition = byteBuffer.get() == 1;
        }
        if (n >= 116) {
            this.rust = byteBuffer.getFloat();
            this.colorHue = byteBuffer.getFloat();
            this.colorSaturation = byteBuffer.getFloat();
            this.colorValue = byteBuffer.getFloat();
        }
        if (n >= 117) {
            this.enginePower = byteBuffer.getInt();
        }
        if (n >= 120) {
            byteBuffer.getShort();
        }
        if (n >= 122) {
            String string = GameWindow.ReadString(byteBuffer);
            this.mechanicalID = byteBuffer.getInt();
        }
        if (n >= 124) {
            boolean bl5 = this.alarmed = byteBuffer.get() == 1;
        }
        if (n >= 129) {
            this.sirenStartTime = byteBuffer.getDouble();
        }
        if (n >= 133 && byteBuffer.get() == 1) {
            InventoryItem inventoryItem = null;
            try {
                inventoryItem = InventoryItem.loadItem(byteBuffer, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (inventoryItem != null) {
                this.setCurrentKey(inventoryItem);
            }
        }
        if (n >= 165) {
            n2 = byteBuffer.get();
            for (int i = 0; i < n2; ++i) {
                String string = GameWindow.ReadStringUTF(byteBuffer);
                byte by = byteBuffer.get();
                this.bloodIntensity.put(string, by);
            }
        }
        if (n >= 174) {
            if (byteBuffer.get() == 1) {
                this.vehicleTowingID = byteBuffer.getInt();
                this.towAttachmentSelf = GameWindow.ReadStringUTF(byteBuffer);
                this.towAttachmentOther = GameWindow.ReadStringUTF(byteBuffer);
                this.towConstraintZOffset = byteBuffer.getFloat();
            }
        } else if (n >= 172) {
            this.vehicleTowingID = byteBuffer.getInt();
        }
        if (n >= 188) {
            this.setRegulatorSpeed(byteBuffer.getFloat());
        }
        if (n >= 195) {
            this.previouslyEntered = byteBuffer.get() == 1;
        }
        this.loaded = true;
    }

    @Override
    public void softReset() {
        this.keySpawned = 0;
        this.keyIsOnDoor = false;
        this.keysInIgnition = false;
        this.currentKey = null;
        this.previouslyEntered = false;
        this.engineState = engineStateTypes.Idle;
        this.randomizeContainers();
    }

    public void trySpawnKey() {
        int n;
        if (GameClient.bClient) {
            return;
        }
        if (this.script == null || this.script.getPartById("Engine") == null) {
            return;
        }
        if (this.keySpawned == 1) {
            return;
        }
        if (SandboxOptions.getInstance().VehicleEasyUse.getValue()) {
            this.addKeyToGloveBox();
            return;
        }
        VehicleType vehicleType = VehicleType.getTypeFromName(this.getVehicleType());
        int n2 = n = vehicleType == null ? 70 : vehicleType.getChanceToSpawnKey();
        if (Rand.Next(100) <= n) {
            this.addKeyToWorld();
        }
        this.keySpawned = 1;
    }

    public boolean shouldCollideWithCharacters() {
        if (this.vehicleTowedBy != null) {
            return this.vehicleTowedBy.shouldCollideWithCharacters();
        }
        float f = this.getSpeed2D();
        return this.isEngineRunning() ? f > 0.05f : f > 1.0f;
    }

    public boolean shouldCollideWithObjects() {
        if (this.vehicleTowedBy != null) {
            return this.vehicleTowedBy.shouldCollideWithObjects();
        }
        return this.isEngineRunning();
    }

    public void brekingObjects() {
        Object object;
        int n;
        boolean bl = this.shouldCollideWithCharacters();
        boolean bl2 = this.shouldCollideWithObjects();
        if (!bl && !bl2) {
            return;
        }
        Vector3f vector3f = this.script.getExtents();
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        float f = Math.max(vector3f.x / 2.0f, vector3f.z / 2.0f) + 0.3f + 1.0f;
        int n2 = (int)Math.ceil(f);
        for (int i = -n2; i < n2; ++i) {
            for (n = -n2; n < n2; ++n) {
                Object object2;
                IsoObject isoObject;
                int n3;
                object = this.getCell().getGridSquare(this.x + (float)n, this.y + (float)i, this.z);
                if (object == null) continue;
                if (bl2) {
                    for (n3 = 0; n3 < ((IsoGridSquare)object).getObjects().size(); ++n3) {
                        isoObject = ((IsoGridSquare)object).getObjects().get(n3);
                        if (isoObject instanceof IsoWorldInventoryObject) continue;
                        object2 = null;
                        if (this.brekingObjectsList.contains(isoObject) || isoObject == null || isoObject.getProperties() == null) continue;
                        if (isoObject.getProperties().Is("CarSlowFactor")) {
                            object2 = this.testCollisionWithObject(isoObject, 0.3f, vector22);
                        }
                        if (object2 != null) {
                            this.brekingObjectsList.add(isoObject);
                            if (!GameClient.bClient) {
                                isoObject.Collision((Vector2)object2, this);
                            }
                        }
                        if (isoObject.getProperties().Is("HitByCar")) {
                            object2 = this.testCollisionWithObject(isoObject, 0.3f, vector22);
                        }
                        if (object2 != null && !GameClient.bClient) {
                            isoObject.Collision((Vector2)object2, this);
                        }
                        this.checkCollisionWithPlant((IsoGridSquare)object, isoObject, vector22);
                    }
                }
                if (bl) {
                    for (n3 = 0; n3 < ((IsoGridSquare)object).getMovingObjects().size(); ++n3) {
                        isoObject = ((IsoGridSquare)object).getMovingObjects().get(n3);
                        object2 = Type.tryCastTo(isoObject, IsoZombie.class);
                        if (object2 != null) {
                            if (((IsoZombie)object2).isProne()) {
                                this.testCollisionWithProneCharacter((IsoGameCharacter)object2, false);
                            }
                            ((IsoZombie)object2).setVehicle4TestCollision(this);
                        }
                        if (!(isoObject instanceof IsoPlayer) || isoObject == this.getDriver()) continue;
                        IsoPlayer isoPlayer = (IsoPlayer)isoObject;
                        isoPlayer.setVehicle4TestCollision(this);
                    }
                }
                if (!bl2) continue;
                for (n3 = 0; n3 < ((IsoGridSquare)object).getStaticMovingObjects().size(); ++n3) {
                    isoObject = ((IsoGridSquare)object).getStaticMovingObjects().get(n3);
                    object2 = Type.tryCastTo(isoObject, IsoDeadBody.class);
                    if (object2 == null) continue;
                    int n4 = this.testCollisionWithCorpse((IsoDeadBody)object2, true);
                }
            }
        }
        float f2 = -999.0f;
        for (n = 0; n < this.brekingObjectsList.size(); ++n) {
            object = this.brekingObjectsList.get(n);
            Vector2 vector23 = this.testCollisionWithObject((IsoObject)object, 1.0f, vector22);
            if (vector23 == null || !((IsoObject)object).getSquare().getObjects().contains(object)) {
                this.brekingObjectsList.remove(object);
                ((IsoObject)object).UnCollision(this);
                continue;
            }
            if (!(f2 < ((IsoObject)object).GetVehicleSlowFactor(this))) continue;
            f2 = ((IsoObject)object).GetVehicleSlowFactor(this);
        }
        this.brekingSlowFactor = f2 != -999.0f ? PZMath.clamp(f2, 0.0f, 34.0f) : 0.0f;
        TL_vector2_pool.get().release(vector22);
    }

    private void updateVelocityMultiplier() {
        if (this.physics == null || this.getScript() == null) {
            return;
        }
        Vector3f vector3f = this.getLinearVelocity((Vector3f)TL_vector3f_pool.get().alloc());
        vector3f.y = 0.0f;
        float f = vector3f.length();
        float f2 = 100000.0f;
        float f3 = 1.0f;
        if (this.getScript().getWheelCount() > 0) {
            if (f > 0.0f && f > 34.0f - this.brekingSlowFactor) {
                f2 = 34.0f - this.brekingSlowFactor;
                f3 = (34.0f - this.brekingSlowFactor) / f;
            }
        } else if (this.getVehicleTowedBy() == null) {
            f2 = 0.0f;
            f3 = 0.1f;
        }
        Bullet.setVehicleVelocityMultiplier(this.VehicleID, f2, f3);
        TL_vector3f_pool.get().release(vector3f);
    }

    private void playScrapePastPlantSound(IsoGridSquare isoGridSquare) {
        if (this.emitter != null && !this.emitter.isPlaying(this.soundScrapePastPlant)) {
            this.emitter.setPos((float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, isoGridSquare.z);
            this.soundScrapePastPlant = this.emitter.playSoundImpl("VehicleScrapePastPlant", isoGridSquare);
        }
    }

    private void checkCollisionWithPlant(IsoGridSquare isoGridSquare, IsoObject isoObject, Vector2 vector22) {
        IsoTree isoTree = Type.tryCastTo(isoObject, IsoTree.class);
        if (isoTree == null && !isoObject.getProperties().Is("Bush")) {
            return;
        }
        float f = Math.abs(this.getCurrentSpeedKmHour());
        if (f <= 1.0f) {
            return;
        }
        Vector2 vector23 = this.testCollisionWithObject(isoObject, 0.3f, vector22);
        if (vector23 == null) {
            return;
        }
        if (isoTree != null && isoTree.getSize() == 1) {
            this.ApplyImpulse4Break(isoObject, 0.025f);
            this.playScrapePastPlantSound(isoGridSquare);
            return;
        }
        if (this.isPositionOnLeftOrRight(vector23.x, vector23.y)) {
            this.ApplyImpulse4Break(isoObject, 0.025f);
            this.playScrapePastPlantSound(isoGridSquare);
            return;
        }
        if (f < 10.0f) {
            this.ApplyImpulse4Break(isoObject, 0.025f);
            this.playScrapePastPlantSound(isoGridSquare);
            return;
        }
        this.ApplyImpulse4Break(isoObject, 0.1f);
        this.playScrapePastPlantSound(isoGridSquare);
    }

    public void damageObjects(float f) {
        if (!this.isEngineRunning()) {
            return;
        }
        Vector3f vector3f = this.script.getExtents();
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        float f2 = Math.max(vector3f.x / 2.0f, vector3f.z / 2.0f) + 0.3f + 1.0f;
        int n = (int)Math.ceil(f2);
        for (int i = -n; i < n; ++i) {
            for (int j = -n; j < n; ++j) {
                IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x + (float)j, this.y + (float)i, this.z);
                if (isoGridSquare == null) continue;
                for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                    IsoGridSquare isoGridSquare2;
                    IsoObject isoObject = isoGridSquare.getObjects().get(k);
                    Vector2 vector23 = null;
                    if (isoObject instanceof IsoTree && (vector23 = this.testCollisionWithObject(isoObject, 2.0f, vector22)) != null) {
                        isoObject.setRenderEffect(RenderEffectType.Hit_Tree_Shudder);
                    }
                    if (vector23 == null && isoObject instanceof IsoWindow) {
                        vector23 = this.testCollisionWithObject(isoObject, 1.0f, vector22);
                    }
                    if (vector23 == null && isoObject.sprite != null && (isoObject.sprite.getProperties().Is("HitByCar") || isoObject.sprite.getProperties().Is("CarSlowFactor"))) {
                        vector23 = this.testCollisionWithObject(isoObject, 1.0f, vector22);
                    }
                    if (vector23 == null && (isoGridSquare2 = this.getCell().getGridSquare(this.x + (float)j, this.y + (float)i, 1.0)) != null && isoGridSquare2.getHasTypes().isSet(IsoObjectType.lightswitch)) {
                        vector23 = this.testCollisionWithObject(isoObject, 1.0f, vector22);
                    }
                    if (vector23 == null && (isoGridSquare2 = this.getCell().getGridSquare(this.x + (float)j, this.y + (float)i, 0.0)) != null && isoGridSquare2.getHasTypes().isSet(IsoObjectType.lightswitch)) {
                        vector23 = this.testCollisionWithObject(isoObject, 1.0f, vector22);
                    }
                    if (vector23 == null) continue;
                    isoObject.Hit(vector23, this, f);
                }
            }
        }
        TL_vector2_pool.get().release(vector22);
    }

    @Override
    public void update() {
        VehiclePart vehiclePart;
        int n;
        Object object;
        float f;
        int n2;
        int n3;
        float f2;
        if (this.removedFromWorld) {
            DebugLog.Vehicle.debugln("vehicle update() removedFromWorld=true id=%d", this.VehicleID);
            return;
        }
        if (!this.getCell().vehicles.contains(this)) {
            DebugLog.Vehicle.debugln("vehicle update() not in cell.vehicles list id=%d x=%f y=%f %s", this.VehicleID, Float.valueOf(this.x), Float.valueOf(this.y), this);
            this.getCell().getRemoveList().add(this);
            return;
        }
        if (this.chunk == null) {
            DebugLog.Vehicle.debugln("vehicle update() chunk=null id=%d x=%f y=%f", this.VehicleID, Float.valueOf(this.x), Float.valueOf(this.y));
        } else if (!this.chunk.vehicles.contains(this)) {
            DebugLog.Vehicle.debugln("vehicle update() not in chunk.vehicles list id=%d x=%f y=%f", this.VehicleID, Float.valueOf(this.x), Float.valueOf(this.y));
            if (GameClient.bClient) {
                VehicleManager.instance.sendRequestGetPosition(this.VehicleID, PacketTypes.PacketType.VehiclesUnreliable);
            }
        } else if (!GameServer.bServer && this.chunk.refs.isEmpty()) {
            DebugLog.Vehicle.debugln("vehicle update() chunk was unloaded id=%d", this.VehicleID);
            this.removeFromWorld();
            return;
        }
        super.update();
        if (GameClient.bClient || GameServer.bServer) {
            this.isReliable = this.physicReliableLimit.Check();
        }
        if (GameClient.bClient && this.hasAuthorization(GameClient.connection)) {
            this.updatePhysicsNetwork();
        }
        if (this.getVehicleTowing() != null && this.getDriver() != null) {
            f2 = 2.5f;
            if (this.getVehicleTowing().getPartCount() == 0) {
                f2 = 12.0f;
            }
            if (this.getVehicleTowing().scriptName.equals("Base.Trailer")) {
                VehiclePart vehiclePart2 = this.getVehicleTowing().getPartById("TrailerTrunk");
                if (this.getCurrentSpeedKmHour() > 30.0f && vehiclePart2.getCondition() < 50 && !vehiclePart2.container.Items.isEmpty()) {
                    int n4;
                    ArrayList<InventoryItem> arrayList = new ArrayList<InventoryItem>();
                    for (n4 = 0; n4 < vehiclePart2.container.Items.size(); ++n4) {
                        if (!((double)vehiclePart2.container.Items.get(n4).getWeight() >= 3.5)) continue;
                        arrayList.add(vehiclePart2.container.Items.get(n4));
                    }
                    if (!arrayList.isEmpty()) {
                        n4 = vehiclePart2.getCondition();
                        n3 = 0;
                        n2 = 0;
                        for (int i = 0; i < this.getVehicleTowing().parts.size(); ++i) {
                            VehiclePart vehiclePart3 = this.getVehicleTowing().getPartByIndex(i);
                            if (vehiclePart3 == null || vehiclePart3.item == null) continue;
                            if (vehiclePart3.partId != null && vehiclePart3.partId.contains("Suspension")) {
                                n3 += vehiclePart3.getCondition();
                                continue;
                            }
                            if (vehiclePart3.partId == null || !vehiclePart3.partId.contains("Tire")) continue;
                            n2 += vehiclePart3.getCondition();
                        }
                        f = this.parameterVehicleSteer.getCurrentValue();
                        int n5 = (int)(Math.pow(100 - n4 * 2, 2.0) * 0.3 * (1.0 + (double)(100 - n3 / 2) * 0.005) * (1.0 + (double)(100 - n3 / 2) * 0.005) * (double)(1.0f + f / 3.0f));
                        if (Rand.Next(0, Math.max(10000 - n5, 1)) == 0) {
                            object = (InventoryItem)arrayList.get(Rand.Next(0, arrayList.size()));
                            ((InventoryItem)object).setCondition(((InventoryItem)object).getCondition() - ((InventoryItem)object).getConditionMax() / 10);
                            vehiclePart2.getSquare().AddWorldInventoryItem((InventoryItem)object, Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
                            vehiclePart2.container.Items.remove(object);
                            vehiclePart2.getSquare().playSound("thumpa2");
                        }
                    }
                }
            }
        }
        if (this.getVehicleTowedBy() != null && this.getDriver() != null) {
            f2 = 2.5f;
            if (this.getVehicleTowedBy().getPartCount() == 0) {
                f2 = 12.0f;
            }
        }
        if (this.physics != null && this.vehicleTowingID != -1 && this.vehicleTowing == null) {
            this.tryReconnectToTowedVehicle();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.getVehicleTowedBy() != null && this.getVehicleTowedBy().getController() != null) {
            bl = this.getVehicleTowedBy() != null && this.getVehicleTowedBy().getController().isEnable;
            boolean bl3 = bl2 = this.getVehicleTowing() != null && this.getVehicleTowing().getDriver() != null;
        }
        if (this.physics != null) {
            int n6;
            boolean bl4 = this.getDriver() != null || bl || bl2;
            long l = System.currentTimeMillis();
            if (this.constraintChangedTime != -1L) {
                if (this.constraintChangedTime + 3500L < l) {
                    this.constraintChangedTime = -1L;
                    if (!bl4 && this.physicActiveCheck < l) {
                        this.setPhysicsActive(false);
                    }
                }
            } else {
                if (this.physicActiveCheck != -1L && (bl4 || !this.physics.isEnable)) {
                    this.physicActiveCheck = -1L;
                }
                if (!bl4 && this.physics.isEnable && this.physicActiveCheck != -1L && this.physicActiveCheck < l) {
                    this.physicActiveCheck = -1L;
                    this.setPhysicsActive(false);
                }
            }
            if (this.getVehicleTowedBy() != null && this.getScript().getWheelCount() > 0) {
                this.physics.updateTrailer();
            } else if (this.getDriver() == null && !GameServer.bServer) {
                this.physics.checkShouldBeActive();
            }
            this.doAlarm();
            VehicleImpulse vehicleImpulse = this.impulseFromServer;
            if (!GameServer.bServer && vehicleImpulse != null && vehicleImpulse.enable) {
                vehicleImpulse.enable = false;
                f = 1.0f;
                Bullet.applyCentralForceToVehicle(this.VehicleID, vehicleImpulse.impulse.x * f, vehicleImpulse.impulse.y * f, vehicleImpulse.impulse.z * f);
                Vector3f vector3f = vehicleImpulse.rel_pos.cross((Vector3fc)vehicleImpulse.impulse, (Vector3f)TL_vector3f_pool.get().alloc());
                Bullet.applyTorqueToVehicle(this.VehicleID, vector3f.x * f, vector3f.y * f, vector3f.z * f);
                TL_vector3f_pool.get().release(vector3f);
            }
            this.applyImpulseFromHitZombies();
            this.applyImpulseFromProneCharacters();
            int n7 = 1000;
            if (System.currentTimeMillis() - this.engineCheckTime > (long)n7 && !GameClient.bClient) {
                VehiclePart vehiclePart4;
                this.engineCheckTime = System.currentTimeMillis();
                if (!GameClient.bClient) {
                    if (this.engineState != engineStateTypes.Idle) {
                        int n8 = (int)((double)this.engineLoudness * this.engineSpeed / 2500.0);
                        double d = Math.min(this.getEngineSpeed(), 2000.0);
                        n8 = (int)((double)n8 * (1.0 + d / 4000.0));
                        n6 = 120;
                        if (GameServer.bServer) {
                            n6 = (int)((double)n6 * ServerOptions.getInstance().CarEngineAttractionModifier.getValue());
                            n8 = (int)((double)n8 * ServerOptions.getInstance().CarEngineAttractionModifier.getValue());
                        }
                        if (Rand.Next((int)((float)n6 * GameTime.instance.getInvMultiplier())) == 0) {
                            WorldSoundManager.instance.addSoundRepeating(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), Math.max(8, n8), n8 / 40, false);
                        }
                        if (Rand.Next((int)((float)(n6 - 85) * GameTime.instance.getInvMultiplier())) == 0) {
                            WorldSoundManager.instance.addSoundRepeating(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), Math.max(8, n8 / 2), n8 / 40, false);
                        }
                        if (Rand.Next((int)((float)(n6 - 110) * GameTime.instance.getInvMultiplier())) == 0) {
                            WorldSoundManager.instance.addSoundRepeating(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), Math.max(8, n8 / 4), n8 / 40, false);
                        }
                        WorldSoundManager.instance.addSoundRepeating(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), Math.max(8, n8 / 6), n8 / 40, false);
                    }
                    if (this.lightbarSirenMode.isEnable() && this.getBatteryCharge() > 0.0f) {
                        WorldSoundManager.instance.addSoundRepeating(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), 100, 60, false);
                    }
                }
                if (this.engineState == engineStateTypes.Running && !this.isEngineWorking()) {
                    this.shutOff();
                }
                if (this.engineState == engineStateTypes.Running && (vehiclePart4 = this.getPartById("Engine")) != null && vehiclePart4.getCondition() < 50 && Rand.Next(Rand.AdjustForFramerate(vehiclePart4.getCondition() * 12)) == 0) {
                    this.shutOff();
                }
                if (this.engineState == engineStateTypes.Starting) {
                    this.updateEngineStarting();
                }
                if (this.engineState == engineStateTypes.RetryingStarting && System.currentTimeMillis() - this.engineLastUpdateStateTime > 10L) {
                    this.engineDoStarting();
                }
                if (this.engineState == engineStateTypes.StartingSuccess && System.currentTimeMillis() - this.engineLastUpdateStateTime > 500L) {
                    this.engineDoRunning();
                }
                if (this.engineState == engineStateTypes.StartingFailed && System.currentTimeMillis() - this.engineLastUpdateStateTime > 500L) {
                    this.engineDoIdle();
                }
                if (this.engineState == engineStateTypes.StartingFailedNoPower && System.currentTimeMillis() - this.engineLastUpdateStateTime > 500L) {
                    this.engineDoIdle();
                }
                if (this.engineState == engineStateTypes.Stalling && System.currentTimeMillis() - this.engineLastUpdateStateTime > 3000L) {
                    this.engineDoIdle();
                }
                if (this.engineState == engineStateTypes.ShutingDown && System.currentTimeMillis() - this.engineLastUpdateStateTime > 2000L) {
                    this.engineDoIdle();
                }
            }
            if (this.getDriver() == null && !bl) {
                this.getController().park();
            }
            this.setX(this.jniTransform.origin.x + WorldSimulation.instance.offsetX);
            this.setY(this.jniTransform.origin.z + WorldSimulation.instance.offsetY);
            this.setZ(0.0f);
            IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x, this.y, this.z);
            if (isoGridSquare == null && !this.chunk.refs.isEmpty()) {
                float f3 = 5.0E-4f;
                int n9 = this.chunk.wx * 10;
                n6 = this.chunk.wy * 10;
                int n10 = n9 + 10;
                int n11 = n6 + 10;
                float f4 = this.x;
                float f5 = this.y;
                this.x = Math.max(this.x, (float)n9 + f3);
                this.x = Math.min(this.x, (float)n10 - f3);
                this.y = Math.max(this.y, (float)n6 + f3);
                this.y = Math.min(this.y, (float)n11 - f3);
                this.z = 0.2f;
                Transform transform = this.tempTransform;
                Transform transform2 = this.tempTransform2;
                this.getWorldTransform(transform);
                transform2.basis.set((Matrix3fc)transform.basis);
                transform2.origin.set(this.x - WorldSimulation.instance.offsetX, this.z, this.y - WorldSimulation.instance.offsetY);
                this.setWorldTransform(transform2);
                this.current = this.getCell().getGridSquare(this.x, this.y, this.z);
                DebugLog.Vehicle.debugln("Vehicle vid=%d is moved into an unloaded area (%f;%f)", this.VehicleID, Float.valueOf(this.x), Float.valueOf(this.y));
            }
            if (this.current == null || this.current.chunk == null) {
                boolean bl5 = false;
            } else if (this.current.getChunk() != this.chunk) {
                assert (this.chunk.vehicles.contains(this));
                this.chunk.vehicles.remove(this);
                this.chunk = this.current.getChunk();
                if (!GameServer.bServer && this.chunk.refs.isEmpty()) {
                    DebugLog.Vehicle.debugln("BaseVehicle.update() added to unloaded chunk id=%d", this.VehicleID);
                }
                assert (!this.chunk.vehicles.contains(this));
                this.chunk.vehicles.add(this);
                IsoChunk.addFromCheckedVehicles(this);
            }
            this.updateTransform();
            object = BaseVehicle.allocVector3f().set((Vector3fc)this.jniLinearVelocity);
            if (this.jniIsCollide && this.limitCrash.Check()) {
                this.jniIsCollide = false;
                this.limitCrash.Reset();
                Vector3f vector3f = BaseVehicle.allocVector3f();
                vector3f.set((Vector3fc)object).sub((Vector3fc)this.lastLinearVelocity);
                vector3f.y = 0.0f;
                float f6 = vector3f.length();
                DebugLog.Vehicle.debugln("Vehicle vid=%d velocity last=%s/%f current=%s/%f delta=%f", this.VehicleID, this.lastLinearVelocity, Float.valueOf(this.lastLinearVelocity.length()), object, Float.valueOf(object.length()), Float.valueOf(f6));
                if (object.lengthSquared() > this.lastLinearVelocity.lengthSquared() && f6 > 6.0f) {
                    DebugLog.Vehicle.trace("Vehicle vid=%d got sharp speed increase delta=%f", this.VehicleID, Float.valueOf(f6));
                    f6 = 6.0f;
                }
                if (f6 > 1.0f) {
                    if (this.lastLinearVelocity.length() < 6.0f) {
                        f6 /= 3.0f;
                    }
                    DebugLog.Vehicle.trace("Vehicle vid=%d crash delta=%f", this.VehicleID, Float.valueOf(f6));
                    Vector3f vector3f2 = this.getForwardVector(BaseVehicle.allocVector3f());
                    float f7 = vector3f.dot((Vector3fc)vector3f2);
                    BaseVehicle.releaseVector3f(vector3f2);
                    this.crash(f6 * 3.0f, f7 < 0.0f);
                    this.damageObjects(f6 * 30.0f);
                }
                BaseVehicle.releaseVector3f(vector3f);
            }
            this.lastLinearVelocity.set((Vector3fc)object);
            BaseVehicle.releaseVector3f((Vector3f)object);
        }
        if (this.soundHornOn && this.hornemitter != null) {
            this.hornemitter.setPos(this.getX(), this.getY(), this.getZ());
        }
        for (n = 0; n < this.impulseFromSquishedZombie.length; ++n) {
            VehicleImpulse vehicleImpulse = this.impulseFromSquishedZombie[n];
            if (vehicleImpulse == null) continue;
            vehicleImpulse.enable = false;
        }
        this.updateSounds();
        this.brekingObjects();
        if (this.bAddThumpWorldSound) {
            this.bAddThumpWorldSound = false;
            WorldSoundManager.instance.addSound(this, (int)this.x, (int)this.y, (int)this.z, 20, 20, true);
        }
        if (this.script.getLightbar().enable && this.lightbarLightsMode.isEnable() && this.getBatteryCharge() > 0.0f) {
            this.lightbarLightsMode.update();
        }
        this.updateWorldLights();
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            IsoPlayer isoPlayer;
            if (this.current == null || !this.current.lighting[n].bCanSee()) {
                this.setTargetAlpha(n, 0.0f);
            }
            if ((isoPlayer = IsoPlayer.players[n]) == null || !(this.DistToSquared(isoPlayer) < 225.0f)) continue;
            this.setTargetAlpha(n, 1.0f);
        }
        for (n = 0; n < this.getScript().getPassengerCount(); ++n) {
            if (this.getCharacter(n) == null) continue;
            Vector3f vector3f = this.getPassengerWorldPos(n, (Vector3f)TL_vector3f_pool.get().alloc());
            this.getCharacter(n).setX(vector3f.x);
            this.getCharacter(n).setY(vector3f.y);
            this.getCharacter(n).setZ(vector3f.z * 1.0f);
            TL_vector3f_pool.get().release(vector3f);
        }
        VehiclePart vehiclePart5 = this.getPartById("lightbar");
        if (vehiclePart5 != null && this.lightbarLightsMode.isEnable() && vehiclePart5.getCondition() == 0 && !GameClient.bClient) {
            this.setLightbarLightsMode(0);
        }
        if (vehiclePart5 != null && this.lightbarSirenMode.isEnable() && vehiclePart5.getCondition() == 0 && !GameClient.bClient) {
            this.setLightbarSirenMode(0);
        }
        if (this.needPartsUpdate() || this.isMechanicUIOpen()) {
            this.updateParts();
        } else {
            this.drainBatteryUpdateHack();
        }
        if (this.engineState == engineStateTypes.Running || bl) {
            this.updateBulletStats();
        }
        if (this.bDoDamageOverlay) {
            this.bDoDamageOverlay = false;
            this.doDamageOverlay();
        }
        if (GameClient.bClient) {
            this.checkPhysicsValidWithServer();
        }
        if ((vehiclePart = this.getPartById("GasTank")) != null && vehiclePart.getContainerContentAmount() > (float)vehiclePart.getContainerCapacity()) {
            vehiclePart.setContainerContentAmount(vehiclePart.getContainerCapacity());
        }
        n3 = 0;
        for (n2 = 0; n2 < this.getMaxPassengers(); ++n2) {
            Passenger passenger = this.getPassenger(n2);
            if (passenger.character == null) continue;
            n3 = 1;
            break;
        }
        if (n3 != 0) {
            this.m_surroundVehicle.update();
        }
        if (!GameServer.bServer) {
            if (this.physics != null) {
                Bullet.setVehicleMass(this.VehicleID, this.getFudgedMass());
            }
            this.updateVelocityMultiplier();
        }
    }

    private void updateEngineStarting() {
        if (this.getBatteryCharge() <= 0.1f) {
            this.engineDoStartingFailedNoPower();
            return;
        }
        VehiclePart vehiclePart = this.getPartById("GasTank");
        if (vehiclePart != null && vehiclePart.getContainerContentAmount() <= 0.0f) {
            this.engineDoStartingFailed();
            return;
        }
        int n = 0;
        float f = ClimateManager.getInstance().getAirTemperatureForSquare(this.getSquare());
        if (this.engineQuality < 65 && f <= 2.0f) {
            n = Math.min((2 - (int)f) * 2, 30);
        }
        if (!SandboxOptions.instance.VehicleEasyUse.getValue() && this.engineQuality < 100 && Rand.Next(this.engineQuality + 50 - n) <= 30) {
            this.engineDoStartingFailed();
            return;
        }
        if (Rand.Next(this.engineQuality) != 0) {
            this.engineDoStartingSuccess();
        } else {
            this.engineDoRetryingStarting();
        }
    }

    private void applyImpulseFromHitZombies() {
        if (this.impulseFromHitZombie.isEmpty()) {
            return;
        }
        if (GameClient.bClient && !this.hasAuthorization(GameClient.connection) || GameServer.bServer) {
            int n = this.impulseFromHitZombie.size();
            for (int i = 0; i < n; ++i) {
                VehicleImpulse vehicleImpulse = this.impulseFromHitZombie.get(i);
                vehicleImpulse.release();
                vehicleImpulse.enable = false;
            }
            this.impulseFromHitZombie.clear();
            return;
        }
        Vector3f vector3f = ((Vector3f)TL_vector3f_pool.get().alloc()).set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = ((Vector3f)TL_vector3f_pool.get().alloc()).set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = ((Vector3f)TL_vector3f_pool.get().alloc()).set(0.0f, 0.0f, 0.0f);
        int n = this.impulseFromHitZombie.size();
        for (int i = 0; i < n; ++i) {
            VehicleImpulse vehicleImpulse = this.impulseFromHitZombie.get(i);
            vector3f.add((Vector3fc)vehicleImpulse.impulse);
            vector3f2.add((Vector3fc)vehicleImpulse.rel_pos.cross((Vector3fc)vehicleImpulse.impulse, vector3f3));
            vehicleImpulse.release();
            vehicleImpulse.enable = false;
        }
        this.impulseFromHitZombie.clear();
        float f = 7.0f * this.getFudgedMass();
        if (vector3f.lengthSquared() > f * f) {
            vector3f.mul(f / vector3f.length());
        }
        float f2 = 30.0f;
        Bullet.applyCentralForceToVehicle(this.VehicleID, vector3f.x * f2, vector3f.y * f2, vector3f.z * f2);
        Bullet.applyTorqueToVehicle(this.VehicleID, vector3f2.x * f2, vector3f2.y * f2, vector3f2.z * f2);
        if (GameServer.bServer) {
            // empty if block
        }
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector3f2);
        TL_vector3f_pool.get().release(vector3f3);
    }

    private void applyImpulseFromProneCharacters() {
        if (GameClient.bClient && !this.hasAuthorization(GameClient.connection) || GameServer.bServer) {
            return;
        }
        boolean bl = PZArrayUtil.contains(this.impulseFromSquishedZombie, vehicleImpulse -> vehicleImpulse != null && vehicleImpulse.enable);
        if (!bl) {
            return;
        }
        Vector3f vector3f = ((Vector3f)TL_vector3f_pool.get().alloc()).set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = ((Vector3f)TL_vector3f_pool.get().alloc()).set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        for (int i = 0; i < this.impulseFromSquishedZombie.length; ++i) {
            VehicleImpulse vehicleImpulse2 = this.impulseFromSquishedZombie[i];
            if (vehicleImpulse2 == null || !vehicleImpulse2.enable) continue;
            vector3f.add((Vector3fc)vehicleImpulse2.impulse);
            vector3f2.add((Vector3fc)vehicleImpulse2.rel_pos.cross((Vector3fc)vehicleImpulse2.impulse, vector3f3));
            vehicleImpulse2.enable = false;
        }
        if (vector3f.lengthSquared() > 0.0f) {
            float f = this.getFudgedMass() * 0.15f;
            if (vector3f.lengthSquared() > f * f) {
                vector3f.mul(f / vector3f.length());
            }
            float f2 = 30.0f;
            Bullet.applyCentralForceToVehicle(this.VehicleID, vector3f.x * f2, vector3f.y * f2, vector3f.z * f2);
            Bullet.applyTorqueToVehicle(this.VehicleID, vector3f2.x * f2, vector3f2.y * f2, vector3f2.z * f2);
        }
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector3f2);
        TL_vector3f_pool.get().release(vector3f3);
    }

    public float getFudgedMass() {
        if (this.getScriptName().contains("Trailer")) {
            return this.getMass();
        }
        BaseVehicle baseVehicle = this.getVehicleTowedBy();
        if (baseVehicle != null && baseVehicle.getDriver() != null && baseVehicle.isEngineRunning()) {
            float f = Math.max(250.0f, baseVehicle.getMass() / 3.7f);
            if (this.getScript().getWheelCount() == 0) {
                f = Math.min(f, 200.0f);
            }
            return f;
        }
        return this.getMass();
    }

    private boolean isNullChunk(int n, int n2) {
        if (!IsoWorld.instance.getMetaGrid().isValidChunk(n, n2)) {
            return false;
        }
        if (GameClient.bClient && !ClientServerMap.isChunkLoaded(n, n2)) {
            return true;
        }
        if (GameClient.bClient && !PassengerMap.isChunkLoaded(this, n, n2)) {
            return true;
        }
        return this.getCell().getChunk(n, n2) == null;
    }

    public boolean isInvalidChunkAround() {
        Vector3f vector3f = this.getLinearVelocity((Vector3f)TL_vector3f_pool.get().alloc());
        float f = Math.abs(vector3f.x);
        float f2 = Math.abs(vector3f.z);
        boolean bl = vector3f.x < 0.0f && f > f2;
        boolean bl2 = vector3f.x > 0.0f && f > f2;
        boolean bl3 = vector3f.z < 0.0f && f2 > f;
        boolean bl4 = vector3f.z > 0.0f && f2 > f;
        TL_vector3f_pool.get().release(vector3f);
        return this.isInvalidChunkAround(bl, bl2, bl3, bl4);
    }

    public boolean isInvalidChunkAhead() {
        Vector3f vector3f = this.getForwardVector((Vector3f)TL_vector3f_pool.get().alloc());
        boolean bl = vector3f.x < -0.5f;
        boolean bl2 = vector3f.z > 0.5f;
        boolean bl3 = vector3f.x > 0.5f;
        boolean bl4 = vector3f.z < -0.5f;
        return this.isInvalidChunkAround(bl, bl3, bl4, bl2);
    }

    public boolean isInvalidChunkBehind() {
        Vector3f vector3f = this.getForwardVector((Vector3f)TL_vector3f_pool.get().alloc());
        boolean bl = vector3f.x < -0.5f;
        boolean bl2 = vector3f.z > 0.5f;
        boolean bl3 = vector3f.x > 0.5f;
        boolean bl4 = vector3f.z < -0.5f;
        return this.isInvalidChunkAround(bl3, bl, bl2, bl4);
    }

    public boolean isInvalidChunkAround(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (IsoChunkMap.ChunkGridWidth > 7) {
            if (bl2 && (this.isNullChunk(this.chunk.wx + 1, this.chunk.wy) || this.isNullChunk(this.chunk.wx + 2, this.chunk.wy))) {
                return true;
            }
            if (bl && (this.isNullChunk(this.chunk.wx - 1, this.chunk.wy) || this.isNullChunk(this.chunk.wx - 2, this.chunk.wy))) {
                return true;
            }
            if (bl4 && (this.isNullChunk(this.chunk.wx, this.chunk.wy + 1) || this.isNullChunk(this.chunk.wx, this.chunk.wy + 2))) {
                return true;
            }
            if (bl3 && (this.isNullChunk(this.chunk.wx, this.chunk.wy - 1) || this.isNullChunk(this.chunk.wx, this.chunk.wy - 2))) {
                return true;
            }
        } else if (IsoChunkMap.ChunkGridWidth > 4) {
            if (bl2 && this.isNullChunk(this.chunk.wx + 1, this.chunk.wy)) {
                return true;
            }
            if (bl && this.isNullChunk(this.chunk.wx - 1, this.chunk.wy)) {
                return true;
            }
            if (bl4 && this.isNullChunk(this.chunk.wx, this.chunk.wy + 1)) {
                return true;
            }
            if (bl3 && this.isNullChunk(this.chunk.wx, this.chunk.wy - 1)) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    @Override
    public void postupdate() {
        int n;
        this.current = this.getCell().getGridSquare((int)this.x, (int)this.y, 0);
        if (this.current == null) {
            for (n = (int)this.z; n >= 0; --n) {
                this.current = this.getCell().getGridSquare((int)this.x, (int)this.y, n);
                if (this.current != null) break;
            }
        }
        if (this.movingSq != null) {
            this.movingSq.getMovingObjects().remove(this);
            this.movingSq = null;
        }
        if (this.current != null && !this.current.getMovingObjects().contains(this)) {
            this.current.getMovingObjects().add(this);
            this.movingSq = this.current;
        }
        this.square = this.current;
        if (this.sprite.hasActiveModel()) {
            this.updateAnimationPlayer(this.getAnimationPlayer(), null);
            for (n = 0; n < this.models.size(); ++n) {
                ModelInfo modelInfo = this.models.get(n);
                this.updateAnimationPlayer(modelInfo.getAnimationPlayer(), modelInfo.part);
            }
        }
    }

    protected void updateAnimationPlayer(AnimationPlayer animationPlayer, VehiclePart vehiclePart) {
        VehicleWindow vehicleWindow;
        Object object;
        if (animationPlayer == null || !animationPlayer.isReady()) {
            return;
        }
        AnimationMultiTrack animationMultiTrack = animationPlayer.getMultiTrack();
        float f = 0.016666668f;
        f *= 0.8f;
        animationPlayer.Update(f *= GameTime.instance.getUnmoddedMultiplier());
        for (int i = 0; i < animationMultiTrack.getTrackCount(); ++i) {
            object = animationMultiTrack.getTracks().get(i);
            if (!((AnimationTrack)object).IsPlaying || !((AnimationTrack)object).isFinished()) continue;
            animationMultiTrack.removeTrackAt(i);
            --i;
        }
        if (vehiclePart == null) {
            return;
        }
        ModelInfo modelInfo = this.getModelInfoForPart(vehiclePart);
        if (modelInfo.m_track != null && animationMultiTrack.getIndexOfTrack(modelInfo.m_track) == -1) {
            modelInfo.m_track = null;
        }
        if (modelInfo.m_track != null) {
            object = vehiclePart.getWindow();
            if (object != null) {
                AnimationTrack animationTrack = modelInfo.m_track;
                animationTrack.setCurrentTimeValue(animationTrack.getDuration() * ((VehicleWindow)object).getOpenDelta());
            }
            return;
        }
        object = vehiclePart.getDoor();
        if (object != null) {
            this.playPartAnim(vehiclePart, ((VehicleDoor)object).isOpen() ? "Opened" : "Closed");
        }
        if ((vehicleWindow = vehiclePart.getWindow()) != null) {
            this.playPartAnim(vehiclePart, "ClosedToOpen");
        }
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        super.saveChange(string, kahluaTable, byteBuffer);
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        super.loadChange(string, byteBuffer);
    }

    public void authorizationClientCollide(IsoPlayer isoPlayer) {
        if (isoPlayer != null && this.getDriver() == null) {
            this.setNetPlayerAuthorization(Authorization.LocalCollide, isoPlayer.getOnlineID());
            this.authSimulationTime = System.currentTimeMillis();
            this.interpolation.clear();
            if (this.getVehicleTowing() != null) {
                this.getVehicleTowing().setNetPlayerAuthorization(Authorization.LocalCollide, isoPlayer.getOnlineID());
                this.getVehicleTowing().authSimulationTime = System.currentTimeMillis();
                this.getVehicleTowing().interpolation.clear();
            } else if (this.getVehicleTowedBy() != null) {
                this.getVehicleTowedBy().setNetPlayerAuthorization(Authorization.LocalCollide, isoPlayer.getOnlineID());
                this.getVehicleTowedBy().authSimulationTime = System.currentTimeMillis();
                this.getVehicleTowedBy().interpolation.clear();
            }
        }
    }

    public void authorizationServerCollide(short s, boolean bl) {
        if (this.isNetPlayerAuthorization(Authorization.Local)) {
            return;
        }
        if (bl) {
            this.setNetPlayerAuthorization(Authorization.LocalCollide, s);
            if (this.getVehicleTowing() != null) {
                this.getVehicleTowing().setNetPlayerAuthorization(Authorization.LocalCollide, s);
            } else if (this.getVehicleTowedBy() != null) {
                this.getVehicleTowedBy().setNetPlayerAuthorization(Authorization.LocalCollide, s);
            }
        } else {
            Authorization authorization = s == -1 ? Authorization.Server : Authorization.Local;
            this.setNetPlayerAuthorization(authorization, s);
            if (this.getVehicleTowing() != null) {
                this.getVehicleTowing().setNetPlayerAuthorization(authorization, s);
            } else if (this.getVehicleTowedBy() != null) {
                this.getVehicleTowedBy().setNetPlayerAuthorization(authorization, s);
            }
        }
    }

    public void authorizationServerOnSeat(IsoPlayer isoPlayer, boolean bl) {
        BaseVehicle baseVehicle = this.getVehicleTowing();
        BaseVehicle baseVehicle2 = this.getVehicleTowedBy();
        if (this.isNetPlayerId((short)-1) && bl) {
            if (baseVehicle != null && baseVehicle.getDriver() == null) {
                this.addPointConstraint(null, baseVehicle, this.getTowAttachmentSelf(), baseVehicle.getTowAttachmentSelf());
            } else if (baseVehicle2 != null && baseVehicle2.getDriver() == null) {
                this.addPointConstraint(null, baseVehicle2, this.getTowAttachmentSelf(), baseVehicle2.getTowAttachmentSelf());
            } else {
                this.setNetPlayerAuthorization(Authorization.Local, isoPlayer.getOnlineID());
            }
        } else if (this.isNetPlayerId(isoPlayer.getOnlineID()) && !bl) {
            if (baseVehicle != null && baseVehicle.getDriver() != null) {
                baseVehicle.addPointConstraint(null, this, baseVehicle.getTowAttachmentSelf(), this.getTowAttachmentSelf());
            } else if (baseVehicle2 != null && baseVehicle2.getDriver() != null) {
                baseVehicle2.addPointConstraint(null, this, baseVehicle2.getTowAttachmentSelf(), this.getTowAttachmentSelf());
            } else {
                this.setNetPlayerAuthorization(Authorization.Server, -1);
                if (baseVehicle != null) {
                    baseVehicle.setNetPlayerAuthorization(Authorization.Server, -1);
                } else if (baseVehicle2 != null) {
                    baseVehicle2.setNetPlayerAuthorization(Authorization.Server, -1);
                }
            }
        }
    }

    public boolean hasAuthorization(UdpConnection udpConnection) {
        if (this.isNetPlayerId((short)-1) || udpConnection == null) {
            return false;
        }
        if (GameServer.bServer) {
            for (int i = 0; i < udpConnection.players.length; ++i) {
                if (udpConnection.players[i] == null || !this.isNetPlayerId(udpConnection.players[i].OnlineID)) continue;
                return true;
            }
            return false;
        }
        return this.isNetPlayerId(IsoPlayer.getInstance().getOnlineID());
    }

    public void netPlayerServerSendAuthorisation(ByteBuffer byteBuffer) {
        byteBuffer.put(this.netPlayerAuthorization.index());
        byteBuffer.putShort(this.netPlayerId);
    }

    public void netPlayerFromServerUpdate(Authorization authorization, short s) {
        if (this.isNetPlayerAuthorization(authorization) && this.isNetPlayerId(s)) {
            return;
        }
        if (Authorization.Local.equals((Object)authorization)) {
            if (IsoPlayer.getLocalPlayerByOnlineID(s) != null) {
                this.setNetPlayerAuthorization(Authorization.Local, s);
            } else {
                this.setNetPlayerAuthorization(Authorization.Remote, s);
            }
        } else if (Authorization.LocalCollide.equals((Object)authorization)) {
            if (IsoPlayer.getLocalPlayerByOnlineID(s) != null) {
                this.setNetPlayerAuthorization(Authorization.LocalCollide, s);
            } else {
                this.setNetPlayerAuthorization(Authorization.RemoteCollide, s);
            }
        } else {
            this.setNetPlayerAuthorization(Authorization.Server, -1);
        }
    }

    public Transform getWorldTransform(Transform transform) {
        transform.set(this.jniTransform);
        return transform;
    }

    public void setWorldTransform(Transform transform) {
        this.jniTransform.set(transform);
        Quaternionf quaternionf = this.tempQuat4f;
        transform.getRotation(quaternionf);
        if (!GameServer.bServer) {
            Bullet.teleportVehicle(this.VehicleID, transform.origin.x + WorldSimulation.instance.offsetX, transform.origin.z + WorldSimulation.instance.offsetY, transform.origin.y, quaternionf.x, quaternionf.y, quaternionf.z, quaternionf.w);
        }
    }

    public void flipUpright() {
        Transform transform = this.tempTransform;
        transform.set(this.jniTransform);
        Quaternionf quaternionf = this.tempQuat4f;
        quaternionf.setAngleAxis(0.0f, BaseVehicle._UNIT_Y.x, BaseVehicle._UNIT_Y.y, BaseVehicle._UNIT_Y.z);
        transform.setRotation(quaternionf);
        this.setWorldTransform(transform);
    }

    public void setAngles(float f, float f2, float f3) {
        if ((int)f == (int)this.getAngleX() && (int)f2 == (int)this.getAngleY() && f3 == (float)((int)this.getAngleZ())) {
            return;
        }
        this.polyDirty = true;
        float f4 = f * ((float)Math.PI / 180);
        float f5 = f2 * ((float)Math.PI / 180);
        float f6 = f3 * ((float)Math.PI / 180);
        this.tempQuat4f.rotationXYZ(f4, f5, f6);
        this.tempTransform.set(this.jniTransform);
        this.tempTransform.setRotation(this.tempQuat4f);
        this.setWorldTransform(this.tempTransform);
    }

    public float getAngleX() {
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.jniTransform.getRotation(this.tempQuat4f).getEulerAnglesXYZ(vector3f);
        float f = vector3f.x * 57.295776f;
        TL_vector3f_pool.get().release(vector3f);
        return f;
    }

    public float getAngleY() {
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.jniTransform.getRotation(this.tempQuat4f).getEulerAnglesXYZ(vector3f);
        float f = vector3f.y * 57.295776f;
        TL_vector3f_pool.get().release(vector3f);
        return f;
    }

    public float getAngleZ() {
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.jniTransform.getRotation(this.tempQuat4f).getEulerAnglesXYZ(vector3f);
        float f = vector3f.z * 57.295776f;
        TL_vector3f_pool.get().release(vector3f);
        return f;
    }

    public void setDebugZ(float f) {
        this.tempTransform.set(this.jniTransform);
        this.tempTransform.origin.y = PZMath.clamp(f, 0.0f, 1.0f) * 3.0f * 0.82f;
        this.setWorldTransform(this.tempTransform);
    }

    public void setPhysicsActive(boolean bl) {
        if (this.physics == null || bl == this.physics.isEnable) {
            return;
        }
        this.physics.isEnable = bl;
        if (!GameServer.bServer) {
            Bullet.setVehicleActive(this.VehicleID, bl);
        }
        if (bl) {
            this.physicActiveCheck = System.currentTimeMillis() + 3000L;
        }
    }

    public float getDebugZ() {
        return this.jniTransform.origin.y / 2.46f;
    }

    public PolygonalMap2.VehiclePoly getPoly() {
        if (this.polyDirty) {
            if (this.polyGarageCheck && this.square != null) {
                this.radiusReductionInGarage = this.square.getRoom() != null && this.square.getRoom().RoomDef != null && this.square.getRoom().RoomDef.contains("garagestorage") ? -0.3f : 0.0f;
                this.polyGarageCheck = false;
            }
            this.poly.init(this, 0.0f);
            this.polyPlusRadius.init(this, PLUS_RADIUS + this.radiusReductionInGarage);
            this.polyDirty = false;
            this.polyPlusRadiusMinX = -123.0f;
            this.initShadowPoly();
        }
        return this.poly;
    }

    public PolygonalMap2.VehiclePoly getPolyPlusRadius() {
        if (this.polyDirty) {
            if (this.polyGarageCheck && this.square != null) {
                this.radiusReductionInGarage = this.square.getRoom() != null && this.square.getRoom().RoomDef != null && this.square.getRoom().RoomDef.contains("garagestorage") ? -0.3f : 0.0f;
                this.polyGarageCheck = false;
            }
            this.poly.init(this, 0.0f);
            this.polyPlusRadius.init(this, PLUS_RADIUS + this.radiusReductionInGarage);
            this.polyDirty = false;
            this.polyPlusRadiusMinX = -123.0f;
            this.initShadowPoly();
        }
        return this.polyPlusRadius;
    }

    private void initShadowPoly() {
        this.getWorldTransform(this.tempTransform);
        Quaternionf quaternionf = this.tempTransform.getRotation(this.tempQuat4f);
        Vector2f vector2f = this.script.getShadowExtents();
        Vector2f vector2f2 = this.script.getShadowOffset();
        float f = vector2f.x / 2.0f;
        float f2 = vector2f.y / 2.0f;
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        if (quaternionf.x < 0.0f) {
            this.getWorldPos(vector2f2.x - f, 0.0f, vector2f2.y + f2, vector3f);
            this.shadowCoord.x1 = vector3f.x;
            this.shadowCoord.y1 = vector3f.y;
            this.getWorldPos(vector2f2.x + f, 0.0f, vector2f2.y + f2, vector3f);
            this.shadowCoord.x2 = vector3f.x;
            this.shadowCoord.y2 = vector3f.y;
            this.getWorldPos(vector2f2.x + f, 0.0f, vector2f2.y - f2, vector3f);
            this.shadowCoord.x3 = vector3f.x;
            this.shadowCoord.y3 = vector3f.y;
            this.getWorldPos(vector2f2.x - f, 0.0f, vector2f2.y - f2, vector3f);
            this.shadowCoord.x4 = vector3f.x;
            this.shadowCoord.y4 = vector3f.y;
        } else {
            this.getWorldPos(vector2f2.x - f, 0.0f, vector2f2.y + f2, vector3f);
            this.shadowCoord.x1 = vector3f.x;
            this.shadowCoord.y1 = vector3f.y;
            this.getWorldPos(vector2f2.x + f, 0.0f, vector2f2.y + f2, vector3f);
            this.shadowCoord.x2 = vector3f.x;
            this.shadowCoord.y2 = vector3f.y;
            this.getWorldPos(vector2f2.x + f, 0.0f, vector2f2.y - f2, vector3f);
            this.shadowCoord.x3 = vector3f.x;
            this.shadowCoord.y3 = vector3f.y;
            this.getWorldPos(vector2f2.x - f, 0.0f, vector2f2.y - f2, vector3f);
            this.shadowCoord.x4 = vector3f.x;
            this.shadowCoord.y4 = vector3f.y;
        }
        TL_vector3f_pool.get().release(vector3f);
    }

    private void initPolyPlusRadiusBounds() {
        if (this.polyPlusRadiusMinX != -123.0f) {
            return;
        }
        PolygonalMap2.VehiclePoly vehiclePoly = this.getPolyPlusRadius();
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector3f vector3f2 = this.getLocalPos(vehiclePoly.x1, vehiclePoly.y1, vehiclePoly.z, vector3f);
        float f = (float)((int)(vector3f2.x * 100.0f)) / 100.0f;
        float f2 = (float)((int)(vector3f2.z * 100.0f)) / 100.0f;
        vector3f2 = this.getLocalPos(vehiclePoly.x2, vehiclePoly.y2, vehiclePoly.z, vector3f);
        float f3 = (float)((int)(vector3f2.x * 100.0f)) / 100.0f;
        float f4 = (float)((int)(vector3f2.z * 100.0f)) / 100.0f;
        vector3f2 = this.getLocalPos(vehiclePoly.x3, vehiclePoly.y3, vehiclePoly.z, vector3f);
        float f5 = (float)((int)(vector3f2.x * 100.0f)) / 100.0f;
        float f6 = (float)((int)(vector3f2.z * 100.0f)) / 100.0f;
        vector3f2 = this.getLocalPos(vehiclePoly.x4, vehiclePoly.y4, vehiclePoly.z, vector3f);
        float f7 = (float)((int)(vector3f2.x * 100.0f)) / 100.0f;
        float f8 = (float)((int)(vector3f2.z * 100.0f)) / 100.0f;
        this.polyPlusRadiusMinX = Math.min(f, Math.min(f3, Math.min(f5, f7)));
        this.polyPlusRadiusMaxX = Math.max(f, Math.max(f3, Math.max(f5, f7)));
        this.polyPlusRadiusMinY = Math.min(f2, Math.min(f4, Math.min(f6, f8)));
        this.polyPlusRadiusMaxY = Math.max(f2, Math.max(f4, Math.max(f6, f8)));
        TL_vector3f_pool.get().release(vector3f);
    }

    public Vector3f getForwardVector(Vector3f vector3f) {
        int n = 2;
        return this.jniTransform.basis.getColumn(n, vector3f);
    }

    public Vector3f getUpVector(Vector3f vector3f) {
        int n = 1;
        return this.jniTransform.basis.getColumn(n, vector3f);
    }

    public float getUpVectorDot() {
        Vector3f vector3f = this.getUpVector((Vector3f)TL_vector3f_pool.get().alloc());
        float f = vector3f.dot((Vector3fc)_UNIT_Y);
        TL_vector3f_pool.get().release(vector3f);
        return f;
    }

    public boolean isStopped() {
        return this.jniSpeed > -0.8f && this.jniSpeed < 0.8f && !this.getController().isGasPedalPressed();
    }

    public float getCurrentSpeedKmHour() {
        return this.jniSpeed;
    }

    public Vector3f getLinearVelocity(Vector3f vector3f) {
        return vector3f.set((Vector3fc)this.jniLinearVelocity);
    }

    public float getSpeed2D() {
        float f = this.jniLinearVelocity.x;
        float f2 = this.jniLinearVelocity.z;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public boolean isAtRest() {
        if (this.physics == null) {
            return true;
        }
        float f = this.jniLinearVelocity.y;
        return Math.abs(this.physics.EngineForce) < 0.01f && this.getSpeed2D() < 0.02f && Math.abs(f) < 0.5f;
    }

    protected void updateTransform() {
        if (this.sprite.modelSlot == null) {
            return;
        }
        float f = this.getScript().getModelScale();
        float f2 = 1.0f;
        if (this.sprite.modelSlot != null && this.sprite.modelSlot.model.scale != 1.0f) {
            f2 = this.sprite.modelSlot.model.scale;
        }
        Transform transform = this.getWorldTransform(this.tempTransform);
        Quaternionf quaternionf = (Quaternionf)TL_quaternionf_pool.get().alloc();
        Quaternionf quaternionf2 = (Quaternionf)TL_quaternionf_pool.get().alloc();
        Matrix4f matrix4f = (Matrix4f)TL_matrix4f_pool.get().alloc();
        transform.getRotation(quaternionf);
        quaternionf.y *= -1.0f;
        quaternionf.z *= -1.0f;
        Matrix4f matrix4f2 = quaternionf.get(matrix4f);
        float f3 = 1.0f;
        if (this.sprite.modelSlot.model.m_modelScript != null) {
            f3 = this.sprite.modelSlot.model.m_modelScript.invertX ? -1.0f : 1.0f;
        }
        Object object = this.script.getModel().getOffset();
        Vector3f vector3f = this.getScript().getModel().getRotate();
        quaternionf2.rotationXYZ(vector3f.x * ((float)Math.PI / 180), vector3f.y * ((float)Math.PI / 180), vector3f.z * ((float)Math.PI / 180));
        this.renderTransform.translationRotateScale(((Vector3f)object).x * -1.0f, ((Vector3f)object).y, ((Vector3f)object).z, quaternionf2.x, quaternionf2.y, quaternionf2.z, quaternionf2.w, f * f2 * f3, f * f2, f * f2);
        matrix4f2.mul((Matrix4fc)this.renderTransform, this.renderTransform);
        this.vehicleTransform.translationRotateScale(((Vector3f)object).x * -1.0f, ((Vector3f)object).y, ((Vector3f)object).z, 0.0f, 0.0f, 0.0f, 1.0f, f);
        matrix4f2.mul((Matrix4fc)this.vehicleTransform, this.vehicleTransform);
        for (int i = 0; i < this.models.size(); ++i) {
            ModelInfo modelInfo = this.models.get(i);
            object = modelInfo.scriptModel;
            vector3f = ((VehicleScript.Model)object).getOffset();
            Vector3f vector3f2 = ((VehicleScript.Model)object).getRotate();
            float f4 = ((VehicleScript.Model)object).scale;
            f2 = 1.0f;
            float f5 = 1.0f;
            if (modelInfo.modelScript != null) {
                f2 = modelInfo.modelScript.scale;
                f5 = modelInfo.modelScript.invertX ? -1.0f : 1.0f;
            }
            quaternionf2.rotationXYZ(vector3f2.x * ((float)Math.PI / 180), vector3f2.y * ((float)Math.PI / 180), vector3f2.z * ((float)Math.PI / 180));
            if (modelInfo.wheelIndex == -1) {
                modelInfo.renderTransform.translationRotateScale(vector3f.x * -1.0f, vector3f.y, vector3f.z, quaternionf2.x, quaternionf2.y, quaternionf2.z, quaternionf2.w, f4 * f2 * f5, f4 * f2, f4 * f2);
                this.vehicleTransform.mul((Matrix4fc)modelInfo.renderTransform, modelInfo.renderTransform);
                continue;
            }
            WheelInfo wheelInfo = this.wheelInfo[modelInfo.wheelIndex];
            float f6 = wheelInfo.steering;
            float f7 = wheelInfo.rotation;
            VehicleScript.Wheel wheel = this.getScript().getWheel(modelInfo.wheelIndex);
            VehicleImpulse vehicleImpulse = modelInfo.wheelIndex < this.impulseFromSquishedZombie.length ? this.impulseFromSquishedZombie[modelInfo.wheelIndex] : null;
            float f8 = vehicleImpulse != null && vehicleImpulse.enable ? 0.05f : 0.0f;
            Matrix4f matrix4f3 = matrix4f;
            if (wheelInfo.suspensionLength == 0.0f) {
                matrix4f3.translation(wheel.offset.x / f * -1.0f, wheel.offset.y / f, wheel.offset.z / f);
            } else {
                matrix4f3.translation(wheel.offset.x / f * -1.0f, (wheel.offset.y + this.script.getSuspensionRestLength() - wheelInfo.suspensionLength) / f + f8 * 0.5f, wheel.offset.z / f);
            }
            modelInfo.renderTransform.identity();
            modelInfo.renderTransform.mul((Matrix4fc)matrix4f3);
            modelInfo.renderTransform.rotateY(f6 * -1.0f);
            modelInfo.renderTransform.rotateX(f7);
            matrix4f.translationRotateScale(vector3f.x * -1.0f, vector3f.y, vector3f.z, quaternionf2.x, quaternionf2.y, quaternionf2.z, quaternionf2.w, f4 * f2 * f5, f4 * f2, f4 * f2);
            modelInfo.renderTransform.mul((Matrix4fc)matrix4f);
            this.vehicleTransform.mul((Matrix4fc)modelInfo.renderTransform, modelInfo.renderTransform);
        }
        TL_matrix4f_pool.get().release(matrix4f);
        TL_quaternionf_pool.get().release(quaternionf);
        TL_quaternionf_pool.get().release(quaternionf2);
    }

    public void updatePhysics() {
        this.physics.update();
    }

    public void updatePhysicsNetwork() {
        if (this.limitPhysicSend.Check()) {
            VehicleManager.instance.sendPhysic(this);
            if (this.limitPhysicPositionSent == null) {
                this.limitPhysicPositionSent = new Vector2();
            } else if (IsoUtils.DistanceToSquared(this.limitPhysicPositionSent.x, this.limitPhysicPositionSent.y, this.x, this.y) > 0.001f) {
                this.limitPhysicSend.setUpdatePeriod(150L);
            } else {
                this.limitPhysicSend.setSmoothUpdatePeriod(300L);
            }
            this.limitPhysicPositionSent.set(this.x, this.y);
        }
    }

    public void checkPhysicsValidWithServer() {
        float f = 0.05f;
        if (this.limitPhysicValid.Check() && Bullet.getOwnVehiclePhysics(this.VehicleID, physicsParams) == 0) {
            float f2 = Math.abs(physicsParams[0] - this.x);
            float f3 = Math.abs(physicsParams[1] - this.y);
            if (f2 > f || f3 > f) {
                VehicleManager.instance.sendRequestGetPosition(this.VehicleID, PacketTypes.PacketType.Vehicles);
                DebugLog.Vehicle.trace("diff-x=%f diff-y=%f delta=%f", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f));
            }
        }
    }

    public void updateControls() {
        if (this.getController() == null) {
            return;
        }
        if (!this.isOperational()) {
            return;
        }
        IsoPlayer isoPlayer = Type.tryCastTo(this.getDriver(), IsoPlayer.class);
        if (isoPlayer != null && isoPlayer.isBlockMovement()) {
            return;
        }
        this.getController().updateControls();
    }

    public boolean isKeyboardControlled() {
        IsoGameCharacter isoGameCharacter = this.getCharacter(0);
        return isoGameCharacter != null && isoGameCharacter == IsoPlayer.players[0] && this.getVehicleTowedBy() == null;
    }

    public int getJoypad() {
        IsoGameCharacter isoGameCharacter = this.getCharacter(0);
        if (isoGameCharacter != null && isoGameCharacter instanceof IsoPlayer) {
            return ((IsoPlayer)isoGameCharacter).JoypadBind;
        }
        return -1;
    }

    @Override
    public void Damage(float f) {
        this.crash(f, true);
    }

    @Override
    public void HitByVehicle(BaseVehicle baseVehicle, float f) {
        this.crash(f, true);
    }

    public void crash(float f, boolean bl) {
        if (GameClient.bClient) {
            SoundManager.instance.PlayWorldSound(this.getCrashSound(f), this.square, 1.0f, 20.0f, 1.0f, true);
            GameClient.instance.sendClientCommandV(null, "vehicle", "crash", "vehicle", this.getId(), "amount", Float.valueOf(f), "front", bl);
            return;
        }
        float f2 = 1.3f;
        float f3 = f;
        switch (SandboxOptions.instance.CarDamageOnImpact.getValue()) {
            case 1: {
                f2 = 1.9f;
                break;
            }
            case 2: {
                f2 = 1.6f;
                break;
            }
            case 4: {
                f2 = 1.1f;
                break;
            }
            case 5: {
                f2 = 0.9f;
            }
        }
        f = Math.abs(f) / f2;
        if (bl) {
            this.addDamageFront((int)f);
        } else {
            this.addDamageRear((int)Math.abs(f / f2));
        }
        this.damagePlayers(Math.abs(f3));
        SoundManager.instance.PlayWorldSound(this.getCrashSound(f3), this.square, 1.0f, 20.0f, 1.0f, true);
    }

    private String getCrashSound(float f) {
        if (f < 5.0f) {
            return "VehicleCrash1";
        }
        if (f < 30.0f) {
            return "VehicleCrash2";
        }
        return "VehicleCrash";
    }

    public void addDamageFrontHitAChr(int n) {
        if (n < 4 && Rand.NextBool(7)) {
            return;
        }
        VehiclePart vehiclePart = this.getPartById("EngineDoor");
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 10), n + 3));
        }
        if (vehiclePart != null && (vehiclePart.getCondition() <= 0 || vehiclePart.getInventoryItem() == null) && Rand.NextBool(4) && (vehiclePart = this.getPartById("Engine")) != null) {
            vehiclePart.damage(Rand.Next(2, 4));
        }
        if (n > 12 && (vehiclePart = this.getPartById("Windshield")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 10), n + 3));
        }
        if (Rand.Next(5) < n && (vehiclePart = Rand.NextBool(2) ? this.getPartById("TireFrontLeft") : this.getPartById("TireFrontRight")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(1, 3));
        }
        if (Rand.Next(7) < n) {
            this.damageHeadlight("HeadlightLeft", Rand.Next(1, 4));
        }
        if (Rand.Next(7) < n) {
            this.damageHeadlight("HeadlightRight", Rand.Next(1, 4));
        }
        float f = this.getBloodIntensity("Front");
        this.setBloodIntensity("Front", f + 0.01f);
    }

    public void addDamageRearHitAChr(int n) {
        if (n < 4 && Rand.NextBool(7)) {
            return;
        }
        VehiclePart vehiclePart = this.getPartById("TruckBed");
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.setCondition(vehiclePart.getCondition() - Rand.Next(Math.max(1, n - 10), n + 3));
            vehiclePart.doInventoryItemStats(vehiclePart.getInventoryItem(), 0);
            this.transmitPartCondition(vehiclePart);
        }
        if ((vehiclePart = this.getPartById("DoorRear")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 10), n + 3));
        }
        if ((vehiclePart = this.getPartById("TrunkDoor")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 10), n + 3));
        }
        if (n > 12 && (vehiclePart = this.getPartById("WindshieldRear")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(n);
        }
        if (Rand.Next(5) < n && (vehiclePart = Rand.NextBool(2) ? this.getPartById("TireRearLeft") : this.getPartById("TireRearRight")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(1, 3));
        }
        if (Rand.Next(7) < n) {
            this.damageHeadlight("HeadlightRearLeft", Rand.Next(1, 4));
        }
        if (Rand.Next(7) < n) {
            this.damageHeadlight("HeadlightRearRight", Rand.Next(1, 4));
        }
        if (Rand.Next(6) < n && (vehiclePart = this.getPartById("GasTank")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(1, 3));
        }
        float f = this.getBloodIntensity("Rear");
        this.setBloodIntensity("Rear", f + 0.01f);
    }

    private void addDamageFront(int n) {
        this.currentFrontEndDurability -= n;
        VehiclePart vehiclePart = this.getPartById("EngineDoor");
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
        }
        if ((vehiclePart == null || vehiclePart.getInventoryItem() == null || vehiclePart.getCondition() < 25) && (vehiclePart = this.getPartById("Engine")) != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 3), n + 3));
        }
        if ((vehiclePart = this.getPartById("Windshield")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
        }
        if (Rand.Next(4) == 0) {
            vehiclePart = this.getPartById("DoorFrontLeft");
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
            if ((vehiclePart = this.getPartById("WindowFrontLeft")) != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
        }
        if (Rand.Next(4) == 0) {
            vehiclePart = this.getPartById("DoorFrontRight");
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
            if ((vehiclePart = this.getPartById("WindowFrontRight")) != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
        }
        if (Rand.Next(20) < n) {
            this.damageHeadlight("HeadlightLeft", n);
        }
        if (Rand.Next(20) < n) {
            this.damageHeadlight("HeadlightRight", n);
        }
    }

    private void addDamageRear(int n) {
        this.currentRearEndDurability -= n;
        VehiclePart vehiclePart = this.getPartById("TruckBed");
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.setCondition(vehiclePart.getCondition() - Rand.Next(Math.max(1, n - 5), n + 5));
            vehiclePart.doInventoryItemStats(vehiclePart.getInventoryItem(), 0);
            this.transmitPartCondition(vehiclePart);
        }
        if ((vehiclePart = this.getPartById("DoorRear")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
        }
        if ((vehiclePart = this.getPartById("TrunkDoor")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
        }
        if ((vehiclePart = this.getPartById("WindshieldRear")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(n);
        }
        if (Rand.Next(4) == 0) {
            vehiclePart = this.getPartById("DoorRearLeft");
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
            if ((vehiclePart = this.getPartById("WindowRearLeft")) != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
        }
        if (Rand.Next(4) == 0) {
            vehiclePart = this.getPartById("DoorRearRight");
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
            if ((vehiclePart = this.getPartById("WindowRearRight")) != null && vehiclePart.getInventoryItem() != null) {
                vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
            }
        }
        if (Rand.Next(20) < n) {
            this.damageHeadlight("HeadlightRearLeft", n);
        }
        if (Rand.Next(20) < n) {
            this.damageHeadlight("HeadlightRearRight", n);
        }
        if (Rand.Next(20) < n && (vehiclePart = this.getPartById("Muffler")) != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(Rand.Next(Math.max(1, n - 5), n + 5));
        }
    }

    private void damageHeadlight(String string, int n) {
        VehiclePart vehiclePart = this.getPartById(string);
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.damage(n);
            if (vehiclePart.getCondition() <= 0) {
                vehiclePart.setInventoryItem(null);
                this.transmitPartItem(vehiclePart);
            }
        }
    }

    private float clamp(float f, float f2, float f3) {
        if (f < f2) {
            f = f2;
        }
        if (f > f3) {
            f = f3;
        }
        return f;
    }

    public boolean isCharacterAdjacentTo(IsoGameCharacter isoGameCharacter) {
        if ((int)isoGameCharacter.z != (int)this.z) {
            return false;
        }
        Transform transform = this.getWorldTransform(this.tempTransform);
        transform.inverse();
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        vector3f.set(isoGameCharacter.x - WorldSimulation.instance.offsetX, 0.0f, isoGameCharacter.y - WorldSimulation.instance.offsetY);
        transform.transform(vector3f);
        Vector3f vector3f2 = this.script.getExtents();
        Vector3f vector3f3 = this.script.getCenterOfMassOffset();
        float f = vector3f3.x - vector3f2.x / 2.0f;
        float f2 = vector3f3.x + vector3f2.x / 2.0f;
        float f3 = vector3f3.z - vector3f2.z / 2.0f;
        float f4 = vector3f3.z + vector3f2.z / 2.0f;
        if (vector3f.x >= f - 0.5f && vector3f.x < f2 + 0.5f && vector3f.z >= f3 - 0.5f && vector3f.z < f4 + 0.5f) {
            TL_vector3f_pool.get().release(vector3f);
            return true;
        }
        TL_vector3f_pool.get().release(vector3f);
        return false;
    }

    public Vector2 testCollisionWithCharacter(IsoGameCharacter isoGameCharacter, float f, Vector2 vector22) {
        if (this.physics == null) {
            return null;
        }
        Vector3f vector3f = this.script.getExtents();
        Vector3f vector3f2 = this.script.getCenterOfMassOffset();
        if (this.DistToProper(isoGameCharacter) > Math.max(vector3f.x / 2.0f, vector3f.z / 2.0f) + f + 1.0f) {
            return null;
        }
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(isoGameCharacter.nx, isoGameCharacter.ny, 0.0f, vector3f3);
        float f2 = vector3f2.x - vector3f.x / 2.0f;
        float f3 = vector3f2.x + vector3f.x / 2.0f;
        float f4 = vector3f2.z - vector3f.z / 2.0f;
        float f5 = vector3f2.z + vector3f.z / 2.0f;
        if (vector3f3.x > f2 && vector3f3.x < f3 && vector3f3.z > f4 && vector3f3.z < f5) {
            float f6 = vector3f3.x - f2;
            float f7 = f3 - vector3f3.x;
            float f8 = vector3f3.z - f4;
            float f9 = f5 - vector3f3.z;
            Vector3f vector3f4 = (Vector3f)TL_vector3f_pool.get().alloc();
            if (f6 < f7 && f6 < f8 && f6 < f9) {
                vector3f4.set(f2 - f - 0.015f, 0.0f, vector3f3.z);
            } else if (f7 < f6 && f7 < f8 && f7 < f9) {
                vector3f4.set(f3 + f + 0.015f, 0.0f, vector3f3.z);
            } else if (f8 < f6 && f8 < f7 && f8 < f9) {
                vector3f4.set(vector3f3.x, 0.0f, f4 - f - 0.015f);
            } else if (f9 < f6 && f9 < f7 && f9 < f8) {
                vector3f4.set(vector3f3.x, 0.0f, f5 + f + 0.015f);
            }
            TL_vector3f_pool.get().release(vector3f3);
            Transform transform = this.getWorldTransform(this.tempTransform);
            transform.origin.set(0.0f, 0.0f, 0.0f);
            transform.transform(vector3f4);
            vector3f4.x += this.getX();
            vector3f4.z += this.getY();
            this.collideX = vector3f4.x;
            this.collideY = vector3f4.z;
            vector22.set(vector3f4.x, vector3f4.z);
            TL_vector3f_pool.get().release(vector3f4);
            return vector22;
        }
        float f10 = this.clamp(vector3f3.x, f2, f3);
        float f11 = this.clamp(vector3f3.z, f4, f5);
        float f12 = vector3f3.x - f10;
        float f13 = vector3f3.z - f11;
        TL_vector3f_pool.get().release(vector3f3);
        float f14 = f12 * f12 + f13 * f13;
        if (f14 < f * f) {
            if (f12 == 0.0f && f13 == 0.0f) {
                return vector22.set(-1.0f, -1.0f);
            }
            Vector3f vector3f5 = (Vector3f)TL_vector3f_pool.get().alloc();
            vector3f5.set(f12, 0.0f, f13);
            vector3f5.normalize();
            vector3f5.mul(f + 0.015f);
            vector3f5.x += f10;
            vector3f5.z += f11;
            Transform transform = this.getWorldTransform(this.tempTransform);
            transform.origin.set(0.0f, 0.0f, 0.0f);
            transform.transform(vector3f5);
            vector3f5.x += this.getX();
            vector3f5.z += this.getY();
            this.collideX = vector3f5.x;
            this.collideY = vector3f5.z;
            vector22.set(vector3f5.x, vector3f5.z);
            TL_vector3f_pool.get().release(vector3f5);
            return vector22;
        }
        return null;
    }

    public int testCollisionWithProneCharacter(IsoGameCharacter isoGameCharacter, boolean bl) {
        Vector2 vector22 = isoGameCharacter.getAnimVector((Vector2)TL_vector2_pool.get().alloc());
        int n = this.testCollisionWithProneCharacter(isoGameCharacter, vector22.x, vector22.y, bl);
        TL_vector2_pool.get().release(vector22);
        return n;
    }

    public int testCollisionWithCorpse(IsoDeadBody isoDeadBody, boolean bl) {
        float f = (float)Math.cos(isoDeadBody.getAngle());
        float f2 = (float)Math.sin(isoDeadBody.getAngle());
        int n = this.testCollisionWithProneCharacter(isoDeadBody, f, f2, bl);
        return n;
    }

    public int testCollisionWithProneCharacter(IsoMovingObject isoMovingObject, float f, float f2, boolean bl) {
        if (this.physics == null) {
            return 0;
        }
        if (GameServer.bServer) {
            return 0;
        }
        Vector3f vector3f = this.script.getExtents();
        float f3 = 0.3f;
        if (this.DistToProper(isoMovingObject) > Math.max(vector3f.x / 2.0f, vector3f.z / 2.0f) + f3 + 1.0f) {
            return 0;
        }
        if (Math.abs(this.jniSpeed) < 3.0f) {
            return 0;
        }
        float f4 = isoMovingObject.x + f * 0.65f;
        float f5 = isoMovingObject.y + f2 * 0.65f;
        float f6 = isoMovingObject.x - f * 0.65f;
        float f7 = isoMovingObject.y - f2 * 0.65f;
        int n = 0;
        Vector3f vector3f2 = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        for (int i = 0; i < this.script.getWheelCount(); ++i) {
            float f8;
            float f9;
            VehicleScript.Wheel wheel = this.script.getWheel(i);
            boolean bl2 = true;
            for (int j = 0; j < this.models.size(); ++j) {
                ModelInfo modelInfo = this.models.get(j);
                if (modelInfo.wheelIndex != i) continue;
                this.getWorldPos(wheel.offset.x, wheel.offset.y - this.wheelInfo[i].suspensionLength, wheel.offset.z, vector3f2);
                if (!(vector3f2.z > this.script.getWheel((int)i).radius + 0.05f)) break;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            this.getWorldPos(wheel.offset.x, wheel.offset.y, wheel.offset.z, vector3f3);
            float f10 = f6;
            float f11 = f7;
            float f12 = f4;
            float f13 = f5;
            float f14 = vector3f3.x;
            float f15 = vector3f3.y;
            double d = (double)((f14 - f10) * (f12 - f10) + (f15 - f11) * (f13 - f11)) / (Math.pow(f12 - f10, 2.0) + Math.pow(f13 - f11, 2.0));
            if (d <= 0.0) {
                f9 = f10;
                f8 = f11;
            } else if (d >= 1.0) {
                f9 = f12;
                f8 = f13;
            } else {
                f9 = f10 + (f12 - f10) * (float)d;
                f8 = f11 + (f13 - f11) * (float)d;
            }
            if (IsoUtils.DistanceToSquared(vector3f3.x, vector3f3.y, f9, f8) > wheel.radius * wheel.radius) continue;
            if (bl && Math.abs(this.jniSpeed) > 10.0f) {
                if (GameServer.bServer && isoMovingObject instanceof IsoZombie) {
                    ((IsoZombie)isoMovingObject).setThumpFlag(1);
                } else {
                    SoundManager.instance.PlayWorldSound("VehicleRunOverBody", isoMovingObject.getCurrentSquare(), 0.0f, 20.0f, 0.9f, true);
                }
                bl = false;
            }
            if (i >= this.impulseFromSquishedZombie.length) continue;
            if (this.impulseFromSquishedZombie[i] == null) {
                this.impulseFromSquishedZombie[i] = new VehicleImpulse();
            }
            this.impulseFromSquishedZombie[i].impulse.set(0.0f, 1.0f, 0.0f);
            float f16 = Math.max(Math.abs(this.jniSpeed), 20.0f) / 20.0f;
            this.impulseFromSquishedZombie[i].impulse.mul(0.065f * this.getFudgedMass() * f16);
            this.impulseFromSquishedZombie[i].rel_pos.set(vector3f3.x - this.x, 0.0f, vector3f3.y - this.y);
            this.impulseFromSquishedZombie[i].enable = true;
            ++n;
        }
        TL_vector3f_pool.get().release(vector3f2);
        TL_vector3f_pool.get().release(vector3f3);
        return n;
    }

    public Vector2 testCollisionWithObject(IsoObject isoObject, float f, Vector2 vector22) {
        if (this.physics == null) {
            return null;
        }
        if (isoObject.square == null) {
            return null;
        }
        float f2 = this.getObjectX(isoObject);
        float f3 = this.getObjectY(isoObject);
        Vector3f vector3f = this.script.getExtents();
        Vector3f vector3f2 = this.script.getCenterOfMassOffset();
        float f4 = Math.max(vector3f.x / 2.0f, vector3f.z / 2.0f) + f + 1.0f;
        if (this.DistToSquared(f2, f3) > f4 * f4) {
            return null;
        }
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(f2, f3, 0.0f, vector3f3);
        float f5 = vector3f2.x - vector3f.x / 2.0f;
        float f6 = vector3f2.x + vector3f.x / 2.0f;
        float f7 = vector3f2.z - vector3f.z / 2.0f;
        float f8 = vector3f2.z + vector3f.z / 2.0f;
        if (vector3f3.x > f5 && vector3f3.x < f6 && vector3f3.z > f7 && vector3f3.z < f8) {
            float f9 = vector3f3.x - f5;
            float f10 = f6 - vector3f3.x;
            float f11 = vector3f3.z - f7;
            float f12 = f8 - vector3f3.z;
            Vector3f vector3f4 = (Vector3f)TL_vector3f_pool.get().alloc();
            if (f9 < f10 && f9 < f11 && f9 < f12) {
                vector3f4.set(f5 - f - 0.015f, 0.0f, vector3f3.z);
            } else if (f10 < f9 && f10 < f11 && f10 < f12) {
                vector3f4.set(f6 + f + 0.015f, 0.0f, vector3f3.z);
            } else if (f11 < f9 && f11 < f10 && f11 < f12) {
                vector3f4.set(vector3f3.x, 0.0f, f7 - f - 0.015f);
            } else if (f12 < f9 && f12 < f10 && f12 < f11) {
                vector3f4.set(vector3f3.x, 0.0f, f8 + f + 0.015f);
            }
            TL_vector3f_pool.get().release(vector3f3);
            Transform transform = this.getWorldTransform(this.tempTransform);
            transform.origin.set(0.0f, 0.0f, 0.0f);
            transform.transform(vector3f4);
            vector3f4.x += this.getX();
            vector3f4.z += this.getY();
            this.collideX = vector3f4.x;
            this.collideY = vector3f4.z;
            vector22.set(vector3f4.x, vector3f4.z);
            TL_vector3f_pool.get().release(vector3f4);
            return vector22;
        }
        float f13 = this.clamp(vector3f3.x, f5, f6);
        float f14 = this.clamp(vector3f3.z, f7, f8);
        float f15 = vector3f3.x - f13;
        float f16 = vector3f3.z - f14;
        TL_vector3f_pool.get().release(vector3f3);
        float f17 = f15 * f15 + f16 * f16;
        if (f17 < f * f) {
            if (f15 == 0.0f && f16 == 0.0f) {
                return vector22.set(-1.0f, -1.0f);
            }
            Vector3f vector3f5 = (Vector3f)TL_vector3f_pool.get().alloc();
            vector3f5.set(f15, 0.0f, f16);
            vector3f5.normalize();
            vector3f5.mul(f + 0.015f);
            vector3f5.x += f13;
            vector3f5.z += f14;
            Transform transform = this.getWorldTransform(this.tempTransform);
            transform.origin.set(0.0f, 0.0f, 0.0f);
            transform.transform(vector3f5);
            vector3f5.x += this.getX();
            vector3f5.z += this.getY();
            this.collideX = vector3f5.x;
            this.collideY = vector3f5.z;
            vector22.set(vector3f5.x, vector3f5.z);
            TL_vector3f_pool.get().release(vector3f5);
            return vector22;
        }
        return null;
    }

    public boolean testCollisionWithVehicle(BaseVehicle baseVehicle) {
        VehicleScript vehicleScript;
        VehicleScript vehicleScript2 = this.script;
        if (vehicleScript2 == null) {
            vehicleScript2 = ScriptManager.instance.getVehicle(this.scriptName);
        }
        if ((vehicleScript = baseVehicle.script) == null) {
            vehicleScript = ScriptManager.instance.getVehicle(baseVehicle.scriptName);
        }
        if (vehicleScript2 == null || vehicleScript == null) {
            return false;
        }
        Vector2[] vector2Array = L_testCollisionWithVehicle.testVecs1;
        Vector2[] vector2Array2 = L_testCollisionWithVehicle.testVecs2;
        if (vector2Array[0] == null) {
            for (int i = 0; i < vector2Array.length; ++i) {
                vector2Array[i] = new Vector2();
                vector2Array2[i] = new Vector2();
            }
        }
        Vector3f vector3f = vehicleScript2.getExtents();
        Vector3f vector3f2 = vehicleScript2.getCenterOfMassOffset();
        Vector3f vector3f3 = vehicleScript.getExtents();
        Vector3f vector3f4 = vehicleScript.getCenterOfMassOffset();
        Vector3f vector3f5 = L_testCollisionWithVehicle.worldPos;
        float f = 0.5f;
        this.getWorldPos(vector3f2.x + vector3f.x * f, 0.0f, vector3f2.z + vector3f.z * f, vector3f5, vehicleScript2);
        vector2Array[0].set(vector3f5.x, vector3f5.y);
        this.getWorldPos(vector3f2.x - vector3f.x * f, 0.0f, vector3f2.z + vector3f.z * f, vector3f5, vehicleScript2);
        vector2Array[1].set(vector3f5.x, vector3f5.y);
        this.getWorldPos(vector3f2.x - vector3f.x * f, 0.0f, vector3f2.z - vector3f.z * f, vector3f5, vehicleScript2);
        vector2Array[2].set(vector3f5.x, vector3f5.y);
        this.getWorldPos(vector3f2.x + vector3f.x * f, 0.0f, vector3f2.z - vector3f.z * f, vector3f5, vehicleScript2);
        vector2Array[3].set(vector3f5.x, vector3f5.y);
        baseVehicle.getWorldPos(vector3f4.x + vector3f3.x * f, 0.0f, vector3f4.z + vector3f3.z * f, vector3f5, vehicleScript);
        vector2Array2[0].set(vector3f5.x, vector3f5.y);
        baseVehicle.getWorldPos(vector3f4.x - vector3f3.x * f, 0.0f, vector3f4.z + vector3f3.z * f, vector3f5, vehicleScript);
        vector2Array2[1].set(vector3f5.x, vector3f5.y);
        baseVehicle.getWorldPos(vector3f4.x - vector3f3.x * f, 0.0f, vector3f4.z - vector3f3.z * f, vector3f5, vehicleScript);
        vector2Array2[2].set(vector3f5.x, vector3f5.y);
        baseVehicle.getWorldPos(vector3f4.x + vector3f3.x * f, 0.0f, vector3f4.z - vector3f3.z * f, vector3f5, vehicleScript);
        vector2Array2[3].set(vector3f5.x, vector3f5.y);
        return QuadranglesIntersection.IsQuadranglesAreIntersected(vector2Array, vector2Array2);
    }

    protected float getObjectX(IsoObject isoObject) {
        if (isoObject instanceof IsoMovingObject) {
            return isoObject.getX();
        }
        return (float)isoObject.getSquare().getX() + 0.5f;
    }

    protected float getObjectY(IsoObject isoObject) {
        if (isoObject instanceof IsoMovingObject) {
            return isoObject.getY();
        }
        return (float)isoObject.getSquare().getY() + 0.5f;
    }

    public void ApplyImpulse(IsoObject isoObject, float f) {
        float f2 = this.getObjectX(isoObject);
        float f3 = this.getObjectY(isoObject);
        VehicleImpulse vehicleImpulse = VehicleImpulse.alloc();
        vehicleImpulse.impulse.set(this.x - f2, 0.0f, this.y - f3);
        vehicleImpulse.impulse.normalize();
        vehicleImpulse.impulse.mul(f);
        vehicleImpulse.rel_pos.set(f2 - this.x, 0.0f, f3 - this.y);
        this.impulseFromHitZombie.add(vehicleImpulse);
    }

    public void ApplyImpulse4Break(IsoObject isoObject, float f) {
        float f2 = this.getObjectX(isoObject);
        float f3 = this.getObjectY(isoObject);
        VehicleImpulse vehicleImpulse = VehicleImpulse.alloc();
        this.getLinearVelocity(vehicleImpulse.impulse);
        vehicleImpulse.impulse.mul(-f * this.getFudgedMass());
        vehicleImpulse.rel_pos.set(f2 - this.x, 0.0f, f3 - this.y);
        this.impulseFromHitZombie.add(vehicleImpulse);
    }

    public void hitCharacter(IsoZombie isoZombie) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoZombie, IsoPlayer.class);
        IsoZombie isoZombie2 = Type.tryCastTo(isoZombie, IsoZombie.class);
        if (isoZombie.getCurrentState() == StaggerBackState.instance() || isoZombie.getCurrentState() == ZombieFallDownState.instance()) {
            return;
        }
        if (Math.abs(isoZombie.x - this.x) < 0.01f || Math.abs(isoZombie.y - this.y) < 0.01f) {
            return;
        }
        float f = 15.0f;
        Vector3f vector3f = this.getLinearVelocity((Vector3f)TL_vector3f_pool.get().alloc());
        vector3f.y = 0.0f;
        float f2 = vector3f.length();
        if ((f2 = Math.min(f2, f)) < 0.05f) {
            TL_vector3f_pool.get().release(vector3f);
            return;
        }
        Vector3f vector3f2 = (Vector3f)TL_vector3f_pool.get().alloc();
        vector3f2.set(this.x - isoZombie.x, 0.0f, this.y - isoZombie.y);
        vector3f2.normalize();
        vector3f.normalize();
        float f3 = vector3f.dot((Vector3fc)vector3f2);
        TL_vector3f_pool.get().release(vector3f);
        if (f3 < 0.0f && !GameServer.bServer) {
            this.ApplyImpulse(isoZombie, this.getFudgedMass() * 7.0f * f2 / f * Math.abs(f3));
        }
        vector3f2.normalize();
        vector3f2.mul(3.0f * f2 / f);
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        float f4 = f2 + this.physics.clientForce / this.getFudgedMass();
        if (isoPlayer != null) {
            isoPlayer.setVehicleHitLocation(this);
        } else if (isoZombie2 != null) {
            isoZombie2.setVehicleHitLocation(this);
        }
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter(isoZombie.x, isoZombie.y, isoZombie.z);
        long l = baseSoundEmitter.playSound("VehicleHitCharacter");
        baseSoundEmitter.setParameterValue(l, FMODManager.instance.getParameterDescription("VehicleSpeed"), this.getCurrentSpeedKmHour());
        isoZombie.Hit(this, f4, f3 > 0.0f, vector22.set(-vector3f2.x, -vector3f2.z));
        TL_vector2_pool.get().release(vector22);
        TL_vector3f_pool.get().release(vector3f2);
        long l2 = System.currentTimeMillis();
        long l3 = (l2 - this.zombieHitTimestamp) / 1000L;
        this.zombiesHits = Math.max(this.zombiesHits - (int)l3, 0);
        if (l2 - this.zombieHitTimestamp > 700L) {
            this.zombieHitTimestamp = l2;
            ++this.zombiesHits;
            this.zombiesHits = Math.min(this.zombiesHits, 20);
        }
        if (f2 >= 5.0f || this.zombiesHits > 10) {
            f2 = this.getCurrentSpeedKmHour() / 5.0f;
            Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
            this.getLocalPos(isoZombie.x, isoZombie.y, isoZombie.z, vector3f3);
            if (vector3f3.z > 0.0f) {
                int n = this.caclulateDamageWithBodies(true);
                this.addDamageFrontHitAChr(n);
            } else {
                int n = this.caclulateDamageWithBodies(false);
                this.addDamageRearHitAChr(n);
            }
            TL_vector3f_pool.get().release(vector3f3);
        }
    }

    private int caclulateDamageWithBodies(boolean bl) {
        boolean bl2 = this.getCurrentSpeedKmHour() > 0.0f;
        float f = Math.abs(this.getCurrentSpeedKmHour());
        float f2 = f / 160.0f;
        f2 = PZMath.clamp(f2 * f2, 0.0f, 1.0f);
        float f3 = 60.0f * f2;
        float f4 = PZMath.max(1.0f, (float)this.zombiesHits / 3.0f);
        if (!bl && !bl2) {
            f4 = 1.0f;
        }
        if (this.zombiesHits > 10 && f3 < Math.abs(this.getCurrentSpeedKmHour()) / 5.0f) {
            f3 = Math.abs(this.getCurrentSpeedKmHour()) / 5.0f;
        }
        return (int)(f4 * f3);
    }

    public int calculateDamageWithCharacter(IsoGameCharacter isoGameCharacter) {
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z, vector3f);
        int n = vector3f.z > 0.0f ? this.caclulateDamageWithBodies(true) : -1 * this.caclulateDamageWithBodies(false);
        TL_vector3f_pool.get().release(vector3f);
        return n;
    }

    public boolean blocked(int n, int n2, int n3) {
        if (this.removedFromWorld || this.current == null || this.getController() == null) {
            return false;
        }
        if (this.getController() == null) {
            return false;
        }
        if (n3 != (int)this.getZ()) {
            return false;
        }
        if (IsoUtils.DistanceTo2D((float)n + 0.5f, (float)n2 + 0.5f, this.x, this.y) > 5.0f) {
            return false;
        }
        float f = 0.3f;
        Transform transform = this.tempTransform3;
        this.getWorldTransform(transform);
        transform.inverse();
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        vector3f.set((float)n + 0.5f - WorldSimulation.instance.offsetX, 0.0f, (float)n2 + 0.5f - WorldSimulation.instance.offsetY);
        transform.transform(vector3f);
        Vector3f vector3f2 = this.script.getExtents();
        Vector3f vector3f3 = this.script.getCenterOfMassOffset();
        float f2 = this.clamp(vector3f.x, vector3f3.x - vector3f2.x / 2.0f, vector3f3.x + vector3f2.x / 2.0f);
        float f3 = this.clamp(vector3f.z, vector3f3.z - vector3f2.z / 2.0f, vector3f3.z + vector3f2.z / 2.0f);
        float f4 = vector3f.x - f2;
        float f5 = vector3f.z - f3;
        TL_vector3f_pool.get().release(vector3f);
        float f6 = f4 * f4 + f5 * f5;
        return f6 < f * f;
    }

    public boolean isIntersectingSquare(int n, int n2, int n3) {
        if (n3 != (int)this.getZ()) {
            return false;
        }
        if (this.removedFromWorld || this.current == null || this.getController() == null) {
            return false;
        }
        BaseVehicle.tempPoly.x1 = BaseVehicle.tempPoly.x4 = (float)n;
        BaseVehicle.tempPoly.y1 = BaseVehicle.tempPoly.y2 = (float)n2;
        BaseVehicle.tempPoly.x2 = BaseVehicle.tempPoly.x3 = (float)(n + 1);
        BaseVehicle.tempPoly.y3 = BaseVehicle.tempPoly.y4 = (float)(n2 + 1);
        return PolyPolyIntersect.intersects(tempPoly, this.getPoly());
    }

    public boolean isIntersectingSquareWithShadow(int n, int n2, int n3) {
        if (n3 != (int)this.getZ()) {
            return false;
        }
        if (this.removedFromWorld || this.current == null || this.getController() == null) {
            return false;
        }
        BaseVehicle.tempPoly.x1 = BaseVehicle.tempPoly.x4 = (float)n;
        BaseVehicle.tempPoly.y1 = BaseVehicle.tempPoly.y2 = (float)n2;
        BaseVehicle.tempPoly.x2 = BaseVehicle.tempPoly.x3 = (float)(n + 1);
        BaseVehicle.tempPoly.y3 = BaseVehicle.tempPoly.y4 = (float)(n2 + 1);
        return PolyPolyIntersect.intersects(tempPoly, this.shadowCoord);
    }

    public boolean circleIntersects(float f, float f2, float f3, float f4) {
        if (this.getController() == null) {
            return false;
        }
        if ((int)f3 != (int)this.getZ()) {
            return false;
        }
        if (IsoUtils.DistanceTo2D(f, f2, this.x, this.y) > 5.0f) {
            return false;
        }
        Vector3f vector3f = this.script.getExtents();
        Vector3f vector3f2 = this.script.getCenterOfMassOffset();
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(f, f2, f3, vector3f3);
        float f5 = vector3f2.x - vector3f.x / 2.0f;
        float f6 = vector3f2.x + vector3f.x / 2.0f;
        float f7 = vector3f2.z - vector3f.z / 2.0f;
        float f8 = vector3f2.z + vector3f.z / 2.0f;
        if (vector3f3.x > f5 && vector3f3.x < f6 && vector3f3.z > f7 && vector3f3.z < f8) {
            return true;
        }
        float f9 = this.clamp(vector3f3.x, f5, f6);
        float f10 = this.clamp(vector3f3.z, f7, f8);
        float f11 = vector3f3.x - f9;
        float f12 = vector3f3.z - f10;
        TL_vector3f_pool.get().release(vector3f3);
        float f13 = f11 * f11 + f12 * f12;
        return f13 < f4 * f4;
    }

    public void updateLights() {
        boolean bl;
        VehicleModelInstance vehicleModelInstance = (VehicleModelInstance)this.sprite.modelSlot.model;
        vehicleModelInstance.textureRustA = this.rust;
        if (this.script.getWheelCount() == 0) {
            vehicleModelInstance.textureRustA = 0.0f;
        }
        vehicleModelInstance.painColor.x = this.colorHue;
        vehicleModelInstance.painColor.y = this.colorSaturation;
        vehicleModelInstance.painColor.z = this.colorValue;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        if (this.windowLightsOn) {
            VehiclePart vehiclePart = this.getPartById("Windshield");
            bl2 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindshieldRear");
            bl3 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindowFrontLeft");
            bl4 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindowMiddleLeft");
            bl5 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindowRearLeft");
            bl6 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindowFrontRight");
            bl7 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindowMiddleRight");
            bl8 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
            vehiclePart = this.getPartById("WindowRearRight");
            bl9 = vehiclePart != null && vehiclePart.getInventoryItem() != null;
        }
        vehicleModelInstance.textureLightsEnables1[10] = bl2 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables1[14] = bl3 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables1[2] = bl4 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables1[6] = bl5 | bl6 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables1[9] = bl7 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables1[13] = bl8 | bl9 ? 1.0f : 0.0f;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        if (this.headlightsOn && this.getBatteryCharge() > 0.0f) {
            VehiclePart vehiclePart = this.getPartById("HeadlightLeft");
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                bl10 = true;
            }
            if ((vehiclePart = this.getPartById("HeadlightRight")) != null && vehiclePart.getInventoryItem() != null) {
                bl11 = true;
            }
            if ((vehiclePart = this.getPartById("HeadlightRearLeft")) != null && vehiclePart.getInventoryItem() != null) {
                bl13 = true;
            }
            if ((vehiclePart = this.getPartById("HeadlightRearRight")) != null && vehiclePart.getInventoryItem() != null) {
                bl12 = true;
            }
        }
        vehicleModelInstance.textureLightsEnables2[4] = bl11 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables2[8] = bl10 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables2[12] = bl12 ? 1.0f : 0.0f;
        vehicleModelInstance.textureLightsEnables2[1] = bl13 ? 1.0f : 0.0f;
        boolean bl14 = bl = this.stoplightsOn && this.getBatteryCharge() > 0.0f;
        if (this.scriptName.contains("Trailer") && this.vehicleTowedBy != null && this.vehicleTowedBy.stoplightsOn && this.vehicleTowedBy.getBatteryCharge() > 0.0f) {
            bl = true;
        }
        if (bl) {
            vehicleModelInstance.textureLightsEnables2[5] = 1.0f;
            vehicleModelInstance.textureLightsEnables2[9] = 1.0f;
        } else {
            vehicleModelInstance.textureLightsEnables2[5] = 0.0f;
            vehicleModelInstance.textureLightsEnables2[9] = 0.0f;
        }
        if (this.script.getLightbar().enable) {
            if (this.lightbarLightsMode.isEnable() && this.getBatteryCharge() > 0.0f) {
                switch (this.lightbarLightsMode.getLightTexIndex()) {
                    case 0: {
                        vehicleModelInstance.textureLightsEnables2[13] = 0.0f;
                        vehicleModelInstance.textureLightsEnables2[2] = 0.0f;
                        break;
                    }
                    case 1: {
                        vehicleModelInstance.textureLightsEnables2[13] = 0.0f;
                        vehicleModelInstance.textureLightsEnables2[2] = 1.0f;
                        break;
                    }
                    case 2: {
                        vehicleModelInstance.textureLightsEnables2[13] = 1.0f;
                        vehicleModelInstance.textureLightsEnables2[2] = 0.0f;
                        break;
                    }
                    default: {
                        vehicleModelInstance.textureLightsEnables2[13] = 0.0f;
                        vehicleModelInstance.textureLightsEnables2[2] = 0.0f;
                        break;
                    }
                }
            } else {
                vehicleModelInstance.textureLightsEnables2[13] = 0.0f;
                vehicleModelInstance.textureLightsEnables2[2] = 0.0f;
            }
        }
        if (DebugOptions.instance.VehicleCycleColor.getValue()) {
            float f = System.currentTimeMillis() % 2000L;
            float f2 = System.currentTimeMillis() % 7000L;
            float f3 = System.currentTimeMillis() % 11000L;
            vehicleModelInstance.painColor.x = f / 2000.0f;
            vehicleModelInstance.painColor.y = f2 / 7000.0f;
            vehicleModelInstance.painColor.z = f3 / 11000.0f;
        }
        if (DebugOptions.instance.VehicleRenderBlood0.getValue()) {
            Arrays.fill(vehicleModelInstance.matrixBlood1Enables1, 0.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood1Enables2, 0.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood2Enables1, 0.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood2Enables2, 0.0f);
        }
        if (DebugOptions.instance.VehicleRenderBlood50.getValue()) {
            Arrays.fill(vehicleModelInstance.matrixBlood1Enables1, 0.5f);
            Arrays.fill(vehicleModelInstance.matrixBlood1Enables2, 0.5f);
            Arrays.fill(vehicleModelInstance.matrixBlood2Enables1, 1.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood2Enables2, 1.0f);
        }
        if (DebugOptions.instance.VehicleRenderBlood100.getValue()) {
            Arrays.fill(vehicleModelInstance.matrixBlood1Enables1, 1.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood1Enables2, 1.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood2Enables1, 1.0f);
            Arrays.fill(vehicleModelInstance.matrixBlood2Enables2, 1.0f);
        }
        if (DebugOptions.instance.VehicleRenderDamage0.getValue()) {
            Arrays.fill(vehicleModelInstance.textureDamage1Enables1, 0.0f);
            Arrays.fill(vehicleModelInstance.textureDamage1Enables2, 0.0f);
            Arrays.fill(vehicleModelInstance.textureDamage2Enables1, 0.0f);
            Arrays.fill(vehicleModelInstance.textureDamage2Enables2, 0.0f);
        }
        if (DebugOptions.instance.VehicleRenderDamage1.getValue()) {
            Arrays.fill(vehicleModelInstance.textureDamage1Enables1, 1.0f);
            Arrays.fill(vehicleModelInstance.textureDamage1Enables2, 1.0f);
            Arrays.fill(vehicleModelInstance.textureDamage2Enables1, 0.0f);
            Arrays.fill(vehicleModelInstance.textureDamage2Enables2, 0.0f);
        }
        if (DebugOptions.instance.VehicleRenderDamage2.getValue()) {
            Arrays.fill(vehicleModelInstance.textureDamage1Enables1, 0.0f);
            Arrays.fill(vehicleModelInstance.textureDamage1Enables2, 0.0f);
            Arrays.fill(vehicleModelInstance.textureDamage2Enables1, 1.0f);
            Arrays.fill(vehicleModelInstance.textureDamage2Enables2, 1.0f);
        }
        if (DebugOptions.instance.VehicleRenderRust0.getValue()) {
            vehicleModelInstance.textureRustA = 0.0f;
        }
        if (DebugOptions.instance.VehicleRenderRust50.getValue()) {
            vehicleModelInstance.textureRustA = 0.5f;
        }
        if (DebugOptions.instance.VehicleRenderRust100.getValue()) {
            vehicleModelInstance.textureRustA = 1.0f;
        }
        vehicleModelInstance.refBody = 0.3f;
        vehicleModelInstance.refWindows = 0.4f;
        if (this.rust > 0.8f) {
            vehicleModelInstance.refBody = 0.1f;
            vehicleModelInstance.refWindows = 0.2f;
        }
    }

    private void updateWorldLights() {
        if (!this.script.getLightbar().enable) {
            this.removeWorldLights();
            return;
        }
        if (!this.lightbarLightsMode.isEnable() || this.getBatteryCharge() <= 0.0f) {
            this.removeWorldLights();
            return;
        }
        if (this.lightbarLightsMode.getLightTexIndex() == 0) {
            this.removeWorldLights();
            return;
        }
        this.rightLight2.radius = 8;
        this.rightLight1.radius = 8;
        this.leftLight2.radius = 8;
        this.leftLight1.radius = 8;
        if (this.lightbarLightsMode.getLightTexIndex() == 1) {
            IsoLightSource isoLightSource;
            Vector3f vector3f = this.getWorldPos(0.4f, 0.0f, 0.0f, (Vector3f)TL_vector3f_pool.get().alloc());
            int n = (int)vector3f.x;
            int n2 = (int)vector3f.y;
            int n3 = (int)(this.getZ() + 1.0f);
            TL_vector3f_pool.get().release(vector3f);
            int n4 = this.leftLightIndex;
            if (n4 == 1 && this.leftLight1.x == n && this.leftLight1.y == n2 && this.leftLight1.z == n3) {
                return;
            }
            if (n4 == 2 && this.leftLight2.x == n && this.leftLight2.y == n2 && this.leftLight2.z == n3) {
                return;
            }
            this.removeWorldLights();
            if (n4 == 1) {
                isoLightSource = this.leftLight2;
                this.leftLightIndex = 2;
            } else {
                isoLightSource = this.leftLight1;
                this.leftLightIndex = 1;
            }
            isoLightSource.life = -1;
            isoLightSource.x = n;
            isoLightSource.y = n2;
            isoLightSource.z = n3;
            IsoWorld.instance.CurrentCell.addLamppost(isoLightSource);
        } else {
            IsoLightSource isoLightSource;
            Vector3f vector3f = this.getWorldPos(-0.4f, 0.0f, 0.0f, (Vector3f)TL_vector3f_pool.get().alloc());
            int n = (int)vector3f.x;
            int n5 = (int)vector3f.y;
            int n6 = (int)(this.getZ() + 1.0f);
            TL_vector3f_pool.get().release(vector3f);
            int n7 = this.rightLightIndex;
            if (n7 == 1 && this.rightLight1.x == n && this.rightLight1.y == n5 && this.rightLight1.z == n6) {
                return;
            }
            if (n7 == 2 && this.rightLight2.x == n && this.rightLight2.y == n5 && this.rightLight2.z == n6) {
                return;
            }
            this.removeWorldLights();
            if (n7 == 1) {
                isoLightSource = this.rightLight2;
                this.rightLightIndex = 2;
            } else {
                isoLightSource = this.rightLight1;
                this.rightLightIndex = 1;
            }
            isoLightSource.life = -1;
            isoLightSource.x = n;
            isoLightSource.y = n5;
            isoLightSource.z = n6;
            IsoWorld.instance.CurrentCell.addLamppost(isoLightSource);
        }
    }

    public void fixLightbarModelLighting(IsoLightSource isoLightSource, Vector3f vector3f) {
        if (isoLightSource == this.leftLight1 || isoLightSource == this.leftLight2) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        } else if (isoLightSource == this.rightLight1 || isoLightSource == this.rightLight2) {
            vector3f.set(-1.0f, 0.0f, 0.0f);
        }
    }

    private void removeWorldLights() {
        if (this.leftLightIndex == 1) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.leftLight1);
            this.leftLightIndex = -1;
        }
        if (this.leftLightIndex == 2) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.leftLight2);
            this.leftLightIndex = -1;
        }
        if (this.rightLightIndex == 1) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.rightLight1);
            this.rightLightIndex = -1;
        }
        if (this.rightLightIndex == 2) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.rightLight2);
            this.rightLightIndex = -1;
        }
    }

    public void doDamageOverlay() {
        if (this.sprite.modelSlot == null) {
            return;
        }
        this.doDoorDamage();
        this.doWindowDamage();
        this.doOtherBodyWorkDamage();
        this.doBloodOverlay();
    }

    private void checkDamage(VehiclePart vehiclePart, int n, boolean bl) {
        if (bl && vehiclePart != null && vehiclePart.getId().startsWith("Window") && vehiclePart.getScriptModelById("Default") != null) {
            bl = false;
        }
        VehicleModelInstance vehicleModelInstance = (VehicleModelInstance)this.sprite.modelSlot.model;
        try {
            vehicleModelInstance.textureDamage1Enables1[n] = 0.0f;
            vehicleModelInstance.textureDamage2Enables1[n] = 0.0f;
            vehicleModelInstance.textureUninstall1[n] = 0.0f;
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                if (vehiclePart.getInventoryItem().getCondition() < 60 && vehiclePart.getInventoryItem().getCondition() >= 40) {
                    vehicleModelInstance.textureDamage1Enables1[n] = 1.0f;
                }
                if (vehiclePart.getInventoryItem().getCondition() < 40) {
                    vehicleModelInstance.textureDamage2Enables1[n] = 1.0f;
                }
                if (vehiclePart.window != null && vehiclePart.window.isOpen() && bl) {
                    vehicleModelInstance.textureUninstall1[n] = 1.0f;
                }
            } else if (vehiclePart != null && bl) {
                vehicleModelInstance.textureUninstall1[n] = 1.0f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkDamage2(VehiclePart vehiclePart, int n, boolean bl) {
        VehicleModelInstance vehicleModelInstance = (VehicleModelInstance)this.sprite.modelSlot.model;
        try {
            vehicleModelInstance.textureDamage1Enables2[n] = 0.0f;
            vehicleModelInstance.textureDamage2Enables2[n] = 0.0f;
            vehicleModelInstance.textureUninstall2[n] = 0.0f;
            if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
                if (vehiclePart.getInventoryItem().getCondition() < 60 && vehiclePart.getInventoryItem().getCondition() >= 40) {
                    vehicleModelInstance.textureDamage1Enables2[n] = 1.0f;
                }
                if (vehiclePart.getInventoryItem().getCondition() < 40) {
                    vehicleModelInstance.textureDamage2Enables2[n] = 1.0f;
                }
                if (vehiclePart.window != null && vehiclePart.window.isOpen() && bl) {
                    vehicleModelInstance.textureUninstall2[n] = 1.0f;
                }
            } else if (vehiclePart != null && bl) {
                vehicleModelInstance.textureUninstall2[n] = 1.0f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkUninstall2(VehiclePart vehiclePart, int n) {
        VehicleModelInstance vehicleModelInstance = (VehicleModelInstance)this.sprite.modelSlot.model;
        try {
            vehicleModelInstance.textureUninstall2[n] = 0.0f;
            if (vehiclePart != null && vehiclePart.getInventoryItem() == null) {
                vehicleModelInstance.textureUninstall2[n] = 1.0f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doOtherBodyWorkDamage() {
        this.checkDamage(this.getPartById("EngineDoor"), 0, false);
        this.checkDamage(this.getPartById("EngineDoor"), 3, false);
        this.checkDamage(this.getPartById("EngineDoor"), 11, false);
        this.checkDamage2(this.getPartById("EngineDoor"), 6, true);
        this.checkDamage(this.getPartById("TruckBed"), 4, false);
        this.checkDamage(this.getPartById("TruckBed"), 7, false);
        this.checkDamage(this.getPartById("TruckBed"), 15, false);
        VehiclePart vehiclePart = this.getPartById("TrunkDoor");
        if (vehiclePart != null) {
            this.checkDamage2(vehiclePart, 10, true);
            if (vehiclePart.scriptPart.hasLightsRear) {
                this.checkUninstall2(vehiclePart, 12);
                this.checkUninstall2(vehiclePart, 1);
                this.checkUninstall2(vehiclePart, 5);
                this.checkUninstall2(vehiclePart, 9);
            }
        } else {
            vehiclePart = this.getPartById("DoorRear");
            if (vehiclePart != null) {
                this.checkDamage2(vehiclePart, 10, true);
                if (vehiclePart.scriptPart.hasLightsRear) {
                    this.checkUninstall2(vehiclePart, 12);
                    this.checkUninstall2(vehiclePart, 1);
                    this.checkUninstall2(vehiclePart, 5);
                    this.checkUninstall2(vehiclePart, 9);
                }
            }
        }
    }

    private void doWindowDamage() {
        this.checkDamage(this.getPartById("WindowFrontLeft"), 2, true);
        this.checkDamage(this.getPartById("WindowFrontRight"), 9, true);
        VehiclePart vehiclePart = this.getPartById("WindowRearLeft");
        if (vehiclePart != null) {
            this.checkDamage(vehiclePart, 6, true);
        } else {
            vehiclePart = this.getPartById("WindowMiddleLeft");
            if (vehiclePart != null) {
                this.checkDamage(vehiclePart, 6, true);
            }
        }
        vehiclePart = this.getPartById("WindowRearRight");
        if (vehiclePart != null) {
            this.checkDamage(vehiclePart, 13, true);
        } else {
            vehiclePart = this.getPartById("WindowMiddleRight");
            if (vehiclePart != null) {
                this.checkDamage(vehiclePart, 13, true);
            }
        }
        this.checkDamage(this.getPartById("Windshield"), 10, true);
        this.checkDamage(this.getPartById("WindshieldRear"), 14, true);
    }

    private void doDoorDamage() {
        this.checkDamage(this.getPartById("DoorFrontLeft"), 1, true);
        this.checkDamage(this.getPartById("DoorFrontRight"), 8, true);
        VehiclePart vehiclePart = this.getPartById("DoorRearLeft");
        if (vehiclePart != null) {
            this.checkDamage(vehiclePart, 5, true);
        } else {
            vehiclePart = this.getPartById("DoorMiddleLeft");
            if (vehiclePart != null) {
                this.checkDamage(vehiclePart, 5, true);
            }
        }
        vehiclePart = this.getPartById("DoorRearRight");
        if (vehiclePart != null) {
            this.checkDamage(vehiclePart, 12, true);
        } else {
            vehiclePart = this.getPartById("DoorMiddleRight");
            if (vehiclePart != null) {
                this.checkDamage(vehiclePart, 12, true);
            }
        }
    }

    public float getBloodIntensity(String string) {
        return (float)(this.bloodIntensity.getOrDefault(string, BYTE_ZERO) & 0xFF) / 100.0f;
    }

    public void setBloodIntensity(String string, float f) {
        byte by = (byte)(PZMath.clamp(f, 0.0f, 1.0f) * 100.0f);
        if (this.bloodIntensity.containsKey(string) && by == this.bloodIntensity.get(string)) {
            return;
        }
        this.bloodIntensity.put(string, by);
        this.doBloodOverlay();
        this.transmitBlood();
    }

    public void transmitBlood() {
        if (!GameServer.bServer) {
            return;
        }
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void doBloodOverlay() {
        if (this.sprite.modelSlot == null) {
            return;
        }
        VehicleModelInstance vehicleModelInstance = (VehicleModelInstance)this.sprite.modelSlot.model;
        Arrays.fill(vehicleModelInstance.matrixBlood1Enables1, 0.0f);
        Arrays.fill(vehicleModelInstance.matrixBlood1Enables2, 0.0f);
        Arrays.fill(vehicleModelInstance.matrixBlood2Enables1, 0.0f);
        Arrays.fill(vehicleModelInstance.matrixBlood2Enables2, 0.0f);
        if (Core.getInstance().getOptionBloodDecals() == 0) {
            return;
        }
        this.doBloodOverlayFront(vehicleModelInstance.matrixBlood1Enables1, vehicleModelInstance.matrixBlood1Enables2, this.getBloodIntensity("Front"));
        this.doBloodOverlayRear(vehicleModelInstance.matrixBlood1Enables1, vehicleModelInstance.matrixBlood1Enables2, this.getBloodIntensity("Rear"));
        this.doBloodOverlayLeft(vehicleModelInstance.matrixBlood1Enables1, vehicleModelInstance.matrixBlood1Enables2, this.getBloodIntensity("Left"));
        this.doBloodOverlayRight(vehicleModelInstance.matrixBlood1Enables1, vehicleModelInstance.matrixBlood1Enables2, this.getBloodIntensity("Right"));
        for (Map.Entry<String, Byte> entry : this.bloodIntensity.entrySet()) {
            Integer n = s_PartToMaskMap.get(entry.getKey());
            if (n == null) continue;
            vehicleModelInstance.matrixBlood1Enables1[n.intValue()] = (float)(entry.getValue() & 0xFF) / 100.0f;
        }
        this.doBloodOverlayAux(vehicleModelInstance.matrixBlood2Enables1, vehicleModelInstance.matrixBlood2Enables2, 1.0f);
    }

    private void doBloodOverlayAux(float[] fArray, float[] fArray2, float f) {
        fArray[0] = f;
        fArray2[6] = f;
        fArray2[4] = f;
        fArray2[8] = f;
        fArray[4] = f;
        fArray[7] = f;
        fArray[15] = f;
        fArray2[10] = f;
        fArray2[12] = f;
        fArray2[1] = f;
        fArray2[5] = f;
        fArray2[9] = f;
        fArray[3] = f;
        fArray[8] = f;
        fArray[12] = f;
        fArray[11] = f;
        fArray[1] = f;
        fArray[5] = f;
        fArray2[0] = f;
        fArray[10] = f;
        fArray[14] = f;
        fArray[9] = f;
        fArray[13] = f;
        fArray[2] = f;
        fArray[6] = f;
    }

    private void doBloodOverlayFront(float[] fArray, float[] fArray2, float f) {
        fArray[0] = f;
        fArray2[6] = f;
        fArray2[4] = f;
        fArray2[8] = f;
        fArray[10] = f;
    }

    private void doBloodOverlayRear(float[] fArray, float[] fArray2, float f) {
        fArray[4] = f;
        fArray2[10] = f;
        fArray2[12] = f;
        fArray2[1] = f;
        fArray2[5] = f;
        fArray2[9] = f;
        fArray[14] = f;
    }

    private void doBloodOverlayLeft(float[] fArray, float[] fArray2, float f) {
        fArray[11] = f;
        fArray[1] = f;
        fArray[5] = f;
        fArray[15] = f;
        fArray[2] = f;
        fArray[6] = f;
    }

    private void doBloodOverlayRight(float[] fArray, float[] fArray2, float f) {
        fArray[3] = f;
        fArray[8] = f;
        fArray[12] = f;
        fArray[7] = f;
        fArray[9] = f;
        fArray[13] = f;
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        boolean bl3;
        if (this.script == null) {
            return;
        }
        if (this.physics != null) {
            this.physics.debug();
        }
        int n = IsoCamera.frameState.playerIndex;
        boolean bl4 = bl3 = IsoCamera.CamCharacter != null && IsoCamera.CamCharacter.getVehicle() == this;
        if (!bl3 && !this.square.lighting[n].bSeen()) {
            return;
        }
        if (bl3 || this.square.lighting[n].bCouldSee()) {
            this.setTargetAlpha(n, 1.0f);
        } else {
            this.setTargetAlpha(n, 0.0f);
        }
        if (this.sprite.hasActiveModel()) {
            boolean bl5;
            this.updateLights();
            boolean bl6 = bl5 = Core.getInstance().getOptionBloodDecals() != 0;
            if (this.OptionBloodDecals != bl5) {
                this.OptionBloodDecals = bl5;
                this.doBloodOverlay();
            }
            BaseVehicle.inf.a = colorInfo.a = this.getAlpha(n);
            BaseVehicle.inf.r = colorInfo.r;
            BaseVehicle.inf.g = colorInfo.g;
            BaseVehicle.inf.b = colorInfo.b;
            this.sprite.renderVehicle(this.def, this, f, f2, 0.0f, 0.0f, 0.0f, inf, true);
        }
        this.updateAlpha(n);
        if (Core.bDebug && DebugOptions.instance.VehicleRenderArea.getValue()) {
            this.renderAreas();
        }
        if (Core.bDebug && DebugOptions.instance.VehicleRenderAttackPositions.getValue()) {
            this.m_surroundVehicle.render();
        }
        if (Core.bDebug && DebugOptions.instance.VehicleRenderExit.getValue()) {
            this.renderExits();
        }
        if (Core.bDebug && DebugOptions.instance.VehicleRenderIntersectedSquares.getValue()) {
            this.renderIntersectedSquares();
        }
        if (Core.bDebug && DebugOptions.instance.VehicleRenderAuthorizations.getValue()) {
            this.renderAuthorizations();
        }
        if (Core.bDebug && DebugOptions.instance.VehicleRenderInterpolateBuffer.getValue()) {
            this.renderInterpolateBuffer();
        }
        if (DebugOptions.instance.VehicleRenderTrailerPositions.getValue()) {
            this.renderTrailerPositions();
        }
        this.renderUsableArea();
    }

    @Override
    public void renderlast() {
        int n = IsoCamera.frameState.playerIndex;
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.chatElement == null || !vehiclePart.chatElement.getHasChatToDisplay()) continue;
            if (vehiclePart.getDeviceData() != null && !vehiclePart.getDeviceData().getIsTurnedOn()) {
                vehiclePart.chatElement.clear(n);
                continue;
            }
            float f = IsoUtils.XToScreen(this.getX(), this.getY(), this.getZ(), 0);
            float f2 = IsoUtils.YToScreen(this.getX(), this.getY(), this.getZ(), 0);
            f = f - IsoCamera.getOffX() - this.offsetX;
            f2 = f2 - IsoCamera.getOffY() - this.offsetY;
            f += (float)(32 * Core.TileScale);
            f2 += (float)(20 * Core.TileScale);
            vehiclePart.chatElement.renderBatched(n, (int)(f /= Core.getInstance().getZoom(n)), (int)(f2 /= Core.getInstance().getZoom(n)));
        }
    }

    public void renderShadow() {
        if (this.physics == null) {
            return;
        }
        if (this.script == null) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        if (!this.square.lighting[n].bSeen()) {
            return;
        }
        if (this.square.lighting[n].bCouldSee()) {
            this.setTargetAlpha(n, 1.0f);
        } else {
            this.setTargetAlpha(n, 0.0f);
        }
        Texture texture = this.getShadowTexture();
        if (texture != null && this.getCurrentSquare() != null) {
            float f = 0.6f * this.getAlpha(n);
            ColorInfo colorInfo = this.getCurrentSquare().lighting[n].lightInfo();
            f *= (colorInfo.r + colorInfo.g + colorInfo.b) / 3.0f;
            if (this.polyDirty) {
                this.getPoly();
            }
            SpriteRenderer.instance.renderPoly(texture, (int)IsoUtils.XToScreenExact(this.shadowCoord.x2, this.shadowCoord.y2, 0.0f, 0), (int)IsoUtils.YToScreenExact(this.shadowCoord.x2, this.shadowCoord.y2, 0.0f, 0), (int)IsoUtils.XToScreenExact(this.shadowCoord.x1, this.shadowCoord.y1, 0.0f, 0), (int)IsoUtils.YToScreenExact(this.shadowCoord.x1, this.shadowCoord.y1, 0.0f, 0), (int)IsoUtils.XToScreenExact(this.shadowCoord.x4, this.shadowCoord.y4, 0.0f, 0), (int)IsoUtils.YToScreenExact(this.shadowCoord.x4, this.shadowCoord.y4, 0.0f, 0), (int)IsoUtils.XToScreenExact(this.shadowCoord.x3, this.shadowCoord.y3, 0.0f, 0), (int)IsoUtils.YToScreenExact(this.shadowCoord.x3, this.shadowCoord.y3, 0.0f, 0), 1.0f, 1.0f, 1.0f, 0.8f * f);
        }
    }

    public boolean isEnterBlocked(IsoGameCharacter isoGameCharacter, int n) {
        return this.isExitBlocked(isoGameCharacter, n);
    }

    public boolean isExitBlocked(int n) {
        Vector2 vector22;
        VehicleScript.Position position = this.getPassengerPosition(n, "inside");
        VehicleScript.Position position2 = this.getPassengerPosition(n, "outside");
        if (position == null || position2 == null) {
            return true;
        }
        Vector3f vector3f = this.getPassengerPositionWorldPos(position2, (Vector3f)TL_vector3f_pool.get().alloc());
        if (position2.area != null) {
            vector22 = (Vector2)TL_vector2_pool.get().alloc();
            VehicleScript.Area area = this.script.getAreaById(position2.area);
            Vector2 vector23 = this.areaPositionWorld4PlayerInteract(area, vector22);
            if (vector23 != null) {
                vector3f.x = vector23.x;
                vector3f.y = vector23.y;
            }
            TL_vector2_pool.get().release(vector22);
        }
        vector3f.z = 0.0f;
        vector22 = this.getPassengerPositionWorldPos(position, (Vector3f)TL_vector3f_pool.get().alloc());
        boolean bl = PolygonalMap2.instance.lineClearCollide(((Vector3f)vector22).x, ((Vector3f)vector22).y, vector3f.x, vector3f.y, (int)this.z, this, false, false);
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector22);
        return bl;
    }

    public boolean isExitBlocked(IsoGameCharacter isoGameCharacter, int n) {
        Object object;
        Vector2 vector22;
        VehicleScript.Position position = this.getPassengerPosition(n, "inside");
        VehicleScript.Position position2 = this.getPassengerPosition(n, "outside");
        if (position == null || position2 == null) {
            return true;
        }
        Vector3f vector3f = this.getPassengerPositionWorldPos(position2, (Vector3f)TL_vector3f_pool.get().alloc());
        if (position2.area != null) {
            vector22 = (Vector2)TL_vector2_pool.get().alloc();
            VehicleScript.Area area = this.script.getAreaById(position2.area);
            object = this.areaPositionWorld4PlayerInteract(area, vector22);
            if (object != null) {
                vector3f.x = ((Vector2)object).x;
                vector3f.y = ((Vector2)object).y;
            }
            TL_vector2_pool.get().release(vector22);
        }
        vector3f.z = 0.0f;
        vector22 = this.getPassengerPositionWorldPos(position, (Vector3f)TL_vector3f_pool.get().alloc());
        boolean bl = PolygonalMap2.instance.lineClearCollide(((Vector3f)vector22).x, ((Vector3f)vector22).y, vector3f.x, vector3f.y, (int)this.z, this, false, false);
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector22);
        if (!bl && GameClient.bClient && (object = IsoWorld.instance.CurrentCell.getGridSquare(vector3f.x, vector3f.y, vector3f.z)) != null && isoGameCharacter instanceof IsoPlayer && !SafeHouse.isPlayerAllowedOnSquare((IsoPlayer)isoGameCharacter, (IsoGridSquare)object)) {
            bl = true;
        }
        return bl;
    }

    public boolean isPassengerUseDoor2(IsoGameCharacter isoGameCharacter, int n) {
        VehicleScript.Position position = this.getPassengerPosition(n, "outside2");
        if (position != null) {
            Vector3f vector3f = this.getPassengerPositionWorldPos(position, (Vector3f)TL_vector3f_pool.get().alloc());
            vector3f.sub(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z);
            float f = vector3f.length();
            TL_vector3f_pool.get().release(vector3f);
            if (f < 2.0f) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnterBlocked2(IsoGameCharacter isoGameCharacter, int n) {
        return this.isExitBlocked2(n);
    }

    public boolean isExitBlocked2(int n) {
        VehicleScript.Position position = this.getPassengerPosition(n, "inside");
        VehicleScript.Position position2 = this.getPassengerPosition(n, "outside2");
        if (position == null || position2 == null) {
            return true;
        }
        Vector3f vector3f = this.getPassengerPositionWorldPos(position2, (Vector3f)TL_vector3f_pool.get().alloc());
        vector3f.z = 0.0f;
        Vector3f vector3f2 = this.getPassengerPositionWorldPos(position, (Vector3f)TL_vector3f_pool.get().alloc());
        boolean bl = PolygonalMap2.instance.lineClearCollide(vector3f2.x, vector3f2.y, vector3f.x, vector3f.y, (int)this.z, this, false, false);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(vector3f.x, vector3f.y, vector3f.z);
        IsoGameCharacter isoGameCharacter = this.getCharacter(n);
        if (isoGameCharacter instanceof IsoPlayer && !SafeHouse.isPlayerAllowedOnSquare((IsoPlayer)isoGameCharacter, isoGridSquare)) {
            bl = true;
        }
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector3f2);
        return bl;
    }

    private void renderExits() {
        int n = Core.TileScale;
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector3f vector3f2 = (Vector3f)TL_vector3f_pool.get().alloc();
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            VehicleScript.Position position = this.getPassengerPosition(i, "inside");
            VehicleScript.Position position2 = this.getPassengerPosition(i, "outside");
            if (position == null || position2 == null) continue;
            float f = 0.3f;
            this.getPassengerPositionWorldPos(position2, vector3f);
            this.getPassengerPositionWorldPos(position, vector3f2);
            int n2 = (int)Math.floor(vector3f.x - f);
            int n3 = (int)Math.floor(vector3f.x + f);
            int n4 = (int)Math.floor(vector3f.y - f);
            int n5 = (int)Math.floor(vector3f.y + f);
            for (int j = n4; j <= n5; ++j) {
                for (int k = n2; k <= n3; ++k) {
                    int n6 = (int)IsoUtils.XToScreenExact(k, j + 1, (int)this.z, 0);
                    int n7 = (int)IsoUtils.YToScreenExact(k, j + 1, (int)this.z, 0);
                    SpriteRenderer.instance.renderPoly(n6, n7, n6 + 32 * n, n7 - 16 * n, n6 + 64 * n, n7, n6 + 32 * n, n7 + 16 * n, 1.0f, 1.0f, 1.0f, 0.5f);
                }
            }
            float f2 = 1.0f;
            float f3 = 1.0f;
            float f4 = 1.0f;
            if (this.isExitBlocked(i)) {
                f4 = 0.0f;
                f3 = 0.0f;
            }
            this.getController().drawCircle(vector3f2.x, vector3f2.y, f, 0.0f, 0.0f, 1.0f, 1.0f);
            this.getController().drawCircle(vector3f.x, vector3f.y, f, f2, f3, f4, 1.0f);
        }
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector3f2);
    }

    private Vector2 areaPositionLocal(VehicleScript.Area area) {
        return this.areaPositionLocal(area, new Vector2());
    }

    private Vector2 areaPositionLocal(VehicleScript.Area area, Vector2 vector22) {
        Vector2 vector23 = this.areaPositionWorld(area, vector22);
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(vector23.x, vector23.y, 0.0f, vector3f);
        vector23.set(vector3f.x, vector3f.z);
        TL_vector3f_pool.get().release(vector3f);
        return vector23;
    }

    public Vector2 areaPositionWorld(VehicleScript.Area area) {
        return this.areaPositionWorld(area, new Vector2());
    }

    public Vector2 areaPositionWorld(VehicleScript.Area area, Vector2 vector22) {
        if (area == null) {
            return null;
        }
        Vector3f vector3f = this.getWorldPos(area.x, 0.0f, area.y, (Vector3f)TL_vector3f_pool.get().alloc());
        vector22.set(vector3f.x, vector3f.y);
        TL_vector3f_pool.get().release(vector3f);
        return vector22;
    }

    public Vector2 areaPositionWorld4PlayerInteract(VehicleScript.Area area) {
        return this.areaPositionWorld4PlayerInteract(area, new Vector2());
    }

    public Vector2 areaPositionWorld4PlayerInteract(VehicleScript.Area area, Vector2 vector22) {
        Vector3f vector3f = this.script.getExtents();
        Vector3f vector3f2 = this.script.getCenterOfMassOffset();
        Vector2 vector23 = this.areaPositionWorld(area, vector22);
        Vector3f vector3f3 = this.getLocalPos(vector23.x, vector23.y, 0.0f, (Vector3f)TL_vector3f_pool.get().alloc());
        if (area.x > vector3f2.x + vector3f.x / 2.0f || area.x < vector3f2.x - vector3f.x / 2.0f) {
            vector3f3.x = area.x > 0.0f ? (vector3f3.x -= area.w * 0.3f) : (vector3f3.x += area.w * 0.3f);
        } else {
            vector3f3.z = area.y > 0.0f ? (vector3f3.z -= area.h * 0.3f) : (vector3f3.z += area.h * 0.3f);
        }
        this.getWorldPos(vector3f3, vector3f3);
        vector22.set(vector3f3.x, vector3f3.y);
        TL_vector3f_pool.get().release(vector3f3);
        return vector22;
    }

    private void renderAreas() {
        if (this.getScript() == null) {
            return;
        }
        Vector3f vector3f = this.getForwardVector((Vector3f)TL_vector3f_pool.get().alloc());
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        for (int i = 0; i < this.parts.size(); ++i) {
            Vector2 vector23;
            VehicleScript.Area area;
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.getArea() == null || (area = this.getScript().getAreaById(vehiclePart.getArea())) == null || (vector23 = this.areaPositionWorld(area, vector22)) == null) continue;
            boolean bl = this.isInArea(area.id, IsoPlayer.getInstance());
            this.getController().drawRect(vector3f, vector23.x - WorldSimulation.instance.offsetX, vector23.y - WorldSimulation.instance.offsetY, area.w, area.h / 2.0f, bl ? 0.0f : 0.65f, bl ? 1.0f : 0.65f, bl ? 1.0f : 0.65f);
            vector23 = this.areaPositionWorld4PlayerInteract(area, vector22);
            this.getController().drawRect(vector3f, vector23.x - WorldSimulation.instance.offsetX, vector23.y - WorldSimulation.instance.offsetY, 0.1f, 0.1f, 1.0f, 0.0f, 0.0f);
        }
        TL_vector3f_pool.get().release(vector3f);
        TL_vector2_pool.get().release(vector22);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), 1.0f, 0.5f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), 1.0f, 0.5f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), 1.0f, 0.5f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), 1.0f, 0.5f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.shadowCoord.x1, this.shadowCoord.y1, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x1, this.shadowCoord.y1, 0.0f, 0), IsoUtils.XToScreenExact(this.shadowCoord.x2, this.shadowCoord.y2, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x2, this.shadowCoord.y2, 0.0f, 0), 0.5f, 1.0f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.shadowCoord.x2, this.shadowCoord.y2, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x2, this.shadowCoord.y2, 0.0f, 0), IsoUtils.XToScreenExact(this.shadowCoord.x3, this.shadowCoord.y3, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x3, this.shadowCoord.y3, 0.0f, 0), 0.5f, 1.0f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.shadowCoord.x3, this.shadowCoord.y3, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x3, this.shadowCoord.y3, 0.0f, 0), IsoUtils.XToScreenExact(this.shadowCoord.x4, this.shadowCoord.y4, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x4, this.shadowCoord.y4, 0.0f, 0), 0.5f, 1.0f, 0.5f, 1.0f, 0);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.shadowCoord.x4, this.shadowCoord.y4, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x4, this.shadowCoord.y4, 0.0f, 0), IsoUtils.XToScreenExact(this.shadowCoord.x1, this.shadowCoord.y1, 0.0f, 0), IsoUtils.YToScreenExact(this.shadowCoord.x1, this.shadowCoord.y1, 0.0f, 0), 0.5f, 1.0f, 0.5f, 1.0f, 0);
    }

    private void renderInterpolateBuffer() {
        if (this.netPlayerAuthorization != Authorization.Remote) {
            return;
        }
        float f = IsoUtils.XToScreenExact(this.x, this.y, 0.0f, 0);
        float f2 = IsoUtils.YToScreenExact(this.x, this.y, 0.0f, 0);
        float f3 = f - 310.0f;
        float f4 = f2 + 22.0f;
        float f5 = 300.0f;
        float f6 = 150.0f;
        float f7 = 4.0f;
        Color color = Color.lightGray;
        Color color2 = Color.green;
        Color color3 = Color.cyan;
        Color color4 = Color.yellow;
        Color color5 = Color.blue;
        Color color6 = Color.red;
        LineDrawer.drawLine(f3, f4, f3 + f5, f4, color.r, color.g, color.b, color.a, 1);
        LineDrawer.drawLine(f3, f4 + f6, f3 + f5, f4 + f6, color.r, color.g, color.b, color.a, 1);
        long l = GameTime.getServerTimeMills();
        long l2 = l - 150L - (long)this.interpolation.history;
        long l3 = l + 150L;
        this.renderInterpolateBuffer_drawVertLine(l2, color, f3, f4, f5, f6, l2, l3, true);
        this.renderInterpolateBuffer_drawVertLine(l3, color, f3, f4, f5, f6, l2, l3, true);
        this.renderInterpolateBuffer_drawVertLine(l, color2, f3, f4, f5, f6, l2, l3, true);
        this.renderInterpolateBuffer_drawVertLine(l - (long)this.interpolation.delay, color3, f3, f4, f5, f6, l2, l3, true);
        this.renderInterpolateBuffer_drawPoint(l - (long)this.interpolation.delay, this.x, color5, 5, f3, f4, f5, f6, l2, l3, this.x - f7, this.x + f7);
        this.renderInterpolateBuffer_drawPoint(l - (long)this.interpolation.delay, this.y, color6, 5, f3, f4, f5, f6, l2, l3, this.y - f7, this.y + f7);
        long l4 = 0L;
        float f8 = Float.NaN;
        float f9 = Float.NaN;
        VehicleInterpolationData vehicleInterpolationData = new VehicleInterpolationData();
        vehicleInterpolationData.time = l - (long)this.interpolation.delay;
        VehicleInterpolationData vehicleInterpolationData2 = this.interpolation.buffer.higher(vehicleInterpolationData);
        VehicleInterpolationData vehicleInterpolationData3 = this.interpolation.buffer.floor(vehicleInterpolationData);
        for (VehicleInterpolationData object2 : this.interpolation.buffer) {
            boolean bl = (object2.hashCode() & 1) == 0;
            this.renderInterpolateBuffer_drawVertLine(object2.time, color4, f3, f4, f5, f6, l2, l3, bl);
            if (object2 == vehicleInterpolationData2) {
                this.renderInterpolateBuffer_drawTextHL(object2.time, "H", color3, f3, f4, f5, f6, l2, l3);
            }
            if (object2 == vehicleInterpolationData3) {
                this.renderInterpolateBuffer_drawTextHL(object2.time, "L", color3, f3, f4, f5, f6, l2, l3);
            }
            this.renderInterpolateBuffer_drawPoint(object2.time, object2.x, color5, 5, f3, f4, f5, f6, l2, l3, this.x - f7, this.x + f7);
            this.renderInterpolateBuffer_drawPoint(object2.time, object2.y, color6, 5, f3, f4, f5, f6, l2, l3, this.y - f7, this.y + f7);
            if (!Float.isNaN(f8)) {
                this.renderInterpolateBuffer_drawLine(l4, f8, object2.time, object2.x, color5, f3, f4, f5, f6, l2, l3, this.x - f7, this.x + f7);
                this.renderInterpolateBuffer_drawLine(l4, f9, object2.time, object2.y, color6, f3, f4, f5, f6, l2, l3, this.y - f7, this.y + f7);
            }
            l4 = object2.time;
            f8 = object2.x;
            f9 = object2.y;
        }
        Object object3 = new float[27];
        float[] fArray = new float[2];
        boolean bl = this.interpolation.interpolationDataGet((float[])object3, fArray, l - (long)this.interpolation.delay);
        TextManager.instance.DrawString(f3, f4 + f6 + 20.0f, String.format("interpolationDataGet=%s", bl ? "True" : "False"), color3.r, color3.g, color3.b, color3.a);
        TextManager.instance.DrawString(f3, f4 + f6 + 30.0f, String.format("buffer.size=%d buffering=%s", this.interpolation.buffer.size(), String.valueOf(this.interpolation.buffering)), color3.r, color3.g, color3.b, color3.a);
        if (this.interpolation.buffer.size() >= 2) {
            TextManager.instance.DrawString(f3, f4 + f6 + 40.0f, String.format("last=%d first=%d", this.interpolation.buffer.last().time, this.interpolation.buffer.first().time), color3.r, color3.g, color3.b, color3.a);
            TextManager.instance.DrawString(f3, f4 + f6 + 50.0f, String.format("(last-first).time=%d delay=%d", this.interpolation.buffer.last().time - this.interpolation.buffer.first().time, this.interpolation.delay), color3.r, color3.g, color3.b, color3.a);
        }
    }

    private void renderInterpolateBuffer_drawTextHL(long l, String string, Color color, float f, float f2, float f3, float f4, long l2, long l3) {
        float f5 = f3 / (float)(l3 - l2);
        float f6 = (float)(l - l2) * f5;
        TextManager.instance.DrawString(f6 + f, f2, string, color.r, color.g, color.b, color.a);
    }

    private void renderInterpolateBuffer_drawVertLine(long l, Color color, float f, float f2, float f3, float f4, long l2, long l3, boolean bl) {
        float f5 = f3 / (float)(l3 - l2);
        float f6 = (float)(l - l2) * f5;
        LineDrawer.drawLine(f6 + f, f2, f6 + f, f2 + f4, color.r, color.g, color.b, color.a, 1);
        TextManager.instance.DrawString(f6 + f, f2 + f4 + (bl ? 0.0f : 10.0f), String.format("%.1f", Float.valueOf((float)(l - l / 100000L * 100000L) / 1000.0f)), color.r, color.g, color.b, color.a);
    }

    private void renderInterpolateBuffer_drawLine(long l, float f, long l2, float f2, Color color, float f3, float f4, float f5, float f6, long l3, long l4, float f7, float f8) {
        float f9 = f5 / (float)(l4 - l3);
        float f10 = (float)(l - l3) * f9;
        float f11 = (float)(l2 - l3) * f9;
        float f12 = f6 / (f8 - f7);
        float f13 = (f - f7) * f12;
        float f14 = (f2 - f7) * f12;
        LineDrawer.drawLine(f10 + f3, f13 + f4, f11 + f3, f14 + f4, color.r, color.g, color.b, color.a, 1);
    }

    private void renderInterpolateBuffer_drawPoint(long l, float f, Color color, int n, float f2, float f3, float f4, float f5, long l2, long l3, float f6, float f7) {
        float f8 = f4 / (float)(l3 - l2);
        float f9 = (float)(l - l2) * f8;
        float f10 = f5 / (f7 - f6);
        float f11 = (f - f6) * f10;
        LineDrawer.drawCircle(f9 + f2, f11 + f3, n, 10, color.r, color.g, color.b);
    }

    private void renderAuthorizations() {
        Object object;
        Object object2;
        float f = 0.3f;
        float f2 = 0.3f;
        float f3 = 0.3f;
        float f4 = 0.5f;
        switch (this.netPlayerAuthorization) {
            case Server: {
                f = 1.0f;
                break;
            }
            case LocalCollide: {
                f3 = 1.0f;
                break;
            }
            case Local: {
                f2 = 1.0f;
                break;
            }
            case Remote: {
                f2 = 1.0f;
                f = 1.0f;
                break;
            }
            case RemoteCollide: {
                f3 = 1.0f;
                f = 1.0f;
            }
        }
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), f, f2, f3, f4, 1);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x2, this.poly.y2, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), f, f2, f3, f4, 1);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x3, this.poly.y3, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), f, f2, f3, f4, 1);
        LineDrawer.drawLine(IsoUtils.XToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x4, this.poly.y4, 0.0f, 0), IsoUtils.XToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), IsoUtils.YToScreenExact(this.poly.x1, this.poly.y1, 0.0f, 0), f, f2, f3, f4, 1);
        float f5 = 0.0f;
        if (this.getVehicleTowing() != null) {
            Vector3fObjectPool vector3fObjectPool = TL_vector3f_pool.get();
            Vector3f vector3f = (Vector3f)vector3fObjectPool.alloc();
            Vector3f vector3f2 = this.getTowingWorldPos(this.getTowAttachmentSelf(), vector3f);
            object2 = (Vector3f)vector3fObjectPool.alloc();
            object = this.getVehicleTowing().getTowingWorldPos(this.getVehicleTowing().getTowAttachmentSelf(), (Vector3f)object2);
            if (vector3f2 != null && object != null) {
                LineDrawer.DrawIsoLine(vector3f2.x, vector3f2.y, vector3f2.z, object.x, object.y, object.z, f, f2, f3, f4, 1);
                LineDrawer.DrawIsoCircle(vector3f2.x, vector3f2.y, vector3f2.z, 0.2f, 16, f, f2, f3, f4);
                f5 = IsoUtils.DistanceTo(vector3f2.x, vector3f2.y, vector3f2.z, object.x, object.y, object.z);
            }
            vector3fObjectPool.release(vector3f);
            vector3fObjectPool.release(object2);
        }
        f = 1.0f;
        f2 = 1.0f;
        f3 = 0.75f;
        f4 = 1.0f;
        float f6 = 10.0f;
        float f7 = IsoUtils.XToScreenExact(this.x, this.y, 0.0f, 0);
        float f8 = IsoUtils.YToScreenExact(this.x, this.y, 0.0f, 0);
        object2 = GameClient.IDToPlayerMap.get(this.netPlayerId);
        object = (object2 == null ? "@server" : ((IsoPlayer)object2).getUsername()) + " ( " + this.netPlayerId + " )";
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), "VID: " + this.getScriptName() + " ( " + this.getId() + " )", f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), "PID: " + (String)object, f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), "Auth: " + this.netPlayerAuthorization.name(), f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), "Static/active: " + this.isStatic + "/" + this.isActive, f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), "x=" + this.x + " / y=" + this.y, f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 14.0f), String.format("Passengers: %d/%d", Arrays.stream(this.passengers).filter(passenger -> passenger.character != null).count(), this.passengers.length), f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), String.format("Speed: %s%.3f kmph", this.getCurrentSpeedKmHour() >= 0.0f ? "+" : "", Float.valueOf(this.getCurrentSpeedKmHour())), f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), String.format("Engine speed: %.3f", this.engineSpeed), f, f2, f3, f4);
        TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), String.format("Mass: %.3f/%.3f", Float.valueOf(this.getMass()), Float.valueOf(this.getFudgedMass())), f, f2, f3, f4);
        if (f5 > 1.5f) {
            f2 = 0.75f;
        }
        if (this.getVehicleTowing() != null) {
            TextManager.instance.DrawString(f7, f8 + (f6 += 14.0f), "Towing: " + this.getVehicleTowing().getId(), f, f2, f3, f4);
            TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), String.format("Distance: %.3f", Float.valueOf(f5)), f, f2, f3, f4);
        }
        if (this.getVehicleTowedBy() != null) {
            TextManager.instance.DrawString(f7, f8 + (f6 += 14.0f), "TowedBy: " + this.getVehicleTowedBy().getId(), f, f2, f3, f4);
            TextManager.instance.DrawString(f7, f8 + (f6 += 12.0f), String.format("Distance: %.3f", Float.valueOf(f5)), f, f2, f3, f4);
        }
    }

    private void renderUsableArea() {
        if (this.getScript() == null || !UIManager.VisibleAllUI) {
            return;
        }
        VehiclePart vehiclePart = this.getUseablePart(IsoPlayer.getInstance());
        if (vehiclePart == null) {
            return;
        }
        VehicleScript.Area area = this.getScript().getAreaById(vehiclePart.getArea());
        if (area == null) {
            return;
        }
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        Vector2 vector23 = this.areaPositionWorld(area, vector22);
        if (vector23 == null) {
            TL_vector2_pool.get().release(vector22);
            return;
        }
        Vector3f vector3f = this.getForwardVector((Vector3f)TL_vector3f_pool.get().alloc());
        float f = Core.getInstance().getGoodHighlitedColor().getR();
        float f2 = Core.getInstance().getGoodHighlitedColor().getG();
        float f3 = Core.getInstance().getGoodHighlitedColor().getB();
        this.getController().drawRect(vector3f, vector23.x - WorldSimulation.instance.offsetX, vector23.y - WorldSimulation.instance.offsetY, area.w, area.h / 2.0f, f, f2, f3);
        vector3f.x *= area.h / this.script.getModelScale();
        vector3f.z *= area.h / this.script.getModelScale();
        if (vehiclePart.getDoor() != null && (vehiclePart.getId().contains("Left") || vehiclePart.getId().contains("Right"))) {
            if (vehiclePart.getId().contains("Front")) {
                this.getController().drawRect(vector3f, vector23.x - WorldSimulation.instance.offsetX + vector3f.x * area.h / 2.0f, vector23.y - WorldSimulation.instance.offsetY + vector3f.z * area.h / 2.0f, area.w, area.h / 8.0f, f, f2, f3);
            } else if (vehiclePart.getId().contains("Rear")) {
                this.getController().drawRect(vector3f, vector23.x - WorldSimulation.instance.offsetX - vector3f.x * area.h / 2.0f, vector23.y - WorldSimulation.instance.offsetY - vector3f.z * area.h / 2.0f, area.w, area.h / 8.0f, f, f2, f3);
            }
        }
        TL_vector2_pool.get().release(vector22);
        TL_vector3f_pool.get().release(vector3f);
    }

    private void renderIntersectedSquares() {
        PolygonalMap2.VehiclePoly vehiclePoly = this.getPoly();
        float f = Math.min(vehiclePoly.x1, Math.min(vehiclePoly.x2, Math.min(vehiclePoly.x3, vehiclePoly.x4)));
        float f2 = Math.min(vehiclePoly.y1, Math.min(vehiclePoly.y2, Math.min(vehiclePoly.y3, vehiclePoly.y4)));
        float f3 = Math.max(vehiclePoly.x1, Math.max(vehiclePoly.x2, Math.max(vehiclePoly.x3, vehiclePoly.x4)));
        float f4 = Math.max(vehiclePoly.y1, Math.max(vehiclePoly.y2, Math.max(vehiclePoly.y3, vehiclePoly.y4)));
        for (int i = (int)f2; i < (int)Math.ceil(f4); ++i) {
            for (int j = (int)f; j < (int)Math.ceil(f3); ++j) {
                if (!this.isIntersectingSquare(j, i, (int)this.z)) continue;
                LineDrawer.addLine(j, i, (int)this.z, j + 1, i + 1, (int)this.z, 1.0f, 1.0f, 1.0f, null, false);
            }
        }
    }

    private void renderTrailerPositions() {
        boolean bl;
        Vector3f vector3f;
        if (this.script == null || this.physics == null) {
            return;
        }
        Vector3f vector3f2 = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        Vector3f vector3f4 = this.getTowingWorldPos("trailer", vector3f3);
        if (vector3f4 != null) {
            this.physics.drawCircle(vector3f4.x, vector3f4.y, 0.3f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if ((vector3f = this.getPlayerTrailerLocalPos("trailer", false, vector3f2)) != null) {
            this.getWorldPos(vector3f, vector3f);
            bl = PolygonalMap2.instance.lineClearCollide(vector3f3.x, vector3f3.y, vector3f.x, vector3f.y, (int)this.z, this, false, false);
            this.physics.drawCircle(vector3f.x, vector3f.y, 0.3f, 1.0f, bl ? 0.0f : 1.0f, bl ? 0.0f : 1.0f, 1.0f);
            if (bl) {
                LineDrawer.addLine(vector3f.x, vector3f.y, 0.0f, vector3f3.x, vector3f3.y, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        if ((vector3f = this.getPlayerTrailerLocalPos("trailer", true, vector3f2)) != null) {
            this.getWorldPos(vector3f, vector3f);
            bl = PolygonalMap2.instance.lineClearCollide(vector3f3.x, vector3f3.y, vector3f.x, vector3f.y, (int)this.z, this, false, false);
            this.physics.drawCircle(vector3f.x, vector3f.y, 0.3f, 1.0f, bl ? 0.0f : 1.0f, bl ? 0.0f : 1.0f, 1.0f);
            if (bl) {
                LineDrawer.addLine(vector3f.x, vector3f.y, 0.0f, vector3f3.x, vector3f3.y, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        TL_vector3f_pool.get().release(vector3f2);
        TL_vector3f_pool.get().release(vector3f3);
    }

    public void getWheelForwardVector(int n, Vector3f vector3f) {
        WheelInfo wheelInfo = this.wheelInfo[n];
        Matrix4f matrix4f = (Matrix4f)TL_matrix4f_pool.get().alloc();
        matrix4f.rotationY(wheelInfo.steering);
        Matrix4f matrix4f2 = this.jniTransform.getMatrix((Matrix4f)TL_matrix4f_pool.get().alloc());
        matrix4f2.setTranslation(0.0f, 0.0f, 0.0f);
        matrix4f.mul((Matrix4fc)matrix4f2, matrix4f);
        TL_matrix4f_pool.get().release(matrix4f2);
        TL_matrix4f_pool.get().release(matrix4f);
        matrix4f.getColumn(2, this.tempVector4f);
        vector3f.set(this.tempVector4f.x, 0.0f, this.tempVector4f.z);
    }

    public void tryStartEngine(boolean bl) {
        if (this.getDriver() != null && this.getDriver() instanceof IsoPlayer && ((IsoPlayer)this.getDriver()).isBlockMovement()) {
            return;
        }
        if (this.engineState != engineStateTypes.Idle) {
            return;
        }
        if (Core.bDebug && DebugOptions.instance.CheatVehicleStartWithoutKey.getValue() || SandboxOptions.instance.VehicleEasyUse.getValue() || this.isKeysInIgnition() || bl || this.getDriver().getInventory().haveThisKeyId(this.getKeyId()) != null || this.isHotwired()) {
            this.engineDoStarting();
        } else if (GameServer.bServer) {
            this.getDriver().sendObjectChange("vehicleNoKey");
        } else {
            this.getDriver().SayDebug(" [img=media/ui/CarKey_none.png]");
        }
    }

    public void tryStartEngine() {
        this.tryStartEngine(false);
    }

    public void engineDoIdle() {
        this.engineState = engineStateTypes.Idle;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
    }

    public void engineDoStarting() {
        this.engineState = engineStateTypes.Starting;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
        this.setKeysInIgnition(true);
    }

    public boolean isStarting() {
        return this.engineState == engineStateTypes.Starting || this.engineState == engineStateTypes.StartingFailed || this.engineState == engineStateTypes.StartingSuccess || this.engineState == engineStateTypes.StartingFailedNoPower;
    }

    private String getEngineSound() {
        if (this.getScript() != null && this.getScript().getSounds().engine != null) {
            return this.getScript().getSounds().engine;
        }
        return "VehicleEngineDefault";
    }

    private String getEngineStartSound() {
        if (this.getScript() != null && this.getScript().getSounds().engineStart != null) {
            return this.getScript().getSounds().engineStart;
        }
        return "VehicleStarted";
    }

    private String getEngineTurnOffSound() {
        if (this.getScript() != null && this.getScript().getSounds().engineTurnOff != null) {
            return this.getScript().getSounds().engineTurnOff;
        }
        return "VehicleTurnedOff";
    }

    private String getIgnitionFailSound() {
        if (this.getScript() != null && this.getScript().getSounds().ignitionFail != null) {
            return this.getScript().getSounds().ignitionFail;
        }
        return "VehicleFailingToStart";
    }

    private String getIgnitionFailNoPowerSound() {
        if (this.getScript() != null && this.getScript().getSounds().ignitionFailNoPower != null) {
            return this.getScript().getSounds().ignitionFailNoPower;
        }
        return "VehicleFailingToStartNoPower";
    }

    public void engineDoRetryingStarting() {
        this.getEmitter().stopSoundByName(this.getIgnitionFailSound());
        this.getEmitter().playSoundImpl(this.getIgnitionFailSound(), (IsoObject)null);
        this.engineState = engineStateTypes.RetryingStarting;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
    }

    public void engineDoStartingSuccess() {
        this.getEmitter().stopSoundByName(this.getIgnitionFailSound());
        this.engineState = engineStateTypes.StartingSuccess;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        if (this.getEngineStartSound().equals(this.getEngineSound())) {
            if (!this.getEmitter().isPlaying(this.combinedEngineSound)) {
                this.combinedEngineSound = this.emitter.playSoundImpl(this.getEngineSound(), (IsoObject)null);
            }
        } else {
            this.getEmitter().playSoundImpl(this.getEngineStartSound(), (IsoObject)null);
        }
        this.transmitEngine();
        this.setKeysInIgnition(true);
    }

    public void engineDoStartingFailed() {
        this.getEmitter().stopSoundByName(this.getIgnitionFailSound());
        this.getEmitter().playSoundImpl(this.getIgnitionFailSound(), (IsoObject)null);
        this.stopEngineSounds();
        this.engineState = engineStateTypes.StartingFailed;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
    }

    public void engineDoStartingFailedNoPower() {
        this.getEmitter().stopSoundByName(this.getIgnitionFailNoPowerSound());
        this.getEmitter().playSoundImpl(this.getIgnitionFailNoPowerSound(), (IsoObject)null);
        this.stopEngineSounds();
        this.engineState = engineStateTypes.StartingFailedNoPower;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
    }

    public void engineDoRunning() {
        this.setNeedPartsUpdate(true);
        this.engineState = engineStateTypes.Running;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
    }

    public void engineDoStalling() {
        this.getEmitter().playSoundImpl("VehicleRunningOutOfGas", (IsoObject)null);
        this.engineState = engineStateTypes.Stalling;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.stopEngineSounds();
        this.engineSoundIndex = 0;
        this.transmitEngine();
        if (!Core.getInstance().getOptionLeaveKeyInIgnition()) {
            this.setKeysInIgnition(false);
        }
    }

    public void engineDoShuttingDown() {
        VehiclePart vehiclePart;
        if (!this.getEngineTurnOffSound().equals(this.getEngineSound())) {
            this.getEmitter().playSoundImpl(this.getEngineTurnOffSound(), (IsoObject)null);
        }
        this.stopEngineSounds();
        this.engineSoundIndex = 0;
        this.engineState = engineStateTypes.ShutingDown;
        this.engineLastUpdateStateTime = System.currentTimeMillis();
        this.transmitEngine();
        if (!Core.getInstance().getOptionLeaveKeyInIgnition()) {
            this.setKeysInIgnition(false);
        }
        if ((vehiclePart = this.getHeater()) != null) {
            vehiclePart.getModData().rawset((Object)"active", (Object)false);
        }
    }

    public void shutOff() {
        if (this.getPartById("GasTank").getContainerContentAmount() == 0.0f) {
            this.engineDoStalling();
            return;
        }
        this.engineDoShuttingDown();
    }

    public void resumeRunningAfterLoad() {
        if (GameClient.bClient) {
            IsoGameCharacter isoGameCharacter = this.getDriver();
            if (isoGameCharacter == null) {
                return;
            }
            Boolean bl = this.getDriver().getInventory().haveThisKeyId(this.getKeyId()) != null ? Boolean.TRUE : Boolean.FALSE;
            GameClient.instance.sendClientCommandV((IsoPlayer)this.getDriver(), "vehicle", "startEngine", "haveKey", bl);
            return;
        }
        if (!this.isEngineWorking()) {
            return;
        }
        this.getEmitter();
        this.engineDoStartingSuccess();
    }

    public boolean isEngineStarted() {
        return this.engineState == engineStateTypes.Starting || this.engineState == engineStateTypes.StartingFailed || this.engineState == engineStateTypes.StartingSuccess || this.engineState == engineStateTypes.RetryingStarting;
    }

    public boolean isEngineRunning() {
        return this.engineState == engineStateTypes.Running;
    }

    public boolean isEngineWorking() {
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            String string = vehiclePart.getLuaFunction("checkEngine");
            if (string == null || Boolean.TRUE.equals(this.callLuaBoolean(string, this, vehiclePart))) continue;
            return false;
        }
        return true;
    }

    public boolean isOperational() {
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            String string = vehiclePart.getLuaFunction("checkOperate");
            if (string == null || Boolean.TRUE.equals(this.callLuaBoolean(string, this, vehiclePart))) continue;
            return false;
        }
        return true;
    }

    public boolean isDriveable() {
        if (!this.isEngineWorking()) {
            return false;
        }
        return this.isOperational();
    }

    public BaseSoundEmitter getEmitter() {
        if (this.emitter == null) {
            if (Core.SoundDisabled || GameServer.bServer) {
                this.emitter = new DummySoundEmitter();
            } else {
                FMODSoundEmitter fMODSoundEmitter = new FMODSoundEmitter();
                fMODSoundEmitter.parameterUpdater = this;
                this.emitter = fMODSoundEmitter;
            }
        }
        return this.emitter;
    }

    public long playSoundImpl(String string, IsoObject isoObject) {
        return this.getEmitter().playSoundImpl(string, isoObject);
    }

    public int stopSound(long l) {
        return this.getEmitter().stopSound(l);
    }

    public void playSound(String string) {
        this.getEmitter().playSound(string);
    }

    public void updateSounds() {
        int n;
        if (!GameServer.bServer) {
            if (this.getBatteryCharge() > 0.0f) {
                if (this.lightbarSirenMode.isEnable() && this.soundSirenSignal == -1L) {
                    this.setLightbarSirenMode(this.lightbarSirenMode.get());
                }
            } else if (this.soundSirenSignal != -1L) {
                this.getEmitter().stopSound(this.soundSirenSignal);
                this.soundSirenSignal = -1L;
            }
        }
        IsoPlayer isoPlayer = null;
        float f = Float.MAX_VALUE;
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            IsoPlayer isoPlayer2 = IsoPlayer.players[n];
            if (isoPlayer2 == null || isoPlayer2.getCurrentSquare() == null) continue;
            float f2 = isoPlayer2.getX();
            float f3 = isoPlayer2.getY();
            float f4 = IsoUtils.DistanceToSquared(f2, f3, this.x, this.y);
            if (isoPlayer2.Traits.HardOfHearing.isSet()) {
                f4 *= 4.5f;
            }
            if (isoPlayer2.Traits.Deaf.isSet()) {
                f4 = Float.MAX_VALUE;
            }
            if (!(f4 < f)) continue;
            isoPlayer = isoPlayer2;
            f = f4;
        }
        if (isoPlayer == null) {
            if (this.emitter != null) {
                this.emitter.setPos(this.x, this.y, this.z);
                if (!this.emitter.isEmpty()) {
                    this.emitter.tick();
                }
            }
            return;
        }
        if (!GameServer.bServer) {
            float f5;
            float f6;
            float f7 = f6 = ClimateManager.getInstance().isRaining() ? ClimateManager.getInstance().getPrecipitationIntensity() : 0.0f;
            if (this.getSquare() != null && this.getSquare().isInARoom()) {
                f6 = 0.0f;
            }
            if (this.getEmitter().isPlaying("VehicleAmbiance")) {
                if (f6 == 0.0f) {
                    this.getEmitter().stopOrTriggerSoundByName("VehicleAmbiance");
                }
            } else if (f6 > 0.0f && f < 100.0f) {
                this.emitter.playAmbientLoopedImpl("VehicleAmbiance");
            }
            if ((f5 = f) > 1200.0f) {
                this.stopEngineSounds();
                if (this.emitter != null && !this.emitter.isEmpty()) {
                    this.emitter.setPos(this.x, this.y, this.z);
                    this.emitter.tick();
                }
                return;
            }
            for (int i = 0; i < this.new_EngineSoundId.length; ++i) {
                if (this.new_EngineSoundId[i] == 0L) continue;
                this.getEmitter().setVolume(this.new_EngineSoundId[i], 1.0f - f5 / 1200.0f);
            }
        }
        this.startTime -= GameTime.instance.getMultiplier();
        if (this.getController() == null) {
            return;
        }
        if (GameServer.bServer) {
            return;
        }
        if (this.emitter == null) {
            if (this.engineState != engineStateTypes.Running) {
                return;
            }
            this.getEmitter();
        }
        n = this.isAnyListenerInside() ? 1 : 0;
        float f8 = Math.abs(this.getCurrentSpeedKmHour());
        if (this.startTime <= 0.0f && this.engineState == engineStateTypes.Running && !this.getEmitter().isPlaying(this.combinedEngineSound)) {
            this.combinedEngineSound = this.emitter.playSoundImpl(this.getEngineSound(), (IsoObject)null);
            if (this.getEngineSound().equals(this.getEngineStartSound())) {
                this.emitter.setTimelinePosition(this.combinedEngineSound, "idle");
            }
        }
        boolean bl = false;
        if (!GameClient.bClient || this.isLocalPhysicSim()) {
            for (int i = 0; i < this.script.getWheelCount(); ++i) {
                if (!(this.wheelInfo[i].skidInfo < 0.15f)) continue;
                bl = true;
                break;
            }
        }
        if (this.getDriver() == null) {
            bl = false;
        }
        if (bl != this.skidding) {
            if (bl) {
                this.skidSound = this.getEmitter().playSoundImpl("VehicleSkid", (IsoObject)null);
            } else if (this.skidSound != 0L) {
                this.emitter.stopSound(this.skidSound);
                this.skidSound = 0L;
            }
            this.skidding = bl;
        }
        if (this.soundBackMoveSignal != -1L && this.emitter != null) {
            this.emitter.set3D(this.soundBackMoveSignal, n == 0);
        }
        if (this.soundHorn != -1L && this.emitter != null) {
            this.emitter.set3D(this.soundHorn, n == 0);
        }
        if (this.soundSirenSignal != -1L && this.emitter != null) {
            this.emitter.set3D(this.soundSirenSignal, n == 0);
        }
        if (!(this.emitter == null || this.engineState == engineStateTypes.Idle && this.emitter.isEmpty())) {
            this.getFMODParameters().update();
            this.emitter.setPos(this.x, this.y, this.z);
            this.emitter.tick();
        }
    }

    private boolean updatePart(VehiclePart vehiclePart) {
        String string;
        vehiclePart.updateSignalDevice();
        VehicleLight vehicleLight = vehiclePart.getLight();
        if (vehicleLight != null && vehiclePart.getId().contains("Headlight")) {
            vehiclePart.setLightActive(this.getHeadlightsOn() && vehiclePart.getInventoryItem() != null && this.getBatteryCharge() > 0.0f);
        }
        if ((string = vehiclePart.getLuaFunction("update")) == null) {
            return false;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (vehiclePart.getLastUpdated() < 0.0f) {
            vehiclePart.setLastUpdated(f);
        } else if (vehiclePart.getLastUpdated() > f) {
            vehiclePart.setLastUpdated(f);
        }
        float f2 = f - vehiclePart.getLastUpdated();
        if ((int)(f2 * 60.0f) > 0) {
            vehiclePart.setLastUpdated(f);
            this.callLuaVoid(string, this, vehiclePart, f2 * 60.0f);
            return true;
        }
        return false;
    }

    public void updateParts() {
        if (GameClient.bClient) {
            for (int i = 0; i < this.getPartCount(); ++i) {
                VehiclePart vehiclePart = this.getPartByIndex(i);
                vehiclePart.updateSignalDevice();
            }
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.getPartCount(); ++i) {
            VehiclePart vehiclePart = this.getPartByIndex(i);
            if (this.updatePart(vehiclePart) && !bl) {
                bl = true;
            }
            if (i != this.getPartCount() - 1 || !bl) continue;
            this.brakeBetweenUpdatesSpeed = 0.0f;
        }
    }

    public void drainBatteryUpdateHack() {
        boolean bl = this.isEngineRunning();
        if (bl) {
            return;
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.getDeviceData() != null && vehiclePart.getDeviceData().getIsTurnedOn()) {
                this.updatePart(vehiclePart);
                continue;
            }
            if (vehiclePart.getLight() == null || !vehiclePart.getLight().getActive()) continue;
            this.updatePart(vehiclePart);
        }
        if (this.hasLightbar() && (this.lightbarLightsMode.isEnable() || this.lightbarSirenMode.isEnable()) && this.getBattery() != null) {
            this.updatePart(this.getBattery());
        }
    }

    public boolean getHeadlightsOn() {
        return this.headlightsOn;
    }

    public void setHeadlightsOn(boolean bl) {
        if (this.headlightsOn == bl) {
            return;
        }
        this.headlightsOn = bl;
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 8);
        } else {
            this.playSound(this.headlightsOn ? "VehicleHeadlightsOn" : "VehicleHeadlightsOff");
        }
    }

    public boolean getWindowLightsOn() {
        return this.windowLightsOn;
    }

    public void setWindowLightsOn(boolean bl) {
        this.windowLightsOn = bl;
    }

    public boolean getHeadlightCanEmmitLight() {
        if (this.getBatteryCharge() <= 0.0f) {
            return false;
        }
        VehiclePart vehiclePart = this.getPartById("HeadlightLeft");
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            return true;
        }
        vehiclePart = this.getPartById("HeadlightRight");
        return vehiclePart != null && vehiclePart.getInventoryItem() != null;
    }

    public boolean getStoplightsOn() {
        return this.stoplightsOn;
    }

    public void setStoplightsOn(boolean bl) {
        if (this.stoplightsOn == bl) {
            return;
        }
        this.stoplightsOn = bl;
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 8);
        }
    }

    public boolean hasHeadlights() {
        return this.getLightCount() > 0;
    }

    @Override
    public void addToWorld() {
        if (this.addedToWorld) {
            DebugLog.General.error("added vehicle twice " + this + " id=" + this.VehicleID);
            return;
        }
        VehiclesDB2.instance.setVehicleLoaded(this);
        this.addedToWorld = true;
        this.removedFromWorld = false;
        super.addToWorld();
        this.createPhysics();
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.getItemContainer() != null) {
                vehiclePart.getItemContainer().addItemsToProcessItems();
            }
            if (vehiclePart.getDeviceData() == null || GameServer.bServer) continue;
            ZomboidRadio.getInstance().RegisterDevice(vehiclePart);
        }
        if (this.lightbarSirenMode.isEnable()) {
            this.setLightbarSirenMode(this.lightbarSirenMode.get());
            if (this.sirenStartTime <= 0.0) {
                this.sirenStartTime = GameTime.instance.getWorldAgeHours();
            }
        }
        if (this.chunk != null && this.chunk.jobType != IsoChunk.JobType.SoftReset) {
            PolygonalMap2.instance.addVehicleToWorld(this);
        }
        if (this.engineState != engineStateTypes.Idle) {
            double d = this.engineSpeed = this.getScript() == null ? 1000.0 : (double)this.getScript().getEngineIdleSpeed();
        }
        if (this.chunk != null && this.chunk.jobType != IsoChunk.JobType.SoftReset) {
            this.trySpawnKey();
        }
        if (this.emitter != null) {
            SoundManager.instance.registerEmitter(this.emitter);
        }
    }

    @Override
    public void removeFromWorld() {
        int n;
        this.breakConstraint(false, false);
        VehiclesDB2.instance.setVehicleUnloaded(this);
        for (n = 0; n < this.passengers.length; ++n) {
            if (this.getPassenger((int)n).character == null) continue;
            for (int i = 0; i < 4; ++i) {
                if (this.getPassenger((int)n).character != IsoPlayer.players[i]) continue;
                return;
            }
        }
        IsoChunk.removeFromCheckedVehicles(this);
        DebugLog.Vehicle.trace("BaseVehicle.removeFromWorld() %s id=%d", this, this.VehicleID);
        if (this.removedFromWorld) {
            return;
        }
        if (!this.addedToWorld) {
            DebugLog.Vehicle.debugln("ERROR: removing vehicle but addedToWorld=false %s id=%d", this, this.VehicleID);
        }
        this.removedFromWorld = true;
        this.addedToWorld = false;
        for (n = 0; n < this.parts.size(); ++n) {
            VehiclePart vehiclePart = this.parts.get(n);
            if (vehiclePart.getItemContainer() != null) {
                vehiclePart.getItemContainer().removeItemsFromProcessItems();
            }
            if (vehiclePart.getDeviceData() == null || GameServer.bServer) continue;
            ZomboidRadio.getInstance().UnRegisterDevice(vehiclePart);
        }
        if (this.emitter != null) {
            this.emitter.stopAll();
            SoundManager.instance.unregisterEmitter(this.emitter);
            this.emitter = null;
        }
        if (this.hornemitter != null && this.soundHorn != -1L) {
            this.hornemitter.stopAll();
            this.soundHorn = -1L;
        }
        if (this.createdModel) {
            ModelManager.instance.Remove(this);
            this.createdModel = false;
        }
        this.releaseAnimationPlayers();
        if (this.getController() != null) {
            if (!GameServer.bServer) {
                Bullet.removeVehicle(this.VehicleID);
            }
            this.physics = null;
        }
        if (GameServer.bServer || GameClient.bClient) {
            VehicleManager.instance.removeFromWorld(this);
        } else if (this.VehicleID != -1) {
            VehicleIDMap.instance.remove(this.VehicleID);
        }
        IsoWorld.instance.CurrentCell.addVehicles.remove(this);
        IsoWorld.instance.CurrentCell.vehicles.remove(this);
        PolygonalMap2.instance.removeVehicleFromWorld(this);
        if (GameClient.bClient) {
            this.chunk.vehicles.remove(this);
        }
        this.m_surroundVehicle.reset();
        this.removeWorldLights();
        super.removeFromWorld();
    }

    public void permanentlyRemove() {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            IsoGameCharacter isoGameCharacter = this.getCharacter(i);
            if (isoGameCharacter == null) continue;
            if (GameServer.bServer) {
                isoGameCharacter.sendObjectChange("exitVehicle");
            }
            this.exit(isoGameCharacter);
        }
        this.breakConstraint(true, false);
        this.removeFromWorld();
        this.removeFromSquare();
        if (this.chunk != null) {
            this.chunk.vehicles.remove(this);
        }
        VehiclesDB2.instance.removeVehicle(this);
    }

    public VehiclePart getBattery() {
        return this.battery;
    }

    public void setEngineFeature(int n, int n2, int n3) {
        this.engineQuality = PZMath.clamp(n, 0, 100);
        this.engineLoudness = (int)((float)n2 / 2.7f);
        this.enginePower = n3;
    }

    public int getEngineQuality() {
        return this.engineQuality;
    }

    public int getEngineLoudness() {
        return this.engineLoudness;
    }

    public int getEnginePower() {
        return this.enginePower;
    }

    public float getBatteryCharge() {
        VehiclePart vehiclePart = this.getBattery();
        if (vehiclePart != null && vehiclePart.getInventoryItem() instanceof DrainableComboItem) {
            return ((DrainableComboItem)vehiclePart.getInventoryItem()).getUsedDelta();
        }
        return 0.0f;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public VehiclePart getPartByIndex(int n) {
        if (n < 0 || n >= this.parts.size()) {
            return null;
        }
        return this.parts.get(n);
    }

    public VehiclePart getPartById(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            VehicleScript.Part part = vehiclePart.getScriptPart();
            if (part == null || !string.equals(part.id)) continue;
            return vehiclePart;
        }
        return null;
    }

    public int getNumberOfPartsWithContainers() {
        if (this.getScript() == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.getScript().getPartCount(); ++i) {
            if (this.getScript().getPart((int)i).container == null) continue;
            ++n;
        }
        return n;
    }

    public VehiclePart getPartForSeatContainer(int n) {
        if (this.getScript() == null || n < 0 || n >= this.getMaxPassengers()) {
            return null;
        }
        for (int i = 0; i < this.getPartCount(); ++i) {
            VehiclePart vehiclePart = this.getPartByIndex(i);
            if (vehiclePart.getContainerSeatNumber() != n) continue;
            return vehiclePart;
        }
        return null;
    }

    public void transmitPartCondition(VehiclePart vehiclePart) {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x800);
        this.updateFlags = (short)(this.updateFlags | 0x800);
    }

    public void transmitPartItem(VehiclePart vehiclePart) {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x80);
        this.updateFlags = (short)(this.updateFlags | 0x80);
    }

    public void transmitPartModData(VehiclePart vehiclePart) {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x10);
        this.updateFlags = (short)(this.updateFlags | 0x10);
    }

    public void transmitPartUsedDelta(VehiclePart vehiclePart) {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        if (!(vehiclePart.getInventoryItem() instanceof DrainableComboItem)) {
            return;
        }
        vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x20);
        this.updateFlags = (short)(this.updateFlags | 0x20);
    }

    public void transmitPartDoor(VehiclePart vehiclePart) {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        if (vehiclePart.getDoor() == null) {
            return;
        }
        vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x200);
        this.updateFlags = (short)(this.updateFlags | 0x200);
    }

    public void transmitPartWindow(VehiclePart vehiclePart) {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.parts.contains(vehiclePart)) {
            return;
        }
        if (vehiclePart.getWindow() == null) {
            return;
        }
        vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x100);
        this.updateFlags = (short)(this.updateFlags | 0x100);
    }

    public int getLightCount() {
        return this.lights.size();
    }

    public VehiclePart getLightByIndex(int n) {
        if (n < 0 || n >= this.lights.size()) {
            return null;
        }
        return this.lights.get(n);
    }

    public String getZone() {
        return this.respawnZone;
    }

    public void setZone(String string) {
        this.respawnZone = string;
    }

    public boolean isInArea(String string, IsoGameCharacter isoGameCharacter) {
        if (string == null || this.getScript() == null) {
            return false;
        }
        VehicleScript.Area area = this.getScript().getAreaById(string);
        if (area == null) {
            return false;
        }
        Vector2 vector22 = (Vector2)TL_vector2_pool.get().alloc();
        Vector2 vector23 = this.areaPositionLocal(area, vector22);
        if (vector23 == null) {
            TL_vector2_pool.get().release(vector22);
            return false;
        }
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        this.getLocalPos(isoGameCharacter.x, isoGameCharacter.y, this.z, vector3f);
        float f = vector23.x - area.w / 2.0f;
        float f2 = vector23.y - area.h / 2.0f;
        float f3 = vector23.x + area.w / 2.0f;
        float f4 = vector23.y + area.h / 2.0f;
        TL_vector2_pool.get().release(vector22);
        boolean bl = vector3f.x >= f && vector3f.x < f3 && vector3f.z >= f2 && vector3f.z < f4;
        TL_vector3f_pool.get().release(vector3f);
        return bl;
    }

    public float getAreaDist(String string, IsoGameCharacter isoGameCharacter) {
        if (string == null || this.getScript() == null) {
            return 999.0f;
        }
        VehicleScript.Area area = this.getScript().getAreaById(string);
        if (area != null) {
            Vector3f vector3f = this.getLocalPos(isoGameCharacter.x, isoGameCharacter.y, this.z, (Vector3f)TL_vector3f_pool.get().alloc());
            float f = Math.abs(area.x - area.w / 2.0f);
            float f2 = Math.abs(area.y - area.h / 2.0f);
            float f3 = Math.abs(area.x + area.w / 2.0f);
            float f4 = Math.abs(area.y + area.h / 2.0f);
            float f5 = Math.abs(vector3f.x + f) + Math.abs(vector3f.z + f2);
            TL_vector3f_pool.get().release(vector3f);
            return f5;
        }
        return 999.0f;
    }

    public Vector2 getAreaCenter(String string) {
        return this.getAreaCenter(string, new Vector2());
    }

    public Vector2 getAreaCenter(String string, Vector2 vector22) {
        if (string == null || this.getScript() == null) {
            return null;
        }
        VehicleScript.Area area = this.getScript().getAreaById(string);
        if (area == null) {
            return null;
        }
        return this.areaPositionWorld(area, vector22);
    }

    public boolean isInBounds(float f, float f2) {
        return this.getPoly().containsPoint(f, f2);
    }

    public boolean canAccessContainer(int n, IsoGameCharacter isoGameCharacter) {
        VehiclePart vehiclePart = this.getPartByIndex(n);
        if (vehiclePart == null) {
            return false;
        }
        VehicleScript.Part part = vehiclePart.getScriptPart();
        if (part == null) {
            return false;
        }
        if (part.container == null) {
            return false;
        }
        if (vehiclePart.isInventoryItemUninstalled() && part.container.capacity == 0) {
            return false;
        }
        if (part.container.luaTest == null || part.container.luaTest.isEmpty()) {
            return true;
        }
        return Boolean.TRUE.equals(this.callLuaBoolean(part.container.luaTest, this, vehiclePart, isoGameCharacter));
    }

    public boolean canInstallPart(IsoGameCharacter isoGameCharacter, VehiclePart vehiclePart) {
        if (!this.parts.contains(vehiclePart)) {
            return false;
        }
        KahluaTable kahluaTable = vehiclePart.getTable("install");
        if (kahluaTable == null || !(kahluaTable.rawget((Object)"test") instanceof String)) {
            return false;
        }
        return Boolean.TRUE.equals(this.callLuaBoolean((String)kahluaTable.rawget((Object)"test"), this, vehiclePart, isoGameCharacter));
    }

    public boolean canUninstallPart(IsoGameCharacter isoGameCharacter, VehiclePart vehiclePart) {
        if (!this.parts.contains(vehiclePart)) {
            return false;
        }
        KahluaTable kahluaTable = vehiclePart.getTable("uninstall");
        if (kahluaTable == null || !(kahluaTable.rawget((Object)"test") instanceof String)) {
            return false;
        }
        return Boolean.TRUE.equals(this.callLuaBoolean((String)kahluaTable.rawget((Object)"test"), this, vehiclePart, isoGameCharacter));
    }

    private void callLuaVoid(String string, Object object, Object object2) {
        Object object3 = LuaManager.getFunctionObject(string);
        if (object3 == null) {
            return;
        }
        LuaManager.caller.protectedCallVoid(LuaManager.thread, object3, object, object2);
    }

    private void callLuaVoid(String string, Object object, Object object2, Object object3) {
        Object object4 = LuaManager.getFunctionObject(string);
        if (object4 == null) {
            return;
        }
        LuaManager.caller.protectedCallVoid(LuaManager.thread, object4, object, object2, object3);
    }

    private Boolean callLuaBoolean(String string, Object object, Object object2) {
        Object object3 = LuaManager.getFunctionObject(string);
        if (object3 == null) {
            return null;
        }
        return LuaManager.caller.protectedCallBoolean(LuaManager.thread, object3, object, object2);
    }

    private Boolean callLuaBoolean(String string, Object object, Object object2, Object object3) {
        Object object4 = LuaManager.getFunctionObject(string);
        if (object4 == null) {
            return null;
        }
        return LuaManager.caller.protectedCallBoolean(LuaManager.thread, object4, object, object2, object3);
    }

    public short getId() {
        return this.VehicleID;
    }

    public void setTireInflation(int n, float f) {
    }

    public void setTireRemoved(int n, boolean bl) {
        if (!GameServer.bServer) {
            Bullet.setTireRemoved(this.VehicleID, n, bl);
        }
    }

    public Vector3f chooseBestAttackPosition(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2, Vector3f vector3f) {
        Vector2f vector2f = (Vector2f)TL_vector2f_pool.get().alloc();
        Vector2f vector2f2 = isoGameCharacter.getVehicle().getSurroundVehicle().getPositionForZombie((IsoZombie)isoGameCharacter2, vector2f);
        float f = vector2f.x;
        float f2 = vector2f.y;
        TL_vector2f_pool.get().release(vector2f);
        if (vector2f2 != null) {
            return vector3f.set(f, f2, this.z);
        }
        return null;
    }

    public MinMaxPosition getMinMaxPosition() {
        MinMaxPosition minMaxPosition = new MinMaxPosition();
        float f = this.getX();
        float f2 = this.getY();
        Vector3f vector3f = this.getScript().getExtents();
        float f3 = vector3f.x;
        float f4 = vector3f.z;
        IsoDirections isoDirections = this.getDir();
        switch (isoDirections) {
            case E: 
            case W: {
                minMaxPosition.minX = f - f3 / 2.0f;
                minMaxPosition.maxX = f + f3 / 2.0f;
                minMaxPosition.minY = f2 - f4 / 2.0f;
                minMaxPosition.maxY = f2 + f4 / 2.0f;
                break;
            }
            case N: 
            case S: {
                minMaxPosition.minX = f - f4 / 2.0f;
                minMaxPosition.maxX = f + f4 / 2.0f;
                minMaxPosition.minY = f2 - f3 / 2.0f;
                minMaxPosition.maxY = f2 + f3 / 2.0f;
                break;
            }
            default: {
                return null;
            }
        }
        return minMaxPosition;
    }

    public String getVehicleType() {
        return this.type;
    }

    public void setVehicleType(String string) {
        this.type = string;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f) {
        this.maxSpeed = f;
    }

    public void lockServerUpdate(long l) {
        this.updateLockTimeout = System.currentTimeMillis() + l;
    }

    public void changeTransmission(TransmissionNumber transmissionNumber) {
        this.transmissionNumber = transmissionNumber;
    }

    public void tryHotwire(int n) {
        int n2 = Math.max(100 - this.getEngineQuality(), 5);
        n2 = Math.min(n2, 50);
        int n3 = n * 4;
        int n4 = n2 + n3;
        boolean bl = false;
        String string = null;
        if (Rand.Next(100) <= 11 - n && this.alarmed) {
            this.triggerAlarm();
        }
        if (Rand.Next(100) <= n4) {
            this.setHotwired(true);
            bl = true;
            string = "VehicleHotwireSuccess";
        } else if (Rand.Next(100) <= 10 - n) {
            this.setHotwiredBroken(true);
            bl = true;
            string = "VehicleHotwireFail";
        } else {
            string = "VehicleHotwireFail";
        }
        if (string != null) {
            if (GameServer.bServer) {
                LuaManager.GlobalObject.playServerSound(string, this.square);
            } else if (this.getDriver() != null) {
                this.getDriver().getEmitter().playSound(string);
            }
        }
        if (bl && GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x1000);
        }
    }

    public void cheatHotwire(boolean bl, boolean bl2) {
        if (bl != this.hotwired || bl2 != this.hotwiredBroken) {
            this.hotwired = bl;
            this.hotwiredBroken = bl2;
            if (GameServer.bServer) {
                this.updateFlags = (short)(this.updateFlags | 0x1000);
            }
        }
    }

    public boolean isKeyIsOnDoor() {
        return this.keyIsOnDoor;
    }

    public void setKeyIsOnDoor(boolean bl) {
        this.keyIsOnDoor = bl;
    }

    public boolean isHotwired() {
        return this.hotwired;
    }

    public void setHotwired(boolean bl) {
        this.hotwired = bl;
    }

    public boolean isHotwiredBroken() {
        return this.hotwiredBroken;
    }

    public void setHotwiredBroken(boolean bl) {
        this.hotwiredBroken = bl;
    }

    public IsoGameCharacter getDriver() {
        Passenger passenger = this.getPassenger(0);
        return passenger == null ? null : passenger.character;
    }

    public boolean isKeysInIgnition() {
        return this.keysInIgnition;
    }

    public void setKeysInIgnition(boolean bl) {
        IsoGameCharacter isoGameCharacter = this.getDriver();
        if (isoGameCharacter == null) {
            return;
        }
        this.setAlarmed(false);
        if (!(!GameClient.bClient || isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer())) {
            return;
        }
        if (!this.isHotwired()) {
            Object object;
            InventoryItem inventoryItem;
            if (!GameServer.bServer && bl && !this.keysInIgnition && (inventoryItem = this.getDriver().getInventory().haveThisKeyId(this.getKeyId())) != null) {
                this.setCurrentKey(inventoryItem);
                object = inventoryItem.getContainer().getContainingItem();
                if (object instanceof InventoryContainer && "KeyRing".equals(((InventoryItem)object).getType())) {
                    inventoryItem.getModData().rawset((Object)"keyRing", (Object)((InventoryItem)object).getID());
                } else if (inventoryItem.hasModData()) {
                    inventoryItem.getModData().rawset((Object)"keyRing", null);
                }
                inventoryItem.getContainer().DoRemoveItem(inventoryItem);
                this.keysInIgnition = bl;
                if (GameClient.bClient) {
                    GameClient.instance.sendClientCommandV((IsoPlayer)this.getDriver(), "vehicle", "putKeyInIgnition", "key", inventoryItem);
                }
            }
            if (!bl && this.keysInIgnition && !GameServer.bServer) {
                if (this.currentKey == null) {
                    this.currentKey = this.createVehicleKey();
                }
                inventoryItem = this.getCurrentKey();
                object = this.getDriver().getInventory();
                if (inventoryItem.hasModData() && inventoryItem.getModData().rawget((Object)"keyRing") instanceof Double) {
                    Double d = (Double)inventoryItem.getModData().rawget((Object)"keyRing");
                    InventoryItem inventoryItem2 = ((ItemContainer)object).getItemWithID(d.intValue());
                    if (inventoryItem2 instanceof InventoryContainer && "KeyRing".equals(inventoryItem2.getType())) {
                        object = ((InventoryContainer)inventoryItem2).getInventory();
                    }
                    inventoryItem.getModData().rawset((Object)"keyRing", null);
                }
                ((ItemContainer)object).addItem(inventoryItem);
                this.setCurrentKey(null);
                this.keysInIgnition = bl;
                if (GameClient.bClient) {
                    GameClient.instance.sendClientCommand((IsoPlayer)this.getDriver(), "vehicle", "removeKeyFromIgnition", null);
                }
            }
        }
    }

    public void putKeyInIgnition(InventoryItem inventoryItem) {
        if (!GameServer.bServer) {
            return;
        }
        if (!(inventoryItem instanceof Key)) {
            return;
        }
        if (this.keysInIgnition) {
            return;
        }
        this.keysInIgnition = true;
        this.keyIsOnDoor = false;
        this.currentKey = inventoryItem;
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void removeKeyFromIgnition() {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.keysInIgnition) {
            return;
        }
        this.keysInIgnition = false;
        this.currentKey = null;
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void putKeyOnDoor(InventoryItem inventoryItem) {
        if (!GameServer.bServer) {
            return;
        }
        if (!(inventoryItem instanceof Key)) {
            return;
        }
        if (this.keyIsOnDoor) {
            return;
        }
        this.keyIsOnDoor = true;
        this.keysInIgnition = false;
        this.currentKey = inventoryItem;
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void removeKeyFromDoor() {
        if (!GameServer.bServer) {
            return;
        }
        if (!this.keyIsOnDoor) {
            return;
        }
        this.keyIsOnDoor = false;
        this.currentKey = null;
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void syncKeyInIgnition(boolean bl, boolean bl2, InventoryItem inventoryItem) {
        if (!GameClient.bClient) {
            return;
        }
        if (this.getDriver() instanceof IsoPlayer && ((IsoPlayer)this.getDriver()).isLocalPlayer()) {
            return;
        }
        this.keysInIgnition = bl;
        this.keyIsOnDoor = bl2;
        this.currentKey = inventoryItem;
    }

    private void randomizeContainers() {
        Object object;
        int n;
        if (GameClient.bClient) {
            return;
        }
        boolean bl = true;
        String string = this.getScriptName().substring(this.getScriptName().indexOf(46) + 1);
        ItemPickerJava.VehicleDistribution vehicleDistribution = (ItemPickerJava.VehicleDistribution)ItemPickerJava.VehicleDistributions.get((Object)(string + this.getSkinIndex()));
        if (vehicleDistribution != null) {
            bl = false;
        } else {
            vehicleDistribution = (ItemPickerJava.VehicleDistribution)ItemPickerJava.VehicleDistributions.get((Object)string);
        }
        if (vehicleDistribution == null) {
            for (int i = 0; i < this.parts.size(); ++i) {
                VehiclePart vehiclePart = this.parts.get(i);
                if (vehiclePart.getItemContainer() == null) continue;
                if (Core.bDebug) {
                    DebugLog.log("VEHICLE MISSING CONT DISTRIBUTION: " + string);
                }
                return;
            }
            return;
        }
        Object object2 = bl && Rand.Next(100) <= 8 && !vehicleDistribution.Specific.isEmpty() ? PZArrayUtil.pickRandom(vehicleDistribution.Specific) : vehicleDistribution.Normal;
        if (!StringUtils.isNullOrWhitespace(this.specificDistributionId)) {
            for (n = 0; n < vehicleDistribution.Specific.size(); ++n) {
                object = vehicleDistribution.Specific.get(n);
                if (!this.specificDistributionId.equals(((ItemPickerJava.ItemPickerRoom)object).specificId)) continue;
                object2 = object;
                break;
            }
        }
        for (n = 0; n < this.parts.size(); ++n) {
            object = this.parts.get(n);
            if (((VehiclePart)object).getItemContainer() == null) continue;
            if (GameServer.bServer && GameServer.bSoftReset) {
                ((VehiclePart)object).getItemContainer().setExplored(false);
            }
            if (((VehiclePart)object).getItemContainer().bExplored) continue;
            ((VehiclePart)object).getItemContainer().clear();
            if (Rand.Next(100) <= 100) {
                this.randomizeContainer((VehiclePart)object, (ItemPickerJava.ItemPickerRoom)object2);
                LuaEventManager.triggerEvent("OnFillContainer", string, ((VehiclePart)object).getItemContainer().getType(), ((VehiclePart)object).getItemContainer());
            }
            ((VehiclePart)object).getItemContainer().setExplored(true);
        }
    }

    private void randomizeContainer(VehiclePart vehiclePart, ItemPickerJava.ItemPickerRoom itemPickerRoom) {
        if (GameClient.bClient) {
            return;
        }
        if (itemPickerRoom == null) {
            return;
        }
        if (!vehiclePart.getId().contains("Seat") && !itemPickerRoom.Containers.containsKey((Object)vehiclePart.getId())) {
            DebugLog.log("NO CONT DISTRIB FOR PART: " + vehiclePart.getId() + " CAR: " + this.getScriptName().replaceFirst("Base.", ""));
        }
        ItemPickerJava.fillContainerType(itemPickerRoom, vehiclePart.getItemContainer(), "", null);
        if (!GameServer.bServer || !vehiclePart.getItemContainer().getItems().isEmpty()) {
            // empty if block
        }
    }

    public boolean hasHorn() {
        return this.script.getSounds().hornEnable;
    }

    public boolean hasLightbar() {
        VehiclePart vehiclePart = this.getPartById("lightbar");
        return this.script.getLightbar().enable;
    }

    public void onHornStart() {
        this.soundHornOn = true;
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x400);
            if (this.script.getSounds().hornEnable) {
                WorldSoundManager.instance.addSound(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), 150, 150, false);
            }
            return;
        }
        if (this.soundHorn != -1L) {
            this.hornemitter.stopSound(this.soundHorn);
        }
        if (this.script.getSounds().hornEnable) {
            this.hornemitter = IsoWorld.instance.getFreeEmitter(this.getX(), this.getY(), (int)this.getZ());
            this.soundHorn = this.hornemitter.playSoundLoopedImpl(this.script.getSounds().horn);
            this.hornemitter.set3D(this.soundHorn, !this.isAnyListenerInside());
            this.hornemitter.setVolume(this.soundHorn, 1.0f);
            this.hornemitter.setPitch(this.soundHorn, 1.0f);
            if (!GameClient.bClient) {
                WorldSoundManager.instance.addSound(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), 150, 150, false);
            }
        }
    }

    public void onHornStop() {
        this.soundHornOn = false;
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x400);
            return;
        }
        if (this.script.getSounds().hornEnable && this.soundHorn != -1L) {
            this.hornemitter.stopSound(this.soundHorn);
            this.soundHorn = -1L;
        }
    }

    public boolean hasBackSignal() {
        return this.script != null && this.script.getSounds().backSignalEnable;
    }

    public boolean isBackSignalEmitting() {
        return this.soundBackMoveSignal != -1L;
    }

    public void onBackMoveSignalStart() {
        this.soundBackMoveOn = true;
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x400);
            return;
        }
        if (this.soundBackMoveSignal != -1L) {
            this.emitter.stopSound(this.soundBackMoveSignal);
        }
        if (this.script.getSounds().backSignalEnable) {
            this.soundBackMoveSignal = this.emitter.playSoundLoopedImpl(this.script.getSounds().backSignal);
            this.emitter.set3D(this.soundBackMoveSignal, !this.isAnyListenerInside());
        }
    }

    public void onBackMoveSignalStop() {
        this.soundBackMoveOn = false;
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x400);
            return;
        }
        if (this.script.getSounds().backSignalEnable && this.soundBackMoveSignal != -1L) {
            this.emitter.stopSound(this.soundBackMoveSignal);
            this.soundBackMoveSignal = -1L;
        }
    }

    public int getLightbarLightsMode() {
        return this.lightbarLightsMode.get();
    }

    public void setLightbarLightsMode(int n) {
        this.lightbarLightsMode.set(n);
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x400);
            return;
        }
    }

    public int getLightbarSirenMode() {
        return this.lightbarSirenMode.get();
    }

    public void setLightbarSirenMode(int n) {
        if (this.soundSirenSignal != -1L) {
            this.getEmitter().stopSound(this.soundSirenSignal);
            this.soundSirenSignal = -1L;
        }
        this.lightbarSirenMode.set(n);
        if (GameServer.bServer) {
            this.updateFlags = (short)(this.updateFlags | 0x400);
            return;
        }
        if (this.lightbarSirenMode.isEnable() && this.getBatteryCharge() > 0.0f) {
            this.soundSirenSignal = this.getEmitter().playSoundLoopedImpl(this.lightbarSirenMode.getSoundName(this.script.getLightbar()));
            this.getEmitter().set3D(this.soundSirenSignal, !this.isAnyListenerInside());
        }
    }

    public HashMap<String, String> getChoosenParts() {
        return this.choosenParts;
    }

    public float getMass() {
        float f = this.mass;
        if (f < 0.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void setMass(float f) {
        this.mass = f;
    }

    public float getInitialMass() {
        return this.initialMass;
    }

    public void setInitialMass(float f) {
        this.initialMass = f;
    }

    public void updateTotalMass() {
        float f = 0.0f;
        for (int i = 0; i < this.parts.size(); ++i) {
            VehiclePart vehiclePart = this.parts.get(i);
            if (vehiclePart.getItemContainer() != null) {
                f += vehiclePart.getItemContainer().getCapacityWeight();
            }
            if (vehiclePart.getInventoryItem() == null) continue;
            f += vehiclePart.getInventoryItem().getWeight();
        }
        this.setMass(Math.round(this.getInitialMass() + f));
        if (this.physics != null && !GameServer.bServer) {
            Bullet.setVehicleMass(this.VehicleID, this.getMass());
        }
    }

    public float getBrakingForce() {
        return this.brakingForce;
    }

    public void setBrakingForce(float f) {
        this.brakingForce = f;
    }

    public float getBaseQuality() {
        return this.baseQuality;
    }

    public void setBaseQuality(float f) {
        this.baseQuality = f;
    }

    public float getCurrentSteering() {
        return this.currentSteering;
    }

    public void setCurrentSteering(float f) {
        this.currentSteering = f;
    }

    public boolean isDoingOffroad() {
        if (this.getCurrentSquare() == null) {
            return false;
        }
        IsoObject isoObject = this.getCurrentSquare().getFloor();
        if (isoObject == null || isoObject.getSprite() == null) {
            return false;
        }
        String string = isoObject.getSprite().getName();
        if (string == null) {
            return false;
        }
        return !string.contains("carpentry_02") && !string.contains("blends_street") && !string.contains("floors_exterior_street");
    }

    public boolean isBraking() {
        return this.isBraking;
    }

    public void setBraking(boolean bl) {
        this.isBraking = bl;
        if (bl && this.brakeBetweenUpdatesSpeed == 0.0f) {
            this.brakeBetweenUpdatesSpeed = Math.abs(this.getCurrentSpeedKmHour());
        }
    }

    public void updatePartStats() {
        this.setBrakingForce(0.0f);
        this.engineLoudness = (int)((double)this.getScript().getEngineLoudness() * SandboxOptions.instance.ZombieAttractionMultiplier.getValue() / 2.0);
        boolean bl = false;
        for (int i = 0; i < this.getPartCount(); ++i) {
            float f;
            VehiclePart vehiclePart = this.getPartByIndex(i);
            if (vehiclePart.getInventoryItem() == null) continue;
            if (vehiclePart.getInventoryItem().getBrakeForce() > 0.0f) {
                f = VehiclePart.getNumberByCondition(vehiclePart.getInventoryItem().getBrakeForce(), vehiclePart.getInventoryItem().getCondition(), 5.0f);
                f += f / 50.0f * (float)vehiclePart.getMechanicSkillInstaller();
                this.setBrakingForce(this.getBrakingForce() + f);
            }
            if (vehiclePart.getInventoryItem().getWheelFriction() > 0.0f) {
                vehiclePart.setWheelFriction(0.0f);
                f = VehiclePart.getNumberByCondition(vehiclePart.getInventoryItem().getWheelFriction(), vehiclePart.getInventoryItem().getCondition(), 0.2f);
                f += 0.1f * (float)vehiclePart.getMechanicSkillInstaller();
                f = Math.min(2.3f, f);
                vehiclePart.setWheelFriction(f);
            }
            if (vehiclePart.getInventoryItem().getSuspensionCompression() > 0.0f) {
                vehiclePart.setSuspensionCompression(VehiclePart.getNumberByCondition(vehiclePart.getInventoryItem().getSuspensionCompression(), vehiclePart.getInventoryItem().getCondition(), 0.6f));
                vehiclePart.setSuspensionDamping(VehiclePart.getNumberByCondition(vehiclePart.getInventoryItem().getSuspensionDamping(), vehiclePart.getInventoryItem().getCondition(), 0.6f));
            }
            if (!(vehiclePart.getInventoryItem().getEngineLoudness() > 0.0f)) continue;
            vehiclePart.setEngineLoudness(VehiclePart.getNumberByCondition(vehiclePart.getInventoryItem().getEngineLoudness(), vehiclePart.getInventoryItem().getCondition(), 10.0f));
            this.engineLoudness = (int)((float)this.engineLoudness * (1.0f + (100.0f - vehiclePart.getEngineLoudness()) / 100.0f));
            bl = true;
        }
        if (!bl) {
            this.engineLoudness *= 2;
        }
    }

    public void transmitEngine() {
        if (!GameServer.bServer) {
            return;
        }
        this.updateFlags = (short)(this.updateFlags | 4);
    }

    public void setRust(float f) {
        this.rust = PZMath.clamp(f, 0.0f, 1.0f);
    }

    public float getRust() {
        return this.rust;
    }

    public void transmitRust() {
        if (!GameServer.bServer) {
            return;
        }
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void transmitColorHSV() {
        if (!GameServer.bServer) {
            return;
        }
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void transmitSkinIndex() {
        if (!GameServer.bServer) {
            return;
        }
        this.updateFlags = (short)(this.updateFlags | 0x1000);
    }

    public void updateBulletStats() {
        float f;
        double d;
        if (this.getScriptName().contains("Burnt") || !WorldSimulation.instance.created) {
            return;
        }
        float[] fArray = wheelParams;
        double d2 = 2.4;
        int n = 5;
        if (this.isInForest() && this.isDoingOffroad() && Math.abs(this.getCurrentSpeedKmHour()) > 1.0f) {
            d = Rand.Next(0.08f, 0.18f);
            f = 0.7f;
            n = 3;
        } else if (this.isDoingOffroad() && Math.abs(this.getCurrentSpeedKmHour()) > 1.0f) {
            d = Rand.Next(0.05f, 0.15f);
            f = 0.7f;
        } else {
            d = Math.abs(this.getCurrentSpeedKmHour()) > 1.0f && Rand.Next(100) < 10 ? (double)Rand.Next(0.05f, 0.15f) : 0.0;
            f = 1.0f;
        }
        if (RainManager.isRaining().booleanValue()) {
            f -= 0.3f;
        }
        Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
        for (int i = 0; i < this.script.getWheelCount(); ++i) {
            this.updateBulletStatsWheel(i, fArray, vector3f, f, n, d2, d);
        }
        TL_vector3f_pool.get().release(vector3f);
        if (SystemDisabler.getdoVehicleLowRider() && this.isKeyboardControlled()) {
            float f2 = 1.6f;
            float f3 = 1.0f;
            lowRiderParam[0] = GameKeyboard.isKeyDown(79) ? lowRiderParam[0] + (f2 - lowRiderParam[0]) * f3 : lowRiderParam[0] + (0.0f - lowRiderParam[0]) * 0.05f;
            lowRiderParam[1] = GameKeyboard.isKeyDown(80) ? lowRiderParam[1] + (f2 - lowRiderParam[1]) * f3 : lowRiderParam[1] + (0.0f - lowRiderParam[1]) * 0.05f;
            lowRiderParam[2] = GameKeyboard.isKeyDown(75) ? lowRiderParam[2] + (f2 - lowRiderParam[2]) * f3 : lowRiderParam[2] + (0.0f - lowRiderParam[2]) * 0.05f;
            lowRiderParam[3] = GameKeyboard.isKeyDown(76) ? lowRiderParam[3] + (f2 - lowRiderParam[3]) * f3 : lowRiderParam[3] + (0.0f - lowRiderParam[3]) * 0.05f;
            fArray[23] = lowRiderParam[0];
            fArray[22] = lowRiderParam[1];
            fArray[21] = lowRiderParam[2];
            fArray[20] = lowRiderParam[3];
        }
        Bullet.setVehicleParams(this.VehicleID, fArray);
    }

    private void updateBulletStatsWheel(int n, float[] fArray, Vector3f vector3f, float f, int n2, double d, double d2) {
        int n3 = n * 6;
        VehicleScript.Wheel wheel = this.script.getWheel(n);
        Vector3f vector3f2 = this.getWorldPos(wheel.offset.x, wheel.offset.y, wheel.offset.z, vector3f);
        VehiclePart vehiclePart = this.getPartById("Tire" + wheel.getId());
        VehiclePart vehiclePart2 = this.getPartById("Suspension" + wheel.getId());
        if (vehiclePart != null && vehiclePart.getInventoryItem() != null) {
            fArray[n3 + 0] = 1.0f;
            fArray[n3 + 1] = Math.min(vehiclePart.getContainerContentAmount() / (float)(vehiclePart.getContainerCapacity() - 10), 1.0f);
            fArray[n3 + 2] = f * vehiclePart.getWheelFriction();
            if (vehiclePart2 != null && vehiclePart2.getInventoryItem() != null) {
                fArray[n3 + 3] = vehiclePart2.getSuspensionDamping();
                fArray[n3 + 4] = vehiclePart2.getSuspensionCompression();
            } else {
                fArray[n3 + 3] = 0.1f;
                fArray[n3 + 4] = 0.1f;
            }
            fArray[n3 + 5] = Rand.Next(n2) == 0 ? (float)(Math.sin(d * (double)vector3f2.x()) * Math.sin(d * (double)vector3f2.y()) * d2) : 0.0f;
        } else {
            fArray[n3 + 0] = 0.0f;
            fArray[n3 + 1] = 30.0f;
            fArray[n3 + 2] = 0.0f;
            fArray[n3 + 3] = 2.88f;
            fArray[n3 + 4] = 3.83f;
            fArray[n3 + 5] = Rand.Next(n2) == 0 ? (float)(Math.sin(d * (double)vector3f2.x()) * Math.sin(d * (double)vector3f2.y()) * d2) : 0.0f;
        }
        if (this.forcedFriction > -1.0f) {
            fArray[n3 + 2] = this.forcedFriction;
        }
    }

    public void setActiveInBullet(boolean bl) {
        if (!bl && this.isEngineRunning()) {
            return;
        }
    }

    public boolean areAllDoorsLocked() {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            VehiclePart vehiclePart = this.getPassengerDoor(i);
            if (vehiclePart == null || vehiclePart.getDoor() == null || vehiclePart.getDoor().isLocked()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyDoorLocked() {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            VehiclePart vehiclePart = this.getPassengerDoor(i);
            if (vehiclePart == null || vehiclePart.getDoor() == null || !vehiclePart.getDoor().isLocked()) continue;
            return true;
        }
        return false;
    }

    public float getRemainingFuelPercentage() {
        VehiclePart vehiclePart = this.getPartById("GasTank");
        if (vehiclePart == null) {
            return 0.0f;
        }
        return vehiclePart.getContainerContentAmount() / (float)vehiclePart.getContainerCapacity() * 100.0f;
    }

    public int getMechanicalID() {
        return this.mechanicalID;
    }

    public void setMechanicalID(int n) {
        this.mechanicalID = n;
    }

    public boolean needPartsUpdate() {
        return this.needPartsUpdate;
    }

    public void setNeedPartsUpdate(boolean bl) {
        this.needPartsUpdate = bl;
    }

    public VehiclePart getHeater() {
        return this.getPartById("Heater");
    }

    public int windowsOpen() {
        int n = 0;
        for (int i = 0; i < this.getPartCount(); ++i) {
            VehiclePart vehiclePart = this.getPartByIndex(i);
            if (vehiclePart.window == null || !vehiclePart.window.open) continue;
            ++n;
        }
        return n;
    }

    public boolean isAlarmed() {
        return this.alarmed;
    }

    public void setAlarmed(boolean bl) {
        this.alarmed = bl;
        if (bl) {
            this.setPreviouslyEntered(false);
        }
    }

    public void triggerAlarm() {
        if (!this.alarmed) {
            return;
        }
        this.alarmed = false;
        this.alarmTime = Rand.Next(1500, 3000);
        this.alarmAccumulator = 0.0f;
    }

    private void doAlarm() {
        if (this.alarmTime > 0) {
            if (this.getBatteryCharge() <= 0.0f) {
                if (this.soundHornOn) {
                    this.onHornStop();
                }
                this.alarmTime = -1;
                return;
            }
            this.alarmAccumulator += GameTime.instance.getMultiplier() / 1.6f;
            if (this.alarmAccumulator >= (float)this.alarmTime) {
                this.onHornStop();
                this.setHeadlightsOn(false);
                this.alarmTime = -1;
                return;
            }
            int n = (int)this.alarmAccumulator / 20;
            if (!this.soundHornOn && n % 2 == 0) {
                this.onHornStart();
                this.setHeadlightsOn(true);
            }
            if (this.soundHornOn && n % 2 == 1) {
                this.onHornStop();
                this.setHeadlightsOn(false);
            }
        }
    }

    public boolean isMechanicUIOpen() {
        return this.mechanicUIOpen;
    }

    public void setMechanicUIOpen(boolean bl) {
        this.mechanicUIOpen = bl;
    }

    public void damagePlayers(float f) {
        if (!SandboxOptions.instance.PlayerDamageFromCrash.getValue()) {
            return;
        }
        if (GameClient.bClient) {
            return;
        }
        for (int i = 0; i < this.passengers.length; ++i) {
            if (this.getPassenger((int)i).character == null) continue;
            IsoGameCharacter isoGameCharacter = this.getPassenger((int)i).character;
            if (GameServer.bServer && isoGameCharacter instanceof IsoPlayer) {
                GameServer.sendPlayerDamagedByCarCrash((IsoPlayer)isoGameCharacter, f);
                continue;
            }
            this.addRandomDamageFromCrash(isoGameCharacter, f);
            LuaEventManager.triggerEvent("OnPlayerGetDamage", isoGameCharacter, "CARCRASHDAMAGE", Float.valueOf(f));
        }
    }

    public void addRandomDamageFromCrash(IsoGameCharacter isoGameCharacter, float f) {
        int n;
        int n2 = 1;
        if (f > 40.0f) {
            n2 = Rand.Next(1, 3);
        }
        if (f > 70.0f) {
            n2 = Rand.Next(2, 4);
        }
        int n3 = 0;
        for (n = 0; n < isoGameCharacter.getVehicle().getPartCount(); ++n) {
            VehiclePart vehiclePart = isoGameCharacter.getVehicle().getPartByIndex(n);
            if (vehiclePart.window == null || vehiclePart.getCondition() >= 15) continue;
            ++n3;
        }
        for (n = 0; n < n2; ++n) {
            int n4 = Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.MAX));
            BodyPart bodyPart = isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n4));
            float f2 = Math.max(Rand.Next(f - 15.0f, f), 5.0f);
            if (isoGameCharacter.Traits.FastHealer.isSet()) {
                f2 = (float)((double)f2 * 0.8);
            } else if (isoGameCharacter.Traits.SlowHealer.isSet()) {
                f2 = (float)((double)f2 * 1.2);
            }
            switch (SandboxOptions.instance.InjurySeverity.getValue()) {
                case 1: {
                    f2 *= 0.5f;
                    break;
                }
                case 3: {
                    f2 *= 1.5f;
                }
            }
            f2 *= this.getScript().getPlayerDamageProtection();
            f2 = (float)((double)f2 * 0.9);
            bodyPart.AddDamage(f2);
            if (f2 > 40.0f && Rand.Next(12) == 0) {
                bodyPart.generateDeepWound();
            } else if (f2 > 50.0f && Rand.Next(10) == 0 && SandboxOptions.instance.BoneFracture.getValue()) {
                if (bodyPart.getType() == BodyPartType.Neck || bodyPart.getType() == BodyPartType.Groin) {
                    bodyPart.generateDeepWound();
                } else {
                    bodyPart.setFractureTime(Rand.Next(Rand.Next(10.0f, f2 + 10.0f), Rand.Next(f2 + 20.0f, f2 + 30.0f)));
                }
            }
            if (!(f2 > 30.0f) || Rand.Next(12 - n3) != 0) continue;
            bodyPart = isoGameCharacter.getBodyDamage().setScratchedWindow();
            if (Rand.Next(5) != 0) continue;
            bodyPart.generateDeepWound();
            bodyPart.setHaveGlass(true);
        }
    }

    public void hitVehicle(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        VehiclePart vehiclePart;
        float f = 1.0f;
        if (handWeapon == null) {
            handWeapon = (HandWeapon)InventoryItemFactory.CreateItem("Base.BareHands");
        }
        f = handWeapon.getDoorDamage();
        if (isoGameCharacter.isCriticalHit()) {
            f *= 10.0f;
        }
        if ((vehiclePart = this.getNearestBodyworkPart(isoGameCharacter)) != null) {
            VehicleWindow vehicleWindow = vehiclePart.getWindow();
            for (int i = 0; i < vehiclePart.getChildCount(); ++i) {
                VehiclePart vehiclePart2 = vehiclePart.getChild(i);
                if (vehiclePart2.getWindow() == null) continue;
                vehicleWindow = vehiclePart2.getWindow();
                break;
            }
            if (vehicleWindow != null && vehicleWindow.getHealth() > 0) {
                vehicleWindow.damage((int)f);
                this.transmitPartWindow(vehiclePart);
                if (vehicleWindow.getHealth() == 0) {
                    VehicleManager.sendSoundFromServer(this, (byte)1);
                }
            } else {
                vehiclePart.setCondition(vehiclePart.getCondition() - (int)f);
                this.transmitPartItem(vehiclePart);
            }
            vehiclePart.updateFlags = (short)(vehiclePart.updateFlags | 0x800);
            this.updateFlags = (short)(this.updateFlags | 0x800);
        } else {
            Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
            this.getLocalPos(isoGameCharacter.getX(), isoGameCharacter.getY(), isoGameCharacter.getZ(), vector3f);
            boolean bl = vector3f.x > 0.0f;
            TL_vector3f_pool.get().release(vector3f);
            if (bl) {
                this.addDamageFront((int)f);
            } else {
                this.addDamageRear((int)f);
            }
            this.updateFlags = (short)(this.updateFlags | 0x800);
        }
    }

    public boolean isTrunkLocked() {
        VehiclePart vehiclePart = this.getPartById("TrunkDoor");
        if (vehiclePart == null) {
            vehiclePart = this.getPartById("DoorRear");
        }
        if (vehiclePart != null && vehiclePart.getDoor() != null && vehiclePart.getInventoryItem() != null) {
            return vehiclePart.getDoor().isLocked();
        }
        return false;
    }

    public void setTrunkLocked(boolean bl) {
        VehiclePart vehiclePart = this.getPartById("TrunkDoor");
        if (vehiclePart == null) {
            vehiclePart = this.getPartById("DoorRear");
        }
        if (vehiclePart != null && vehiclePart.getDoor() != null && vehiclePart.getInventoryItem() != null) {
            vehiclePart.getDoor().setLocked(bl);
            if (GameServer.bServer) {
                this.transmitPartDoor(vehiclePart);
            }
        }
    }

    public VehiclePart getNearestBodyworkPart(IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < this.getPartCount(); ++i) {
            VehiclePart vehiclePart = this.getPartByIndex(i);
            if (!"door".equals(vehiclePart.getCategory()) && !"bodywork".equals(vehiclePart.getCategory()) || !this.isInArea(vehiclePart.getArea(), isoGameCharacter) || vehiclePart.getCondition() <= 0) continue;
            return vehiclePart;
        }
        return null;
    }

    public double getSirenStartTime() {
        return this.sirenStartTime;
    }

    public void setSirenStartTime(double d) {
        this.sirenStartTime = d;
    }

    public boolean sirenShutoffTimeExpired() {
        double d = SandboxOptions.instance.SirenShutoffHours.getValue();
        if (d <= 0.0) {
            return false;
        }
        double d2 = GameTime.instance.getWorldAgeHours();
        if (this.sirenStartTime > d2) {
            this.sirenStartTime = d2;
        }
        return this.sirenStartTime + d < d2;
    }

    public void repair() {
        for (int i = 0; i < this.getPartCount(); ++i) {
            VehiclePart vehiclePart = this.getPartByIndex(i);
            vehiclePart.repair();
        }
        this.rust = 0.0f;
        this.transmitRust();
        this.bloodIntensity.clear();
        this.transmitBlood();
        this.doBloodOverlay();
    }

    public boolean isAnyListenerInside() {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            IsoGameCharacter isoGameCharacter = this.getCharacter(i);
            if (!(isoGameCharacter instanceof IsoPlayer) || !((IsoPlayer)isoGameCharacter).isLocalPlayer() || isoGameCharacter.Traits.Deaf.isSet()) continue;
            return true;
        }
        return false;
    }

    public boolean couldCrawlerAttackPassenger(IsoGameCharacter isoGameCharacter) {
        int n = this.getSeat(isoGameCharacter);
        if (n == -1) {
            return false;
        }
        return false;
    }

    public boolean isGoodCar() {
        return this.isGoodCar;
    }

    public void setGoodCar(boolean bl) {
        this.isGoodCar = bl;
    }

    public InventoryItem getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(InventoryItem inventoryItem) {
        this.currentKey = inventoryItem;
    }

    public boolean isInForest() {
        return this.getSquare() != null && this.getSquare().getZone() != null && ("Forest".equals(this.getSquare().getZone().getType()) || "DeepForest".equals(this.getSquare().getZone().getType()) || "FarmLand".equals(this.getSquare().getZone().getType()));
    }

    public float getOffroadEfficiency() {
        if (this.isInForest()) {
            return this.script.getOffroadEfficiency() * 1.5f;
        }
        return this.script.getOffroadEfficiency() * 2.0f;
    }

    public void doChrHitImpulse(IsoObject isoObject) {
        float f = 22.0f;
        Vector3f vector3f = this.getLinearVelocity((Vector3f)TL_vector3f_pool.get().alloc());
        vector3f.y = 0.0f;
        Vector3f vector3f2 = (Vector3f)TL_vector3f_pool.get().alloc();
        vector3f2.set(this.x - isoObject.getX(), 0.0f, this.z - isoObject.getY());
        vector3f2.normalize();
        vector3f.mul((Vector3fc)vector3f2);
        TL_vector3f_pool.get().release(vector3f2);
        float f2 = vector3f.length();
        f2 = Math.min(f2, f);
        if (f2 < 0.05f) {
            TL_vector3f_pool.get().release(vector3f);
            return;
        }
        if (GameServer.bServer) {
            if (isoObject instanceof IsoZombie) {
                ((IsoZombie)isoObject).setThumpFlag(1);
            }
        } else {
            SoundManager.instance.PlayWorldSound("ZombieThumpGeneric", isoObject.square, 0.0f, 20.0f, 0.9f, true);
        }
        Vector3f vector3f3 = (Vector3f)TL_vector3f_pool.get().alloc();
        vector3f3.set(this.x - isoObject.getX(), 0.0f, this.y - isoObject.getY());
        vector3f3.normalize();
        vector3f.normalize();
        float f3 = vector3f.dot((Vector3fc)vector3f3);
        TL_vector3f_pool.get().release(vector3f);
        TL_vector3f_pool.get().release(vector3f3);
        this.ApplyImpulse(isoObject, this.getFudgedMass() * 3.0f * f2 / f * Math.abs(f3));
    }

    public boolean isDoColor() {
        return this.doColor;
    }

    public void setDoColor(boolean bl) {
        this.doColor = bl;
    }

    public float getBrakeSpeedBetweenUpdate() {
        return this.brakeBetweenUpdatesSpeed;
    }

    @Override
    public IsoGridSquare getSquare() {
        return this.getCell().getGridSquare(this.x, this.y, this.z);
    }

    public void setColor(float f, float f2, float f3) {
        this.colorValue = f;
        this.colorSaturation = f2;
        this.colorHue = f3;
    }

    public void setColorHSV(float f, float f2, float f3) {
        this.colorHue = f;
        this.colorSaturation = f2;
        this.colorValue = f3;
    }

    public float getColorHue() {
        return this.colorHue;
    }

    public float getColorSaturation() {
        return this.colorSaturation;
    }

    public float getColorValue() {
        return this.colorValue;
    }

    public boolean isRemovedFromWorld() {
        return this.removedFromWorld;
    }

    public float getInsideTemperature() {
        VehiclePart vehiclePart = this.getPartById("PassengerCompartment");
        float f = 0.0f;
        if (vehiclePart != null && vehiclePart.getModData() != null) {
            if (vehiclePart.getModData().rawget((Object)"temperature") != null) {
                f += ((Double)vehiclePart.getModData().rawget((Object)"temperature")).floatValue();
            }
            if (vehiclePart.getModData().rawget((Object)"windowtemperature") != null) {
                f += ((Double)vehiclePart.getModData().rawget((Object)"windowtemperature")).floatValue();
            }
        }
        return f;
    }

    public AnimationPlayer getAnimationPlayer() {
        String string = this.getScript().getModel().file;
        Model model = ModelManager.instance.getLoadedModel(string);
        if (model == null || model.bStatic) {
            return null;
        }
        if (this.m_animPlayer != null && this.m_animPlayer.getModel() != model) {
            this.m_animPlayer = Pool.tryRelease(this.m_animPlayer);
        }
        if (this.m_animPlayer == null) {
            this.m_animPlayer = AnimationPlayer.alloc(model);
        }
        return this.m_animPlayer;
    }

    public void releaseAnimationPlayers() {
        this.m_animPlayer = Pool.tryRelease(this.m_animPlayer);
        PZArrayUtil.forEach(this.models, ModelInfo::releaseAnimationPlayer);
    }

    public void setAddThumpWorldSound(boolean bl) {
        this.bAddThumpWorldSound = bl;
    }

    @Override
    public void Thump(IsoMovingObject isoMovingObject) {
        VehiclePart vehiclePart;
        VehiclePart vehiclePart2 = this.getPartById("lightbar");
        if (vehiclePart2 == null) {
            return;
        }
        if (vehiclePart2.getCondition() <= 0) {
            isoMovingObject.setThumpTarget(null);
        }
        if ((vehiclePart = this.getUseablePart((IsoGameCharacter)isoMovingObject)) != null) {
            vehiclePart.setCondition(vehiclePart.getCondition() - Rand.Next(1, 5));
        }
        vehiclePart2.setCondition(vehiclePart2.getCondition() - Rand.Next(1, 5));
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        return null;
    }

    @Override
    public float getThumpCondition() {
        return 1.0f;
    }

    public boolean isRegulator() {
        return this.regulator;
    }

    public void setRegulator(boolean bl) {
        this.regulator = bl;
    }

    public float getRegulatorSpeed() {
        return this.regulatorSpeed;
    }

    public void setRegulatorSpeed(float f) {
        this.regulatorSpeed = f;
    }

    public float getCurrentSpeedForRegulator() {
        return (float)Math.max(5.0 * Math.floor(this.jniSpeed / 5.0f), 5.0);
    }

    public void setVehicleTowing(BaseVehicle baseVehicle, String string, String string2) {
        this.vehicleTowing = baseVehicle;
        this.vehicleTowingID = this.vehicleTowing == null ? -1 : this.vehicleTowing.getSqlId();
        this.towAttachmentSelf = string;
        this.towAttachmentOther = string2;
        this.towConstraintZOffset = 0.0f;
    }

    public void setVehicleTowedBy(BaseVehicle baseVehicle, String string, String string2) {
        this.vehicleTowedBy = baseVehicle;
        this.vehicleTowedByID = this.vehicleTowedBy == null ? -1 : this.vehicleTowedBy.getSqlId();
        this.towAttachmentSelf = string2;
        this.towAttachmentOther = string;
        this.towConstraintZOffset = 0.0f;
    }

    public BaseVehicle getVehicleTowing() {
        return this.vehicleTowing;
    }

    public BaseVehicle getVehicleTowedBy() {
        return this.vehicleTowedBy;
    }

    public boolean attachmentExist(String string) {
        VehicleScript vehicleScript = this.getScript();
        if (vehicleScript == null) {
            return false;
        }
        ModelAttachment modelAttachment = vehicleScript.getAttachmentById(string);
        return modelAttachment != null;
    }

    public Vector3f getAttachmentLocalPos(String string, Vector3f vector3f) {
        VehicleScript vehicleScript = this.getScript();
        if (vehicleScript == null) {
            return null;
        }
        ModelAttachment modelAttachment = vehicleScript.getAttachmentById(string);
        if (modelAttachment == null) {
            return null;
        }
        vector3f.set((Vector3fc)modelAttachment.getOffset());
        if (vehicleScript.getModel() == null) {
            return vector3f;
        }
        return vector3f.add((Vector3fc)vehicleScript.getModel().getOffset());
    }

    public Vector3f getAttachmentWorldPos(String string, Vector3f vector3f) {
        return (vector3f = this.getAttachmentLocalPos(string, vector3f)) == null ? null : this.getWorldPos(vector3f, vector3f);
    }

    public void setForceBrake() {
        this.getController().clientControls.forceBrake = System.currentTimeMillis();
    }

    public Vector3f getTowingLocalPos(String string, Vector3f vector3f) {
        return this.getAttachmentLocalPos(string, vector3f);
    }

    public Vector3f getTowedByLocalPos(String string, Vector3f vector3f) {
        return this.getAttachmentLocalPos(string, vector3f);
    }

    public Vector3f getTowingWorldPos(String string, Vector3f vector3f) {
        return (vector3f = this.getTowingLocalPos(string, vector3f)) == null ? null : this.getWorldPos(vector3f, vector3f);
    }

    public Vector3f getTowedByWorldPos(String string, Vector3f vector3f) {
        return (vector3f = this.getTowedByLocalPos(string, vector3f)) == null ? null : this.getWorldPos(vector3f, vector3f);
    }

    public Vector3f getPlayerTrailerLocalPos(String string, boolean bl, Vector3f vector3f) {
        ModelAttachment modelAttachment = this.getScript().getAttachmentById(string);
        if (modelAttachment == null) {
            return null;
        }
        Vector3f vector3f2 = this.getScript().getExtents();
        Vector3f vector3f3 = this.getScript().getCenterOfMassOffset();
        float f = vector3f3.x + vector3f2.x / 2.0f + 0.3f + 0.05f;
        if (!bl) {
            f *= -1.0f;
        }
        if (modelAttachment.getOffset().z > 0.0f) {
            return vector3f.set(f, 0.0f, vector3f3.z + vector3f2.z / 2.0f + 0.3f + 0.05f);
        }
        return vector3f.set(f, 0.0f, vector3f3.z - (vector3f2.z / 2.0f + 0.3f + 0.05f));
    }

    public Vector3f getPlayerTrailerWorldPos(String string, boolean bl, Vector3f vector3f) {
        if ((vector3f = this.getPlayerTrailerLocalPos(string, bl, vector3f)) == null) {
            return null;
        }
        this.getWorldPos(vector3f, vector3f);
        vector3f.z = (int)this.z;
        Vector3f vector3f2 = this.getTowingWorldPos(string, (Vector3f)TL_vector3f_pool.get().alloc());
        boolean bl2 = PolygonalMap2.instance.lineClearCollide(vector3f.x, vector3f.y, vector3f2.x, vector3f2.y, (int)this.z, this, false, false);
        TL_vector3f_pool.get().release(vector3f2);
        if (bl2) {
            return null;
        }
        return vector3f;
    }

    private void drawTowingRope() {
        BaseVehicle baseVehicle = this.getVehicleTowing();
        if (baseVehicle == null) {
            return;
        }
        Vector3fObjectPool vector3fObjectPool = TL_vector3f_pool.get();
        Vector3f vector3f = this.getAttachmentWorldPos("trailer", (Vector3f)vector3fObjectPool.alloc());
        Vector3f vector3f2 = this.getAttachmentWorldPos("trailerfront", (Vector3f)vector3fObjectPool.alloc());
        ModelAttachment modelAttachment = this.script.getAttachmentById("trailerfront");
        if (modelAttachment != null) {
            vector3f2.set((Vector3fc)modelAttachment.getOffset());
        }
        Vector2 vector22 = new Vector2();
        vector22.x = baseVehicle.x;
        vector22.y = baseVehicle.y;
        vector22.x -= this.x;
        vector22.y -= this.y;
        vector22.setLength(2.0f);
        this.drawDirectionLine(vector22, vector22.getLength(), 1.0f, 0.5f, 0.5f);
    }

    public void drawDirectionLine(Vector2 vector22, float f, float f2, float f3, float f4) {
        float f5 = this.x + vector22.x * f;
        float f6 = this.y + vector22.y * f;
        float f7 = IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
        float f8 = IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
        float f9 = IsoUtils.XToScreenExact(f5, f6, this.z, 0);
        float f10 = IsoUtils.YToScreenExact(f5, f6, this.z, 0);
        LineDrawer.drawLine(f7, f8, f9, f10, f2, f3, f4, 0.5f, 1);
    }

    public void addPointConstraint(IsoPlayer isoPlayer, BaseVehicle baseVehicle, String string, String string2) {
        this.addPointConstraint(isoPlayer, baseVehicle, string, string2, false);
    }

    public void addPointConstraint(IsoPlayer isoPlayer, BaseVehicle baseVehicle, String string, String string2, Boolean bl) {
        if (baseVehicle == null || isoPlayer != null && (IsoUtils.DistanceToSquared(isoPlayer.x, isoPlayer.y, this.x, this.y) > 100.0f || IsoUtils.DistanceToSquared(isoPlayer.x, isoPlayer.y, baseVehicle.x, baseVehicle.y) > 100.0f)) {
            DebugLog.General.warn("The " + isoPlayer.getUsername() + " user attached vehicles at a long distance");
        }
        BaseVehicle baseVehicle2 = this;
        baseVehicle2.breakConstraint(true, bl);
        baseVehicle.breakConstraint(true, bl);
        Vector3fObjectPool vector3fObjectPool = TL_vector3f_pool.get();
        Vector3f vector3f = baseVehicle2.getTowingLocalPos(string, (Vector3f)vector3fObjectPool.alloc());
        Vector3f vector3f2 = baseVehicle.getTowedByLocalPos(string2, (Vector3f)vector3fObjectPool.alloc());
        if (vector3f == null || vector3f2 == null) {
            if (vector3f != null) {
                vector3fObjectPool.release(vector3f);
            }
            if (vector3f2 != null) {
                vector3fObjectPool.release(vector3f2);
            }
            return;
        }
        if (!GameServer.bServer) {
            baseVehicle2.constraintTowing = baseVehicle2.getScriptName().contains("Trailer") || baseVehicle.getScriptName().contains("Trailer") ? Bullet.addPointConstraint(baseVehicle2.VehicleID, baseVehicle.VehicleID, vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z) : Bullet.addRopeConstraint(baseVehicle2.VehicleID, baseVehicle.VehicleID, vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z, 1.5f);
        }
        baseVehicle.constraintTowing = baseVehicle2.constraintTowing;
        baseVehicle2.setVehicleTowing(baseVehicle, string, string2);
        baseVehicle.setVehicleTowedBy(baseVehicle2, string, string2);
        vector3fObjectPool.release(vector3f);
        vector3fObjectPool.release(vector3f2);
        baseVehicle2.constraintChanged();
        baseVehicle.constraintChanged();
        if (GameServer.bServer && isoPlayer != null && baseVehicle2.netPlayerAuthorization == Authorization.Server && baseVehicle.netPlayerAuthorization == Authorization.Server) {
            baseVehicle2.setNetPlayerAuthorization(Authorization.LocalCollide, isoPlayer.OnlineID);
            baseVehicle2.authSimulationTime = System.currentTimeMillis();
            baseVehicle.setNetPlayerAuthorization(Authorization.LocalCollide, isoPlayer.OnlineID);
            baseVehicle.authSimulationTime = System.currentTimeMillis();
        }
        if (GameServer.bServer && !bl.booleanValue()) {
            VehicleManager.instance.sendTowing(baseVehicle2, baseVehicle, string, string2);
        }
    }

    public void authorizationChanged(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter != null) {
            this.setNetPlayerAuthorization(Authorization.Local, isoGameCharacter.getOnlineID());
        } else {
            this.setNetPlayerAuthorization(Authorization.Server, -1);
        }
    }

    public void constraintChanged() {
        long l = System.currentTimeMillis();
        this.setPhysicsActive(true);
        this.constraintChangedTime = l;
        if (GameServer.bServer) {
            if (this.getVehicleTowing() != null) {
                this.authorizationChanged(this.getDriver());
                this.getVehicleTowing().authorizationChanged(this.getDriver());
            } else if (this.getVehicleTowedBy() != null) {
                this.authorizationChanged(this.getVehicleTowedBy().getDriver());
                this.getVehicleTowedBy().authorizationChanged(this.getVehicleTowedBy().getDriver());
            } else {
                this.authorizationChanged(this.getDriver());
            }
        }
    }

    public void breakConstraint(boolean bl, boolean bl2) {
        if (!GameServer.bServer && this.constraintTowing == -1) {
            return;
        }
        if (!GameServer.bServer) {
            Bullet.removeConstraint(this.constraintTowing);
        }
        this.constraintTowing = -1;
        if (this.vehicleTowing != null) {
            if (GameServer.bServer && !bl2) {
                VehicleManager.instance.sendDetachTowing(this, this.vehicleTowing);
            }
            this.vehicleTowing.vehicleTowedBy = null;
            this.vehicleTowing.constraintTowing = -1;
            if (bl) {
                this.vehicleTowingID = -1;
                this.vehicleTowing.vehicleTowedByID = -1;
            }
            this.vehicleTowing.constraintChanged();
            this.vehicleTowing = null;
        }
        if (this.vehicleTowedBy != null) {
            if (GameServer.bServer && !bl2) {
                VehicleManager.instance.sendDetachTowing(this.vehicleTowedBy, this);
            }
            this.vehicleTowedBy.vehicleTowing = null;
            this.vehicleTowedBy.constraintTowing = -1;
            if (bl) {
                this.vehicleTowedBy.vehicleTowingID = -1;
                this.vehicleTowedByID = -1;
            }
            this.vehicleTowedBy.constraintChanged();
            this.vehicleTowedBy = null;
        }
        this.constraintChanged();
    }

    public boolean canAttachTrailer(BaseVehicle baseVehicle, String string, String string2) {
        return this.canAttachTrailer(baseVehicle, string, string2, false);
    }

    public boolean canAttachTrailer(BaseVehicle baseVehicle, String string, String string2, boolean bl) {
        boolean bl2;
        BaseVehicle baseVehicle2 = this;
        if (baseVehicle2 == baseVehicle || baseVehicle2.physics == null || baseVehicle2.constraintTowing != -1) {
            return false;
        }
        if (baseVehicle == null || baseVehicle.physics == null || baseVehicle.constraintTowing != -1) {
            return false;
        }
        Vector3fObjectPool vector3fObjectPool = TL_vector3f_pool.get();
        Vector3f vector3f = baseVehicle2.getTowingWorldPos(string, (Vector3f)vector3fObjectPool.alloc());
        Vector3f vector3f2 = baseVehicle.getTowedByWorldPos(string2, (Vector3f)vector3fObjectPool.alloc());
        if (vector3f == null || vector3f2 == null) {
            return false;
        }
        float f = IsoUtils.DistanceToSquared(vector3f.x, vector3f.y, 0.0f, vector3f2.x, vector3f2.y, 0.0f);
        vector3fObjectPool.release(vector3f);
        vector3fObjectPool.release(vector3f2);
        ModelAttachment modelAttachment = baseVehicle2.script.getAttachmentById(string);
        ModelAttachment modelAttachment2 = baseVehicle.script.getAttachmentById(string2);
        if (modelAttachment != null && modelAttachment.getCanAttach() != null && !modelAttachment.getCanAttach().contains(string2)) {
            return false;
        }
        if (modelAttachment2 != null && modelAttachment2.getCanAttach() != null && !modelAttachment2.getCanAttach().contains(string)) {
            return false;
        }
        DebugLog.Vehicle.trace("vidA=%d (%s) vidB=%d (%s) dist: %f", baseVehicle2.getId(), string, baseVehicle.getId(), string2, Float.valueOf(f));
        boolean bl3 = bl2 = baseVehicle2.getScriptName().contains("Trailer") || baseVehicle.getScriptName().contains("Trailer");
        return f < (bl ? 10.0f : (bl2 ? 1.0f : 4.0f));
    }

    private void tryReconnectToTowedVehicle() {
        if (GameClient.bClient) {
            short s = VehicleManager.instance.getTowedVehicleID(this.VehicleID);
            if (s == -1) {
                return;
            }
            BaseVehicle baseVehicle = VehicleManager.instance.getVehicleByID(s);
            if (baseVehicle == null) {
                return;
            }
            if (!this.canAttachTrailer(baseVehicle, this.towAttachmentSelf, this.towAttachmentOther, true)) {
                return;
            }
            this.addPointConstraint(null, baseVehicle, this.towAttachmentSelf, this.towAttachmentOther, true);
            return;
        }
        if (this.vehicleTowing != null) {
            return;
        }
        if (this.vehicleTowingID == -1) {
            return;
        }
        BaseVehicle baseVehicle = null;
        ArrayList<BaseVehicle> arrayList = IsoWorld.instance.CurrentCell.getVehicles();
        for (int i = 0; i < arrayList.size(); ++i) {
            BaseVehicle baseVehicle2 = arrayList.get(i);
            if (baseVehicle2.getSqlId() != this.vehicleTowingID) continue;
            baseVehicle = baseVehicle2;
            break;
        }
        if (baseVehicle == null) {
            return;
        }
        if (!this.canAttachTrailer(baseVehicle, this.towAttachmentSelf, this.towAttachmentOther, true)) {
            return;
        }
        this.addPointConstraint(null, baseVehicle, this.towAttachmentSelf, this.towAttachmentOther, false);
    }

    public void positionTrailer(BaseVehicle baseVehicle) {
        if (baseVehicle == null) {
            return;
        }
        Vector3fObjectPool vector3fObjectPool = TL_vector3f_pool.get();
        Vector3f vector3f = this.getTowingWorldPos("trailer", (Vector3f)vector3fObjectPool.alloc());
        Vector3f vector3f2 = baseVehicle.getTowedByWorldPos("trailer", (Vector3f)vector3fObjectPool.alloc());
        if (vector3f == null || vector3f2 == null) {
            return;
        }
        vector3f2.sub(baseVehicle.x, baseVehicle.y, baseVehicle.z);
        vector3f.sub((Vector3fc)vector3f2);
        Transform transform = baseVehicle.getWorldTransform(this.tempTransform);
        transform.origin.set(vector3f.x - WorldSimulation.instance.offsetX, baseVehicle.jniTransform.origin.y, vector3f.y - WorldSimulation.instance.offsetY);
        baseVehicle.setWorldTransform(transform);
        baseVehicle.setX(vector3f.x);
        baseVehicle.setLx(vector3f.x);
        baseVehicle.setY(vector3f.y);
        baseVehicle.setLy(vector3f.y);
        baseVehicle.setCurrent(this.getCell().getGridSquare(vector3f.x, vector3f.y, 0.0));
        this.addPointConstraint(null, baseVehicle, "trailer", "trailer");
        vector3fObjectPool.release(vector3f);
        vector3fObjectPool.release(vector3f2);
    }

    public String getTowAttachmentSelf() {
        return this.towAttachmentSelf;
    }

    public String getTowAttachmentOther() {
        return this.towAttachmentOther;
    }

    public VehicleEngineRPM getVehicleEngineRPM() {
        if (this.vehicleEngineRPM == null) {
            this.vehicleEngineRPM = ScriptManager.instance.getVehicleEngineRPM(this.getScript().getEngineRPMType());
            if (this.vehicleEngineRPM == null) {
                DebugLog.General.warn("unknown vehicleEngineRPM \"%s\"", this.getScript().getEngineRPMType());
                this.vehicleEngineRPM = new VehicleEngineRPM();
            }
        }
        return this.vehicleEngineRPM;
    }

    public FMODParameterList getFMODParameters() {
        return this.fmodParameters;
    }

    public void startEvent(long l, GameSoundClip gameSoundClip, BitSet bitSet) {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        ArrayList arrayList = gameSoundClip.eventDescription.parameters;
        for (int i = 0; i < arrayList.size(); ++i) {
            FMODParameter fMODParameter;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = (FMOD_STUDIO_PARAMETER_DESCRIPTION)arrayList.get(i);
            if (bitSet.get(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex) || (fMODParameter = fMODParameterList.get(fMOD_STUDIO_PARAMETER_DESCRIPTION)) == null) continue;
            fMODParameter.startEventInstance(l);
        }
    }

    public void updateEvent(long l, GameSoundClip gameSoundClip) {
    }

    public void stopEvent(long l, GameSoundClip gameSoundClip, BitSet bitSet) {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        ArrayList arrayList = gameSoundClip.eventDescription.parameters;
        for (int i = 0; i < arrayList.size(); ++i) {
            FMODParameter fMODParameter;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = (FMOD_STUDIO_PARAMETER_DESCRIPTION)arrayList.get(i);
            if (bitSet.get(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex) || (fMODParameter = fMODParameterList.get(fMOD_STUDIO_PARAMETER_DESCRIPTION)) == null) continue;
            fMODParameter.stopEventInstance(l);
        }
    }

    private void stopEngineSounds() {
        if (this.emitter == null) {
            return;
        }
        for (int i = 0; i < this.new_EngineSoundId.length; ++i) {
            if (this.new_EngineSoundId[i] == 0L) continue;
            this.getEmitter().stopSound(this.new_EngineSoundId[i]);
            this.new_EngineSoundId[i] = 0L;
        }
        if (this.combinedEngineSound != 0L) {
            if (this.getEmitter().hasSustainPoints(this.combinedEngineSound)) {
                this.getEmitter().triggerCue(this.combinedEngineSound);
            } else {
                this.getEmitter().stopSound(this.combinedEngineSound);
            }
            this.combinedEngineSound = 0L;
        }
    }

    public BaseVehicle setSmashed(String string) {
        return this.setSmashed(string, false);
    }

    public BaseVehicle setSmashed(String string, boolean bl) {
        Object object;
        KahluaTableImpl kahluaTableImpl;
        String string2 = null;
        Integer n = null;
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)LuaManager.env.rawget((Object)"SmashedCarDefinitions");
        if (kahluaTableImpl2 != null && (kahluaTableImpl = (KahluaTableImpl)kahluaTableImpl2.rawget((Object)"cars")) != null && (object = (KahluaTableImpl)kahluaTableImpl.rawget((Object)this.getScriptName())) != null) {
            string2 = object.rawgetStr((Object)string.toLowerCase());
            n = object.rawgetInt((Object)"skin");
            if (n == -1) {
                n = this.getSkinIndex();
            }
        }
        int n2 = this.getKeyId();
        if (string2 != null) {
            this.removeFromWorld();
            this.permanentlyRemove();
            object = new BaseVehicle(IsoWorld.instance.CurrentCell);
            ((BaseVehicle)object).setScriptName(string2);
            ((BaseVehicle)object).setScript();
            ((BaseVehicle)object).setSkinIndex(n);
            ((IsoMovingObject)object).setX(this.x);
            ((IsoMovingObject)object).setY(this.y);
            ((IsoMovingObject)object).setZ(this.z);
            ((IsoObject)object).setDir(this.getDir());
            ((BaseVehicle)object).savedRot.set((Quaternionfc)this.savedRot);
            if (bl) {
                float f = this.getAngleY();
                ((BaseVehicle)object).savedRot.rotationXYZ(0.0f, f * ((float)Math.PI / 180), (float)Math.PI);
            }
            ((BaseVehicle)object).jniTransform.setRotation(((BaseVehicle)object).savedRot);
            if (IsoChunk.doSpawnedVehiclesInInvalidPosition((BaseVehicle)object)) {
                ((IsoObject)object).setSquare(this.square);
                ((BaseVehicle)object).square.chunk.vehicles.add((BaseVehicle)object);
                ((BaseVehicle)object).chunk = ((BaseVehicle)object).square.chunk;
                ((BaseVehicle)object).addToWorld();
                VehiclesDB2.instance.addVehicle((BaseVehicle)object);
            }
            ((BaseVehicle)object).setGeneralPartCondition(0.5f, 60.0f);
            VehiclePart vehiclePart = ((BaseVehicle)object).getPartById("Engine");
            if (vehiclePart != null) {
                vehiclePart.setCondition(0);
            }
            ((BaseVehicle)object).engineQuality = 0;
            ((IsoObject)object).setKeyId(n2);
            return object;
        }
        return this;
    }

    public boolean isCollided(IsoGameCharacter isoGameCharacter) {
        if (GameClient.bClient && this.getDriver() != null && !this.getDriver().isLocal()) {
            return true;
        }
        Vector2 vector22 = this.testCollisionWithCharacter(isoGameCharacter, 0.20000002f, this.hitVars.collision);
        return vector22 != null && vector22.x != -1.0f;
    }

    public HitVars checkCollision(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.isProne()) {
            int n = this.testCollisionWithProneCharacter(isoGameCharacter, true);
            if (n > 0) {
                this.hitVars.calc(isoGameCharacter, this);
                this.hitCharacter(isoGameCharacter, this.hitVars);
                return this.hitVars;
            }
        } else {
            this.hitVars.calc(isoGameCharacter, this);
            this.hitCharacter(isoGameCharacter, this.hitVars);
            return this.hitVars;
        }
        return null;
    }

    public boolean updateHitByVehicle(IsoGameCharacter isoGameCharacter) {
        HitVars hitVars;
        if (isoGameCharacter.isVehicleCollisionActive(this) && (this.isCollided(isoGameCharacter) || isoGameCharacter.isCollidedWithVehicle()) && this.physics != null && (hitVars = this.checkCollision(isoGameCharacter)) != null) {
            isoGameCharacter.doHitByVehicle(this, hitVars);
            return true;
        }
        return false;
    }

    public void hitCharacter(IsoGameCharacter isoGameCharacter, HitVars hitVars) {
        if (hitVars.dot < 0.0f && !GameServer.bServer) {
            this.ApplyImpulse(isoGameCharacter, hitVars.vehicleImpulse);
        }
        long l = System.currentTimeMillis();
        long l2 = (l - this.zombieHitTimestamp) / 1000L;
        this.zombiesHits = Math.max(this.zombiesHits - (int)l2, 0);
        if (l - this.zombieHitTimestamp > 700L) {
            this.zombieHitTimestamp = l;
            ++this.zombiesHits;
            this.zombiesHits = Math.min(this.zombiesHits, 20);
        }
        if (isoGameCharacter instanceof IsoPlayer) {
            ((IsoPlayer)isoGameCharacter).setVehicleHitLocation(this);
        } else if (isoGameCharacter instanceof IsoZombie) {
            ((IsoZombie)isoGameCharacter).setVehicleHitLocation(this);
        }
        if (hitVars.vehicleSpeed >= 5.0f || this.zombiesHits > 10) {
            hitVars.vehicleSpeed = this.getCurrentSpeedKmHour() / 5.0f;
            Vector3f vector3f = (Vector3f)TL_vector3f_pool.get().alloc();
            this.getLocalPos(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z, vector3f);
            if (vector3f.z > 0.0f) {
                int n = this.caclulateDamageWithBodies(true);
                if (!GameClient.bClient) {
                    this.addDamageFrontHitAChr(n);
                }
                DebugLog.Vehicle.trace("Damage car front hits=%d damage=%d", this.zombiesHits, n);
                hitVars.vehicleDamage = n;
                hitVars.isVehicleHitFromFront = true;
            } else {
                int n = this.caclulateDamageWithBodies(false);
                if (!GameClient.bClient) {
                    this.addDamageRearHitAChr(n);
                }
                DebugLog.Vehicle.trace("Damage car rear hits=%d damage=%d", this.zombiesHits, n);
                hitVars.vehicleDamage = n;
                hitVars.isVehicleHitFromFront = false;
            }
            TL_vector3f_pool.get().release(vector3f);
        }
    }

    protected static class UpdateFlags {
        public static final short Full = 1;
        public static final short PositionOrientation = 2;
        public static final short Engine = 4;
        public static final short Lights = 8;
        public static final short PartModData = 16;
        public static final short PartUsedDelta = 32;
        public static final short PartModels = 64;
        public static final short PartItem = 128;
        public static final short PartWindow = 256;
        public static final short PartDoor = 512;
        public static final short Sounds = 1024;
        public static final short PartCondition = 2048;
        public static final short UpdateCarProperties = 4096;
        public static final short Authorization = 16384;
        public static final short AllPartFlags = 19440;

        protected UpdateFlags() {
        }
    }

    public static final class Vector2ObjectPool
    extends ObjectPool<Vector2> {
        int allocated = 0;

        Vector2ObjectPool() {
            super(Vector2::new);
        }

        @Override
        protected Vector2 makeObject() {
            ++this.allocated;
            return (Vector2)super.makeObject();
        }
    }

    public static final class Vector3fObjectPool
    extends ObjectPool<Vector3f> {
        int allocated = 0;

        Vector3fObjectPool() {
            super(Vector3f::new);
        }

        @Override
        protected Vector3f makeObject() {
            ++this.allocated;
            return (Vector3f)super.makeObject();
        }
    }

    private static final class VehicleImpulse {
        static final ArrayDeque<VehicleImpulse> pool = new ArrayDeque();
        final Vector3f impulse = new Vector3f();
        final Vector3f rel_pos = new Vector3f();
        boolean enable = false;

        private VehicleImpulse() {
        }

        static VehicleImpulse alloc() {
            return pool.isEmpty() ? new VehicleImpulse() : pool.pop();
        }

        void release() {
            pool.push(this);
        }
    }

    public static enum Authorization {
        Server,
        LocalCollide,
        RemoteCollide,
        Local,
        Remote;

        private static final HashMap<Byte, Authorization> authorizations;

        public static Authorization valueOf(byte by) {
            return authorizations.getOrDefault(by, Server);
        }

        public byte index() {
            return (byte)this.ordinal();
        }

        static {
            authorizations = new HashMap();
            Arrays.stream(Authorization.values()).forEach(authorization -> authorizations.put(authorization.index(), (Authorization)((Object)authorization)));
        }
    }

    public static enum engineStateTypes {
        Idle,
        Starting,
        RetryingStarting,
        StartingSuccess,
        StartingFailed,
        Running,
        Stalling,
        ShutingDown,
        StartingFailedNoPower;

        public static final engineStateTypes[] Values;

        static {
            Values = engineStateTypes.values();
        }
    }

    public static final class WheelInfo {
        public float steering;
        public float rotation;
        public float skidInfo;
        public float suspensionLength;
    }

    public static final class ServerVehicleState {
        public float x = -1.0f;
        public float y;
        public float z;
        public Quaternionf orient = new Quaternionf();
        public short flags = 0;
        public Authorization netPlayerAuthorization = Authorization.Server;
        public short netPlayerId = 0;

        public void setAuthorization(BaseVehicle baseVehicle) {
            this.netPlayerAuthorization = baseVehicle.netPlayerAuthorization;
            this.netPlayerId = baseVehicle.netPlayerId;
        }

        public boolean shouldSend(BaseVehicle baseVehicle) {
            if (baseVehicle.getController() == null) {
                return false;
            }
            if (baseVehicle.updateLockTimeout > System.currentTimeMillis()) {
                return false;
            }
            this.flags = (short)(this.flags & 1);
            if (!baseVehicle.isNetPlayerAuthorization(this.netPlayerAuthorization) || !baseVehicle.isNetPlayerId(this.netPlayerId)) {
                this.flags = (short)(this.flags | 0x4000);
            }
            this.flags = (short)(this.flags | baseVehicle.updateFlags);
            return this.flags != 0;
        }
    }

    public static final class Passenger {
        public IsoGameCharacter character;
        final Vector3f offset = new Vector3f();
    }

    public static class HitVars {
        private static final float speedCap = 10.0f;
        private final Vector3f velocity = new Vector3f();
        private final Vector2 collision = new Vector2();
        private float dot;
        protected float vehicleImpulse;
        protected float vehicleSpeed;
        public final Vector3f targetImpulse = new Vector3f();
        public boolean isVehicleHitFromFront;
        public boolean isTargetHitFromBehind;
        public int vehicleDamage;
        public float hitSpeed;

        public void calc(IsoGameCharacter isoGameCharacter, BaseVehicle baseVehicle) {
            baseVehicle.getLinearVelocity(this.velocity);
            this.velocity.y = 0.0f;
            if (isoGameCharacter instanceof IsoZombie) {
                this.vehicleSpeed = Math.min(this.velocity.length(), 10.0f);
                this.hitSpeed = this.vehicleSpeed + baseVehicle.getClientForce() / baseVehicle.getFudgedMass();
            } else {
                this.vehicleSpeed = (float)Math.sqrt(this.velocity.x * this.velocity.x + this.velocity.z * this.velocity.z);
                this.hitSpeed = isoGameCharacter.isOnFloor() ? Math.max(this.vehicleSpeed * 6.0f, 5.0f) : Math.max(this.vehicleSpeed * 2.0f, 5.0f);
            }
            this.targetImpulse.set(baseVehicle.x - isoGameCharacter.x, 0.0f, baseVehicle.y - isoGameCharacter.y);
            this.targetImpulse.normalize();
            this.velocity.normalize();
            this.dot = this.velocity.dot((Vector3fc)this.targetImpulse);
            this.targetImpulse.normalize();
            this.targetImpulse.mul(3.0f * this.vehicleSpeed / 10.0f);
            this.targetImpulse.set(this.targetImpulse.x, this.targetImpulse.y, this.targetImpulse.z);
            this.vehicleImpulse = baseVehicle.getFudgedMass() * 7.0f * this.vehicleSpeed / 10.0f * Math.abs(this.dot);
            this.isTargetHitFromBehind = "BEHIND".equals(isoGameCharacter.testDotSide(baseVehicle));
        }
    }

    public static final class ModelInfo {
        public VehiclePart part;
        public VehicleScript.Model scriptModel;
        public ModelScript modelScript;
        public int wheelIndex;
        public final Matrix4f renderTransform = new Matrix4f();
        public VehicleSubModelInstance modelInstance;
        public AnimationPlayer m_animPlayer;
        public AnimationTrack m_track;

        public AnimationPlayer getAnimationPlayer() {
            Object object;
            if (this.part != null && this.part.getParent() != null && (object = this.part.getVehicle().getModelInfoForPart(this.part.getParent())) != null) {
                return ((ModelInfo)object).getAnimationPlayer();
            }
            object = this.scriptModel.file;
            Model model = ModelManager.instance.getLoadedModel((String)object);
            if (model == null || model.bStatic) {
                return null;
            }
            if (this.m_animPlayer != null && this.m_animPlayer.getModel() != model) {
                this.m_animPlayer = Pool.tryRelease(this.m_animPlayer);
            }
            if (this.m_animPlayer == null) {
                this.m_animPlayer = AnimationPlayer.alloc(model);
            }
            return this.m_animPlayer;
        }

        public void releaseAnimationPlayer() {
            this.m_animPlayer = Pool.tryRelease(this.m_animPlayer);
        }
    }

    public static final class Matrix4fObjectPool
    extends ObjectPool<Matrix4f> {
        int allocated = 0;

        Matrix4fObjectPool() {
            super(Matrix4f::new);
        }

        @Override
        protected Matrix4f makeObject() {
            ++this.allocated;
            return (Matrix4f)super.makeObject();
        }
    }

    public static final class QuaternionfObjectPool
    extends ObjectPool<Quaternionf> {
        int allocated = 0;

        QuaternionfObjectPool() {
            super(Quaternionf::new);
        }

        @Override
        protected Quaternionf makeObject() {
            ++this.allocated;
            return (Quaternionf)super.makeObject();
        }
    }

    private static final class L_testCollisionWithVehicle {
        static final Vector2[] testVecs1 = new Vector2[4];
        static final Vector2[] testVecs2 = new Vector2[4];
        static final Vector3f worldPos = new Vector3f();

        private L_testCollisionWithVehicle() {
        }
    }

    public static final class Vector2fObjectPool
    extends ObjectPool<Vector2f> {
        int allocated = 0;

        Vector2fObjectPool() {
            super(Vector2f::new);
        }

        @Override
        protected Vector2f makeObject() {
            ++this.allocated;
            return (Vector2f)super.makeObject();
        }
    }

    public static final class MinMaxPosition {
        public float minX;
        public float maxX;
        public float minY;
        public float maxY;
    }
}

