/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import zombie.util.IntIterator;
import zombie.util.hash.DefaultIntHashFunction;
import zombie.util.hash.IntHashFunction;
import zombie.util.hash.Primes;
import zombie.util.map.AbstractIntKeyMap;
import zombie.util.map.IntKeyMap;
import zombie.util.map.IntKeyMapIterator;
import zombie.util.set.AbstractIntSet;
import zombie.util.set.IntSet;
import zombie.util.util.Exceptions;

public class IntKeyOpenHashMap<V>
extends AbstractIntKeyMap<V>
implements IntKeyMap<V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private IntHashFunction keyhash;
    private int size;
    private transient int[] keys;
    private transient Object[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient IntSet ckeys;
    private transient Collection<V> cvalues;

    private IntKeyOpenHashMap(IntHashFunction intHashFunction, int n, int n2, double d, int n3, double d2) {
        if (intHashFunction == null) {
            Exceptions.nullArgument("hash function");
        }
        if (n < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(n));
        }
        if (d <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(d));
        }
        if (n3 <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(n3));
        }
        if (d2 <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(d2));
        }
        this.keyhash = intHashFunction;
        n = Primes.nextPrime(n);
        this.keys = new int[n];
        this.values = new Object[n];
        this.states = new byte[n];
        this.size = 0;
        this.expandAt = (int)Math.round(d2 * (double)n);
        this.used = 0;
        this.growthPolicy = n2;
        this.growthFactor = d;
        this.growthChunk = n3;
        this.loadFactor = d2;
    }

    private IntKeyOpenHashMap(int n, int n2, double d, int n3, double d2) {
        this(DefaultIntHashFunction.INSTANCE, n, n2, d, n3, d2);
    }

    public IntKeyOpenHashMap() {
        this(11);
    }

    public IntKeyOpenHashMap(IntKeyMap<V> intKeyMap) {
        this();
        this.putAll(intKeyMap);
    }

    public IntKeyOpenHashMap(int n) {
        this(n, 0, 1.0, 10, 0.75);
    }

    public IntKeyOpenHashMap(double d) {
        this(11, 0, 1.0, 10, d);
    }

    public IntKeyOpenHashMap(int n, double d) {
        this(n, 0, 1.0, 10, d);
    }

    public IntKeyOpenHashMap(int n, double d, double d2) {
        this(n, 0, d2, 10, d);
    }

    public IntKeyOpenHashMap(int n, double d, int n2) {
        this(n, 1, 1.0, n2, d);
    }

    public IntKeyOpenHashMap(IntHashFunction intHashFunction) {
        this(intHashFunction, 11, 0, 1.0, 10, 0.75);
    }

    public IntKeyOpenHashMap(IntHashFunction intHashFunction, int n) {
        this(intHashFunction, n, 0, 1.0, 10, 0.75);
    }

    public IntKeyOpenHashMap(IntHashFunction intHashFunction, double d) {
        this(intHashFunction, 11, 0, 1.0, 10, d);
    }

    public IntKeyOpenHashMap(IntHashFunction intHashFunction, int n, double d) {
        this(intHashFunction, n, 0, 1.0, 10, d);
    }

    public IntKeyOpenHashMap(IntHashFunction intHashFunction, int n, double d, double d2) {
        this(intHashFunction, n, 0, d2, 10, d);
    }

    public IntKeyOpenHashMap(IntHashFunction intHashFunction, int n, double d, int n2) {
        this(intHashFunction, n, 1, 1.0, n2, d);
    }

    private void ensureCapacity(int n) {
        if (n >= this.expandAt) {
            int n2 = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)n2 * this.loadFactor < (double)n) {
                n2 = (int)Math.round((double)n / this.loadFactor);
            }
            n2 = Primes.nextPrime(n2);
            this.expandAt = (int)Math.round(this.loadFactor * (double)n2);
            int[] nArray = new int[n2];
            Object[] objectArray = new Object[n2];
            byte[] byArray = new byte[n2];
            this.used = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.states[i] != 1) continue;
                ++this.used;
                int n3 = this.keys[i];
                Object object = this.values[i];
                int n4 = Math.abs(this.keyhash.hash(n3));
                int n5 = n4 % n2;
                if (byArray[n5] == 1) {
                    int n6 = 1 + n4 % (n2 - 2);
                    do {
                        if ((n5 -= n6) >= 0) continue;
                        n5 += n2;
                    } while (byArray[n5] != 0);
                }
                byArray[n5] = 1;
                objectArray[n5] = object;
                nArray[n5] = n3;
            }
            this.keys = nArray;
            this.values = objectArray;
            this.states = byArray;
        }
    }

    @Override
    public IntSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    @Override
    public V put(int n, V v) {
        int n2;
        block5: {
            int n3 = Math.abs(this.keyhash.hash(n));
            n2 = n3 % this.keys.length;
            if (this.states[n2] == 1) {
                if (this.keys[n2] == n) {
                    Object object = this.values[n2];
                    this.values[n2] = v;
                    return (V)object;
                }
                int n4 = 1 + n3 % (this.keys.length - 2);
                do {
                    if ((n2 -= n4) < 0) {
                        n2 += this.keys.length;
                    }
                    if (this.states[n2] == 0 || this.states[n2] == 2) break block5;
                } while (this.states[n2] != 1 || this.keys[n2] != n);
                Object object = this.values[n2];
                this.values[n2] = v;
                return (V)object;
            }
        }
        if (this.states[n2] == 0) {
            ++this.used;
        }
        this.states[n2] = 1;
        this.keys[n2] = n;
        this.values[n2] = v;
        ++this.size;
        this.ensureCapacity(this.used);
        return null;
    }

    @Override
    public Collection<V> values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            IntKeyOpenHashMap intKeyOpenHashMap = (IntKeyOpenHashMap)super.clone();
            intKeyOpenHashMap.keys = new int[this.keys.length];
            System.arraycopy(this.keys, 0, intKeyOpenHashMap.keys, 0, this.keys.length);
            intKeyOpenHashMap.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, intKeyOpenHashMap.values, 0, this.values.length);
            intKeyOpenHashMap.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, intKeyOpenHashMap.states, 0, this.states.length);
            intKeyOpenHashMap.cvalues = null;
            intKeyOpenHashMap.ckeys = null;
            return intKeyOpenHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Exceptions.cloning();
            return null;
        }
    }

    @Override
    public IntKeyMapIterator<V> entries() {
        return new IntKeyMapIterator<V>(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int n) {
                while (n < IntKeyOpenHashMap.this.keys.length && IntKeyOpenHashMap.this.states[n] != 1) {
                    ++n;
                }
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry < IntKeyOpenHashMap.this.keys.length;
            }

            @Override
            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            @Override
            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                IntKeyOpenHashMap.this.states[this.lastEntry] = 2;
                IntKeyOpenHashMap.this.values[this.lastEntry] = null;
                --IntKeyOpenHashMap.this.size;
                this.lastEntry = -1;
            }

            @Override
            public int getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return IntKeyOpenHashMap.this.keys[this.lastEntry];
            }

            @Override
            public V getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return IntKeyOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    @Override
    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.used = 0;
    }

    @Override
    public boolean containsKey(int n) {
        int n2 = Math.abs(this.keyhash.hash(n));
        int n3 = n2 % this.keys.length;
        if (this.states[n3] != 0) {
            if (this.states[n3] == 1 && this.keys[n3] == n) {
                return true;
            }
            int n4 = 1 + n2 % (this.keys.length - 2);
            do {
                if ((n3 -= n4) < 0) {
                    n3 += this.keys.length;
                }
                if (this.states[n3] != 0) continue;
                return false;
            } while (this.states[n3] != 1 || this.keys[n3] != n);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            for (int i = 0; i < this.states.length; ++i) {
                if (this.states[i] != 1 || this.values[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.states.length; ++i) {
                if (this.states[i] != 1 || !object.equals(this.values[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(int n) {
        int n2 = Math.abs(this.keyhash.hash(n));
        int n3 = n2 % this.keys.length;
        if (this.states[n3] != 0) {
            if (this.states[n3] == 1 && this.keys[n3] == n) {
                return (V)this.values[n3];
            }
            int n4 = 1 + n2 % (this.keys.length - 2);
            do {
                if ((n3 -= n4) < 0) {
                    n3 += this.keys.length;
                }
                if (this.states[n3] != 0) continue;
                return null;
            } while (this.states[n3] != 1 || this.keys[n3] != n);
            return (V)this.values[n3];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V remove(int n) {
        int n2 = Math.abs(this.keyhash.hash(n));
        int n3 = n2 % this.keys.length;
        if (this.states[n3] != 0) {
            if (this.states[n3] == 1 && this.keys[n3] == n) {
                Object object = this.values[n3];
                this.values[n3] = null;
                this.states[n3] = 2;
                --this.size;
                return (V)object;
            }
            int n4 = 1 + n2 % (this.keys.length - 2);
            do {
                if ((n3 -= n4) < 0) {
                    n3 += this.keys.length;
                }
                if (this.states[n3] != 0) continue;
                return null;
            } while (this.states[n3] != 1 || this.keys[n3] != n);
            Object object = this.values[n3];
            this.values[n3] = null;
            this.states[n3] = 2;
            --this.size;
            return (V)object;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.keys.length);
        IntKeyMapIterator<V> intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            objectOutputStream.writeInt(intKeyMapIterator.getKey());
            objectOutputStream.writeObject(intKeyMapIterator.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keys = new int[objectInputStream.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new Object[this.keys.length];
        this.used = this.size;
        for (int i = 0; i < this.size; ++i) {
            int n = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            int n2 = Math.abs(this.keyhash.hash(n));
            int n3 = n2 % this.keys.length;
            if (this.states[n3] != 0) {
                int n4 = 1 + n2 % (this.keys.length - 2);
                do {
                    if ((n3 -= n4) >= 0) continue;
                    n3 += this.keys.length;
                } while (this.states[n3] != 0);
            }
            this.states[n3] = 1;
            this.keys[n3] = n;
            this.values[n3] = object;
        }
    }

    private class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public void clear() {
            IntKeyOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(int n) {
            return IntKeyOpenHashMap.this.containsKey(n);
        }

        @Override
        public IntIterator iterator() {
            return new IntIterator(){
                int nextEntry = this.nextEntry(0);
                int lastEntry = -1;

                int nextEntry(int n) {
                    while (n < IntKeyOpenHashMap.this.keys.length && IntKeyOpenHashMap.this.states[n] != 1) {
                        ++n;
                    }
                    return n;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry < IntKeyOpenHashMap.this.keys.length;
                }

                @Override
                public int next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return IntKeyOpenHashMap.this.keys[this.lastEntry];
                }

                @Override
                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    IntKeyOpenHashMap.this.states[this.lastEntry] = 2;
                    IntKeyOpenHashMap.this.values[this.lastEntry] = null;
                    --IntKeyOpenHashMap.this.size;
                    this.lastEntry = -1;
                }
            };
        }

        @Override
        public boolean remove(int n) {
            boolean bl = IntKeyOpenHashMap.this.containsKey(n);
            if (bl) {
                IntKeyOpenHashMap.this.remove(n);
            }
            return bl;
        }

        @Override
        public int size() {
            return IntKeyOpenHashMap.this.size;
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public void clear() {
            IntKeyOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return IntKeyOpenHashMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                int nextEntry = this.nextEntry(0);
                int lastEntry = -1;

                int nextEntry(int n) {
                    while (n < IntKeyOpenHashMap.this.keys.length && IntKeyOpenHashMap.this.states[n] != 1) {
                        ++n;
                    }
                    return n;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry < IntKeyOpenHashMap.this.keys.length;
                }

                @Override
                public V next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return IntKeyOpenHashMap.this.values[this.lastEntry];
                }

                @Override
                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    IntKeyOpenHashMap.this.states[this.lastEntry] = 2;
                    IntKeyOpenHashMap.this.values[this.lastEntry] = null;
                    --IntKeyOpenHashMap.this.size;
                    this.lastEntry = -1;
                }
            };
        }

        @Override
        public int size() {
            return IntKeyOpenHashMap.this.size;
        }
    }
}

