/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.map;

import zombie.util.hash.DefaultIntHashFunction;
import zombie.util.map.IntKeyMap;
import zombie.util.map.IntKeyMapIterator;

public abstract class AbstractIntKeyMap<V>
implements IntKeyMap<V> {
    protected AbstractIntKeyMap() {
    }

    @Override
    public void clear() {
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            intKeyMapIterator.remove();
        }
    }

    @Override
    public V remove(int n) {
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            if (intKeyMapIterator.getKey() != n) continue;
            Object v = intKeyMapIterator.getValue();
            intKeyMapIterator.remove();
            return v;
        }
        return null;
    }

    @Override
    public void putAll(IntKeyMap<V> intKeyMap) {
        IntKeyMapIterator<V> intKeyMapIterator = intKeyMap.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            this.put(intKeyMapIterator.getKey(), intKeyMapIterator.getValue());
        }
    }

    @Override
    public boolean containsKey(int n) {
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            if (intKeyMapIterator.getKey() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int n) {
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            if (intKeyMapIterator.getKey() != n) continue;
            return intKeyMapIterator.getValue();
        }
        return null;
    }

    @Override
    public boolean containsValue(Object object) {
        IntKeyMapIterator intKeyMapIterator = this.entries();
        if (object == null) {
            while (intKeyMapIterator.hasNext()) {
                intKeyMapIterator.next();
                if (object != null) continue;
                return true;
            }
        } else {
            while (intKeyMapIterator.hasNext()) {
                intKeyMapIterator.next();
                if (!object.equals(intKeyMapIterator.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IntKeyMap)) {
            return false;
        }
        IntKeyMap intKeyMap = (IntKeyMap)object;
        if (this.size() != intKeyMap.size()) {
            return false;
        }
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            int n = intKeyMapIterator.getKey();
            Object v = intKeyMapIterator.getValue();
            if (v == null) {
                if (intKeyMap.get(n) != null) {
                    return false;
                }
                if (intKeyMap.containsKey(n)) continue;
                return false;
            }
            if (v.equals(intKeyMap.get(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            n += DefaultIntHashFunction.INSTANCE.hash(intKeyMapIterator.getKey()) ^ intKeyMapIterator.getValue().hashCode();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        int n = 0;
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            intKeyMapIterator.next();
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        IntKeyMapIterator intKeyMapIterator = this.entries();
        while (intKeyMapIterator.hasNext()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(',');
            }
            intKeyMapIterator.next();
            stringBuilder.append(String.valueOf(intKeyMapIterator.getKey()));
            stringBuilder.append("->");
            stringBuilder.append(String.valueOf(intKeyMapIterator.getValue()));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void trimToSize() {
    }
}

