/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class PZConvertList<S, T>
extends AbstractList<T>
implements RandomAccess {
    private final List<S> m_list;
    private final Function<S, T> m_converterST;
    private final Function<T, S> m_converterTS;

    public PZConvertList(List<S> list, Function<S, T> function) {
        this(list, function, null);
    }

    public PZConvertList(List<S> list, Function<S, T> function, Function<T, S> function2) {
        this.m_list = Objects.requireNonNull(list);
        this.m_converterST = function;
        this.m_converterTS = function2;
    }

    public boolean isReadonly() {
        return this.m_converterTS == null;
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_list.toArray();
    }

    @Override
    public <R> R[] toArray(R[] RArray) {
        int n = this.size();
        for (int i = 0; i < n && i < RArray.length; ++i) {
            T t = this.get(i);
            RArray[i] = t;
        }
        if (RArray.length > n) {
            RArray[n] = null;
        }
        return RArray;
    }

    @Override
    public T get(int n) {
        return this.convertST(this.m_list.get(n));
    }

    @Override
    public T set(int n, T t) {
        T t2 = this.get(n);
        this.setS(n, this.convertTS(t));
        return t2;
    }

    public S setS(int n, S s) {
        S s2 = this.m_list.get(n);
        this.m_list.set(n, s);
        return s2;
    }

    @Override
    public int indexOf(Object object) {
        int n = -1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (!PZConvertList.objectsEqual(object, this.get(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    private static boolean objectsEqual(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    public void replaceAll(UnaryOperator<T> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            T t = this.get(i);
            Object r = unaryOperator.apply(t);
            this.set(i, (T)r);
        }
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.m_list.sort((object, object2) -> comparator.compare((T)this.convertST(object), (T)this.convertST(object2)));
    }

    private T convertST(S s) {
        return this.m_converterST.apply(s);
    }

    private S convertTS(T t) {
        return this.m_converterTS.apply(t);
    }
}

