/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.list;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public final class PZArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private E[] elements;
    private int numElements;
    private static final PZArrayList<Object> instance = new PZArrayList<Object>(Object.class, 0);

    public PZArrayList(Class<E> clazz, int n) {
        this.elements = (Object[])Array.newInstance(clazz, n);
    }

    @Override
    public E get(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.numElements);
        }
        return this.elements[n];
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.numElements; ++i) {
            if ((object != null || this.elements[i] != null) && (object == null || !object.equals(this.elements[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        if (this.numElements == this.elements.length) {
            int n = this.elements.length + (this.elements.length >> 1);
            if (n < this.numElements + 1) {
                n = this.numElements + 1;
            }
            this.elements = Arrays.copyOf(this.elements, n);
        }
        this.elements[this.numElements] = e;
        ++this.numElements;
        return true;
    }

    @Override
    public void add(int n, E e) {
        if (n < 0 || n > this.numElements) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.numElements);
        }
        if (this.numElements == this.elements.length) {
            int n2 = this.elements.length + this.elements.length >> 1;
            if (n2 < this.numElements + 1) {
                n2 = this.numElements + 1;
            }
            this.elements = Arrays.copyOf(this.elements, n2);
        }
        System.arraycopy(this.elements, n, this.elements, n + 1, this.numElements - n);
        this.elements[n] = e;
        ++this.numElements;
    }

    @Override
    public E remove(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.numElements);
        }
        E e = this.elements[n];
        int n2 = this.numElements - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elements, n + 1, this.elements, n, n2);
        }
        this.elements[this.numElements - 1] = null;
        --this.numElements;
        return e;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.numElements; ++i) {
            if ((object != null || this.elements[i] != null) && (object == null || !object.equals(this.elements[i]))) continue;
            int n = this.numElements - i - 1;
            if (n > 0) {
                System.arraycopy(this.elements, i + 1, this.elements, i, n);
            }
            this.elements[this.numElements - 1] = null;
            --this.numElements;
            return true;
        }
        return false;
    }

    @Override
    public E set(int n, E e) {
        if (n < 0 || n >= this.numElements) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.numElements);
        }
        E e2 = this.elements[n];
        this.elements[n] = e;
        return e2;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.numElements; ++i) {
            this.elements[i] = null;
        }
        this.numElements = 0;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.numElements; ++i) {
            E e = this.elements[i];
            stringBuilder.append(e == this ? "(self)" : e.toString());
            if (i == this.numElements - 1) break;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        return stringBuilder.append(']').toString();
    }

    public E[] getElements() {
        return this.elements;
    }

    public static <E> AbstractList<E> emptyList() {
        return instance;
    }
}

