/*
 * Decompiled with CFR 0.152.
 */
package zombie.util.io;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedDeque;
import zombie.core.utils.Bits;
import zombie.debug.DebugLog;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;

public final class BitHeader {
    private static final ConcurrentLinkedDeque<BitHeaderByte> pool_byte = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<BitHeaderShort> pool_short = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<BitHeaderInt> pool_int = new ConcurrentLinkedDeque();
    private static final ConcurrentLinkedDeque<BitHeaderLong> pool_long = new ConcurrentLinkedDeque();
    public static boolean DEBUG = true;

    private static BitHeaderBase getHeader(HeaderSize headerSize, ByteBuffer byteBuffer, boolean bl) {
        if (headerSize == HeaderSize.Byte) {
            BitHeaderByte bitHeaderByte = pool_byte.poll();
            if (bitHeaderByte == null) {
                bitHeaderByte = new BitHeaderByte();
            }
            bitHeaderByte.setBuffer(byteBuffer);
            bitHeaderByte.setWrite(bl);
            return bitHeaderByte;
        }
        if (headerSize == HeaderSize.Short) {
            BitHeaderShort bitHeaderShort = pool_short.poll();
            if (bitHeaderShort == null) {
                bitHeaderShort = new BitHeaderShort();
            }
            bitHeaderShort.setBuffer(byteBuffer);
            bitHeaderShort.setWrite(bl);
            return bitHeaderShort;
        }
        if (headerSize == HeaderSize.Integer) {
            BitHeaderInt bitHeaderInt = pool_int.poll();
            if (bitHeaderInt == null) {
                bitHeaderInt = new BitHeaderInt();
            }
            bitHeaderInt.setBuffer(byteBuffer);
            bitHeaderInt.setWrite(bl);
            return bitHeaderInt;
        }
        if (headerSize == HeaderSize.Long) {
            BitHeaderLong bitHeaderLong = pool_long.poll();
            if (bitHeaderLong == null) {
                bitHeaderLong = new BitHeaderLong();
            }
            bitHeaderLong.setBuffer(byteBuffer);
            bitHeaderLong.setWrite(bl);
            return bitHeaderLong;
        }
        return null;
    }

    private BitHeader() {
    }

    public static void debug_print() {
        if (DEBUG) {
            DebugLog.log("*********************************************");
            DebugLog.log("ByteHeader = " + pool_byte.size());
            DebugLog.log("ShortHeader = " + pool_short.size());
            DebugLog.log("IntHeader = " + pool_int.size());
            DebugLog.log("LongHeader = " + pool_long.size());
        }
    }

    public static BitHeaderWrite allocWrite(HeaderSize headerSize, ByteBuffer byteBuffer) {
        return BitHeader.allocWrite(headerSize, byteBuffer, false);
    }

    public static BitHeaderWrite allocWrite(HeaderSize headerSize, ByteBuffer byteBuffer, boolean bl) {
        BitHeaderBase bitHeaderBase = BitHeader.getHeader(headerSize, byteBuffer, true);
        if (!bl) {
            bitHeaderBase.create();
        }
        return bitHeaderBase;
    }

    public static BitHeaderRead allocRead(HeaderSize headerSize, ByteBuffer byteBuffer) {
        return BitHeader.allocRead(headerSize, byteBuffer, false);
    }

    public static BitHeaderRead allocRead(HeaderSize headerSize, ByteBuffer byteBuffer, boolean bl) {
        BitHeaderBase bitHeaderBase = BitHeader.getHeader(headerSize, byteBuffer, false);
        if (!bl) {
            bitHeaderBase.read();
        }
        return bitHeaderBase;
    }

    public static enum HeaderSize {
        Byte,
        Short,
        Integer,
        Long;

    }

    public static class BitHeaderByte
    extends BitHeaderBase {
        private ConcurrentLinkedDeque<BitHeaderByte> pool;
        private byte header;

        private BitHeaderByte() {
        }

        @Override
        public void release() {
            this.reset();
            pool_byte.offer(this);
        }

        @Override
        public int getLen() {
            return Bits.getLen(this.header);
        }

        @Override
        protected void reset_header() {
            this.header = 0;
        }

        @Override
        protected void write_header() {
            this.buffer.put(this.header);
        }

        @Override
        protected void read_header() {
            this.header = this.buffer.get();
        }

        @Override
        protected void addflags_header(int n) {
            this.header = Bits.addFlags(this.header, n);
        }

        @Override
        protected void addflags_header(long l) {
            this.header = Bits.addFlags(this.header, l);
        }

        @Override
        protected boolean hasflags_header(int n) {
            return Bits.hasFlags(this.header, n);
        }

        @Override
        protected boolean hasflags_header(long l) {
            return Bits.hasFlags(this.header, l);
        }

        @Override
        protected boolean equals_header(int n) {
            return this.header == n;
        }

        @Override
        protected boolean equals_header(long l) {
            return (long)this.header == l;
        }
    }

    public static class BitHeaderShort
    extends BitHeaderBase {
        private ConcurrentLinkedDeque<BitHeaderShort> pool;
        private short header;

        private BitHeaderShort() {
        }

        @Override
        public void release() {
            this.reset();
            pool_short.offer(this);
        }

        @Override
        public int getLen() {
            return Bits.getLen(this.header);
        }

        @Override
        protected void reset_header() {
            this.header = 0;
        }

        @Override
        protected void write_header() {
            this.buffer.putShort(this.header);
        }

        @Override
        protected void read_header() {
            this.header = this.buffer.getShort();
        }

        @Override
        protected void addflags_header(int n) {
            this.header = Bits.addFlags(this.header, n);
        }

        @Override
        protected void addflags_header(long l) {
            this.header = Bits.addFlags(this.header, l);
        }

        @Override
        protected boolean hasflags_header(int n) {
            return Bits.hasFlags(this.header, n);
        }

        @Override
        protected boolean hasflags_header(long l) {
            return Bits.hasFlags(this.header, l);
        }

        @Override
        protected boolean equals_header(int n) {
            return this.header == n;
        }

        @Override
        protected boolean equals_header(long l) {
            return (long)this.header == l;
        }
    }

    public static class BitHeaderInt
    extends BitHeaderBase {
        private ConcurrentLinkedDeque<BitHeaderInt> pool;
        private int header;

        private BitHeaderInt() {
        }

        @Override
        public void release() {
            this.reset();
            pool_int.offer(this);
        }

        @Override
        public int getLen() {
            return Bits.getLen(this.header);
        }

        @Override
        protected void reset_header() {
            this.header = 0;
        }

        @Override
        protected void write_header() {
            this.buffer.putInt(this.header);
        }

        @Override
        protected void read_header() {
            this.header = this.buffer.getInt();
        }

        @Override
        protected void addflags_header(int n) {
            this.header = Bits.addFlags(this.header, n);
        }

        @Override
        protected void addflags_header(long l) {
            this.header = Bits.addFlags(this.header, l);
        }

        @Override
        protected boolean hasflags_header(int n) {
            return Bits.hasFlags(this.header, n);
        }

        @Override
        protected boolean hasflags_header(long l) {
            return Bits.hasFlags(this.header, l);
        }

        @Override
        protected boolean equals_header(int n) {
            return this.header == n;
        }

        @Override
        protected boolean equals_header(long l) {
            return (long)this.header == l;
        }
    }

    public static class BitHeaderLong
    extends BitHeaderBase {
        private ConcurrentLinkedDeque<BitHeaderLong> pool;
        private long header;

        private BitHeaderLong() {
        }

        @Override
        public void release() {
            this.reset();
            pool_long.offer(this);
        }

        @Override
        public int getLen() {
            return Bits.getLen(this.header);
        }

        @Override
        protected void reset_header() {
            this.header = 0L;
        }

        @Override
        protected void write_header() {
            this.buffer.putLong(this.header);
        }

        @Override
        protected void read_header() {
            this.header = this.buffer.getLong();
        }

        @Override
        protected void addflags_header(int n) {
            this.header = Bits.addFlags(this.header, n);
        }

        @Override
        protected void addflags_header(long l) {
            this.header = Bits.addFlags(this.header, l);
        }

        @Override
        protected boolean hasflags_header(int n) {
            return Bits.hasFlags(this.header, n);
        }

        @Override
        protected boolean hasflags_header(long l) {
            return Bits.hasFlags(this.header, l);
        }

        @Override
        protected boolean equals_header(int n) {
            return this.header == (long)n;
        }

        @Override
        protected boolean equals_header(long l) {
            return this.header == l;
        }
    }

    public static abstract class BitHeaderBase
    implements BitHeaderRead,
    BitHeaderWrite {
        protected boolean isWrite;
        protected ByteBuffer buffer;
        protected int start_pos = -1;

        protected void setBuffer(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        protected void setWrite(boolean bl) {
            this.isWrite = bl;
        }

        @Override
        public int getStartPosition() {
            return this.start_pos;
        }

        protected void reset() {
            this.buffer = null;
            this.isWrite = false;
            this.start_pos = -1;
            this.reset_header();
        }

        @Override
        public abstract int getLen();

        @Override
        public abstract void release();

        protected abstract void reset_header();

        protected abstract void write_header();

        protected abstract void read_header();

        protected abstract void addflags_header(int var1);

        protected abstract void addflags_header(long var1);

        protected abstract boolean hasflags_header(int var1);

        protected abstract boolean hasflags_header(long var1);

        protected abstract boolean equals_header(int var1);

        protected abstract boolean equals_header(long var1);

        @Override
        public void create() {
            if (!this.isWrite) {
                throw new RuntimeException("BitHeader -> Cannot write to a non write Header.");
            }
            this.start_pos = this.buffer.position();
            this.reset_header();
            this.write_header();
        }

        @Override
        public void write() {
            if (!this.isWrite) {
                throw new RuntimeException("BitHeader -> Cannot write to a non write Header.");
            }
            int n = this.buffer.position();
            this.buffer.position(this.start_pos);
            this.write_header();
            this.buffer.position(n);
        }

        @Override
        public void read() {
            if (this.isWrite) {
                throw new RuntimeException("BitHeader -> Cannot read from a non read Header.");
            }
            this.start_pos = this.buffer.position();
            this.read_header();
        }

        @Override
        public void addFlags(int n) {
            if (!this.isWrite) {
                throw new RuntimeException("BitHeader -> Cannot set bits on a non write Header.");
            }
            this.addflags_header(n);
        }

        @Override
        public void addFlags(long l) {
            if (!this.isWrite) {
                throw new RuntimeException("BitHeader -> Cannot set bits on a non write Header.");
            }
            this.addflags_header(l);
        }

        @Override
        public boolean hasFlags(int n) {
            return this.hasflags_header(n);
        }

        @Override
        public boolean hasFlags(long l) {
            return this.hasflags_header(l);
        }

        @Override
        public boolean equals(int n) {
            return this.equals_header(n);
        }

        @Override
        public boolean equals(long l) {
            return this.equals_header(l);
        }
    }
}

