/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.util.function.BiFunction;

public class StringUtils {
    public static final String s_emptyString = "";
    public static final char UTF8_BOM = '\ufeff';

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNullOrWhitespace(String string) {
        return StringUtils.isNullOrEmpty(string) || StringUtils.isWhitespace(string);
    }

    private static boolean isWhitespace(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = 0;
            int n3 = n / 2;
            int n4 = n - 1;
            while (n2 <= n3) {
                if (!Character.isWhitespace(string.charAt(n2)) || !Character.isWhitespace(string.charAt(n4))) {
                    return false;
                }
                ++n2;
                --n4;
            }
            return true;
        }
        return false;
    }

    public static String discardNullOrWhitespace(String string) {
        return StringUtils.isNullOrWhitespace(string) ? null : string;
    }

    public static String trimPrefix(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String trimSuffix(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static boolean equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        return string != null && string.equals(string2);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        return string.regionMatches(true, string.length() - n, string2, 0, n);
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        for (int i = string.length() - string2.length(); i >= 0; --i) {
            if (!string.regionMatches(true, i, string2, 0, string2.length())) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        return string != null && string.equalsIgnoreCase(string2);
    }

    public static boolean tryParseBoolean(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return false;
        }
        String string2 = string.trim();
        return string2.equalsIgnoreCase("true") || string2.equals("1") || string2.equals("1.0");
    }

    public static boolean isBoolean(String string) {
        String string2 = string.trim();
        if (string2.equalsIgnoreCase("true") || string2.equals("1") || string2.equals("1.0")) {
            return true;
        }
        return string2.equalsIgnoreCase("false") || string2.equals("0") || string2.equals("0.0");
    }

    public static boolean contains(String[] stringArray, String string, BiFunction<String, String, Boolean> biFunction) {
        return StringUtils.indexOf(stringArray, string, biFunction) > -1;
    }

    public static int indexOf(String[] stringArray, String string, BiFunction<String, String, Boolean> biFunction) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!biFunction.apply(stringArray[i], string).booleanValue()) continue;
            n = i;
            break;
        }
        return n;
    }

    public static String indent(String string) {
        return StringUtils.indent(string, s_emptyString, "\t");
    }

    private static String indent(String string, String string2, String string3) {
        String string4 = System.lineSeparator();
        return StringUtils.indent(string, string4, string2, string3);
    }

    private static String indent(String string, String string2, String string3, String string4) {
        if (StringUtils.isNullOrEmpty(string)) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        StringBuilder stringBuilder2 = new StringBuilder(n);
        int n2 = 0;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append(string2);
                    stringBuilder2.setLength(0);
                    ++n2;
                    continue block4;
                }
                default: {
                    if (stringBuilder2.length() == 0) {
                        if (n2 == 0) {
                            stringBuilder2.append(string3);
                        } else {
                            stringBuilder2.append(string4);
                        }
                    }
                    stringBuilder2.append(c);
                }
            }
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder2.setLength(0);
        return stringBuilder.toString();
    }

    public static String leftJustify(String string, int n) {
        if (string == null) {
            return StringUtils.leftJustify(s_emptyString, n);
        }
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        int n3 = n - n2;
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = 32;
        }
        String string2 = new String(cArray);
        return string + string2;
    }

    public static String moduleDotType(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.contains(".")) {
            return string2;
        }
        return string + "." + string2;
    }

    public static String stripBOM(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\ufeff') {
            return string.substring(1);
        }
        return string;
    }

    public static boolean containsDoubleDot(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return false;
        }
        return string.contains("..") || string.contains("\u0000.\u0000.");
    }
}

