/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import zombie.util.IPooledObject;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;

public final class Pool<PO extends IPooledObject> {
    private final Supplier<PO> m_allocator;
    private final ThreadLocal<PoolStacks> m_stacks = ThreadLocal.withInitial(PoolStacks::new);

    public Pool(Supplier<PO> supplier) {
        this.m_allocator = supplier;
    }

    public final PO alloc() {
        IPooledObject iPooledObject;
        Supplier<PO> supplier = this.m_allocator;
        PoolStacks poolStacks = this.m_stacks.get();
        THashSet<IPooledObject> tHashSet = poolStacks.inUse;
        List<IPooledObject> list = poolStacks.released;
        if (!list.isEmpty()) {
            iPooledObject = list.remove(list.size() - 1);
        } else {
            iPooledObject = (IPooledObject)supplier.get();
            if (iPooledObject == null) {
                throw new NullPointerException("Allocator returned a nullPtr. This is not allowed.");
            }
            iPooledObject.setPool(this);
        }
        iPooledObject.setFree(false);
        tHashSet.add((Object)iPooledObject);
        return (PO)iPooledObject;
    }

    public final void release(IPooledObject iPooledObject) {
        PoolStacks poolStacks = this.m_stacks.get();
        THashSet<IPooledObject> tHashSet = poolStacks.inUse;
        List<IPooledObject> list = poolStacks.released;
        if (iPooledObject.getPool() != this) {
            throw new UnsupportedOperationException("Cannot release item. Not owned by this pool.");
        }
        if (iPooledObject.isFree()) {
            throw new UnsupportedOperationException("Cannot release item. Already released.");
        }
        tHashSet.remove((Object)iPooledObject);
        iPooledObject.setFree(true);
        list.add(iPooledObject);
        iPooledObject.onReleased();
    }

    public static <E> E tryRelease(E e) {
        IPooledObject iPooledObject = Type.tryCastTo(e, IPooledObject.class);
        if (iPooledObject != null && !iPooledObject.isFree()) {
            iPooledObject.release();
        }
        return null;
    }

    public static <E extends IPooledObject> E tryRelease(E e) {
        if (e != null && !e.isFree()) {
            e.release();
        }
        return null;
    }

    public static <E extends IPooledObject> E[] tryRelease(E[] EArray) {
        PZArrayUtil.forEach(EArray, Pool::tryRelease);
        return null;
    }

    private static final class PoolStacks {
        final THashSet<IPooledObject> inUse = new THashSet();
        final List<IPooledObject> released = new ArrayList<IPooledObject>();

        PoolStacks() {
            this.inUse.setAutoCompactionFactor(0.0f);
        }
    }
}

