/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import zombie.core.logger.ExceptionLogger;

public class PZSQLUtils {
    public static void init() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionLogger.logException(classNotFoundException);
            System.exit(1);
        }
        PZSQLUtils.setupSqliteVariables();
    }

    private static void setupSqliteVariables() {
        if (!System.getProperty("os.name").contains("OS X")) {
            if (System.getProperty("os.name").startsWith("Win")) {
                if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.setProperty("org.sqlite.lib.path", PZSQLUtils.searchPathForSqliteLib("sqlitejdbc64.dll"));
                    System.setProperty("org.sqlite.lib.name", "sqlitejdbc64.dll");
                }
            } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                // empty if block
            }
        }
    }

    private static String searchPathForSqliteLib(String string) {
        for (String string2 : System.getProperty("java.library.path", "").split(File.pathSeparator)) {
            File file = new File(string2, string);
            if (!file.exists()) continue;
            return string2;
        }
        return "";
    }

    public static Connection getConnection(String string) throws SQLException {
        return DriverManager.getConnection("jdbc:sqlite:" + string);
    }
}

