/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.util.List;
import zombie.util.Pool;

public interface IPooledObject {
    public Pool<IPooledObject> getPool();

    public void setPool(Pool<IPooledObject> var1);

    public void release();

    public boolean isFree();

    public void setFree(boolean var1);

    default public void onReleased() {
    }

    public static void release(IPooledObject[] iPooledObjectArray) {
        int n = iPooledObjectArray.length;
        for (int i = 0; i < n; ++i) {
            Pool.tryRelease(iPooledObjectArray[i]);
        }
    }

    public static void tryReleaseAndBlank(IPooledObject[] iPooledObjectArray) {
        if (iPooledObjectArray != null) {
            IPooledObject.releaseAndBlank(iPooledObjectArray);
        }
    }

    public static void releaseAndBlank(IPooledObject[] iPooledObjectArray) {
        int n = iPooledObjectArray.length;
        for (int i = 0; i < n; ++i) {
            iPooledObjectArray[i] = Pool.tryRelease(iPooledObjectArray[i]);
        }
    }

    public static void release(List<? extends IPooledObject> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Pool.tryRelease(list.get(i));
        }
        list.clear();
    }
}

