/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferBackedInputStream
extends InputStream {
    final ByteBuffer buf;

    public ByteBufferBackedInputStream(ByteBuffer byteBuffer) {
        Objects.requireNonNull(byteBuffer);
        this.buf = byteBuffer;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        n2 = Math.min(n2, this.buf.remaining());
        this.buf.get(byArray, n, n2);
        return n2;
    }
}

