/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public final class BufferedRandomAccessFile
extends RandomAccessFile {
    private byte[] buffer;
    private int buf_end = 0;
    private int buf_pos = 0;
    private long real_pos = 0L;
    private final int BUF_SIZE;

    public BufferedRandomAccessFile(String string, String string2, int n) throws IOException {
        super(string, string2);
        this.invalidate();
        this.BUF_SIZE = n;
        this.buffer = new byte[this.BUF_SIZE];
    }

    public BufferedRandomAccessFile(File file, String string, int n) throws IOException {
        super(file, string);
        this.invalidate();
        this.BUF_SIZE = n;
        this.buffer = new byte[this.BUF_SIZE];
    }

    @Override
    public final int read() throws IOException {
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++] & 0xFF;
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.BUF_SIZE);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = super.getFilePointer();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buf_end - this.buf_pos;
        if (n2 <= n3) {
            System.arraycopy(this.buffer, this.buf_pos, byArray, n, n2);
            this.buf_pos += n2;
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = this.read();
            if (n4 == -1) {
                return i;
            }
            byArray[n + i] = (byte)n4;
        }
        return n2;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.real_pos;
        return l - (long)this.buf_end + (long)this.buf_pos;
    }

    @Override
    public void seek(long l) throws IOException {
        int n = (int)(this.real_pos - l);
        if (n >= 0 && n <= this.buf_end) {
            this.buf_pos = this.buf_end - n;
        } else {
            super.seek(l);
            this.invalidate();
        }
    }

    public final String getNextLine() throws IOException {
        String string = null;
        if (this.buf_end - this.buf_pos <= 0 && this.fillBuffer() < 0) {
            throw new IOException("error in filling buffer!");
        }
        int n = -1;
        for (int i = this.buf_pos; i < this.buf_end; ++i) {
            if (this.buffer[i] != 10) continue;
            n = i;
            break;
        }
        if (n < 0) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder(128);
            while ((n2 = this.read()) != -1 && n2 != 10) {
                stringBuilder.append((char)n2);
            }
            if (n2 == -1 && stringBuilder.length() == 0) {
                return null;
            }
            return stringBuilder.toString();
        }
        string = n > 0 && this.buffer[n - 1] == 13 ? new String(this.buffer, this.buf_pos, n - this.buf_pos - 1, StandardCharsets.UTF_8) : new String(this.buffer, this.buf_pos, n - this.buf_pos, StandardCharsets.UTF_8);
        this.buf_pos = n + 1;
        return string;
    }
}

