/*
 * Decompiled with CFR 0.152.
 */
package zombie.util;

import zombie.util.IntCollection;
import zombie.util.IntIterator;
import zombie.util.util.Display;
import zombie.util.util.Exceptions;

public abstract class AbstractIntCollection
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public boolean add(int n) {
        Exceptions.unsupported("add");
        return false;
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        IntIterator intIterator = intCollection.iterator();
        boolean bl = false;
        while (intIterator.hasNext()) {
            bl |= this.add(intIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intIterator.next();
            intIterator.remove();
        }
    }

    @Override
    public boolean contains(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.next() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(IntCollection intCollection) {
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(int n) {
        IntIterator intIterator = this.iterator();
        boolean bl = false;
        while (intIterator.hasNext()) {
            if (intIterator.next() != n) continue;
            intIterator.remove();
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean removeAll(IntCollection intCollection) {
        if (intCollection == null) {
            Exceptions.nullArgument("collection");
        }
        IntIterator intIterator = this.iterator();
        boolean bl = false;
        while (intIterator.hasNext()) {
            if (!intCollection.contains(intIterator.next())) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(IntCollection intCollection) {
        if (intCollection == null) {
            Exceptions.nullArgument("collection");
        }
        IntIterator intIterator = this.iterator();
        boolean bl = false;
        while (intIterator.hasNext()) {
            if (intCollection.contains(intIterator.next())) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        IntIterator intIterator = this.iterator();
        int n = 0;
        while (intIterator.hasNext()) {
            intIterator.next();
            ++n;
        }
        return n;
    }

    @Override
    public int[] toArray() {
        return this.toArray(null);
    }

    @Override
    public int[] toArray(int[] nArray) {
        int n = this.size();
        if (nArray == null || nArray.length < n) {
            nArray = new int[n];
        }
        IntIterator intIterator = this.iterator();
        int n2 = 0;
        while (intIterator.hasNext()) {
            nArray[n2] = intIterator.next();
            ++n2;
        }
        return nArray;
    }

    @Override
    public void trimToSize() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(Display.display(intIterator.next()));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

