/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.ui.UIElement;

public final class VehicleGauge
extends UIElement {
    protected int needleX;
    protected int needleY;
    protected float minAngle;
    protected float maxAngle;
    protected float value;
    protected Texture texture;
    protected int needleWidth = 45;

    public VehicleGauge(Texture texture, int n, int n2, float f, float f2) {
        this.texture = texture;
        this.needleX = n;
        this.needleY = n2;
        this.minAngle = f;
        this.maxAngle = f2;
        this.width = texture.getWidth();
        this.height = texture.getHeight();
    }

    public void setNeedleWidth(int n) {
        this.needleWidth = n;
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.render();
        this.DrawTexture(this.texture, 0.0, 0.0, 1.0);
        double d = this.minAngle < this.maxAngle ? Math.toRadians(this.minAngle + (this.maxAngle - this.minAngle) * this.value) : Math.toRadians(this.maxAngle + (this.maxAngle - this.minAngle) * (1.0f - this.value));
        double d2 = this.needleX;
        double d3 = this.needleY;
        double d4 = (double)this.needleX + (double)this.needleWidth * Math.cos(d);
        double d5 = Math.ceil((double)this.needleY + (double)this.needleWidth * Math.sin(d));
        int n = this.getAbsoluteX().intValue();
        int n2 = this.getAbsoluteY().intValue();
        SpriteRenderer.instance.renderline(null, n + (int)d2, n2 + (int)d3, n + (int)d4, n2 + (int)d5, 1.0f, 0.0f, 0.0f, 1.0f);
    }

    public void setValue(float f) {
        this.value = Math.min(f, 1.0f);
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }
}

