/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.characters.BodyDamage.BodyDamage;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.textures.Texture;
import zombie.network.GameClient;
import zombie.ui.UIElement;

public final class UI_BodyPart
extends UIElement {
    public float alpha = 1.0f;
    public final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public BodyPartType BodyPartType;
    public boolean IsFlipped = false;
    public float MaxOscilatorRate = 0.58f;
    public float MinOscilatorRate = 0.025f;
    public float Oscilator = 0.0f;
    public float OscilatorRate = 0.02f;
    public float OscilatorStep = 0.0f;
    IsoGameCharacter chr;
    boolean mouseOver = false;
    Texture scratchTex;
    Texture bandageTex;
    Texture dirtyBandageTex;
    Texture infectionTex;
    Texture deepWoundTex;
    Texture stitchTex;
    Texture biteTex;
    Texture glassTex;
    Texture boneTex;
    Texture splintTex;
    Texture burnTex;
    Texture bulletTex;

    public UI_BodyPart(BodyPartType bodyPartType, int n, int n2, String string, IsoGameCharacter isoGameCharacter, boolean bl) {
        String string2 = "male";
        if (isoGameCharacter.isFemale()) {
            string2 = "female";
        }
        this.chr = isoGameCharacter;
        this.BodyPartType = bodyPartType;
        this.scratchTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_scratch_" + string);
        this.bandageTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_bandage_" + string);
        this.dirtyBandageTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_bandagedirty_" + string);
        this.infectionTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_infection_" + string);
        this.biteTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_bite_" + string);
        this.deepWoundTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_deepwound_" + string);
        this.stitchTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_stitches_" + string);
        this.glassTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_glass_" + string);
        this.boneTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_bones_" + string);
        this.splintTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_splint_" + string);
        this.burnTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_burn_" + string);
        this.bulletTex = Texture.getSharedTexture("media/ui/BodyDamage/" + string2 + "_bullet_" + string);
        this.x = n;
        this.y = n2;
        this.width = this.scratchTex.getWidth();
        this.height = this.scratchTex.getHeight();
        this.IsFlipped = bl;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        this.mouseOver = false;
    }

    @Override
    public void render() {
        BodyDamage bodyDamage = this.chr.getBodyDamage();
        if (GameClient.bClient && this.chr instanceof IsoPlayer && !((IsoPlayer)this.chr).isLocalPlayer()) {
            bodyDamage = this.chr.getBodyDamageRemote();
        }
        if (this.infectionTex != null && !bodyDamage.IsBandaged(this.BodyPartType) && bodyDamage.getBodyPart(this.BodyPartType).getWoundInfectionLevel() > 0.0f) {
            this.DrawTexture(this.infectionTex, 0.0, 0.0, bodyDamage.getBodyPart(this.BodyPartType).getWoundInfectionLevel() / 10.0f);
        }
        if (this.bandageTex != null && bodyDamage.IsBandaged(this.BodyPartType) && bodyDamage.getBodyPart(this.BodyPartType).getBandageLife() > 0.0f) {
            this.DrawTexture(this.bandageTex, 0.0, 0.0, 1.0);
        } else if (this.dirtyBandageTex != null && bodyDamage.IsBandaged(this.BodyPartType) && bodyDamage.getBodyPart(this.BodyPartType).getBandageLife() <= 0.0f) {
            this.DrawTexture(this.dirtyBandageTex, 0.0, 0.0, 1.0);
        } else if (this.scratchTex != null && bodyDamage.IsScratched(this.BodyPartType)) {
            this.DrawTexture(this.scratchTex, 0.0, 0.0, bodyDamage.getBodyPart(this.BodyPartType).getScratchTime() / 20.0f);
        } else if (this.scratchTex != null && bodyDamage.IsCut(this.BodyPartType)) {
            this.DrawTexture(this.scratchTex, 0.0, 0.0, bodyDamage.getBodyPart(this.BodyPartType).getCutTime() / 20.0f);
        } else if (this.biteTex != null && !bodyDamage.IsBandaged(this.BodyPartType) && bodyDamage.IsBitten(this.BodyPartType) && bodyDamage.getBodyPart(this.BodyPartType).getBiteTime() >= 0.0f) {
            this.DrawTexture(this.biteTex, 0.0, 0.0, 1.0);
        } else if (this.deepWoundTex != null && bodyDamage.IsDeepWounded(this.BodyPartType)) {
            this.DrawTexture(this.deepWoundTex, 0.0, 0.0, bodyDamage.getBodyPart(this.BodyPartType).getDeepWoundTime() / 15.0f);
        } else if (this.stitchTex != null && bodyDamage.IsStitched(this.BodyPartType)) {
            this.DrawTexture(this.stitchTex, 0.0, 0.0, 1.0);
        }
        if (this.boneTex != null && bodyDamage.getBodyPart(this.BodyPartType).getFractureTime() > 0.0f && bodyDamage.getBodyPart(this.BodyPartType).getSplintFactor() == 0.0f) {
            this.DrawTexture(this.boneTex, 0.0, 0.0, 1.0);
        } else if (this.splintTex != null && bodyDamage.getBodyPart(this.BodyPartType).getSplintFactor() > 0.0f) {
            this.DrawTexture(this.splintTex, 0.0, 0.0, 1.0);
        }
        if (this.glassTex != null && bodyDamage.getBodyPart(this.BodyPartType).haveGlass() && !bodyDamage.getBodyPart(this.BodyPartType).bandaged()) {
            this.DrawTexture(this.glassTex, 0.0, 0.0, 1.0);
        }
        if (this.bulletTex != null && bodyDamage.getBodyPart(this.BodyPartType).haveBullet() && !bodyDamage.getBodyPart(this.BodyPartType).bandaged()) {
            this.DrawTexture(this.bulletTex, 0.0, 0.0, 1.0);
        }
        if (this.burnTex != null && bodyDamage.getBodyPart(this.BodyPartType).getBurnTime() > 0.0f && !bodyDamage.getBodyPart(this.BodyPartType).bandaged()) {
            this.DrawTexture(this.burnTex, 0.0, 0.0, bodyDamage.getBodyPart(this.BodyPartType).getBurnTime() / 100.0f);
        }
        super.render();
    }
}

